/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.jdbc.translators.TimeTranslator;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.UnicodeUtil;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Calendar;

public class UnicodeTimeTranslator
extends TimeTranslator {
    UnicodeTimeTranslator(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2) {
        super(n, n2, n3, n4, n5, n6, bl, bl2);
    }

    public String getString(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        String string = null;
        if (!this.isNull(sQLParamController, structuredMem)) {
            string = structuredMem.getString(this.bufpos, this.physicalLength - 1);
        }
        return string;
    }

    public Time getTime(SQLParamController sQLParamController, StructuredMem structuredMem, Calendar calendar) throws SQLException {
        Time time = null;
        if (!this.isNull(sQLParamController, structuredMem)) {
            byte[] byArray = structuredMem.getBytes(this.bufpos, this.physicalLength - 1);
            int n = (byArray[1] - 48) * 10;
            n += byArray[3] - 48;
            int n2 = (byArray[7] - 48) * 10;
            n2 += byArray[9] - 48;
            int n3 = (byArray[13] - 48) * 10;
            n3 += byArray[15] - 48;
            if (calendar == null) {
                time = new Time(n, n2, n3);
            } else {
                calendar.clear();
                calendar.set(1970, 0, 1, n, n2, n3);
                time = DBTechTranslator.CalendarUtil.getTimeFromCalendar(calendar);
            }
        }
        return time;
    }

    protected void putSpecific(DataPart dataPart, Object object) {
        dataPart.putDefineByte(1, this.bufpos - 1);
        dataPart.putUnicodeBytes((byte[])object, this.bufpos, this.physicalLength - 1);
    }

    public Object transTimeForInput(Time time, Calendar calendar) throws SQLException {
        if (time == null) {
            return null;
        }
        byte[] byArray = (byte[])super.transTimeForInput(time, calendar);
        byte[] byArray2 = UnicodeUtil.bytes2BigUnicode(byArray);
        this.checkFieldLimits(byArray2.length);
        return byArray2;
    }
}

