/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.util.Command;
import java.awt.Rectangle;

public class AlignCommand
extends Command {
    private DrawingView fView;
    private int fOp;
    public static final int LEFTS = 0;
    public static final int CENTERS = 1;
    public static final int RIGHTS = 2;
    public static final int TOPS = 3;
    public static final int MIDDLES = 4;
    public static final int BOTTOMS = 5;

    public AlignCommand(String string, DrawingView drawingView, int n) {
        super(string);
        this.fView = drawingView;
        this.fOp = n;
    }

    public boolean isExecutable() {
        return this.fView.selectionCount() > 1;
    }

    public void execute() {
        FigureEnumeration figureEnumeration = this.fView.selectionElements();
        Figure figure = figureEnumeration.nextFigure();
        Rectangle rectangle = figure.displayBox();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure2 = figureEnumeration.nextFigure();
            Rectangle rectangle2 = figure2.displayBox();
            switch (this.fOp) {
                case 0: {
                    figure2.moveBy(rectangle.x - rectangle2.x, 0);
                    break;
                }
                case 1: {
                    figure2.moveBy(rectangle.x + rectangle.width / 2 - (rectangle2.x + rectangle2.width / 2), 0);
                    break;
                }
                case 2: {
                    figure2.moveBy(rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width), 0);
                    break;
                }
                case 3: {
                    figure2.moveBy(0, rectangle.y - rectangle2.y);
                    break;
                }
                case 4: {
                    figure2.moveBy(0, rectangle.y + rectangle.height / 2 - (rectangle2.y + rectangle2.height / 2));
                    break;
                }
                case 5: {
                    figure2.moveBy(0, rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height));
                }
            }
        }
        this.fView.checkDamage();
    }
}

