/**
 * \file QRefDialog.C
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * \author Kalle Dalheimer
 * \author John Levon
 *
 * Full author contact details are available in file CREDITS.
 */

#include <config.h>

#include "QRefDialog.h"
#include "QRef.h"

#include <qcombobox.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qpushbutton.h>

namespace lyx {
namespace frontend {

QRefDialog::QRefDialog(QRef * form)
	: QRefDialogBase(0, 0, false, 0),
	form_(form)
{
	connect(okPB, SIGNAL(clicked()),
		form_, SLOT(slotOK()));
	connect(applyPB, SIGNAL(clicked()),
		form_, SLOT(slotApply()));
	connect(closePB, SIGNAL(clicked()),
		form_, SLOT(slotClose()));
}


void QRefDialog::show()
{
	QRefDialogBase::show();
	refsLB->setFocus();
}


void QRefDialog::changed_adaptor()
{
	form_->changed();
}


void QRefDialog::gotoClicked()
{
	form_->gotoRef();
}


void QRefDialog::refHighlighted(const QString & sel)
{
	if (form_->readOnly())
		return;

	int const cur_item = refsLB->currentItem();
	bool const cur_item_selected = cur_item >= 0 ?
		refsLB->isSelected(cur_item) : false;

	if (cur_item_selected)
		referenceED->setText(sel);

	if (form_->at_ref_)
		form_->gotoRef();
	gotoPB->setEnabled(true);
	if (form_->typeAllowed())
		typeCO->setEnabled(true);
	if (form_->nameAllowed())
		nameED->setEnabled(true);
}


void QRefDialog::refSelected(const QString & sel)
{
	if (form_->readOnly())
		return;

	int const cur_item = refsLB->currentItem();
	bool const cur_item_selected = cur_item >= 0 ?
		refsLB->isSelected(cur_item) : false;

	if (cur_item_selected)
		referenceED->setText(sel);
	// <enter> or double click, inserts ref and closes dialog
	form_->slotOK();
}


void QRefDialog::sortToggled(bool on)
{
	form_->sort_ = on;
	form_->redoRefs();
}


void QRefDialog::updateClicked()
{
	form_->updateRefs();
}


void QRefDialog::closeEvent(QCloseEvent * e)
{
	form_->slotWMHide();
	e->accept();
}

} // namespace frontend
} // namespace lyx
