/*
 * Copyright (c) 2008 Vincent Bernat <bernat@luffy.cx>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include "lldpd.h"

#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>

static void
ctl_callback(struct lldpd *cfg, struct lldpd_callback *callback)
{
	char *buffer;
	int n;

	if ((buffer = (char *)malloc(MAX_HMSGSIZE)) ==
	    NULL) {
		LLOG_WARN("failed to alloc reception buffer");
		return;
	}
	if ((n = recv(callback->fd, buffer,
		    MAX_HMSGSIZE, 0)) == -1) {
		LLOG_WARN("error while receiving message");
		free(buffer);
		return;
	}
	if (n > 0)
		client_handle_client(cfg, callback, buffer, n);
	else {
		close(callback->fd);
		lldpd_callback_del(cfg, callback->fd, ctl_callback);
	}
	free(buffer);
}

void
ctl_accept(struct lldpd *cfg, struct lldpd_callback *callback)
{
	int s;
	if ((s = accept(callback->fd, NULL, NULL)) == -1) {
		LLOG_WARN("unable to accept connection from socket");
		return;
	}
	if (lldpd_callback_add(cfg, s, ctl_callback, NULL) != 0) {
		LLOG_WARN("unable to add callback for new client");
		close(s);
	}
	return;
}
