#!/bin/sh
#                               -*- Mode: Sh -*- 
# kernel_grub_rm.sh --- 
# Author           : Manoj Srivastava ( srivasta@glaurung.green-gryphon.com ) 
# Created On       : Wed Jul  4 22:18:43 2001
# Created On Node  : glaurung.green-gryphon.com
# Last Modified By : Manoj Srivastava
# Last Modified On : Sat Dec 24 08:37:00 2005
# Last Machine Used: glaurung.internal.golden-gryphon.com
# Update Count     : 10
# Status           : Unknown, Use with caution!
# HISTORY          : 
# Description      : 
# 
# 

CONFIG_FILE=/etc/kernel_grub.conf
if [ -x /bin/mktemp ]; then
    TMPFILE=$(mktemp -t kpkg-postrm-grub.XXXXXX) || \
        { echo 1>&2 "Cannot create temporary file" ; exit 1; }
elif [ -x /bin/tempfile ]; then
    TMPFILE=$(tempfile -p kpkg-postrm-grub -m 0600 )|| \
        { echo 1>&2 "Cannot create temporary file" ; exit 1; };
else
    set -e
    mkdir /tmp/kpkg-postrm-grub.$$
    TMPFILE=/tmp/kpkg-postrm-grub.$$/tmpfile
    set +e
fi
trap "[ -f $TMPFILE ] && rm -f $TMPFILE; exit 1" 1 2 3 13 15


### Defaults
grub_menu_lst=/boot/grub/menu.lst
grub_kernel_partition='(hd0,0)'
grub_root_partition='(hd0,0)'             # the location of root filesystem.
# Set this to 'YES' if /boot and / are on different partitions
kernel_not_on_root_partition=''
# kernel_boot_options="hdc=ide-scsi"    # any options come here.

if [ -e $CONFIG_FILE ]; then
    . $CONFIG_FILE
fi

if [ $# -ne 2 ]; then
    echo 1>&2 "Usage: $0 version location"
    exit 2
fi

version="$1"
vmlinuz_location="$2"

# This means we have a separate boot partition
if [ "$kernel_not_on_root_partition" == 'YES' ]; then
    vmlinuz_location=`basename "$vmlinuz_location"`
    echo 1>&2 $vmlinuz_location
fi

if [ -f $grub_menu_lst ]; then
    if grep "^kernel $grub_kernel_partition.*$vmlinuz_location"  $grub_menu_lst >/dev/null 2>&1; then
	echo 1>&2 "Removing kernel entry from $grub_menu_lst"
	perl -nle "print unless /^#Autogenerated by kernel-image $version/ .. /^#End kernel-image $version/" < $grub_menu_lst > $TMPFILE
	mv -f $TMPFILE $grub_menu_lst
    else
	echo 1>&2 "Seems like this kernel (version $version) is not"
	echo 1>&2 "installed in $grub_menu_lst. Skipping."
    fi
fi

rm -f $TMPFILE
if [ -d /tmp/kpkg-postrm-grub.$$ ]; then
    rmdir /tmp/kpkg-postrm-grub.$$
fi

exit 0


version="$1"

if [ -f $grub_menu_lst ]; then
    perl -nle "print unless /^#Autogenerated by kernel-image $version/ .. /^#End kernel-image $version/" < $grub_menu_lst > $TMPFILE
    mv -f $TMPFILE $grub_menu_lst
fi


rm -f $TMPFILE
if [ -d /tmp/kpkg-postrm-grub.$$ ]; then
    rmdir /tmp/kpkg-postrm-grub.$$
fi
exit 0
