%  Copyright (C) 2003 David Roundy
%
%  This program is free software; you can redistribute it and/or modify
%  it under the terms of the GNU General Public License as published by
%  the Free Software Foundation; either version 2, or (at your option)
%  any later version.
%
%  This program is distributed in the hope that it will be useful,
%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%  GNU General Public License for more details.
%
%  You should have received a copy of the GNU General Public License
%  along with this program; if not, write to the Free Software Foundation,
%  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

\begin{code}
module PatchSet ( PatchSet,
                 ) where

import Patch
import PatchInfo

-- A PatchSet is in reverse order, plus has information about which tags
-- are clean, meaning all patches applied prior to them are in the tag
-- itself, so we can stop reading at that point.  Just to clarify, the
-- first patch in a PatchSet is the one most recently applied to the repo.
type PatchSet = [[(PatchInfo, Maybe Patch)]]
\end{code}

