// column_definition.cc
//
//  Copyright 2000,2001 Daniel Burrows
//  
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.

#include "column_definition.h"

#include <apt-pkg/error.h>
#include <apt-pkg/strutl.h>

using namespace std;

column_generator::~column_generator()
{
}

column_definition_list *parse_columns(string config, column_parser_func parser, column_type_defaults *defaults)
{
  column_definition_list *rval=new column_definition_list;

  string::size_type start=0;
  string::size_type firstbreak;
  do
    {
      firstbreak=config.find_first_of("%#", start);
      if(firstbreak!=start)
	{
	  string literal=string(config,
				start,
				firstbreak==config.npos?config.npos:firstbreak-start);

	  // Grok backslashes, sort of
	  string de_backslashified;

	  for(string::size_type i=0; i<literal.size(); ++i)
	    {
	      if(literal[i]!='\\' || i==literal.size()-1)
		de_backslashified+=literal[i];
	      else switch(literal[++i])
		{
		case 'n':
		  de_backslashified+='\n';
		  break;
		default:
		  de_backslashified+=literal[i];
		}
	    }

	  rval->push_back(column_definition(-1,
					    de_backslashified.size(),
					    false,
					    false,
					    de_backslashified));
	}

      if(firstbreak!=config.npos)
	{
	  if(config[firstbreak]=='#')
	    {
	      if(rval->empty())
		rval->push_back(column_definition(-1, 0, true, ""));
	      else
		rval->back().expand=true;

	      firstbreak++;
	    }
	  else if(config[firstbreak]=='%')
	    {
	      int width=-1;

	      firstbreak++;

	      if(firstbreak==config.size())
		{
		  _error->Error("Formatting marker with missing format code");
		  delete rval;
		  return NULL;
		}

	      if(isdigit(config[firstbreak]))
		{
		  unsigned long val;

		  string tocvt="";
		  while(isdigit(config[firstbreak]) && firstbreak<config.size()-1)
		    tocvt+=config[firstbreak++];

		  if(firstbreak==config.size())
		    {
		      _error->Error("Formatting marker with missing format code");
		      delete rval;
		      return NULL;
		    }

		  if(!StrToNum(tocvt.c_str(), val, tocvt.size()))
		    {
		      _error->Error(("Bad number in format string: '"+tocvt+"'").c_str());
		      delete rval;
		      return NULL;
		    }

		  width=val;
		}

	      if(config[firstbreak]=='%')
		rval->push_back(column_definition(-1,
						  1,
						  false,
						  false,
						  "%"));
	      else
		{
		  int itemtype=parser(config[firstbreak]);

		  if(itemtype==-1)
		    {
		      _error->Error((string("Unknown formatting code '")+config[firstbreak]+"'").c_str());
		      delete rval;
		      return NULL;
		    }

		  if(width==-1)
		    width=defaults[itemtype].width;

		  rval->push_back(column_definition(itemtype,
						    width,
						    defaults[itemtype].expand,
						    defaults[itemtype].shrink,
						    ""));
		}
	      firstbreak++;
	    }
	  start=firstbreak;
	}
    } while(firstbreak!=config.npos);
  return rval;
}

string column_generator::layout_columns(unsigned int width)
{
  layout l;

  for(column_definition_list::iterator j=columns.begin();
      j!=columns.end();
      j++)
    {
      if(j->type==-1)
	l.push_back(column(column_disposition(j->arg, 0), j->width,
			   j->expand, j->shrink));
      else
	l.push_back(column(setup_column(j->type), j->width, j->expand, j->shrink));
    }

  return columnify(l, width);
}
