// colors.h  -*-c++-*-
//
//  Copyright 1999 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  Acts as a repository for colors.

#ifndef COLORS_H
#define COLORS_H

#include <string>

// Returns the named color or the default color if no such color exists.
int get_color(const std::string name);

// Sets the named color to have the given foreground, background, and
// attributes.
void set_color(const std::string name, short fg, short bg, int attr);

bool parse_color(std::string s, short &c);

#endif
