/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.gui.WritableTableFormat;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import ca.odell.glazedlists.swing.MutableTableModelEvent;
import javax.swing.table.AbstractTableModel;

public class EventTableModel
extends AbstractTableModel
implements ListEventListener {
    private TransformedList swingThreadSource = null;
    private TableFormat tableFormat;
    private MutableTableModelEvent tableModelEvent = new MutableTableModelEvent(this);

    public EventTableModel(EventList source, TableFormat tableFormat) {
        this.swingThreadSource = GlazedListsSwing.swingThreadProxyList(source);
        this.tableFormat = tableFormat;
        this.swingThreadSource.addListEventListener(this);
    }

    public EventTableModel(EventList source, String[] propertyNames, String[] columnLabels, boolean[] writable) {
        this(source, GlazedLists.tableFormat(propertyNames, columnLabels, writable));
    }

    public TableFormat getTableFormat() {
        return this.tableFormat;
    }

    public void setTableFormat(TableFormat tableFormat) {
        this.tableFormat = tableFormat;
        this.tableModelEvent.setStructureChanged();
        this.fireTableChanged(this.tableModelEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getElementAt(int index) {
        this.swingThreadSource.getReadWriteLock().readLock().lock();
        try {
            Object object = this.swingThreadSource.get(index);
            return object;
        }
        finally {
            this.swingThreadSource.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listChanged(ListEvent listChanges) {
        this.swingThreadSource.getReadWriteLock().readLock().lock();
        try {
            while (listChanges.nextBlock()) {
                int startIndex = listChanges.getBlockStartIndex();
                int endIndex = listChanges.getBlockEndIndex();
                int changeType = listChanges.getType();
                this.tableModelEvent.setValues(startIndex, endIndex, changeType);
                this.fireTableChanged(this.tableModelEvent);
            }
        }
        finally {
            this.swingThreadSource.getReadWriteLock().readLock().unlock();
        }
    }

    public String getColumnName(int column) {
        return this.tableFormat.getColumnName(column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount() {
        this.swingThreadSource.getReadWriteLock().readLock().lock();
        try {
            int n = this.swingThreadSource.size();
            return n;
        }
        finally {
            this.swingThreadSource.getReadWriteLock().readLock().unlock();
        }
    }

    public int getColumnCount() {
        return this.tableFormat.getColumnCount();
    }

    public Class getColumnClass(int columnIndex) {
        if (this.tableFormat instanceof AdvancedTableFormat) {
            return ((AdvancedTableFormat)this.tableFormat).getColumnClass(columnIndex);
        }
        return super.getColumnClass(columnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(int row, int column) {
        this.swingThreadSource.getReadWriteLock().readLock().lock();
        try {
            Object object = this.tableFormat.getColumnValue(this.swingThreadSource.get(row), column);
            return object;
        }
        finally {
            this.swingThreadSource.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCellEditable(int row, int column) {
        if (this.tableFormat instanceof WritableTableFormat) {
            WritableTableFormat writableTableFormat = (WritableTableFormat)this.tableFormat;
            this.swingThreadSource.getReadWriteLock().readLock().lock();
            try {
                Object toEdit = this.swingThreadSource.get(row);
                boolean bl = writableTableFormat.isEditable(toEdit, column);
                return bl;
            }
            finally {
                this.swingThreadSource.getReadWriteLock().readLock().unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValueAt(Object editedValue, int row, int column) {
        if (!(this.tableFormat instanceof WritableTableFormat)) throw new UnsupportedOperationException("Unexpected set() on read-only table");
        this.swingThreadSource.getReadWriteLock().writeLock().lock();
        try {
            WritableTableFormat writableTableFormat = (WritableTableFormat)this.tableFormat;
            Object baseObject = this.swingThreadSource.get(row);
            Object updatedObject = writableTableFormat.setColumnValue(baseObject, editedValue, column);
            if (updatedObject == null) return;
            this.swingThreadSource.set(row, updatedObject);
            return;
        }
        finally {
            this.swingThreadSource.getReadWriteLock().writeLock().unlock();
        }
    }

    public void dispose() {
        this.swingThreadSource.dispose();
    }
}

