/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.pmap;

import ca.odell.glazedlists.impl.io.Bufferlo;
import ca.odell.glazedlists.impl.pmap.BlockingValueCallback;
import ca.odell.glazedlists.impl.pmap.LoadValue;
import ca.odell.glazedlists.impl.pmap.PersistentMap;
import ca.odell.glazedlists.impl.pmap.ValueCallback;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public final class Chunk {
    private PersistentMap persistentMap = null;
    private int offset = -1;
    private int[] size = new int[]{-1, -1};
    private int sizeToUse = -1;
    private boolean on = false;
    private int sequenceId = -1;
    private Object key = null;
    private Bufferlo keyBytes = null;
    private int keyBytesLength = -1;
    private int valueBytesLength = -1;
    private Bufferlo valueBytes = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Chunk(Bufferlo value) {
        this.valueBytes = value.duplicate();
        this.valueBytesLength = this.valueBytes.length();
    }

    private Chunk(PersistentMap persistentMap, int offset, boolean on, int sizeToUse, int[] size) {
        this.persistentMap = persistentMap;
        this.offset = offset;
        this.on = on;
        this.sizeToUse = sizeToUse;
        this.size = size;
    }

    public void fetchValue(ValueCallback valueCallback) {
        this.persistentMap.getNIODaemon().invokeLater(new LoadValue(this, valueCallback));
    }

    public Bufferlo getValue() {
        return BlockingValueCallback.get(this);
    }

    PersistentMap getPersistentMap() {
        return this.persistentMap;
    }

    int size() {
        return this.size[this.sizeToUse];
    }

    boolean isOn() {
        return this.on;
    }

    public int getOffset() {
        return this.offset;
    }

    Object getKey() {
        return this.key;
    }

    void setSequenceId(int sequenceId) {
        this.sequenceId = sequenceId;
    }

    int getSequenceId() {
        return this.sequenceId;
    }

    void initializeForPersistence(PersistentMap persistentMap, Object key) {
        if (this.persistentMap != null) {
            throw new IllegalStateException("doubly-initialized chunk");
        }
        this.persistentMap = persistentMap;
        this.key = key;
        try {
            this.keyBytes = new Bufferlo();
            persistentMap.getKeyCoder().encode(key, this.keyBytes.getOutputStream());
            this.keyBytesLength = this.keyBytes.length();
        }
        catch (IOException e) {
            persistentMap.fail(e, "Unexpected encoding exception");
        }
    }

    int bytesRequired() {
        int required = 0;
        required += 4;
        required += 4;
        required += 4;
        required += 4;
        required += 4;
        required += 4;
        required += 4;
        required += this.keyBytesLength;
        return required += this.valueBytesLength;
    }

    void allocateAsNew(int offset, int size) throws IOException {
        this.offset = offset;
        this.sizeToUse = 0;
        this.size[0] = size;
        this.size[1] = size;
        this.on = false;
        FileChannel fileChannel = this.persistentMap.getFileChannel();
        Bufferlo sizeData = new Bufferlo();
        DataOutputStream sizeDataOut = new DataOutputStream(sizeData.getOutputStream());
        sizeDataOut.writeInt(0);
        sizeDataOut.writeInt(this.sizeToUse);
        sizeDataOut.writeInt(this.size[0]);
        sizeDataOut.writeInt(this.size[1]);
        sizeData.writeToChannel(fileChannel.position(offset));
        fileChannel.force(false);
    }

    void delete() throws IOException {
        if (!$assertionsDisabled && this.offset == -1) {
            throw new AssertionError();
        }
        if (!this.on) {
            return;
        }
        this.on = false;
        FileChannel fileChannel = this.persistentMap.getFileChannel();
        Bufferlo sizeData = new Bufferlo();
        DataOutputStream sizeDataOut = new DataOutputStream(sizeData.getOutputStream());
        sizeDataOut.writeInt(0);
        sizeData.writeToChannel(fileChannel.position(this.offset));
        fileChannel.force(false);
    }

    static Chunk readChunk(PersistentMap persistentMap) throws IOException {
        FileChannel fileChannel = persistentMap.getFileChannel();
        Bufferlo sizeData = new Bufferlo();
        DataInputStream dataIn = new DataInputStream(sizeData.getInputStream());
        int offset = (int)fileChannel.position();
        int bytesRequired = 16;
        int read = sizeData.readFromChannel(fileChannel, bytesRequired);
        if (read < 0) {
            return null;
        }
        if (read < bytesRequired) {
            throw new IOException("Insufficent bytes available");
        }
        int on = dataIn.readInt();
        int sizeToUse = dataIn.readInt();
        int[] size = new int[]{-1, -1};
        size[0] = dataIn.readInt();
        size[1] = dataIn.readInt();
        if (on != 0 && on != 1) {
            throw new IOException("Unexpected on value: " + on);
        }
        if (sizeToUse != 0 && sizeToUse != 1) {
            throw new IOException("Unexpected size to use value " + sizeToUse);
        }
        if (size[sizeToUse] < 0) {
            throw new IOException("Unexpected size: " + size[sizeToUse]);
        }
        Chunk chunk = new Chunk(persistentMap, offset, on == 1, sizeToUse, size);
        if (chunk.on) {
            chunk.readHeader();
        }
        fileChannel.position(offset + size[sizeToUse]);
        return chunk;
    }

    void writeData() throws IOException {
        if (!$assertionsDisabled && this.offset == -1) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.on) {
            throw new AssertionError();
        }
        FileChannel fileChannel = this.persistentMap.getFileChannel();
        Bufferlo chunkData = new Bufferlo();
        DataOutputStream chunkDataOut = new DataOutputStream(chunkData.getOutputStream());
        chunkDataOut.writeInt(this.sequenceId);
        chunkDataOut.writeInt(this.keyBytesLength);
        chunkDataOut.writeInt(this.valueBytesLength);
        chunkData.append(this.keyBytes);
        chunkData.append(this.valueBytes);
        chunkData.writeToChannel(fileChannel.position(this.offset + 16));
        fileChannel.force(false);
        this.on = true;
        chunkDataOut.writeInt(1);
        chunkData.writeToChannel(fileChannel.position(this.offset));
        fileChannel.force(false);
        this.keyBytes = null;
        this.valueBytes = null;
    }

    private void readHeader() throws IOException {
        if (!$assertionsDisabled && this.offset == -1) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.size() == -1) {
            throw new AssertionError();
        }
        FileChannel fileChannel = this.persistentMap.getFileChannel();
        Bufferlo chunkAsBytes = new Bufferlo();
        DataInputStream dataIn = new DataInputStream(chunkAsBytes.getInputStream());
        int bytesRequired = this.size();
        int read = chunkAsBytes.readFromChannel(fileChannel.position(this.offset), bytesRequired);
        if (read < bytesRequired) {
            throw new IOException("Expected " + bytesRequired + " but found " + read + " bytes");
        }
        dataIn.readInt();
        dataIn.readInt();
        dataIn.readInt();
        dataIn.readInt();
        this.sequenceId = dataIn.readInt();
        this.keyBytesLength = dataIn.readInt();
        this.valueBytesLength = dataIn.readInt();
        this.keyBytes = chunkAsBytes.consume(this.keyBytesLength);
        chunkAsBytes.clear();
        this.key = this.persistentMap.getKeyCoder().decode(this.keyBytes.getInputStream());
    }

    Bufferlo readValue() throws IOException {
        if (!$assertionsDisabled && this.offset == -1) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.size() == -1) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.valueBytesLength == -1) {
            throw new AssertionError();
        }
        FileChannel fileChannel = this.persistentMap.getFileChannel();
        Bufferlo valueBytes = new Bufferlo();
        int valueLocation = this.offset;
        valueLocation += 4;
        valueLocation += 4;
        valueLocation += 4;
        valueLocation += 4;
        valueLocation += 4;
        valueLocation += 4;
        valueLocation += 4;
        int read = valueBytes.readFromChannel(fileChannel.position(valueLocation += this.keyBytesLength), this.valueBytesLength);
        if (read < this.valueBytesLength) {
            throw new IOException("Expected " + this.valueBytesLength + " but found " + read + " bytes");
        }
        return valueBytes;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("<chunk      offset=\"").append(this.offset).append("\"");
        result.append("\n              size=\"").append(this.size()).append("\"");
        result.append("\n                on=\"").append(this.isOn()).append("\"");
        result.append("\n       sequence_id=\"").append(this.sequenceId).append("\"");
        result.append("\n               key=\"").append(this.key).append("\"");
        result.append("\n    keyBytesLength=\"").append(this.keyBytesLength).append("\"");
        result.append("\n  valueBytesLength=\"").append(this.valueBytesLength).append("\">");
        return result.toString();
    }

    static {
        $assertionsDisabled = !Chunk.class.desiredAssertionStatus();
    }
}

