/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.CollectionList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.ThresholdList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.impl.Diff;
import ca.odell.glazedlists.impl.ListCollectionListModel;
import ca.odell.glazedlists.impl.ReadOnlyList;
import ca.odell.glazedlists.impl.SyncListener;
import ca.odell.glazedlists.impl.ThreadSafeList;
import ca.odell.glazedlists.impl.WeakReferenceProxy;
import ca.odell.glazedlists.impl.beans.BeanProperty;
import ca.odell.glazedlists.impl.beans.BeanTableFormat;
import ca.odell.glazedlists.impl.beans.BeanTextFilterator;
import ca.odell.glazedlists.impl.beans.BeanThresholdEvaluator;
import ca.odell.glazedlists.impl.beans.JavaBeanEventListConnector;
import ca.odell.glazedlists.impl.filter.StringTextFilterator;
import ca.odell.glazedlists.impl.matchers.BeanPropertyMatcher;
import ca.odell.glazedlists.impl.matchers.FixedMatcherEditor;
import ca.odell.glazedlists.impl.sort.BeanPropertyComparator;
import ca.odell.glazedlists.impl.sort.BooleanComparator;
import ca.odell.glazedlists.impl.sort.ComparableComparator;
import ca.odell.glazedlists.impl.sort.ComparatorChain;
import ca.odell.glazedlists.impl.sort.ReverseComparator;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.MatcherEditor;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public final class GlazedLists {
    private static Comparator booleanComparator = null;
    private static Comparator comparableComparator = null;
    private static Comparator reversedComparable = null;
    private static StringTextFilterator stringTextFilterator = null;

    private GlazedLists() {
        throw new UnsupportedOperationException();
    }

    public static void replaceAll(EventList target, List source, boolean updates) {
        Diff.replaceAll(target, source, updates);
    }

    public static void replaceAll(EventList target, List source, boolean updates, Comparator comparator) {
        Diff.replaceAll(target, source, updates, comparator);
    }

    public static Comparator beanPropertyComparator(Class className, String property) {
        return GlazedLists.beanPropertyComparator(className, property, GlazedLists.comparableComparator());
    }

    public static Comparator beanPropertyComparator(Class className, String property, Comparator propertyComparator) {
        return new BeanPropertyComparator(className, property, propertyComparator);
    }

    public static Comparator booleanComparator() {
        if (booleanComparator == null) {
            booleanComparator = new BooleanComparator();
        }
        return booleanComparator;
    }

    public static Comparator caseInsensitiveComparator() {
        return String.CASE_INSENSITIVE_ORDER;
    }

    public static Comparator chainComparators(List comparators) {
        return new ComparatorChain(comparators);
    }

    public static Comparator comparableComparator() {
        if (comparableComparator == null) {
            comparableComparator = new ComparableComparator();
        }
        return comparableComparator;
    }

    public static Comparator reverseComparator() {
        if (reversedComparable == null) {
            reversedComparable = GlazedLists.reverseComparator(GlazedLists.comparableComparator());
        }
        return reversedComparable;
    }

    public static Comparator reverseComparator(Comparator forward) {
        return new ReverseComparator(forward);
    }

    public static TableFormat tableFormat(String[] propertyNames, String[] columnLabels) {
        return new BeanTableFormat(null, propertyNames, columnLabels);
    }

    public static TableFormat tableFormat(Class baseClass, String[] propertyNames, String[] columnLabels) {
        return new BeanTableFormat(baseClass, propertyNames, columnLabels);
    }

    public static TableFormat tableFormat(String[] propertyNames, String[] columnLabels, boolean[] editable) {
        return new BeanTableFormat(null, propertyNames, columnLabels, editable);
    }

    public static TableFormat tableFormat(Class baseClass, String[] propertyNames, String[] columnLabels, boolean[] editable) {
        return new BeanTableFormat(baseClass, propertyNames, columnLabels, editable);
    }

    public static TextFilterator textFilterator(String[] propertyNames) {
        return new BeanTextFilterator(propertyNames);
    }

    public static TextFilterator toStringTextFilterator() {
        if (stringTextFilterator == null) {
            stringTextFilterator = new StringTextFilterator();
        }
        return stringTextFilterator;
    }

    public static ThresholdList.Evaluator thresholdEvaluator(String propertyName) {
        return new BeanThresholdEvaluator(propertyName);
    }

    public static CollectionList.Model listCollectionListModel() {
        return new ListCollectionListModel();
    }

    public static EventList eventList(Collection contents) {
        BasicEventList result = new BasicEventList();
        if (contents != null) {
            result.addAll(contents);
        }
        return result;
    }

    public static TransformedList readOnlyList(EventList source) {
        return new ReadOnlyList(source);
    }

    public static TransformedList threadSafeList(EventList source) {
        return new ThreadSafeList(source);
    }

    public static ListEventListener weakReferenceProxy(EventList source, ListEventListener target) {
        return new WeakReferenceProxy(source, target);
    }

    public static ObservableElementList.Connector beanConnector(Class beanClass) {
        return new JavaBeanEventListConnector(beanClass);
    }

    public static ObservableElementList.Connector beanConnector(Class beanClass, String addListener, String removeListener) {
        return new JavaBeanEventListConnector(beanClass, addListener, removeListener);
    }

    public static Matcher beanPropertyMatcher(Class beanClass, String propertyName, Object value) {
        return new BeanPropertyMatcher(new BeanProperty(beanClass, propertyName, true, false), value);
    }

    public static MatcherEditor fixedMatcherEditor(Matcher matcher) {
        return new FixedMatcherEditor(matcher);
    }

    public static ListEventListener syncEventListToList(EventList source, List target) {
        return new SyncListener(source, target);
    }
}

