/* nova_defs.h: NOVA simulator definitions 

   Copyright (c) 1993-1997,
   Robert M Supnik, Digital Equipment Corporation
   Commercial use prohibited

   16-Mar-95	RMS	Added dynamic memory size
   06-Dec-95	RMS	Added magnetic tape

   The author gratefully acknowledges the help of Tom West, Diana
   Engelbart, and Carl Friend in resolving questions about the NOVA
*/

#include "sim_defs.h"					/* simulator defns */

/* Memory */

#define MAXMEMSIZE	32768				/* max memory size */
#define MEMSIZE		(cpu_unit.capac)		/* actual memory size */
#define ADDRMASK	(MAXMEMSIZE - 1)		/* address mask */
#define MEM_ADDR_OK(x)	(x < MEMSIZE)

/* Simulator stop codes */

#define STOP_RSRV	1				/* must be 1 */
#define STOP_HALT	2				/* HALT */
#define STOP_IBKPT	3				/* breakpoint */
#define STOP_IND	4				/* indirect loop */
#define STOP_IND_INT	5				/* ind loop, intr */
#define STOP_RBKPT	6				/* read breakpoint */
#define STOP_WBKPT	7				/* write breakpoint */

/* IOT return codes */

#define IOT_V_REASON	16				/* set reason */

/* IOT fields */

#define ioNIO		0				/* opcode field */
#define ioDIA		1
#define ioDOA		2
#define ioDIB		3
#define ioDOB		4
#define ioDIC		5
#define ioDOC		6
#define ioSKP		7

#define iopN		0				/* pulse field */
#define iopS		1
#define iopC		2
#define iopP		3

/* Range of implemented device numbers */

#define DEV_LOW		010				/* lowest intr dev */
#define DEV_HIGH	033				/* highest intr dev */
#define DEV_MDV		001				/* multiply/divide */
#define DEV_CPU		077				/* CPU control */

#define IORETURN(f,v)	((f)? (v): SCPE_OK)		/* stop on error */

/* I/O structure

   The NOVA I/O structure is tied together by dev_table, indexed by
   the device number.  Each entry in dev_table consists of

	mask		device mask for busy, done (simulator representation)
	pi		pi disable bit (hardware representation)
	routine		IOT action routine
*/

struct ndev {
	int	mask;					/* done/busy mask */
	int	pi;					/* assigned pi bit */
	int	(*routine)();				/* dispatch routine */
	};

/* Device flags (simulator representation)

   Priority (for INTA) runs from low numbers to high
*/

#define INT_V_DKP	3				/* moving head disk */
#define INT_V_DSK	4				/* fixed head disk */
#define INT_V_MTA	5				/* magnetic tape */
#define INT_V_LPT	6				/* line printer */
#define INT_V_CLK	7				/* clock */
#define INT_V_PTR	8				/* paper tape reader */
#define INT_V_PTP	9				/* paper tape punch */
#define INT_V_TTI	10				/* keyboard */
#define INT_V_TTO	11				/* terminal */
#define INT_V_NO_ION_PENDING 13				/* ion delay */
#define INT_V_ION 	14				/* interrupts on */

#define INT_DKP		(1 << INT_V_DKP)
#define INT_DSK		(1 << INT_V_DSK)
#define INT_MTA		(1 << INT_V_MTA)
#define INT_LPT		(1 << INT_V_LPT)
#define INT_CLK		(1 << INT_V_CLK)
#define INT_PTR		(1 << INT_V_PTR)
#define INT_PTP		(1 << INT_V_PTP)
#define INT_TTI		(1 << INT_V_TTI)
#define INT_TTO		(1 << INT_V_TTO)
#define INT_NO_ION_PENDING (1 << INT_V_NO_ION_PENDING)
#define INT_ION		(1 << INT_V_ION)
#define INT_DEV		((1 << INT_V_NO_ION_PENDING) - 1) /* device ints */
#define INT_PENDING	INT_ION+INT_NO_ION_PENDING

/* PI disable bits */

#define PI_DKP		0000400
#define PI_DSK		0000100
#define PI_MTA		0000040
#define PI_LPT		0000010
#define PI_CLK		0000004
#define PI_PTR		0000020
#define PI_PTP		0000004
#define PI_TTI		0000002
#define PI_TTO		0000001
/* #define PI_CDR	0000040	*/
/* #define PI_DCM	0100000	*/
/* #define PI_CAS	0000040	*/
/* #define PI_PLT	0000010	*/
/* #define PI_ADCV	0000002	*/
