// File:        XmlMDataStd.cxx
// Created:     Mon Aug 27 17:33:16 2001
// Author:      Alexander GRIGORIEV
// Copyright:   Open Cascade 2001
// History:

#include <XmlMDataStd.ixx>

#include <XmlMDataStd_ShapeDriver.hxx>
#include <XmlMDataStd_DirectoryDriver.hxx>
#include <XmlMDataStd_UAttributeDriver.hxx>
#include <XmlMDataStd_IntegerArrayDriver.hxx>
#include <XmlMDataStd_RealArrayDriver.hxx>
#include <XmlMDataStd_ExtStringArrayDriver.hxx>
#include <XmlMDataStd_NameDriver.hxx>
#include <XmlMDataStd_CommentDriver.hxx>
#include <XmlMDataStd_IntegerDriver.hxx>
#include <XmlMDataStd_PointDriver.hxx>
#include <XmlMDataStd_AxisDriver.hxx>
#include <XmlMDataStd_RealDriver.hxx>
#include <XmlMDataStd_PlaneDriver.hxx>
#include <XmlMDataStd_GeometryDriver.hxx>
#include <XmlMDataStd_ConstraintDriver.hxx>
#include <XmlMDataStd_PlacementDriver.hxx>
#include <XmlMDataStd_PatternStdDriver.hxx>
#include <XmlMDataStd_VariableDriver.hxx>
#include <XmlMDataStd_ExpressionDriver.hxx>
#include <XmlMDataStd_RelationDriver.hxx>
#include <XmlMDataStd_NoteBookDriver.hxx>
#include <XmlMDataStd_TreeNodeDriver.hxx>

//=======================================================================
//function : AddDrivers
//purpose  : 
//=======================================================================
void XmlMDataStd::AddDrivers (const Handle(XmlMDF_ADriverTable)& aDriverTable,
                              const Handle(CDM_MessageDriver)&   anMsgDrv)
{
  aDriverTable-> AddDriver (new XmlMDataStd_ShapeDriver         (anMsgDrv));
  aDriverTable-> AddDriver (new XmlMDataStd_DirectoryDriver     (anMsgDrv));
  aDriverTable-> AddDriver (new XmlMDataStd_IntegerArrayDriver  (anMsgDrv));
  aDriverTable-> AddDriver (new XmlMDataStd_RealArrayDriver     (anMsgDrv));
  aDriverTable-> AddDriver (new XmlMDataStd_UAttributeDriver    (anMsgDrv));
  aDriverTable-> AddDriver (new XmlMDataStd_NameDriver          (anMsgDrv));
  aDriverTable-> AddDriver (new XmlMDataStd_CommentDriver       (anMsgDrv));
  aDriverTable-> AddDriver (new XmlMDataStd_IntegerDriver       (anMsgDrv));
  aDriverTable-> AddDriver (new XmlMDataStd_RealDriver          (anMsgDrv));
  aDriverTable-> AddDriver (new XmlMDataStd_PointDriver         (anMsgDrv));
  aDriverTable-> AddDriver (new XmlMDataStd_AxisDriver          (anMsgDrv));
  aDriverTable-> AddDriver (new XmlMDataStd_PlaneDriver         (anMsgDrv));
  aDriverTable-> AddDriver (new XmlMDataStd_GeometryDriver      (anMsgDrv));
  aDriverTable-> AddDriver (new XmlMDataStd_ConstraintDriver    (anMsgDrv));
  aDriverTable-> AddDriver (new XmlMDataStd_PlacementDriver     (anMsgDrv));
  aDriverTable-> AddDriver (new XmlMDataStd_PatternStdDriver    (anMsgDrv));
  aDriverTable-> AddDriver (new XmlMDataStd_VariableDriver      (anMsgDrv));
  aDriverTable-> AddDriver (new XmlMDataStd_ExpressionDriver    (anMsgDrv));
  aDriverTable-> AddDriver (new XmlMDataStd_RelationDriver      (anMsgDrv));
  aDriverTable-> AddDriver (new XmlMDataStd_NoteBookDriver      (anMsgDrv));
  aDriverTable-> AddDriver (new XmlMDataStd_TreeNodeDriver      (anMsgDrv));
  aDriverTable-> AddDriver (new XmlMDataStd_ExtStringArrayDriver(anMsgDrv));
}
