/* ACHDIM.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"

/* Subroutine */ int machdim_(chaine, length, chaine_len)
char *chaine;
integer *length;
ftnlen chaine_len;
{
    /* Builtin functions */
    integer __i__len(), __s__cmp();

    /* Local variables */
    static integer ideb, im;



/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ***********************************************************************
 */

/*     FONCTION : */
/*     ---------- */
/*   RECHERCHE LA LONGUEUR UTILE D'UNE CHAINE DE CARACTERES */
/*   C'EST A DIRE LA LONGUEUR AU DELA DE LAQUELLE IL NE RESTE QUE */
/*   DES CARACTERES BLANCS OU DES CARACTERES DE CONTROLE */
/*   ( CODE AMSCII <= 31 ) */

/*     MOTS CLES : */
/*     ----------- */
/*   MANIPULATIONS, CARACTERE, CHAINE, LONGUEUR-UTILE */

/*     ARGUMENTS D'ENTREE : */
/*     -------------------- */
/*        CHAINE : CHAINE DE CARACTERES */

/*     ARGUMENTS DE SORTIE : */
/*     --------------------- */
/*        LENGTH : LONGUEUR UTILE (=0 SI CHAINE VIDE) */

/*     COMMONS UTILISES : */
/*     ------------------ */
/*        NEANT */

/*     REFERENCES APPELEES : */
/*     --------------------- */
/*        NEANT */

/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */

/*      D'apres GERARD DURAND, le 22-03-88 : (Extrait de QCHDIM) */

/*      La methode est basee sur la restriction de l'intervalle par une */
/*      methode de dichotomie et par le fait que le test d'inferiorite */
/*      par rapport au blanc d'une sous-chaine est plus rapide qu'une */
/*      boucle caractere par caractere sur la longueur de la sous chaine. 
*/
/*      Les tests effectues sur 6460 lignes FORTRAN de 80 caracteres */
/*      donnent 0.48s par cette methode contre 0.59s par la methode */
/*      classique sur VAX 8700. */

/* $    HISTORIQUE DES MODIFICATIONS : */
/*     ------------------------------ */
/*     25-01-93 : JMB ; NETTOYAGE DE MACHDIM */
/*      22-12-89 : DGZ ; CORRECTION DE L'EN-TETE */
/*        27-05-88 : DGZ ; REFONTE AVEC UTILISATION DE L'ALGORITHME DE GD 
*/
/* > */
/* ***********************************************************************
 */


/* ****** Initialisation ** */

/* **** AJOUT DECLARATION AUTO ******* */
/* **** FIN DECLARATION AUTO ********* */

    *length = __i__len(chaine, chaine_len);
    if (*length == 0) {
	goto L9999;
    }
    ideb = 1;

/* ****** Point de synchronisation - Tests de fin ** */

L100:

    if (*(unsigned char *)&chaine[*length - 1] > ' ') {
	goto L9999;
    }
    --(*length);
    if (*length == 0) {
	goto L9999;
    }

/* ****** Calcul point milieu - Restriction intervalle ** */

    im = (ideb + *length) / 2;
    if (__s__cmp(chaine + (im - 1), " ", *length - (im - 1), 1L) > 0) {
	ideb = im;
    } else {
	*length = im;
    }

/* ****** Retour synchronisation ** */

    goto L100;

/* ****** Fin du sous-programme ** */

L9999:

 return 0   ;

} /* machdim_ */

