// File:	StepToGeom_MakeToroidalSurface.cxx
// Created:	Mon Jul  5 11:06:16 1993
// Author:	Martine LANGLOIS
//		<mla@mastox>

#include <StepToGeom_MakeToroidalSurface.ixx>
#include <StepGeom_ToroidalSurface.hxx>
#include <StepGeom_Axis2Placement3d.hxx>
#include <StepToGeom_MakeAxis2Placement.hxx>
#include <Geom_Axis2Placement.hxx>
#include <gp_Ax2.hxx>
#include <Geom_ToroidalSurface.hxx>
#include <StdFail_NotDone.hxx>
#include <UnitsMethods.hxx>

//=============================================================================
// Creation d' une ToroidalSurface de Geom a partir d' une 
// ToroidalSurface de Step
//=============================================================================

StepToGeom_MakeToroidalSurface::StepToGeom_MakeToroidalSurface
  ( const Handle(StepGeom_ToroidalSurface)& S)
{
  Standard_Real                     R1, R2;
  Handle(StepGeom_Axis2Placement3d) A;
  Handle(Geom_Axis2Placement)       A1;
  gp_Ax2                            A2;

  R1  = S->MajorRadius() * UnitsMethods::LengthFactor();
  R2  = S->MinorRadius() * UnitsMethods::LengthFactor();
  
  if( R1 < 0) 
    R1*=-1;
  if( R2 < 0) 
    R2*=-1;
  
  A   = S->Position();
  StepToGeom_MakeAxis2Placement MkAxis2(A);
  A1  = MkAxis2.Value();
  A2  = A1->Ax2();
  theToroidalSurface = new Geom_ToroidalSurface(A2, R1, R2);
  done = Standard_True;
}

//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom_ToroidalSurface) &
      StepToGeom_MakeToroidalSurface::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theToroidalSurface;
}
