// File:	StepToGeom_MakeCurve.cxx
// Created:	Fri Jul  2 17:07:46 1993
// Author:	Martine LANGLOIS
//		<mla@mastox>
//:n7 abv 16.02.99: S4132: adding translation of curve_replica
//:o2 abv 17.02.99: S4132: adding translation of offset_curve_3d
//:o5 abv 17.02.99: bm4_sd_seal_c.stp #58720: translate surface_curve (3d only)
//:p0 abv 19.02.99: management of 'done' flag improved

#include <StepToGeom_MakeCurve.ixx>

#include <StdFail_NotDone.hxx>
#include <Geom_OffsetCurve.hxx>
#include <Geom_Direction.hxx>

#include <StepGeom_Curve.hxx>
#include <StepGeom_TrimmedCurve.hxx>
#include <StepGeom_Line.hxx>
#include <StepGeom_Conic.hxx>
#include <StepGeom_BoundedCurve.hxx>
#include <StepGeom_CartesianTransformationOperator3d.hxx>
#include <StepGeom_CurveReplica.hxx>
#include <StepGeom_OffsetCurve3d.hxx>
#include <StepGeom_SurfaceCurve.hxx>

#include <StepToGeom_MakeDirection.hxx>
#include <StepToGeom_MakeTrimmedCurve.hxx>
#include <StepToGeom_MakeCurve.hxx>
#include <StepToGeom_MakeLine.hxx>
#include <StepToGeom_MakeConic.hxx>
#include <StepToGeom_MakeBoundedCurve.hxx>
#include <StepToGeom_MakeTransformation3d.hxx>

//=============================================================================
// Creation d' une Curve de Geom a partir d' une Curve de Step
//=============================================================================

StepToGeom_MakeCurve::StepToGeom_MakeCurve ( const Handle(StepGeom_Curve)& C)
{
  done = Standard_False;
  if (C->IsKind(STANDARD_TYPE(StepGeom_Line))) {
    Handle(StepGeom_Line) L = Handle(StepGeom_Line)::DownCast(C);
    StepToGeom_MakeLine MkLine(L);
    if ( MkLine.IsDone() ) theCurve = MkLine.Value();
  }
  else   if (C->IsKind(STANDARD_TYPE(StepGeom_TrimmedCurve))) {
    Handle(StepGeom_TrimmedCurve) L = Handle(StepGeom_TrimmedCurve)::DownCast(C);
    StepToGeom_MakeTrimmedCurve MkTrimmed(L); 
    if ( MkTrimmed.IsDone() ) theCurve = MkTrimmed.Value();
  }
  else if (C->IsKind(STANDARD_TYPE(StepGeom_Conic))) {
    Handle(StepGeom_Conic) L = Handle(StepGeom_Conic)::DownCast(C);
    StepToGeom_MakeConic MkConic(L);
    if ( MkConic.IsDone() ) theCurve = MkConic.Value();
  }
  else if (C->IsKind(STANDARD_TYPE(StepGeom_BoundedCurve))) {
    Handle(StepGeom_BoundedCurve) L = Handle(StepGeom_BoundedCurve)::DownCast(C);
    StepToGeom_MakeBoundedCurve MkBoundedC(L);
    if ( MkBoundedC.IsDone() ) theCurve = MkBoundedC.Value();
  }
  else if (C->IsKind(STANDARD_TYPE(StepGeom_CurveReplica))) { //:n7 abv 16 Feb 99
    Handle(StepGeom_CurveReplica) CR = Handle(StepGeom_CurveReplica)::DownCast(C);
    Handle(StepGeom_Curve) PC = CR->ParentCurve();
    Handle(StepGeom_CartesianTransformationOperator3d) T = 
      Handle(StepGeom_CartesianTransformationOperator3d)::DownCast(CR->Transformation());
    // protect against cyclic references and wrong type of cartop
    if ( ! T.IsNull() && PC != C ) {
      StepToGeom_MakeCurve MkCurve(PC);
      if ( MkCurve.IsDone() ) {
	theCurve = MkCurve.Value();
	StepToGeom_MakeTransformation3d MkT ( T );
	theCurve->Transform ( MkT.Value() );
      }
    }
  }
  else if (C->IsKind(STANDARD_TYPE(StepGeom_OffsetCurve3d))) { //:o2 abv 17 Feb 99
    Handle(StepGeom_OffsetCurve3d) OC = Handle(StepGeom_OffsetCurve3d)::DownCast(C);
    Handle(StepGeom_Curve) BC = OC->BasisCurve();
    if ( BC != C ) { // protect against loop
      StepToGeom_MakeCurve MkBC ( BC );
      StepToGeom_MakeDirection MkDir ( OC->RefDirection() );
      if ( MkBC.IsDone() && MkDir.IsDone() ) {
	gp_Dir dir = MkDir.Value()->Dir();
	theCurve = new Geom_OffsetCurve ( MkBC.Value(), -OC->Distance(), dir );
      }
    }
  }
  else if (C->IsKind(STANDARD_TYPE(StepGeom_SurfaceCurve))) { //:o5 abv 17 Feb 99
    Handle(StepGeom_SurfaceCurve) SC = Handle(StepGeom_SurfaceCurve)::DownCast(C);
    StepToGeom_MakeCurve MkSC ( SC->Curve3d() );
    if ( MkSC.IsDone() ) theCurve = MkSC.Value();
  }
  done = ! theCurve.IsNull();
}	 

//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom_Curve) &
      StepToGeom_MakeCurve::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theCurve;
}
