// File:	StepToGeom_MakeCircle2d.cxx
// Created:	Fri Aug 26 11:45:44 1994
// Author:	Frederic MAUPAS
//		<fma@minox>

#include <StepToGeom_MakeCircle2d.ixx>
#include <StepGeom_Circle.hxx>
#include <StepGeom_Axis2Placement2d.hxx>
#include <Geom2d_AxisPlacement.hxx>
#include <StepToGeom_MakeAxisPlacement.hxx>
#include <gp_Ax2.hxx>
#include <gp_Ax22d.hxx>

#include <StdFail_NotDone.hxx>

//=============================================================================
// Creation d' un Circle de Geom2d a partir d' un Circle de Step
//=============================================================================

StepToGeom_MakeCircle2d::StepToGeom_MakeCircle2d
  ( const Handle(StepGeom_Circle)& C)
{
  StepGeom_Axis2Placement           AxisSelect;
  Handle(StepGeom_Axis2Placement2d) A;
  Handle(Geom2d_AxisPlacement)   A1;
  gp_Ax22d                       A2;
  Standard_Real                  R;

  AxisSelect  = C->Position();
  if (AxisSelect.CaseNum(AxisSelect.Value()) == 1) {
    StepToGeom_MakeAxisPlacement
      MkAxis(Handle(StepGeom_Axis2Placement2d)::DownCast(AxisSelect.Value()));
    A1 = MkAxis.Value();
    A2 = gp_Ax22d( A1->Ax2d() );
    R  = C->Radius(); 
    theCircle = new Geom2d_Circle(A2, R);
    done = Standard_True;
  }
  else {
    done= Standard_False;
  }
}

//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom2d_Circle) &
      StepToGeom_MakeCircle2d::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theCircle;
}
