// File:	StepToGeom_MakeAxisPlacemant.cxx
// Created:	Fri Aug 26 12:11:31 1994
// Author:	Frederic MAUPAS
//		<fma@minox>
// sln 23.10.2001. CTS23496: If problems with creation of direction occur default direction is used

#include <StepToGeom_MakeAxisPlacement.ixx>
#include <StepToGeom_MakeCartesianPoint2d.hxx>
#include <StepToGeom_MakeDirection2d.hxx>
#include <Geom2d_CartesianPoint.hxx>
#include <Geom2d_Direction.hxx>
#include <gp_Pnt2d.hxx>
#include <gp_Dir2d.hxx>
#include <StdFail_NotDone.hxx>

//=============================================================================
// Creation d' un AxisPlacement de Geom2d a partir d' un axis2_placement_3d
// de Step
//=============================================================================

StepToGeom_MakeAxisPlacement::StepToGeom_MakeAxisPlacement
  ( const Handle(StepGeom_Axis2Placement2d)& A)
{
  Handle(StepGeom_CartesianPoint)  P1;
  Handle(StepGeom_Direction)       V2;
  Handle(Geom2d_CartesianPoint) P;
  Handle(Geom2d_Direction)      Vx;
  gp_Pnt2d                      Pgp;
  gp_Dir2d                      Vxgp;

  P1 = A->Location();
  StepToGeom_MakeCartesianPoint2d MkPoint2d(P1);
  P = MkPoint2d.Value();
  Pgp = P->Pnt2d();

  // sln 23.10.2001. CTS23496: If problems with creation of direction occur default direction is used
  Standard_Boolean isDefaultDirectionUsed = Standard_True;
  if (A->HasRefDirection()) {
    V2 = A->RefDirection();
    StepToGeom_MakeDirection2d MkDir2d(V2);
    if(MkDir2d.IsDone()) {
      Vx = MkDir2d.Value();
      Vxgp = Vx->Dir2d();
      isDefaultDirectionUsed = Standard_False;
    }
  }
  if(isDefaultDirectionUsed) 
    Vxgp = gp_Dir2d(1.,0.);

  theAxisPlacement = new Geom2d_AxisPlacement(Pgp,Vxgp);
  done = Standard_True;
}

//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom2d_AxisPlacement) &
      StepToGeom_MakeAxisPlacement::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theAxisPlacement;
}
