/* MLIEST.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"
#include <Data_Data.h>
/* Common Block Declarations */

/*extern __Data_API struct {*/
extern struct {
    integer nbr[1001];
} minombr_;

#define minombr_1 minombr_

/* Subroutine */ int mmliest_(ndimen, nbrpnt, nbcntr, tabpnt, typcnt, tabcnt, 
	tabpar, distot, cuvtot, dcvtot, iercod)
integer *ndimen, *nbrpnt, *nbcntr;
doublereal *tabpnt;
integer *typcnt;
doublereal *tabcnt, *tabpar, *distot, *cuvtot, *dcvtot;
integer *iercod;
{
    /* System generated locals */
    integer tabpnt_dim1, tabpnt_offset, tabcnt_dim1, tabcnt_offset, i__1, 
	    i__2;
    doublereal d__1;

    /* Local variables */
    static logical idbg;
    static integer iaux, ipnt;
    static doublereal vaux;
    static integer ipnt1;
    static doublereal delta, vsecn[9]	/* was [3][3] */, vtang[9]	/* 
	    was [3][3] */;
    extern /* Subroutine */ int mmeps1_();
    static integer ii, id1, id2, id3, jd1, jd2, jd3, ibb, ier;
    extern doublereal msc_();
    extern integer mnfndeb_();
    extern /* Subroutine */ int maermsg_(), mgenmsg_(), mlimscn_(), mmlipri_()
	    , mgsomsg_();
    static doublereal eps1;



/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ***********************************************************************
 */

/*     FONCTION : */
/*     ---------- */
/*    Estimation a priori des integrales de c''2 et c'''2 avant le lissage
.*/

/*     MOTS CLES : */
/*     ----------- */
/*       RESERVE, POINTS, LISSAGE, ESTIMATION */

/*     ARGUMENTS D'ENTREE : */
/*     -------------------- */
/*     NDIMEN: Dimension spatial des points */
/*     NBRPNT: Nombre de points a traiter */
/*     NBCNTR: Nombre de contraintes */
/*     TYPCNT : Tableau caracterisant les points contraints */
/*     TYPCNT(1,i) :  Indice du point contraints */
/*     TYPCNT(2,i) :  Type de la contrainte */
/*                    0 -> de passage (G0) */
/*                    1 -> de tangence (G1) */
/*                    2 -> de courbure (G2) */
/*     TABCNT(*,1,i) : Vecteur tangent a respecter */
/*     TABCNT(*,2,i) : Vecteur courbure a respecter */
/*     TABPAR: Les parametres associe aux points. */
/*     DISTOT: Longueur estime de la courbe */

/*     ARGUMENTS DE SORTIE : */
/*     --------------------- */
/*                                             2 */
/*       CUVTOT: Estimation de l'intgrale de C" */
/*                                             2 */
/*       DCVTOT: Estimation de l'intgrale de C'" */
/*       IERCOD : Code d'erreur */
/*              = 0 ok */
/*              = 1 distot est trop petit */
/*              = 2 Autre erreur */

/*     COMMONS UTILISES : */
/*     ------------------ */

/*     REFERENCES APPELEES : */
/*     --------------------- */

/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */
/*       . niveau de debug = 3 */

/* $    HISTORIQUE DES MODIFICATIONS : */
/*     ------------------------------ */
/*     10-07-95 : PMN ; Creation version originale */
/* > */
/* ***********************************************************************
 */


/*     INCLUDE MINOMBR */
/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ***********************************************************************
 */

/*     FONCTION : */
/*     ---------- */
/*        Sert a fournir les constantes entieres de 0 a 1000 */

/*     MOTS CLES : */
/*     ----------- */
/*        TOUS,ENTIERS */

/*     DEMSCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */

/* $    HISTORIQUE DES MODIFICATIONS : */
/*     ------------------------------ */
/*     11-10-89 : DH ; Creation version originale */
/* > */
/* ***********************************************************************
 */


/* ***********************************************************************
 */




    /* Parameter adjustments */
    tabcnt_dim1 = *ndimen;
    tabcnt_offset = tabcnt_dim1 * 3 + 1;
    tabcnt -= tabcnt_offset;
    --tabpar;
    tabpnt_dim1 = *ndimen;
    tabpnt_offset = tabpnt_dim1 + 1;
    tabpnt -= tabpnt_offset;
    typcnt -= 3;

    /* Function Body */
    ibb = mnfndeb_();
    idbg = ibb >= 3;
    if (idbg) {
	mgenmsg_("MMLIEST", 7L);
    }
    *iercod = 0;
    mmeps1_(&eps1);
    if (*ndimen > 3) {
	goto L9101;
    }

/* ***********************************************************************
 */

    if (*distot <= eps1) {
	goto L9101;
    }

/*     Estimation des norme L2 des derivees secondes et premieres */

/*    ===== Initialisation au bords t1 ======== */

    id1 = 1;
    id2 = 2;
    id3 = 3;

    jd1 = 1;
    jd2 = 2;
    jd3 = 3;

/*     ---> Calcul des tangente */

    mmlipri_(ndimen, nbrpnt, nbcntr, &tabpnt[tabpnt_offset], &typcnt[3], &
	    tabcnt[tabcnt_offset], &minombr_1.nbr[1], &vtang[id1 * 3 - 3], &
	    ier);
    if (ier > 0) {
	goto L9102;
    }

    mmlipri_(ndimen, nbrpnt, nbcntr, &tabpnt[tabpnt_offset], &typcnt[3], &
	    tabcnt[tabcnt_offset], &minombr_1.nbr[2], &vtang[id2 * 3 - 3], &
	    ier);
    if (ier > 0) {
	goto L9102;
    }

    mmlipri_(ndimen, nbrpnt, nbcntr, &tabpnt[tabpnt_offset], &typcnt[3], &
	    tabcnt[tabcnt_offset], &minombr_1.nbr[3], &vtang[id3 * 3 - 3], &
	    ier);
    if (ier > 0) {
	goto L9102;
    }

    mlimscn_(ndimen, nbrpnt, nbcntr, &tabpar[1], &typcnt[3], &tabcnt[
	    tabcnt_offset], &vtang[id1 * 3 - 3], &vtang[id2 * 3 - 3], distot, 
	    &minombr_1.nbr[1], &vsecn[jd1 * 3 - 3], &ier);
    if (ier > 0) {
	goto L9102;
    }

    mlimscn_(ndimen, nbrpnt, nbcntr, &tabpar[1], &typcnt[3], &tabcnt[
	    tabcnt_offset], &vtang[id1 * 3 - 3], &vtang[id3 * 3 - 3], distot, 
	    &minombr_1.nbr[2], &vsecn[jd2 * 3 - 3], &ier);

    delta = (tabpar[2] - tabpar[1]) * (float).5;
    if (delta <= eps1) {
	delta = (float)1.;
    }

    *cuvtot = msc_(ndimen, &vsecn[jd1 * 3 - 3], &vsecn[jd1 * 3 - 3]) * delta;

    vaux = 0.;
    i__1 = *ndimen;
    for (ii = 1; ii <= i__1; ++ii) {
/* Computing 2nd power */
	d__1 = vsecn[ii + jd2 * 3 - 4] - vsecn[ii + jd1 * 3 - 4];
	vaux += d__1 * d__1;
    }

    if (delta > eps1) {
	*dcvtot = vaux / (delta * 4);
    } else {
	*dcvtot = 0.;
    }

/* ======   BOUCLE SUR LES POINTS INTERNES ====== */

    i__1 = *nbrpnt - 1;
    for (ipnt = 2; ipnt <= i__1; ++ipnt) {

	iaux = id1;
	id1 = id2;
	id2 = id3;
	id3 = iaux;

	ipnt1 = ipnt + 1;

	if (ipnt1 != *nbrpnt) {

/*            ---> Calcul de la tangente suivante */

	    ii = ipnt1 + 1;
	    mmlipri_(ndimen, nbrpnt, nbcntr, &tabpnt[tabpnt_offset], &typcnt[
		    3], &tabcnt[tabcnt_offset], &ii, &vtang[id3 * 3 - 3], &
		    ier);
	    if (ier > 0) {
		goto L9102;
	    }

/*             ---> Calcul de la derive seconde suivante */

	    mlimscn_(ndimen, nbrpnt, nbcntr, &tabpar[1], &typcnt[3], &tabcnt[
		    tabcnt_offset], &vtang[id1 * 3 - 3], &vtang[id3 * 3 - 3], 
		    distot, &ipnt1, &vsecn[jd3 * 3 - 3], &ier);
	    if (ier > 0) {
		goto L9102;
	    }

	} else {
/*             ---> Calcul de la derive seconde suivante */

	    mlimscn_(ndimen, nbrpnt, nbcntr, &tabpar[1], &typcnt[3], &tabcnt[
		    tabcnt_offset], &vtang[id1 * 3 - 3], &vtang[id2 * 3 - 3], 
		    distot, &ipnt1, &vsecn[jd3 * 3 - 3], &ier);
	    if (ier > 0) {
		goto L9102;
	    }
	}


/*         Evaluation du l'integrale au carre de la derive seconde */

	delta = (tabpar[ipnt + 1] - tabpar[ipnt - 1]) * (float).5;

	*cuvtot += msc_(ndimen, &vsecn[jd2 * 3 - 3], &vsecn[jd2 * 3 - 3]) * 
		delta;

/*         Evaluation du l'integrale au carre de la derive troisieme 
*/

	vaux = 0.;
	i__2 = *ndimen;
	for (ii = 1; ii <= i__2; ++ii) {
/* Computing 2nd power */
	    d__1 = vsecn[ii + jd3 * 3 - 4] - vsecn[ii + jd1 * 3 - 4];
	    vaux += d__1 * d__1;
	}

	if (delta > eps1) {
	    *dcvtot += vaux / (delta * 4);
	}

	iaux = jd1;
	jd1 = jd2;
	jd2 = jd3;
	jd3 = iaux;

    }

/*     Estimation sur le dernier point. */

    delta = (tabpar[*nbrpnt] - tabpar[*nbrpnt - 1]) * (float).5;
    if (delta <= eps1) {
	delta = (float)1.;
    }

    *cuvtot += msc_(ndimen, &vsecn[jd2 * 3 - 3], &vsecn[jd2 * 3 - 3]) * delta;

    vaux = 0.;
    i__1 = *ndimen;
    for (ii = 1; ii <= i__1; ++ii) {
/* Computing 2nd power */
	d__1 = vsecn[ii + jd2 * 3 - 4] - vsecn[ii + jd1 * 3 - 4];
	vaux += d__1 * d__1;
    }

    if (delta > eps1) {
	vaux /= delta * 4;
    }

    *dcvtot += vaux;

/*     Denormalisation via la longueur. */

    *cuvtot = *cuvtot * *distot * *distot;
    *dcvtot = *dcvtot * *distot * *distot;

    goto L9999;


/* ***********************************************************************
 */
/*                   TRAITEMENT DES ERREURS */
/* ***********************************************************************
 */

L9101:
    *iercod = 1;
    goto L9999;

L9102:
    *iercod = 2;

/* ***********************************************************************
 */
/*                   RETOUR PROGRAMME APPELANT */
/* ***********************************************************************
 */

L9999:
    if (*iercod != 0) {
	maermsg_("MMLIEST", iercod, 7L);
    }
    if (idbg) {
	mgsomsg_("MMLIEST", 7L);
    }
 return 0 ;
} /* mmliest_ */

