
#include <OpenGl_tgl_all.h>

#include <stddef.h>
#include <stdio.h>
#include <GL/gl.h>
#include <GL/glu.h>

#include <OpenGl_cmn_varargs.h>
#include <OpenGl_cmn_memory.h>
#include <OpenGl_telem_attri.h>
#include <OpenGl_tsm.h>
#include <OpenGl_telem.h>
#include <OpenGl_telem_inquire.h>

static  TStatus  CharacterSpacingDisplay( TSM_ELEM_DATA, Tint, cmn_key* );
static  TStatus  CharacterSpacingAdd( TSM_ELEM_DATA, Tint, cmn_key* );
static  TStatus  CharacterSpacingDelete( TSM_ELEM_DATA, Tint, cmn_key* );
static  TStatus  CharacterSpacingPrint( TSM_ELEM_DATA, Tint, cmn_key* );
static  TStatus  CharacterSpacingInquire( TSM_ELEM_DATA, Tint, cmn_key* );

static  TStatus  (*MtdTbl[])( TSM_ELEM_DATA, Tint, cmn_key* ) =
{
    CharacterSpacingDisplay,             /* PickTraverse */
    CharacterSpacingDisplay,
    CharacterSpacingAdd,
    CharacterSpacingDelete,
    CharacterSpacingPrint,
    CharacterSpacingInquire
};


MtblPtr
TelCharacterSpacingInitClass( TelType *el )
{
   *el = TelCharacterSpacing;
   return MtdTbl;
}

static  TStatus
CharacterSpacingAdd( TSM_ELEM_DATA d, Tint n, cmn_key *k )
{
    Tfloat *data;

    data = cmn_getmem( 1, sizeof(Tfloat), 0 );
    if( !data )
	return TFailure;

    *data = k[0]->data.fdata;

    ((tsm_elem_data)(d.pdata))->pdata = data;

    return TSuccess;
}


static  TStatus
CharacterSpacingDisplay( TSM_ELEM_DATA data, Tint n, cmn_key *k )
{
    CMN_KEY     key;

    key.id = TelCharacterSpacing;
    key.data.fdata = *(Tfloat*)(data.pdata);
    TsmSetAttri( 1, &key );

    return TSuccess;
}


static  TStatus
CharacterSpacingDelete( TSM_ELEM_DATA data, Tint n, cmn_key *k )
{
    cmn_freemem( data.pdata );
    return TSuccess;
}


static  TStatus
CharacterSpacingPrint( TSM_ELEM_DATA data, Tint n, cmn_key *k )
{
    fprintf( stdout, "TelCharacterSpacing. Value = %g\n", *(Tfloat *)(data.pdata));
    fprintf( stdout, "\n" );

    return TSuccess;
}


static TStatus
CharacterSpacingInquire( TSM_ELEM_DATA data, Tint n, cmn_key *k )
{
   Tint    i;
   Tfloat *f;

   f = data.pdata;

   for( i = 0; i < n; i++ )
   {
      switch( k[i]->id )
      {
	 case INQ_GET_SIZE_ID:
	 {
	    k[i]->data.ldata = sizeof( Tint );
	    break;
	 }
	 case INQ_GET_CONTENT_ID:
	 {
	    TEL_INQ_CONTENT *c;
	    Teldata         *w;

	    c = k[i]->data.pdata;
	    w = c->data;
            c->act_size = 0;
	    w->fdata = *f;
	    break;
	 }
      }
   }

   return TSuccess;
}
