#include <Message_Msg.ixx>
#include <Message_MsgFile.hxx>

//=======================================================================
//function : Message_Msg
//purpose  : 
//=======================================================================

Message_Msg::Message_Msg ()    
{
  myEdited = Standard_False;
}

//=======================================================================
//function : Message_Msg
//purpose  : 
//=======================================================================

Message_Msg::Message_Msg (const Standard_CString acode)
{
  myCode = acode;
  SetOriginal (Message_MsgFile::Msg(acode));
}

//=======================================================================
//function : SetOriginal
//purpose  : 
//=======================================================================

void  Message_Msg::SetOriginal (const Standard_CString mess)
{
  myOriginal.Clear();  myOriginal.AssignCat (mess);
  myValue.Clear();     myValue.AssignCat    (mess);
  myEdited = Standard_False;
}

//  Test CKY pb memoire AsciiString ??
static Standard_Integer fillval (const TCollection_AsciiString &val,
				 const TCollection_AsciiString &str,
				 TCollection_AsciiString &dfval)
{
  Standard_Integer loc = dfval.Search(str);
  if(loc == -1) return 0;
  dfval.Remove(loc,str.Length());
  dfval.Insert(loc,val);
  return 1;
}  

//=======================================================================
//function : AddInteger
//purpose  : 
//=======================================================================

void  Message_Msg::AddInteger (const Standard_Integer val)
{
  if (fillval(val,"%d",myValue))
    myEdited = Standard_True;
}  

//=======================================================================
//function : AddReal
//purpose  : 
//=======================================================================

void  Message_Msg::AddReal (const Standard_Real val)
{ 
  if (fillval(val,"%f",myValue))
    myEdited = Standard_True;
}  

//=======================================================================
//function : AddString
//purpose  : 
//=======================================================================

void  Message_Msg::AddString  (const Standard_CString val)
{ 
  if (fillval(val,"%s",myValue))
    myEdited = Standard_True;
}  

//=======================================================================
//function : AddString
//purpose  : 
//=======================================================================

void  Message_Msg::AddString  (const TCollection_AsciiString& val)
{  AddString (val.ToCString());  }

//=======================================================================
//function : AddString
//purpose  : 
//=======================================================================

void  Message_Msg::AddString  (const Handle(TCollection_HAsciiString)& val)
{  if (!val.IsNull()) AddString (val->ToCString());  }
