/* MDRC11.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"
#ifdef WNT
#include <MathBase.h>
#else 
#define  __MathBase_API
#endif
/* Subroutine */ __MathBase_API int mmdrc11_(iordre, ndimen, ncoeff, courbe, points, mfactab)
integer *iordre, *ndimen, *ncoeff;
doublereal *courbe, *points, *mfactab;
{
    /* System generated locals */
    integer courbe_dim1, courbe_offset, points_dim2, points_offset, i__1, 
	    i__2;

    /* Local variables */
    extern /* Subroutine */ int mfac_();
    static integer ndeg, i__, j, ndgcb, nd, ibb;
    extern integer mnfndeb_();
    extern /* Subroutine */ int mgenmsg_(), mgsomsg_();



/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ********************************************************************** 
*/

/*     FONCTION : */
/*     ---------- */
/*        Calcul des derivees successives de l' equation COURBE au */
/*        parametres -1, 1 de l' ordre 0 jusqu' a l' ordre IORDRE */
/*        inclus.Le calcul se fait sans connaitre les coefficients des */
/*        derivees de la courbe. */

/*     MOTS CLES : */
/*     ----------- */
/*        POSITIONNEMENT,EXTREMITES,COURBE,DERIVEE. */

/*     ARGUMENTS D'ENTREE : */
/*     ------------------ */
/*        IORDRE   : Ordre maximal de calcul des derivees. */
/*        NDIMEN   : Dimension de l' espace. */
/*        NCOEFF  : Nombre de coefficients de la courbe (degre+1). */
/*        COURBE  : Tableau des coefficients de la courbe. */

/*     ARGUMENTS DE SORTIE : */
/*     ------------------- */
/*        POINTS    : Tableau des valeurs des derivees successives */
/*                 au parametres -1.D0 et 1.D0. */
/*        MFACTAB : Tableau auxiliaire pour le calcul de factorielle(I). 
*/

/*     COMMONS UTILISES   : */
/*     ---------------- */
/*        Aucun. */

/*     REFERENCES APPELEES   : */
/*     ----------------------- */

/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */

/* ---> ATTENTION, les coefficients de la courbe sont ranges */
/*     "A L' ENVERS". */

/* ---> L' algorithme de calcul des derivees est base sur la */
/*     generalisation du schema de Horner : */
/*                          k             2 */
/*          Soit C(t) = uk.t  + ... + u2.t  + u1.t + u0 . */


/*     On pose a0 = uk, b0 = 0, c0 = 0 et pour 1<=j<=k, on calcule : */

/*          aj = a(j-1).x + u(k-j) */
/*          bj = b(j-1).x + a(j-1) */
/*          cj = c(j-1).x + b(j-1) */

/*     On obtient alors : C(x) = ak, C'(x) = bk, C"(x) = 2.ck  . */

/*     L' algorithme se generalise facilement pour le calcul de */

/*               (n) */
/*              C  (x)   . */
/*             --------- */
/*                n! */

/*      Reference : D. KNUTH, "The Art of Computer Programming" */
/*      ---------              Vol. 2/Seminumerical Algorithms */
/*                             Addison-Wesley Pub. Co. (1969) */
/*                             pages 423-425. */


/* $    HISTORIQUE DES MODIFICATIONS   : */
/*     -------------------------------- */
/*     29-01-1990 : RBD ; Correction de l' en-tete, mise au normes. */
/*     22-02-1988 : JJM ; Appel MFNDEB -> MNFNDEB */
/*     25-11-1987 : Cree par JJM (d' apres MDRCRV). */
/* > */
/* ********************************************************************** 
*/

/*   Le nom de la routine */

    /* Parameter adjustments */
    points_dim2 = *iordre + 1;
    points_offset = (points_dim2 << 1) + 1;
    points -= points_offset;
    courbe_dim1 = *ncoeff;
    courbe_offset = courbe_dim1;
    courbe -= courbe_offset;

    /* Function Body */
    ibb = mnfndeb_();
    if (ibb >= 2) {
	mgenmsg_("MMDRC11", 7L);
    }

    if (*iordre < 0 || *ncoeff < 1) {
	goto L9999;
    }

/* ------------------- Initialisation du tableau POINTS ----------------- 
*/

    ndgcb = *ncoeff - 1;
    i__1 = *ndimen;
    for (nd = 1; nd <= i__1; ++nd) {
	points[(nd * points_dim2 << 1) + 1] = courbe[ndgcb + nd * courbe_dim1]
		;
	points[(nd * points_dim2 << 1) + 2] = courbe[ndgcb + nd * courbe_dim1]
		;
/* L100: */
    }

    i__1 = *ndimen;
    for (nd = 1; nd <= i__1; ++nd) {
	i__2 = *iordre;
	for (j = 1; j <= i__2; ++j) {
	    points[((j + nd * points_dim2) << 1) + 1] = 0.;
	    points[((j + nd * points_dim2) << 1) + 2] = 0.;
/* L400: */
	}
/* L300: */
    }

/*    Calcul au parametre -1 et 1 */

    i__1 = *ndimen;
    for (nd = 1; nd <= i__1; ++nd) {
	i__2 = ndgcb;
	for (ndeg = 1; ndeg <= i__2; ++ndeg) {
	    for (i__ = *iordre; i__ >= 1; --i__) {
		points[((i__ + nd * points_dim2) << 1) + 1] = -points[((i__ + nd 
			* points_dim2) << 1) + 1] + points[((i__ - 1 + nd * 
			points_dim2) << 1) + 1];
		points[((i__ + nd * points_dim2) << 1) + 2] += points[((i__ - 1 
			+ nd * points_dim2) << 1) + 2];
/* L800: */
	    }
	    points[(nd * points_dim2 << 1) + 1] = -points[(nd * points_dim2 <<
		     1) + 1] + courbe[ndgcb - ndeg + nd * courbe_dim1];
	    points[(nd * points_dim2 << 1) + 2] += courbe[ndgcb - ndeg + nd * 
		    courbe_dim1];
/* L700: */
	}
/* L600: */
    }

/* --------------------- Multiplication par factorielle(I) -------------- 
*/

    if (*iordre > 1) {
	mfac_(&mfactab[1], iordre);

	i__1 = *ndimen;
	for (nd = 1; nd <= i__1; ++nd) {
	    i__2 = *iordre;
	    for (i__ = 2; i__ <= i__2; ++i__) {
		points[((i__ + nd * points_dim2) << 1) + 1] = mfactab[i__] * 
			points[((i__ + nd * points_dim2) << 1) + 1];
		points[((i__ + nd * points_dim2) << 1) + 2] = mfactab[i__] * 
			points[((i__ + nd * points_dim2) << 1) + 2];
/* L1000: */
	    }
/* L900: */
	}
    }

/* ---------------------------- Fin ------------------------------------- 
*/

L9999:
    if (ibb >= 2) {
	mgsomsg_("MMDRC11", 7L);
    }
    return 0;
} /* mmdrc11_ */

