// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _math_SVD_HeaderFile
#define _math_SVD_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _math_Matrix_HeaderFile
#include <math_Matrix.hxx>
#endif
#ifndef _math_Vector_HeaderFile
#include <math_Vector.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class StdFail_NotDone;
class Standard_DimensionError;
class math_Matrix;
class math_Vector;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! SVD implements the solution of a set of N linear equations <br>
//! of M unknowns without condition on N or M. The Singular <br>
//! Value Decomposition algorithm is used. For singular or <br>
//! nearly singular matrices SVD is a better choice than Gauss <br>
//! or GaussLeastSquare. <br>
class math_SVD  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Given as input an n X m matrix A with n < m, n = m or n > m <br>
//! this constructor performs the Singular Value Decomposition. <br>
Standard_EXPORT math_SVD(const math_Matrix& A);
//! Returns true if the computations are successful, otherwise returns false. <br>
  Standard_Boolean IsDone() const;


//! Given the input Vector B this routine solves the set of linear <br>
//! equations A . X = B. <br>
//! Exception NotDone is raised if the decomposition of A was not done <br>
//! successfully. <br>
//! Exception DimensionError is raised if the range of B is not <br>
//! equal to the rowrange of A. <br>
//! Exception DimensionError is raised if the range of X is not <br>
//! equal to the colrange of A. <br>
Standard_EXPORT   void Solve(const math_Vector& B,math_Vector& X,const Standard_Real Eps = 1.0e-6) const;

//! Computes the inverse Inv of matrix A such as A * Inverse = Identity. <br>
//! Exceptions <br>
//! StdFail_NotDone if the algorithm fails (and IsDone returns false). <br>
//! Standard_DimensionError if the ranges of Inv are <br>
//! compatible with the ranges of A. <br>
Standard_EXPORT   void PseudoInverse(math_Matrix& Inv,const Standard_Real Eps = 1.0e-6) const;

//! Prints information on the current state of the object. <br>
//!          Is used to redefine the operator <<. <br>
Standard_EXPORT   void Dump(Standard_OStream& o) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean Done;
Standard_Boolean Singular;
math_Matrix U;
math_Matrix V;
math_Vector Diag;
Standard_Integer RowA;


};


#include <math_SVD.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
