// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _math_BracketMinimum_HeaderFile
#define _math_BracketMinimum_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class StdFail_NotDone;
class math_Function;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//!Given two distinct initial points, BracketMinimum <br>
//! implements the computation of three points (a, b, c) which <br>
//! bracket the minimum of the function and verify A less than <br>
//! B, B less than C and F(A) less than F(B), F(B) less than (C). <br>
class math_BracketMinimum  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Given two initial values this class computes a <br>
//! bracketing triplet of abscissae Ax, Bx, Cx <br>
//! (such that Bx is between Ax and Cx, F(Bx) is <br>
//! less than both F(Bx) and F(Cx)) the Brent minimization is done <br>
//! on the function F. <br>
Standard_EXPORT math_BracketMinimum(math_Function& F,const Standard_Real A,const Standard_Real B);


//! Given two initial values this class computes a <br>
//! bracketing triplet of abscissae Ax, Bx, Cx <br>
//! (such that Bx is between Ax and Cx, F(Bx) is <br>
//! less than both F(Bx) and F(Cx)) the Brent minimization is done <br>
//! on the function F. <br>
//! This constructor has to be used if F(A) is known. <br>
Standard_EXPORT math_BracketMinimum(math_Function& F,const Standard_Real A,const Standard_Real B,const Standard_Real FA);


//! Given two initial values this class computes a <br>
//! bracketing triplet of abscissae Ax, Bx, Cx <br>
//! (such that Bx is between Ax and Cx, F(Bx) is <br>
//! less than both F(Bx) and F(Cx)) the Brent minimization is done <br>
//! on the function F. <br>
//! This constructor has to be used if F(A) and F(B) are known. <br>
Standard_EXPORT math_BracketMinimum(math_Function& F,const Standard_Real A,const Standard_Real B,const Standard_Real FA,const Standard_Real FB);
//! Returns true if the computations are successful, otherwise returns false. <br>
  Standard_Boolean IsDone() const;

//! Returns the bracketed triplet of abscissae. <br>
//! Exceptions <br>
//! StdFail_NotDone if the algorithm fails (and IsDone returns false). <br>
Standard_EXPORT   void Values(Standard_Real& A,Standard_Real& B,Standard_Real& C) const;

//! returns the bracketed triplet function values. <br>
//! Exceptions <br>
//! StdFail_NotDone if the algorithm fails (and IsDone returns false). <br>
Standard_EXPORT   void FunctionValues(Standard_Real& FA,Standard_Real& FB,Standard_Real& FC) const;

//! Prints on the stream o information on the current state <br>
//!          of the object. <br>
//!          Is used to redefine the operator <<. <br>
Standard_EXPORT   void Dump(Standard_OStream& o) const;





protected:

 // Methods PROTECTED
 // 

//! Is used internally by the constructors. <br>
Standard_EXPORT   void Perform(math_Function& F,const Standard_Real A,const Standard_Real B) ;


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean Done;
Standard_Real Ax;
Standard_Real Bx;
Standard_Real Cx;
Standard_Real FAx;
Standard_Real FBx;
Standard_Real FCx;
Standard_Boolean myFA;
Standard_Boolean myFB;


};


#include <math_BracketMinimum.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
