// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Visual3d_PickDescriptor_HeaderFile
#define _Visual3d_PickDescriptor_HeaderFile

#ifndef _Handle_Visual3d_HSequenceOfPickPath_HeaderFile
#include <Handle_Visual3d_HSequenceOfPickPath.hxx>
#endif
#ifndef _Visual3d_ContextPick_HeaderFile
#include <Visual3d_ContextPick.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Graphic3d_Structure_HeaderFile
#include <Handle_Graphic3d_Structure.hxx>
#endif
class Visual3d_HSequenceOfPickPath;
class Visual3d_PickError;
class Visual3d_ContextPick;
class Visual3d_PickPath;
class Graphic3d_Structure;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class contains the pick information. <br>
//!	    It contains a certain number of PickPaths. <br>
class Visual3d_PickDescriptor  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates a PickDescriptor <me>. <br>
Standard_EXPORT Visual3d_PickDescriptor(const Visual3d_ContextPick& CTX);

//! Adds a PickPath to PickDescriptor <me>. <br>
Standard_EXPORT   void AddPickPath(const Visual3d_PickPath& APickPath) ;

//! Erases all the information in <me>. <br>
Standard_EXPORT   void Clear() ;

//! Returns the pick depth, that is the <br>
//!	    number of PickPaths available in the PickDescriptor. <br>
Standard_EXPORT   Standard_Integer Depth() const;

//! Returns the group of PickPaths of <me>. <br>
Standard_EXPORT   Handle_Visual3d_HSequenceOfPickPath PickPath() const;

//! Returns the root structure. <br>
//!	    If the pick order was of the type TOO_TOPFIRST <br>
//!	    then it's the first structure. <br>
//!	    If the pick order was of the type TOO_BOTTOMFIRST <br>
//!	    Then it's the last structure. <br>
//!	    The pick order is set by the method SetOrder <br>
//!	    from ContextPick. <br>
//!  Category: Inquire methods <br>
//!  Warning: Raises PickError if Depth == 0 (no picked structure). <br>
Standard_EXPORT   Handle_Graphic3d_Structure TopStructure() const;

//! Returns the root structure pickid. <br>
//!	    If the pick order was of the type TOO_TOPFIRST <br>
//!	    then it's the first pickid. <br>
//!	    If the pick order was of the type TOO_BOTTOMFIRST <br>
//!	    then it's the last pickid. <br>
//!	    The pick order is set by the method SetOrder <br>
//!	    from ContextPick. <br>
//!  Category: Inquire methods <br>
//!  Warning: Raises PickError if Depth == 0 (no picked structure). <br>
Standard_EXPORT   Standard_Integer TopPickId() const;

//! Returns the root structure element number. <br>
//!	    If the pick order was of the type TOO_TOPFIRST <br>
//!	    then it's the first element number. <br>
//!	    If the pick order was of the type TOO_BOTTOMFIRST <br>
//!	    then it's the last element number. <br>
//!	    The pick order is set by the method SetOrder <br>
//!	    from ContextPick. <br>
//!  Category: Inquire methods <br>
//!  Warning: Raises PickError if Depth == 0 (no picked structure). <br>
Standard_EXPORT   Standard_Integer TopElementNumber() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Visual3d_HSequenceOfPickPath MyPickPathSequence;
Visual3d_ContextPick MyContext;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
