// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TopTrans_CurveTransition_HeaderFile
#define _TopTrans_CurveTransition_HeaderFile

#ifndef _gp_Dir_HeaderFile
#include <gp_Dir.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TopAbs_Orientation_HeaderFile
#include <TopAbs_Orientation.hxx>
#endif
#ifndef _TopAbs_State_HeaderFile
#include <TopAbs_State.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class gp_Dir;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This algorithm  is used to  compute the transition <br>
//!          of a Curve intersecting a curvilinear boundary. <br>
//! <br>
//!          The geometric  elements  are described locally  at <br>
//!          the   intersection   point  by    a   second order <br>
//!          development. <br>
//! <br>
//!          The curve is described  by the intersection point, <br>
//!          the tangent vector and the curvature. <br>
//! <br>
//!          The  boundary  is described  by   a set  of  curve <br>
//!          elements, a curve element is either : <br>
//! <br>
//!          - A curve. <br>
//! <br>
//!          - A curve and an orientation  called a half-curve, <br>
//!          the boundary  of the curve is  before or after the <br>
//!          intersection point depending on the orientation. <br>
//! <br>
class TopTrans_CurveTransition  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Create an empty  Curve Transition. <br>
Standard_EXPORT TopTrans_CurveTransition();

//! Initialize a Transition with the local description <br>
//!          of a Curve. <br>
Standard_EXPORT   void Reset(const gp_Dir& Tgt,const gp_Dir& Norm,const Standard_Real Curv) ;

//! Initialize a Transition with the local description <br>
//!          of a straigth line. <br>
Standard_EXPORT   void Reset(const gp_Dir& Tgt) ;

//! Add  a curve element to the  boundary.    If Or is <br>
//!          REVERSED  the curve  is   before the intersection, <br>
//!          else if  Or  is FORWARD  the   curv  is after  the <br>
//!          intersection   and    if   Or  is   INTERNAL   the <br>
//!          intersection is in the middle of the curv. <br>
Standard_EXPORT   void Compare(const Standard_Real Tole,const gp_Dir& Tang,const gp_Dir& Norm,const Standard_Real Curv,const TopAbs_Orientation S,const TopAbs_Orientation Or) ;

//! returns   the  state   of  the   curve  before the <br>
//!          intersection, this is the position relative to the <br>
//!          boundary of a point very close to the intersection <br>
//!          on the negative side of the tangent. <br>
Standard_EXPORT   TopAbs_State StateBefore() const;

//! returns  the    state of  the  curve   after   the <br>
//!          intersection, this is the position relative to the <br>
//!          boundary of a point very close to the intersection <br>
//!          on the positive side of the tangent. <br>
Standard_EXPORT   TopAbs_State StateAfter() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 

//! Compare two curvature and return true  if N1,C1 is <br>
//!          before N2,C2 in the edge orientation <br>
Standard_EXPORT   Standard_Boolean IsBefore(const Standard_Real Tole,const Standard_Real Angl,const gp_Dir& Nor1,const Standard_Real Cur1,const gp_Dir& Nor2,const Standard_Real Cur2) const;

//! Compare two angles at tolerance Tole <br>
Standard_EXPORT   Standard_Integer Compare(const Standard_Real Ang1,const Standard_Real Ang2,const Standard_Real Tole) const;


 // Fields PRIVATE
 //
gp_Dir myTgt;
gp_Dir myNorm;
Standard_Real myCurv;
Standard_Boolean Init;
gp_Dir TgtFirst;
gp_Dir NormFirst;
Standard_Real CurvFirst;
TopAbs_Orientation TranFirst;
gp_Dir TgtLast;
gp_Dir NormLast;
Standard_Real CurvLast;
TopAbs_Orientation TranLast;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
