// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _StepElement_ElementAspect_HeaderFile
#define _StepElement_ElementAspect_HeaderFile

#ifndef _StepData_SelectType_HeaderFile
#include <StepData_SelectType.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
#ifndef _Handle_StepData_SelectMember_HeaderFile
#include <Handle_StepData_SelectMember.hxx>
#endif
#ifndef _StepElement_ElementVolume_HeaderFile
#include <StepElement_ElementVolume.hxx>
#endif
#ifndef _StepElement_CurveEdge_HeaderFile
#include <StepElement_CurveEdge.hxx>
#endif
class Standard_Transient;
class StepData_SelectMember;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Representation of STEP SELECT type ElementAspect <br>
class StepElement_ElementAspect  : public StepData_SelectType {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Empty constructor <br>
Standard_EXPORT StepElement_ElementAspect();

//! Recognizes a kind of ElementAspect select type <br>
//!          return 0 <br>
Standard_EXPORT   Standard_Integer CaseNum(const Handle(Standard_Transient)& ent) const;

//! Recognizes a items of select member ElementAspectMember <br>
//!          1 -> ElementVolume <br>
//!          2 -> Volume3dFace <br>
//!          3 -> Volume2dFace <br>
//!          4 -> Volume3dEdge <br>
//!          5 -> Volume2dEdge <br>
//!          6 -> Surface3dFace <br>
//!          7 -> Surface2dFace <br>
//!          8 -> Surface3dEdge <br>
//!          9 -> Surface2dEdge <br>
//!          10 -> CurveEdge <br>
//!          0 else <br>
Standard_EXPORT virtual  Standard_Integer CaseMem(const Handle(StepData_SelectMember)& ent) const;

//! Returns a new select member the type ElementAspectMember <br>
Standard_EXPORT virtual  Handle_StepData_SelectMember NewMember() const;

//! Set Value for ElementVolume <br>
Standard_EXPORT   void SetElementVolume(const StepElement_ElementVolume aVal) ;

//! Returns Value as ElementVolume (or Null if another type) <br>
Standard_EXPORT   StepElement_ElementVolume ElementVolume() const;

//! Set Value for Volume3dFace <br>
Standard_EXPORT   void SetVolume3dFace(const Standard_Integer aVal) ;

//! Returns Value as Volume3dFace (or Null if another type) <br>
Standard_EXPORT   Standard_Integer Volume3dFace() const;

//! Set Value for Volume2dFace <br>
Standard_EXPORT   void SetVolume2dFace(const Standard_Integer aVal) ;

//! Returns Value as Volume2dFace (or Null if another type) <br>
Standard_EXPORT   Standard_Integer Volume2dFace() const;

//! Set Value for Volume3dEdge <br>
Standard_EXPORT   void SetVolume3dEdge(const Standard_Integer aVal) ;

//! Returns Value as Volume3dEdge (or Null if another type) <br>
Standard_EXPORT   Standard_Integer Volume3dEdge() const;

//! Set Value for Volume2dEdge <br>
Standard_EXPORT   void SetVolume2dEdge(const Standard_Integer aVal) ;

//! Returns Value as Volume2dEdge (or Null if another type) <br>
Standard_EXPORT   Standard_Integer Volume2dEdge() const;

//! Set Value for Surface3dFace <br>
Standard_EXPORT   void SetSurface3dFace(const Standard_Integer aVal) ;

//! Returns Value as Surface3dFace (or Null if another type) <br>
Standard_EXPORT   Standard_Integer Surface3dFace() const;

//! Set Value for Surface2dFace <br>
Standard_EXPORT   void SetSurface2dFace(const Standard_Integer aVal) ;

//! Returns Value as Surface2dFace (or Null if another type) <br>
Standard_EXPORT   Standard_Integer Surface2dFace() const;

//! Set Value for Surface3dEdge <br>
Standard_EXPORT   void SetSurface3dEdge(const Standard_Integer aVal) ;

//! Returns Value as Surface3dEdge (or Null if another type) <br>
Standard_EXPORT   Standard_Integer Surface3dEdge() const;

//! Set Value for Surface2dEdge <br>
Standard_EXPORT   void SetSurface2dEdge(const Standard_Integer aVal) ;

//! Returns Value as Surface2dEdge (or Null if another type) <br>
Standard_EXPORT   Standard_Integer Surface2dEdge() const;

//! Set Value for CurveEdge <br>
Standard_EXPORT   void SetCurveEdge(const StepElement_CurveEdge aVal) ;

//! Returns Value as CurveEdge (or Null if another type) <br>
Standard_EXPORT   StepElement_CurveEdge CurveEdge() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
