// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _StepData_PDescr_HeaderFile
#define _StepData_PDescr_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_StepData_PDescr_HeaderFile
#include <Handle_StepData_PDescr.hxx>
#endif

#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_StepData_PDescr_HeaderFile
#include <Handle_StepData_PDescr.hxx>
#endif
#ifndef _StepData_EnumTool_HeaderFile
#include <StepData_EnumTool.hxx>
#endif
#ifndef _Handle_Standard_Type_HeaderFile
#include <Handle_Standard_Type.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Handle_StepData_EDescr_HeaderFile
#include <Handle_StepData_EDescr.hxx>
#endif
#ifndef _Handle_Interface_Check_HeaderFile
#include <Handle_Interface_Check.hxx>
#endif
class Standard_Type;
class StepData_EDescr;
class StepData_Field;
class Interface_Check;


//! This class is intended to describe the authorized form for a <br>
//!           parameter, as a type or a value for a field <br>
//! <br>
//!           A PDescr firstly describes a type, which can be SELECT, i.e. <br>
//!           have several members <br>
class StepData_PDescr : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT StepData_PDescr();


Standard_EXPORT   void SetName(const Standard_CString name) ;


Standard_EXPORT   Standard_CString Name() const;

//! Declares this PDescr to be a Select, hence to have members <br>
//!           <me> itself can be the first member <br>
Standard_EXPORT   void SetSelect() ;

//! Adds a member to a SELECT description <br>
Standard_EXPORT   void AddMember(const Handle(StepData_PDescr)& member) ;

//! Sets a name for SELECT member. To be used if a member is for <br>
//!           an immediate type <br>
Standard_EXPORT   void SetMemberName(const Standard_CString memname) ;

//! Sets <me> for an Integer value <br>
Standard_EXPORT   void SetInteger() ;

//! Sets <me> for a Real value <br>
Standard_EXPORT   void SetReal() ;

//! Sets <me> for a String value <br>
Standard_EXPORT   void SetString() ;

//! Sets <me> for a Boolean value (false,true) <br>
Standard_EXPORT   void SetBoolean() ;

//! Sets <me> for a Logical value (false,true,unknown) <br>
Standard_EXPORT   void SetLogical() ;

//! Sets <me> for an Enum value <br>
//!           Then, call AddEnumDef ordered from the first one (value 0) <br>
Standard_EXPORT   void SetEnum() ;

//! Adds an enum value as a string <br>
Standard_EXPORT   void AddEnumDef(const Standard_CString enumdef) ;

//! Sets <me> for an Entity which must match a Type (early-bound) <br>
Standard_EXPORT   void SetType(const Handle(Standard_Type)& atype) ;

//! Sets <me> for a Described Entity, whose Description must match <br>
//!           the type name  <dscnam> <br>
Standard_EXPORT   void SetDescr(const Standard_CString dscnam) ;

//! Adds an arity count to <me>, by default 1 <br>
//!           1 : a simple field passes to a LIST/ARRAY etc <br>
//!               or a LIST to a LIST OF LIST <br>
//!           2 : a simple field passes to a LIST OF LIST <br>
Standard_EXPORT   void AddArity(const Standard_Integer arity = 1) ;

//! Directly sets the arity count <br>
//!           0 : simple field <br>
//!           1 : LIST or ARRAY etc <br>
//!           2 : LIST OF LIST <br>
Standard_EXPORT   void SetArity(const Standard_Integer arity = 1) ;

//! Sets <me> as <other> but duplicated <br>
//!           Hence, some definition may be changed <br>
Standard_EXPORT   void SetFrom(const Handle(StepData_PDescr)& other) ;

//! Sets/Unsets <me> to accept undefined values <br>
Standard_EXPORT   void SetOptional(const Standard_Boolean opt = Standard_True) ;

//! Sets/Unsets <me> to be for a derived field <br>
Standard_EXPORT   void SetDerived(const Standard_Boolean der = Standard_True) ;

//! Sets <me> to describe a field of an entity <br>
//!           With a name and a rank <br>
Standard_EXPORT   void SetField(const Standard_CString name,const Standard_Integer rank) ;

//! Tells if <me> is for a SELECT <br>
Standard_EXPORT   Standard_Boolean IsSelect() const;

//! For a SELECT, returns the member whose name matches <name> <br>
//!           To this member, the following question can then be asked <br>
//!           Null Handle if <name> not matched or <me> not a SELECT <br>
//! <br>
//!           Remark : not to be asked for an entity type <br>
//!           Hence, following IsInteger .. Enum* only apply on <me> and <br>
//!           require Member <br>
//!           While IsType applies on <me> and all Select Members <br>
Standard_EXPORT   Handle_StepData_PDescr Member(const Standard_CString name) const;

//! Tells if <me> is for an Integer <br>
Standard_EXPORT   Standard_Boolean IsInteger() const;

//! Tells if <me> is for a Real value <br>
Standard_EXPORT   Standard_Boolean IsReal() const;

//! Tells if <me> is for a String value <br>
Standard_EXPORT   Standard_Boolean IsString() const;

//! Tells if <me> is for a Boolean value (false,true) <br>
Standard_EXPORT   Standard_Boolean IsBoolean() const;

//! Tells if <me> is for a Logical value (false,true,unknown) <br>
Standard_EXPORT   Standard_Boolean IsLogical() const;

//! Tells if <me> is for an Enum value <br>
//!           Then, call AddEnumDef ordered from the first one (value 0) <br>
//!           Managed by an EnumTool <br>
Standard_EXPORT   Standard_Boolean IsEnum() const;

//! Returns the maximum integer for a suitable value (count - 1) <br>
Standard_EXPORT   Standard_Integer EnumMax() const;

//! Returns the numeric value found for an enum text <br>
//!           The text must be in capitals and limited by dots <br>
//!           A non-suitable text gives a negative value to be returned <br>
Standard_EXPORT   Standard_Integer EnumValue(const Standard_CString name) const;

//! Returns the text which corresponds to a numeric value, <br>
//!           between 0 and EnumMax. It is limited by dots <br>
Standard_EXPORT   Standard_CString EnumText(const Standard_Integer val) const;

//! Tells if <me> is for an Entity, either Described or CDL Type <br>
Standard_EXPORT   Standard_Boolean IsEntity() const;

//! Tells if <me> is for an entity of a given CDL type (early-bnd) <br>
//!           (works for <me> + nexts if <me> is a Select) <br>
Standard_EXPORT   Standard_Boolean IsType(const Handle(Standard_Type)& atype) const;

//! Returns the type to match (IsKind), for a CDL Entity <br>
//!           (else, null handle) <br>
Standard_EXPORT   Handle_Standard_Type Type() const;

//! Tells if <me> is for a Described entity of a given EDescr <br>
//!           (does this EDescr match description name ?). For late-bnd <br>
//!           (works for <me> + nexts if <me> is a Select) <br>
Standard_EXPORT   Standard_Boolean IsDescr(const Handle(StepData_EDescr)& descr) const;

//! Returns the description (type name) to match, for a Described <br>
//!           (else, empty string) <br>
Standard_EXPORT   Standard_CString DescrName() const;

//! Returns the arity of <me> <br>
Standard_EXPORT   Standard_Integer Arity() const;

//! For a LIST or LIST OF LIST, Returns the PDescr for the simpler <br>
//!           PDescr. Else, returns <me> <br>
//!           This allows to have different attributes for Optional for <br>
//!           instance, on a field, and on the parameter of a LIST : <br>
//!           [OPTIONAL] LIST OF [OPTIONAL] ... <br>
Standard_EXPORT   Handle_StepData_PDescr Simple() const;

//! Tells if <me> is Optional <br>
Standard_EXPORT   Standard_Boolean IsOptional() const;

//! Tells if <me> is Derived <br>
Standard_EXPORT   Standard_Boolean IsDerived() const;

//! Tells if <me> is a Field. Else it is a Type <br>
Standard_EXPORT   Standard_Boolean IsField() const;


Standard_EXPORT   Standard_CString FieldName() const;


Standard_EXPORT   Standard_Integer FieldRank() const;

//! Semantic Check of a Field : does it complies with the given <br>
//!           description ? <br>
Standard_EXPORT virtual  void Check(const StepData_Field& afild,Handle(Interface_Check)& ach) const;
//Standard_EXPORT ~StepData_PDescr();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   Standard_Integer Kind() const;


 // Fields PRIVATE
 //
TCollection_AsciiString thename;
Standard_Integer thesel;
TCollection_AsciiString thesnam;
Handle_StepData_PDescr thenext;
Standard_Integer thekind;
StepData_EnumTool theenum;
Handle_Standard_Type thetype;
TCollection_AsciiString thednam;
Standard_Integer thearit;
Handle_StepData_PDescr thefrom;
Standard_Boolean theopt;
Standard_Boolean theder;
TCollection_AsciiString thefnam;
Standard_Integer thefnum;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
