// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ShapeUpgrade_ShapeDivideContinuity_HeaderFile
#define _ShapeUpgrade_ShapeDivideContinuity_HeaderFile

#ifndef _GeomAbs_Shape_HeaderFile
#include <GeomAbs_Shape.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _ShapeUpgrade_ShapeDivide_HeaderFile
#include <ShapeUpgrade_ShapeDivide.hxx>
#endif
#ifndef _Handle_ShapeUpgrade_FaceDivide_HeaderFile
#include <Handle_ShapeUpgrade_FaceDivide.hxx>
#endif
class TopoDS_Shape;
class ShapeUpgrade_FaceDivide;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class ShapeUpgrade_ShapeDivideContinuity  : public ShapeUpgrade_ShapeDivide {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT ShapeUpgrade_ShapeDivideContinuity();

//! Initialize by a Shape. <br>
Standard_EXPORT ShapeUpgrade_ShapeDivideContinuity(const TopoDS_Shape& S);

//! Sets tolerance. <br>
Standard_EXPORT   void SetTolerance(const Standard_Real Tol) ;

//! Sets tolerance. <br>
Standard_EXPORT   void SetTolerance2d(const Standard_Real Tol) ;


//!  Defines a criterion of continuity for the boundary (all the <br>
//!  Wires) <br>
//! <br>
//!  The possible values are C0, G1, C1, G2, C2, C3, CN The <br>
//!  default is C1 to respect the Cas.Cade Shape Validity.  G1 <br>
//!  and G2 are not authorized. <br>
Standard_EXPORT   void SetBoundaryCriterion(const GeomAbs_Shape Criterion = GeomAbs_C1) ;


//!  Defines a criterion of continuity for the boundary (all the <br>
//!  pcurves of Wires) <br>
//! <br>
//!  The possible values are C0, G1, C1, G2, C2, C3, CN The <br>
//!  default is C1 to respect the Cas.Cade Shape Validity.  G1 <br>
//!  and G2 are not authorized. <br>
Standard_EXPORT   void SetPCurveCriterion(const GeomAbs_Shape Criterion = GeomAbs_C1) ;


//!  Defines a criterion of continuity for the boundary (all the <br>
//!  Wires) <br>
//! <br>
//!  The possible values are C0, G1, C1, G2, C2, C3, CN The <br>
//!  default is C1 to respect the Cas.Cade Shape Validity.  G1 <br>
//!  and G2 are not authorized. <br>
Standard_EXPORT   void SetSurfaceCriterion(const GeomAbs_Shape Criterion = GeomAbs_C1) ;





protected:

 // Methods PROTECTED
 // 

//! Returns the tool for dividing faces. <br>
Standard_EXPORT virtual  Handle_ShapeUpgrade_FaceDivide GetSplitFaceTool() const;


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
GeomAbs_Shape myCurve3dCriterion;
GeomAbs_Shape myCurve2dCriterion;
GeomAbs_Shape mySurfaceCriterion;
Standard_Real myTolerance3d;
Standard_Real myTolerance2d;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
