// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ShapeUpgrade_ConvertCurve3dToBezier_HeaderFile
#define _ShapeUpgrade_ConvertCurve3dToBezier_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_ShapeUpgrade_ConvertCurve3dToBezier_HeaderFile
#include <Handle_ShapeUpgrade_ConvertCurve3dToBezier.hxx>
#endif

#ifndef _Handle_TColGeom_HSequenceOfCurve_HeaderFile
#include <Handle_TColGeom_HSequenceOfCurve.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfReal_HeaderFile
#include <Handle_TColStd_HSequenceOfReal.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _ShapeUpgrade_SplitCurve3d_HeaderFile
#include <ShapeUpgrade_SplitCurve3d.hxx>
#endif
class TColGeom_HSequenceOfCurve;
class TColStd_HSequenceOfReal;


//! converts/splits a 3d curve of any type to a list of beziers <br>
class ShapeUpgrade_ConvertCurve3dToBezier : public ShapeUpgrade_SplitCurve3d {

public:
 // Methods PUBLIC
 // 

//! Empty constructor <br>
Standard_EXPORT ShapeUpgrade_ConvertCurve3dToBezier();
//! Sets mode for conversion Geom_Line to bezier. <br>
  void SetLineMode(const Standard_Boolean mode) ;
//! Returns the Geom_Line conversion mode. <br>
  Standard_Boolean GetLineMode() const;
//! Sets mode for conversion Geom_Circle to bezier. <br>
  void SetCircleMode(const Standard_Boolean mode) ;
//! Returns the Geom_Circle conversion mode. <br>
  Standard_Boolean GetCircleMode() const;
//! Returns the Geom_Conic conversion mode. <br>
  void SetConicMode(const Standard_Boolean mode) ;
//! Performs converting and computes the resulting shape. <br>
  Standard_Boolean GetConicMode() const;

//! Converts curve into a list of beziers, and stores the <br>
//!          splitting parameters on original curve. <br>
Standard_EXPORT virtual  void Compute() ;

//! Splits a list of beziers computed by Compute method according <br>
//!          the split values and splitting parameters. <br>
Standard_EXPORT virtual  void Build(const Standard_Boolean Segment) ;

//! Returns the list of splitted parameters in original curve <br>
//!          parametrisation. <br>
Standard_EXPORT   Handle_TColStd_HSequenceOfReal SplitParams() const;
//Standard_EXPORT ~ShapeUpgrade_ConvertCurve3dToBezier();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 

//! Returns the list of bezier curves correspondent to original <br>
//!          curve. <br>
Standard_EXPORT   Handle_TColGeom_HSequenceOfCurve Segments() const;


 // Fields PRIVATE
 //
Handle_TColGeom_HSequenceOfCurve mySegments;
Handle_TColStd_HSequenceOfReal mySplitParams;
Standard_Boolean myLineMode;
Standard_Boolean myCircleMode;
Standard_Boolean myConicMode;


};


#include <ShapeUpgrade_ConvertCurve3dToBezier.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
