// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _SelectMgr_SelectionManager_HeaderFile
#define _SelectMgr_SelectionManager_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_SelectMgr_SelectionManager_HeaderFile
#include <Handle_SelectMgr_SelectionManager.hxx>
#endif

#ifndef _TColStd_MapOfTransient_HeaderFile
#include <TColStd_MapOfTransient.hxx>
#endif
#ifndef _SelectMgr_DataMapOfObjectSelectors_HeaderFile
#include <SelectMgr_DataMapOfObjectSelectors.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Handle_SelectMgr_ViewerSelector_HeaderFile
#include <Handle_SelectMgr_ViewerSelector.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_SelectMgr_SelectableObject_HeaderFile
#include <Handle_SelectMgr_SelectableObject.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _SelectMgr_TypeOfUpdate_HeaderFile
#include <SelectMgr_TypeOfUpdate.hxx>
#endif
class SelectMgr_ViewerSelector;
class SelectMgr_SelectableObject;
class TCollection_AsciiString;


//! A framework to manage selection from the point of <br>
//! view of viewer selectors. These can be added and <br>
//! removed, and selection modes can be activated and <br>
//! deactivated. In addition, objects may be known to all <br>
//! selectors or only to some. <br>
class SelectMgr_SelectionManager : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Constructs an empty selection manager object. <br>
Standard_EXPORT SelectMgr_SelectionManager();

//! Adds the viewer selector aSelector to this framework. <br>
Standard_EXPORT   void Add(const Handle(SelectMgr_ViewerSelector)& aSelector) ;


Standard_EXPORT   void Remove(const Handle(SelectMgr_ViewerSelector)& aSelector) ;


//! Returns true if this framework contains the viewer selector aSelector. <br>
Standard_EXPORT   Standard_Boolean Contains(const Handle(SelectMgr_ViewerSelector)& aSelector) const;

//! Returns true if this framework contains the <br>
//! selectable object aSelectableObject. <br>
Standard_EXPORT   Standard_Boolean Contains(const Handle(SelectMgr_SelectableObject)& aSelectableObject) const;

//!  Loads and computes one  mode of <br>
//!        selection if  <aMode> notequal -1 ; <br>
//!         if  <anObject> already has a <br>
//!        selection with this mode, it's emptied and the sensitive <br>
//!        entities are computed  for this mode else one  Selection <br>
//!        is created with this mode before computing. <br>
Standard_EXPORT   void Load(const Handle(SelectMgr_SelectableObject)& anObject,const Standard_Integer aMode = -1) ;

//!   Local    object  available for <br>
//!        <aSelector> Only.  the sensitive entities for  selection <br>
//!        of mode <aMode> are computed if <aMode> not equal -1. <br>
//!        if <aMode> =-1 oc compute is done <br>
Standard_EXPORT   void Load(const Handle(SelectMgr_SelectableObject)& anObject,const Handle(SelectMgr_ViewerSelector)& aSelector,const Standard_Integer aMode = -1) ;

//! removes the object from All the ViewerSelectors where it was; <br>
Standard_EXPORT   void Remove(const Handle(SelectMgr_SelectableObject)& anObject) ;

//! removes the object from aSelector; <br>
Standard_EXPORT   void Remove(const Handle(SelectMgr_SelectableObject)& anObject,const Handle(SelectMgr_ViewerSelector)& aSelector) ;

//! Activates the selection mode aMode in a selector <br>
//! for the selectable object anObject. <br>
Standard_EXPORT   void Activate(const Handle(SelectMgr_SelectableObject)& anObject,const Standard_Integer aMode = 0,const Standard_Boolean AutomaticProj = Standard_True) ;

//! Activates the selection mode aMode in the selector <br>
//! aSelector for the selectable object anObject. <br>
Standard_EXPORT   void Activate(const Handle(SelectMgr_SelectableObject)& anObject,const Standard_Integer aMode,const Handle(SelectMgr_ViewerSelector)& aSelector,const Standard_Boolean AutomaticProj = Standard_True) ;

//! Deactivate all the activated modes in any <br>
//!          Selector for <anObject> <br>
Standard_EXPORT   void Deactivate(const Handle(SelectMgr_SelectableObject)& anObject) ;

//! Deactivates the Mode <aMode> in every Selector where <br>
//!          it was activated <br>
Standard_EXPORT   void Deactivate(const Handle(SelectMgr_SelectableObject)& anObject,const Standard_Integer aMode) ;

//! Deactivates the selection mode aMode in the <br>
//! selector aSelector for the selectable object anObject. <br>
Standard_EXPORT   void Deactivate(const Handle(SelectMgr_SelectableObject)& anObject,const Standard_Integer aMode,const Handle(SelectMgr_ViewerSelector)& aSelector) ;

//! Deactivates all selection modes in the selector <br>
//!  aSelector for the selectable object anObject. <br>
Standard_EXPORT   void Deactivate(const Handle(SelectMgr_SelectableObject)& anObject,const Handle(SelectMgr_ViewerSelector)& aSelector) ;

//! Ensures that no object in the selector aSelector will be active. <br>
Standard_EXPORT   void Sleep(const Handle(SelectMgr_ViewerSelector)& aSelector) ;

//! the objet is temporarily deactivated everywhere it was activated. <br>
Standard_EXPORT   void Sleep(const Handle(SelectMgr_SelectableObject)& anObject) ;

//! Different from Deactivate; this method <br>
//!          deactivates the activated modes of an object, <br>
//!          but just for a time; when the Awake Method is called <br>
//!          the sleeping modes are reactivated. <br>
Standard_EXPORT   void Sleep(const Handle(SelectMgr_SelectableObject)& anObject,const Handle(SelectMgr_ViewerSelector)& aSelector) ;

//! activates all the deactivated objects in a selector. <br>
Standard_EXPORT   void Awake(const Handle(SelectMgr_ViewerSelector)& aSelector,const Standard_Boolean AutomaticProj = Standard_True) ;


Standard_EXPORT   void Awake(const Handle(SelectMgr_SelectableObject)& anObject,const Standard_Boolean AutomaticProj = Standard_True) ;

//! activates all the deactivated modes <br>
//!          of an object in a selector <br>
Standard_EXPORT   void Awake(const Handle(SelectMgr_SelectableObject)& anObject,const Handle(SelectMgr_ViewerSelector)& aSelector,const Standard_Boolean AutomaticProj = Standard_True) ;

//! Returns true if the selection is active for the selectable object anObject. <br>
Standard_EXPORT   Standard_Boolean IsActivated(const Handle(SelectMgr_SelectableObject)& anObject) const;

//! Returns true if the selection mode aMode is active for the selectable object anObject. <br>
Standard_EXPORT   Standard_Boolean IsActivated(const Handle(SelectMgr_SelectableObject)& anObject,const Standard_Integer aMode) const;

//! Returns true if the selection mode aMode is active for the selectable <br>
//!          object anObject in the viewer selector aSelector. <br>
Standard_EXPORT   Standard_Boolean IsActivated(const Handle(SelectMgr_SelectableObject)& anObject,const Handle(SelectMgr_ViewerSelector)& aSelector,const Standard_Integer aMode) const;

//! computes Selections in <anIObj> if they are <br>
//!          activated in at least one Selector. <br>
//!          puts a recompute flag in each selection which is not active. <br>
//!          if <aMode>=-1 all the selection modes will have to be <br>
//!          recomputed. <br>
//!          if <ForceUpdate>  = True, all selections are recomputed, <br>
//!          even if they are not active. <br>
Standard_EXPORT   void RecomputeSelection(const Handle(SelectMgr_SelectableObject)& anIObj,const Standard_Boolean ForceUpdate = Standard_False,const Standard_Integer aMode = -1) ;

//! updates the selectionModes of <anObject> <br>
//!          According to <br>
//!          . the stored type of update in each selection <br>
//!          mode, <br>
//!          . the activation status of each selection mode <br>
//!          if <ForceUpdate> == True Recompute <br>
Standard_EXPORT   void Update(const Handle(SelectMgr_SelectableObject)& anObject,const Standard_Boolean ForceUpdate = Standard_True) ;


Standard_EXPORT   void Update(const Handle(SelectMgr_SelectableObject)& anObject,const Handle(SelectMgr_ViewerSelector)& aSelector,const Standard_Boolean ForceUpdate = Standard_True) ;


Standard_EXPORT   void SetUpdateMode(const Handle(SelectMgr_SelectableObject)& anObject,const SelectMgr_TypeOfUpdate aType) ;


Standard_EXPORT   void SetUpdateMode(const Handle(SelectMgr_SelectableObject)& anObject,const Standard_Integer aSelMode,const SelectMgr_TypeOfUpdate aType) ;


Standard_EXPORT   TCollection_AsciiString Status() const;


Standard_EXPORT   TCollection_AsciiString Status(const Handle(SelectMgr_SelectableObject)& anObject) const;
//Standard_EXPORT ~SelectMgr_SelectionManager();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void LoadMode(const Handle(SelectMgr_SelectableObject)& anObject,const Standard_Integer aMode) ;


 // Fields PRIVATE
 //
TColStd_MapOfTransient myselectors;
TColStd_MapOfTransient myglobal;
SelectMgr_DataMapOfObjectSelectors mylocal;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
