// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _OSD_Error_HeaderFile
#define _OSD_Error_HeaderFile

#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _OSD_WhoAmI_HeaderFile
#include <OSD_WhoAmI.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class OSD_OSDError;
class TCollection_AsciiString;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Management of OSD errors <br>
class OSD_Error  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Initializes Error to be without any Error. <br>
//!          This is only used by OSD, not by programmer. <br>
Standard_EXPORT OSD_Error();

//! Raises OSD_Error with accurate error message. <br>
Standard_EXPORT   void Perror() ;

//! Instantiates error <br>
//!          This is only used by OSD methods to instantiates an error code. <br>
//!          No description is done for the programmer. <br>
Standard_EXPORT   void SetValue(const Standard_Integer Errcode,const Standard_Integer From,const TCollection_AsciiString& Message) ;

//! Returns an accurate error code. <br>
//!          To test these values, you must include "OSD_ErrorList.hxx" <br>
Standard_EXPORT   Standard_Integer Error() const;

//! Returns TRUE if an error occurs <br>
//!          This is a way to test if a system call succeeded or not. <br>
Standard_EXPORT   Standard_Boolean Failed() const;

//! Resets error counter to zero <br>
//!          This allows the user to ignore an error (WARNING). <br>
Standard_EXPORT   void Reset() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TCollection_AsciiString myMessage;
Standard_Integer myErrno;
OSD_WhoAmI myCode;
Standard_Integer extCode;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
