// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Message_ProgressSentry_HeaderFile
#define _Message_ProgressSentry_HeaderFile

#ifndef _Handle_Message_ProgressIndicator_HeaderFile
#include <Handle_Message_ProgressIndicator.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
class Message_ProgressIndicator;
class TCollection_HAsciiString;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class is a tool allowing to manage opening/closing <br>
//!          scopes in the ProgressIndicator in convenient and safe way. <br>
class Message_ProgressSentry  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT Message_ProgressSentry(const Handle(Message_ProgressIndicator)& PI,const Standard_CString name,const Standard_Real min,const Standard_Real max,const Standard_Real step,const Standard_Boolean isInf = Standard_False,const Standard_Real newScopeSpan = 0.0);

//! Creates an instance of ProgressSentry attaching it to <br>
//!          the specified ProgressIndicator, selects parameters of <br>
//!          the current scale, and opens a new scope with specified <br>
//!          span (equal to step by default) <br>
Standard_EXPORT Message_ProgressSentry(const Handle(Message_ProgressIndicator)& PI,const Handle(TCollection_HAsciiString)& name,const Standard_Real min,const Standard_Real max,const Standard_Real step,const Standard_Boolean isInf = Standard_False,const Standard_Real newScopeSpan = 0.0);
//! Closes currently opened scope (if any) <br>
  void EndScope() ;
~Message_ProgressSentry()
{
  EndScope();
}


  void NextScope() const;
void Next() const { NextScope(); }
//! Closes current scope and opens next one <br>
//!          with either specified or default span <br>
  void NextScope(const Standard_Real span) const;
void Next(const double span) const { NextScope(span); }
//! Returns False if ProgressIndicator signals UserBreak <br>
  Standard_Boolean More() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Message_ProgressIndicator myProgress;
Standard_Boolean myActive;


};


#include <Message_ProgressSentry.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
