// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _MeshAlgo_CircleTool_HeaderFile
#define _MeshAlgo_CircleTool_HeaderFile

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _MeshAlgo_DataMapOfIntegerCirc_HeaderFile
#include <MeshAlgo_DataMapOfIntegerCirc.hxx>
#endif
#ifndef _TColStd_MapOfInteger_HeaderFile
#include <TColStd_MapOfInteger.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TColStd_ListOfInteger_HeaderFile
#include <TColStd_ListOfInteger.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class gp_Circ2d;
class gp_XY;
class TColStd_ListOfInteger;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Create sort   and  destroy the  circles    used in <br>
//!          triangulation. <br>
class MeshAlgo_CircleTool  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT MeshAlgo_CircleTool();

//! Constructs a CircleTool with the maximal dimension <br>
//!          of  the occuped  space and  an  evaluation of  the <br>
//!          number of circles. <br>
Standard_EXPORT MeshAlgo_CircleTool(const Standard_Integer numberOfComponents);

//! Constructs a CircleTool with the maximal dimension <br>
//!          of  the occuped  space and  an  evaluation of  the <br>
//!          number of circles. <br>
Standard_EXPORT   void Initialize(const Standard_Integer numberOfComponents) ;

//! Valids The  CircleTool to select  circles with not <br>
//!          ordered vertex.  If  we  select  circles of  a not <br>
//!          valided CircleTool  with a not ordered  vertex the <br>
//!          selection will be wrong. <br>
Standard_EXPORT   void Valid() ;

//! unValids  The CircleTool  to  select  circles with <br>
//!          ordered vertices. It  is  interesting  to   add  a <br>
//!          consequent number of vertices. <br>
Standard_EXPORT   void unValid() ;

//! Adds and binds circle to the tool. <br>
Standard_EXPORT   void Add(const gp_Circ2d& theCirc,const Standard_Integer theIndex) ;

//! Computes adds and binds circle to the tool. <br>
Standard_EXPORT   Standard_Boolean Add(const gp_XY& p1,const gp_XY& p2,const gp_XY& p3,const Standard_Integer theIndex) ;

//! Deletes a circle from the tool. <br>
Standard_EXPORT   void Delete(const Standard_Integer theIndex) ;

//! Select the circles which contains thePnt. <br>
Standard_EXPORT   TColStd_ListOfInteger& Select(const gp_XY& thePnt) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Real Tolerance;
MeshAlgo_DataMapOfIntegerCirc Components;
TColStd_MapOfInteger SearchList;
Standard_Boolean isValid;
TColStd_ListOfInteger lastSelect;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
