// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Interface_CheckTool_HeaderFile
#define _Interface_CheckTool_HeaderFile

#ifndef _Handle_Interface_GTool_HeaderFile
#include <Handle_Interface_GTool.hxx>
#endif
#ifndef _Interface_ShareTool_HeaderFile
#include <Interface_ShareTool.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Interface_InterfaceModel_HeaderFile
#include <Handle_Interface_InterfaceModel.hxx>
#endif
#ifndef _Handle_Interface_Protocol_HeaderFile
#include <Handle_Interface_Protocol.hxx>
#endif
#ifndef _Handle_Interface_HGraph_HeaderFile
#include <Handle_Interface_HGraph.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
#ifndef _Handle_Interface_Check_HeaderFile
#include <Handle_Interface_Check.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Interface_GTool;
class Interface_CheckFailure;
class Interface_InterfaceModel;
class Interface_Protocol;
class Interface_Graph;
class Interface_HGraph;
class Standard_Transient;
class Interface_ShareTool;
class Interface_Check;
class Interface_CheckIterator;
class Interface_EntityIterator;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Performs Checks on Entities, using General Service Library and <br>
//!           Modules to work. Works on one Entity or on a complete Model <br>
class Interface_CheckTool  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates a CheckTool, by calling the General Service Library <br>
//!           and Modules, selected through a Protocol, to work on a Model <br>
//!           Moreover, Protocol recognizes Unknown Entities <br>
Standard_EXPORT Interface_CheckTool(const Handle(Interface_InterfaceModel)& model,const Handle(Interface_Protocol)& protocol);

//! Creates a CheckTool, by calling the General Service Library <br>
//!           and Modules, selected through a Protocol, to work on a Model <br>
//!           Protocol and so on are taken from the Model (its GTool) <br>
Standard_EXPORT Interface_CheckTool(const Handle(Interface_InterfaceModel)& model);

//! Creates a CheckTool from a Graph. The Graph contains a Model <br>
//!           which designates a Protocol: they are used to create ShareTool <br>
Standard_EXPORT Interface_CheckTool(const Interface_Graph& graph);


Standard_EXPORT Interface_CheckTool(const Handle(Interface_HGraph)& hgraph);

//! Fills as required a Check with the Error and Warning messages <br>
//!           produced by Checking a given Entity. <br>
//!           For an Erroneous or Corrected Entity : Check build at Analyse <br>
//!           time; else, Check computed for Entity (Verify integrity), can <br>
//!           use a Graph as required to control context <br>
Standard_EXPORT   void FillCheck(const Handle(Standard_Transient)& ent,const Interface_ShareTool& sh,Handle(Interface_Check)& ach) ;

//! Utility method which Prints the content of a Check <br>
Standard_EXPORT   void Print(const Handle(Interface_Check)& ach,Standard_OStream& S) const;

//! Simply Lists all the Checks and the Content (messages) and the <br>
//!           Entity, if there is, of each Check <br>
//!           (if all Checks are OK, nothing is Printed) <br>
Standard_EXPORT   void Print(const Interface_CheckIterator& list,Standard_OStream& S) const;

//! Returns the Check associated to an Entity identified by <br>
//!           its Number in a Model. <br>
Standard_EXPORT   Handle_Interface_Check Check(const Standard_Integer num) ;

//! Checks if any Error has been detected (CheckList not empty) <br>
//!           Returns normally if none, raises exception if some exists. <br>
//!           It reuses the last computations from other checking methods, <br>
//!           unless the argument <resest> is given True <br>
Standard_EXPORT   void CheckSuccess(const Standard_Boolean reset = Standard_False) ;

//! Returns list of all "remarkable" informations, which include : <br>
//!           - GlobalCheck, if not empty <br>
//!           - Error Checks, for all Errors (Verify + Analyse) <br>
//!           - also Corrected Entities <br>
//!           - and Unknown Entities : for those, each Unknown Entity is <br>
//!             associated to an empty Check (it is neither an Error nor a <br>
//!             Correction, but a remarkable information) <br>
Standard_EXPORT   Interface_CheckIterator CompleteCheckList() ;

//! Returns list of all Errors detected <br>
//!           Note that presence of Unknown Entities is not an error <br>
//!           Cumulates : GlobalCheck if error + <br>
//!             AnalyseCheckList + VerifyCheckList <br>
Standard_EXPORT   Interface_CheckIterator CheckList() ;

//! Returns list of errors dectected at Analyse time (syntactic) <br>
//!           (note that GlobalCheck is not in this list) <br>
Standard_EXPORT   Interface_CheckIterator AnalyseCheckList() ;

//! Returns list of integrity constraints errors (semantic) <br>
//!           (note that GlobalCheck is not in this list) <br>
Standard_EXPORT   Interface_CheckIterator VerifyCheckList() ;

//! Returns list of Corrections (includes GlobalCheck if corrected) <br>
Standard_EXPORT   Interface_CheckIterator WarningCheckList() ;

//! Returns list of Unknown Entities <br>
//!           Note that Error and Erroneous Entities are not considered <br>
//!           as Unknown <br>
Standard_EXPORT   Interface_EntityIterator UnknownEntities() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Interface_GTool thegtool;
Interface_ShareTool theshare;
Standard_Integer thestat;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
