// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IntCurveSurface_IntersectionPoint_HeaderFile
#define _IntCurveSurface_IntersectionPoint_HeaderFile

#ifndef _gp_Pnt_HeaderFile
#include <gp_Pnt.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _IntCurveSurface_TransitionOnCurve_HeaderFile
#include <IntCurveSurface_TransitionOnCurve.hxx>
#endif
class gp_Pnt;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Definition of an interserction point between a <br>
//!          curve and a surface. <br>
class IntCurveSurface_IntersectionPoint  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Empty Constructor. <br>
Standard_EXPORT IntCurveSurface_IntersectionPoint();

//! Create an IntersectionPoint. <br>
Standard_EXPORT IntCurveSurface_IntersectionPoint(const gp_Pnt& P,const Standard_Real USurf,const Standard_Real VSurf,const Standard_Real UCurv,const IntCurveSurface_TransitionOnCurve TrCurv);

//! Set the fields of the current IntersectionPoint. <br>
Standard_EXPORT   void SetValues(const gp_Pnt& P,const Standard_Real USurf,const Standard_Real VSurf,const Standard_Real UCurv,const IntCurveSurface_TransitionOnCurve TrCurv) ;

//! Get the fields of the current IntersectionPoint. <br>
Standard_EXPORT   void Values(gp_Pnt& P,Standard_Real& USurf,Standard_Real& VSurf,Standard_Real& UCurv,IntCurveSurface_TransitionOnCurve& TrCurv) const;
//! returns the geometric point. <br>
 const gp_Pnt& Pnt() const;
//! returns the U parameter on the surface. <br>
  Standard_Real U() const;
//! returns the V parameter on the surface. <br>
  Standard_Real V() const;
//! returns the parameter on the curve. <br>
  Standard_Real W() const;
//! returns the Transition of the point. <br>
  IntCurveSurface_TransitionOnCurve Transition() const;

//! Dump all the fields. <br>
Standard_EXPORT   void Dump() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
gp_Pnt myP;
Standard_Real myUSurf;
Standard_Real myVSurf;
Standard_Real myUCurv;
IntCurveSurface_TransitionOnCurve myTrOnCurv;


};


#include <IntCurveSurface_IntersectionPoint.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
