// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESToBRep_HeaderFile
#define _IGESToBRep_HeaderFile

#ifndef _Handle_IGESToBRep_AlgoContainer_HeaderFile
#include <Handle_IGESToBRep_AlgoContainer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_IGESData_IGESEntity_HeaderFile
#include <Handle_IGESData_IGESEntity.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfTransient_HeaderFile
#include <Handle_TColStd_HSequenceOfTransient.hxx>
#endif
class IGESToBRep_AlgoContainer;
class IGESData_IGESEntity;
class TopoDS_Shape;
class TColStd_HSequenceOfTransient;
class TopoDS_Edge;
class TopoDS_Face;
class IGESToBRep_CurveAndSurface;
class IGESToBRep_BasicSurface;
class IGESToBRep_BasicCurve;
class IGESToBRep_TopoSurface;
class IGESToBRep_TopoCurve;
class IGESToBRep_BRepEntity;
class IGESToBRep_IGESBoundary;
class IGESToBRep_Reader;
class IGESToBRep_Actor;
class IGESToBRep_AlgoContainer;
class IGESToBRep_ToolContainer;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Provides tools in order to transfer IGES entities <br>
//!         to CAS.CADE. <br>
class IGESToBRep  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates and initializes default AlgoContainer. <br>
Standard_EXPORT static  void Init() ;

//! Sets default AlgoContainer <br>
Standard_EXPORT static  void SetAlgoContainer(const Handle(IGESToBRep_AlgoContainer)& aContainer) ;

//! Returns default AlgoContainer <br>
Standard_EXPORT static  Handle_IGESToBRep_AlgoContainer AlgoContainer() ;

//! Return True if the IGESEntity can be transfered by <br>
//!          TransferCurveAndSurface. <br>
//!          ex: All IGESEntity from IGESGeom <br>
Standard_EXPORT static  Standard_Boolean IsCurveAndSurface(const Handle(IGESData_IGESEntity)& start) ;

//! Return True if the IGESEntity can be transfered by <br>
//!          TransferBasicCurve. <br>
//!          ex: CircularArc, ConicArc, Line, CopiousData, <br>
//!              BSplineCurve, SplineCurve... from IGESGeom : <br>
//!              104,110,112,126 <br>
Standard_EXPORT static  Standard_Boolean IsBasicCurve(const Handle(IGESData_IGESEntity)& start) ;

//! Return True if the IGESEntity can be transfered by <br>
//!          TransferBasicSurface. <br>
//!          ex: BSplineSurface, SplineSurface... from IGESGeom : <br>
//!              114,128 <br>
Standard_EXPORT static  Standard_Boolean IsBasicSurface(const Handle(IGESData_IGESEntity)& start) ;

//! Return True if the IGESEntity can be transfered by <br>
//!          TransferTopoCurve. <br>
//!          ex: all Curves from IGESGeom : <br>
//!              all basic curves,102,130,142,144 <br>
Standard_EXPORT static  Standard_Boolean IsTopoCurve(const Handle(IGESData_IGESEntity)& start) ;

//! Return True if the IGESEntity can be transfered by <br>
//!          TransferTopoSurface. <br>
//!          ex: All Surfaces from IGESGeom : <br>
//!              all basic surfaces,108,118,120,122,141,143 <br>
Standard_EXPORT static  Standard_Boolean IsTopoSurface(const Handle(IGESData_IGESEntity)& start) ;

//! Return True if the IGESEntity can be transfered by <br>
//!          TransferBRepEntity. <br>
//!          ex: VertexList, EdgeList, Loop, Face, Shell, <br>
//!              Manifold Solid BRep Object from IGESSolid : <br>
//!              502, 504, 508, 510, 514, 186. <br>
Standard_EXPORT static  Standard_Boolean IsBRepEntity(const Handle(IGESData_IGESEntity)& start) ;

//! Creates  a file  Shape_'number' with the shape being <br>
//!          able to be restored by Draw. <br>
Standard_EXPORT static  void WriteShape(const TopoDS_Shape& shape,const Standard_Integer number) ;


Standard_EXPORT static  Standard_Integer IGESCurveToSequenceOfIGESCurve(const Handle(IGESData_IGESEntity)& curve,Handle(TColStd_HSequenceOfTransient)& sequence) ;


Standard_EXPORT static  Standard_Boolean TransferPCurve(const TopoDS_Edge& fromedge,const TopoDS_Edge& toedge,const TopoDS_Face& face) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //

friend class IGESToBRep_CurveAndSurface;
friend class IGESToBRep_BasicSurface;
friend class IGESToBRep_BasicCurve;
friend class IGESToBRep_TopoSurface;
friend class IGESToBRep_TopoCurve;
friend class IGESToBRep_BRepEntity;
friend class IGESToBRep_IGESBoundary;
friend class IGESToBRep_Reader;
friend class IGESToBRep_Actor;
friend class IGESToBRep_AlgoContainer;
friend class IGESToBRep_ToolContainer;

};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
