// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESSelect_CounterOfLevelNumber_HeaderFile
#define _IGESSelect_CounterOfLevelNumber_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IGESSelect_CounterOfLevelNumber_HeaderFile
#include <Handle_IGESSelect_CounterOfLevelNumber.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfInteger_HeaderFile
#include <Handle_TColStd_HArray1OfInteger.hxx>
#endif
#ifndef _IFSelect_SignCounter_HeaderFile
#include <IFSelect_SignCounter.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
#ifndef _Handle_Interface_InterfaceModel_HeaderFile
#include <Handle_Interface_InterfaceModel.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfInteger_HeaderFile
#include <Handle_TColStd_HSequenceOfInteger.hxx>
#endif
#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class TColStd_HArray1OfInteger;
class Standard_Transient;
class Interface_InterfaceModel;
class TColStd_HSequenceOfInteger;
class TCollection_HAsciiString;


//! This class gives information about Level Number. It counts <br>
//!           entities according level number, considering also the <br>
//!           multiple level (see the class LevelList) for which an entity <br>
//!           is attached to each of the listed levels. <br>
//! <br>
//!           Data are available, as level number, or as their alphanumeric <br>
//!           counterparts ("LEVEL nnnnnnn", " NO LEVEL", " LEVEL LIST") <br>
class IGESSelect_CounterOfLevelNumber : public IFSelect_SignCounter {

public:
 // Methods PUBLIC
 // 

//! Creates a CounterOfLevelNumber, clear, ready to work <br>
//!           <withmap> and <withlist> are transmitted to SignCounter <br>
Standard_EXPORT IGESSelect_CounterOfLevelNumber(const Standard_Boolean withmap = Standard_True,const Standard_Boolean withlist = Standard_False);

//! Resets already memorized informations : also numeric data <br>
Standard_EXPORT virtual  void Clear() ;

//! Adds an entity by considering its lrvrl number(s) <br>
//!	         A level is added both in numeric and alphanumeric form, <br>
//!           i.e. LevelList gives "LEVEL LIST", others (no level or <br>
//!           positive level) displays level number on 7 digits (C : %7d) <br>
//!           Remark : an entity attached to a Level List is added for <br>
//!           " LEVEL LIST", and for each of its constituant levels <br>
Standard_EXPORT virtual  void AddSign(const Handle(Standard_Transient)& ent,const Handle(Interface_InterfaceModel)& model) ;

//! The internal action to record a new level number, positive, <br>
//!           null (no level) or negative (level list) <br>
Standard_EXPORT   void AddLevel(const Handle(Standard_Transient)& ent,const Standard_Integer level) ;

//! Returns the highest value found for a level number <br>
Standard_EXPORT   Standard_Integer HighestLevel() const;

//! Returns the number of times a level is used, <br>
//!           0 if it has not been recorded at all <br>
//!           <level> = 0 counts entities attached to no level <br>
//!           <level> < 0 counts entities attached to a LevelList <br>
Standard_EXPORT   Standard_Integer NbTimesLevel(const Standard_Integer level) const;

//! Returns the ordered list of used positive Level numbers <br>
Standard_EXPORT   Handle_TColStd_HSequenceOfInteger Levels() const;

//! Determines and returns the value of the signature for an <br>
//!           entity as an HAsciiString. Redefined, gives the same result <br>
//!           as AddSign, see this method ("LEVEL LIST" or "nnnnnnn") <br>
Standard_EXPORT virtual  Handle_TCollection_HAsciiString Sign(const Handle(Standard_Transient)& ent,const Handle(Interface_InterfaceModel)& model) const;

//! Prints the counts of items (not the list) then the Highest <br>
//!           Level Number recorded <br>
Standard_EXPORT virtual  void PrintCount(Standard_OStream& S) const;
//Standard_EXPORT ~IGESSelect_CounterOfLevelNumber();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer thehigh;
Standard_Integer thenblists;
Handle_TColStd_HArray1OfInteger thelevels;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
