// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Dynamic_Method_HeaderFile
#define _Dynamic_Method_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Dynamic_Method_HeaderFile
#include <Handle_Dynamic_Method.hxx>
#endif

#ifndef _Handle_Dynamic_VariableNode_HeaderFile
#include <Handle_Dynamic_VariableNode.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Handle_Dynamic_Variable_HeaderFile
#include <Handle_Dynamic_Variable.hxx>
#endif
#ifndef _Handle_Dynamic_Parameter_HeaderFile
#include <Handle_Dynamic_Parameter.hxx>
#endif
#ifndef _Dynamic_ModeEnum_HeaderFile
#include <Dynamic_ModeEnum.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class Dynamic_VariableNode;
class TCollection_AsciiString;
class Dynamic_Variable;
class Dynamic_Parameter;


//! This class  is  a  root class  available   for the <br>
//!          definition of  methods and  also  for  using  them <br>
//!          throughout method  instances. The logical name of <br>
//!          the method and   the signature as  a collection of <br>
//!          variables is stored in it. <br>
class Dynamic_Method : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Returns the type  of object which is  the  name of the <br>
//!          function definition. <br>
Standard_EXPORT virtual  TCollection_AsciiString Type() const = 0;

//! Returns the  first variable node   of the Method which <br>
//!          contains a variable. <br>
Standard_EXPORT   Handle_Dynamic_VariableNode FirstVariableNode() const;

//! Returns true if there is a variable with <avariable> <br>
//!          as name, false otherwise. <br>
Standard_EXPORT   Standard_Boolean Variable(const Standard_CString avariable) const;

//! Adds another  variable <avariable>  to the sequence of <br>
//!          variable definitions. <br>
Standard_EXPORT   void Variable(const Handle(Dynamic_Variable)& avariable) ;

//! Returns  True,   if there  is   a variable <avariable> <br>
//!          previously  stored in the  instance  <me> and there is <br>
//!          the corresponding parameter    value   in the   output <br>
//!          argument <aparameter>, False otherwise. <br>
Standard_EXPORT   Standard_Boolean Value(const Standard_CString aname,Handle(Dynamic_Parameter)& aparameter,Dynamic_ModeEnum& amode) const;

//! Returns True, if  there  is a variable   named <aname> <br>
//!          previously stored in the  instance of <me> and returns <br>
//!          the   corresponding variable  in  the output  argument <br>
//!          <avariable>, False otherwise. <br>
Standard_EXPORT   Standard_Boolean Value(const Standard_CString aname,Handle(Dynamic_Variable)& avariable) const;

//! Useful for debugging. <br>
Standard_EXPORT virtual  void Dump(Standard_OStream& astream) const;
//Standard_EXPORT ~Dynamic_Method();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 

//! It is the constructor of this deferred class <br>
Standard_EXPORT Dynamic_Method();


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Dynamic_VariableNode thefirstvariablenode;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
