// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepTools_Modifier_HeaderFile
#define _BRepTools_Modifier_HeaderFile

#ifndef _TopTools_DataMapOfShapeShape_HeaderFile
#include <TopTools_DataMapOfShapeShape.hxx>
#endif
#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_BRepTools_Modification_HeaderFile
#include <Handle_BRepTools_Modification.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Standard_NullObject;
class Standard_NoSuchObject;
class TopoDS_Shape;
class BRepTools_Modification;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class BRepTools_Modifier  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates an empty Modifier. <br>
Standard_EXPORT BRepTools_Modifier();

//! Creates a modifier on the shape <S>. <br>
Standard_EXPORT BRepTools_Modifier(const TopoDS_Shape& S);

//! Creates a modifier on  the shape <S>, and performs <br>
//!          the modifications described by <M>. <br>
Standard_EXPORT BRepTools_Modifier(const TopoDS_Shape& S,const Handle(BRepTools_Modification)& M);

//! Initializes the modifier with the shape <S>. <br>
Standard_EXPORT   void Init(const TopoDS_Shape& S) ;

//! Performs the modifications described by <M>. <br>
Standard_EXPORT   void Perform(const Handle(BRepTools_Modification)& M) ;
//! Returns Standard_True if the modification has <br>
//!          been computed successfully. <br>
//! <br>
  Standard_Boolean IsDone() const;
//! Returns the modified shape corresponding to <S>. <br>
 const TopoDS_Shape& ModifiedShape(const TopoDS_Shape& S) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void Put(const TopoDS_Shape& S) ;


Standard_EXPORT   Standard_Boolean Rebuild(const TopoDS_Shape& S,const Handle(BRepTools_Modification)& M,const Standard_Real Tolerance) ;


 // Fields PRIVATE
 //
TopTools_DataMapOfShapeShape myMap;
TopoDS_Shape myShape;
Standard_Boolean myDone;


};


#include <BRepTools_Modifier.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
