// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BOP_SolidClassifier_HeaderFile
#define _BOP_SolidClassifier_HeaderFile

#ifndef _BOP_PSoClassif_HeaderFile
#include <BOP_PSoClassif.hxx>
#endif
#ifndef _BOP_IndexedDataMapOfSolidClassifier_HeaderFile
#include <BOP_IndexedDataMapOfSolidClassifier.hxx>
#endif
#ifndef _TopAbs_State_HeaderFile
#include <TopAbs_State.hxx>
#endif
#ifndef _TopoDS_Shell_HeaderFile
#include <TopoDS_Shell.hxx>
#endif
#ifndef _TopoDS_Solid_HeaderFile
#include <TopoDS_Solid.hxx>
#endif
#ifndef _BRep_Builder_HeaderFile
#include <BRep_Builder.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class TopoDS_Solid;
class gp_Pnt;
class TopoDS_Shell;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//!  The  auxiliary class to classify points with <br>
//!  a solid <br>
//! <br>
class BOP_SolidClassifier  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Empty  Constructor <br>
Standard_EXPORT BOP_SolidClassifier();


//! Clear internal state <br>
Standard_EXPORT   void Clear() ;


//! Modifier <br>
Standard_EXPORT   void LoadSolid(const TopoDS_Solid& aS) ;


//! Compute the position of point <P> regarding with the <br>
//! geometric domain of the solid <S>. <br>
Standard_EXPORT   TopAbs_State Classify(const TopoDS_Solid& aS,const gp_Pnt& aP,const Standard_Real aTol) ;


//! Modifier <br>
Standard_EXPORT   void LoadShell(const TopoDS_Shell& S) ;


//! Compute the position of point <P> regarding with the <br>
//! geometric domain of the shell <S>. <br>
Standard_EXPORT   TopAbs_State Classify(const TopoDS_Shell& aS,const gp_Pnt& aP,const Standard_Real aTol) ;


//! Returns computed 3D-State <br>
Standard_EXPORT   TopAbs_State State() const;


//! Destructor <br>
Standard_EXPORT   void Destroy() ;
Standard_EXPORT virtual ~BOP_SolidClassifier(){Destroy();}





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
BOP_PSoClassif myPClassifier;
BOP_IndexedDataMapOfSolidClassifier myClassifierMap;
TopAbs_State myState;
TopoDS_Shell myShell;
TopoDS_Solid mySolid;
BRep_Builder myBuilder;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
