/*
 *   mwwttcus.h -- Mwave WorldTrade Customization defines for the ini file
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#if !defined(MWWTTBL_MWWTTCUS_H)
#define MWWTTBL_MWWTTCUS_H 1

/*This is the minimum power setting (dBm/10) allowed by the mwwttbl lib.*/
/*The maxiumum power allowed is controlled by the MAX_PWR setting in each*/
/*WT Table upto a maximum of 0 dBm.*/
#define MIN_POWER_ALLOWED -600  /*60dBm*/

/* Prefix to the section in the Mwave.ini file containing WT Table overrides.*/
/* The full section name is MWCOUNTRYx where x is the Mwave country number from*/
/* mwwttbl.h with no leading zeros.*/
#define MWCOUNTRY  "MWCOUNTRY"

/* Override for the Modem Tx power level.  This value is less than 0*/
/* in units of 1/10 dBm.  For example, -100 is -10dBm.  Note that hardware*/
/* platforms might not allow the full range up to 0dBm.*/
#define MODEMTX    "ModemTx"

/* Override for the Fax Tx power level.  This value is less than 0*/
/* in units of 1/10 dBm.  For example, -100 is -10dBm.  Note that hardware*/
/* platforms might not allow the full range up to 0dBm.*/
#define FAXTX      "FaxTx"

/* Override for the Speakerphone Tx power level.  Range is 15 to -15 corresponding*/
/* to dB difference from the nominal 0dB level.*/
#define SPKRPHTX   "SkprphTx"

/* Override for the Greeting/Message Tx power level.  Range is 15 to -15*/
/* corresponding to dB difference from the nominal 0dB level.  Note that*/
/* higher levels will cause difficulty detecting calling tones during*/
/* discrimination.*/
#define GREETTX    "GreetTx"

/* Override for the calling tones Tx power level.  This value is less than*/
/* 0 in units of 1/10 dBm.  For example, -100 is -10dBm.  Note that hardware*/
/* platforms might not allow the full range up to 0dBm.*/
#define TONETX     "ToneTx"

/* Override for the TAM beep which is a prompt for recording messages.  This*/
/* value is less than 0 in units of 1/10 dBm.  For example, -100 is -10dBm.*/
/* Note that hardware platforms might not allow the full range up to 0dBm.*/
/* Also, TAPI plays a wave file for the beep which is controlled by GREETTX.*/
#define TAMBEEPTX  "TAMbeepTx"

/* Override for the Conversation record beep which is played while recording*/
/* a conversation.  This value is less than 0 in units of 1/10 dBm.  Note that*/
/* hardware platforms might not allow the full range up to 0dBm.*/
#define CONVBEEPTX "ConvBeepTx"

/* Override for the DTMF power levels.  This value is less than 0 in units*/
/* of 1/10 dBm. Typical is -60 for high and -80 for low or -90 for high*/
/* and -110 for low.  This would be -6,-8dBm or -9,-11dBm groups.*/
#define DTMFTXHIGH  "DTMFtxHigh"
#define DTMFTXLOW   "DTMFtxLow"

/* Override for the Pulse Dial make and break times.  The make + break time*/
/* creates the number of pulses per second.  Times are in milliseconds.*/
#define PDMAKE     "PDmake"
#define PDBREAK    "PDbreak"

/* Override for the Pulse Dial InterDigit Delay.  Time is in milliseconds.*/
#define PDIDD      "PDIDD"

/* Override for the Flash Hook time in milliseconds.*/
#define FH         "FH"

/* Override for the Microphone gains in dB.  Microphone gains #1 are used by*/
/* MCI Phone.  Valid range is 0 to 100.*/
#define MICMIN1    "MicMin1"
#define MICNOM1    "MicNom1"
#define MICMAX1    "MicMax1"


/* Override for the Microphone gains in dB.  Microphone gains #2 are used by*/
/* the TAPI code.  Valid range is 0 to 100.*/
#define MICMIN2    "MicMin2"
#define MICNOM2    "MicNom2"
#define MICMAX2    "MicMax2"


/* Override for the Speaker Max Volume for MCI Phone.  Valid range is 0 to 65535.*/
/* These numbers represent the digital maximum volume allowed.  A high number is*/
/* expected.*/
#define SPKR1      "Spkr1"

/* Override for the Speaker Max Volume for the TAPI code.  Valid range is 0 to 65535.*/
/* These numbers represent the dB setting for a speaker volume.  A low number*/
/* is expected.*/
#define SPKR2      "Spkr2"

#endif

