/*
 *   dspstcmp.c -- Routines that compare strings in the DSP Manager code
 *
 *  Written By: Mike Sullivan IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#include "dspmgr.h"

#include <string.h>
#include "dspstcmp.h"

/****************************************************************************/
/* If case switch is = 0 then case sensitivity is turned off                */
/* If case switch is = 1 then case sensitivity is turned on                 */
/****************************************************************************/

static int caseswitch = 1;

/**************************START OF SPECIFICATIONS **************************/
/*                                                                          */
/* SUBROUTINE NAME: strcmpnull                                              */
/*                                                                          */
/* FUNCTION:                                                                */
/*                                                                          */
/* INPUT:                                                                   */
/*                                                                          */
/* OUTPUT:                                                                  */
/*                                                                          */
/* SIDE EFFECTS: (NONE)                                                     */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/* 00) 03/23/93  KJF   Created from Ver. 299 (Refer to archive for history) */
/*                                                                          */
/************************** END OF SPECIFICATIONS ***************************/

int mwstrcmpnull(const char *Arg1,const char *Arg2)

{
   if (Arg1 == NULL || Arg2 == NULL) {

      /* At least one pointer is null, so cant use strcmp                   */

      if (Arg1 == Arg2)
         return 0;                     /* Compare is equal                  */
      else
         if (Arg2 == NULL)
            return 1;                  /* Arg1 > NULL                       */
         else
            return -1;                 /* NULL < Arg2                       */
   }
   else                                /* Neither pointer is null so use    */
                                       /* strcmp                            */
      return  mwstrcmp(Arg1, Arg2);
}

/**************************START OF SPECIFICATIONS **************************/
/*                                                                          */
/* SUBROUTINE NAME:  mwstrcmp                                               */
/*                                                                          */
/* FUNCTION:                                                                */
/*                                                                          */
/* INPUT:                                                                   */
/*                                                                          */
/* OUTPUT:                                                                  */
/*                                                                          */
/* SIDE EFFECTS: (NONE)                                                     */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/*                                                                          */
/************************** END OF SPECIFICATIONS ***************************/

int mwstrcmp(const char *Arg1,const char *Arg2)
{
   if (caseswitch == 1)
      return (strcmp(Arg1, Arg2));
   else
      return (strcasecmp(Arg1, Arg2));
}

/**************************START OF SPECIFICATIONS **************************/
/*                                                                          */
/* SUBROUTINE NAME:  SetCase                                                */
/*                                                                          */
/* FUNCTION:                                                                */
/*                                                                          */
/* INPUT:                                                                   */
/*                                                                          */
/* OUTPUT:                                                                  */
/*                                                                          */
/* SIDE EFFECTS: (NONE)                                                     */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/*                                                                          */
/************************** END OF SPECIFICATIONS ***************************/

int SetCase(int newcase)
{
   int        oldcase;

   oldcase = caseswitch;
   caseswitch = newcase;
   return (oldcase);
}
