/*  -*- c -*-  */
/* -------------------------------------------------------------------- *
**  copyright (c) 1995 ipvr stuttgart and thomas harrer
** -------------------------------------------------------------------- *
**
**  libhelp
**
**  a comprehensive hypertext help system for OSF/Motif(tm) applications. 
**  based on libhtmlw from NCSA Mosaic(tm) version 2.4
**
**  written by thomas harrer
**  e-mail: Thomas.Harrer@rus.uni-stuttgart.de
**  
** -------------------------------------------------------------------- *
*h  $Id: image.h,v 1.11 1995/06/28 12:59:30 thomas Exp $
** -------------------------------------------------------------------- *
**
*h  module:		image.h
**
**  contents:		exportet items for image handling (module image.c).
**
**  interface:		#include "image.h"
**
** -------------------------------------------------------------------- *
**  license and copying issues:
**
**  this software is free; you can redistribute it and/or modify it 
**  under terms similar to the gnu general public license (version 1 
**  or any later version published by the free software foundation). 
**  see the file Licence for more details.
**
**  this program is distributed in the hope that it will be useful,
**  but without any warranty; without even the implied warranty of
**  merchantability or fitness for a particular purpose.  
** -------------------------------------------------------------------- */
#ifndef _IMAGE_H_
#define _IMAGE_H_ 1

#include <X11/Intrinsic.h>

/* -------------------------------------------------------------------- *
*g  prototype
** -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- *
*p  procedure-name:	image_resolve
**
**  purpose:		Image resolution function.
**			called by the html widget if image ref occurs
** -------------------------------------------------------------------- *
**  args:		name of image (without help-path).	
**  return type:	ImageInfo*
**  error handling.:	returns NULL if image is not loadable.
** -------------------------------------------------------------------- */
ImageInfo*
image_resolve (/* i  */ Widget 		w,
	       /* i  */ char* 		src,
	       /* i  */ unsigned long 	html_no);

/* -------------------------------------------------------------------- *
*g ------------ small information functions ---------------------------
** -------------------------------------------------------------------- */
void icache_flush (void);
int the_cache_mem (void);
int the_cache_size (void);
int the_cache_default_size (void);
int the_colors (void);

/* -------------------------------------------------------------------- *
*g  macros
** -------------------------------------------------------------------- */
#ifndef IMG_CACHE_SIZE
# define IMG_CACHE_SIZE 8
#endif /* !IMG_CACHE_SIZE */

#ifndef COLORS_PER_IMAGE
# define COLORS_PER_IMAGE 50 
#endif /* !COLORS_PER_IMAGE */

#endif /* !_IMAGE_H_ */
/* -------------------------------------------------------------------- *
*l  emacs:
**  local variables:
**  mode:		c
**  outline-regexp:	"\*[HGPLT]"
**  comment-column:	32
**  eval:		(outline-minor-mode t)
**  end:
** -------------------------------------------------------------------- */
