#!/usr/bin/perl

$|=1;
###############################################################
# Copyright Sebastien Joncheray                               #
#  info@perl-gratuit.com, info@raynette.com                   #
# GOAL : RUN STATS ON BSD MACHINES                            #
# Each time this script is executed, all stats are done       #
#                                                             #
# This script needs to be modified to fit your needs,         #
# especially because of the $ENV{HOME} variable (probably to  #
# be removed)                                                 #
#                                                             #
# You also may need to remove :                               #
# system ("rm","-f","-R","$ENV{HOME}/$docroot{$vhost}/stats/btn");
# which was made to ensure compatibility for previous version #
# of http-analyze.                                            #
###############################################################

#### SETTINGS : ####
$httpdconf="$ENV{HOME}/usr/local/etc/httpd/conf/httpd.conf";
%log=();			# path to the log file, for each virtual host
%docroot=();			# path to DocumentRoot , for each virtual host
####################


&getserverlist;			# get the list of virtual hosts and log files (fill %log and %docroot).
&delete_doubles;		# delete virtual hosts in double
&arrange_all_path;		# add an absolute path before each access_log relative path

  
# let's do the statistics rigth now for each virtual host
foreach $vhost (keys(%log)) {
  if ( ($log{"$vhost"} ne '') && ($docroot{"$vhost"} ne '')  && (-e "$ENV{HOME}/$log{$vhost}") && (-e "$ENV{HOME}/$docroot{$vhost}") ) {
    # LOOKS GOOD, log file exists, and document root too...
    #print ("$vhost :\n      $log{$vhost}\n      $docroot{$vhost}\n OK.\n");

    # is there a /stats dir yet ?
    if (!(-e "$ENV{HOME}/$docroot{$vhost}/stats")) {
      &create_stats_dir ($vhost);
    }


    system ("rm","-f","-R","$ENV{HOME}/$docroot{$vhost}/stats/btn");
    # The above line is only neccesary for adarweb servers.


    system ("virtual","/usr/local/lib/http-analyze/http-analyze",
     "-c","/usr/local/lib/http-analyze/stats-platinum.conf",
     "-mf", 
     "-l","/usr/local/lib/http-analyze",
      "-o", "$docroot{$vhost}/stats",
      "-U", "$vhost", "-S", "$vhost", 
      "$log{$vhost}");
  }
}

1;





################################################
sub getserverlist {
local ($line,$vhost,$log);

  # OPEN HTTPD.CONF FILE
  open (A,"$httpdconf") || (die "$httpdconf error:$!");
  $vhost='';

  # READ EACH LINE.
  while ($line=<A>) {
    chop ($line);
    if ($line=~ /^<[vV]irtual[hH]ost\s*([A-Za-z0-9.-]*)\s*.*>/) {
      ## on a trouv un nouveau serveur
      $vhost=$1;
      next;
    }
    if ($line=~ /^<[hH]ost\s*([A-Za-z0-9.-]*)\s*>/) {
      ## on a trouv un nouveau serveur
      $vhost=$1;
      next;
    }
    if ($line=~ /^<\/[vV]irtual[hH]ost>/) {
      $vhost = "";
    }
    if ($line=~ /^<\/[hH]ost>/) {
      $vhost = "";
    }

    if ( ($vhost ne "") && ($line=~ /^[Dd]ocument[Rr]oot/)) {
      $line=~ s/[Dd]ocument[Rr]oot\s+//;
      $docroot{$vhost} = $line;
      next;
    }
    if (($vhost ne "") && ($line=~ /^[Tt]ransfer[Ll]og/)) {
      $line=~ s/[Tt]ransfer[Ll]og\s+//;
      $log{$vhost} = $line;	
      next;
    }
  }
  close (A);
}
################################################
sub delete_doubles {
  foreach $key (keys(%log)) {
    if ( ($key=~ /^www\.(.*)/) && ($log{$1} ne '') ) {
      delete ($log{"$key"});
      delete ($docroot{"$key"});
    }
  }
}
################################################
sub arrange_all_path {
local ($vhost);

  foreach $vhost (%log) {
    if ($log{"$vhost"} ne '') {
      $log{"$vhost"}='/www/'.$log{"$vhost"};
    }
  }

}
################################################
sub create_stats_dir {
local ($vhost)=@_;
  mkdir ("$ENV{HOME}/$docroot{$vhost}/stats",0777);
  #  symlink ("/usr/local/lib/http-analyze/files/btn","$ENV{HOME}/$docroot{$vhost}/stats/btn") || print "\n$!\n";
  # symlink is no more usefull, since http-analyze v2.3 does it by itself
}
################################################
1;
