/*
**
** @(#)$Id: ccvt.c,v 1.4 1994/03/16 18:48:00 shin Exp $
**
** Modified:	Jing-Shin Chang
**		Department of EE, National Tsing-Hua University
**		Hsinchu, Taiwan 30043, ROC
**		shin@hera.ee.nthu.edu.tw, shin@hermes.ee.nthu.edu.tw
** History:
**
**	1993/08/02:
**		- changed to act as a filter
**		- code type spec becomes case insensitive
**	1994/03/12:
**		- modify Get4Byte to avoid Bus Error and binary alignment
**			problem in non-sun3 architecture
**			for EUC codes in the 2nd plane
**	1994/03/17:
**		- modify Put4Byte to avoid Bus Error and binary alignment
**			problem
**	1994/04/16:
**		- pass buffer lengths explicitly to/from Alter() since there
**			might be embedded '\0' in input stream when
**			NOT reading from an ordinary text file (e.g., from
**			a device or a shell).
**	1994/04/21:
**		- fix the Bus/Alignment bugs introduced by returning from a
**			function (who return a structure) without executing
**			a return() statement.
**		- GetNSCPcode, GetIBMHcode are fixed in this way
**		- SymbolTab may have the same potential problem. I am not sure.
**	1994/10/08:
**		- remove useless setjmp() stuffs
**		- use Tch2Tch() to unify the API
**	1994/10/26:
**		- fixed TELegraph_Key bug
*/

static char *rcsid
	= "@(#)$Id: ccvt.c,v 1.4 1994/03/16 18:48:00 shin Exp $";

/*
 *      @(#)code.c      2/15/91 11:03:39
 */
/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 1991                                                       *
 *                                                                           *
 *                  The Workstation Vertical Integration Project, PDD, III   *
 *                                                                           *
 *  Share and Enjoy it.                                                      *
 *  Any part of this program or publication can be reproduced, transmitted,  *
 *  transcribed stored in your system, or translated into any language or    *
 *  computer language, in any form or by any means, electronic, mechanical,  *
 *  magnetic, optical, chemical, biological, and otherwise if you like.      *
 *  Welcome any question.                                                    *
 *                                                                           *
 *          The Workstation Vertical Integration Project, PDD, III           *
 *          8FL., 106, HOPING E. RD., SEC. 2 TAIPEI, TAIWAN, R.O.C.          *
 *          (02) 7377197                                                     *
 *                                                                           *
 *****************************************************************************/

/******************************************************************************
*******************************************************************************
**
** FILE NAME:   code.c
**
** PURPOSE:     convert any string of these Chinese codes(BIG5, IBM 5550,
**              IBM HOST, NSC, EUC, TCA, TELegraph) to the other six.
**
** CONTENTS:    Alter ()
**              GetCode[] ()
**              Seq[] ()
**              Transform[] ()
**              SymbolTab ()
**              Code[] ()
**              PutCode[] ()
**
** AUTHOR:      Dan_Yi Liu
** DATE:        15 February 1991
**
*******************************************************************************
******************************************************************************/
/*****************************************************************************
 *                                                                           *
 *                  The Transformation of Chinese Codes                      *
 *                                                                           *
 *      This program is used to convert an existed file of one of the        *
 *      Chinese codes ( BIG5, IBM 5550, IBM Host, EUC, TCA, TELegraph        *
 *      , NSC(National Standard Code) and NSC (with protocol) ) to an        *
 *      otuput file of the other seven.                                      *
 *                                                                           *
 *****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <setjmp.h>

static short int IBMHOST_tab[1914] = {
        0x0000,0x017c,0x0179,0x00e7,0x00c7,0x017d,0x00f6,0x00da,
        0x00eb,0x00d6,0x01f5,0x01f6,0x0244,0x00f5,0x0254,0x0264,
        0x011c,0x00e9,0x0213,0x0214,0x02cf,0x02d0,0x024f,0x0250,
        0x0251,0x0252,0x0253,0x0190,0x023e,0x024e,0x00dd,0x0217,
        0x01d8,0x0270,0x00cb,0x0273,0x0272,0x0255,0x0265,0x0256,
        0x0266,0x00c9,0x00d9,0x0257,0x0267,0x0238,0x0239,0x013b,
        0x014b,0x0258,0x0268,0x0259,0x0269,0x017a,0x017b,0x0236,
        0x0237,0x025a,0x026a,0x00ca,0x00dc,0x023f,0x026e,0x026f,
        0x00fa,0x0240,0x00c8,0x00ea,0x025b,0x026b,0x0241,0x025c,
        0x025d,0x026d,0x02e0,0x02e1,0x02e2,0x0242,0x00d7,0x015b,
        0x0182,0x00c6,0x00e8,0x00f7,0x00cc,0x00d8,0x00f8,0x025e,
        0x02d8,0x02d9,0x02d3,0x02d4,0x02d7,0x02da,0x02db,0x02dc,
        0x02dd,0x02d5,0x02d6,0x02de,0x02df,0x025f,0x0260,0x02e3,
        0x02e4,0x02e5,0x02e6,0x0271,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x016b,0x016c,0x016d,0x016e,0x016f,
        0x0170,0x0171,0x0172,0x0173,0x0174,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x013c,0x013d,0x013e,0x013f,
        0x0140,0x0141,0x0142,0x0143,0x0144,0x014c,0x014d,0x014e,
        0x014f,0x0150,0x0151,0x0152,0x0153,0x0154,0x015d,0x015e,
        0x015f,0x0160,0x0161,0x0162,0x0163,0x0164,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x00fc,0x00fd,0x00fe,0x00ff,
        0x0100,0x0101,0x0102,0x0103,0x0104,0x010c,0x010d,0x010e,
        0x010f,0x0110,0x0111,0x0112,0x0113,0x0114,0x011d,0x011e,
        0x011f,0x0120,0x0121,0x0122,0x0123,0x0124,0x270f,0x270f,
        0x270f,0x270f,0x023b,0x0274,0x023c,0x0275,0x023d,0x0276,
        0x0245,0x0277,0x0246,0x0278,0x0279,0x02b3,0x027a,0x02b4,
        0x027b,0x02b5,0x027c,0x02b6,0x027d,0x02b7,0x027f,0x02b8,
        0x0280,0x02b9,0x0281,0x02ba,0x0282,0x02bb,0x0283,0x02bc,
        0x0284,0x02bd,0x0285,0x02be,0x024a,0x0286,0x02bf,0x0287,
        0x02c0,0x0288,0x02c1,0x0289,0x028a,0x028b,0x028c,0x028d,
        0x0290,0x02c2,0x02c8,0x0291,0x02c3,0x02c9,0x0292,0x02c4,
        0x02ca,0x0295,0x02c5,0x02cb,0x0296,0x02c6,0x02cc,0x0297,
        0x0298,0x0299,0x029a,0x029b,0x0247,0x029c,0x0248,0x029d,
        0x0249,0x029f,0x02a0,0x02a1,0x02a2,0x02ad,0x02ae,0x024b,
        0x02af,0x02cd,0x02ce,0x023a,0x02b0,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x017f,0x01b8,0x0180,0x01b9,0x0181,0x01ba,0x0189,0x01bb,
        0x018a,0x01bc,0x01bd,0x01f7,0x01be,0x01f8,0x01bf,0x01f9,
        0x01c0,0x01fa,0x01c1,0x01fb,0x01c3,0x01fc,0x01c4,0x01fd,
        0x01c5,0x01fe,0x01c6,0x01ff,0x01c7,0x0200,0x01c8,0x0201,
        0x01c9,0x0202,0x018e,0x01ca,0x0203,0x01cb,0x0204,0x01cc,
        0x0205,0x01cd,0x01ce,0x01cf,0x01d0,0x01d1,0x01d4,0x0206,
        0x020c,0x01d5,0x0207,0x020d,0x01d6,0x0208,0x020e,0x01d9,
        0x0209,0x020f,0x01da,0x020a,0x0210,0x01db,0x01dc,0x01dd,
        0x01de,0x01df,0x018b,0x01e0,0x018c,0x01e1,0x018d,0x01e3,
        0x01e4,0x01e5,0x01e6,0x01f1,0x01f2,0x018f,0x01f3,0x0211,
        0x0212,0x017e,0x01f4,0x020b,0x0191,0x0192,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x0021,0x0022,
        0x0023,0x0024,0x0025,0x0026,0x0027,0x0028,0x0029,0x002a,
        0x002b,0x002c,0x002d,0x002e,0x002f,0x0030,0x0031,0x0032,
        0x0033,0x0034,0x0035,0x0036,0x0037,0x0038,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x0001,0x0002,
        0x0003,0x0004,0x0005,0x0006,0x0007,0x0008,0x0009,0x000a,
        0x000b,0x000c,0x000d,0x000e,0x000f,0x0010,0x0011,0x0012,
        0x0013,0x0014,0x0015,0x0016,0x0017,0x0018,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x007f,0x0080,0x0081,0x0082,
        0x0083,0x0084,0x0085,0x0086,0x0087,0x0088,0x0089,0x008a,
        0x008b,0x008c,0x008d,0x008e,0x008f,0x0090,0x0091,0x0092,
        0x0093,0x0094,0x0095,0x0096,0x0097,0x0098,0x0099,0x009a,
        0x009b,0x009c,0x009d,0x009e,0x009f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x0040,0x0041,0x0042,
        0x0043,0x0044,0x0045,0x0046,0x0047,0x0048,0x0049,0x004a,
        0x004b,0x004c,0x004d,0x004e,0x004f,0x0050,0x0051,0x0052,
        0x0053,0x0054,0x0055,0x0056,0x0057,0x0058,0x0059,0x005a,
        0x005b,0x005c,0x005d,0x005e,0x005f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x02f1,0x02f2,0x02f3,0x02f4,0x02f5,0x02f6,0x02f7,0x02f8,
        0x02f9,0x02fa,0x02fb,0x02fc,0x270f,0x270f,0x270f,0x270f,
        0x0301,0x0302,0x0303,0x0304,0x0305,0x0306,0x0307,0x0308,
        0x0309,0x030a,0x030b,0x030c,0x030d,0x030e,0x030f,0x0310,
        0x0311,0x0312,0x0313,0x0314,0x0315,0x0316,0x0317,0x0318,
        0x0319,0x031a,0x031b,0x031c,0x031d,0x031e,0x031f,0x0320,
        0x0321,0x0322,0x0323,0x0324,0x0325,0x0326,0x0327,0x0328,
        0x0329,0x032a,0x03ad,0x03ae,0x03af,0x03b0,0x03b1,0x03b3,
        0x03b4,0x03b5,0x03b6,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x03bd,0x03be,0x03bf,0x03c0,0x03c1,0x03c2,0x03c3,
        0x03c4,0x03c5,0x03c6,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x03cc,0x03cd,0x03ce,0x03cf,0x03d0,0x03d1,0x03d2,0x03d3,
        0x03d4,0x03d5,0x03d6,0x03d7,0x03d8,0x03d9,0x03da,0x03db,
        0x03dc,0x03dd,0x03de,0x03df,0x03e0,0x03e1,0x03e2,0x03e3,
        0x03e4,0x03e5,0x03e6,0x03e7,0x03e8,0x03e9,0x03ea,0x03eb,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x03ad,0x03ae,0x03af,0x03b0,
        0x03b1,0x03b2,0x03b3,0x03b4,0x03b5,0x03b6,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x03bd,0x03be,0x03bf,0x03c0,
        0x03c1,0x03c2,0x03c3,0x03c4,0x03c5,0x03c6,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x03cc,0x03cd,0x03ce,0x03cf,0x03d0,
        0x03d1,0x03d2,0x03d3,0x03d4,0x03d5,0x03d6,0x03d7,0x03d8,
        0x03d9,0x03da,0x03db,0x03dc,0x03dd,0x03de,0x03df,0x03e0,
        0x03e1,0x03e2,0x03e3,0x03e4,0x03e5,0x03e6,0x03e7,0x03e8,
        0x03e9,0x03ea,0x03eb,0x03ec,0x03ed,0x03ee,0x03ef,0x03f0,
        0x03f1,0x03f2,0x03f3,0x03f4,0x03f5,0x03f6,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x040b,0x040c,0x040d,0x040e,0x040f,0x0410,
        0x270f,0x0412,0x0413,0x0414,0x0415,0x0416,0x0417,0x0418,
        0x0419,0x041a,0x041b,0x041c,0x041d,0x041e,0x041f,0x0420,
        0x270f,0x270f,0x0423,0x0424,0x0425,0x0426,0x270f,0x270f,
        0x0429,0x042a,0x042b,0x042c,0x042d,0x042e,0x042f,0x0430,
        0x0431,0x0432,0x0433,0x0434,0x0435,0x0436,0x0437,0x0438,
        0x0439,0x043a,0x043b,0x043c,0x043d,0x043e,0x043f,0x0440,
        0x0441,0x0442,0x026c,0x270f,0x0445,0x0446,0x0447,0x0448,
        0x0449,0x044a,0x044b,0x044c,0x044d,0x044e,0x044f,0x0450,
        0x270f,0x270f,0x270f,0x0454,0x0455,0x270f,0x270f,0x270f,
        0x0459,0x045a,0x045b,0x045c,0x045d,0x045e,0x045f,0x0460,
        0x0461,0x0462,0x0463,0x0464,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x00b0,0x00b1,0x00b2,0x00b3,0x00b4,0x00b5,0x00b6,
        0x00b7,0x00b8,0x00b9,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,
        0x0077,0x0078,0x0079,0x00db,0x00e6,0x00f9,0x00fb,0x0261,
        0x0262,0x0263 };

static short int IBMIN_tab[1125] = {
        0x0000,0x01f6,0x01f7,0x01f8,0x01f9,0x01fa,0x01fb,0x01fc,
        0x01fd,0x01fe,0x01ff,0x0200,0x0201,0x0202,0x0203,0x0204,
        0x0205,0x0206,0x0207,0x0208,0x0209,0x020a,0x020b,0x020c,
        0x020d,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x01d6,0x01d7,0x01d8,0x01d9,0x01da,0x01db,0x01dc,
        0x01dd,0x01de,0x01df,0x01e0,0x01e1,0x01e2,0x01e3,0x01e4,
        0x01e5,0x01e6,0x01e7,0x01e8,0x01e9,0x01ea,0x01eb,0x01ec,
        0x01ed,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x0265,0x0266,0x0267,0x0268,0x0269,0x026a,0x026b,0x026c,
        0x026d,0x026e,0x026f,0x0270,0x0271,0x0272,0x0273,0x0274,
        0x0275,0x0276,0x0277,0x0278,0x0279,0x027a,0x027b,0x027c,
        0x027d,0x027e,0x027f,0x0280,0x0281,0x0282,0x0283,0x0284,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x0769,0x076a,0x076b,0x076c,0x076d,0x076e,0x076f,0x0770,
        0x0771,0x0772,0x270f,0x270f,0x270f,0x270f,0x270f,0x0234,
        0x0235,0x0236,0x0237,0x0238,0x0239,0x023a,0x023b,0x023c,
        0x023d,0x023e,0x023f,0x0240,0x0241,0x0242,0x0243,0x0244,
        0x0245,0x0246,0x0247,0x0248,0x0249,0x024a,0x024b,0x024c,
        0x024d,0x024e,0x024f,0x0250,0x0251,0x0252,0x0253,0x0254,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x0759,0x075a,0x075b,0x075c,0x075d,0x075e,0x075f,0x0760,
        0x0761,0x0762,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x0051,0x0004,
        0x0042,0x0029,0x003b,0x0022,0x0054,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x0009,0x004e,
        0x0055,0x002a,0x0007,0x0773,0x003c,0x001e,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x0774,0x0003,
        0x0052,0x0011,0x0043,0x0008,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x000d,0x0006,0x0053,
        0x0056,0x0775,0x0040,0x0776,0x00fc,0x00fd,0x00fe,0x00ff,
        0x0100,0x0101,0x0102,0x0103,0x0104,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x0105,0x0106,0x0107,0x0108,
        0x0109,0x010a,0x010b,0x010c,0x010d,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x0010,0x010e,0x010f,0x0110,
        0x0111,0x0112,0x0113,0x0114,0x0115,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x002f,0x00dc,0x00dd,0x00de,0x00df,
        0x00e0,0x00e1,0x00e2,0x00e3,0x00e4,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x0030,0x00e5,0x00e6,0x00e7,0x00e8,
        0x00e9,0x00ea,0x00eb,0x00ec,0x00ed,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x004f,0x270f,0x00ee,0x00ef,0x00f0,
        0x00f1,0x00f2,0x00f3,0x00f4,0x00f5,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x00cb,0x00cc,0x00cd,0x00ce,0x00cf,
        0x00d0,0x00d1,0x00d2,0x00d3,0x00d4,0x270f,0x270f,0x270f,
        0x270f,0x0002,0x0035,0x0036,0x0001,0x0005,0x01c9,0x0178,
        0x017a,0x017c,0x0050,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x017e,0x0180,0x01ba,0x01bc,0x01be,0x019a,0x01c5,
        0x001b,0x01cc,0x01cd,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x0179,0x017b,0x017d,0x017f,0x0181,0x0182,0x0184,0x0186,
        0x0188,0x018a,0x270f,0x018c,0x018e,0x0190,0x0192,0x0194,
        0x0196,0x0198,0x019b,0x019d,0x019f,0x01a1,0x01a2,0x01a3,
        0x01a4,0x01a5,0x270f,0x270f,0x01a6,0x01a9,0x01ac,0x270f,
        0x0020,0x01af,0x01b2,0x01b5,0x01b6,0x01b7,0x01b8,0x01b9,
        0x01bb,0x01bd,0x270f,0x01bf,0x01c0,0x01c1,0x01c2,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x01c3,0x01c4,0x01c6,0x01ca,0x000a,0x000b,0x0183,
        0x0185,0x0187,0x0189,0x018b,0x018d,0x018f,0x0191,0x0193,
        0x0195,0x0197,0x0199,0x019c,0x019e,0x01a0,0x01a7,0x01aa,
        0x01ad,0x01b0,0x01b3,0x01cb,0x01a8,0x01ab,0x01ae,0x01b1,
        0x01b4,0x01c7,0x01c8,0x0012,0x0013,0x270f,0x270f,0x001f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x0037,0x0038,
        0x002d,0x002e,0x016b,0x011a,0x011c,0x011e,0x001c,0x003d,
        0x0041,0x0046,0x004d,0x270f,0x000c,0x0120,0x0122,0x015c,
        0x015e,0x0160,0x013c,0x0167,0x270f,0x270f,0x001d,0x0016,
        0x0017,0x0018,0x0019,0x001a,0x000e,0x0025,0x0027,0x002b,
        0x0031,0x0033,0x0039,0x0044,0x0047,0x0048,0x0057,0x0065,
        0x0066,0x0777,0x0778,0x0779,0x000f,0x0026,0x0028,0x002c,
        0x0032,0x0034,0x003a,0x0045,0x0732,0x0049,0x003e,0x003f,
        0x0021,0x006b,0x0024,0x0023,0x011b,0x011d,0x011f,0x0121,
        0x0123,0x0124,0x0126,0x0128,0x012a,0x012c,0x270f,0x012e,
        0x0130,0x0132,0x0134,0x0136,0x0138,0x013a,0x013d,0x013f,
        0x0141,0x0143,0x0144,0x0145,0x0146,0x0147,0x270f,0x270f,
        0x0148,0x014b,0x014e,0x270f,0x270f,0x0151,0x0154,0x0157,
        0x0158,0x0159,0x015a,0x015b,0x015d,0x015f,0x270f,0x0161,
        0x0162,0x0163,0x0164,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x0165,0x0166,0x0168,
        0x016c,0x270f,0x270f,0x0125,0x0127,0x0129,0x012b,0x012d,
        0x012f,0x0131,0x0133,0x0135,0x0137,0x0139,0x013b,0x013e,
        0x0140,0x0142,0x0149,0x014c,0x014f,0x0152,0x0155,0x270f,
        0x014a,0x014d,0x0150,0x0153,0x0156,0x0169,0x016a,0x0014,
        0x0015,0x270f,0x270f,0x005a,0x005b,0x0061,0x0062,0x005c,
        0x0058,0x0059,0x005d,0x005e,0x005f,0x0060,0x0063,0x0064,
        0x004a,0x004b,0x004c,0x0067,0x0068,0x0069,0x006a,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x05e0,0x05e1,0x05e2,0x05e3,0x05e4,0x05e5,0x05e6,
        0x05e7,0x05e8,0x05e9,0x05ea,0x05eb,0x270f,0x270f,0x270f,
        0x270f,0x05f0,0x05f1,0x05f2,0x05f3,0x05f4,0x05f5,0x05f6,
        0x05f7,0x05f8,0x05f9,0x05fa,0x05fb,0x05fc,0x05fd,0x05fe,
        0x05ff,0x0600,0x0601,0x0602,0x0603,0x0604,0x0605,0x0606,
        0x0607,0x0608,0x0609,0x060a,0x060b,0x060c,0x060d,0x060e,
        0x060f,0x0610,0x0611,0x0612,0x0613,0x0614,0x0615,0x0616,
        0x0617,0x0618,0x0619,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x061a,0x061b,0x061c,
        0x061d,0x061e,0x06a1,0x061f,0x0620,0x0621,0x0622,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x0629,0x062a,0x062b,
        0x062c,0x062d,0x062e,0x062f,0x0630,0x0631,0x0632,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x0638,0x0639,0x063a,0x063b,
        0x063c,0x063d,0x063e,0x063f,0x0640,0x0641,0x0642,0x0643,
        0x0644,0x0645,0x0646,0x0647,0x0648,0x0649,0x064a,0x064b,
        0x064c,0x064d,0x064e,0x064f,0x0650,0x0651,0x0652,0x0653,
        0x0654,0x0655,0x0656,0x0657,0x06db,0x06dc,0x06dd,0x06de,
        0x06df,0x06e0,0x06e1,0x06e2,0x06e3,0x06e4,0x06e5,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,0x270f,
        0x270f,0x270f,0x270f,0x06fa,0x06fb,0x06fc,0x06fd,0x06fe,
        0x06ff,0x270f,0x0701,0x0702,0x0703,0x0704,0x0705,0x0706,
        0x0707,0x0708,0x0709,0x070a,0x070b,0x070c,0x070d,0x070e,
        0x070f,0x270f,0x270f,0x0712,0x0713,0x0714,0x0715,0x270f,
        0x270f,0x0718,0x0719,0x071a,0x071b,0x071c,0x071d,0x071e,
        0x071f,0x0720,0x0721,0x0722,0x0723,0x0724,0x0725,0x0726,
        0x0727,0x0728,0x0729,0x072a,0x072b,0x072c,0x072d,0x072e,
        0x072f,0x0730,0x0731,0x270f,0x270f,0x0734,0x0735,0x0736,
        0x0737,0x0738,0x0739,0x073a,0x073b,0x073c,0x073d,0x073e,
        0x073f,0x270f,0x270f,0x270f,0x0743,0x0744,0x270f,0x270f,
        0x270f,0x0748,0x0749,0x074a,0x074b,0x074c,0x074d,0x074e,
        0x074f,0x0750,0x0751,0x0752,0x0753 };

static short int EBCDIC2ASCIItab[256] = {
            0x00, 0x01, 0x02, 0x03, 0x1A, 0x09, 0x1A, 0x7F,
            0x1A, 0x1A, 0x1A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
            0x10, 0x11, 0x12, 0x13, 0x1A, 0x1A, 0x08, 0x1A,
            0x18, 0x19, 0x1A, 0x1A, 0x1C, 0x1D, 0x1E, 0x1F,
            0x1A, 0x1A, 0x1C, 0x1A, 0x1A, 0x0A, 0x17, 0x1B,
            0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x05, 0x06, 0x07,
            0x1A, 0x1A, 0x16, 0x1A, 0x1A, 0x1E, 0x1A, 0x04,
            0x1A, 0x1A, 0x1A, 0x1A, 0x14, 0x15, 0x1A, 0x1A,
            0x20, 0xA6, 0xE1, 0x80, 0xEB, 0x90, 0x9F, 0xE2,
            0xAB, 0x8B, 0x9B, 0x2E, 0x3C, 0x28, 0x2B, 0x7C,
            0x26, 0xA9, 0xAA, 0x9C, 0xDB, 0xA5, 0x99, 0xE3,
            0xA8, 0x9E, 0x21, 0x24, 0x2A, 0x29, 0x3B, 0x5E,
            0x2D, 0x2F, 0xDF, 0xDC, 0x9A, 0xDD, 0xDE, 0x98,
            0x9D, 0xAC, 0xBA, 0x2C, 0x25, 0x5F, 0x3E, 0x3F,
            0xD7, 0x88, 0x94, 0xB0, 0xB1, 0xB2, 0xFC, 0xD6,
            0xFB, 0x60, 0x3A, 0x23, 0x40, 0x27, 0x3D, 0x22,
            0xF8, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
            0x68, 0x69, 0x96, 0xA4, 0xF3, 0xAF, 0xAE, 0xC5,
            0x8C, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F, 0x70,
            0x71, 0x72, 0x97, 0x87, 0xCE, 0x93, 0xF1, 0xFE,
            0xC8, 0x7E, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78,
            0x79, 0x7A, 0xEF, 0xC0, 0xDA, 0x5B, 0xF2, 0xF9,
            0xB5, 0xB6, 0xFD, 0xB7, 0xB8, 0xB9, 0xE6, 0xBB,
            0xBC, 0xBD, 0x8D, 0xD9, 0xBF, 0x5D, 0xD8, 0xC4,
            0x7B, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
            0x48, 0x49, 0xCB, 0xCA, 0xBE, 0xE8, 0xEC, 0xED,
            0x7D, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, 0x50,
            0x51, 0x52, 0xA1, 0xAD, 0xF5, 0xF4, 0xA3, 0x8F,
            0x5C, 0xE7, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58,
            0x59, 0x5A, 0xA0, 0x85, 0x8E, 0xE9, 0xE4, 0xD1,
            0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
            0x38, 0x39, 0xB3, 0xF7, 0xF0, 0xFA, 0xA7, 0xFF };

static short int ASCII2EBCDICtab[256] = {
            0x00, 0x01, 0x02, 0x03, 0x37, 0x2D, 0x2E, 0x2F,
            0x16, 0x05, 0x25, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
            0x10, 0x11, 0x12, 0x13, 0x3C, 0x3D, 0x32, 0x26,
            0x18, 0x19, 0x3F, 0x27, 0x22, 0x1D, 0x35, 0x1F,
            0x40, 0x5A, 0x7F, 0x7B, 0x5B, 0x6C, 0x50, 0x7D,
            0x4D, 0x5D, 0x5C, 0x4E, 0x6B, 0x60, 0x4B, 0x61,
            0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7,
            0xF8, 0xF9, 0x7A, 0x5E, 0x4C, 0x7E, 0x6E, 0x6F,
            0x7C, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7,
            0xC8, 0xC9, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6,
            0xD7, 0xD8, 0xD9, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6,
            0xE7, 0xE8, 0xE9, 0xAD, 0xE0, 0xBD, 0x5F, 0x6D,
            0x79, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
            0x88, 0x89, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96,
            0x97, 0x98, 0x99, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6,
            0xA7, 0xA8, 0xA9, 0xC0, 0x4F, 0xD0, 0xA1, 0x07,
            0x00, 0x01, 0x02, 0x03, 0x37, 0x2D, 0x2E, 0x2F,
            0x16, 0x05, 0x25, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
            0x10, 0x11, 0x12, 0x13, 0x3C, 0x3D, 0x32, 0x26,
            0x18, 0x19, 0x3F, 0x27, 0x22, 0x1D, 0x35, 0x1F,
            0x40, 0x5A, 0x7F, 0x7B, 0x5B, 0x6C, 0x50, 0x7D,
            0x4D, 0x5D, 0x5C, 0x4E, 0x6B, 0x60, 0x4B, 0x61,
            0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7,
            0xF8, 0xF9, 0x7A, 0x5E, 0x4C, 0x7E, 0x6E, 0x6F,
            0x7C, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7,
            0xC8, 0xC9, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6,
            0xD7, 0xD8, 0xD9, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6,
            0xE7, 0xE8, 0xE9, 0xAD, 0xE0, 0xBD, 0x5F, 0x6D,
            0x79, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
            0x88, 0x89, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96,
            0x97, 0x98, 0x99, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6,
            0xA7, 0xA8, 0xA9, 0xC0, 0x4F, 0xD0, 0xA1, 0x07 };

/* -- this flag should always defined in this package --^^-- */

#define TELegraph_Key

#ifdef TELegraph_Key
   static unsigned short int TCA_2_TEL_Tab[13995] = {
      0x9f08, 0x0001, 0x0001, 0x0000, 0x9f16, 0x0001, 0x9f23, 0x9f22,
      0x9f27, 0x9f09, 0x0001, 0x0001, 0x0001, 0x9f14, 0x0001, 0x0001,
      0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x9f64,
      0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x9f10, 0x9f11, 0x0000,
      0x0000, 0x9f63, 0x9f65, 0x0001, 0x0001, 0x9f43, 0x9f45, 0x0001,
      0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
      0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000,
      0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
      0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
      0x9f0a, 0x9f48, 0x9f0f, 0x9f0b, 0x9f0e, 0x0001, 0x0001, 0x0001,
      0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
      0x0001, 0x0001, 0x0001, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001,
      0x0001, 0x0001, 0x0001, 0x9f47, 0x0001, 0x0001, 0x0001, 0x0001,
      0x0001, 0x0001, 0x0001, 0x0001, 0x9f12, 0x9f13, 0x0001, 0x0001,
      0x0001, 0x0001, 0x0001, 0x9f24, 0x9f26, 0x9f25, 0x0001, 0x0001,
      0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
      0x0001, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
      0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
      0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
      0x0001, 0x0001, 0x0001, 0x0001, 0x9f17, 0x9f44, 0x0001, 0x0001,
      0x9f0c, 0x0001, 0x0001, 0x0001, 0x0001, 0x9f0d, 0x9f28, 0x0001,
      0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
      0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x4134, 0x4136,
      0x4137, 0x4138, 0x014d, 0x0161, 0x428c, 0x0f56, 0x1298, 0x0001,
      0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
      0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000,
      0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0001, 0x0000,
      0x0000, 0x0000, 0x0000, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
      0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
      0x0001, 0x0001, 0x1d50, 0x1d4e, 0x5f46, 0x5f47, 0x0001, 0x5f68,
      0x1d9a, 0x5f85, 0x1da6, 0x5f86, 0x1db4, 0x5fd7, 0x1de0, 0x5fd8,
      0x5fd9, 0x1de1, 0x5fdb, 0x1dde, 0x5fdc, 0x5fdd, 0x1dd6, 0x5fde,
      0x0001, 0x0001, 0x0001, 0x5fd3, 0x0001, 0x5fe0, 0x6065, 0x6066,
      0x1e35, 0x6067, 0x6068, 0x6069, 0x606a, 0x606b, 0x606c, 0x606d,
      0x606e, 0x6071, 0x6072, 0x6073, 0x6074, 0x1e24, 0x1e27, 0x6075,
      0x6076, 0x6077, 0x9f18, 0x9f19, 0x9f1a, 0x9f1b, 0x9f1c, 0x9f1d,
      0x9f1e, 0x9f1f, 0x9f20, 0x9f21, 0x0001, 0x0001, 0x0001, 0x0001,
      0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
      0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
      0x0001, 0x0001, 0x9f29, 0x9f2a, 0x9f2b, 0x9f2c, 0x9f2d, 0x9f2e,
      0x9f2f, 0x9f30, 0x9f31, 0x9f32, 0x9f33, 0x9f34, 0x9f35, 0x9f36,
      0x9f37, 0x9f38, 0x9f39, 0x9f3a, 0x9f3b, 0x9f3c, 0x9f3d, 0x9f3e,
      0x9f3f, 0x9f40, 0x9f41, 0x9f42, 0x9f49, 0x9f4a, 0x9f4b, 0x9f4c,
      0x9f4d, 0x9f4e, 0x9f4f, 0x9f50, 0x9f51, 0x9f52, 0x9f53, 0x9f54,
      0x9f55, 0x9f56, 0x9f57, 0x9f58, 0x9f59, 0x9f5a, 0x9f5b, 0x9f5c,
      0x9f5d, 0x9f5e, 0x9f5f, 0x9f60, 0x9f61, 0x9f62, 0x0001, 0x0001,
      0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
      0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
      0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
      0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
      0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
      0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x9edf, 0x9ee0,
      0x9ee1, 0x9ee2, 0x9ee3, 0x9ee4, 0x9ee5, 0x9ee6, 0x9ee7, 0x9ee8,
      0x9ee9, 0x9eea, 0x9eeb, 0x9eec, 0x9eed, 0x9eee, 0x9eef, 0x9ef0,
      0x9ef1, 0x9ef2, 0x9ef3, 0x9ef4, 0x9ef5, 0x9ef6, 0x9ef7, 0x9ef8,
      0x9ef9, 0x9efa, 0x9efb, 0x9efc, 0x9efd, 0x9efe, 0x9eff, 0x9f00,
      0x9f01, 0x9f02, 0x9f03, 0x9f07, 0x0001, 0x9f04, 0x9f05, 0x9f06,
      0x6078, 0x6079, 0x607a, 0x6070, 0x0001, 0x0001, 0x60d2, 0x1e67,
      0x60e5, 0x1e9a, 0x6101, 0x610b, 0x1ebc, 0x6111, 0x5d51, 0x5d52,
      0x1b45, 0x1b4b, 0x5d53, 0x5d54, 0x5d55, 0x5d56, 0x1b46, 0x5d57,
      0x5d44, 0x5d4a, 0x5d43, 0x5d3a, 0x5d39, 0x5d59, 0x5d5f, 0x0001,
      0x5d5e, 0x5dcf, 0x1b9f, 0x5deb, 0x5e35, 0x5e51, 0x5e52, 0x5e4f,
      0x1c3d, 0x5e50, 0x5e7f, 0x5e80, 0x6112, 0x1ec7, 0x6113, 0x41b4,
      0x038f, 0x42ef, 0x0394, 0x0001, 0x051c, 0x4650, 0x4651, 0x46ae,
      0x46af, 0x46ed, 0x46ee, 0x47d7, 0x4904, 0x0947, 0x4905, 0x4906,
      0x09aa, 0x0a0a, 0x49d2, 0x49d3, 0x0b76, 0x4bae, 0x0b73, 0x4bb0,
      0x4bb1, 0x0b72, 0x0001, 0x0001, 0x0d93, 0x0d9c, 0x4df6, 0x4df7,
      0x4df8, 0x4df9, 0x4dfa, 0x4dfb, 0x4dfc, 0x0d9e, 0x0d9d, 0x4dfd,
      0x4e00, 0x4dfe, 0x0001, 0x0e22, 0x4f3a, 0x0e67, 0x4fd5, 0x4fd6,
      0x50ac, 0x1018, 0x1017, 0x513e, 0x1039, 0x51b1, 0x51b2, 0x51b3,
      0x108c, 0x51c0, 0x5261, 0x5262, 0x0001, 0x0001, 0x1c66, 0x1c77,
      0x002c, 0x1c7b, 0x003b, 0x5e8b, 0x0056, 0x014e, 0x0162, 0x0168,
      0x1cb9, 0x1cb6, 0x5eb2, 0x019f, 0x01a6, 0x01ae, 0x01f4, 0x5eb3,
      0x0228, 0x022d, 0x1cc9, 0x0241, 0x0250, 0x1cd0, 0x0269, 0x1ccb,
      0x0282, 0x0290, 0x03a3, 0x03c0, 0x044e, 0x5ec8, 0x045f, 0x0469,
      0x048e, 0x051f, 0x1d06, 0x057f, 0x058c, 0x0594, 0x059d, 0x06e1,
      0x05c0, 0x5ef5, 0x061a, 0x0621, 0x0629, 0x065a, 0x5ef6, 0x5f08,
      0x5f05, 0x06a3, 0x06ab, 0x06b0, 0x5f40, 0x5f41, 0x4003, 0x0708,
      0x07ff, 0x0819, 0x0827, 0x0954, 0x5f42, 0x097d, 0x0983, 0x098b,
      0x0997, 0x5f43, 0x09b0, 0x0a0e, 0x0a1c, 0x0a2e, 0x0b80, 0x0b9c,
      0x0ba7, 0x4bf4, 0x0bcb, 0x0bd0, 0x0bd5, 0x0be4, 0x0e3d, 0x0bef,
      0x0dab, 0x0e2d, 0x0e35, 0x0e39, 0x0018, 0x0e43, 0x0e4c, 0x0e4e,
      0x0e69, 0x0eb3, 0x0eb8, 0x0f3c, 0x0f43, 0x0f57, 0x0f5c, 0x0f62,
      0x0f68, 0x0f94, 0x1d4f, 0x5f44, 0x1005, 0x101a, 0x1021, 0x103e,
      0x1093, 0x1097, 0x10a2, 0x1103, 0x5516, 0x1145, 0x118e, 0x11bb,
      0x11ca, 0x126d, 0x1299, 0x136a, 0x14d7, 0x1399, 0x13ae, 0x13cf,
      0x13d7, 0x13dd, 0x13ed, 0x1404, 0x140b, 0x1488, 0x148d, 0x1493,
      0x1499, 0x14a6, 0x14ac, 0x14b1, 0x14cf, 0x14d3, 0x55c7, 0x1776,
      0x165a, 0x16f5, 0x16ff, 0x170e, 0x1a3b, 0x177f, 0x1795, 0x17a8,
      0x186d, 0x1872, 0x187d, 0x5b07, 0x1898, 0x18e7, 0x18ee, 0x18fe,
      0x1964, 0x196c, 0x19b4, 0x19bf, 0x5f45, 0x1a38, 0x1a84, 0x1abd,
      0x1ac1, 0x1ac7, 0x1b6e, 0x1b70, 0x1ba7, 0x1d4d, 0x1bf3, 0x1c0f,
      0x1c3e, 0x1c44, 0x1c48, 0x1c4d, 0x1c6f, 0x1c7f, 0x1c83, 0x1c8a,
      0x1cc4, 0x1cd2, 0x1cd4, 0x1d15, 0x1d19, 0x1d20, 0x1d73, 0x1d87,
      0x1dae, 0x1da7, 0x0001, 0x1db1, 0x1db7, 0x1dc9, 0x1e00, 0x1e57,
      0x1e5d, 0x1e74, 0x1e7a, 0x1e7e, 0x1e82, 0x1e87, 0x0001, 0x4105,
      0x1ea4, 0x1ea9, 0x1eb1, 0x1eb9, 0x1ebf, 0x1ec4, 0x1ed5, 0x1eda,
      0x4129, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50,
      0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50,
      0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50,
      0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50,
      0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50,
      0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50,
      0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50,
      0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50,
      0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50,
      0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50,
      0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50,
      0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50,
      0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50,
      0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50,
      0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50,
      0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50,
      0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50,
      0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50,
      0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50,
      0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50,
      0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50, 0x5d50,
      0x0001, 0x002c, 0x0002, 0x0003, 0x0023, 0x002e, 0x0037, 0x003b,
      0x0056, 0x014e, 0x0162, 0x0168, 0x019f, 0x01ae, 0x01af, 0x01f4,
      0x0228, 0x0241, 0x0250, 0x0282, 0x0005, 0x0007, 0x0004, 0x0006,
      0x0015, 0x001d, 0x01a0, 0x0024, 0x400a, 0x0030, 0x002f, 0x003c,
      0x0048, 0x014f, 0x01b0, 0x021d, 0x0242, 0x0283, 0x0290, 0x03c0,
      0x044e, 0x045f, 0x0469, 0x048e, 0x051f, 0x0520, 0x4541, 0x057f,
      0x058c, 0x0594, 0x059d, 0x05c0, 0x0615, 0x061a, 0x0621, 0x0623,
      0x0622, 0x0629, 0x065a, 0x06a3, 0x06ab, 0x06b0, 0x0828, 0x000a,
      0x0009, 0x0008, 0x0016, 0x0017, 0x001e, 0x0025, 0x059e, 0x0038,
      0x003d, 0x0040, 0x003e, 0x003f, 0x0049, 0x0058, 0x0057, 0x0059,
      0x005b, 0x005c, 0x005f, 0x005d, 0x005e, 0x005a, 0x0151, 0x0150,
      0x0163, 0x016a, 0x016b, 0x0169, 0x017f, 0x01a7, 0x01b1, 0x01b2,
      0x01b3, 0x021e, 0x0227, 0x021f, 0x0229, 0x023c, 0x0246, 0x0245,
      0x0244, 0x0251, 0x026a, 0x0285, 0x0284, 0x0286, 0x044f, 0x046b,
      0x046d, 0x046c, 0x046a, 0x0521, 0x058d, 0x0595, 0x059f, 0x05be,
      0x0624, 0x0662, 0x06a4, 0x06b1, 0x06b2, 0x0708, 0x07ff, 0x0819,
      0x0827, 0x0829, 0x0954, 0x097d, 0x0983, 0x098b, 0x0997, 0x09b0,
      0x0a0e, 0x0a1c, 0x0a2e, 0x0b80, 0x0b9c, 0x0ba7, 0x0bcb, 0x0bd0,
      0x0bd5, 0x0be4, 0x0bef, 0x0dab, 0x0e2d, 0x0e35, 0x0e39, 0x0e43,
      0x0e4c, 0x0e4e, 0x0e69, 0x0eb9, 0x000e, 0x000d, 0x000c, 0x000b,
      0x4006, 0x001f, 0x0026, 0x0028, 0x0027, 0x006e, 0x0066, 0x0062,
      0x0063, 0x0064, 0x0065, 0x006c, 0x006d, 0x0067, 0x0069, 0x0153,
      0x0152, 0x0175, 0x0176, 0x0188, 0x01a9, 0x01ab, 0x01a8, 0x01b4,
      0x01f6, 0x01f5, 0x0221, 0x41a7, 0x022a, 0x022f, 0x006b, 0x0248,
      0x0247, 0x0253, 0x0252, 0x025a, 0x0264, 0x027d, 0x029c, 0x0291,
      0x029f, 0x0298, 0x029a, 0x0295, 0x0294, 0x41d7, 0x02a2, 0x02a0,
      0x0297, 0x0293, 0x0296, 0x029e, 0x029b, 0x029d, 0x0292, 0x0299,
      0x03a2, 0x03a6, 0x03a5, 0x0460, 0x046f, 0x0470, 0x048f, 0x0490,
      0x0522, 0x053a, 0x05a1, 0x061d, 0x061c, 0x061b, 0x062b, 0x062c,
      0x065b, 0x0663, 0x06a5, 0x06ca, 0x06b3, 0x0709, 0x0800, 0x082c,
      0x47f0, 0x082b, 0x082a, 0x098c, 0x09b1, 0x0a33, 0x0a31, 0x0a2f,
      0x0a30, 0x0a32, 0x0b9d, 0x0bca, 0x0be6, 0x0be5, 0x0bf1, 0x0bf3,
      0x0bf4, 0x0bf2, 0x0e6a, 0x0eb3, 0x0eb8, 0x0f3c, 0x0f43, 0x0f57,
      0x0f5c, 0x0f62, 0x50d6, 0x0f68, 0x0f69, 0x0f6a, 0x0f6b, 0x0f94,
      0x1005, 0x101a, 0x1021, 0x103e, 0x1093, 0x1097, 0x10a2, 0x1103,
      0x1145, 0x118e, 0x11bb, 0x000f, 0x0010, 0x400c, 0x400d, 0x0031,
      0x0041, 0x004a, 0x004c, 0x004b, 0x0077, 0x0079, 0x0081, 0x007a,
      0x4028, 0x007c, 0x007f, 0x0080, 0x007e, 0x0070, 0x0073, 0x0075,
      0x006f, 0x0071, 0x0076, 0x0078, 0x007b, 0x0156, 0x0157, 0x0154,
      0x0155, 0x0164, 0x016c, 0x0177, 0x0189, 0x01b9, 0x01b6, 0x01b7,
      0x01b5, 0x01b8, 0x01f7, 0x0222, 0x0232, 0x0231, 0x025b, 0x025c,
      0x02a7, 0x02ac, 0x02a9, 0x02a8, 0x02ad, 0x02a3, 0x41dd, 0x02a5,
      0x02ae, 0x02aa, 0x02a6, 0x02a4, 0x02ab, 0x41dc, 0x02b0, 0x03a8,
      0x03a4, 0x42fc, 0x044d, 0x03c6, 0x03c1, 0x03c4, 0x03c3, 0x03c5,
      0x03c2, 0x0461, 0x0462, 0x0472, 0x0473, 0x0496, 0x0491, 0x0495,
      0x0492, 0x443d, 0x0494, 0x0493, 0x0524, 0x0525, 0x053e, 0x053f,
      0x053d, 0x0540, 0x0580, 0x058f, 0x05c1, 0x0616, 0x062d, 0x065d,
      0x065c, 0x06ad, 0x06b4, 0x0713, 0x070e, 0x0803, 0x0801, 0x0802,
      0x0804, 0x0833, 0x082f, 0x082e, 0x0958, 0x09b3, 0x09b2, 0x09b4,
      0x09b5, 0x0a0f, 0x0a10, 0x0a1d, 0x0a37, 0x0a35, 0x0a34, 0x0a36,
      0x0b81, 0x0b9e, 0x0ba8, 0x4c0d, 0x0bfb, 0x0bf7, 0x4c32, 0x0bfc,
      0x0bfd, 0x0bff, 0x0c01, 0x0bf8, 0x0bf9, 0x4c31, 0x0bf6, 0x0dac,
      0x0e50, 0x0e4f, 0x1006, 0x11ca, 0x126d, 0x1299, 0x136a, 0x1399,
      0x13ae, 0x13cf, 0x13d0, 0x13d7, 0x13dd, 0x13ed, 0x1404, 0x140b,
      0x140c, 0x140d, 0x1488, 0x148d, 0x1493, 0x1499, 0x14a6, 0x14ac,
      0x14b1, 0x14cf, 0x14d3, 0x14d9, 0x165a, 0x16f5, 0x16ff, 0x170e,
      0x1777, 0x1baa, 0x0019, 0x004d, 0x008f, 0x0091, 0x4053, 0x0096,
      0x009c, 0x0085, 0x009a, 0x0095, 0x0083, 0x0092, 0x0093, 0x008b,
      0x0088, 0x0087, 0x008c, 0x0094, 0x008a, 0x008d, 0x4056, 0x009b,
      0x0084, 0x0082, 0x0090, 0x0086, 0x0097, 0x4054, 0x008e, 0x0099,
      0x0159, 0x0158, 0x015a, 0x016d, 0x018c, 0x018d, 0x01be, 0x01bd,
      0x01c0, 0x01bc, 0x01ba, 0x01fa, 0x01f8, 0x01f9, 0x01fb, 0x0233,
      0x0265, 0x025f, 0x02b2, 0x02bb, 0x02b3, 0x02c6, 0x02b6, 0x41e5,
      0x41e6, 0x02ca, 0x02c9, 0x02be, 0x02bd, 0x02c8, 0x02b1, 0x02b7,
      0x02c3, 0x02c2, 0x02c4, 0x02c1, 0x02bc, 0x02bf, 0x02c0, 0x02b5,
      0x02c5, 0x02c7, 0x41e4, 0x02ba, 0x02b4, 0x41ec, 0x03a7, 0x03aa,
      0x03a9, 0x03ab, 0x03cc, 0x03d1, 0x03c8, 0x03cd, 0x03cb, 0x03ce,
      0x432c, 0x03d0, 0x03cf, 0x03c7, 0x0450, 0x0474, 0x049e, 0x0498,
      0x04a2, 0x051e, 0x049f, 0x049d, 0x049b, 0x0499, 0x04a0, 0x049a,
      0x0497, 0x04a1, 0x0529, 0x0528, 0x0526, 0x0527, 0x0542, 0x0541,
      0x0543, 0x059b, 0x05a4, 0x05a5, 0x05a3, 0x05a2, 0x05c5, 0x05c6,
      0x05c7, 0x05c4, 0x061e, 0x0631, 0x066d, 0x066a, 0x066b, 0x069e,
      0x06a6, 0x06b5, 0x06d5, 0x06d4, 0x06e2, 0x06e3, 0x0710, 0x070b,
      0x070f, 0x070c, 0x071c, 0x0718, 0x071d, 0x0717, 0x0806, 0x0805,
      0x0841, 0x084b, 0x084a, 0x083f, 0x0839, 0x0843, 0x0834, 0x0844,
      0x083c, 0x083d, 0x083a, 0x0838, 0x0846, 0x0836, 0x084c, 0x0835,
      0x0849, 0x0847, 0x0845, 0x0842, 0x095b, 0x095c, 0x095a, 0x09b7,
      0x0a11, 0x0a47, 0x0a3d, 0x0a3e, 0x0a40, 0x0a41, 0x0a45, 0x0a43,
      0x0a46, 0x0a3b, 0x0a38, 0x0a48, 0x0a42, 0x0a49, 0x0b9f, 0x0bcc,
      0x0bf5, 0x0c02, 0x0c19, 0x0c0c, 0x0c10, 0x0c11, 0x0c20, 0x0c1b,
      0x0c04, 0x0c0a, 0x0c14, 0x0c05, 0x0c12, 0x0c03, 0x0c17, 0x0c15,
      0x4c43, 0x0c0f, 0x0c06, 0x0c0b, 0x0c07, 0x0c1c, 0x0c08, 0x0c13,
      0x0c16, 0x4c48, 0x0c0d, 0x0dad, 0x0db0, 0x0db1, 0x0dae, 0x0e52,
      0x0e51, 0x4f59, 0x0e6f, 0x0e6d, 0x0ebd, 0x0f65, 0x0f64, 0x0f6c,
      0x0f6d, 0x1007, 0x5151, 0x1098, 0x1148, 0x1147, 0x1146, 0x1190,
      0x129a, 0x137c, 0x140f, 0x140e, 0x1413, 0x1410, 0x1412, 0x1411,
      0x141c, 0x14d0, 0x14e1, 0x14dd, 0x14de, 0x177f, 0x1795, 0x17a8,
      0x186d, 0x1872, 0x187d, 0x1898, 0x18e7, 0x18ee, 0x18fe, 0x1964,
      0x196c, 0x19b4, 0x19bf, 0x19c4, 0x5b08, 0x19c6, 0x19c5, 0x0617,
      0x1a38, 0x1a3d, 0x1a43, 0x1a41, 0x1a3f, 0x1a84, 0x1abd, 0x1ac1,
      0x1bb1, 0x1bae, 0x1bb0, 0x1bb2, 0x1bad, 0x0011, 0x0029, 0x0032,
      0x0039, 0x0043, 0x0044, 0x004e, 0x004f, 0x00a2, 0x00b5, 0x00ae,
      0x00a3, 0x00a9, 0x4067, 0x00b4, 0x00ad, 0x00ab, 0x00aa, 0x406b,
      0x00a4, 0x00ac, 0x00a0, 0x00a7, 0x00b2, 0x00a8, 0x00af, 0x00b0,
      0x009e, 0x015b, 0x015c, 0x015d, 0x0165, 0x016f, 0x016e, 0x0170,
      0x018f, 0x01ac, 0x01d2, 0x01c9, 0x01c8, 0x01cb, 0x01c3, 0x01c2,
      0x01c7, 0x01c1, 0x01ff, 0x01fe, 0x024a, 0x024c, 0x024b, 0x0249,
      0x0255, 0x0260, 0x0261, 0x41ba, 0x0288, 0x0287, 0x0289, 0x02d4,
      0x02d5, 0x41f9, 0x41fa, 0x41fb, 0x02db, 0x02d8, 0x02d7, 0x02dc,
      0x02d0, 0x02dd, 0x02d9, 0x02b8, 0x02d2, 0x02d6, 0x02df, 0x41fc,
      0x02cc, 0x02cf, 0x02e2, 0x02da, 0x02e0, 0x03ae, 0x433d, 0x03d9,
      0x03dc, 0x433e, 0x03d4, 0x03d6, 0x03d5, 0x03da, 0x0463, 0x0478,
      0x0476, 0x0477, 0x0475, 0x047d, 0x04a6, 0x04a5, 0x04b1, 0x04a4,
      0x04b0, 0x04ac, 0x04a7, 0x04ab, 0x04aa, 0x04a9, 0x04ae, 0x04a8,
      0x04a3, 0x4469, 0x04ad, 0x04be, 0x052a, 0x052c, 0x052b, 0x0546,
      0x0549, 0x0547, 0x054b, 0x0548, 0x054a, 0x0590, 0x05a8, 0x05a6,
      0x05a7, 0x05d0, 0x05c9, 0x05d1, 0x05cc, 0x05cd, 0x05ce, 0x05bf,
      0x0634, 0x0636, 0x0632, 0x0630, 0x0637, 0x062f, 0x065e, 0x0671,
      0x0670, 0x0672, 0x066e, 0x066f, 0x069d, 0x06b8, 0x06b9, 0x06ba,
      0x06e6, 0x06e7, 0x06e5, 0x06e4, 0x0714, 0x0715, 0x0720, 0x071b,
      0x0721, 0x0724, 0x073a, 0x0735, 0x0737, 0x0727, 0x0733, 0x0726,
      0x072d, 0x0730, 0x0732, 0x0734, 0x072a, 0x0809, 0x0808, 0x081b,
      0x081a, 0x081c, 0x083e, 0x085b, 0x085e, 0x0856, 0x4810, 0x0855,
      0x0852, 0x0863, 0x086c, 0x084e, 0x0864, 0x0865, 0x085d, 0x085a,
      0x084d, 0x0854, 0x0853, 0x0861, 0x086a, 0x0858, 0x085f, 0x083b,
      0x086b, 0x0850, 0x0869, 0x0867, 0x0868, 0x0857, 0x084f, 0x480e,
      0x095d, 0x098d, 0x0998, 0x09b9, 0x09c1, 0x09c0, 0x09ba, 0x09bc,
      0x09bb, 0x09be, 0x09c2, 0x09bf, 0x09c4, 0x4957, 0x0a0d, 0x0a1f,
      0x0a1e, 0x0a4b, 0x0a62, 0x0a5a, 0x0a4f, 0x0a5e, 0x0a51, 0x4a18,
      0x0a61, 0x0a5f, 0x0a5b, 0x0a4d, 0x0a4e, 0x0a57, 0x0a58, 0x0a56,
      0x0a59, 0x0a53, 0x0a5d, 0x4a19, 0x0a55, 0x0a4a, 0x0a50, 0x0b82,
      0x0ba0, 0x0ba2, 0x0ba9, 0x0be7, 0x0bea, 0x0c3f, 0x0c41, 0x0c48,
      0x0c24, 0x0c35, 0x0c40, 0x0c25, 0x0c2a, 0x0c2b, 0x0c29, 0x0c3e,
      0x0c22, 0x0c37, 0x0c36, 0x0c26, 0x0c2e, 0x0c27, 0x0c2f, 0x0c23,
      0x0c38, 0x0c30, 0x0c46, 0x0c2c, 0x0c28, 0x0c3d, 0x0c3b, 0x0c34,
      0x0c21, 0x0c43, 0x4c54, 0x0c4c, 0x0c3c, 0x0db6, 0x0db4, 0x0db5,
      0x0db3, 0x0db7, 0x0e30, 0x0e2e, 0x0e38, 0x0e44, 0x0e54, 0x0e56,
      0x0e6c, 0x0e71, 0x0e74, 0x0e73, 0x0e72, 0x0ec3, 0x0ec2, 0x0ebe,
      0x0ec4, 0x4fe4, 0x0f6e, 0x0f9f, 0x0fff, 0x0f9e, 0x1008, 0x1022,
      0x103f, 0x1040, 0x1099, 0x51c6, 0x1105, 0x1106, 0x1107, 0x114a,
      0x1149, 0x1194, 0x1192, 0x11cb, 0x129b, 0x137b, 0x139a, 0x54b0,
      0x13d2, 0x141f, 0x1416, 0x1415, 0x141b, 0x1414, 0x1419, 0x1418,
      0x141d, 0x5522, 0x141a, 0x1489, 0x149a, 0x14a7, 0x14f4, 0x14e3,
      0x14e2, 0x14ef, 0x14fa, 0x14e4, 0x14f7, 0x14f3, 0x14ee, 0x14ea,
      0x14f1, 0x14f6, 0x14e6, 0x14f2, 0x14fc, 0x14f5, 0x164a, 0x165b,
      0x01bb, 0x170f, 0x196d, 0x19c9, 0x19cc, 0x19ca, 0x1a4a, 0x1a4c,
      0x1a46, 0x1a4b, 0x1abe, 0x1ac7, 0x1b6e, 0x1b70, 0x1ba7, 0x1bb6,
      0x1bb5, 0x1bb3, 0x1bb8, 0x1bb7, 0x1bf3, 0x1c0f, 0x1c3e, 0x1c44,
      0x0045, 0x0050, 0x0051, 0x00cf, 0x00bb, 0x00ba, 0x00bd, 0x00cc,
      0x00c5, 0x00c3, 0x00ca, 0x00bf, 0x00bc, 0x00c7, 0x00cb, 0x00c1,
      0x00c6, 0x00b9, 0x00c4, 0x00c0, 0x00be, 0x00c8, 0x00c2, 0x00cd,
      0x00b6, 0x015e, 0x017b, 0x017a, 0x0181, 0x417e, 0x01cd, 0x01d1,
      0x01d3, 0x417f, 0x01cc, 0x01cf, 0x0204, 0x0205, 0x0202, 0x0201,
      0x0224, 0x024d, 0x0263, 0x0270, 0x028b, 0x02eb, 0x02f3, 0x02e9,
      0x4219, 0x02fa, 0x02f0, 0x4217, 0x02ee, 0x02f8, 0x02f5, 0x02f2,
      0x4218, 0x02f4, 0x02f6, 0x02f9, 0x02ec, 0x02ea, 0x02ed, 0x02fb,
      0x421d, 0x02e8, 0x02fc, 0x03af, 0x03db, 0x03e0, 0x03e3, 0x03e5,
      0x03e4, 0x03ec, 0x434e, 0x03e1, 0x047e, 0x047c, 0x047a, 0x0479,
      0x047b, 0x04b3, 0x447b, 0x04c1, 0x04b7, 0x04ba, 0x04c0, 0x04b9,
      0x04bc, 0x04b2, 0x04bb, 0x04c2, 0x04bf, 0x052e, 0x054d, 0x0550,
      0x054e, 0x054c, 0x054f, 0x0581, 0x05ac, 0x05b0, 0x05ab, 0x05aa,
      0x05d4, 0x05d3, 0x0626, 0x0639, 0x063c, 0x063b, 0x0664, 0x0673,
      0x0675, 0x06a0, 0x06a8, 0x06bd, 0x06d6, 0x06eb, 0x06e9, 0x06ed,
      0x06ee, 0x06ea, 0x06ef, 0x06ec, 0x0725, 0x072b, 0x072c, 0x072e,
      0x0723, 0x0731, 0x0741, 0x0752, 0x074c, 0x0747, 0x073e, 0x073d,
      0x4721, 0x074f, 0x074e, 0x0749, 0x081e, 0x086d, 0x0881, 0x087e,
      0x0882, 0x0870, 0x087a, 0x086f, 0x0877, 0x087c, 0x0872, 0x0876,
      0x0873, 0x0871, 0x0878, 0x0875, 0x0880, 0x087b, 0x095e, 0x095f,
      0x10b1, 0x0999, 0x09ae, 0x09c8, 0x09cb, 0x09c7, 0x09c9, 0x09cc,
      0x09c6, 0x09ca, 0x09cd, 0x4963, 0x0a12, 0x0a4c, 0x0a74, 0x0a83,
      0x0a75, 0x0a71, 0x0a7f, 0x0a69, 0x0a65, 0x0a86, 0x0b7f, 0x0a80,
      0x0a6f, 0x0a72, 0x4a44, 0x0a78, 0x0a7e, 0x0a6b, 0x0a70, 0x0a7b,
      0x0a84, 0x0a87, 0x0a77, 0x0a7d, 0x0a7a, 0x0a73, 0x0ba1, 0x0bac,
      0x0bae, 0x0bc0, 0x0bcd, 0x0bd2, 0x4c12, 0x0c33, 0x0c50, 0x0c5e,
      0x0c5b, 0x0c69, 0x0c58, 0x0c51, 0x0c5f, 0x0c57, 0x0c54, 0x0c64,
      0x0c66, 0x0c67, 0x0c62, 0x0c55, 0x4c56, 0x0c6c, 0x0c59, 0x0c63,
      0x4c7f, 0x0c5d, 0x0c61, 0x0c52, 0x0c5c, 0x0dba, 0x0e32, 0x0dc1,
      0x0dbb, 0x0dbe, 0x0dbc, 0x0daa, 0x0dbd, 0x0db9, 0x0e31, 0x0e59,
      0x0e58, 0x0e55, 0x0e78, 0x0e77, 0x0e75, 0x0ec7, 0x0ece, 0x0ecc,
      0x0ec5, 0x0ecf, 0x0ecd, 0x0ec6, 0x0f58, 0x50d7, 0x0f74, 0x0f72,
      0x0f73, 0x0f71, 0x0fa4, 0x0fa2, 0x0fa3, 0x0fa0, 0x0fa1, 0x1001,
      0x1009, 0x100a, 0x100b, 0x1026, 0x1025, 0x1023, 0x1024, 0x1044,
      0x5157, 0x1041, 0x1048, 0x104a, 0x1043, 0x1042, 0x1046, 0x1094,
      0x10a7, 0x10ba, 0x10a9, 0x10aa, 0x1108, 0x110b, 0x110a, 0x1109,
      0x1140, 0x1141, 0x114e, 0x1150, 0x114c, 0x1196, 0x1193, 0x11cd,
      0x11cc, 0x53bc, 0x129d, 0x129f, 0x129c, 0x12a3, 0x12a1, 0x129e,
      0x12a0, 0x136b, 0x139b, 0x54c8, 0x13da, 0x13d8, 0x13db, 0x13ee,
      0x1428, 0x1433, 0x142a, 0x1420, 0x1421, 0x1422, 0x1432, 0x142b,
      0x1426, 0x142d, 0x1487, 0x142c, 0x1494, 0x55a6, 0x150d, 0x1518,
      0x151b, 0x1509, 0x1505, 0x150c, 0x1519, 0x150b, 0x1517, 0x151e,
      0x14ff, 0x1503, 0x150f, 0x1516, 0x1506, 0x1501, 0x14fd, 0x1507,
      0x1500, 0x1508, 0x55e7, 0x14fe, 0x164b, 0x165d, 0x57b2, 0x165e,
      0x1700, 0x1710, 0x1778, 0x1796, 0x17ac, 0x17a9, 0x17aa, 0x1899,
      0x189a, 0x18f0, 0x18ef, 0x5a50, 0x196f, 0x196e, 0x19d7, 0x19d1,
      0x19ce, 0x19d3, 0x19d0, 0x19d5, 0x19d4, 0x19cf, 0x19d2, 0x1a52,
      0x1a59, 0x1a4f, 0x1a54, 0x1a86, 0x1a85, 0x1ac2, 0x1b71, 0x1bba,
      0x1bb9, 0x1bbb, 0x1bbc, 0x1c48, 0x1c4d, 0x1c6f, 0x1c7f, 0x1c83,
      0x1c8a, 0x1cc4, 0x1cd2, 0x1cd4, 0x1d15, 0x1d19, 0x002a, 0x0052,
      0x00d4, 0x00df, 0x00ec, 0x00d6, 0x00ef, 0x00ee, 0x00da, 0x00f1,
      0x00e4, 0x00e0, 0x00ed, 0x00ea, 0x00e7, 0x00e3, 0x00e2, 0x00db,
      0x00d2, 0x40a1, 0x00f0, 0x00d7, 0x00eb, 0x00de, 0x00e6, 0x00e5,
      0x00d8, 0x00d0, 0x00f4, 0x00f2, 0x00dc, 0x00f3, 0x00dd, 0x0171,
      0x0183, 0x0184, 0x0182, 0x0198, 0x0197, 0x0192, 0x0196, 0x01d8,
      0x01d4, 0x01d7, 0x01da, 0x01db, 0x0234, 0x0267, 0x0272, 0x0271,
      0x028c, 0x030f, 0x030d, 0x0309, 0x422e, 0x0306, 0x02fe, 0x0304,
      0x030a, 0x0305, 0x422c, 0x0301, 0x0302, 0x02fd, 0x030c, 0x0303,
      0x422d, 0x0300, 0x0339, 0x422b, 0x0307, 0x0311, 0x03b0, 0x03b1,
      0x03ee, 0x4368, 0x03eb, 0x03ea, 0x4392, 0x045b, 0x0480, 0x0483,
      0x0481, 0x04c7, 0x04c8, 0x04ca, 0x04cb, 0x04c9, 0x04d0, 0x04bd,
      0x04cc, 0x04cd, 0x04cf, 0x04ce, 0x04c6, 0x04c3, 0x052f, 0x4548,
      0x0553, 0x0554, 0x0557, 0x0555, 0x0552, 0x0556, 0x0559, 0x0558,
      0x0582, 0x05ae, 0x05af, 0x05ad, 0x05d7, 0x05db, 0x05da, 0x45cd,
      0x05d6, 0x45d4, 0x05d9, 0x45da, 0x05dd, 0x061f, 0x063e, 0x063d,
      0x0677, 0x0678, 0x0676, 0x06be, 0x06f2, 0x06f1, 0x06f0, 0x0744,
      0x0748, 0x074a, 0x0742, 0x0743, 0x0750, 0x074d, 0x0751, 0x0755,
      0x0761, 0x075c, 0x0758, 0x075a, 0x0757, 0x0756, 0x075b, 0x0822,
      0x0874, 0x087d, 0x0879, 0x0898, 0x088c, 0x0886, 0x0896, 0x4843,
      0x088e, 0x483e, 0x088f, 0x0889, 0x0894, 0x088b, 0x0884, 0x0885,
      0x0883, 0x0892, 0x0891, 0x0960, 0x0961, 0x0984, 0x099c, 0x09a0,
      0x09d2, 0x09d4, 0x09d6, 0x09d3, 0x4973, 0x09d5, 0x4974, 0x09d1,
      0x0a13, 0x0a20, 0x0a24, 0x0a25, 0x0a8b, 0x0a8e, 0x0a9a, 0x0a99,
      0x0a9f, 0x0a90, 0x0a96, 0x0aa0, 0x0a8c, 0x0ac0, 0x0a8a, 0x0a9b,
      0x0a9e, 0x0a93, 0x0a85, 0x0a9d, 0x0a94, 0x0a92, 0x0a97, 0x0a8d,
      0x0a98, 0x4a69, 0x4a59, 0x0a95, 0x0bb0, 0x0baf, 0x0bc1, 0x0beb,
      0x4c14, 0x4c15, 0x4c16, 0x0bec, 0x0c45, 0x0c72, 0x0c7f, 0x0c7a,
      0x0c79, 0x0c70, 0x0c76, 0x0c75, 0x0c6d, 0x0c7d, 0x4cad, 0x0c7b,
      0x0c73, 0x0c6e, 0x0c74, 0x0c71, 0x0c7c, 0x4cb2, 0x0c77, 0x0c86,
      0x0c84, 0x0c7e, 0x4e61, 0x0dca, 0x0e2c, 0x4e62, 0x0dc5, 0x0dc7,
      0x0e36, 0x0e5c, 0x0e7c, 0x0e7b, 0x0e7d, 0x0e7a, 0x0e80, 0x4fdb,
      0x0edb, 0x0ee4, 0x0edd, 0x0ed4, 0x0eda, 0x0ed2, 0x0f79, 0x0f7d,
      0x0f7c, 0x0f7a, 0x0f7e, 0x0fae, 0x0fb0, 0x0fb1, 0x0fa6, 0x0fa7,
      0x0fad, 0x0fac, 0x0fab, 0x0fb2, 0x0faa, 0x512f, 0x513b, 0x1027,
      0x1029, 0x102a, 0x1055, 0x1050, 0x1051, 0x5165, 0x109b, 0x10b8,
      0x10b6, 0x51e4, 0x51e5, 0x10b3, 0x51de, 0x10b0, 0x10ad, 0x10b5,
      0x51e2, 0x10b4, 0x110d, 0x1110, 0x111b, 0x111a, 0x1113, 0x1119,
      0x1118, 0x1114, 0x1115, 0x1157, 0x52c0, 0x1159, 0x1154, 0x1158,
      0x115a, 0x1152, 0x1198, 0x119b, 0x11bd, 0x11e0, 0x11d2, 0x1270,
      0x12b7, 0x12b0, 0x12a5, 0x12a4, 0x12b6, 0x12b8, 0x12af, 0x12ad,
      0x5401, 0x12b3, 0x12b5, 0x12ac, 0x12b2, 0x12b4, 0x136c, 0x1380,
      0x139d, 0x13b1, 0x13b0, 0x13d3, 0x13d1, 0x13e1, 0x13df, 0x13e2,
      0x13e0, 0x13f0, 0x13f1, 0x143c, 0x1438, 0x5538, 0x143a, 0x1430,
      0x5539, 0x5540, 0x1434, 0x5534, 0x143d, 0x1436, 0x143e, 0x1435,
      0x1431, 0x148f, 0x148e, 0x149c, 0x14a8, 0x14b4, 0x14b6, 0x55a8,
      0x14b5, 0x14f8, 0x1525, 0x153b, 0x1520, 0x1533, 0x152e, 0x1539,
      0x1536, 0x152b, 0x152a, 0x1538, 0x1529, 0x152f, 0x152c, 0x151f,
      0x1530, 0x1528, 0x1524, 0x1531, 0x164d, 0x1662, 0x1669, 0x165f,
      0x1666, 0x1668, 0x1664, 0x1665, 0x57ba, 0x1711, 0x1713, 0x1719,
      0x5899, 0x1716, 0x589d, 0x17b4, 0x17af, 0x17ae, 0x17b5, 0x17b1,
      0x17ad, 0x17b3, 0x17b0, 0x17b2, 0x17b6, 0x17b7, 0x1873, 0x188c,
      0x188b, 0x189b, 0x189c, 0x18f2, 0x1965, 0x1971, 0x1972, 0x1970,
      0x19c0, 0x19df, 0x19e3, 0x19d9, 0x19de, 0x19dd, 0x19d8, 0x19e1,
      0x19dc, 0x19e2, 0x19da, 0x1a3c, 0x1a5a, 0x1a83, 0x1a5b, 0x1a8a,
      0x1a88, 0x1a87, 0x1ac9, 0x1acb, 0x1ac8, 0x1aca, 0x5bd3, 0x1b72,
      0x1bc4, 0x1bc5, 0x1bc3, 0x1bbf, 0x1bc0, 0x1bc6, 0x1bbe, 0x1bc1,
      0x1bf4, 0x1cd6, 0x1d20, 0x1d73, 0x1d87, 0x1da7, 0x1db1, 0x1db7,
      0x0033, 0x40ad, 0x012a, 0x00ff, 0x00fa, 0x00f9, 0x40cf, 0x00fe,
      0x00fb, 0x0100, 0x0104, 0x00f6, 0x00fd, 0x0103, 0x0102, 0x40d0,
      0x00fc, 0x00e1, 0x40ac, 0x40bc, 0x015f, 0x017c, 0x01a4, 0x01dd,
      0x01df, 0x0207, 0x020b, 0x020a, 0x0208, 0x0226, 0x0225, 0x022b,
      0x023e, 0x023f, 0x023d, 0x027f, 0x0a15, 0x031a, 0x4240, 0x4241,
      0x0319, 0x0320, 0x423d, 0x423e, 0x423f, 0x0314, 0x031d, 0x031b,
      0x4254, 0x0313, 0x4242, 0x4255, 0x0312, 0x031f, 0x4256, 0x0318,
      0x0315, 0x0317, 0x031e, 0x03b2, 0x03b4, 0x03b3, 0x03f0, 0x03f9,
      0x03fb, 0x03fa, 0x03f1, 0x03fc, 0x03f7, 0x03f8, 0x040b, 0x03f5,
      0x03f6, 0x0464, 0x0486, 0x04d3, 0x04d4, 0x04d6, 0x04dc, 0x04dd,
      0x4493, 0x04d1, 0x04da, 0x04d9, 0x04d5, 0x04d7, 0x0530, 0x0563,
      0x0561, 0x0560, 0x055e, 0x055c, 0x0562, 0x0586, 0x0585, 0x0584,
      0x05b2, 0x4588, 0x05b1, 0x05e0, 0x45e6, 0x05e1, 0x05e8, 0x05e5,
      0x05e9, 0x05e3, 0x05ea, 0x05e4, 0x05e6, 0x45df, 0x05ec, 0x05e7,
      0x0618, 0x0643, 0x0641, 0x0640, 0x0642, 0x067c, 0x067d, 0x067b,
      0x067a, 0x067e, 0x06c0, 0x06c2, 0x06cd, 0x06db, 0x06d8, 0x06da,
      0x06f3, 0x06f5, 0x06f7, 0x06f4, 0x06f9, 0x06f8, 0x06f6, 0x473f,
      0x0763, 0x075d, 0x0762, 0x4740, 0x0783, 0x0769, 0x4741, 0x076f,
      0x0772, 0x076d, 0x076a, 0x077d, 0x076e, 0x0779, 0x0778, 0x0773,
      0x077f, 0x076c, 0x077b, 0x0774, 0x080a, 0x080b, 0x0823, 0x08b6,
      0x08bb, 0x08a0, 0x08b3, 0x08b8, 0x08ba, 0x08a4, 0x0899, 0x08b4,
      0x08be, 0x08a1, 0x08bd, 0x08ac, 0x08a9, 0x08b5, 0x089c, 0x08bc,
      0x08c1, 0x08ab, 0x4864, 0x08b7, 0x08bf, 0x08b2, 0x08af, 0x08a8,
      0x08a6, 0x089b, 0x089a, 0x4862, 0x096b, 0x0967, 0x0965, 0x0963,
      0x0968, 0x031c, 0x0964, 0x0962, 0x0966, 0x0969, 0x0986, 0x0985,
      0x098f, 0x09a5, 0x09a3, 0x09a4, 0x099b, 0x09d9, 0x09d7, 0x09dc,
      0x09dd, 0x09de, 0x09da, 0x0a14, 0x0a1b, 0x0a26, 0x0aad, 0x0abc,
      0x0ab8, 0x0ab1, 0x0ac1, 0x0aab, 0x0aa9, 0x0abd, 0x0ab9, 0x0ab3,
      0x0abe, 0x0aac, 0x0ac5, 0x0abb, 0x0aaf, 0x0aae, 0x0ab2, 0x0ab6,
      0x4a88, 0x0ab7, 0x4a89, 0x4a8a, 0x0b84, 0x0bc2, 0x0bd8, 0x0bd9,
      0x4c18, 0x0ca9, 0x0c8d, 0x4ce9, 0x0c96, 0x0c8a, 0x0c99, 0x4ce1,
      0x0c9a, 0x0ca8, 0x0ca7, 0x0ca5, 0x0c91, 0x0c92, 0x0c89, 0x0c93,
      0x4c9a, 0x0caf, 0x0ca6, 0x0c8c, 0x0ca4, 0x4cea, 0x0c8f, 0x0cae,
      0x0cb4, 0x0c8b, 0x0c97, 0x0c9e, 0x0c95, 0x0c9d, 0x0ca2, 0x0ca0,
      0x0c9c, 0x0c90, 0x0cad, 0x0caa, 0x0c9f, 0x0c8e, 0x0c9b, 0x0dce,
      0x4e7c, 0x4e7d, 0x0dd0, 0x4e82, 0x0e3a, 0x0e5d, 0x4f63, 0x0e87,
      0x0e86, 0x0e83, 0x4faa, 0x0e85, 0x0eb4, 0x0ee1, 0x0ee7, 0x0ee0,
      0x0ee2, 0x0edf, 0x501c, 0x0f3e, 0x0f46, 0x0f47, 0x0f59, 0x0f5e,
      0x0f82, 0x0f83, 0x0f80, 0x0f88, 0x0f96, 0x0fb7, 0x0fb8, 0x0fa9,
      0x0fb3, 0x0fb5, 0x100d, 0x102c, 0x102b, 0x102d, 0x105b, 0x105f,
      0x105e, 0x105a, 0x105c, 0x105d, 0x10c0, 0x10b9, 0x10bb, 0x111e,
      0x1120, 0x1121, 0x1160, 0x119e, 0x119f, 0x11d7, 0x11da, 0x11d4,
      0x11de, 0x11d9, 0x11d3, 0x11d5, 0x11df, 0x1271, 0x1273, 0x1272,
      0x12ca, 0x12c8, 0x12db, 0x12bc, 0x12c1, 0x12c3, 0x12c6, 0x12be,
      0x12c0, 0x12c9, 0x12bd, 0x12c7, 0x12bf, 0x12cb, 0x549e, 0x13a2,
      0x13a0, 0x13b3, 0x13b4, 0x13b5, 0x13e3, 0x13f4, 0x13f3, 0x144a,
      0x5544, 0x1444, 0x1448, 0x1446, 0x5542, 0x1443, 0x149d, 0x14b9,
      0x14b8, 0x14ba, 0x14bb, 0x1546, 0x154b, 0x154a, 0x1534, 0x154d,
      0x1549, 0x1556, 0x1553, 0x1547, 0x1545, 0x1548, 0x1555, 0x154c,
      0x1540, 0x1541, 0x1542, 0x154f, 0x154e, 0x164e, 0x06d9, 0x1674,
      0x1672, 0x166f, 0x1671, 0x57c9, 0x1673, 0x1677, 0x166d, 0x166b,
      0x1675, 0x1702, 0x1722, 0x171a, 0x1726, 0x171d, 0x171e, 0x171c,
      0x171b, 0x1781, 0x1780, 0x17be, 0x17ba, 0x17bc, 0x17bd, 0x17bf,
      0x17c0, 0x17bb, 0x17b9, 0x17c2, 0x1876, 0x187e, 0x18a1, 0x18a3,
      0x18a2, 0x189f, 0x18a0, 0x189e, 0x18e9, 0x18e8, 0x1900, 0x1902,
      0x1973, 0x1974, 0x19ee, 0x19e6, 0x19ef, 0x19ed, 0x19f7, 0x19f3,
      0x19f1, 0x19e8, 0x19eb, 0x19f2, 0x19f4, 0x19e7, 0x19f6, 0x19ec,
      0x19f0, 0x19ea, 0x1a60, 0x1a61, 0x1a65, 0x1a8c, 0x1ac3, 0x1ad1,
      0x1acf, 0x1acc, 0x1acd, 0x1ad0, 0x5bde, 0x1b74, 0x1bc7, 0x1bcd,
      0x1bcb, 0x1bd0, 0x1bc9, 0x1bcc, 0x1bce, 0x1bcf, 0x1bc8, 0x1bf6,
      0x1c11, 0x1c10, 0x11c1, 0x11c0, 0x1c8b, 0x1c8c, 0x1dc9, 0x1e00,
      0x1e57, 0x1e5d, 0x1e74, 0x1e7a, 0x40d7, 0x010a, 0x0109, 0x010f,
      0x010b, 0x0108, 0x0107, 0x010e, 0x0110, 0x0a18, 0x01a2, 0x01e0,
      0x01e1, 0x01e2, 0x01dc, 0x020d, 0x020c, 0x41a1, 0x024e, 0x0274,
      0x0324, 0x0327, 0x033a, 0x0325, 0x032f, 0x0338, 0x0334, 0x0328,
      0x0337, 0x033c, 0x034d, 0x032c, 0x0332, 0x0329, 0x426f, 0x033e,
      0x034e, 0x0316, 0x4270, 0x0336, 0x033b, 0x033d, 0x4271, 0x033f,
      0x032e, 0x0350, 0x0335, 0x03b9, 0x0407, 0x0406, 0x040a, 0x0405,
      0x040d, 0x0408, 0x0403, 0x43a4, 0x0404, 0x0451, 0x0452, 0x0484,
      0x04e2, 0x04e5, 0x44c8, 0x04e4, 0x04e6, 0x04e9, 0x0532, 0x0531,
      0x0567, 0x0565, 0x0568, 0x0566, 0x0587, 0x0588, 0x0598, 0x05f3,
      0x05f6, 0x45fc, 0x05ee, 0x0627, 0x0647, 0x0644, 0x0648, 0x0645,
      0x0665, 0x0687, 0x0681, 0x0682, 0x4695, 0x06c4, 0x06dc, 0x06fc,
      0x06fd, 0x06fb, 0x0776, 0x0781, 0x0768, 0x076b, 0x0780, 0x079c,
      0x476f, 0x078c, 0x0799, 0x0784, 0x078d, 0x0788, 0x07bc, 0x0785,
      0x0795, 0x0789, 0x0792, 0x078e, 0x0797, 0x080c, 0x0824, 0x08b9,
      0x08ae, 0x08c9, 0x08c5, 0x08d5, 0x08c8, 0x08c7, 0x4882, 0x08cc,
      0x08d4, 0x08cb, 0x08d3, 0x08cd, 0x08d7, 0x08d8, 0x08a3, 0x08da,
      0x08d6, 0x08cf, 0x0907, 0x08ce, 0x487e, 0x096c, 0x096f, 0x096d,
      0x096e, 0x0980, 0x097f, 0x0990, 0x09e0, 0x09e2, 0x09e4, 0x09e5,
      0x09e1, 0x09ec, 0x09e7, 0x4987, 0x09e6, 0x0a16, 0x0a17, 0x0a29,
      0x0a28, 0x0ada, 0x0aca, 0x0ad0, 0x0acd, 0x0acc, 0x0adf, 0x0acf,
      0x4aa4, 0x0ad5, 0x0ad2, 0x0ad9, 0x0ac9, 0x0ad8, 0x0ad1, 0x0ac7,
      0x0ac8, 0x0ae0, 0x0ae2, 0x0ae1, 0x0ac6, 0x0ace, 0x0b00, 0x0adc,
      0x0b85, 0x0b88, 0x0b89, 0x0bb3, 0x0bb2, 0x0bc3, 0x0bda, 0x4c1d,
      0x0be8, 0x4c1c, 0x0cbf, 0x0cc2, 0x0cd9, 0x0cb8, 0x4d13, 0x0ccf,
      0x0cc8, 0x0cb7, 0x0cbb, 0x0cb9, 0x0cb5, 0x0ccd, 0x0ccc, 0x0cba,
      0x0ccb, 0x0cd1, 0x0cbe, 0x0cbc, 0x0cd2, 0x0cc1, 0x0cc9, 0x0cc3,
      0x0cbd, 0x0cc5, 0x0cb6, 0x0cc4, 0x0cf8, 0x0d12, 0x0cb3, 0x0cca,
      0x4d1c, 0x0cc6, 0x0cd3, 0x0cdc, 0x4cf9, 0x0dd2, 0x0dd3, 0x0dd6,
      0x0dd7, 0x0dd5, 0x0dd8, 0x0de2, 0x0dd4, 0x0e46, 0x4f64, 0x0e5f,
      0x0e92, 0x0e8d, 0x0e91, 0x0e8e, 0x5041, 0x0ef1, 0x0ef5, 0x0eec,
      0x0eee, 0x0ef8, 0x0ef7, 0x0ef6, 0x0ef4, 0x0eeb, 0x0eef, 0x0ef0,
      0x0f5f, 0x0f60, 0x0f85, 0x0f84, 0x0fbf, 0x0fbb, 0x0fbd, 0x5103,
      0x0fba, 0x0fbc, 0x5102, 0x1002, 0x1003, 0x100f, 0x100e, 0x101b,
      0x102e, 0x5178, 0x109c, 0x10bd, 0x10c1, 0x10c3, 0x1167, 0x1164,
      0x1165, 0x1163, 0x1161, 0x11a3, 0x11a2, 0x11a0, 0x11c3, 0x11c2,
      0x11e7, 0x11f3, 0x11e5, 0x11ee, 0x11f0, 0x11f2, 0x11eb, 0x11e9,
      0x11ed, 0x11ef, 0x1275, 0x1278, 0x12d3, 0x12ce, 0x12d7, 0x12cf,
      0x12b9, 0x12d9, 0x12dc, 0x12d4, 0x12d6, 0x12d5, 0x12da, 0x12dd,
      0x032a, 0x13b6, 0x13b7, 0x13d5, 0x13f5, 0x1406, 0x1455, 0x1454,
      0x144f, 0x1452, 0x1450, 0x144b, 0x144d, 0x144c, 0x554f, 0x1453,
      0x1458, 0x14a9, 0x14ad, 0x1564, 0x1570, 0x5634, 0x1575, 0x1562,
      0x1559, 0x1573, 0x1558, 0x1566, 0x1568, 0x156a, 0x1587, 0x1572,
      0x1567, 0x1574, 0x1579, 0x156e, 0x1569, 0x155c, 0x1581, 0x1576,
      0x1532, 0x1563, 0x157c, 0x1560, 0x1554, 0x164f, 0x167a, 0x1678,
      0x167f, 0x57dd, 0x1679, 0x167c, 0x57e5, 0x0001, 0x1706, 0x172c,
      0x172d, 0x172b, 0x1779, 0x1782, 0x17c7, 0x17d6, 0x17d1, 0x17d5,
      0x17c6, 0x17c9, 0x17d0, 0x17d4, 0x17ce, 0x17ca, 0x17c3, 0x17c5,
      0x17c4, 0x17d2, 0x1880, 0x188d, 0x18a4, 0x18ad, 0x18a6, 0x18ae,
      0x18b1, 0x18ac, 0x18b0, 0x18a7, 0x18aa, 0x18a8, 0x18af, 0x18a9,
      0x18f6, 0x18f5, 0x18f3, 0x1908, 0x190f, 0x1905, 0x190d, 0x190a,
      0x1907, 0x190e, 0x5a5b, 0x5ace, 0x1977, 0x197a, 0x19b5, 0x19f9,
      0x19fc, 0x19fa, 0x19fe, 0x19fb, 0x19fd, 0x1a67, 0x1a63, 0x1a6b,
      0x5b74, 0x1a8f, 0x1a8e, 0x1ac4, 0x1ad8, 0x1ad9, 0x5bfa, 0x5bfb,
      0x1ada, 0x1ad4, 0x1ad6, 0x1ad2, 0x5bec, 0x1b7c, 0x1b78, 0x1b76,
      0x1b79, 0x1b7b, 0x1b7a, 0x1b77, 0x1bda, 0x1bdc, 0x1bdb, 0x1bd2,
      0x1bd6, 0x1bd7, 0x1bd4, 0x1bca, 0x1bd5, 0x1bf7, 0x1bf9, 0x1bf8,
      0x1bfa, 0x1bfb, 0x1c12, 0x1c15, 0x1c72, 0x1c8d, 0x1c8f, 0x1c90,
      0x1cd9, 0x1cdb, 0x1cdf, 0x1cda, 0x1cde, 0x1cdd, 0x1d22, 0x1d21,
      0x1e7e, 0x1e82, 0x1e87, 0x0034, 0x0114, 0x0118, 0x0115, 0x0116,
      0x011c, 0x011a, 0x0113, 0x0119, 0x40ea, 0x40f2, 0x011d, 0x01e5,
      0x418b, 0x01e4, 0x020f, 0x0213, 0x0212, 0x0210, 0x0211, 0x0235,
      0x034a, 0x427e, 0x0345, 0x427f, 0x0342, 0x0349, 0x0343, 0x0344,
      0x034b, 0x034c, 0x4294, 0x0347, 0x427d, 0x0341, 0x0352, 0x4293,
      0x0353, 0x03ba, 0x03bb, 0x0419, 0x0413, 0x0418, 0x0417, 0x0416,
      0x0414, 0x041a, 0x0412, 0x43be, 0x0410, 0x041b, 0x041e, 0x0411,
      0x0487, 0x04f4, 0x04f7, 0x04f9, 0x04f2, 0x04f1, 0x04f0, 0x04ed,
      0x04f5, 0x04fa, 0x05f9, 0x05fc, 0x064a, 0x065f, 0x0686, 0x0685,
      0x06ae, 0x06cf, 0x06fe, 0x0700, 0x079a, 0x0796, 0x07ac, 0x079d,
      0x0787, 0x079b, 0x078b, 0x078f, 0x0791, 0x07a5, 0x07af, 0x07a9,
      0x079e, 0x07a6, 0x07a3, 0x079f, 0x0794, 0x0790, 0x07a4, 0x080f,
      0x080d, 0x08e6, 0x4883, 0x4897, 0x08f0, 0x08f2, 0x08d2, 0x08f1,
      0x08e4, 0x08ea, 0x08e7, 0x08e3, 0x08f5, 0x08e8, 0x08e9, 0x08e1,
      0x0971, 0x0988, 0x0992, 0x09ee, 0x09f3, 0x09ea, 0x09f2, 0x09ed,
      0x09e9, 0x09ef, 0x09eb, 0x0a19, 0x0b0a, 0x0afe, 0x0af6, 0x0b02,
      0x0af9, 0x0af1, 0x0b01, 0x0aea, 0x0b2d, 0x0aef, 0x0b07, 0x0afd,
      0x0af7, 0x0af0, 0x0b03, 0x0afa, 0x0af8, 0x0afc, 0x0b06, 0x0b8d,
      0x0ba3, 0x0bc6, 0x0bc5, 0x0bce, 0x4c05, 0x0ce4, 0x0ceb, 0x0cfc,
      0x0cee, 0x0cf4, 0x0cdd, 0x0ce1, 0x0d01, 0x0cf7, 0x0ce6, 0x0d00,
      0x0cf1, 0x0cf0, 0x0cea, 0x0cfb, 0x0cde, 0x0ce0, 0x0cf6, 0x0cfd,
      0x0ce9, 0x0ce7, 0x4d4c, 0x0de1, 0x4ec5, 0x0ded, 0x0de9, 0x0dde,
      0x0dec, 0x0de6, 0x0df0, 0x0deb, 0x0de0, 0x0dea, 0x0de7, 0x4ec6,
      0x0dee, 0x0de5, 0x0e37, 0x0e47, 0x0e93, 0x0e9c, 0x0e99, 0x0e98,
      0x0f12, 0x0f00, 0x0efe, 0x0f04, 0x0f03, 0x0f07, 0x504e, 0x0eff,
      0x0f01, 0x0f02, 0x0f8d, 0x0f8e, 0x0fc8, 0x0fc1, 0x0fc9, 0x0fc2,
      0x510a, 0x0fc4, 0x0fc7, 0x0fc3, 0x0fc2, 0x1030, 0x1031, 0x1068,
      0x1070, 0x106f, 0x106a, 0x106e, 0x1074, 0x106b, 0x517f, 0x1069,
      0x1073, 0x1062, 0x106d, 0x109d, 0x10c7, 0x10da, 0x10c9, 0x520f,
      0x10c6, 0x5210, 0x10c8, 0x10cd, 0x10ce, 0x521a, 0x1124, 0x1125,
      0x1127, 0x157e, 0x1143, 0x116e, 0x116c, 0x1170, 0x1169, 0x116f,
      0x52d0, 0x11a4, 0x11a5, 0x5355, 0x121a, 0x11f4, 0x11fa, 0x11f8,
      0x127b, 0x127e, 0x1277, 0x12ea, 0x12df, 0x12e9, 0x12e2, 0x12e8,
      0x12d0, 0x1387, 0x1384, 0x1385, 0x138a, 0x13a6, 0x13a5, 0x13a4,
      0x13f6, 0x13f7, 0x1407, 0x1405, 0x145d, 0x145c, 0x145e, 0x1456,
      0x145a, 0x1467, 0x1459, 0x145f, 0x5566, 0x1457, 0x149f, 0x14c0,
      0x159a, 0x1596, 0x1583, 0x157f, 0x1595, 0x158d, 0x158f, 0x1585,
      0x1590, 0x158a, 0x157d, 0x1580, 0x158b, 0x158c, 0x158e, 0x1591,
      0x1584, 0x1651, 0x1650, 0x1652, 0x1689, 0x1687, 0x1685, 0x1684,
      0x168b, 0x1680, 0x168a, 0x1682, 0x1683, 0x57f1, 0x168e, 0x1707,
      0x1739, 0x1733, 0x1736, 0x1737, 0x1735, 0x1738, 0x58c4, 0x172e,
      0x1734, 0x1732, 0x1784, 0x179b, 0x17dd, 0x17e3, 0x17e4, 0x17db,
      0x17dc, 0x17e1, 0x17ea, 0x17e5, 0x17d9, 0x17f6, 0x17e2, 0x17e9,
      0x17df, 0x17d8, 0x17e0, 0x17de, 0x17ec, 0x5952, 0x17c8, 0x594b,
      0x1881, 0x1891, 0x1890, 0x18b9, 0x18b7, 0x18b8, 0x18b5, 0x18a5,
      0x18b4, 0x18b3, 0x18b6, 0x1913, 0x1912, 0x1915, 0x1918, 0x191a,
      0x5a61, 0x1916, 0x5a5e, 0x5a65, 0x1967, 0x197d, 0x1980, 0x197c,
      0x1983, 0x19b6, 0x19c1, 0x1a07, 0x1a06, 0x1a0e, 0x1a03, 0x1a0f,
      0x1a00, 0x1a10, 0x1a0b, 0x1a01, 0x1a0a, 0x1a09, 0x1a08, 0x1a0c,
      0x1a05, 0x1a02, 0x1a68, 0x1a6c, 0x1a94, 0x1a93, 0x1a92, 0x1ac0,
      0x5c13, 0x1ae3, 0x1adc, 0x5c14, 0x5c1c, 0x5c1d, 0x1ae4, 0x1ae8,
      0x1ae7, 0x5c1b, 0x1adb, 0x1ae1, 0x5c15, 0x1ae0, 0x5c19, 0x1adf,
      0x5c0a, 0x1b7d, 0x1be1, 0x1bdd, 0x1bde, 0x1bff, 0x1bfd, 0x1bfc,
      0x1c01, 0x1c17, 0x1c19, 0x1c18, 0x1c16, 0x1c3f, 0x1c4f, 0x1c51,
      0x1c93, 0x1c94, 0x1c97, 0x1c98, 0x1c95, 0x1c91, 0x1ce1, 0x1ce0,
      0x1ce2, 0x1ce3, 0x1d23, 0x1d25, 0x1d24, 0x1d8a, 0x1e02, 0x1e5e,
      0x1ea4, 0x1ea9, 0x1eb1, 0x012c, 0x012e, 0x012b, 0x0128, 0x012d,
      0x0129, 0x0127, 0x0120, 0x0126, 0x0121, 0x0122, 0x0125, 0x0160,
      0x01a3, 0x01e7, 0x01e6, 0x0236, 0x0276, 0x0367, 0x42a7, 0x42a8,
      0x035f, 0x0366, 0x0364, 0x0357, 0x0359, 0x42a6, 0x0363, 0x0365,
      0x035e, 0x42a5, 0x0358, 0x035b, 0x036a, 0x03bd, 0x03bc, 0x0421,
      0x0424, 0x0428, 0x0415, 0x042b, 0x0422, 0x0429, 0x43dc, 0x0454,
      0x0467, 0x0465, 0x0466, 0x0489, 0x0488, 0x04ff, 0x0501, 0x0502,
      0x04fd, 0x04fc, 0x0504, 0x0500, 0x0537, 0x056d, 0x0564, 0x056f,
      0x0572, 0x0573, 0x0574, 0x0570, 0x0571, 0x056e, 0x0589, 0x05b3,
      0x05ff, 0x0600, 0x0659, 0x0652, 0x064c, 0x064d, 0x064b, 0x068a,
      0x068b, 0x06a9, 0x46c6, 0x06dd, 0x0704, 0x07ab, 0x07a7, 0x07ae,
      0x07c4, 0x07b8, 0x07b9, 0x07b7, 0x07b6, 0x07b3, 0x07c2, 0x0812,
      0x090d, 0x08fa, 0x48ad, 0x0917, 0x0903, 0x08fb, 0x0905, 0x0906,
      0x08fd, 0x08f3, 0x08ff, 0x48b1, 0x0972, 0x0989, 0x4942, 0x09a6,
      0x09f1, 0x09fb, 0x09f0, 0x0b0f, 0x0b12, 0x0b0b, 0x0b1a, 0x0b15,
      0x0b22, 0x0b1d, 0x0b0e, 0x0b26, 0x0b18, 0x0b13, 0x0b17, 0x0b21,
      0x0b1f, 0x0b14, 0x0b1e, 0x0b10, 0x0b29, 0x4b21, 0x0b8f, 0x0b90,
      0x0bed, 0x0d21, 0x0d14, 0x0d0c, 0x0d13, 0x0d08, 0x0d2d, 0x0d23,
      0x0d17, 0x0d1c, 0x0d11, 0x0d0f, 0x0d18, 0x0d0d, 0x0d05, 0x0d10,
      0x0d1f, 0x0d22, 0x0d20, 0x0d19, 0x0d32, 0x0d1b, 0x0d2e, 0x0d48,
      0x0d1a, 0x0d09, 0x0d0e, 0x0d06, 0x0cf9, 0x0d26, 0x0dfb, 0x0de4,
      0x0df1, 0x0df6, 0x0df3, 0x0df8, 0x0e3b, 0x0e63, 0x0e64, 0x0e9b,
      0x0e9e, 0x0f0c, 0x0f0b, 0x0f0e, 0x0f0f, 0x506d, 0x0f4a, 0x0f98,
      0x0fdd, 0x0fce, 0x0fcd, 0x0fcc, 0x0fd2, 0x1033, 0x1034, 0x518a,
      0x518b, 0x1075, 0x106c, 0x10de, 0x10d4, 0x10d6, 0x5221, 0x10d7,
      0x10d5, 0x112a, 0x112b, 0x1129, 0x1173, 0x1174, 0x11a8, 0x11a7,
      0x11c6, 0x11c7, 0x120b, 0x1206, 0x1200, 0x11fd, 0x1207, 0x1209,
      0x1205, 0x120c, 0x1218, 0x1204, 0x536c, 0x127d, 0x53e0, 0x1281,
      0x12fd, 0x12f4, 0x12ec, 0x12fe, 0x1302, 0x12ed, 0x1304, 0x12f8,
      0x12f5, 0x12f6, 0x12fc, 0x12ee, 0x130b, 0x12f9, 0x12fa, 0x12f2,
      0x1308, 0x1303, 0x12f1, 0x1388, 0x13ba, 0x13bb, 0x13b9, 0x13f9,
      0x13f8, 0x1408, 0x1451, 0x1462, 0x1465, 0x1468, 0x1469, 0x1461,
      0x1463, 0x148a, 0x1496, 0x14a0, 0x55a4, 0x14ae, 0x14c1, 0x15b2,
      0x15ac, 0x15b1, 0x15b0, 0x15a0, 0x15a3, 0x15a7, 0x15a1, 0x15b4,
      0x15a8, 0x15ad, 0x15bb, 0x159d, 0x15ab, 0x15b8, 0x15b3, 0x57f9,
      0x1692, 0x16b0, 0x169d, 0x1696, 0x1699, 0x1690, 0x16a1, 0x16ae,
      0x1695, 0x173f, 0x174a, 0x1740, 0x1743, 0x1741, 0x1744, 0x173b,
      0x1751, 0x173c, 0x17fb, 0x17ed, 0x17f5, 0x17f8, 0x17ee, 0x17f7,
      0x17f1, 0x17f9, 0x17fd, 0x17fa, 0x17fc, 0x17f3, 0x17f0, 0x17f4,
      0x0001, 0x1883, 0x1893, 0x1892, 0x18bd, 0x18bb, 0x18bc, 0x18ea,
      0x18f8, 0x18f7, 0x191e, 0x1986, 0x1984, 0x1987, 0x1985, 0x19b8,
      0x1a16, 0x1a11, 0x1a14, 0x1a18, 0x1a12, 0x1a15, 0x1a19, 0x1a1a,
      0x1a13, 0x1a6e, 0x1a6f, 0x1a71, 0x1a96, 0x1a98, 0x1a97, 0x1a99,
      0x1aea, 0x5c86, 0x1aec, 0x1aee, 0x1af4, 0x1af3, 0x5c4c, 0x1af2,
      0x1af6, 0x5c48, 0x5c4a, 0x1af1, 0x1b7f, 0x1b83, 0x1b84, 0x1b81,
      0x1b82, 0x1b80, 0x1be2, 0x1be4, 0x1be3, 0x1bfe, 0x1c02, 0x1c1a,
      0x5e6c, 0x1c50, 0x1c84, 0x1c9c, 0x1c9d, 0x1cc6, 0x5ec2, 0x1ce6,
      0x1ce7, 0x1ceb, 0x1ce9, 0x1d27, 0x1d76, 0x1d78, 0x1d8d, 0x1db8,
      0x1db9, 0x1e06, 0x1e07, 0x1e05, 0x1e7b, 0x1eb9, 0x1ebf, 0x0136,
      0x0134, 0x0132, 0x0130, 0x0131, 0x0135, 0x0138, 0x0139, 0x410c,
      0x019c, 0x01e9, 0x01ea, 0x01eb, 0x01ee, 0x01ec, 0x0215, 0x0278,
      0x42bc, 0x0373, 0x0372, 0x036d, 0x0374, 0x036e, 0x0369, 0x0360,
      0x0378, 0x42bd, 0x0383, 0x0370, 0x036c, 0x036b, 0x0426, 0x0432,
      0x0431, 0x0437, 0x042f, 0x0435, 0x0434, 0x043a, 0x048b, 0x050b,
      0x450e, 0x050c, 0x4510, 0x050d, 0x050a, 0x057a, 0x0579, 0x0577,
      0x0578, 0x05b5, 0x05b6, 0x462b, 0x0602, 0x0651, 0x064f, 0x0650,
      0x0693, 0x068c, 0x0690, 0x068e, 0x0694, 0x0691, 0x06c6, 0x06de,
      0x0703, 0x0702, 0x07c3, 0x07bb, 0x07be, 0x07b5, 0x07b2, 0x07c8,
      0x07c5, 0x07bf, 0x07bd, 0x07c6, 0x07d2, 0x07cb, 0x07d6, 0x07cf,
      0x07d5, 0x07ce, 0x07d1, 0x07cd, 0x07d7, 0x0814, 0x08fe, 0x0900,
      0x0904, 0x0916, 0x091d, 0x090e, 0x090f, 0x091c, 0x0918, 0x0911,
      0x0912, 0x090c, 0x0910, 0x091b, 0x091a, 0x0919, 0x0914, 0x091e,
      0x0913, 0x48c7, 0x48c8, 0x0974, 0x0975, 0x0976, 0x09f6, 0x09f4,
      0x09f8, 0x09f7, 0x0b3c, 0x0b3a, 0x0b2b, 0x0b32, 0x0b39, 0x0b37,
      0x0b30, 0x0b3b, 0x0b35, 0x0b34, 0x0b2e, 0x0b33, 0x0b3e, 0x4b39,
      0x0b28, 0x0b92, 0x0b91, 0x0bb7, 0x0bc7, 0x0bc8, 0x0d24, 0x0d40,
      0x0d45, 0x0d34, 0x0d3c, 0x0d35, 0x0d46, 0x0d3d, 0x0d37, 0x0d42,
      0x0d3e, 0x0d4b, 0x0d43, 0x0d3f, 0x0d3b, 0x4da1, 0x0d36, 0x0cfe,
      0x0d52, 0x0d4f, 0x0d38, 0x0dfa, 0x0dfd, 0x0dff, 0x0dfc, 0x0e49,
      0x4f76, 0x4fc4, 0x0ea0, 0x0f0d, 0x0f18, 0x0f17, 0x0f1a, 0x0f16,
      0x0f8f, 0x0fd7, 0x5116, 0x0fd6, 0x0fda, 0x0fdc, 0x0fd8, 0x0fd9,
      0x1012, 0x101e, 0x1035, 0x107b, 0x5195, 0x5198, 0x107c, 0x1079,
      0x10e2, 0x10df, 0x10db, 0x10e0, 0x10dd, 0x10e6, 0x10dc, 0x10e3,
      0x1179, 0x1177, 0x117a, 0x1178, 0x1175, 0x1176, 0x530d, 0x11aa,
      0x1214, 0x1216, 0x121c, 0x1217, 0x121d, 0x121e, 0x121b, 0x120a,
      0x123b, 0x1283, 0x130d, 0x1316, 0x1315, 0x1317, 0x1309, 0x1314,
      0x130a, 0x1312, 0x130e, 0x5455, 0x130c, 0x1313, 0x545f, 0x131a,
      0x131d, 0x131f, 0x138e, 0x138f, 0x13a7, 0x13bf, 0x13e8, 0x146c,
      0x146d, 0x146e, 0x146f, 0x146b, 0x5576, 0x15d3, 0x15df, 0x15d4,
      0x15c3, 0x15e0, 0x15d9, 0x15d1, 0x15cf, 0x15d8, 0x15d7, 0x15dd,
      0x15c2, 0x15db, 0x15cd, 0x15cb, 0x169c, 0x16b6, 0x16ad, 0x16a7,
      0x16aa, 0x16b7, 0x16b2, 0x16a4, 0x16a2, 0x16b1, 0x16a0, 0x170a,
      0x1709, 0x174c, 0x1746, 0x58de, 0x174d, 0x58dd, 0x1747, 0x1802,
      0x180c, 0x1807, 0x1806, 0x17f2, 0x1809, 0x181f, 0x17ff, 0x1808,
      0x1805, 0x1804, 0x17fe, 0x180e, 0x180a, 0x1800, 0x1801, 0x1811,
      0x1875, 0x1878, 0x1885, 0x18c5, 0x18c3, 0x18ca, 0x18c9, 0x18cc,
      0x18ce, 0x18c7, 0x18c8, 0x18c1, 0x18cb, 0x18c6, 0x18eb, 0x5a38,
      0x18f9, 0x5a7a, 0x1920, 0x1923, 0x1925, 0x191f, 0x5a82, 0x192a,
      0x1929, 0x1924, 0x196b, 0x198c, 0x198a, 0x198d, 0x198f, 0x198e,
      0x1990, 0x198b, 0x1991, 0x1993, 0x1a1c, 0x1a1e, 0x1a1b, 0x1a1d,
      0x1a24, 0x1a77, 0x1a76, 0x1a74, 0x1a78, 0x1a9f, 0x1aa0, 0x1aa2,
      0x1a9c, 0x1ac6, 0x5c84, 0x1afa, 0x1b05, 0x1b03, 0x5c6a, 0x1af8,
      0x1afc, 0x1b00, 0x5c62, 0x5c63, 0x1b07, 0x1b87, 0x1b88, 0x1c1d,
      0x1c20, 0x1c21, 0x1c1f, 0x1c45, 0x1c56, 0x1c58, 0x1c57, 0x1c9f,
      0x1ca4, 0x5ea3, 0x5ec4, 0x1cea, 0x1cf0, 0x1cef, 0x1cf3, 0x1d32,
      0x1d29, 0x1d33, 0x1d2f, 0x1d2a, 0x1d2c, 0x1d2b, 0x1d2e, 0x1d79,
      0x1d91, 0x5f77, 0x1da9, 0x1dbd, 0x1dbb, 0x5fa4, 0x1dcb, 0x1e0a,
      0x1e0d, 0x1e0e, 0x60dc, 0x1e7c, 0x1e84, 0x0433, 0x1ec4, 0x0140,
      0x0144, 0x0141, 0x013f, 0x0142, 0x0172, 0x0185, 0x019d, 0x01ef,
      0x01f0, 0x0216, 0x42c5, 0x037f, 0x42c6, 0x037d, 0x037b, 0x0387,
      0x037e, 0x037c, 0x0385, 0x0388, 0x0381, 0x0380, 0x0379, 0x0384,
      0x043c, 0x043b, 0x043e, 0x043d, 0x048c, 0x4515, 0x0513, 0x0533,
      0x057b, 0x058a, 0x06c7, 0x07d9, 0x07cc, 0x07d4, 0x07ca, 0x07e7,
      0x07db, 0x07dd, 0x07e4, 0x07e2, 0x0815, 0x0927, 0x0924, 0x092a,
      0x0921, 0x0922, 0x0932, 0x0926, 0x0928, 0x0925, 0x092b, 0x48e4,
      0x092e, 0x092f, 0x0923, 0x0973, 0x49c3, 0x09fc, 0x09fa, 0x49c2,
      0x0a00, 0x49bf, 0x0b46, 0x0b43, 0x0b55, 0x0b4c, 0x0b51, 0x0b58,
      0x0b45, 0x0b48, 0x0b54, 0x0b4f, 0x0b4a, 0x4b66, 0x0b44, 0x0b4e,
      0x0b49, 0x0b95, 0x0ba4, 0x0bdd, 0x4db1, 0x0d6a, 0x0d58, 0x0d62,
      0x0d5b, 0x0d60, 0x0d66, 0x0d5d, 0x0d5f, 0x0d5e, 0x0d6c, 0x0d65,
      0x0d63, 0x0d69, 0x0e05, 0x4ef9, 0x0e08, 0x0e0f, 0x0e0d, 0x0e11,
      0x0e04, 0x0e0e, 0x0e0a, 0x4efa, 0x0e0b, 0x0e0c, 0x0ea3, 0x0f22,
      0x0f23, 0x0f24, 0x0f26, 0x0f25, 0x0f3f, 0x0f4d, 0x0f4e, 0x0fe2,
      0x511d, 0x0fec, 0x1037, 0x1036, 0x107e, 0x107d, 0x5199, 0x1080,
      0x10ed, 0x10eb, 0x10ee, 0x10ec, 0x1133, 0x1180, 0x1181, 0x117c,
      0x117f, 0x117e, 0x11b1, 0x1223, 0x1229, 0x121f, 0x1228, 0x537b,
      0x1227, 0x122c, 0x122d, 0x1285, 0x1287, 0x1322, 0x132a, 0x1320,
      0x1326, 0x1329, 0x132c, 0x1327, 0x1321, 0x1324, 0x1390, 0x13a8,
      0x13c4, 0x54da, 0x13c2, 0x13e9, 0x1472, 0x1470, 0x5583, 0x1497,
      0x14a1, 0x14c6, 0x14c7, 0x15e5, 0x15ea, 0x15f6, 0x15ef, 0x15f0,
      0x15e3, 0x15e4, 0x15f2, 0x15f1, 0x15ec, 0x16c0, 0x16bc, 0x16ba,
      0x16bd, 0x16b8, 0x170b, 0x174b, 0x1756, 0x1752, 0x1754, 0x1750,
      0x1788, 0x1786, 0x1817, 0x1820, 0x1819, 0x181c, 0x1824, 0x1827,
      0x1818, 0x181b, 0x1823, 0x1825, 0x1826, 0x181e, 0x181a, 0x181d,
      0x182a, 0x1822, 0x1884, 0x1886, 0x1894, 0x18cf, 0x1934, 0x1935,
      0x192d, 0x1933, 0x5a8a, 0x192e, 0x1999, 0x1995, 0x1997, 0x1996,
      0x19bb, 0x19ba, 0x1a22, 0x1a21, 0x1a25, 0x1a20, 0x1a29, 0x1a27,
      0x1a79, 0x1aa5, 0x1b10, 0x5c95, 0x1b08, 0x1b6d, 0x1b16, 0x1b11,
      0x1b09, 0x1b14, 0x1b0a, 0x1b0f, 0x1b0b, 0x1b12, 0x1b18, 0x1b0c,
      0x1b15, 0x1b0e, 0x1b8b, 0x1be7, 0x1bef, 0x1be9, 0x1c03, 0x1c23,
      0x1c25, 0x1c27, 0x1c22, 0x1c26, 0x1c24, 0x1c41, 0x1c42, 0x1c49,
      0x1c5a, 0x1ca7, 0x1caa, 0x1cac, 0x1c96, 0x1ca5, 0x1cab, 0x1ca0,
      0x1cec, 0x1cfb, 0x1cf7, 0x1cf4, 0x1cf6, 0x1cf5, 0x1d38, 0x1d36,
      0x1d3a, 0x1d7a, 0x1d7b, 0x1d95, 0x1d90, 0x1da8, 0x1dd5, 0x6038,
      0x1e12, 0x1e13, 0x1e14, 0x1e15, 0x1e10, 0x1e89, 0x1e88, 0x1ed5,
      0x1eda, 0x0147, 0x0146, 0x411e, 0x0148, 0x0218, 0x42ce, 0x0389,
      0x42cf, 0x038a, 0x038b, 0x038c, 0x0443, 0x0442, 0x0441, 0x0440,
      0x0519, 0x0514, 0x0515, 0x0534, 0x457d, 0x05b8, 0x060a, 0x0609,
      0x060b, 0x0603, 0x0654, 0x06c8, 0x0706, 0x07e3, 0x07e0, 0x07e1,
      0x07f0, 0x07e5, 0x0816, 0x0817, 0x092c, 0x0929, 0x0931, 0x0935,
      0x48f3, 0x0939, 0x093a, 0x093c, 0x0937, 0x093e, 0x0979, 0x097a,
      0x0a02, 0x49cc, 0x0b59, 0x0b5d, 0x0b5b, 0x0b62, 0x0b5e, 0x0af2,
      0x0b63, 0x4b8d, 0x4b8e, 0x0b5c, 0x0b61, 0x4bd9, 0x0bbb, 0x4bf7,
      0x0be1, 0x0d6e, 0x0d7d, 0x0d74, 0x0d75, 0x0d73, 0x0d77, 0x0d78,
      0x0d7b, 0x0d44, 0x0d79, 0x0d76, 0x0d7f, 0x0d70, 0x0d7a, 0x0d7c,
      0x0e16, 0x0e12, 0x0e1a, 0x0e15, 0x0e14, 0x0e18, 0x0e17, 0x4f1f,
      0x0e13, 0x0e33, 0x0e41, 0x0eb1, 0x0ea8, 0x50a1, 0x0f2b, 0x50a2,
      0x0f29, 0x0fe8, 0x0fe6, 0x511e, 0x103b, 0x1083, 0x107f, 0x1086,
      0x1082, 0x1081, 0x1085, 0x109f, 0x10f4, 0x10f1, 0x10fb, 0x10ef,
      0x10f3, 0x1136, 0x1137, 0x1182, 0x5312, 0x1236, 0x1238, 0x123c,
      0x1233, 0x1239, 0x1226, 0x128d, 0x1289, 0x128b, 0x53f0, 0x128c,
      0x128f, 0x128a, 0x546e, 0x1339, 0x133c, 0x1335, 0x1331, 0x5473,
      0x132f, 0x1338, 0x1330, 0x133b, 0x132b, 0x1340, 0x1336, 0x1341,
      0x1333, 0x5475, 0x547b, 0x1371, 0x13c5, 0x13c9, 0x550a, 0x13fc,
      0x13fb, 0x13fa, 0x13fd, 0x147c, 0x558c, 0x1473, 0x147a, 0x1479,
      0x1478, 0x1475, 0x147d, 0x1477, 0x148b, 0x14a2, 0x14d1, 0x160f,
      0x15ff, 0x15fc, 0x160b, 0x1605, 0x1606, 0x15f4, 0x1609, 0x1601,
      0x160d, 0x1604, 0x160c, 0x1657, 0x16cf, 0x5846, 0x16ce, 0x16d5,
      0x16d0, 0x16c2, 0x16c5, 0x16c4, 0x16d1, 0x16d2, 0x175a, 0x1759,
      0x175c, 0x176d, 0x58ed, 0x1789, 0x1831, 0x1834, 0x1835, 0x1837,
      0x1830, 0x183a, 0x1838, 0x182b, 0x1832, 0x186f, 0x186e, 0x1887,
      0x18d2, 0x18d5, 0x18d4, 0x18d7, 0x18d3, 0x18fb, 0x193a, 0x1958,
      0x1939, 0x193b, 0x19a1, 0x199e, 0x19a0, 0x19a2, 0x199f, 0x1a2b,
      0x1a2a, 0x1a2f, 0x1a2d, 0x1a2e, 0x1a2c, 0x1a7c, 0x5bb9, 0x1aa8,
      0x1aa7, 0x1b23, 0x5cfa, 0x1b13, 0x1b1f, 0x1b19, 0x1b27, 0x1b1a,
      0x1b0d, 0x1b21, 0x1b1e, 0x1b1b, 0x1b29, 0x5cf5, 0x1b24, 0x1b93,
      0x1b94, 0x1b95, 0x1b91, 0x1ba6, 0x1bec, 0x1bf1, 0x1c05, 0x1c28,
      0x1c29, 0x1c5f, 0x1c71, 0x1cad, 0x1cc7, 0x5eed, 0x1d40, 0x1d3e,
      0x1dd7, 0x1dd8, 0x1dd3, 0x5fb8, 0x1e17, 0x1e18, 0x1e64, 0x1e83,
      0x1e8c, 0x1e8b, 0x1e8d, 0x1e8a, 0x1ebb, 0x1ec0, 0x028e, 0x42df,
      0x0393, 0x0446, 0x0445, 0x051a, 0x06d0, 0x07ee, 0x0813, 0x0940,
      0x093f, 0x0943, 0x48f7, 0x0941, 0x0942, 0x0933, 0x0993, 0x0a05,
      0x0a2b, 0x0b67, 0x0b64, 0x0b6a, 0x0b68, 0x0b53, 0x0b69, 0x0b65,
      0x0b66, 0x0b98, 0x0ba5, 0x0bbc, 0x0d7e, 0x0d94, 0x0d83, 0x0d84,
      0x0d81, 0x0d86, 0x0d85, 0x0e19, 0x0e1c, 0x0e1e, 0x4f22, 0x0eab,
      0x0eac, 0x0f28, 0x0f36, 0x0f52, 0x0feb, 0x0fee, 0x5121, 0x1089,
      0x108a, 0x1088, 0x51ab, 0x10f6, 0x1139, 0x1184, 0x1186, 0x1187,
      0x11b5, 0x11b6, 0x124a, 0x1247, 0x1249, 0x1241, 0x1244, 0x1243,
      0x1290, 0x1342, 0x1343, 0x1347, 0x1345, 0x1349, 0x134a, 0x1344,
      0x54a1, 0x13c6, 0x13c8, 0x1400, 0x13ff, 0x147f, 0x558f, 0x14a3,
      0x161d, 0x160e, 0x161f, 0x161e, 0x161b, 0x1613, 0x1616, 0x1615,
      0x5855, 0x16d8, 0x16d9, 0x16d7, 0x177a, 0x178b, 0x17a2, 0x183e,
      0x1842, 0x1840, 0x183f, 0x1879, 0x18d9, 0x1940, 0x1942, 0x5a99,
      0x1943, 0x1941, 0x193e, 0x1968, 0x19a7, 0x19a8, 0x1a31, 0x1a32,
      0x1a33, 0x1aad, 0x1aae, 0x1ac5, 0x1b2a, 0x1b37, 0x1b2c, 0x5d30,
      0x5d31, 0x1b36, 0x1b34, 0x1b35, 0x5d2c, 0x1b2e, 0x1b2d, 0x1b9a,
      0x1b9c, 0x1b97, 0x1b9b, 0x1c0c, 0x1c09, 0x1c07, 0x1c08, 0x1c0b,
      0x1c2b, 0x5e7c, 0x1c60, 0x1c63, 0x5e93, 0x1cb1, 0x1cb2, 0x1cb0,
      0x5eb1, 0x1cb4, 0x1cca, 0x5eee, 0x5eef, 0x1d03, 0x1cfd, 0x1d1a,
      0x1d46, 0x5f67, 0x5f80, 0x1d97, 0x1dbe, 0x1dc3, 0x1dc2, 0x1ddc,
      0x1dda, 0x1de3, 0x5fcc, 0x1dd9, 0x1e1e, 0x1e1d, 0x1e1f, 0x1e8e,
      0x1eaa, 0x1eb4, 0x0149, 0x0391, 0x0396, 0x0447, 0x0448, 0x440f,
      0x057c, 0x069a, 0x0697, 0x07f1, 0x07f5, 0x07f4, 0x07f3, 0x0944,
      0x4901, 0x0a08, 0x0a06, 0x4ba6, 0x0b6f, 0x0b6d, 0x0b6c, 0x0d8b,
      0x0d8d, 0x0d8f, 0x0d8a, 0x0d8c, 0x0d88, 0x0d90, 0x0e1f, 0x0e21,
      0x0e4a, 0x0e65, 0x0ead, 0x0eae, 0x0f2e, 0x0f32, 0x0f40, 0x0f91,
      0x0f90, 0x5125, 0x0ff2, 0x108b, 0x10f8, 0x113b, 0x118a, 0x1189,
      0x1250, 0x1251, 0x124c, 0x124f, 0x124b, 0x125b, 0x134d, 0x134e,
      0x1352, 0x134b, 0x134c, 0x1351, 0x1394, 0x13aa, 0x13ac, 0x13ab,
      0x1480, 0x1628, 0x1625, 0x162a, 0x1621, 0x1627, 0x1629, 0x162b,
      0x16dc, 0x16e3, 0x16e5, 0x16db, 0x16dd, 0x1767, 0x1768, 0x1760,
      0x1764, 0x1844, 0x1851, 0x184d, 0x1846, 0x184f, 0x1848, 0x1849,
      0x59a6, 0x184e, 0x18da, 0x18db, 0x5a9c, 0x1948, 0x1954, 0x194a,
      0x194e, 0x194b, 0x1949, 0x5af6, 0x19a9, 0x19bc, 0x1a34, 0x5b48,
      0x1abc, 0x1aaf, 0x1b3f, 0x1b3a, 0x1b44, 0x1b38, 0x1b39, 0x1b3e,
      0x1b40, 0x1b3b, 0x1b41, 0x5d58, 0x1b3d, 0x1b43, 0x1b3c, 0x1b47,
      0x1b9e, 0x1bee, 0x1c0d, 0x1c2e, 0x1c2c, 0x1c46, 0x1c7a, 0x1c85,
      0x1cb8, 0x1cb5, 0x1cb7, 0x1ccc, 0x1d05, 0x1d07, 0x1d49, 0x1d4b,
      0x1d9b, 0x1de2, 0x1ddf, 0x1ddd, 0x5fda, 0x1e26, 0x1e21, 0x1e25,
      0x1e23, 0x1e28, 0x1e68, 0x1e6b, 0x1e69, 0x1e78, 0x021a, 0x039c,
      0x0397, 0x0395, 0x0398, 0x044b, 0x051b, 0x4536, 0x160a, 0x057d,
      0x060c, 0x07f6, 0x07f7, 0x0948, 0x0946, 0x0934, 0x0a09, 0x0a2c,
      0x0b74, 0x0d9a, 0x0d9b, 0x0d99, 0x0e23, 0x0eaf, 0x0f33, 0x0ff3,
      0x0ff4, 0x10fd, 0x10fe, 0x10f9, 0x10ff, 0x11b7, 0x11c8, 0x1255,
      0x1253, 0x1256, 0x1292, 0x53f8, 0x1353, 0x1358, 0x1355, 0x1357,
      0x1375, 0x13cd, 0x1483, 0x14cc, 0x162f, 0x162c, 0x1648, 0x162d,
      0x1634, 0x1639, 0x1635, 0x1636, 0x5872, 0x16e6, 0x176c, 0x178e,
      0x17a3, 0x1857, 0x1855, 0x1852, 0x1856, 0x1853, 0x1854, 0x18de,
      0x18dd, 0x1955, 0x1951, 0x1953, 0x5aa3, 0x1ab1, 0x1abf, 0x1b4c,
      0x1b48, 0x5d60, 0x1ba1, 0x1c2d, 0x1ccd, 0x1d0d, 0x1d0c, 0x1d1b,
      0x1d51, 0x1d52, 0x1d56, 0x1d54, 0x1dea, 0x1de7, 0x1e58, 0x60e0,
      0x1e91, 0x1eb5, 0x1ec8, 0x1ed4, 0x1ec9, 0x014a, 0x4130, 0x039a,
      0x0399, 0x039b, 0x045d, 0x05ba, 0x060e, 0x07f8, 0x07fa, 0x094a,
      0x0949, 0x0981, 0x0a0b, 0x0b79, 0x0b78, 0x0b75, 0x0bbd, 0x0d9f,
      0x0e24, 0x0e66, 0x50b8, 0x0f34, 0x0ff8, 0x108d, 0x1258, 0x1361,
      0x135e, 0x13ad, 0x578a, 0x163f, 0x163b, 0x16ed, 0x16ec, 0x16eb,
      0x16ea, 0x176a, 0x5904, 0x178f, 0x1858, 0x1859, 0x185b, 0x18e0,
      0x1956, 0x193c, 0x1957, 0x19af, 0x19bd, 0x1ab4, 0x1b4f, 0x5d8e,
      0x1b51, 0x1b55, 0x1b53, 0x1b50, 0x1b4e, 0x1ba3, 0x1c32, 0x1c33,
      0x1c30, 0x1c86, 0x1cbd, 0x1cbb, 0x1d10, 0x1d5d, 0x1d5c, 0x1d59,
      0x1d58, 0x1d7f, 0x1dc5, 0x1dc4, 0x1dee, 0x1deb, 0x1e2f, 0x1e31,
      0x1e3c, 0x0001, 0x1e6e, 0x1e92, 0x1ead, 0x6117, 0x1ecb, 0x1ecc,
      0x014c, 0x014b, 0x039f, 0x039e, 0x039d, 0x0536, 0x0611, 0x060f,
      0x06c9, 0x07f2, 0x094e, 0x0b7a, 0x0b9a, 0x0da3, 0x0da4, 0x0eb2,
      0x0f41, 0x0f92, 0x0ffa, 0x0ff9, 0x113c, 0x1261, 0x1260, 0x1402,
      0x1401, 0x1485, 0x1772, 0x1770, 0x17a5, 0x185c, 0x18e2, 0x18e4,
      0x195a, 0x195c, 0x19b0, 0x1a82, 0x1b57, 0x1b5a, 0x1b5b, 0x1c35,
      0x1c37, 0x1c6b, 0x1c6a, 0x1cbe, 0x1d0f, 0x1d64, 0x1d62, 0x1d82,
      0x1da2, 0x1df3, 0x5ffb, 0x5ffc, 0x1df1, 0x1e40, 0x1e3f, 0x6106,
      0x1ece, 0x1ecf, 0x1ed7, 0x42f9, 0x0612, 0x07fb, 0x094d, 0x0950,
      0x094f, 0x0a0c, 0x4bbd, 0x0f37, 0x11b9, 0x1262, 0x53b6, 0x1263,
      0x1364, 0x1360, 0x1365, 0x5597, 0x1643, 0x1644, 0x16f0, 0x185f,
      0x1a36, 0x1a35, 0x1b61, 0x1b5f, 0x1b5c, 0x1c4b, 0x1cbf, 0x1d11,
      0x1d68, 0x1d6b, 0x1d66, 0x1d85, 0x1d83, 0x1d81, 0x1df4, 0x1df9,
      0x1dfb, 0x1e44, 0x1e70, 0x1e93, 0x03a0, 0x044c, 0x0951, 0x0da8,
      0x0ffd, 0x0ffe, 0x108e, 0x1378, 0x1397, 0x16f2, 0x16ef, 0x170c,
      0x1865, 0x1863, 0x1864, 0x14d5, 0x18e5, 0x1ab8, 0x1b62, 0x1c39,
      0x1c3b, 0x1c38, 0x1c6c, 0x1cc0, 0x1d6c, 0x1da5, 0x1dc7, 0x1df6,
      0x1e47, 0x1e48, 0x1e59, 0x1e5a, 0x1ea0, 0x1ed3, 0x1ed1, 0x0699,
      0x0b7d, 0x0da6, 0x1269, 0x1268, 0x16f3, 0x1792, 0x195f, 0x1ab9,
      0x1b65, 0x1b63, 0x1cc1, 0x1d13, 0x1d84, 0x1da4, 0x1e80, 0x0da9,
      0x1091, 0x1867, 0x1b67, 0x5e86, 0x1d6d, 0x1d6f, 0x1368, 0x1869,
      0x1961, 0x5bd0, 0x1b6a, 0x1b6b, 0x1b69, 0x1dfd, 0x1dfe, 0x1e96,
      0x187b, 0x1b6c, 0x1e51, 0x0e2b, 0x1d71, 0x1daf, 0x1e54, 0x1e52,
      0x126b, 0x0022, 0x002d, 0x01a6, 0x022d, 0x0269, 0x4001, 0x4002,
      0x0001, 0x4011, 0x03a3, 0x06e1, 0x4003, 0x4004, 0x4005, 0x4008,
      0x4012, 0x0060, 0x0061, 0x401b, 0x4146, 0x0001, 0x0258, 0x027c,
      0x4314, 0x4421, 0x046e, 0x457a, 0x062b, 0x09af, 0x0bbf, 0x4bf4,
      0x0be9, 0x0e3d, 0x0018, 0x0001, 0x401f, 0x401e, 0x4020, 0x006a,
      0x0068, 0x4024, 0x4170, 0x022e, 0x4173, 0x41b7, 0x0001, 0x4316,
      0x4426, 0x0471, 0x0539, 0x053b, 0x4579, 0x05a0, 0x458c, 0x0001,
      0x0001, 0x0668, 0x467b, 0x070a, 0x0001, 0x082d, 0x4c0b, 0x4c1e,
      0x4c20, 0x4c21, 0x4c23, 0x4f84, 0x4f85, 0x0001, 0x113f, 0x5516,
      0x1ba9, 0x007d, 0x402b, 0x402c, 0x0072, 0x4026, 0x402a, 0x4027,
      0x0074, 0x4029, 0x4037, 0x4040, 0x0001, 0x0001, 0x402f, 0x0001,
      0x4038, 0x0001, 0x018b, 0x4172, 0x4171, 0x4197, 0x41ad, 0x0230,
      0x024f, 0x0001, 0x41df, 0x42fd, 0x4300, 0x4318, 0x431e, 0x431b,
      0x442b, 0x443f, 0x4440, 0x443e, 0x443b, 0x443c, 0x0001, 0x4439,
      0x0523, 0x0000, 0x0001, 0x05c3, 0x05c2, 0x0001, 0x458e, 0x4659,
      0x4679, 0x0669, 0x46b4, 0x46bd, 0x46d3, 0x46f5, 0x46f4, 0x0001,
      0x47f1, 0x47f2, 0x086e, 0x47f4, 0x0832, 0x0831, 0x0001, 0x0830,
      0x47f8, 0x0001, 0x4947, 0x09b6, 0x4948, 0x49ff, 0x4a00, 0x4a01,
      0x4a02, 0x4a03, 0x4a04, 0x4a05, 0x4a06, 0x4c0c, 0x4c27, 0x4c30,
      0x0bfa, 0x4c33, 0x4c34, 0x0c00, 0x4c35, 0x4c2f, 0x4e21, 0x4f58,
      0x0e6b, 0x4f86, 0x0eba, 0x0f63, 0x512a, 0x118f, 0x137a, 0x14d7,
      0x55c7, 0x55c8, 0x14d8, 0x0001, 0x1649, 0x1776, 0x1a3b, 0x5b4a,
      0x5b4a, 0x1a39, 0x5b4b, 0x5df1, 0x1bab, 0x5df2, 0x0001, 0x404a,
      0x0089, 0x404b, 0x404c, 0x404d, 0x404e, 0x4055, 0x4050, 0x4051,
      0x009d, 0x4052, 0x0098, 0x4041, 0x4047, 0x4045, 0x404f, 0x0178,
      0x0001, 0x4174, 0x4175, 0x4176, 0x01fc, 0x0001, 0x0001, 0x0254,
      0x025d, 0x026b, 0x0001, 0x41ee, 0x41ef, 0x02b9, 0x41eb, 0x41e9,
      0x0001, 0x41f3, 0x41f4, 0x41f0, 0x41f1, 0x0001, 0x0001, 0x41ed,
      0x0001, 0x0001, 0x03b8, 0x4301, 0x4303, 0x4322, 0x432b, 0x03d3,
      0x0001, 0x4323, 0x4325, 0x0458, 0x048d, 0x4447, 0x4445, 0x4446,
      0x049c, 0x444b, 0x444c, 0x444d, 0x444a, 0x4444, 0x4448, 0x4551,
      0x4552, 0x0596, 0x0597, 0x4597, 0x4598, 0x4599, 0x459a, 0x459b,
      0x459c, 0x459d, 0x0001, 0x4592, 0x0001, 0x465a, 0x4661, 0x0001,
      0x066c, 0x467d, 0x467e, 0x467f, 0x0001, 0x46b6, 0x46be, 0x46d5,
      0x46d6, 0x070d, 0x0712, 0x0711, 0x0719, 0x46f7, 0x071a, 0x4707,
      0x0716, 0x071e, 0x4704, 0x4705, 0x4706, 0x46f6, 0x071f, 0x4700,
      0x0001, 0x47ee, 0x0840, 0x4805, 0x4806, 0x4807, 0x0848, 0x4808,
      0x0837, 0x4809, 0x47fa, 0x0001, 0x4804, 0x47fb, 0x0001, 0x4802,
      0x47fd, 0x4803, 0x0959, 0x09b8, 0x494a, 0x494b, 0x0001, 0x4a08,
      0x0a3a, 0x4a07, 0x0a44, 0x0a3c, 0x4a12, 0x0a54, 0x4a09, 0x4a0a,
      0x4a0e, 0x4bf5, 0x4c0e, 0x4c0f, 0x4c44, 0x0c5a, 0x4c45, 0x0c0e,
      0x4c46, 0x4c47, 0x4c49, 0x4c4a, 0x0c1e, 0x0c1a, 0x0c1f, 0x4c4b,
      0x4c4c, 0x4c4d, 0x4c4e, 0x4c4f, 0x4c3a, 0x0001, 0x4c41, 0x4e23,
      0x0daf, 0x0e53, 0x4f8a, 0x4f8b, 0x0e6e, 0x4f8c, 0x0e70, 0x4f88,
      0x4f89, 0x0ebb, 0x4fe0, 0x4fe1, 0x0ebc, 0x4fde, 0x0f75, 0x50d9,
      0x0f9b, 0x0f9d, 0x512b, 0x1104, 0x54e9, 0x5518, 0x5519, 0x551a,
      0x551b, 0x551c, 0x55c9, 0x55ca, 0x55cb, 0x14df, 0x14e0, 0x55cc,
      0x14dc, 0x14da, 0x14db, 0x188a, 0x5b07, 0x5b06, 0x5b4d, 0x1a40,
      0x5b4e, 0x5b4f, 0x5b50, 0x1a44, 0x5df3, 0x1bac, 0x1baf, 0x0001,
      0x4009, 0x4068, 0x4069, 0x4057, 0x009f, 0x4058, 0x4062, 0x00a5,
      0x4059, 0x406a, 0x405a, 0x405b, 0x405c, 0x00b3, 0x00a1, 0x405d,
      0x405e, 0x405f, 0x00a6, 0x4060, 0x406c, 0x00b1, 0x4061, 0x4063,
      0x0001, 0x4064, 0x4066, 0x0001, 0x0180, 0x4153, 0x4156, 0x01c6,
      0x01c4, 0x01c5, 0x417b, 0x4179, 0x0200, 0x0223, 0x41aa, 0x41b5,
      0x41bf, 0x026d, 0x41f5, 0x41f6, 0x41f7, 0x41f8, 0x02cb, 0x02de,
      0x02d3, 0x4203, 0x41fd, 0x41fe, 0x41ff, 0x4200, 0x02cd, 0x02e3,
      0x4209, 0x420b, 0x4202, 0x0001, 0x0001, 0x02ce, 0x4204, 0x03ac,
      0x03ad, 0x433f, 0x433b, 0x03d7, 0x03dd, 0x433c, 0x03de, 0x4339,
      0x433a, 0x03d8, 0x03c9, 0x03df, 0x4338, 0x4341, 0x4340, 0x4337,
      0x4422, 0x442c, 0x4459, 0x445a, 0x445b, 0x445c, 0x04af, 0x4464,
      0x4465, 0x4462, 0x4467, 0x4460, 0x0001, 0x445f, 0x445d, 0x4468,
      0x445e, 0x4463, 0x0001, 0x4546, 0x052d, 0x0544, 0x0545, 0x4581,
      0x457e, 0x45aa, 0x45ab, 0x45ac, 0x05cf, 0x45b3, 0x05cb, 0x45b0,
      0x45b1, 0x05d2, 0x45ad, 0x05ca, 0x45ae, 0x45af, 0x45b4, 0x45a5,
      0x45a7, 0x0001, 0x45b2, 0x0633, 0x0638, 0x0635, 0x06bc, 0x06b6,
      0x06b7, 0x06bb, 0x46cb, 0x06e8, 0x46d8, 0x46d9, 0x46f8, 0x46f9,
      0x470a, 0x072f, 0x0729, 0x470b, 0x470c, 0x470d, 0x470e, 0x0728,
      0x0739, 0x470f, 0x4710, 0x4711, 0x4712, 0x0722, 0x4713, 0x4715,
      0x4716, 0x0001, 0x4714, 0x471a, 0x4708, 0x0807, 0x081d, 0x480d,
      0x4811, 0x0862, 0x4812, 0x4813, 0x0851, 0x085c, 0x480f, 0x0001,
      0x0001, 0x0001, 0x4819, 0x4818, 0x480b, 0x4916, 0x098e, 0x493b,
      0x09c3, 0x4951, 0x4952, 0x4953, 0x4955, 0x4956, 0x09bd, 0x4958,
      0x4954, 0x0001, 0x0001, 0x494e, 0x494d, 0x49d9, 0x0001, 0x4a1a,
      0x4a1b, 0x4a1c, 0x4a1d, 0x0a52, 0x4a1e, 0x0a64, 0x4a1f, 0x4a20,
      0x4a21, 0x4a14, 0x0a63, 0x4a15, 0x0001, 0x0001, 0x0a5c, 0x0001,
      0x0001, 0x4a31, 0x4a29, 0x4a13, 0x4a16, 0x4bc4, 0x0baa, 0x4bdc,
      0x4bf9, 0x4c10, 0x0c1d, 0x4c68, 0x0c42, 0x0c44, 0x0c3a, 0x4c69,
      0x0c31, 0x4c6a, 0x4c51, 0x4c52, 0x0c4b, 0x0c2d, 0x4c66, 0x4c67,
      0x0c32, 0x4c53, 0x0c47, 0x4c55, 0x0c4d, 0x0c4a, 0x0001, 0x4c40,
      0x0001, 0x0001, 0x4c5d, 0x0001, 0x4c59, 0x4c5f, 0x4c60, 0x0001,
      0x4c5e, 0x4c65, 0x0001, 0x4e27, 0x0db8, 0x4e28, 0x4e34, 0x4e3b,
      0x4e3a, 0x4e30, 0x4e35, 0x0001, 0x494f, 0x4e36, 0x4f5a, 0x4f8e,
      0x4f8f, 0x4f90, 0x4f91, 0x4f92, 0x4f93, 0x4f94, 0x4f95, 0x4f96,
      0x4f97, 0x0efb, 0x4fe8, 0x4fe9, 0x0ec1, 0x0ec0, 0x0ebf, 0x4fe6,
      0x0001, 0x50be, 0x50c2, 0x0f77, 0x0f70, 0x0f6f, 0x50f1, 0x50f2,
      0x513a, 0x5153, 0x104d, 0x104c, 0x5152, 0x51c3, 0x10a4, 0x51c5,
      0x10a6, 0x51c9, 0x51ca, 0x5271, 0x110c, 0x52b5, 0x1191, 0x52f7,
      0x0001, 0x53bb, 0x0001, 0x54ec, 0x5517, 0x5521, 0x5523, 0x141e,
      0x5524, 0x551f, 0x14b2, 0x55ce, 0x55cf, 0x14ed, 0x55d8, 0x55d9,
      0x55da, 0x0001, 0x14e8, 0x14f0, 0x14f9, 0x55db, 0x55dc, 0x55dd,
      0x14e9, 0x14e5, 0x14eb, 0x55d1, 0x14e7, 0x0001, 0x55d2, 0x0001,
      0x57ab, 0x165c, 0x57ac, 0x57ad, 0x0001, 0x5b0f, 0x19c7, 0x19cb,
      0x19c8, 0x5b10, 0x19cd, 0x0001, 0x1a47, 0x1a48, 0x1a45, 0x1a49,
      0x1a4d, 0x5df8, 0x5df9, 0x1bb4, 0x5dfa, 0x5dfb, 0x4080, 0x00b8,
      0x4081, 0x4082, 0x4083, 0x4084, 0x4085, 0x00b7, 0x4086, 0x407f,
      0x4087, 0x4088, 0x00c9, 0x4089, 0x408b, 0x407a, 0x0001, 0x408c,
      0x4078, 0x01ce, 0x01d0, 0x4198, 0x0001, 0x41b6, 0x41bc, 0x41c0,
      0x41c1, 0x026f, 0x026e, 0x02f1, 0x02e4, 0x421a, 0x02e7, 0x4222,
      0x4223, 0x1508, 0x02ef, 0x421b, 0x421c, 0x420e, 0x420f, 0x02f7,
      0x421f, 0x4220, 0x4221, 0x02e6, 0x421e, 0x0001, 0x4224, 0x0001,
      0x434c, 0x03e6, 0x4355, 0x03e7, 0x4356, 0x4351, 0x03e2, 0x03e8,
      0x434f, 0x434d, 0x4350, 0x4354, 0x4353, 0x03e9, 0x435e, 0x441d,
      0x4423, 0x047f, 0x447c, 0x04b5, 0x04c4, 0x4475, 0x04c5, 0x04b4,
      0x4473, 0x4474, 0x0001, 0x4476, 0x04b8, 0x446e, 0x0001, 0x4479,
      0x4470, 0x4471, 0x4472, 0x446a, 0x0001, 0x4477, 0x0001, 0x4558,
      0x4582, 0x45b5, 0x45b6, 0x45b7, 0x45bc, 0x05d5, 0x45b8, 0x45b9,
      0x45ba, 0x45bf, 0x45c0, 0x45c1, 0x45bb, 0x05dc, 0x0001, 0x45cb,
      0x0001, 0x0001, 0x45bd, 0x45c7, 0x0001, 0x465f, 0x063a, 0x4662,
      0x4663, 0x4664, 0x4665, 0x4684, 0x4685, 0x4686, 0x4687, 0x4688,
      0x0674, 0x06a7, 0x46c1, 0x06cc, 0x0001, 0x4717, 0x4718, 0x4729,
      0x472a, 0x472b, 0x472c, 0x472d, 0x073f, 0x0754, 0x472e, 0x0740,
      0x471f, 0x073c, 0x4720, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
      0x47ef, 0x081f, 0x0860, 0x087f, 0x481a, 0x481b, 0x481c, 0x481d,
      0x481e, 0x481f, 0x4820, 0x4821, 0x4822, 0x4823, 0x4824, 0x482b,
      0x4831, 0x0001, 0x4827, 0x0001, 0x0001, 0x4917, 0x4918, 0x4936,
      0x099a, 0x09d0, 0x4967, 0x4968, 0x09cf, 0x4969, 0x496a, 0x496b,
      0x495d, 0x495e, 0x495c, 0x09c5, 0x09ce, 0x4965, 0x0001, 0x0a23,
      0x0a21, 0x0a6e, 0x4a33, 0x4a34, 0x4a4a, 0x0a79, 0x0a6d, 0x4a35,
      0x0a76, 0x4a37, 0x0a6a, 0x4a38, 0x4a39, 0x4a3b, 0x0a7c, 0x0a68,
      0x4a3c, 0x0a67, 0x0a89, 0x4a3d, 0x0a81, 0x4a3e, 0x4a3f, 0x0a88,
      0x0a6c, 0x4a40, 0x0a82, 0x0a66, 0x0001, 0x4a50, 0x0001, 0x0001,
      0x4a4c, 0x4a4b, 0x4a4d, 0x5604, 0x4a2c, 0x4a46, 0x4a36, 0x0001,
      0x4a3a, 0x4bc5, 0x0bab, 0x0bad, 0x4bec, 0x0bd1, 0x0bd3, 0x0001,
      0x4c11, 0x0001, 0x4c7c, 0x4c7d, 0x4c7e, 0x0c56, 0x0c65, 0x0c68,
      0x0c53, 0x0c4f, 0x0c39, 0x0c60, 0x0c4e, 0x0c6a, 0x4c80, 0x0c6b,
      0x4c81, 0x4c82, 0x4c89, 0x4c6f, 0x4c75, 0x0001, 0x0001, 0x4c7a,
      0x4c6c, 0x4c87, 0x4c79, 0x0001, 0x4c73, 0x0001, 0x4c6b, 0x4c74,
      0x4c83, 0x0dc2, 0x4e3c, 0x4e3d, 0x0dc0, 0x0dbf, 0x4e41, 0x4e48,
      0x4e47, 0x4e45, 0x0e40, 0x4f53, 0x0001, 0x4f5b, 0x4f5c, 0x0e68,
      0x0e57, 0x4f98, 0x4f99, 0x4f9a, 0x4f9b, 0x4f9d, 0x4f9e, 0x4f9f,
      0x4fa0, 0x0eb5, 0x0ed0, 0x0ec8, 0x0eca, 0x5001, 0x4ff3, 0x5000,
      0x0001, 0x4ff5, 0x500c, 0x4ffd, 0x0ec9, 0x4fff, 0x4ff6, 0x4ff1,
      0x4ffe, 0x4ff7, 0x50c3, 0x0f44, 0x50d8, 0x0f78, 0x50dd, 0x0fa5,
      0x0001, 0x5129, 0x513f, 0x1047, 0x5155, 0x1045, 0x5156, 0x1049,
      0x0001, 0x104b, 0x0001, 0x109a, 0x0001, 0x10a5, 0x10ab, 0x10ac,
      0x51d2, 0x51d3, 0x51d4, 0x51d5, 0x10a8, 0x51d7, 0x51d9, 0x110e,
      0x5276, 0x5277, 0x1108, 0x5274, 0x114f, 0x114d, 0x52b8, 0x52b9,
      0x52ba, 0x1197, 0x52fa, 0x11bc, 0x0001, 0x0001, 0x53bd, 0x53be,
      0x126f, 0x0001, 0x0001, 0x53c1, 0x53fe, 0x12a2, 0x53fd, 0x137d,
      0x139c, 0x54b1, 0x54c9, 0x0001, 0x13d9, 0x54e3, 0x13de, 0x54ed,
      0x5527, 0x5528, 0x142f, 0x5529, 0x552a, 0x552b, 0x552c, 0x552d,
      0x552e, 0x1429, 0x552f, 0x5530, 0x5531, 0x5532, 0x1427, 0x1423,
      0x0001, 0x1425, 0x559f, 0x14b3, 0x55cd, 0x1504, 0x1514, 0x1511,
      0x151c, 0x55e8, 0x1515, 0x1502, 0x55e9, 0x150e, 0x55ea, 0x1510,
      0x55eb, 0x150a, 0x55ec, 0x55ed, 0x55ee, 0x1512, 0x55ef, 0x0001,
      0x55e2, 0x0001, 0x55f1, 0x55f3, 0x55de, 0x0001, 0x57b3, 0x57b4,
      0x0001, 0x57af, 0x16f7, 0x1701, 0x5896, 0x5897, 0x5898, 0x591d,
      0x5931, 0x17ab, 0x5a1d, 0x5b15, 0x5b19, 0x19d6, 0x5b18, 0x5b5a,
      0x1a4e, 0x5b5b, 0x1a57, 0x1a50, 0x1a53, 0x1a51, 0x0001, 0x5b5f,
      0x5bd1, 0x0001, 0x1bbd, 0x5dfc, 0x5dfd, 0x5dfe, 0x5dff, 0x5e02,
      0x4092, 0x00d3, 0x4093, 0x4090, 0x4091, 0x4094, 0x4095, 0x00d9,
      0x4096, 0x4097, 0x4098, 0x00d5, 0x00d1, 0x4099, 0x409a, 0x00e8,
      0x409b, 0x409c, 0x409d, 0x409e, 0x409f, 0x40aa, 0x4135, 0x4145,
      0x0179, 0x0195, 0x0191, 0x415b, 0x0193, 0x0001, 0x01d6, 0x4184,
      0x4185, 0x01d5, 0x4186, 0x4187, 0x0001, 0x0206, 0x0001, 0x41c4,
      0x422a, 0x422f, 0x4230, 0x4231, 0x4232, 0x4233, 0x030e, 0x4234,
      0x0308, 0x0310, 0x030b, 0x4235, 0x4228, 0x4229, 0x0001, 0x423a,
      0x0001, 0x0001, 0x4225, 0x0001, 0x02ff, 0x4239, 0x4237, 0x430c,
      0x03b7, 0x4364, 0x0409, 0x4367, 0x03ed, 0x4372, 0x4369, 0x436a,
      0x436b, 0x4363, 0x4365, 0x4366, 0x436d, 0x0001, 0x4371, 0x0001,
      0x4424, 0x442d, 0x0001, 0x447d, 0x4485, 0x0001, 0x4490, 0x447e,
      0x447f, 0x448d, 0x0001, 0x4480, 0x4547, 0x057e, 0x455a, 0x0551,
      0x4575, 0x4584, 0x4585, 0x45db, 0x45cf, 0x45d0, 0x45d1, 0x45d2,
      0x45d7, 0x05de, 0x4668, 0x063f, 0x4689, 0x468a, 0x468b, 0x067f,
      0x46c2, 0x06bf, 0x06d7, 0x0746, 0x0745, 0x074b, 0x073b, 0x4738,
      0x4739, 0x473a, 0x0759, 0x0765, 0x075f, 0x0753, 0x4736, 0x075e,
      0x4737, 0x473b, 0x0001, 0x4733, 0x0001, 0x0821, 0x4825, 0x4826,
      0x4833, 0x4834, 0x088d, 0x4835, 0x0887, 0x4836, 0x4837, 0x0888,
      0x0890, 0x0001, 0x088a, 0x4838, 0x4839, 0x4842, 0x483a, 0x483b,
      0x0001, 0x483c, 0x4845, 0x0001, 0x0893, 0x0001, 0x4846, 0x484b,
      0x483d, 0x0001, 0x491b, 0x491c, 0x09a1, 0x099e, 0x099f, 0x099d,
      0x4975, 0x4976, 0x4977, 0x0001, 0x49e7, 0x0a22, 0x4a6a, 0x4a6b,
      0x4a6c, 0x0aa3, 0x0aa4, 0x0a91, 0x4a51, 0x4a52, 0x0aa2, 0x0a8f,
      0x4a6d, 0x4a53, 0x4a54, 0x4a55, 0x4a56, 0x0a9c, 0x0aa5, 0x4a57,
      0x4a58, 0x4a5a, 0x4a5b, 0x0001, 0x0001, 0x4a67, 0x0001, 0x0001,
      0x0001, 0x0001, 0x0b83, 0x4bc7, 0x4bc8, 0x4bc9, 0x4bca, 0x4bda,
      0x4bdd, 0x4bde, 0x4bfb, 0x4bfc, 0x4bfd, 0x4bfe, 0x0001, 0x0bd7,
      0x4c13, 0x4ca8, 0x0c6f, 0x4ca9, 0x4caa, 0x4cab, 0x0c82, 0x0c87,
      0x4cac, 0x4cae, 0x4caf, 0x4cb0, 0x0c88, 0x4cb1, 0x4cb3, 0x4cb4,
      0x4cb5, 0x4cb6, 0x4cb7, 0x0bee, 0x4cb8, 0x4cb9, 0x0c78, 0x4cba,
      0x0c85, 0x0c81, 0x0001, 0x0001, 0x0001, 0x0001, 0x4c9d, 0x4c96,
      0x4c90, 0x4c9c, 0x4c8b, 0x4c99, 0x4ca3, 0x4c98, 0x0dcb, 0x4e5e,
      0x4e5f, 0x0dcc, 0x0dc6, 0x4e60, 0x4e57, 0x4e58, 0x4e51, 0x4e4e,
      0x4e59, 0x0001, 0x4e5c, 0x4e4a, 0x0001, 0x4e52, 0x4e4c, 0x4e50,
      0x4e53, 0x0e3f, 0x4f5d, 0x0e5b, 0x0e5a, 0x4fa1, 0x0e7f, 0x0e79,
      0x4fa2, 0x4fa3, 0x4fa4, 0x0e7e, 0x0e82, 0x0ed3, 0x0ed5, 0x0ed7,
      0x0ed6, 0x0ed1, 0x0edc, 0x0ed8, 0x0ed9, 0x5012, 0x500d, 0x5003,
      0x5004, 0x5015, 0x5006, 0x0001, 0x5013, 0x500a, 0x0f3d, 0x50bf,
      0x0f45, 0x50c4, 0x0f5d, 0x0f7b, 0x0f7f, 0x50f4, 0x50f5, 0x50f6,
      0x50f7, 0x50f8, 0x0faf, 0x50f3, 0x0001, 0x512e, 0x5141, 0x515f,
      0x104f, 0x5161, 0x5162, 0x5163, 0x5164, 0x5167, 0x5166, 0x1056,
      0x104e, 0x1052, 0x5160, 0x10af, 0x51df, 0x10ae, 0x51e0, 0x51e1,
      0x51e3, 0x10b7, 0x51e8, 0x51e6, 0x0001, 0x51db, 0x0001, 0x51da,
      0x1112, 0x1116, 0x110f, 0x1117, 0x1111, 0x527a, 0x527b, 0x115b,
      0x115d, 0x1155, 0x52bc, 0x115c, 0x1153, 0x52bd, 0x0001, 0x52bb,
      0x119a, 0x52fc, 0x1199, 0x119c, 0x52fd, 0x119d, 0x0001, 0x531b,
      0x5333, 0x11ce, 0x5334, 0x5335, 0x11d1, 0x11cf, 0x11d0, 0x11e1,
      0x5338, 0x0001, 0x53c3, 0x53c4, 0x53c5, 0x0001, 0x0001, 0x53c8,
      0x53c7, 0x12aa, 0x12a9, 0x5402, 0x5403, 0x12b1, 0x12a7, 0x12ae,
      0x5404, 0x5405, 0x12a8, 0x0001, 0x54a4, 0x1381, 0x54a5, 0x54a6,
      0x137f, 0x137e, 0x139e, 0x54b5, 0x54ca, 0x54cb, 0x13af, 0x54e4,
      0x54ee, 0x54ef, 0x5536, 0x5537, 0x553a, 0x553b, 0x553c, 0x553d,
      0x553e, 0x149b, 0x55a7, 0x0001, 0x55f8, 0x1526, 0x153d, 0x55f9,
      0x153a, 0x55fa, 0x55fb, 0x55fc, 0x55fd, 0x1523, 0x1521, 0x1522,
      0x55fe, 0x55ff, 0x5600, 0x5601, 0x151a, 0x5609, 0x1537, 0x560a,
      0x560b, 0x560c, 0x152d, 0x1527, 0x560d, 0x1535, 0x560e, 0x55f7,
      0x0001, 0x5607, 0x55f4, 0x5606, 0x5602, 0x5603, 0x164c, 0x57a5,
      0x57b5, 0x166a, 0x57b6, 0x57b7, 0x57b8, 0x57b9, 0x57bb, 0x57bc,
      0x57bd, 0x1663, 0x57be, 0x57bf, 0x57c0, 0x57c5, 0x57c6, 0x1667,
      0x1661, 0x0001, 0x57c4, 0x57c3, 0x57c2, 0x1660, 0x588d, 0x16f8,
      0x1727, 0x1715, 0x589a, 0x1712, 0x589b, 0x589c, 0x1718, 0x589e,
      0x589f, 0x1717, 0x58a0, 0x0001, 0x17b8, 0x1877, 0x59d6, 0x59e3,
      0x189d, 0x59f3, 0x18f1, 0x5a1e, 0x18ff, 0x5a51, 0x0001, 0x5ac1,
      0x5ac2, 0x5b1c, 0x5b1d, 0x19e0, 0x5b1e, 0x1a37, 0x5b1f, 0x5b1b,
      0x0001, 0x5b60, 0x5b61, 0x1a5d, 0x5b63, 0x5b64, 0x1a5f, 0x5b65,
      0x5b66, 0x1a58, 0x5b67, 0x1a5e, 0x1a5c, 0x5ba0, 0x1a89, 0x5ba1,
      0x5bd2, 0x5bd4, 0x0001, 0x1bc0, 0x1bc2, 0x1bf5, 0x1cd7, 0x1d89,
      0x1dae, 0x0001, 0x40af, 0x0101, 0x40b1, 0x40b2, 0x40b3, 0x40bd,
      0x40b4, 0x40b8, 0x00f7, 0x00f5, 0x40b5, 0x00f8, 0x40b6, 0x40b7,
      0x40b9, 0x40ba, 0x40cc, 0x40cd, 0x40ce, 0x010d, 0x40c4, 0x40ae,
      0x40b0, 0x40bf, 0x40c8, 0x40ca, 0x0001, 0x0001, 0x415f, 0x4188,
      0x4189, 0x418a, 0x01de, 0x0209, 0x0001, 0x0237, 0x41c5, 0x4246,
      0x4247, 0x0322, 0x4243, 0x0323, 0x4245, 0x0321, 0x424c, 0x424d,
      0x424e, 0x424f, 0x4262, 0x4263, 0x4264, 0x4248, 0x4249, 0x424a,
      0x424b, 0x4260, 0x0001, 0x4244, 0x4258, 0x0001, 0x0001, 0x430d,
      0x03b6, 0x4381, 0x4382, 0x4384, 0x03f4, 0x4385, 0x03fd, 0x4389,
      0x03f3, 0x437f, 0x4383, 0x03ff, 0x4391, 0x4386, 0x03ef, 0x1565,
      0x437e, 0x437c, 0x437d, 0x437a, 0x437b, 0x0001, 0x438c, 0x4380,
      0x4393, 0x4388, 0x0001, 0x438a, 0x438b, 0x438d, 0x438e, 0x438f,
      0x4390, 0x442f, 0x4491, 0x4492, 0x04d8, 0x4494, 0x04e1, 0x4495,
      0x04df, 0x04de, 0x04e0, 0x44aa, 0x44ab, 0x44ac, 0x44b6, 0x44b7,
      0x44b8, 0x449e, 0x4496, 0x44ad, 0x0001, 0x44ae, 0x44b4, 0x4497,
      0x449d, 0x44a4, 0x449b, 0x44b5, 0x4499, 0x44b0, 0x44b1, 0x44a3,
      0x0001, 0x44a1, 0x0001, 0x454a, 0x4549, 0x055d, 0x055b, 0x4587,
      0x45dc, 0x45dd, 0x45de, 0x05eb, 0x45e1, 0x45e2, 0x45e3, 0x45e4,
      0x05ed, 0x45e0, 0x45e7, 0x45e8, 0x45e9, 0x45ea, 0x45eb, 0x45f2,
      0x4669, 0x466a, 0x4690, 0x0680, 0x468e, 0x468f, 0x0679, 0x46c3,
      0x06c3, 0x46db, 0x46dc, 0x46de, 0x473c, 0x473d, 0x473e, 0x0770,
      0x0782, 0x4744, 0x0777, 0x4743, 0x4746, 0x4747, 0x077a, 0x077e,
      0x4742, 0x0766, 0x077c, 0x474a, 0x4755, 0x475b, 0x0001, 0x474e,
      0x0001, 0x0897, 0x485d, 0x08ad, 0x485e, 0x08a7, 0x08db, 0x08c2,
      0x485f, 0x4860, 0x4861, 0x08c4, 0x08b0, 0x4863, 0x08aa, 0x08b1,
      0x089f, 0x08c0, 0x484c, 0x484d, 0x089e, 0x484e, 0x4850, 0x4851,
      0x4852, 0x4859, 0x0001, 0x4867, 0x485c, 0x0001, 0x0001, 0x0001,
      0x491f, 0x493e, 0x497d, 0x09db, 0x09d8, 0x497e, 0x497f, 0x4980,
      0x1445, 0x0aa8, 0x4a8b, 0x0ac3, 0x0ab5, 0x4a8c, 0x0ac2, 0x4a8d,
      0x4a8e, 0x4a8f, 0x0ac4, 0x4a90, 0x4a91, 0x4a92, 0x4a93, 0x0aa7,
      0x0abf, 0x0ab0, 0x0aaa, 0x4a76, 0x4a77, 0x0aa6, 0x0001, 0x4a7e,
      0x4a7d, 0x4a94, 0x4a95, 0x4a96, 0x4a78, 0x0001, 0x4a6f, 0x4a70,
      0x4a71, 0x4a72, 0x4a7c, 0x4a73, 0x4a74, 0x4a75, 0x0001, 0x4bcb,
      0x4bcc, 0x0b86, 0x4bcd, 0x4bdf, 0x4be0, 0x0bb1, 0x0001, 0x0001,
      0x4c17, 0x0cac, 0x4cd0, 0x0cab, 0x4cd1, 0x4cd2, 0x4cd3, 0x0cb1,
      0x4cd4, 0x0001, 0x4cd5, 0x4cd6, 0x4cd7, 0x4cd8, 0x4cd9, 0x0ca3,
      0x0c94, 0x4cda, 0x4cdb, 0x0cb2, 0x0c98, 0x4cdc, 0x4cdd, 0x4cde,
      0x4cdf, 0x4ce0, 0x0ca1, 0x4cc8, 0x4cc9, 0x4ccd, 0x4ce2, 0x4ce6,
      0x4cca, 0x4cce, 0x4ce8, 0x562c, 0x4cc7, 0x4ce3, 0x4ce7, 0x0001,
      0x0dcf, 0x4e7e, 0x4e7f, 0x4e80, 0x4e81, 0x0dd1, 0x4e83, 0x4e85,
      0x4e6a, 0x0001, 0x4e71, 0x4e77, 0x4e6b, 0x0001, 0x4e75, 0x4e72,
      0x4e67, 0x4e6d, 0x4e70, 0x0001, 0x4f60, 0x4f61, 0x4f5f, 0x0e5e,
      0x0e88, 0x0e84, 0x4fab, 0x4fac, 0x0e8b, 0x0e8a, 0x4fae, 0x4faf,
      0x4fb0, 0x0e89, 0x0eb6, 0x0ee5, 0x5017, 0x5018, 0x5019, 0x501a,
      0x0ede, 0x0ee3, 0x501b, 0x5024, 0x5020, 0x5023, 0x0001, 0x501e,
      0x5027, 0x5025, 0x0f81, 0x50e1, 0x50fa, 0x0fb6, 0x50fb, 0x50fc,
      0x0fb4, 0x50fd, 0x50f9, 0x5130, 0x0001, 0x5142, 0x1061, 0x1057,
      0x1092, 0x516e, 0x5168, 0x1059, 0x5169, 0x516a, 0x1053, 0x0001,
      0x1058, 0x51fb, 0x0001, 0x51fc, 0x51fd, 0x51fe, 0x51ff, 0x10b2,
      0x51fa, 0x51ed, 0x527e, 0x111f, 0x5282, 0x5283, 0x5284, 0x111c,
      0x5285, 0x1142, 0x52c3, 0x115f, 0x52c4, 0x115e, 0x5300, 0x5301,
      0x5302, 0x5339, 0x533a, 0x5351, 0x11d8, 0x533c, 0x533d, 0x11d6,
      0x11e3, 0x533e, 0x11dc, 0x533f, 0x11e2, 0x11dd, 0x5340, 0x5341,
      0x5342, 0x0001, 0x5344, 0x534b, 0x53d4, 0x1274, 0x0001, 0x53ce,
      0x12a6, 0x12ab, 0x540c, 0x540d, 0x12c2, 0x12cc, 0x12bb, 0x12ba,
      0x540e, 0x540f, 0x12c4, 0x12c5, 0x5407, 0x0001, 0x5408, 0x1382,
      0x54b6, 0x139f, 0x13a1, 0x54b7, 0x13b2, 0x54ce, 0x54cf, 0x54d0,
      0x54d1, 0x54d2, 0x54d3, 0x0001, 0x54e5, 0x13e5, 0x0001, 0x54f2,
      0x13f2, 0x54f3, 0x1440, 0x1447, 0x5543, 0x1441, 0x5545, 0x5546,
      0x1449, 0x1442, 0x5547, 0x5548, 0x1445, 0x5541, 0x554a, 0x55a2,
      0x14bc, 0x14be, 0x55aa, 0x14bf, 0x14bd, 0x14d4, 0x5610, 0x5615,
      0x1550, 0x5616, 0x5617, 0x153f, 0x5618, 0x5619, 0x561a, 0x561b,
      0x561c, 0x561d, 0x561e, 0x561f, 0x1551, 0x1543, 0x5620, 0x5621,
      0x5622, 0x153e, 0x1552, 0x562f, 0x5630, 0x5631, 0x0001, 0x0001,
      0x5626, 0x5613, 0x5608, 0x5628, 0x5627, 0x0001, 0x5612, 0x5645,
      0x57a7, 0x57d0, 0x57d1, 0x57d2, 0x57d3, 0x57d4, 0x57d5, 0x166c,
      0x57d6, 0x57d7, 0x166e, 0x57d8, 0x57d9, 0x57da, 0x57db, 0x57dc,
      0x57cb, 0x57cf, 0x57cc, 0x1703, 0x58a7, 0x58a8, 0x58a9, 0x58aa,
      0x1725, 0x1721, 0x58ab, 0x58ac, 0x58ad, 0x58ae, 0x58af, 0x58b0,
      0x58b1, 0x171f, 0x1724, 0x58b2, 0x58b3, 0x0001, 0x0001, 0x590b,
      0x1797, 0x591e, 0x179a, 0x5932, 0x5933, 0x5934, 0x5935, 0x59ca,
      0x59cb, 0x59d7, 0x187f, 0x59e4, 0x0001, 0x0001, 0x5a21, 0x0001,
      0x5a52, 0x1904, 0x1903, 0x5a53, 0x1901, 0x5ac3, 0x5ac4, 0x5ac5,
      0x5ac6, 0x0001, 0x5ac9, 0x0001, 0x5b20, 0x19e4, 0x19e9, 0x5b21,
      0x19e5, 0x19f5, 0x1a64, 0x5b6b, 0x5b6c, 0x1a62, 0x5b6d, 0x5b6e,
      0x5b6f, 0x5b70, 0x0001, 0x0001, 0x1a8b, 0x5ba3, 0x5ba4, 0x5ba5,
      0x0001, 0x1ace, 0x5bdb, 0x5bdc, 0x5bdd, 0x5bdf, 0x5be0, 0x5be1,
      0x5be6, 0x5be2, 0x5be3, 0x5be8, 0x5be4, 0x5dcb, 0x1b73, 0x1b75,
      0x1bd1, 0x5e07, 0x5e08, 0x0001, 0x0001, 0x5e28, 0x5e62, 0x5e98,
      0x5ed4, 0x1d17, 0x40d8, 0x40da, 0x0106, 0x0111, 0x40d3, 0x40d2,
      0x40d9, 0x40d6, 0x0105, 0x40db, 0x40dc, 0x40dd, 0x010c, 0x40d4,
      0x40df, 0x4139, 0x4163, 0x0001, 0x41ab, 0x41c6, 0x0001, 0x0333,
      0x4272, 0x4273, 0x0351, 0x427c, 0x4275, 0x4276, 0x0331, 0x032d,
      0x0330, 0x427b, 0x0326, 0x426e, 0x4274, 0x034f, 0x4278, 0x4279,
      0x05f7, 0x426b, 0x0001, 0x426d, 0x0001, 0x430e, 0x439e, 0x439f,
      0x0401, 0x0402, 0x040c, 0x43a1, 0x43a5, 0x03fe, 0x042d, 0x43a0,
      0x0001, 0x43a6, 0x43ba, 0x43a8, 0x0001, 0x43a7, 0x0001, 0x43aa,
      0x43a2, 0x43a3, 0x0001, 0x0485, 0x0509, 0x44dc, 0x04e7, 0x04e3,
      0x04e8, 0x44ce, 0x44cf, 0x44cc, 0x44dd, 0x44de, 0x44df, 0x04eb,
      0x44da, 0x44db, 0x44c1, 0x04ea, 0x44e0, 0x44c0, 0x44d5, 0x0001,
      0x44cb, 0x0001, 0x44c9, 0x44ca, 0x44cd, 0x44d1, 0x44d9, 0x4564,
      0x4565, 0x4566, 0x0569, 0x4563, 0x4567, 0x056c, 0x4577, 0x0599,
      0x45f5, 0x45f6, 0x05f1, 0x45ff, 0x05f0, 0x05ef, 0x45fd, 0x45fe,
      0x05f5, 0x45f9, 0x45fa, 0x45fb, 0x05f7, 0x4600, 0x05f8, 0x4602,
      0x4603, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x05f4, 0x0001,
      0x0001, 0x0646, 0x0001, 0x06ce, 0x46e3, 0x46e4, 0x46e0, 0x474b,
      0x474c, 0x4748, 0x4749, 0x0775, 0x0771, 0x0798, 0x0786, 0x0793,
      0x4768, 0x4769, 0x476a, 0x476c, 0x078a, 0x4765, 0x4766, 0x4745,
      0x476d, 0x4761, 0x4777, 0x476e, 0x4773, 0x4778, 0x4772, 0x0825,
      0x08c3, 0x4853, 0x484f, 0x486b, 0x486c, 0x486d, 0x4873, 0x4874,
      0x0915, 0x4875, 0x4876, 0x08d1, 0x4877, 0x487f, 0x08d9, 0x487b,
      0x487c, 0x487d, 0x08dc, 0x4872, 0x08d0, 0x08c6, 0x4880, 0x0001,
      0x0001, 0x4878, 0x0001, 0x0001, 0x0001, 0x08df, 0x08de, 0x4879,
      0x0955, 0x4920, 0x4921, 0x4922, 0x4923, 0x0001, 0x4914, 0x097e,
      0x0987, 0x4934, 0x0991, 0x09a2, 0x09a7, 0x4986, 0x09e8, 0x4988,
      0x4989, 0x498b, 0x0001, 0x498a, 0x0001, 0x49da, 0x4aa7, 0x0ae4,
      0x4aab, 0x4aac, 0x4aad, 0x0ad4, 0x4aae, 0x0ae5, 0x4aaf, 0x0acb,
      0x4ab0, 0x0ad3, 0x4ab1, 0x4ab2, 0x0ae8, 0x0ae7, 0x4a97, 0x4a98,
      0x4a99, 0x4a9a, 0x4a9b, 0x4a9c, 0x4a9d, 0x4a9e, 0x4a9f, 0x4aa0,
      0x4aa1, 0x4aa2, 0x0ae3, 0x4aa3, 0x0add, 0x0ae6, 0x4aa6, 0x4abe,
      0x4aa8, 0x4ac9, 0x0001, 0x0001, 0x0001, 0x0001, 0x4ac2, 0x4aa9,
      0x4aaa, 0x4ac3, 0x4aca, 0x4ac0, 0x0001, 0x4aa5, 0x0b87, 0x0b94,
      0x0b8a, 0x4bce, 0x4be1, 0x4be2, 0x4be3, 0x0bb4, 0x0bc4, 0x4bff,
      0x4c00, 0x0bdb, 0x4c1b, 0x4ceb, 0x4d0e, 0x4d0f, 0x0cd5, 0x4d10,
      0x0d57, 0x4d11, 0x4d12, 0x0cc7, 0x4d15, 0x4d16, 0x4d17, 0x4d18,
      0x0cce, 0x4d19, 0x4d1a, 0x4d1b, 0x4d1d, 0x4d1e, 0x0cd7, 0x4d1f,
      0x4d20, 0x4d21, 0x4d22, 0x4d23, 0x0cda, 0x4cf4, 0x4cf5, 0x4cf6,
      0x4cf7, 0x0cd4, 0x0cd0, 0x4cf8, 0x0cd6, 0x0cc0, 0x0cd8, 0x4d14,
      0x4d02, 0x4ced, 0x4d29, 0x4d0b, 0x4d06, 0x4d28, 0x4cf1, 0x4cfe,
      0x0001, 0x4d04, 0x4cfc, 0x0dda, 0x0dd9, 0x0e29, 0x0001, 0x0e28,
      0x4e94, 0x4e95, 0x0001, 0x4ea2, 0x0001, 0x4ea0, 0x0001, 0x0001,
      0x0001, 0x0e45, 0x4f57, 0x4f65, 0x0e61, 0x4f66, 0x4f67, 0x0001,
      0x4fad, 0x0e81, 0x4fb3, 0x0e8c, 0x0e95, 0x4fb4, 0x4fb5, 0x4fb6,
      0x4fb7, 0x4fb8, 0x4fb1, 0x4fb2, 0x4fa8, 0x0ef3, 0x0efa, 0x5042,
      0x0ef9, 0x0ee9, 0x0eea, 0x5043, 0x0ef2, 0x5044, 0x0eed, 0x0001,
      0x0001, 0x5040, 0x5038, 0x0efc, 0x0f48, 0x0f66, 0x0f87, 0x0f86,
      0x5104, 0x5105, 0x0fbe, 0x50fe, 0x50ff, 0x5100, 0x5101, 0x0fb9,
      0x0001, 0x5133, 0x5148, 0x1064, 0x1063, 0x5171, 0x1066, 0x5172,
      0x1065, 0x5173, 0x5174, 0x5175, 0x1095, 0x51be, 0x5202, 0x10be,
      0x5203, 0x10bc, 0x10c2, 0x5204, 0x5205, 0x10c4, 0x5206, 0x5207,
      0x10bf, 0x0001, 0x5200, 0x528b, 0x528c, 0x111d, 0x0001, 0x1162,
      0x1168, 0x52c6, 0x1166, 0x52ca, 0x5305, 0x11c4, 0x531e, 0x11e8,
      0x11e6, 0x533b, 0x5352, 0x11ea, 0x11ec, 0x534f, 0x534c, 0x11e4,
      0x1276, 0x53d6, 0x53d5, 0x0001, 0x541e, 0x541f, 0x5420, 0x5421,
      0x12de, 0x5422, 0x12d8, 0x12cd, 0x5424, 0x12d1, 0x5423, 0x5418,
      0x5419, 0x541d, 0x5417, 0x0001, 0x0001, 0x136d, 0x549f, 0x0001,
      0x54a7, 0x13a3, 0x54b8, 0x54b9, 0x54d5, 0x54f8, 0x54f9, 0x0001,
      0x1437, 0x1424, 0x554e, 0x144e, 0x5550, 0x5551, 0x5552, 0x5553,
      0x5554, 0x5557, 0x559a, 0x559c, 0x559d, 0x559e, 0x0001, 0x149e,
      0x55ac, 0x55ad, 0x55ab, 0x55c5, 0x560f, 0x5632, 0x156c, 0x5633,
      0x1557, 0x5635, 0x5636, 0x5637, 0x5638, 0x156d, 0x156b, 0x157b,
      0x563a, 0x563b, 0x0001, 0x563d, 0x563e, 0x156f, 0x563f, 0x5640,
      0x1561, 0x5641, 0x1578, 0x5642, 0x5643, 0x155f, 0x564c, 0x155b,
      0x564d, 0x564e, 0x564f, 0x1577, 0x1571, 0x5650, 0x5651, 0x564a,
      0x564b, 0x155a, 0x155d, 0x0001, 0x5661, 0x0001, 0x57a6, 0x565f,
      0x5654, 0x565a, 0x5644, 0x0001, 0x0001, 0x0001, 0x5660, 0x0001,
      0x57de, 0x57df, 0x57e0, 0x57e1, 0x167b, 0x57e2, 0x57e3, 0x57e4,
      0x57e7, 0x57e8, 0x57e9, 0x167d, 0x57ea, 0x57e6, 0x1676, 0x588e,
      0x1705, 0x1704, 0x58b4, 0x58b5, 0x58b6, 0x58b7, 0x1730, 0x58be,
      0x58b8, 0x58b9, 0x172a, 0x58ba, 0x58bb, 0x58d3, 0x0001, 0x5912,
      0x1783, 0x0001, 0x1799, 0x1798, 0x591f, 0x17cd, 0x593c, 0x593d,
      0x593e, 0x593f, 0x5940, 0x17d3, 0x5941, 0x5942, 0x17cf, 0x17cb,
      0x5943, 0x5946, 0x0001, 0x594a, 0x59d8, 0x59e5, 0x59e6, 0x18ab,
      0x59fd, 0x18b2, 0x59fa, 0x59f9, 0x18f4, 0x5a27, 0x0001, 0x5a54,
      0x5a55, 0x5a56, 0x5a57, 0x190c, 0x5a58, 0x1909, 0x190b, 0x5a59,
      0x5a5a, 0x1910, 0x1906, 0x5acd, 0x1979, 0x197b, 0x1978, 0x5acf,
      0x5ad0, 0x5ad1, 0x5ad2, 0x5ad3, 0x1975, 0x5ad4, 0x1976, 0x5ad5,
      0x5ad6, 0x5acb, 0x5acc, 0x19f8, 0x5b24, 0x5b25, 0x5b72, 0x5b73,
      0x1a69, 0x1a66, 0x5b78, 0x5b79, 0x5b7a, 0x5b7b, 0x5b7c, 0x5b7d,
      0x5b7e, 0x5b7f, 0x5b76, 0x1a91, 0x1a90, 0x5bac, 0x1a8d, 0x5baa,
      0x5bfc, 0x5bfd, 0x5bfe, 0x5bff, 0x5c00, 0x5c01, 0x5be9, 0x5bea,
      0x1ad3, 0x1ad7, 0x5beb, 0x5bed, 0x5bee, 0x5c02, 0x0001, 0x5bf1,
      0x5c03, 0x5bf9, 0x5bf7, 0x5bf6, 0x5c04, 0x5c05, 0x5dcc, 0x5dd3,
      0x5dd4, 0x0001, 0x5e0c, 0x5e0d, 0x1bd8, 0x1bd9, 0x5e0e, 0x5e0f,
      0x5e29, 0x1577, 0x5e2a, 0x1c14, 0x1c13, 0x5e63, 0x5e64, 0x5e65,
      0x1c8e, 0x0001, 0x1cdc, 0x1e01, 0x1e98, 0x0001, 0x400f, 0x0053,
      0x40e9, 0x40ee, 0x40ef, 0x40f0, 0x40f1, 0x011f, 0x0117, 0x40ec,
      0x011b, 0x40f3, 0x40f4, 0x40eb, 0x40f5, 0x40f6, 0x011e, 0x0001,
      0x40e7, 0x0001, 0x418c, 0x01e3, 0x418d, 0x418e, 0x0340, 0x0348,
      0x4289, 0x428a, 0x428f, 0x4290, 0x4291, 0x4292, 0x0346, 0x4280,
      0x4281, 0x4282, 0x0354, 0x428b, 0x4283, 0x4284, 0x4285, 0x4286,
      0x4287, 0x4288, 0x0001, 0x0001, 0x0001, 0x430f, 0x0420, 0x43bf,
      0x041d, 0x041c, 0x040f, 0x43c3, 0x43c4, 0x43c5, 0x041f, 0x43c1,
      0x43c2, 0x43bd, 0x0001, 0x43ce, 0x43c0, 0x0001, 0x0455, 0x44e2,
      0x04f6, 0x04f8, 0x04fb, 0x04ef, 0x44e3, 0x04ee, 0x44e6, 0x04f3,
      0x44e4, 0x44e5, 0x44ea, 0x44f1, 0x44e7, 0x44e8, 0x44f2, 0x44f3,
      0x0001, 0x44ee, 0x44ed, 0x056a, 0x056b, 0x0576, 0x0592, 0x457c,
      0x4610, 0x4611, 0x05f2, 0x4612, 0x4613, 0x05fb, 0x4614, 0x460a,
      0x4608, 0x4609, 0x465c, 0x466c, 0x466d, 0x0001, 0x0001, 0x0649,
      0x4698, 0x0683, 0x4699, 0x0688, 0x469a, 0x06c5, 0x0701, 0x06ff,
      0x4767, 0x4780, 0x07ad, 0x07a1, 0x477d, 0x477e, 0x477f, 0x4784,
      0x07aa, 0x4783, 0x0001, 0x4781, 0x0001, 0x47e2, 0x47e3, 0x0810,
      0x080e, 0x0818, 0x08dd, 0x4881, 0x08e0, 0x08f6, 0x08e5, 0x4884,
      0x08eb, 0x4885, 0x4886, 0x4887, 0x4888, 0x488d, 0x08f9, 0x488e,
      0x488f, 0x08ec, 0x4890, 0x4891, 0x08ee, 0x4892, 0x08ef, 0x4893,
      0x08f4, 0x4894, 0x08f8, 0x4895, 0x4896, 0x08ed, 0x4898, 0x4899,
      0x0001, 0x489f, 0x0001, 0x489e, 0x488c, 0x4924, 0x4930, 0x4941,
      0x499b, 0x499c, 0x499d, 0x499e, 0x49a1, 0x4995, 0x0001, 0x499f,
      0x49a0, 0x49f2, 0x0ad7, 0x4af3, 0x0b05, 0x4af4, 0x0afb, 0x4af5,
      0x0aed, 0x0aee, 0x4af6, 0x0aeb, 0x4af7, 0x0af3, 0x0af4, 0x4adf,
      0x4ae0, 0x4ae1, 0x4ae2, 0x4ae3, 0x4ae4, 0x0aec, 0x4ae5, 0x0ad6,
      0x0b09, 0x4ae6, 0x0b08, 0x4ae7, 0x0aff, 0x4ae8, 0x4ae9, 0x0af5,
      0x0001, 0x4af8, 0x4aed, 0x0001, 0x4aee, 0x0ae9, 0x0001, 0x0001,
      0x4ad2, 0x4af9, 0x4afa, 0x4ad1, 0x4afb, 0x4afc, 0x0b8c, 0x0001,
      0x0b8b, 0x4bd2, 0x4bd3, 0x4bd0, 0x0bb5, 0x4c03, 0x0bdf, 0x0001,
      0x0bde, 0x0cdf, 0x4d3e, 0x4d3f, 0x0cff, 0x4d40, 0x0ce2, 0x4d41,
      0x4d42, 0x0ce3, 0x0cec, 0x4d43, 0x4d44, 0x4d45, 0x0cf2, 0x0cf3,
      0x4d47, 0x4d48, 0x0cef, 0x4d49, 0x4d4a, 0x0ce8, 0x4d4b, 0x0ced,
      0x4d4d, 0x0cf5, 0x4d4e, 0x0d02, 0x4d07, 0x4d3c, 0x4d2b, 0x4d38,
      0x0ce5, 0x0001, 0x4d3b, 0x4d2e, 0x4d34, 0x4d3a, 0x4d33, 0x0001,
      0x4d2c, 0x0ddd, 0x4ec4, 0x0de3, 0x4ec7, 0x4ea7, 0x4ea8, 0x4ea9,
      0x0de8, 0x4eb9, 0x4ebc, 0x4eb4, 0x0001, 0x0001, 0x4eb0, 0x4ec2,
      0x4eaf, 0x0001, 0x4ec3, 0x4ec1, 0x4eac, 0x4eb5, 0x0001, 0x4ec0,
      0x4f56, 0x0e62, 0x4f6a, 0x4f6b, 0x4f6c, 0x4f6d, 0x4fbe, 0x4fbf,
      0x0e97, 0x0e96, 0x4fc0, 0x4fc1, 0x0001, 0x504c, 0x504d, 0x0efd,
      0x504f, 0x0f09, 0x0f0a, 0x0f06, 0x5054, 0x0001, 0x5037, 0x5051,
      0x505c, 0x5056, 0x5052, 0x50c0, 0x0f4c, 0x50c6, 0x50c7, 0x50d1,
      0x0f8b, 0x0f8a, 0x0001, 0x0fc0, 0x0fcf, 0x5109, 0x510b, 0x0fc6,
      0x0fc5, 0x510c, 0x510d, 0x0fd1, 0x510e, 0x0001, 0x0001, 0x5107,
      0x5108, 0x1010, 0x513c, 0x102f, 0x517d, 0x1072, 0x1071, 0x517e,
      0x5180, 0x1067, 0x5181, 0x5182, 0x5183, 0x5179, 0x0001, 0x51ba,
      0x10cb, 0x520b, 0x10cc, 0x520a, 0x520c, 0x520d, 0x520e, 0x10c5,
      0x10d0, 0x0001, 0x5218, 0x521b, 0x0001, 0x5215, 0x5214, 0x1123,
      0x528d, 0x0001, 0x528e, 0x52d3, 0x52cf, 0x116b, 0x52d1, 0x116a,
      0x0001, 0x0001, 0x52d6, 0x116d, 0x52ce, 0x11b0, 0x5309, 0x11a1,
      0x5322, 0x11f7, 0x11f5, 0x5356, 0x11fc, 0x11f9, 0x11fb, 0x11f6,
      0x5357, 0x11ff, 0x535f, 0x5360, 0x0001, 0x535e, 0x5359, 0x127c,
      0x0001, 0x53d9, 0x12e3, 0x12e5, 0x542f, 0x12e7, 0x12e1, 0x5430,
      0x12e0, 0x5431, 0x5432, 0x12eb, 0x5433, 0x12e6, 0x5434, 0x5428,
      0x5427, 0x542b, 0x1386, 0x138c, 0x54a8, 0x1389, 0x54a9, 0x54bc,
      0x54ba, 0x54bb, 0x13b8, 0x54d6, 0x13e6, 0x555b, 0x1460, 0x555c,
      0x555d, 0x555e, 0x555f, 0x5560, 0x5561, 0x5562, 0x5563, 0x5564,
      0x5565, 0x145b, 0x5567, 0x0001, 0x14af, 0x55af, 0x14c2, 0x55b0,
      0x55b1, 0x55b2, 0x5676, 0x5678, 0x5679, 0x567a, 0x159c, 0x567b,
      0x567c, 0x567d, 0x159b, 0x567e, 0x567f, 0x5680, 0x5681, 0x1586,
      0x1599, 0x1589, 0x5682, 0x5683, 0x1594, 0x5684, 0x15cc, 0x5686,
      0x5687, 0x5688, 0x5689, 0x1598, 0x568a, 0x1597, 0x568b, 0x568c,
      0x157a, 0x568d, 0x566c, 0x566d, 0x566e, 0x566f, 0x5670, 0x5671,
      0x1582, 0x5672, 0x5673, 0x5674, 0x1592, 0x56a3, 0x0001, 0x5698,
      0x5695, 0x5696, 0x5697, 0x0001, 0x0001, 0x5669, 0x5690, 0x566a,
      0x0001, 0x5666, 0x0001, 0x1686, 0x57eb, 0x57ec, 0x57ed, 0x167e,
      0x57ee, 0x57ef, 0x57f0, 0x1688, 0x168f, 0x168c, 0x57f2, 0x57f3,
      0x168d, 0x57f4, 0x58c2, 0x58c3, 0x58c5, 0x172f, 0x58c6, 0x58c7,
      0x58c8, 0x1775, 0x0001, 0x590c, 0x5913, 0x5920, 0x179c, 0x5921,
      0x5922, 0x5923, 0x5924, 0x5925, 0x57f6, 0x594e, 0x17e7, 0x17e6,
      0x17d7, 0x594f, 0x5950, 0x5951, 0x17e8, 0x17eb, 0x5953, 0x0001,
      0x5958, 0x0001, 0x59cc, 0x1874, 0x59d2, 0x59d9, 0x59da, 0x59db,
      0x188e, 0x59e7, 0x188f, 0x59ff, 0x5a16, 0x5a17, 0x5a2a, 0x5a2b,
      0x5a2c, 0x5a2d, 0x5a2e, 0x5a2f, 0x0001, 0x0001, 0x5a30, 0x5a5f,
      0x5a60, 0x1917, 0x1919, 0x5a62, 0x5a63, 0x5a64, 0x1914, 0x5a66,
      0x5a67, 0x5a68, 0x1911, 0x5a5d, 0x5ad8, 0x5ad9, 0x5ada, 0x1981,
      0x197e, 0x1982, 0x197f, 0x5adb, 0x5adc, 0x1a0d, 0x5b2a, 0x1a04,
      0x0001, 0x5b33, 0x5b81, 0x5b82, 0x5b83, 0x5b84, 0x1a6d, 0x1a6a,
      0x5b85, 0x5b86, 0x5bae, 0x5baf, 0x5c10, 0x5c11, 0x5c12, 0x1add,
      0x1aeb, 0x5c16, 0x5c17, 0x1ae5, 0x1aed, 0x0001, 0x5c18, 0x5c1a,
      0x5c1e, 0x5c1f, 0x1ae2, 0x5c20, 0x5c21, 0x5c22, 0x5c0b, 0x5c23,
      0x5c27, 0x5c2d, 0x5c35, 0x5c28, 0x5c34, 0x0001, 0x5c29, 0x0001,
      0x5c2a, 0x5c2f, 0x5c2c, 0x1b7e, 0x5dd8, 0x5dd9, 0x0001, 0x5e15,
      0x5e16, 0x5e17, 0x1be0, 0x1c00, 0x5e3c, 0x5e3d, 0x5e3b, 0x0001,
      0x1c4e, 0x1c52, 0x1c53, 0x5e67, 0x1c92, 0x1c99, 0x1c9a, 0x5ebf,
      0x1ce4, 0x5ed7, 0x5f0c, 0x5f0d, 0x5f0e, 0x5f0f, 0x1d75, 0x0001,
      0x0001, 0x6022, 0x6023, 0x1e03, 0x1e60, 0x1e9c, 0x0123, 0x4105,
      0x0001, 0x0124, 0x0001, 0x4103, 0x4104, 0x4100, 0x4101, 0x4102,
      0x40ff, 0x013c, 0x0001, 0x40f8, 0x0001, 0x4164, 0x418f, 0x4190,
      0x0214, 0x0001, 0x41b2, 0x41c8, 0x42ac, 0x42ad, 0x42a0, 0x035d,
      0x42a2, 0x035a, 0x42a9, 0x42aa, 0x42a1, 0x0362, 0x42a3, 0x42a4,
      0x42ab, 0x0355, 0x0361, 0x042a, 0x0423, 0x042e, 0x43d8, 0x43d2,
      0x0427, 0x0425, 0x43dd, 0x43de, 0x43df, 0x43d6, 0x43d9, 0x43e2,
      0x43d7, 0x43da, 0x43db, 0x43d3, 0x43d4, 0x43d5, 0x441f, 0x4433,
      0x0506, 0x44f6, 0x44f7, 0x44f8, 0x0503, 0x0505, 0x44f9, 0x0507,
      0x44fb, 0x44fc, 0x04fe, 0x44fa, 0x44fd, 0x0001, 0x0001, 0x0001,
      0x4502, 0x0001, 0x454c, 0x0575, 0x0001, 0x05b4, 0x05fe, 0x4616,
      0x4617, 0x4618, 0x4619, 0x05fa, 0x461c, 0x461d, 0x461e, 0x461f,
      0x05fd, 0x4625, 0x0001, 0x4620, 0x4624, 0x064e, 0x466f, 0x4670,
      0x46a3, 0x0684, 0x469d, 0x469e, 0x469f, 0x068d, 0x46a2, 0x46a1,
      0x46a0, 0x06c1, 0x46c5, 0x46d1, 0x0001, 0x07a2, 0x4782, 0x07b0,
      0x4792, 0x478f, 0x07c0, 0x478e, 0x07b1, 0x478d, 0x4790, 0x4791,
      0x07c1, 0x478a, 0x478b, 0x478c, 0x07c9, 0x0001, 0x0001, 0x0001,
      0x4794, 0x0811, 0x47e8, 0x47e7, 0x489b, 0x48a4, 0x0908, 0x48ae,
      0x090a, 0x0902, 0x48a5, 0x0901, 0x090b, 0x48a6, 0x48a7, 0x48a8,
      0x48a9, 0x48aa, 0x48ab, 0x48ac, 0x48b0, 0x48b2, 0x08fc, 0x48b3,
      0x48b4, 0x489a, 0x48bc, 0x48b7, 0x0001, 0x0001, 0x48c0, 0x4927,
      0x4935, 0x49aa, 0x49ab, 0x49a9, 0x0a1a, 0x49db, 0x0a2a, 0x0b16,
      0x4b09, 0x4b0a, 0x4b0b, 0x0b20, 0x0b0c, 0x4b0c, 0x4b0d, 0x0b27,
      0x4b0e, 0x4b0f, 0x0b23, 0x0b11, 0x4b10, 0x4b11, 0x0b19, 0x4b22,
      0x4b23, 0x4b24, 0x4b1c, 0x0b24, 0x4b1d, 0x4b1e, 0x0b1c, 0x0001,
      0x4b2a, 0x4b06, 0x0001, 0x0001, 0x0001, 0x4b07, 0x4b08, 0x4b12,
      0x4b1f, 0x4b04, 0x4b00, 0x0b25, 0x0001, 0x4bd4, 0x4bd5, 0x4bd6,
      0x0bb6, 0x4be4, 0x4be5, 0x4bee, 0x4bef, 0x4c06, 0x0cfa, 0x4d5a,
      0x4d5b, 0x4d75, 0x4d76, 0x0d0a, 0x4d77, 0x4d78, 0x4d79, 0x0d29,
      0x4d7a, 0x0d16, 0x0d2b, 0x4d7b, 0x0d15, 0x4d7c, 0x4d7d, 0x4d7e,
      0x0d31, 0x0d30, 0x4d80, 0x0d27, 0x0d04, 0x0d1d, 0x0d50, 0x0d1e,
      0x0000, 0x0d2f, 0x0d03, 0x4d81, 0x0d2a, 0x4dd0, 0x4d83, 0x4d6f,
      0x0001, 0x4d72, 0x4d6a, 0x4d74, 0x4d6e, 0x4d64, 0x4d5f, 0x4d55,
      0x0d28, 0x0001, 0x0df5, 0x4ec8, 0x4ec9, 0x0df2, 0x0df4, 0x4eca,
      0x0df7, 0x4ecb, 0x4ed5, 0x0001, 0x0001, 0x4f52, 0x0e4b, 0x4f70,
      0x4f6e, 0x4f6f, 0x0e9a, 0x0e9d, 0x4fc5, 0x4fc6, 0x5066, 0x0f14,
      0x0f13, 0x5067, 0x0f10, 0x5075, 0x5074, 0x50c8, 0x50c9, 0x0f49,
      0x0f8c, 0x0f97, 0x0fd4, 0x5111, 0x5112, 0x0fd3, 0x510f, 0x5110,
      0x0001, 0x101d, 0x5184, 0x5185, 0x5186, 0x5187, 0x5188, 0x1076,
      0x1078, 0x0001, 0x0001, 0x5222, 0x10d1, 0x5223, 0x10d3, 0x5224,
      0x10cf, 0x5225, 0x10d2, 0x521f, 0x0001, 0x10d8, 0x5228, 0x5226,
      0x112c, 0x112d, 0x1128, 0x112f, 0x1130, 0x112e, 0x5297, 0x5298,
      0x529e, 0x52a0, 0x5299, 0x52da, 0x52db, 0x52dc, 0x52dd, 0x0001,
      0x52d5, 0x11a6, 0x530a, 0x11a9, 0x5324, 0x5366, 0x1211, 0x1212,
      0x5367, 0x120d, 0x5368, 0x1203, 0x5369, 0x1208, 0x1201, 0x536a,
      0x1210, 0x536f, 0x536b, 0x5363, 0x1202, 0x53e1, 0x53e2, 0x1280,
      0x127f, 0x5437, 0x5438, 0x5439, 0x1306, 0x543a, 0x543b, 0x543c,
      0x12ff, 0x543d, 0x1301, 0x543e, 0x5444, 0x1305, 0x1300, 0x1307,
      0x12fb, 0x5445, 0x5446, 0x5447, 0x12ef, 0x12f3, 0x5441, 0x5435,
      0x0001, 0x138b, 0x54d8, 0x13bc, 0x13bd, 0x0001, 0x13e7, 0x5502,
      0x0001, 0x556e, 0x556f, 0x5570, 0x5571, 0x5572, 0x5573, 0x1464,
      0x55a3, 0x56a4, 0x56a5, 0x15a2, 0x15a4, 0x15aa, 0x56a6, 0x15af,
      0x56a7, 0x56a8, 0x56a9, 0x15a9, 0x56aa, 0x15ae, 0x15b6, 0x56ab,
      0x56ac, 0x15bf, 0x15ba, 0x56ad, 0x56ae, 0x56af, 0x56b0, 0x159f,
      0x56b1, 0x15b5, 0x56b2, 0x56b3, 0x15be, 0x15a5, 0x56b4, 0x56b5,
      0x56b6, 0x56b7, 0x56b8, 0x0001, 0x0001, 0x56bd, 0x0001, 0x56bf,
      0x0001, 0x1653, 0x57f8, 0x1694, 0x57fa, 0x57fb, 0x169b, 0x169e,
      0x169a, 0x1693, 0x57fc, 0x57fd, 0x1698, 0x57fe, 0x57ff, 0x5800,
      0x5801, 0x5802, 0x5803, 0x5806, 0x5807, 0x5808, 0x5809, 0x1697,
      0x580a, 0x580b, 0x580c, 0x580d, 0x580e, 0x580f, 0x5810, 0x1691,
      0x5811, 0x5812, 0x58cc, 0x58cd, 0x173e, 0x58ce, 0x58cf, 0x1745,
      0x58d0, 0x1742, 0x58d1, 0x58d2, 0x173d, 0x0001, 0x0001, 0x5914,
      0x1785, 0x5915, 0x0001, 0x179d, 0x179e, 0x5926, 0x595c, 0x595d,
      0x595e, 0x595f, 0x5961, 0x5960, 0x59cd, 0x1882, 0x0001, 0x18be,
      0x0001, 0x5a00, 0x5a36, 0x191c, 0x5a69, 0x5a6a, 0x5a6b, 0x191b,
      0x191d, 0x5a6c, 0x5a6d, 0x5a6e, 0x5a6f, 0x5a70, 0x5a74, 0x0001,
      0x5ade, 0x5adf, 0x0001, 0x5add, 0x5b87, 0x1a73, 0x1a72, 0x1a70,
      0x5b88, 0x5b89, 0x5b8a, 0x5b8b, 0x5b8c, 0x5b8d, 0x1a9b, 0x1a95,
      0x1a9a, 0x5bb1, 0x5c49, 0x5c4b, 0x1ae9, 0x1af5, 0x5c4d, 0x5c4e,
      0x5c4f, 0x5c50, 0x1af0, 0x5c51, 0x1af7, 0x5c52, 0x5c53, 0x5c54,
      0x5c55, 0x5c56, 0x5c57, 0x1aef, 0x5c45, 0x5c36, 0x0001, 0x5c3b,
      0x5c59, 0x5c70, 0x0001, 0x5c3d, 0x5c5f, 0x5c44, 0x5c5a, 0x5c38,
      0x5c60, 0x0001, 0x5c3c, 0x5c5b, 0x5c42, 0x5e18, 0x5e1e, 0x5e3e,
      0x0001, 0x5e68, 0x5e69, 0x5e6a, 0x5e6b, 0x1c54, 0x5e6d, 0x5e6e,
      0x5e6f, 0x5e70, 0x5e71, 0x1c73, 0x1c70, 0x1c9b, 0x1cc5, 0x5ec1,
      0x1ce5, 0x5edc, 0x5edf, 0x1d1c, 0x5f02, 0x1d28, 0x1d26, 0x5f10,
      0x5f11, 0x5f12, 0x5f13, 0x5f14, 0x1d77, 0x1d8c, 0x1d8e, 0x5f90,
      0x5f91, 0x5f9d, 0x5f9e, 0x0001, 0x6024, 0x1e04, 0x6025, 0x60da,
      0x4106, 0x4107, 0x4108, 0x4109, 0x0137, 0x013e, 0x410b, 0x0133,
      0x013d, 0x013b, 0x410a, 0x4111, 0x4191, 0x01ed, 0x0217, 0x0001,
      0x42b7, 0x42b8, 0x0376, 0x036f, 0x42b9, 0x42ba, 0x0375, 0x42b3,
      0x42ae, 0x42af, 0x42b0, 0x42b1, 0x42b2, 0x0368, 0x42b4, 0x42b5,
      0x42bb, 0x42b6, 0x4310, 0x0439, 0x0430, 0x43fb, 0x0438, 0x43f8,
      0x43f9, 0x43fa, 0x43ed, 0x43f6, 0x0439, 0x4505, 0x4506, 0x4507,
      0x4508, 0x4509, 0x050e, 0x450c, 0x0001, 0x0001, 0x0001, 0x0001,
      0x450b, 0x0001, 0x05b7, 0x0607, 0x0613, 0x4627, 0x0601, 0x462a,
      0x462c, 0x462d, 0x0604, 0x4626, 0x462e, 0x462f, 0x0605, 0x4671,
      0x4672, 0x4673, 0x0001, 0x46a6, 0x068f, 0x46a7, 0x0692, 0x46c7,
      0x46e7, 0x4797, 0x4798, 0x4799, 0x479c, 0x479d, 0x47a2, 0x47a3,
      0x47a4, 0x47a5, 0x07d8, 0x47a0, 0x47a1, 0x07e9, 0x479e, 0x479f,
      0x07da, 0x4788, 0x47ab, 0x47e9, 0x48b5, 0x48b6, 0x48ca, 0x48cb,
      0x0909, 0x48cc, 0x48cd, 0x48ce, 0x48cf, 0x48d0, 0x48d1, 0x48d2,
      0x48c9, 0x48e0, 0x0920, 0x48da, 0x0001, 0x0977, 0x4929, 0x0970,
      0x4937, 0x4938, 0x09f9, 0x49b4, 0x49b5, 0x49b6, 0x0001, 0x0001,
      0x49b1, 0x4b32, 0x4b33, 0x0b40, 0x0b3d, 0x4b34, 0x0b36, 0x0b41,
      0x4b36, 0x4b37, 0x0b31, 0x4b38, 0x4b3a, 0x0b38, 0x4b2c, 0x4b2d,
      0x4b2e, 0x4b2f, 0x4b30, 0x4b31, 0x4b4f, 0x0b2a, 0x4b50, 0x0001,
      0x4b46, 0x4b4d, 0x4b3b, 0x4b42, 0x0001, 0x0001, 0x4b51, 0x4b3d,
      0x0001, 0x0b3f, 0x4b3e, 0x0001, 0x4b41, 0x4b52, 0x4b40, 0x0001,
      0x4be6, 0x4be7, 0x0bb9, 0x4be8, 0x4c07, 0x4c08, 0x4c09, 0x0bdc,
      0x0d33, 0x0d2c, 0x0d53, 0x0d47, 0x0d51, 0x0d56, 0x0d54, 0x0d49,
      0x0d4a, 0x0d39, 0x0d4c, 0x4d89, 0x4d8a, 0x4d8b, 0x4d8c, 0x4d8d,
      0x0d55, 0x4d8e, 0x4d8f, 0x4d90, 0x4d91, 0x4d86, 0x4d87, 0x4d88,
      0x0d4d, 0x4d69, 0x4d94, 0x0001, 0x4d84, 0x4da6, 0x4d98, 0x4d9d,
      0x4d9a, 0x4d66, 0x0001, 0x4d9e, 0x4d93, 0x0001, 0x4d9c, 0x4d73,
      0x0e01, 0x0dfe, 0x0df9, 0x4ef0, 0x0e00, 0x4ef1, 0x0001, 0x0001,
      0x4eea, 0x4ede, 0x4eee, 0x4eed, 0x4edb, 0x4eeb, 0x4eef, 0x4ee1,
      0x4eec, 0x4f74, 0x4f75, 0x0ea1, 0x0e9f, 0x4fc9, 0x4fca, 0x0ea6,
      0x4fcb, 0x4fcc, 0x4fcd, 0x0001, 0x0001, 0x4fce, 0x0f20, 0x5081,
      0x5082, 0x0f1c, 0x0f1b, 0x0f19, 0x5083, 0x0f1e, 0x5080, 0x5065,
      0x50cb, 0x0f4b, 0x50ec, 0x0fdb, 0x0fd5, 0x5113, 0x0fd0, 0x5114,
      0x5115, 0x0001, 0x0fdf, 0x0001, 0x1011, 0x5137, 0x5138, 0x5139,
      0x107a, 0x5197, 0x5194, 0x0001, 0x522d, 0x522e, 0x522f, 0x5230,
      0x10e8, 0x5231, 0x10e5, 0x10f7, 0x5233, 0x0001, 0x10e7, 0x52a4,
      0x1131, 0x1134, 0x52a5, 0x0001, 0x52a2, 0x52b3, 0x1172, 0x530c,
      0x530b, 0x11ac, 0x5376, 0x1220, 0x1219, 0x1213, 0x5377, 0x1215,
      0x5379, 0x0001, 0x0001, 0x53e9, 0x1282, 0x53e8, 0x0001, 0x5456,
      0x5457, 0x5458, 0x5459, 0x1319, 0x131b, 0x545a, 0x545b, 0x1310,
      0x545c, 0x545d, 0x545e, 0x5453, 0x5452, 0x138d, 0x54bd, 0x54be,
      0x54bf, 0x54dc, 0x13c0, 0x54dd, 0x13c1, 0x13be, 0x54de, 0x0001,
      0x0001, 0x5574, 0x5575, 0x5577, 0x146a, 0x5578, 0x0001, 0x0001,
      0x14ab, 0x55b5, 0x55b6, 0x55b7, 0x55b8, 0x14c5, 0x55b9, 0x56c6,
      0x15c7, 0x56c7, 0x15b9, 0x56c8, 0x56c9, 0x56ca, 0x56cb, 0x15d6,
      0x56cc, 0x56cd, 0x56ce, 0x56cf, 0x56d0, 0x15c8, 0x56d1, 0x15bd,
      0x15c6, 0x56d2, 0x56e2, 0x15d2, 0x56e3, 0x15c1, 0x56e4, 0x15ca,
      0x15d0, 0x56e5, 0x56e6, 0x56e7, 0x56e8, 0x56e9, 0x56ea, 0x56eb,
      0x15ce, 0x15de, 0x15d5, 0x56ec, 0x56ed, 0x15dc, 0x15c0, 0x56ee,
      0x15c4, 0x56f0, 0x56f1, 0x56f2, 0x56f3, 0x56f4, 0x56db, 0x56dc,
      0x0001, 0x1654, 0x5815, 0x16b4, 0x16b5, 0x5816, 0x5817, 0x5818,
      0x16a3, 0x5819, 0x581a, 0x581b, 0x16b3, 0x581c, 0x581d, 0x581e,
      0x581f, 0x5820, 0x5825, 0x169f, 0x16a6, 0x16a5, 0x5826, 0x5827,
      0x5828, 0x16ab, 0x5829, 0x16a9, 0x16a8, 0x5814, 0x0001, 0x5821,
      0x0001, 0x0001, 0x1708, 0x58d5, 0x1748, 0x58d6, 0x58d7, 0x58d9,
      0x174e, 0x174f, 0x58da, 0x58db, 0x58dc, 0x173a, 0x1749, 0x5916,
      0x5917, 0x5918, 0x179f, 0x5929, 0x592a, 0x180b, 0x5967, 0x5968,
      0x5969, 0x180d, 0x596a, 0x596b, 0x596c, 0x180f, 0x1803, 0x596d,
      0x596e, 0x5973, 0x5963, 0x5975, 0x5965, 0x0001, 0x59ce, 0x59d3,
      0x59e8, 0x5a04, 0x18cd, 0x18bf, 0x5a05, 0x18c0, 0x18c2, 0x5a01,
      0x5a39, 0x5a3a, 0x5a3b, 0x5a3e, 0x5a79, 0x1926, 0x5a7b, 0x5a7c,
      0x5a7d, 0x5a7e, 0x5a7f, 0x1922, 0x5a80, 0x5a81, 0x192b, 0x1927,
      0x1921, 0x5a83, 0x1928, 0x5a84, 0x5a78, 0x0001, 0x5a76, 0x5ae9,
      0x5ae4, 0x5ae5, 0x5ae6, 0x1992, 0x5ae7, 0x5ae8, 0x1988, 0x5b40,
      0x5b41, 0x1a1f, 0x0001, 0x5b3e, 0x5b90, 0x1a75, 0x5b91, 0x5b92,
      0x1a7b, 0x5b93, 0x5b94, 0x1a9d, 0x1a9e, 0x1aa1, 0x1ab6, 0x0001,
      0x0001, 0x5bb4, 0x5c80, 0x5c81, 0x5c82, 0x5c83, 0x1b06, 0x1af9,
      0x1aff, 0x5c85, 0x1b01, 0x1b02, 0x1b04, 0x5c64, 0x5c65, 0x1afe,
      0x5c66, 0x5c67, 0x5c68, 0x5c69, 0x1afd, 0x5c7d, 0x0001, 0x0001,
      0x5c74, 0x5c6c, 0x5c88, 0x0001, 0x5c7b, 0x5c7f, 0x5c6b, 0x0001,
      0x5c78, 0x5c73, 0x0001, 0x5cc1, 0x5dcd, 0x1b86, 0x1b85, 0x5ddd,
      0x0001, 0x1be6, 0x5e1f, 0x5e2c, 0x1c1c, 0x1c1e, 0x5e41, 0x1c40,
      0x5e73, 0x5e74, 0x5e75, 0x1c74, 0x5e87, 0x1c9e, 0x5ea0, 0x1ca3,
      0x5e9f, 0x5ea1, 0x5ea2, 0x5e9e, 0x5e9d, 0x5ec3, 0x1ce8, 0x5edd,
      0x5ee3, 0x1cf1, 0x1ced, 0x1cee, 0x1cf2, 0x1d31, 0x5f1c, 0x5f1d,
      0x5f1e, 0x5f1f, 0x5f20, 0x1d35, 0x5f21, 0x1d2d, 0x1d30, 0x1d72,
      0x5f1a, 0x0001, 0x5f74, 0x1d8f, 0x1d93, 0x5f75, 0x0001, 0x5f92,
      0x1dba, 0x5fa3, 0x1dcd, 0x5fa5, 0x5fa6, 0x5fa7, 0x5fa8, 0x0001,
      0x1dca, 0x5fa2, 0x0001, 0x6026, 0x602a, 0x602b, 0x602c, 0x602d,
      0x1e0b, 0x602e, 0x602f, 0x6030, 0x1e0c, 0x6031, 0x1e08, 0x1e61,
      0x60e8, 0x1ea6, 0x1ea5, 0x4112, 0x4116, 0x0143, 0x4115, 0x4113,
      0x0001, 0x41b3, 0x028d, 0x42c8, 0x42c9, 0x42cc, 0x42cd, 0x0386,
      0x42ca, 0x42cb, 0x0382, 0x42c7, 0x0001, 0x03be, 0x4311, 0x043f,
      0x4404, 0x0001, 0x0001, 0x0436, 0x4405, 0x0001, 0x4403, 0x0510,
      0x0511, 0x0512, 0x451e, 0x4516, 0x4517, 0x4518, 0x050f, 0x4522,
      0x451c, 0x4519, 0x4500, 0x456e, 0x4642, 0x4643, 0x4645, 0x0606,
      0x463d, 0x463e, 0x463f, 0x4640, 0x4641, 0x1c04, 0x4644, 0x0001,
      0x4646, 0x4675, 0x4676, 0x4677, 0x0657, 0x0696, 0x46a9, 0x46aa,
      0x0695, 0x46ab, 0x46c8, 0x0705, 0x07d0, 0x07d3, 0x47be, 0x07ea,
      0x47bb, 0x47bc, 0x07df, 0x47bd, 0x07e6, 0x47b9, 0x47ba, 0x07dc,
      0x47a8, 0x0930, 0x48e8, 0x092d, 0x48e9, 0x48ea, 0x48e3, 0x0001,
      0x48e6, 0x0001, 0x0001, 0x0001, 0x4915, 0x492a, 0x0001, 0x098a,
      0x09ff, 0x09fd, 0x09fe, 0x49c1, 0x0001, 0x0a01, 0x49c5, 0x49c0,
      0x49bd, 0x49b9, 0x49fb, 0x4b6c, 0x4b6d, 0x4b6e, 0x0b50, 0x0b42,
      0x4b6f, 0x0b47, 0x4b70, 0x4b71, 0x4b72, 0x0b4d, 0x4b73, 0x0b52,
      0x4b74, 0x4b75, 0x4b76, 0x0b56, 0x4b77, 0x4b78, 0x0b4b, 0x0001,
      0x0001, 0x4b65, 0x4b5d, 0x0001, 0x0001, 0x4b58, 0x4b6b, 0x0001,
      0x0001, 0x0001, 0x0001, 0x0b8e, 0x0b93, 0x0001, 0x4be9, 0x0bba,
      0x0bb8, 0x4bf0, 0x4bf1, 0x0be0, 0x0001, 0x4c0a, 0x4dab, 0x4dac,
      0x0d5a, 0x0d6b, 0x0d6d, 0x4dad, 0x0d71, 0x0d4e, 0x4dae, 0x4daf,
      0x4db0, 0x0d72, 0x0d67, 0x4db2, 0x0d64, 0x0d5c, 0x4dbc, 0x4db5,
      0x4dbd, 0x4db6, 0x4dbb, 0x0001, 0x4db7, 0x0001, 0x4db8, 0x4db9,
      0x4dbe, 0x4dba, 0x0d68, 0x4ef7, 0x0e07, 0x4ef8, 0x0e02, 0x0e09,
      0x0e06, 0x4efc, 0x4efd, 0x0e10, 0x4b64, 0x4f01, 0x4efe, 0x4f0d,
      0x4efb, 0x4ee9, 0x0001, 0x4f03, 0x0001, 0x4f79, 0x4f7a, 0x4fcf,
      0x4fd0, 0x0ea2, 0x0ea5, 0x4fd1, 0x4fd2, 0x0ea4, 0x5087, 0x5090,
      0x0f27, 0x0001, 0x0001, 0x508e, 0x0f1f, 0x50cc, 0x50ee, 0x5118,
      0x5119, 0x0001, 0x511b, 0x0fe1, 0x0fe5, 0x0fe3, 0x511c, 0x0fe0,
      0x513d, 0x1038, 0x519b, 0x519c, 0x519d, 0x519e, 0x519f, 0x1090,
      0x0001, 0x51a0, 0x519a, 0x6035, 0x5240, 0x5241, 0x5242, 0x5243,
      0x5244, 0x5245, 0x10e9, 0x523b, 0x0001, 0x523f, 0x10ea, 0x523a,
      0x52a7, 0x117b, 0x52e7, 0x52e4, 0x11ae, 0x11af, 0x11ad, 0x530f,
      0x5310, 0x537e, 0x537f, 0x122a, 0x1225, 0x537c, 0x537d, 0x1224,
      0x122b, 0x5380, 0x1222, 0x122e, 0x5384, 0x5382, 0x0001, 0x1221,
      0x5383, 0x53ec, 0x53ed, 0x1288, 0x0001, 0x53ef, 0x5466, 0x5467,
      0x1325, 0x5468, 0x1328, 0x132d, 0x5469, 0x546a, 0x546b, 0x1318,
      0x546c, 0x132e, 0x1323, 0x131e, 0x546d, 0x5464, 0x0001, 0x0001,
      0x5463, 0x136f, 0x54ab, 0x54ac, 0x54ad, 0x54c0, 0x13c3, 0x54e7,
      0x0001, 0x5509, 0x557d, 0x557e, 0x557f, 0x5580, 0x5581, 0x5582,
      0x1471, 0x5584, 0x1474, 0x5585, 0x5586, 0x0001, 0x1491, 0x55ba,
      0x14c3, 0x14c4, 0x15e8, 0x56f5, 0x56f6, 0x56f7, 0x56f8, 0x15ed,
      0x15e9, 0x56f9, 0x15f5, 0x15f8, 0x56fa, 0x15ee, 0x56fb, 0x0001,
      0x56fc, 0x56fd, 0x15e2, 0x56fe, 0x56ff, 0x15e6, 0x5700, 0x56ef,
      0x15e7, 0x5705, 0x5706, 0x15c9, 0x5707, 0x15eb, 0x570d, 0x5718,
      0x570a, 0x1656, 0x1655, 0x57a9, 0x582a, 0x582b, 0x5863, 0x582c,
      0x16b9, 0x582d, 0x582e, 0x582f, 0x5830, 0x16bb, 0x5831, 0x5832,
      0x16be, 0x5833, 0x5834, 0x5835, 0x5836, 0x16c1, 0x5837, 0x5838,
      0x5839, 0x583b, 0x58df, 0x1757, 0x1755, 0x58e0, 0x58e1, 0x1753,
      0x58e2, 0x58e3, 0x58e4, 0x58e5, 0x0001, 0x0001, 0x58e6, 0x17a0,
      0x1815, 0x597b, 0x597c, 0x1829, 0x1821, 0x1812, 0x1833, 0x1816,
      0x1814, 0x597d, 0x597e, 0x1813, 0x1828, 0x0001, 0x5976, 0x0001,
      0x597f, 0x59e9, 0x59ea, 0x0001, 0x18d0, 0x18d1, 0x0001, 0x5a09,
      0x5a08, 0x18ec, 0x5a18, 0x5a40, 0x5a41, 0x5a87, 0x5a88, 0x5a89,
      0x1936, 0x5a8b, 0x192f, 0x5a8c, 0x1931, 0x1932, 0x192c, 0x0001,
      0x5aba, 0x199d, 0x199b, 0x5aea, 0x5aeb, 0x1998, 0x5aec, 0x199c,
      0x1a23, 0x1a26, 0x1a28, 0x5b42, 0x5b77, 0x5b96, 0x5b97, 0x1a7a,
      0x1aa6, 0x1aa4, 0x5bb7, 0x1aa3, 0x0001, 0x5c8f, 0x1b17, 0x5c90,
      0x5c91, 0x5c92, 0x5c93, 0x5c94, 0x5c96, 0x5c97, 0x5c98, 0x5c99,
      0x5c9a, 0x5c9b, 0x5c9c, 0x5c9d, 0x5c9e, 0x5c9f, 0x5ca0, 0x5cc2,
      0x5ca7, 0x5cc7, 0x0001, 0x5cd3, 0x5ca8, 0x5cbf, 0x5ccb, 0x5cb7,
      0x5cbd, 0x0001, 0x5cd6, 0x5cbe, 0x5cbb, 0x0001, 0x5cc8, 0x5cc4,
      0x5cb6, 0x5cc0, 0x5cba, 0x5cbc, 0x1b8c, 0x1b96, 0x1b8e, 0x1b8a,
      0x5de3, 0x1b89, 0x5de4, 0x5de5, 0x1b8d, 0x1be8, 0x5e2d, 0x0001,
      0x0001, 0x0001, 0x1c5b, 0x1c59, 0x5e76, 0x5e8f, 0x0001, 0x5ea4,
      0x5ea5, 0x1ca2, 0x1cf8, 0x1cf9, 0x1cfa, 0x0001, 0x0001, 0x1d39,
      0x1d37, 0x5f22, 0x5f23, 0x1d3c, 0x5f24, 0x1d34, 0x5f25, 0x0001,
      0x5f64, 0x5f65, 0x5f66, 0x0001, 0x5f7a, 0x5f79, 0x1d96, 0x0001,
      0x5f8e, 0x1dcc, 0x5fb1, 0x5fb2, 0x5fb3, 0x5fb4, 0x5fb5, 0x5fb6,
      0x1dd1, 0x1dcf, 0x1dd0, 0x1dff, 0x5faa, 0x5fae, 0x5fab, 0x6039,
      0x603a, 0x603b, 0x1e11, 0x603c, 0x603d, 0x1e16, 0x603e, 0x603f,
      0x6040, 0x0001, 0x1e09, 0x1e63, 0x60cb, 0x1e62, 0x60dd, 0x60db,
      0x60e9, 0x60ea, 0x0001, 0x1ea7, 0x1eba, 0x411c, 0x411d, 0x411f,
      0x0145, 0x411b, 0x411a, 0x41a5, 0x42d0, 0x42d1, 0x42d2, 0x42d3,
      0x42d4, 0x42d5, 0x42d7, 0x42d6, 0x0001, 0x42db, 0x0444, 0x4407,
      0x0001, 0x4408, 0x0516, 0x452c, 0x0517, 0x0001, 0x452b, 0x452d,
      0x4524, 0x4527, 0x4525, 0x454e, 0x4570, 0x456f, 0x0608, 0x0655,
      0x0653, 0x46ea, 0x46e9, 0x07de, 0x47bf, 0x47c7, 0x47c8, 0x07ef,
      0x47c9, 0x47ca, 0x47cb, 0x093b, 0x48ee, 0x0938, 0x091f, 0x48ef,
      0x48f0, 0x0978, 0x492b, 0x4939, 0x4944, 0x49cd, 0x4b8c, 0x0b57,
      0x4b8a, 0x4b8b, 0x0b5a, 0x0b5f, 0x4b7c, 0x4b7d, 0x4b7e, 0x4b7f,
      0x4b80, 0x4b81, 0x4b82, 0x4b83, 0x4b84, 0x0001, 0x4b85, 0x4b87,
      0x0001, 0x4b86, 0x0001, 0x0001, 0x0001, 0x0b96, 0x4bea, 0x0001,
      0x4db3, 0x4db4, 0x4dd3, 0x0d6f, 0x4dd6, 0x4dd4, 0x4dd5, 0x4dd7,
      0x4dd8, 0x0d80, 0x4dce, 0x0001, 0x4dc7, 0x4dc0, 0x4f1e, 0x4f1a,
      0x4f11, 0x0001, 0x4f19, 0x0001, 0x4f17, 0x0eaa, 0x0ea7, 0x0ea9,
      0x5091, 0x0f2f, 0x0f2d, 0x0f21, 0x0f2c, 0x509c, 0x50a0, 0x0f3b,
      0x0f2a, 0x50cd, 0x0f50, 0x50ce, 0x50cf, 0x0001, 0x0fe7, 0x511f,
      0x0fea, 0x0fe9, 0x1013, 0x103a, 0x51a3, 0x51a4, 0x0001, 0x0001,
      0x1087, 0x51a5, 0x0001, 0x0001, 0x109e, 0x5246, 0x10f2, 0x5247,
      0x10f5, 0x5248, 0x10f0, 0x524f, 0x5258, 0x524b, 0x0001, 0x524d,
      0x1135, 0x1138, 0x1183, 0x52ea, 0x0001, 0x52e8, 0x52e5, 0x52e9,
      0x11b2, 0x5311, 0x11b4, 0x538d, 0x123a, 0x122f, 0x1234, 0x538e,
      0x538f, 0x5390, 0x1232, 0x1237, 0x1230, 0x5391, 0x5389, 0x123d,
      0x538a, 0x538b, 0x538c, 0x1235, 0x126c, 0x5397, 0x0001, 0x5394,
      0x0001, 0x133e, 0x5476, 0x5477, 0x1332, 0x5478, 0x546f, 0x5470,
      0x5471, 0x5472, 0x133d, 0x5474, 0x0001, 0x133f, 0x1337, 0x1334,
      0x133a, 0x5479, 0x1372, 0x1393, 0x54ae, 0x1392, 0x54e1, 0x54e2,
      0x54e8, 0x1476, 0x147b, 0x558b, 0x147e, 0x558d, 0x558e, 0x0001,
      0x559b, 0x55bd, 0x55bb, 0x55bc, 0x5725, 0x15f3, 0x1612, 0x5726,
      0x5727, 0x5728, 0x5729, 0x572a, 0x572b, 0x1610, 0x572c, 0x572d,
      0x15fa, 0x572e, 0x1603, 0x572f, 0x15e1, 0x15fb, 0x5730, 0x5731,
      0x1607, 0x5732, 0x5733, 0x1608, 0x5734, 0x15f9, 0x15fe, 0x5735,
      0x1602, 0x1600, 0x0001, 0x0001, 0x0001, 0x15fd, 0x5724, 0x46d2,
      0x5842, 0x5843, 0x16cb, 0x5844, 0x5845, 0x16ca, 0x5847, 0x5848,
      0x5849, 0x16cc, 0x584a, 0x584b, 0x584c, 0x584d, 0x584e, 0x16cd,
      0x16c8, 0x16c9, 0x5851, 0x583d, 0x16c7, 0x583e, 0x16c6, 0x583f,
      0x0001, 0x1758, 0x58e7, 0x58e8, 0x58e9, 0x175e, 0x58ea, 0x58eb,
      0x58ec, 0x5919, 0x178a, 0x591a, 0x592b, 0x17a1, 0x5981, 0x5982,
      0x183c, 0x5983, 0x182c, 0x5984, 0x5985, 0x183b, 0x5986, 0x5987,
      0x182e, 0x5988, 0x598e, 0x182d, 0x598c, 0x598d, 0x1836, 0x187c,
      0x59dc, 0x59dd, 0x59de, 0x59df, 0x59ec, 0x1895, 0x5a0c, 0x0001,
      0x5a90, 0x5a91, 0x5a8e, 0x1937, 0x193d, 0x1938, 0x5af0, 0x19a3,
      0x1a30, 0x5b44, 0x5b98, 0x5bba, 0x1aaa, 0x5bbb, 0x5bbc, 0x5bbd,
      0x1aa9, 0x5bc1, 0x0001, 0x1b31, 0x5cee, 0x5cef, 0x1b26, 0x5cf0,
      0x1b22, 0x1b20, 0x5cf1, 0x5cf2, 0x5cf3, 0x5cf4, 0x5cf6, 0x5cf7,
      0x1b25, 0x1b28, 0x5cf8, 0x5cf9, 0x1b1c, 0x5cda, 0x5ce9, 0x5cdd,
      0x5ce3, 0x5cdb, 0x5cdf, 0x0001, 0x0001, 0x0001, 0x5d09, 0x0001,
      0x5ce7, 0x5d33, 0x5d0e, 0x1b90, 0x5de6, 0x1b92, 0x1b8f, 0x5de7,
      0x5de8, 0x1bea, 0x1beb, 0x5e23, 0x0001, 0x5e4c, 0x0001, 0x0001,
      0x5e49, 0x1c5d, 0x5e77, 0x5e78, 0x1c5c, 0x0001, 0x5e88, 0x1c76,
      0x1c81, 0x5ea9, 0x5eaa, 0x5eab, 0x5d01, 0x5ead, 0x5ea8, 0x5ee4,
      0x5eeb, 0x1cfc, 0x5eec, 0x1d00, 0x1cff, 0x5ee8, 0x5ee9, 0x1cfe,
      0x5eea, 0x1d16, 0x1d1e, 0x1d1d, 0x1d42, 0x5f2d, 0x5f2e, 0x5f2f,
      0x5f30, 0x1d3d, 0x5f31, 0x5f32, 0x5f33, 0x5f34, 0x5f35, 0x1d43,
      0x1d7e, 0x5f7c, 0x5f7d, 0x5f7e, 0x5f7f, 0x1dc1, 0x5fb7, 0x5fb9,
      0x1dd2, 0x5fba, 0x5fbb, 0x5fbc, 0x5fbd, 0x5fbe, 0x1dd4, 0x0001,
      0x0001, 0x5fbf, 0x6041, 0x6042, 0x6043, 0x6044, 0x6045, 0x6046,
      0x6047, 0x6048, 0x604f, 0x6050, 0x1e1b, 0x6051, 0x6052, 0x6053,
      0x1e1a, 0x1e19, 0x0001, 0x0001, 0x60cc, 0x60cd, 0x0001, 0x1e77,
      0x1e7f, 0x60eb, 0x1e99, 0x1e9d, 0x60fb, 0x60fc, 0x1eb2, 0x1ec5,
      0x1edc, 0x4128, 0x4129, 0x0001, 0x42e0, 0x42e1, 0x42e2, 0x038e,
      0x0001, 0x038d, 0x4436, 0x0001, 0x05b9, 0x458a, 0x4649, 0x0656,
      0x0001, 0x47cc, 0x07ed, 0x47ce, 0x47cf, 0x47d0, 0x47d1, 0x47d2,
      0x47d3, 0x47c3, 0x47d5, 0x48fc, 0x0945, 0x48f8, 0x48f9, 0x48f5,
      0x0001, 0x0001, 0x4931, 0x09a9, 0x0a03, 0x0a04, 0x49ce, 0x4b96,
      0x4b97, 0x4b90, 0x4b92, 0x4b93, 0x0001, 0x0001, 0x0001, 0x0001,
      0x4b98, 0x4b91, 0x0b9b, 0x4bf2, 0x0001, 0x4de3, 0x4de4, 0x0d95,
      0x0d87, 0x4de5, 0x4de6, 0x4de7, 0x4de8, 0x4dda, 0x4ddb, 0x0d97,
      0x0d82, 0x4dc5, 0x4ddf, 0x4f2a, 0x0e1d, 0x0e1b, 0x0001, 0x4f23,
      0x4fd4, 0x0f30, 0x0f39, 0x0f31, 0x50a3, 0x0001, 0x0001, 0x50a9,
      0x0001, 0x0f54, 0x0f51, 0x0ff0, 0x0ff1, 0x0fef, 0x5122, 0x5123,
      0x0001, 0x0001, 0x1015, 0x101f, 0x103c, 0x51aa, 0x51ac, 0x0001,
      0x5257, 0x5259, 0x525a, 0x0001, 0x0001, 0x0001, 0x52a9, 0x52aa,
      0x1185, 0x123f, 0x5398, 0x5399, 0x1242, 0x1240, 0x539a, 0x539b,
      0x1246, 0x1248, 0x539c, 0x1245, 0x53a3, 0x5480, 0x1346, 0x5481,
      0x5482, 0x5483, 0x1348, 0x5484, 0x5485, 0x5486, 0x548b, 0x5488,
      0x13a9, 0x54c2, 0x0001, 0x0001, 0x13fe, 0x1482, 0x5590, 0x5591,
      0x14c9, 0x0001, 0x574c, 0x574d, 0x574e, 0x574f, 0x5750, 0x1614,
      0x5736, 0x1617, 0x161a, 0x1619, 0x1618, 0x5737, 0x161c, 0x5738,
      0x5739, 0x573a, 0x573b, 0x573c, 0x573d, 0x5741, 0x5743, 0x5742,
      0x1658, 0x5852, 0x5853, 0x5854, 0x0001, 0x5856, 0x16d4, 0x5857,
      0x5858, 0x16de, 0x5859, 0x585a, 0x585b, 0x585c, 0x16da, 0x585d,
      0x16d3, 0x0001, 0x5862, 0x16e2, 0x5864, 0x5865, 0x0001, 0x58f2,
      0x175d, 0x176b, 0x1762, 0x58f3, 0x58f9, 0x0001, 0x0001, 0x598f,
      0x5990, 0x5991, 0x1841, 0x5992, 0x5993, 0x5994, 0x5995, 0x5996,
      0x1843, 0x5997, 0x5998, 0x5999, 0x183d, 0x0001, 0x0001, 0x599f,
      0x0001, 0x599d, 0x0001, 0x0001, 0x1888, 0x59ed, 0x59ee, 0x59ef,
      0x18d6, 0x18d8, 0x0001, 0x0001, 0x1944, 0x194d, 0x1946, 0x5a92,
      0x5a93, 0x5a94, 0x5a95, 0x5a96, 0x5a97, 0x1963, 0x194c, 0x1945,
      0x5a98, 0x193f, 0x19a4, 0x19a5, 0x5af4, 0x0001, 0x5b8e, 0x1a7e,
      0x5b9a, 0x5b9b, 0x5bc2, 0x5bc3, 0x5bc4, 0x1ab0, 0x1aac, 0x5d29,
      0x1b32, 0x5d2a, 0x5d2b, 0x1b2f, 0x5d2d, 0x1b2b, 0x1b33, 0x5d2e,
      0x5d2f, 0x1b30, 0x5d32, 0x5d15, 0x5d19, 0x5d06, 0x5d17, 0x5d28,
      0x5d16, 0x5ce0, 0x5d26, 0x0001, 0x5d12, 0x5d1f, 0x0001, 0x5d13,
      0x5d49, 0x1b9d, 0x5dea, 0x1bed, 0x5e30, 0x5e31, 0x5e32, 0x5e33,
      0x1c06, 0x1c0a, 0x5e4d, 0x1c2a, 0x1c36, 0x1c62, 0x1c64, 0x5e7b,
      0x1c61, 0x5e7d, 0x5e7e, 0x0001, 0x0001, 0x5e8a, 0x1c79, 0x0001,
      0x1c78, 0x1c87, 0x5eae, 0x5eaf, 0x5eb0, 0x1cc8, 0x1d04, 0x1d02,
      0x5ef0, 0x1d48, 0x1d47, 0x5f36, 0x5f37, 0x1d4a, 0x1d45, 0x5f38,
      0x1d41, 0x5f39, 0x5f3e, 0x1d7d, 0x5f71, 0x1d98, 0x5f81, 0x1d99,
      0x1daa, 0x1db3, 0x1dbc, 0x5f93, 0x5f94, 0x5fc6, 0x5fc7, 0x5fc8,
      0x5fc9, 0x1ddb, 0x5fca, 0x5fcb, 0x5fcd, 0x0001, 0x0001, 0x5fc2,
      0x5fc5, 0x1e1c, 0x1e20, 0x6054, 0x6055, 0x6056, 0x6057, 0x6058,
      0x6059, 0x605a, 0x605b, 0x1e22, 0x605c, 0x605d, 0x605f, 0x0001,
      0x60d1, 0x1e65, 0x60ec, 0x60f5, 0x60f6, 0x1eac, 0x60fd, 0x1eb3,
      0x60fe, 0x60ff, 0x6100, 0x6110, 0x1ec6, 0x412a, 0x412b, 0x01f1,
      0x0219, 0x0001, 0x42ed, 0x42ee, 0x42ea, 0x42eb, 0x42ec, 0x0392,
      0x0449, 0x4410, 0x4411, 0x4425, 0x452f, 0x0518, 0x4530, 0x464b,
      0x0658, 0x46ec, 0x47d6, 0x48fa, 0x48fd, 0x48fe, 0x48ff, 0x4900,
      0x48f6, 0x492e, 0x4945, 0x09ab, 0x0001, 0x4ba9, 0x4ba0, 0x4ba1,
      0x4ba2, 0x4ba3, 0x4ba5, 0x0b71, 0x0b6e, 0x4ba7, 0x4ba8, 0x0001,
      0x0001, 0x0b70, 0x0b99, 0x4beb, 0x0001, 0x4dea, 0x0d96, 0x0d8e,
      0x4deb, 0x4dee, 0x0d91, 0x4def, 0x0d92, 0x4df0, 0x4df3, 0x4df2,
      0x0001, 0x0001, 0x4f2e, 0x0e20, 0x4f30, 0x0001, 0x4f7b, 0x4f7c,
      0x4f7d, 0x4f7e, 0x4f7f, 0x50ab, 0x50ad, 0x0001, 0x0001, 0x0f55,
      0x5124, 0x51ae, 0x51af, 0x0001, 0x10a0, 0x525b, 0x525c, 0x0001,
      0x525d, 0x0001, 0x525f, 0x113a, 0x52ef, 0x1188, 0x53a6, 0x53a7,
      0x53a8, 0x53a9, 0x124e, 0x53f3, 0x53f4, 0x548c, 0x548d, 0x548e,
      0x548f, 0x5490, 0x1350, 0x5491, 0x5492, 0x5493, 0x0001, 0x1374,
      0x54a2, 0x1391, 0x1395, 0x54c4, 0x13ca, 0x13cb, 0x5512, 0x5592,
      0x5593, 0x14c8, 0x55c0, 0x55c2, 0x55bf, 0x5754, 0x5755, 0x5756,
      0x5757, 0x5758, 0x5759, 0x1623, 0x575b, 0x575c, 0x5770, 0x575d,
      0x575e, 0x1626, 0x575f, 0x1624, 0x5760, 0x576d, 0x0001, 0x5762,
      0x5763, 0x0001, 0x5867, 0x5868, 0x16e0, 0x16df, 0x5869, 0x586a,
      0x586b, 0x586c, 0x16e4, 0x586d, 0x586e, 0x16e1, 0x0001, 0x0001,
      0x58fa, 0x1761, 0x1765, 0x58fb, 0x58fc, 0x1763, 0x58fd, 0x1766,
      0x0001, 0x177c, 0x178c, 0x591c, 0x17a4, 0x59a3, 0x59a4, 0x59a5,
      0x59a7, 0x59a8, 0x184c, 0x184b, 0x59a9, 0x59aa, 0x59ab, 0x0001,
      0x184a, 0x59a2, 0x59d0, 0x59e0, 0x59e1, 0x59f0, 0x5a10, 0x18dc,
      0x18e6, 0x5a48, 0x5a49, 0x5a4a, 0x5a4b, 0x194f, 0x5a9d, 0x5a9e,
      0x5a9f, 0x1947, 0x5aa0, 0x5abb, 0x19ab, 0x5af5, 0x19aa, 0x5af7,
      0x5af8, 0x5b02, 0x5b9c, 0x1a7d, 0x5bc6, 0x5bc7, 0x1b42, 0x5d4f,
      0x5d50, 0x5d51, 0x5d52, 0x1b45, 0x1b4b, 0x5d53, 0x5d54, 0x5d55,
      0x5d56, 0x1b46, 0x5d57, 0x5d44, 0x5d4a, 0x5d43, 0x5d3a, 0x5d39,
      0x5d59, 0x5d5f, 0x0001, 0x5d5e, 0x5dcf, 0x1b99, 0x1b9f, 0x5deb,
      0x5e35, 0x5e51, 0x5e52, 0x5e4f, 0x1c3d, 0x5e50, 0x5e7f, 0x5e80,
      0x1c66, 0x1c77, 0x1c7b, 0x5e8b, 0x1cb9, 0x1cb6, 0x5eb2, 0x5eb3,
      0x1cc9, 0x1cd0, 0x1ccb, 0x5ec8, 0x1d06, 0x5ef5, 0x5ef6, 0x5f08,
      0x5f05, 0x5f40, 0x5f41, 0x5f42, 0x5f43, 0x1d4f, 0x5f44, 0x5f45,
      0x1d4d, 0x1d50, 0x1d4e, 0x5f46, 0x5f47, 0x0001, 0x5f68, 0x1d9a,
      0x5f85, 0x1da6, 0x5f86, 0x1db4, 0x5fd7, 0x1de0, 0x5fd8, 0x5fd9,
      0x1de1, 0x5fdb, 0x1dde, 0x5fdc, 0x5fdd, 0x1dd6, 0x5fde, 0x0001,
      0x0001, 0x0001, 0x5fd3, 0x0001, 0x5fe0, 0x6065, 0x6066, 0x1e35,
      0x6067, 0x6068, 0x6069, 0x606a, 0x606b, 0x606c, 0x606d, 0x606e,
      0x6071, 0x6072, 0x6073, 0x6074, 0x1e24, 0x1e27, 0x6075, 0x6076,
      0x6077, 0x6078, 0x6079, 0x607a, 0x6070, 0x0001, 0x0001, 0x60d2,
      0x1e67, 0x60e5, 0x1e9a, 0x6101, 0x610b, 0x1ebc, 0x6111, 0x6112,
      0x1ec7, 0x6113, 0x41b4, 0x038f, 0x42ef, 0x0394, 0x0001, 0x051c,
      0x4650, 0x4651, 0x46ae, 0x46af, 0x46ed, 0x46ee, 0x47d7, 0x4904,
      0x0947, 0x4905, 0x4906, 0x09aa, 0x0a0a, 0x49d2, 0x49d3, 0x0b76,
      0x4bae, 0x0b73, 0x4bb0, 0x4bb1, 0x0b72, 0x0001, 0x0001, 0x0d93,
      0x0d9c, 0x4df6, 0x4df7, 0x4df8, 0x4df9, 0x4dfa, 0x4dfb, 0x4dfc,
      0x0d9e, 0x0d9d, 0x4dfd, 0x4e00, 0x4f2f, 0x4dfe, 0x0001, 0x0e22,
      0x4f3a, 0x0e67, 0x4fd5, 0x4fd6, 0x50ac, 0x1018, 0x1017, 0x513e,
      0x1039, 0x51b1, 0x51b2, 0x51b3, 0x108c, 0x51c0, 0x5261, 0x5262,
      0x10fa, 0x5263, 0x0001, 0x5264, 0x52ad, 0x52f2, 0x52f3, 0x118b,
      0x532d, 0x53ac, 0x53ad, 0x1254, 0x53b0, 0x53ae, 0x0001, 0x1354,
      0x1359, 0x1356, 0x5495, 0x54c6, 0x13cc, 0x5513, 0x5595, 0x1481,
      0x14a4, 0x14ca, 0x163d, 0x1631, 0x576e, 0x1630, 0x576f, 0x163a,
      0x5771, 0x1632, 0x5772, 0x1633, 0x5773, 0x5776, 0x5873, 0x5874,
      0x5875, 0x5876, 0x5877, 0x16e7, 0x5900, 0x1769, 0x0001, 0x592c,
      0x59ac, 0x59ad, 0x59ae, 0x59af, 0x59b3, 0x59b2, 0x59b0, 0x0001,
      0x5a4c, 0x5aa1, 0x5aa2, 0x1952, 0x5afb, 0x19ac, 0x5af9, 0x19a6,
      0x19ad, 0x5afa, 0x5b49, 0x1a80, 0x5b9d, 0x5bc9, 0x1ab3, 0x1ab2,
      0x5bca, 0x5d7c, 0x1b4a, 0x5d7d, 0x5d7e, 0x5d7f, 0x5d80, 0x5d81,
      0x5d82, 0x5d83, 0x5d84, 0x1b4d, 0x5d85, 0x1b49, 0x5d86, 0x5d87,
      0x5d88, 0x5d89, 0x5d61, 0x0001, 0x5d72, 0x5d62, 0x5d75, 0x0001,
      0x5d77, 0x0001, 0x0001, 0x5d70, 0x5d79, 0x5d6e, 0x5d67, 0x1ba2,
      0x1ba0, 0x5dec, 0x1c34, 0x5e53, 0x1c68, 0x5e81, 0x5e94, 0x5e95,
      0x5eb4, 0x1cba, 0x5eb6, 0x5eb7, 0x5ec9, 0x5eca, 0x1d0b, 0x1d0a,
      0x5ef7, 0x1d09, 0x1d08, 0x0001, 0x5f48, 0x5f49, 0x5f4a, 0x5f4b,
      0x5f4c, 0x1d53, 0x5f4d, 0x1d57, 0x1d55, 0x5f4e, 0x5f69, 0x5f6a,
      0x1d80, 0x1d9c, 0x1d9d, 0x1d9e, 0x5fe3, 0x1de6, 0x5fe4, 0x5fe5,
      0x5fe6, 0x5fe7, 0x5fe8, 0x5feb, 0x5fe9, 0x0001, 0x5fe1, 0x0001,
      0x5fec, 0x607b, 0x607c, 0x607d, 0x607e, 0x607f, 0x1e2c, 0x6080,
      0x6081, 0x6082, 0x6083, 0x6084, 0x6085, 0x6086, 0x6087, 0x1e2d,
      0x6088, 0x6089, 0x608a, 0x608b, 0x1e34, 0x1e2e, 0x1e2b, 0x0001,
      0x608d, 0x60d3, 0x1e6d, 0x1e6c, 0x1e8f, 0x60ed, 0x1e90, 0x0001,
      0x6102, 0x6103, 0x6114, 0x1eca, 0x6115, 0x6116, 0x0001, 0x0001,
      0x412f, 0x412e, 0x4195, 0x4194, 0x42f2, 0x42f3, 0x42f4, 0x4539,
      0x453a, 0x060d, 0x4654, 0x0698, 0x07f9, 0x4908, 0x4bb6, 0x4bb7,
      0x0b7e, 0x4baf, 0x0001, 0x0da0, 0x4e08, 0x4e09, 0x4e0a, 0x0da1,
      0x4e07, 0x4e0c, 0x0e26, 0x0e25, 0x4f3f, 0x4fd7, 0x0f53, 0x5126,
      0x51b4, 0x526a, 0x1100, 0x5267, 0x1259, 0x125a, 0x1293, 0x1362,
      0x135b, 0x135c, 0x5498, 0x135a, 0x135f, 0x1376, 0x54c7, 0x13eb,
      0x1484, 0x577c, 0x5764, 0x577e, 0x577f, 0x5780, 0x5781, 0x5782,
      0x1642, 0x5783, 0x5784, 0x5785, 0x163e, 0x163c, 0x5786, 0x5878,
      0x5879, 0x16e8, 0x587a, 0x587b, 0x16e9, 0x587c, 0x16fd, 0x176f,
      0x5902, 0x5903, 0x176e, 0x592d, 0x59b5, 0x185a, 0x59b6, 0x59b7,
      0x59b8, 0x18df, 0x18e1, 0x18fc, 0x5aa4, 0x0001, 0x19ae, 0x5afc,
      0x5afd, 0x1a81, 0x5b9f, 0x5b9e, 0x5bcc, 0x5d8d, 0x1b56, 0x1b52,
      0x1b54, 0x5d93, 0x5d8a, 0x0001, 0x0001, 0x5d97, 0x5d9e, 0x5d95,
      0x5d90, 0x1ba5, 0x1ba4, 0x5dee, 0x5e58, 0x5e57, 0x5e82, 0x5e8c,
      0x5eb8, 0x5ece, 0x1cce, 0x1ccf, 0x5efa, 0x5ef9, 0x5f52, 0x5f53,
      0x5f54, 0x1d4c, 0x1d5b, 0x1d5a, 0x5f55, 0x5f50, 0x5f6b, 0x5f87,
      0x5f88, 0x1d9f, 0x5f89, 0x5f8f, 0x5f99, 0x5ff3, 0x5ff4, 0x1dec,
      0x5ff5, 0x1ded, 0x5ff6, 0x5ff7, 0x0001, 0x5fee, 0x608e, 0x608f,
      0x1e3a, 0x1e3b, 0x1e36, 0x6090, 0x6091, 0x6092, 0x6093, 0x1e3e,
      0x1e39, 0x1e32, 0x6094, 0x1e38, 0x1e33, 0x1e37, 0x6095, 0x1e30,
      0x6096, 0x6098, 0x0001, 0x6099, 0x0001, 0x1e5b, 0x60d5, 0x60ee,
      0x1e94, 0x60ef, 0x1eae, 0x60f9, 0x1eaf, 0x6104, 0x1ec1, 0x6118,
      0x6119, 0x6126, 0x0054, 0x42f5, 0x0390, 0x42f6, 0x0001, 0x453b,
      0x051d, 0x4656, 0x4657, 0x46b1, 0x4909, 0x490a, 0x490b, 0x094c,
      0x4bba, 0x4bbb, 0x4bbc, 0x0be2, 0x0001, 0x0001, 0x4e0f, 0x4e12,
      0x4f42, 0x0e27, 0x4f81, 0x4fd8, 0x0f3a, 0x0001, 0x0001, 0x50b9,
      0x0ff6, 0x1016, 0x526b, 0x113d, 0x118c, 0x52f5, 0x53b2, 0x125f,
      0x125c, 0x125e, 0x125d, 0x1294, 0x1296, 0x1363, 0x1377, 0x1396,
      0x5596, 0x14cd, 0x5792, 0x5793, 0x5795, 0x5796, 0x5799, 0x578b,
      0x587d, 0x16ee, 0x587f, 0x5880, 0x5881, 0x5905, 0x1790, 0x0001,
      0x592e, 0x185d, 0x59bb, 0x59bc, 0x59bd, 0x59c3, 0x59c0, 0x5a14,
      0x1950, 0x195d, 0x195e, 0x195b, 0x1959, 0x5aa5, 0x5aa6, 0x5afe,
      0x19b1, 0x1a7f, 0x1b59, 0x5da4, 0x1b58, 0x5da5, 0x5da9, 0x5da6,
      0x5da3, 0x5d9f, 0x5da2, 0x5da0, 0x5e59, 0x5e8d, 0x5eb9, 0x5eba,
      0x5ecf, 0x1d0e, 0x5efd, 0x5f57, 0x5f58, 0x1d61, 0x1d65, 0x5f59,
      0x1d5e, 0x1d60, 0x5f5a, 0x1d67, 0x0001, 0x5f6c, 0x1da1, 0x5f8d,
      0x1db5, 0x5f9a, 0x0001, 0x5ff8, 0x5ff9, 0x5ffa, 0x1df2, 0x5ffe,
      0x5fff, 0x6000, 0x6001, 0x1df0, 0x5ffd, 0x1def, 0x0001, 0x0001,
      0x609c, 0x609d, 0x609e, 0x609f, 0x60a0, 0x60a1, 0x60a2, 0x60a3,
      0x1e53, 0x1e45, 0x1e43, 0x60a4, 0x1e42, 0x60a5, 0x1e41, 0x609a,
      0x60e1, 0x60f0, 0x6105, 0x6107, 0x6108, 0x610c, 0x611a, 0x1ed8,
      0x1edd, 0x4131, 0x4196, 0x4419, 0x441a, 0x4438, 0x453d, 0x0610,
      0x46b2, 0x46ca, 0x07fc, 0x47da, 0x47db, 0x0952, 0x0001, 0x4932,
      0x49d8, 0x4bbe, 0x0b7c, 0x0001, 0x4bf3, 0x4e13, 0x4e18, 0x4f46,
      0x4fd9, 0x0eb0, 0x4fda, 0x0ffc, 0x51b5, 0x1265, 0x53b7, 0x5499,
      0x55c3, 0x579b, 0x1641, 0x579c, 0x1645, 0x579d, 0x579e, 0x579f,
      0x5882, 0x16f1, 0x5883, 0x5884, 0x1774, 0x1771, 0x5907, 0x592f,
      0x1860, 0x1861, 0x1862, 0x0001, 0x59d1, 0x5a15, 0x5aa7, 0x19b2,
      0x5aff, 0x1ab7, 0x1b60, 0x1b5d, 0x0001, 0x5da7, 0x0001, 0x5e83,
      0x5e84, 0x1c88, 0x1d63, 0x1d6a, 0x5f8a, 0x1da3, 0x5f8b, 0x0001,
      0x1df5, 0x6007, 0x6008, 0x6009, 0x600a, 0x600b, 0x6005, 0x0001,
      0x1dfa, 0x60a6, 0x60a7, 0x1e4a, 0x60a8, 0x60a9, 0x1e4c, 0x60ae,
      0x60af, 0x60b0, 0x60b1, 0x1e49, 0x1e46, 0x60b2, 0x60b3, 0x60aa,
      0x1e4b, 0x0001, 0x0001, 0x60ab, 0x60e6, 0x1e85, 0x60f1, 0x60f2,
      0x60f7, 0x60fa, 0x6109, 0x1eb7, 0x610a, 0x610d, 0x1ec2, 0x611b,
      0x611c, 0x1ed0, 0x611d, 0x03a1, 0x0001, 0x453e, 0x05bb, 0x4910,
      0x49d6, 0x49d7, 0x0001, 0x4e1a, 0x4e19, 0x0da5, 0x0d89, 0x4f48,
      0x0f35, 0x50c1, 0x51b6, 0x526e, 0x52b1, 0x52b2, 0x0001, 0x549a,
      0x54af, 0x14cb, 0x57a0, 0x5886, 0x5887, 0x5888, 0x588f, 0x59c7,
      0x59c8, 0x5aa8, 0x5aa9, 0x5aaa, 0x5aab, 0x5bce, 0x1ab5, 0x1aba,
      0x5db6, 0x5db3, 0x5db7, 0x5e37, 0x1c3a, 0x5e5b, 0x5e5c, 0x5e85,
      0x5e8e, 0x5f5c, 0x5f6d, 0x0001, 0x1df8, 0x600e, 0x600f, 0x6010,
      0x6011, 0x1df7, 0x60b4, 0x60b5, 0x1e4d, 0x60b6, 0x60b7, 0x60b8,
      0x60b9, 0x60ba, 0x60bb, 0x60bc, 0x1e4f, 0x60bd, 0x60d7, 0x0001,
      0x0001, 0x611e, 0x611f, 0x1ed2, 0x42fb, 0x4912, 0x0995, 0x4bc0,
      0x4bc3, 0x4bc1, 0x4bc2, 0x0001, 0x0001, 0x4f82, 0x51b7, 0x108f,
      0x526f, 0x1266, 0x1267, 0x1297, 0x1367, 0x135d, 0x1366, 0x549c,
      0x1486, 0x5598, 0x1647, 0x57a1, 0x57a2, 0x5908, 0x5909, 0x1773,
      0x0001, 0x17a6, 0x59c9, 0x1866, 0x5aac, 0x5aad, 0x5aae, 0x5dba,
      0x5dbb, 0x1b64, 0x1b68, 0x0001, 0x1c3c, 0x5ebd, 0x1d12, 0x1dfc,
      0x6017, 0x6014, 0x60bf, 0x60c0, 0x60c1, 0x60c2, 0x60c4, 0x1e4e,
      0x60d8, 0x60f3, 0x1ea2, 0x610e, 0x6120, 0x6121, 0x6122, 0x6123,
      0x4313, 0x4e1b, 0x126a, 0x5889, 0x5a4f, 0x5ab0, 0x5bcf, 0x5dbf,
      0x5dbc, 0x5dc0, 0x1b66, 0x5f5d, 0x6018, 0x6019, 0x4f4b, 0x601a,
      0x0001, 0x60c3, 0x60c5, 0x1e95, 0x60f8, 0x6129, 0x4e1d, 0x4e1c,
      0x53fa, 0x57aa, 0x588a, 0x588b, 0x588c, 0x186a, 0x59f1, 0x1960,
      0x5ac0, 0x5e5e, 0x5ebe, 0x1cc2, 0x5ed0, 0x0001, 0x0001, 0x1d6e,
      0x5f5f, 0x5f60, 0x5f8c, 0x1e50, 0x60c6, 0x0001, 0x07fd, 0x0001,
      0x0001, 0x57a3, 0x5ab1, 0x5dc3, 0x5dc4, 0x5dc5, 0x1d70, 0x5f62,
      0x1dac, 0x60c7, 0x57a4, 0x5dc9, 0x601e, 0x60e3, 0x5128, 0x5f63,
      0x601f, 0x1e55, 0x0da7, 0x4e1e, 0x1e72, 0x6124, 0x186b, 0x610f,
      0x0001, 0x9f08, 0x0001 };

   static unsigned short int TEL_2_TCA_Tab[16528] = {
      0x8000, 0x0000, 0x0002, 0x0003, 0x0016, 0x0014, 0x0017, 0x0015,
      0x0041, 0x0040, 0x003f, 0x009f, 0x009e, 0x009d, 0x009c, 0x011b,
      0x011c, 0x02d5, 0x8000, 0x8000, 0x8000, 0x0018, 0x0042, 0x0043,
      0x153a, 0x01c2, 0x8000, 0x8000, 0x8000, 0x0019, 0x0044, 0x00a1,
      0x8000, 0x8000, 0x1519, 0x0004, 0x001b, 0x0045, 0x00a2, 0x00a4,
      0x00a3, 0x02d6, 0x05de, 0x8000, 0x0001, 0x151a, 0x0005, 0x001e,
      0x001d, 0x011f, 0x02d7, 0x07a8, 0x0b6b, 0x8000, 0x8000, 0x0006,
      0x0047, 0x02d8, 0x8000, 0x0007, 0x001f, 0x0048, 0x004a, 0x004b,
      0x0049, 0x0120, 0x8000, 0x02d9, 0x02da, 0x0450, 0x8000, 0x8000,
      0x0020, 0x004c, 0x0121, 0x0123, 0x0122, 0x01c3, 0x02db, 0x02dc,
      0x0451, 0x0452, 0x05df, 0x210f, 0x3122, 0x8000, 0x0008, 0x004e,
      0x004d, 0x004f, 0x0055, 0x0050, 0x0051, 0x0053, 0x0054, 0x0052,
      0x1529, 0x152a, 0x00a7, 0x00a8, 0x00a9, 0x00aa, 0x00a6, 0x00ad,
      0x1540, 0x00ae, 0x153f, 0x00be, 0x00ab, 0x00ac, 0x00a5, 0x0130,
      0x012d, 0x0131, 0x1564, 0x012e, 0x1568, 0x012f, 0x0132, 0x0124,
      0x0133, 0x0125, 0x0127, 0x0134, 0x0129, 0x1561, 0x012c, 0x012a,
      0x012b, 0x0126, 0x01d9, 0x01cc, 0x01d8, 0x01c9, 0x01db, 0x01d1,
      0x01d0, 0x15d0, 0x01d4, 0x01cf, 0x01d2, 0x01d5, 0x01de, 0x01c4,
      0x01da, 0x01c5, 0x01cd, 0x01ce, 0x01d3, 0x01cb, 0x01c7, 0x01dc,
      0x15da, 0x01df, 0x01ca, 0x01d7, 0x01c8, 0x15d8, 0x02f0, 0x16a4,
      0x02ea, 0x16ae, 0x02dd, 0x02e0, 0x02e8, 0x16a7, 0x16b2, 0x02eb,
      0x02ed, 0x02e1, 0x02e6, 0x02e5, 0x02e9, 0x02e4, 0x02df, 0x02ee,
      0x02ef, 0x16b5, 0x02ec, 0x16ad, 0x02e3, 0x02de, 0x0468, 0x180d,
      0x1807, 0x0461, 0x0455, 0x0454, 0x045c, 0x0456, 0x0464, 0x045b,
      0x0463, 0x045f, 0x0466, 0x0459, 0x0462, 0x0458, 0x0460, 0x045d,
      0x0465, 0x1812, 0x045a, 0x045e, 0x0457, 0x0467, 0x8000, 0x0453,
      0x05f9, 0x19d4, 0x05f0, 0x19c9, 0x05e0, 0x19d3, 0x05e3, 0x05f3,
      0x05f8, 0x19cf, 0x05e6, 0x05ef, 0x05fc, 0x05fe, 0x05f5, 0x05e1,
      0x05e9, 0x07b9, 0x05ee, 0x05ed, 0x05e8, 0x05f7, 0x05f6, 0x05ec,
      0x19d7, 0x8000, 0x05eb, 0x05f4, 0x05e2, 0x05ea, 0x05e5, 0x05e4,
      0x05f2, 0x05e7, 0x05fb, 0x05fd, 0x05fa, 0x1beb, 0x07b3, 0x1bea,
      0x1bed, 0x07ad, 0x07ac, 0x07b0, 0x07b8, 0x07b4, 0x07af, 0x07ab,
      0x07b1, 0x1be3, 0x07b6, 0x07b5, 0x07b2, 0x1e62, 0x1e5c, 0x099a,
      0x0999, 0x0996, 0x0995, 0x0998, 0x1e66, 0x1bf5, 0x099b, 0x0997,
      0x099c, 0x1e5d, 0x8000, 0x0b72, 0x0b6c, 0x0b6e, 0x0b6f, 0x2116,
      0x0b6d, 0x0b73, 0x0b71, 0x2118, 0x0b70, 0x0b76, 0x211e, 0x2115,
      0x0d32, 0x0d34, 0x0d35, 0x23be, 0x23c1, 0x0d36, 0x0d33, 0x0d31,
      0x0d2e, 0x0d30, 0x07aa, 0x0d2d, 0x0d2b, 0x0d2f, 0x0d2c, 0x8000,
      0x0eb2, 0x0eb3, 0x0eb1, 0x262f, 0x0eb0, 0x0eb4, 0x0eaf, 0x262c,
      0x0eb5, 0x0eb6, 0x8000, 0x2631, 0x23c9, 0x2630, 0x262d, 0x103a,
      0x1037, 0x1039, 0x103b, 0x28ad, 0x1038, 0x2ae8, 0x1162, 0x1161,
      0x1164, 0x1322, 0x1415, 0x1469, 0x1468, 0x80ba, 0x0009, 0x0021,
      0x0057, 0x0056, 0x00b0, 0x00af, 0x0137, 0x0138, 0x0135, 0x0136,
      0x01e1, 0x01e0, 0x01e2, 0x02f1, 0x02f2, 0x02f3, 0x0469, 0x07bc,
      0x0d37, 0x80bb, 0x000a, 0x0058, 0x0139, 0x02f4, 0x8000, 0x8000,
      0x000b, 0x005b, 0x0059, 0x005a, 0x013a, 0x01e3, 0x02f6, 0x02f5,
      0x02f7, 0x05ff, 0x103c, 0x8000, 0x8000, 0x00b1, 0x00b2, 0x013b,
      0x15df, 0x19e0, 0x046b, 0x046a, 0x07bd, 0x8000, 0x8000, 0x005c,
      0x16bc, 0x046c, 0x0602, 0x0600, 0x0601, 0x103d, 0x8000, 0x8000,
      0x00b3, 0x013c, 0x8000, 0x1572, 0x01e4, 0x01e5, 0x8000, 0x02f8,
      0x8000, 0x19e2, 0x0605, 0x19e4, 0x8000, 0x19e1, 0x0606, 0x0604,
      0x0603, 0x8000, 0x8000, 0x8000, 0x0eb8, 0x103e, 0x8000, 0x000c,
      0x001a, 0x8000, 0x099e, 0x0d38, 0x07be, 0x8000, 0x151b, 0x005d,
      0x00b6, 0x00b4, 0x8000, 0x00b5, 0x02f9, 0x8000, 0x000d, 0x000e,
      0x0022, 0x005e, 0x005f, 0x0060, 0x00b7, 0x0140, 0x013e, 0x013f,
      0x0141, 0x013d, 0x01ea, 0x0438, 0x01e9, 0x01e7, 0x01e6, 0x8000,
      0x01e8, 0x0301, 0x02ff, 0x02fe, 0x16c0, 0x16c1, 0x16bf, 0x0300,
      0x02fc, 0x02fb, 0x8000, 0x02fd, 0x0472, 0x046e, 0x1819, 0x0473,
      0x181a, 0x046f, 0x02fa, 0x0470, 0x0608, 0x19e9, 0x19e6, 0x0609,
      0x0607, 0x8000, 0x060a, 0x060b, 0x09a2, 0x07bf, 0x1c02, 0x07c0,
      0x099f, 0x09a0, 0x09a1, 0x2123, 0x0b79, 0x0b77, 0x0d3a, 0x0d39,
      0x8000, 0x0eb9, 0x0eba, 0x0ebb, 0x0ebd, 0x2635, 0x0ebc, 0x103f,
      0x1040, 0x2e27, 0x8000, 0x8000, 0x000f, 0x00b9, 0x00b8, 0x0142,
      0x01ec, 0x01ed, 0x01eb, 0x01ee, 0x15e4, 0x8000, 0x0303, 0x0302,
      0x16c4, 0x0477, 0x0476, 0x8000, 0x0474, 0x0475, 0x19ed, 0x07c1,
      0x07c4, 0x1c03, 0x07c3, 0x07c2, 0x09a4, 0x09a3, 0x8000, 0x0b7a,
      0x0b7d, 0x0b7e, 0x0b7c, 0x0b7b, 0x23d0, 0x0ebe, 0x1041, 0x2636,
      0x1165, 0x2e28, 0x13b6, 0x8000, 0x8000, 0x0023, 0x0061, 0x0063,
      0x8000, 0x00ba, 0x0143, 0x16c5, 0x0478, 0x07c6, 0x07c5, 0x0062,
      0x0010, 0x0064, 0x00bc, 0x07c7, 0x8000, 0x151c, 0x1543, 0x00bd,
      0x1577, 0x0145, 0x0144, 0x01ef, 0x060c, 0x0b7f, 0x0d3b, 0x1c05,
      0x8000, 0x8000, 0x8000, 0x8000, 0x0065, 0x07ca, 0x07c8, 0x07c9,
      0x8000, 0x0011, 0x0024, 0x8000, 0x0068, 0x0067, 0x0066, 0x00c0,
      0x00bf, 0x0307, 0x0304, 0x0306, 0x0305, 0x0479, 0x09a6, 0x1578,
      0x0012, 0x0069, 0x00c2, 0x00c1, 0x15e7, 0x0308, 0x8000, 0x8000,
      0x152e, 0x8000, 0x00c3, 0x0146, 0x0147, 0x15e8, 0x8000, 0x01f1,
      0x0309, 0x030a, 0x8000, 0x047a, 0x00c4, 0x01f0, 0x8000, 0x060d,
      0x8000, 0x151d, 0x006a, 0x15e9, 0x8000, 0x16c9, 0x1822, 0x1821,
      0x047b, 0x060f, 0x060e, 0x8000, 0x09a7, 0x8000, 0x0d3c, 0x8000,
      0x0ebf, 0x8000, 0x8000, 0x8000, 0x152f, 0x00c5, 0x8000, 0x07cb,
      0x8000, 0x8000, 0x0013, 0x0025, 0x006c, 0x006b, 0x006d, 0x030d,
      0x030c, 0x030e, 0x8000, 0x047c, 0x0610, 0x28b2, 0x1276, 0x8000,
      0x0026, 0x00c7, 0x00d6, 0x00d1, 0x00cc, 0x00cb, 0x00d2, 0x00d0,
      0x00c9, 0x00d7, 0x00ca, 0x00d4, 0x00c6, 0x00d5, 0x00d3, 0x00c8,
      0x00cf, 0x8000, 0x00ce, 0x014d, 0x0153, 0x014f, 0x0152, 0x0148,
      0x014b, 0x014a, 0x0151, 0x0154, 0x0149, 0x014c, 0x0150, 0x8000,
      0x0156, 0x01fe, 0x01f2, 0x01f4, 0x020c, 0x0207, 0x01f6, 0x01ff,
      0x031b, 0x15ed, 0x020b, 0x01f3, 0x0204, 0x01fc, 0x01fb, 0x0205,
      0x0206, 0x0203, 0x0201, 0x0200, 0x0202, 0x0208, 0x01f5, 0x0209,
      0x01fd, 0x01fa, 0x01f9, 0x16ce, 0x0320, 0x16d6, 0x16dd, 0x0321,
      0x0318, 0x8000, 0x031c, 0x16d0, 0x030f, 0x0310, 0x031d, 0x0316,
      0x0315, 0x031a, 0x0323, 0x0314, 0x0317, 0x0319, 0x16cf, 0x031e,
      0x0324, 0x8000, 0x0322, 0x16d7, 0x1824, 0x8000, 0x1833, 0x1826,
      0x0491, 0x047f, 0x048d, 0x047d, 0x048c, 0x048e, 0x0484, 0x182a,
      0x0482, 0x1823, 0x0487, 0x047e, 0x0489, 0x0486, 0x048a, 0x182f,
      0x0485, 0x048b, 0x0481, 0x048f, 0x0492, 0x061d, 0x0616, 0x1a04,
      0x0621, 0x061b, 0x061c, 0x061f, 0x0617, 0x0619, 0x0615, 0x0624,
      0x19f8, 0x0613, 0x0618, 0x19fa, 0x061e, 0x0612, 0x19f6, 0x0611,
      0x19f9, 0x0625, 0x07dc, 0x07d9, 0x07d5, 0x07e0, 0x09b9, 0x07e1,
      0x07df, 0x07d0, 0x07cd, 0x07d7, 0x0869, 0x07d6, 0x07e2, 0x07dd,
      0x07d1, 0x1c0d, 0x1c09, 0x1c0b, 0x09a8, 0x09ab, 0x1e7a, 0x09a9,
      0x09af, 0x09b5, 0x0ac8, 0x8000, 0x09b3, 0x1e77, 0x09c0, 0x09ac,
      0x1e78, 0x1e76, 0x09b4, 0x1e6f, 0x09ae, 0x09c2, 0x09bb, 0x09b0,
      0x09ad, 0x0622, 0x09aa, 0x09bc, 0x09b1, 0x09bd, 0x09b7, 0x09bf,
      0x2126, 0x0b8d, 0x0b84, 0x0b86, 0x0b87, 0x0b82, 0x212e, 0x0b8b,
      0x2127, 0x0b85, 0x0b80, 0x0b88, 0x0b89, 0x09b2, 0x09b8, 0x1e7d,
      0x09c1, 0x1e72, 0x0b8e, 0x0b90, 0x2132, 0x23e1, 0x8000, 0x0d43,
      0x0d4a, 0x0d44, 0x23d9, 0x0d4b, 0x8000, 0x23d7, 0x0d48, 0x0d40,
      0x0ec7, 0x23e2, 0x23dd, 0x0d46, 0x0d42, 0x0d47, 0x0d41, 0x0d3d,
      0x2645, 0x0ec6, 0x0d4c, 0x0ecd, 0x0ecc, 0x0ec3, 0x0ec5, 0x263b,
      0x0ecb, 0x8000, 0x0ec2, 0x0ec1, 0x0ec4, 0x263e, 0x263a, 0x8000,
      0x0ec8, 0x104e, 0x8000, 0x1046, 0x1049, 0x1045, 0x1048, 0x1043,
      0x104d, 0x104c, 0x28ba, 0x0eca, 0x104f, 0x104a, 0x28b7, 0x1047,
      0x104b, 0x1167, 0x1169, 0x116a, 0x116b, 0x2cc1, 0x2cbf, 0x2f73,
      0x3124, 0x1323, 0x2e2f, 0x1278, 0x2f75, 0x13b9, 0x1324, 0x13b8,
      0x13ba, 0x1418, 0x1417, 0x1419, 0x13b7, 0x146c, 0x146b, 0x146a,
      0x14cc, 0x322b, 0x00d8, 0x1522, 0x0158, 0x00da, 0x00d9, 0x020e,
      0x0157, 0x0210, 0x020f, 0x0211, 0x16df, 0x16e0, 0x0325, 0x0493,
      0x0626, 0x0627, 0x07e3, 0x07e5, 0x07e4, 0x8000, 0x1c20, 0x1a08,
      0x15fa, 0x09c3, 0x0b91, 0x0b92, 0x0d4e, 0x0d4d, 0x28bd, 0x8000,
      0x0027, 0x015c, 0x0160, 0x015e, 0x015d, 0x015f, 0x015b, 0x021b,
      0x0214, 0x16ea, 0x8000, 0x0216, 0x0212, 0x0215, 0x0217, 0x021a,
      0x0219, 0x0213, 0x8000, 0x15ff, 0x032a, 0x032c, 0x032b, 0x16e3,
      0x16e9, 0x0327, 0x032d, 0x0494, 0x0328, 0x16e4, 0x16e6, 0x16eb,
      0x0495, 0x049b, 0x183e, 0x0496, 0x0498, 0x0497, 0x1839, 0x183b,
      0x183f, 0x1845, 0x062b, 0x062a, 0x0499, 0x1a0c, 0x0628, 0x1c2e,
      0x07e6, 0x07ea, 0x8000, 0x1c28, 0x1c24, 0x07ef, 0x07f0, 0x07ec,
      0x07ed, 0x07e7, 0x07e9, 0x07e8, 0x07eb, 0x1c26, 0x1e8d, 0x1c2b,
      0x8000, 0x1e88, 0x1e89, 0x09ca, 0x09cc, 0x09c7, 0x09c5, 0x09c4,
      0x09c9, 0x1a0a, 0x09c6, 0x07ee, 0x1e8a, 0x09c8, 0x8000, 0x2142,
      0x0b9c, 0x0b9f, 0x0b9a, 0x0b94, 0x0b98, 0x0d52, 0x0b97, 0x0b96,
      0x0b95, 0x0b93, 0x0b99, 0x0b9d, 0x2141, 0x2140, 0x0b9e, 0x2146,
      0x213e, 0x0d4f, 0x0d54, 0x23e4, 0x0d50, 0x23e9, 0x0ece, 0x23e8,
      0x0d51, 0x0d55, 0x23e3, 0x0d53, 0x8000, 0x1e8e, 0x23e5, 0x0ed2,
      0x264c, 0x0ed0, 0x0ecf, 0x1035, 0x0ed4, 0x0ed3, 0x28c3, 0x0ed1,
      0x264e, 0x264b, 0x0ed5, 0x1051, 0x1050, 0x1053, 0x1052, 0x28bf,
      0x116f, 0x116e, 0x116d, 0x116c, 0x2af6, 0x127a, 0x1279, 0x1325,
      0x1326, 0x2e30, 0x8000, 0x13bb, 0x14cd, 0x015a, 0x0028, 0x006e,
      0x021c, 0x09cd, 0x09ce, 0x8000, 0x0d57, 0x214e, 0x8000, 0x8000,
      0x1603, 0x8000, 0x8000, 0x062d, 0x8000, 0x141a, 0x8000, 0x0029,
      0x00db, 0x0161, 0x0162, 0x032e, 0x07f1, 0x0d59, 0x0d5a, 0x0d58,
      0x8000, 0x002a, 0x0072, 0x006f, 0x0071, 0x0070, 0x1532, 0x00dc,
      0x00dd, 0x1549, 0x0163, 0x0164, 0x021d, 0x0332, 0x0330, 0x0331,
      0x032f, 0x049f, 0x049e, 0x04a0, 0x049d, 0x0333, 0x049c, 0x1849,
      0x062e, 0x0630, 0x8000, 0x062f, 0x09cf, 0x1e9b, 0x07f2, 0x0ba0,
      0x0d5c, 0x0d5b, 0x8000, 0x0ed6, 0x1054, 0x1604, 0x002b, 0x00de,
      0x00df, 0x0166, 0x0168, 0x016b, 0x016a, 0x0167, 0x0165, 0x0228,
      0x021f, 0x0225, 0x0227, 0x0224, 0x1608, 0x0223, 0x021e, 0x0222,
      0x0226, 0x0229, 0x0220, 0x0340, 0x0337, 0x0335, 0x0334, 0x033a,
      0x033f, 0x033d, 0x033c, 0x033b, 0x0339, 0x0342, 0x033e, 0x16f6,
      0x0338, 0x0336, 0x04a9, 0x04a1, 0x184f, 0x184b, 0x8000, 0x04a4,
      0x1854, 0x04a7, 0x04a5, 0x04aa, 0x04a8, 0x0637, 0x0343, 0x04ac,
      0x04a6, 0x04a3, 0x04ab, 0x063d, 0x184c, 0x184e, 0x063c, 0x0631,
      0x0632, 0x0635, 0x0633, 0x0634, 0x0638, 0x0639, 0x063b, 0x063a,
      0x0636, 0x07f9, 0x8000, 0x07f3, 0x07f4, 0x07fc, 0x07f5, 0x07fd,
      0x1c44, 0x07fb, 0x07fa, 0x8000, 0x07f6, 0x07f7, 0x1c49, 0x1c48,
      0x1c4a, 0x1c46, 0x09d0, 0x1e9f, 0x09d3, 0x09d1, 0x09d4, 0x1e9e,
      0x1ea0, 0x09d5, 0x1eab, 0x1ea7, 0x8000, 0x0ba7, 0x2155, 0x2153,
      0x0ba6, 0x0ba5, 0x0ba4, 0x2157, 0x0ba1, 0x0ba8, 0x2150, 0x0ba2,
      0x2151, 0x0ba3, 0x0ba9, 0x2152, 0x0d61, 0x0d60, 0x2402, 0x0d5d,
      0x0d63, 0x0d5e, 0x0d5f, 0x23fc, 0x0d62, 0x23fd, 0x23f8, 0x23ff,
      0x8000, 0x1e9c, 0x0edc, 0x0ed7, 0x0ed9, 0x0edb, 0x265a, 0x28ce,
      0x28c7, 0x28c8, 0x28c9, 0x1056, 0x1171, 0x1172, 0x2afa, 0x2afc,
      0x2e35, 0x1170, 0x127b, 0x13bc, 0x2f77, 0x3128, 0x0221, 0x002c,
      0x002d, 0x0073, 0x00e0, 0x1588, 0x016c, 0x016d, 0x022c, 0x022d,
      0x022b, 0x022a, 0x0344, 0x0346, 0x0345, 0x1704, 0x04ad, 0x063e,
      0x07fe, 0x09d7, 0x09d6, 0x1057, 0x1173, 0x8000, 0x146d, 0x0d64,
      0x8000, 0x154a, 0x00e1, 0x154b, 0x8000, 0x0170, 0x016e, 0x016f,
      0x0171, 0x022f, 0x022e, 0x0230, 0x1705, 0x1706, 0x0347, 0x0349,
      0x034b, 0x0348, 0x034c, 0x034a, 0x04b1, 0x04ae, 0x04b0, 0x04b2,
      0x04af, 0x1a27, 0x0644, 0x0640, 0x0641, 0x0643, 0x0645, 0x0642,
      0x0647, 0x0646, 0x8000, 0x1c66, 0x0803, 0x1c65, 0x0802, 0x8000,
      0x0801, 0x0800, 0x0804, 0x07ff, 0x0d66, 0x09d9, 0x09db, 0x09d8,
      0x09da, 0x1eba, 0x2163, 0x2164, 0x1ebd, 0x0d65, 0x0d6d, 0x0d67,
      0x0d6b, 0x0d6c, 0x0d68, 0x0d69, 0x0d6a, 0x240b, 0x2165, 0x0edf,
      0x0ee0, 0x0ede, 0x0edd, 0x1058, 0x1328, 0x13bf, 0x1a25, 0x002f,
      0x0172, 0x04b3, 0x0648, 0x8000, 0x0807, 0x0806, 0x0805, 0x09dc,
      0x09dd, 0x0d6e, 0x1059, 0x8000, 0x0030, 0x0074, 0x8000, 0x0173,
      0x034d, 0x8000, 0x2166, 0x8000, 0x0031, 0x0075, 0x1611, 0x1612,
      0x09de, 0x1ebf, 0x8000, 0x0231, 0x8000, 0x0032, 0x0046, 0x0076,
      0x154d, 0x00e2, 0x0235, 0x0234, 0x0232, 0x0233, 0x034f, 0x0350,
      0x034e, 0x8000, 0x04b7, 0x04b6, 0x04b4, 0x064b, 0x0649, 0x064a,
      0x04b5, 0x080a, 0x0808, 0x0d6f, 0x240d, 0x0ee1, 0x0ee2, 0x2662,
      0x1175, 0x2cc4, 0x141b, 0x322e, 0x8000, 0x0021, 0x0077, 0x0357,
      0x0033, 0x0174, 0x158c, 0x158b, 0x0239, 0x0236, 0x0237, 0x0238,
      0x8000, 0x0352, 0x1713, 0x170e, 0x0354, 0x0355, 0x0356, 0x170c,
      0x0351, 0x0353, 0x1711, 0x04b9, 0x04b8, 0x1865, 0x0650, 0x064c,
      0x8000, 0x0652, 0x064e, 0x064d, 0x186d, 0x0654, 0x1a31, 0x8000,
      0x080b, 0x080d, 0x8000, 0x0811, 0x0813, 0x080f, 0x0814, 0x0817,
      0x080e, 0x0810, 0x0812, 0x1c6b, 0x0816, 0x1c70, 0x09e2, 0x1ec5,
      0x1ec4, 0x1ec2, 0x216a, 0x09df, 0x1ed6, 0x1ec8, 0x09e0, 0x1e80,
      0x1ece, 0x0baa, 0x2413, 0x216d, 0x0bab, 0x2418, 0x240e, 0x0d70,
      0x0d71, 0x2666, 0x0ee4, 0x1179, 0x266a, 0x266e, 0x28d7, 0x2663,
      0x2b06, 0x1177, 0x1176, 0x1178, 0x13c0, 0x3079, 0x141c, 0x146f,
      0x31bf, 0x146e, 0x14a4, 0x2664, 0x8000, 0x0034, 0x0175, 0x02c7,
      0x0818, 0x8000, 0x0035, 0x00e5, 0x00e4, 0x00e3, 0x023a, 0x0655,
      0x8000, 0x0036, 0x0038, 0x0037, 0x0078, 0x8000, 0x04ba, 0x09e3,
      0x8000, 0x0039, 0x8000, 0x00e6, 0x00e7, 0x0176, 0x8000, 0x035d,
      0x035b, 0x023b, 0x035a, 0x171b, 0x0358, 0x171d, 0x0359, 0x035c,
      0x171c, 0x04bb, 0x1876, 0x04bd, 0x04bc, 0x0657, 0x0656, 0x1a33,
      0x081b, 0x081a, 0x081c, 0x0819, 0x09e5, 0x09e7, 0x1ed9, 0x09e4,
      0x09e6, 0x2177, 0x0bac, 0x0d76, 0x0d74, 0x0d75, 0x241d, 0x0ee6,
      0x0ee7, 0x0ee5, 0x0d73, 0x2b08, 0x117a, 0x2b07, 0x2cc7, 0x28e4,
      0x2e38, 0x0d72, 0x003a, 0x00e8, 0x0178, 0x0177, 0x035e, 0x0bad,
      0x8000, 0x8000, 0x0079, 0x00e9, 0x04be, 0x09e8, 0x8000, 0x8000,
      0x1551, 0x1591, 0x023d, 0x023e, 0x1620, 0x023c, 0x0362, 0x0363,
      0x0360, 0x035f, 0x0361, 0x04bf, 0x1880, 0x04c0, 0x065a, 0x0658,
      0x0659, 0x1c7e, 0x0820, 0x081f, 0x081d, 0x081e, 0x0821, 0x1a37,
      0x1c7b, 0x09ea, 0x09eb, 0x2179, 0x2421, 0x0baf, 0x0bae, 0x09e9,
      0x217b, 0x8000, 0x0d77, 0x0d78, 0x0ee9, 0x2425, 0x0eeb, 0x2674,
      0x0eea, 0x0eed, 0x2676, 0x0ee8, 0x0eec, 0x28e8, 0x28e5, 0x132a,
      0x307b, 0x14ef, 0x1329, 0x8000, 0x8000, 0x0364, 0x023f, 0x8000,
      0x04c1, 0x8000, 0x8000, 0x003b, 0x007a, 0x00ea, 0x0240, 0x1881,
      0x04c2, 0x0d79, 0x8000, 0x003c, 0x8000, 0x0179, 0x0bb0, 0x8000,
      0x003d, 0x007b, 0x007c, 0x00ec, 0x017a, 0x0241, 0x171f, 0x1720,
      0x0365, 0x0366, 0x0367, 0x1721, 0x171e, 0x04c3, 0x065b, 0x1a39,
      0x0822, 0x2429, 0x0823, 0x1c80, 0x09ed, 0x217d, 0x0eee, 0x105a,
      0x117b, 0x1470, 0x00eb, 0x8000, 0x1883, 0x0824, 0x1edb, 0x0bb1,
      0x127c, 0x8000, 0x8000, 0x8000, 0x0243, 0x0242, 0x04c4, 0x1a3a,
      0x0826, 0x0936, 0x0827, 0x0825, 0x09ee, 0x0d7b, 0x0eef, 0x8000,
      0x8000, 0x1523, 0x0244, 0x0245, 0x036b, 0x036a, 0x0368, 0x0369,
      0x1723, 0x04c6, 0x04c9, 0x04c5, 0x04cb, 0x04c7, 0x04c8, 0x04ca,
      0x065e, 0x065d, 0x065c, 0x0828, 0x082b, 0x0829, 0x082e, 0x082a,
      0x082d, 0x082c, 0x8000, 0x09f1, 0x09ef, 0x09f0, 0x0bb2, 0x217f,
      0x0bb3, 0x217e, 0x0ef1, 0x0ef0, 0x0d7c, 0x28eb, 0x117c, 0x8000,
      0x007d, 0x00ed, 0x1553, 0x0247, 0x0249, 0x1629, 0x017c, 0x0248,
      0x0246, 0x162b, 0x162a, 0x017b, 0x036c, 0x036d, 0x1630, 0x024d,
      0x024b, 0x162c, 0x162e, 0x036f, 0x024a, 0x024c, 0x1631, 0x1636,
      0x036e, 0x0370, 0x1735, 0x04d0, 0x0371, 0x04cc, 0x0377, 0x0375,
      0x172f, 0x172a, 0x037c, 0x04cd, 0x04ce, 0x0378, 0x04cf, 0x1729,
      0x0379, 0x04d1, 0x037a, 0x0376, 0x037b, 0x0373, 0x8000, 0x0374,
      0x8000, 0x1730, 0x0372, 0x1a3e, 0x1891, 0x04d7, 0x04d6, 0x188c,
      0x188f, 0x04d2, 0x0662, 0x0663, 0x065f, 0x1a3c, 0x1a3b, 0x04d5,
      0x0660, 0x04db, 0x0661, 0x1a3d, 0x04d4, 0x0665, 0x04da, 0x04d9,
      0x0664, 0x0666, 0x04d3, 0x1a45, 0x188d, 0x0667, 0x066d, 0x066c,
      0x066a, 0x1a42, 0x066b, 0x066e, 0x0669, 0x0831, 0x1a47, 0x1a44,
      0x8000, 0x0668, 0x0832, 0x0830, 0x8000, 0x1a43, 0x1c91, 0x8000,
      0x09f4, 0x0835, 0x083a, 0x09f5, 0x0841, 0x0839, 0x083c, 0x0837,
      0x1c87, 0x1ee4, 0x0838, 0x083f, 0x0843, 0x1ee3, 0x09f2, 0x1c8a,
      0x083e, 0x083d, 0x1c8e, 0x0842, 0x1c92, 0x083b, 0x1c8f, 0x0840,
      0x09f6, 0x09f3, 0x1c88, 0x0834, 0x09fb, 0x09ff, 0x1ee6, 0x0bb8,
      0x09fd, 0x0a01, 0x1eec, 0x0bba, 0x09f9, 0x09fc, 0x0a03, 0x0bbb,
      0x0bc5, 0x0bbc, 0x0a02, 0x1ee7, 0x0bc4, 0x0a00, 0x0bb5, 0x0a04,
      0x1ee5, 0x09fa, 0x0bb4, 0x0bb9, 0x09f7, 0x0bb7, 0x0bc0, 0x0bc3,
      0x8000, 0x2183, 0x242d, 0x0bc2, 0x0bc6, 0x0bbd, 0x0bc1, 0x0d7e,
      0x8000, 0x0bbf, 0x2188, 0x0d7d, 0x0bb6, 0x2182, 0x0d7f, 0x0bbe,
      0x242f, 0x2434, 0x0ef6, 0x0d85, 0x8000, 0x0ef5, 0x0d84, 0x0d83,
      0x0d81, 0x0d82, 0x8000, 0x0ef3, 0x09fe, 0x0efa, 0x0ef4, 0x0ef9,
      0x2432, 0x2438, 0x0d86, 0x0ef2, 0x0d80, 0x0ef8, 0x0efb, 0x8000,
      0x0ef7, 0x243c, 0x105e, 0x0efd, 0x105c, 0x0f03, 0x0f01, 0x0eff,
      0x28ec, 0x0f02, 0x0efc, 0x28ed, 0x105d, 0x0f00, 0x0efe, 0x0f04,
      0x2682, 0x105b, 0x2688, 0x1060, 0x28f7, 0x1061, 0x2b0b, 0x28f2,
      0x117e, 0x117f, 0x1063, 0x117d, 0x1062, 0x1181, 0x28f4, 0x105f,
      0x8000, 0x2685, 0x28ef, 0x8000, 0x8000, 0x2cca, 0x127d, 0x2b0f,
      0x1180, 0x132b, 0x1471, 0x132e, 0x132d, 0x132c, 0x13c1, 0x13c2,
      0x141d, 0x307c, 0x141e, 0x14a5, 0x31c2, 0x32de, 0x8000, 0x007e,
      0x00ee, 0x017e, 0x017f, 0x017d, 0x0180, 0x024f, 0x024e, 0x173d,
      0x037e, 0x037d, 0x0844, 0x0845, 0x0a05, 0x0bc8, 0x2190, 0x0bc7,
      0x218f, 0x2441, 0x0d87, 0x127e, 0x0f05, 0x1064, 0x1182, 0x1183,
      0x2191, 0x007f, 0x0380, 0x037f, 0x0381, 0x173e, 0x04dc, 0x1899,
      0x8000, 0x1a4d, 0x066f, 0x0846, 0x0a06, 0x1ef7, 0x8000, 0x0080,
      0x003e, 0x0081, 0x00f2, 0x00f1, 0x00ef, 0x1555, 0x0183, 0x0182,
      0x159f, 0x159d, 0x159c, 0x0181, 0x0256, 0x025f, 0x025d, 0x1640,
      0x025b, 0x0254, 0x025a, 0x0397, 0x0258, 0x0259, 0x0382, 0x0253,
      0x163a, 0x0250, 0x0263, 0x0255, 0x0257, 0x0262, 0x025c, 0x0261,
      0x163e, 0x0260, 0x0252, 0x0251, 0x025e, 0x0390, 0x038b, 0x039e,
      0x0399, 0x1744, 0x0388, 0x0392, 0x0391, 0x0387, 0x0385, 0x039d,
      0x0395, 0x8000, 0x038f, 0x0383, 0x1745, 0x038e, 0x0384, 0x0396,
      0x189a, 0x0393, 0x1741, 0x0389, 0x038c, 0x038d, 0x8000, 0x039b,
      0x039c, 0x039a, 0x0394, 0x0398, 0x038a, 0x04dd, 0x159a, 0x04e3,
      0x04e1, 0x04e9, 0x04e6, 0x04e8, 0x0670, 0x04eb, 0x04e7, 0x04e4,
      0x04ea, 0x0672, 0x04e2, 0x04ed, 0x04e5, 0x0671, 0x04df, 0x189b,
      0x04ec, 0x04de, 0x04e0, 0x0680, 0x067e, 0x067f, 0x0675, 0x1a54,
      0x1a57, 0x067b, 0x1a5a, 0x067d, 0x0674, 0x1a52, 0x0678, 0x067a,
      0x1a58, 0x0682, 0x0681, 0x1a64, 0x067c, 0x8000, 0x0676, 0x1c99,
      0x0673, 0x084e, 0x0862, 0x0861, 0x0856, 0x8000, 0x1cac, 0x1ca8,
      0x0849, 0x0851, 0x8000, 0x0a16, 0x084d, 0x8000, 0x0860, 0x1c9d,
      0x085f, 0x0854, 0x1ca6, 0x0859, 0x0853, 0x1c9b, 0x0a08, 0x085e,
      0x1ca4, 0x1ca7, 0x085d, 0x084a, 0x084f, 0x0855, 0x0847, 0x085b,
      0x084b, 0x0a07, 0x084c, 0x0848, 0x0857, 0x0852, 0x0850, 0x085c,
      0x1ca9, 0x0858, 0x1c9f, 0x1ef8, 0x1ca3, 0x0a0a, 0x1f0d, 0x0a0d,
      0x0a0c, 0x0a09, 0x8000, 0x0a11, 0x0a0f, 0x0a13, 0x0a1b, 0x0a19,
      0x1f0c, 0x1f03, 0x0bce, 0x0a12, 0x0a10, 0x0a0b, 0x0a18, 0x0a14,
      0x0a15, 0x1f06, 0x0a17, 0x1c9e, 0x1f0a, 0x2192, 0x1f16, 0x1f15,
      0x2194, 0x0bd7, 0x8000, 0x0bd3, 0x0bd0, 0x2196, 0x0bc9, 0x0bd2,
      0x0bd5, 0x0bd6, 0x0bd1, 0x2198, 0x21a1, 0x21ad, 0x21a4, 0x21a6,
      0x0bcc, 0x0bcf, 0x0bcd, 0x0d91, 0x21a8, 0x0bd4, 0x2195, 0x8000,
      0x21aa, 0x219e, 0x0d89, 0x0d8d, 0x2456, 0x0d90, 0x0f06, 0x0d92,
      0x0f07, 0x244b, 0x2449, 0x0d8c, 0x0f08, 0x0d8e, 0x0d8f, 0x0a1a,
      0x2446, 0x2690, 0x2448, 0x244c, 0x0f11, 0x0d88, 0x0f0b, 0x0f0c,
      0x0f12, 0x0f0f, 0x0f10, 0x0f18, 0x0f16, 0x1f00, 0x0f09, 0x0d8b,
      0x0f0e, 0x0f15, 0x0f14, 0x0f13, 0x0f0d, 0x0f0a, 0x0f17, 0x2b16,
      0x269a, 0x1068, 0x1069, 0x1072, 0x1066, 0x106d, 0x106b, 0x1065,
      0x106c, 0x1185, 0x1067, 0x106e, 0x1184, 0x28fb, 0x1070, 0x1071,
      0x28f9, 0x1186, 0x106a, 0x1285, 0x13c5, 0x1187, 0x8000, 0x118c,
      0x2b15, 0x1189, 0x118a, 0x2b13, 0x118b, 0x8000, 0x118d, 0x1280,
      0x127f, 0x1283, 0x1284, 0x1281, 0x132f, 0x2cd4, 0x13c4, 0x2f80,
      0x13c3, 0x1420, 0x141f, 0x8000, 0x312f, 0x14a6, 0x1472, 0x14a8,
      0x14a7, 0x14ce, 0x31c5, 0x8000, 0x0082, 0x1f18, 0x8000, 0x8000,
      0x0184, 0x164a, 0x0266, 0x0264, 0x0265, 0x03a0, 0x04ee, 0x04ef,
      0x0683, 0x0684, 0x086b, 0x0867, 0x086a, 0x0866, 0x086c, 0x0865,
      0x0868, 0x086d, 0x8000, 0x0864, 0x0a1d, 0x0a1f, 0x0a20, 0x0a1e,
      0x269f, 0x0bd8, 0x0d94, 0x1073, 0x0f1b, 0x0f1c, 0x0f1d, 0x269d,
      0x2b19, 0x118e, 0x118f, 0x8000, 0x8000, 0x0083, 0x1f1f, 0x0a22,
      0x0a21, 0x1421, 0x8000, 0x0084, 0x0685, 0x086f, 0x086e, 0x1f20,
      0x0bd9, 0x0d95, 0x2907, 0x0085, 0x00f3, 0x03a1, 0x174e, 0x0870,
      0x0a23, 0x1f22, 0x0bda, 0x1286, 0x8000, 0x3276, 0x8000, 0x0086,
      0x03a2, 0x04f1, 0x18b0, 0x0874, 0x0686, 0x1a6f, 0x1a6d, 0x1a6e,
      0x0687, 0x1a6c, 0x1f23, 0x0872, 0x0873, 0x0871, 0x0d97, 0x1f24,
      0x8000, 0x2cdb, 0x2f83, 0x2e43, 0x8000, 0x8000, 0x04f2, 0x1535,
      0x0087, 0x00f4, 0x0186, 0x0185, 0x0187, 0x0188, 0x15a3, 0x0267,
      0x164b, 0x03a3, 0x03a6, 0x03a8, 0x03a7, 0x1756, 0x03a9, 0x03ab,
      0x03a5, 0x03a4, 0x03aa, 0x1750, 0x03ac, 0x18bb, 0x04f8, 0x04f5,
      0x04f3, 0x04f6, 0x04f9, 0x04f4, 0x04f7, 0x04fa, 0x18bc, 0x18b4,
      0x18b1, 0x068f, 0x0688, 0x068b, 0x0689, 0x068d, 0x068a, 0x0876,
      0x1cbc, 0x0875, 0x087a, 0x1cbb, 0x0877, 0x0878, 0x0879, 0x8000,
      0x0a24, 0x0a28, 0x0a25, 0x8000, 0x0a26, 0x0a27, 0x0a2c, 0x0a2a,
      0x1f26, 0x0be0, 0x0bdd, 0x0be2, 0x0a29, 0x0bdf, 0x0bdb, 0x0be1,
      0x0d9a, 0x0d98, 0x0bde, 0x0bdc, 0x0f1f, 0x8000, 0x0f1e, 0x0f21,
      0x0f20, 0x26a2, 0x1076, 0x0d99, 0x1075, 0x2909, 0x290a, 0x2908,
      0x1078, 0x290d, 0x1190, 0x2cdc, 0x2cdd, 0x1287, 0x1332, 0x8000,
      0x1331, 0x13c6, 0x2f84, 0x1422, 0x14a9, 0x03ae, 0x0088, 0x0189,
      0x018a, 0x0268, 0x04fc, 0x0690, 0x087b, 0x07cc, 0x0a2d, 0x0a2e,
      0x099d, 0x0be3, 0x2464, 0x087c, 0x0089, 0x018b, 0x03b0, 0x03af,
      0x0691, 0x18c0, 0x1a75, 0x18bf, 0x0692, 0x0693, 0x087d, 0x8000,
      0x0a30, 0x0a2f, 0x2466, 0x1288, 0x13c7, 0x8000, 0x008a, 0x00f7,
      0x00f8, 0x00f6, 0x00f9, 0x00f5, 0x018e, 0x018d, 0x018f, 0x018c,
      0x0272, 0x8000, 0x1650, 0x0271, 0x1653, 0x026a, 0x026b, 0x8000,
      0x026c, 0x026d, 0x0274, 0x026f, 0x1652, 0x026e, 0x0270, 0x0269,
      0x0273, 0x0275, 0x03c5, 0x03b1, 0x04fd, 0x03bb, 0x03bc, 0x03b4,
      0x03c6, 0x03b6, 0x1763, 0x03c1, 0x1655, 0x03c4, 0x03bf, 0x03bd,
      0x03be, 0x03c0, 0x03b3, 0x03ba, 0x176e, 0x03c2, 0x03b5, 0x03b9,
      0x8000, 0x03b8, 0x03b2, 0x176a, 0x1765, 0x0504, 0x18db, 0x18d1,
      0x18cf, 0x0503, 0x18ca, 0x050d, 0x18d8, 0x18c6, 0x18c1, 0x0508,
      0x050e, 0x0501, 0x0509, 0x0515, 0x04fe, 0x0500, 0x18c8, 0x0512,
      0x050b, 0x18c5, 0x0514, 0x050f, 0x18ce, 0x0513, 0x050c, 0x0502,
      0x0507, 0x18d4, 0x18da, 0x04ff, 0x0510, 0x06a2, 0x0505, 0x0511,
      0x18d7, 0x18d2, 0x069e, 0x0694, 0x069c, 0x06a7, 0x0695, 0x1a7f,
      0x0699, 0x1a7b, 0x06a5, 0x06a1, 0x06a4, 0x06ab, 0x069a, 0x06a6,
      0x06a8, 0x0697, 0x0696, 0x069f, 0x1a85, 0x06a3, 0x06a0, 0x0698,
      0x069b, 0x8000, 0x1a7e, 0x1a79, 0x1a7a, 0x1a86, 0x1cd5, 0x1ccf,
      0x1cc1, 0x0884, 0x1cd2, 0x0883, 0x0889, 0x087e, 0x088d, 0x088c,
      0x1cd1, 0x0881, 0x088e, 0x0887, 0x8000, 0x1cc4, 0x088f, 0x0891,
      0x0880, 0x0886, 0x8000, 0x088b, 0x087f, 0x0885, 0x0888, 0x1cd0,
      0x069d, 0x0882, 0x1cc6, 0x1cc3, 0x1cca, 0x088a, 0x0a44, 0x0a3f,
      0x0a40, 0x0a3c, 0x0a32, 0x1f37, 0x0a35, 0x0a34, 0x0a45, 0x0a37,
      0x0a33, 0x0a3e, 0x0a3a, 0x1f39, 0x1f33, 0x0a39, 0x21d7, 0x21c2,
      0x0a3d, 0x0a3b, 0x0a31, 0x8000, 0x0a47, 0x1f4c, 0x8000, 0x0a36,
      0x0a41, 0x0a43, 0x0a42, 0x1f4a, 0x1f2f, 0x1f35, 0x1f4d, 0x1f3d,
      0x1f3c, 0x21e5, 0x0beb, 0x21cb, 0x21d5, 0x21c8, 0x21c9, 0x0bed,
      0x0bf1, 0x0be9, 0x1197, 0x21cd, 0x21ce, 0x21df, 0x0be6, 0x0bf0,
      0x0bf4, 0x0be8, 0x0bf3, 0x21c6, 0x0bf5, 0x0bef, 0x0be5, 0x21dc,
      0x0a46, 0x0bea, 0x0be7, 0x0bf2, 0x8000, 0x21c4, 0x0bf6, 0x0bee,
      0x21da, 0x21d8, 0x0be4, 0x0d9d, 0x246c, 0x8000, 0x0da2, 0x0d9b,
      0x0dab, 0x2473, 0x0d9c, 0x0da5, 0x0da9, 0x0d9f, 0x2467, 0x0da6,
      0x0da4, 0x2476, 0x0d9e, 0x8000, 0x247e, 0x0da1, 0x0daa, 0x0da8,
      0x246b, 0x0da7, 0x0da0, 0x2472, 0x247b, 0x248b, 0x0da3, 0x246f,
      0x0f30, 0x0dac, 0x26bd, 0x0f24, 0x8000, 0x0bec, 0x0f2c, 0x8000,
      0x0f28, 0x26b2, 0x0f25, 0x0f2d, 0x0f2b, 0x0f2a, 0x26ae, 0x0f27,
      0x26b5, 0x0f26, 0x0f23, 0x0f29, 0x0f22, 0x26ac, 0x0f2e, 0x26c9,
      0x26ab, 0x26af, 0x2917, 0x107b, 0x1086, 0x1080, 0x107a, 0x2919,
      0x1081, 0x1088, 0x1084, 0x2926, 0x107d, 0x291d, 0x1087, 0x1083,
      0x2916, 0x107e, 0x291f, 0x128d, 0x1082, 0x107c, 0x2923, 0x2b1f,
      0x107f, 0x1192, 0x2b22, 0x1194, 0x119b, 0x1193, 0x1196, 0x2b23,
      0x8000, 0x119c, 0x1195, 0x1198, 0x128a, 0x128f, 0x1290, 0x1289,
      0x128c, 0x128e, 0x128b, 0x8000, 0x1336, 0x1335, 0x2e4c, 0x1334,
      0x2e51, 0x2e4b, 0x2f8c, 0x2f89, 0x13c8, 0x1425, 0x2f87, 0x8000,
      0x1424, 0x1423, 0x1473, 0x8000, 0x31ca, 0x14f0, 0x3080, 0x0506,
      0x008b, 0x0190, 0x03c7, 0x1a92, 0x0894, 0x0a48, 0x1ce9, 0x1f5e,
      0x0a49, 0x0a4a, 0x1f60, 0x21f0, 0x21ee, 0x0bf7, 0x2933, 0x0dae,
      0x0daf, 0x0f32, 0x0f31, 0x2934, 0x1f5f, 0x1089, 0x2b35, 0x8000,
      0x1291, 0x2e52, 0x1474, 0x2cea, 0x008c, 0x00fa, 0x0191, 0x0276,
      0x03c8, 0x0516, 0x03c9, 0x0bf8, 0x108a, 0x1292, 0x8000, 0x008d,
      0x0192, 0x03ca, 0x1776, 0x18ea, 0x0517, 0x18eb, 0x0518, 0x06ad,
      0x06ac, 0x1ced, 0x0a4c, 0x0a4b, 0x1f65, 0x21f4, 0x2490, 0x0f33,
      0x2938, 0x26d2, 0x2937, 0x119e, 0x1293, 0x1426, 0x8000, 0x1536,
      0x0519, 0x06ae, 0x0895, 0x0a4d, 0x1f66, 0x0bfa, 0x0bf9, 0x0f34,
      0x0f35, 0x8000, 0x00fb, 0x008e, 0x0277, 0x051a, 0x0bfb, 0x8000,
      0x008f, 0x18ed, 0x051b, 0x18ee, 0x8000, 0x0090, 0x8000, 0x1a9f,
      0x0896, 0x0897, 0x0a4e, 0x1f69, 0x26d7, 0x108b, 0x21f8, 0x21f6,
      0x293b, 0x11a0, 0x3133, 0x8000, 0x0091, 0x00fd, 0x00fc, 0x03cb,
      0x0a50, 0x1538, 0x03cc, 0x06af, 0x06b3, 0x0db0, 0x1ab3, 0x0092,
      0x8000, 0x00fe, 0x0101, 0x00ff, 0x0100, 0x0278, 0x019e, 0x0195,
      0x019b, 0x019c, 0x15b0, 0x0194, 0x0197, 0x0198, 0x8000, 0x0199,
      0x15b3, 0x019a, 0x0279, 0x0285, 0x0280, 0x0283, 0x028a, 0x028c,
      0x028e, 0x8000, 0x0281, 0x028b, 0x027b, 0x0292, 0x165f, 0x0289,
      0x027c, 0x027d, 0x0284, 0x028f, 0x0282, 0x0287, 0x0290, 0x0286,
      0x8000, 0x027a, 0x1665, 0x027f, 0x028d, 0x177a, 0x1664, 0x1666,
      0x027e, 0x03e8, 0x03d8, 0x03df, 0x03d0, 0x03d3, 0x03db, 0x03dd,
      0x03e4, 0x03d6, 0x03d4, 0x03d5, 0x03e3, 0x1785, 0x03dc, 0x03de,
      0x03e1, 0x1780, 0x1788, 0x051d, 0x03e7, 0x03d1, 0x03da, 0x03d9,
      0x03e0, 0x18fa, 0x177e, 0x03e6, 0x03ec, 0x03e5, 0x03d7, 0x03cd,
      0x03d2, 0x03ce, 0x177c, 0x03e9, 0x177d, 0x06b4, 0x03e2, 0x178a,
      0x03cf, 0x8000, 0x178d, 0x1784, 0x03eb, 0x178c, 0x18fc, 0x18f9,
      0x051e, 0x0523, 0x0533, 0x18f8, 0x0526, 0x052b, 0x18f5, 0x0525,
      0x0522, 0x052e, 0x165d, 0x0520, 0x0534, 0x0531, 0x051f, 0x0524,
      0x18fb, 0x0532, 0x052a, 0x052f, 0x0527, 0x18f6, 0x0528, 0x0529,
      0x18f7, 0x0521, 0x18fd, 0x18ff, 0x052d, 0x06bc, 0x06c1, 0x1aa2,
      0x06b9, 0x06c3, 0x06b5, 0x06c0, 0x06c2, 0x06bb, 0x06ba, 0x06c6,
      0x1ab6, 0x06b8, 0x06b7, 0x06bf, 0x06c4, 0x06bd, 0x06c9, 0x06b6,
      0x8000, 0x1ab9, 0x1aa6, 0x8000, 0x06c8, 0x1ab8, 0x06c7, 0x1aa7,
      0x1aac, 0x08a6, 0x089d, 0x08b1, 0x08ab, 0x089a, 0x08bd, 0x08ae,
      0x08b9, 0x08a4, 0x08a5, 0x08a7, 0x1d00, 0x08b4, 0x089c, 0x08b2,
      0x1d04, 0x089e, 0x08a0, 0x08be, 0x08b8, 0x08b5, 0x08b3, 0x08bc,
      0x08b7, 0x1d0a, 0x08b6, 0x1cff, 0x08ac, 0x08a3, 0x08aa, 0x08a2,
      0x08a1, 0x0899, 0x08bb, 0x1cf3, 0x1cf1, 0x08ba, 0x08af, 0x08a9,
      0x8000, 0x1cf7, 0x1d03, 0x0a6e, 0x08b0, 0x0a5c, 0x0a6a, 0x0a59,
      0x0a55, 0x0a5b, 0x0a5f, 0x0a5a, 0x0a63, 0x0a68, 0x0a62, 0x0a52,
      0x1f8d, 0x0a65, 0x0a53, 0x0a67, 0x0a6b, 0x0a69, 0x0a71, 0x1f73,
      0x0a58, 0x0a66, 0x0a6f, 0x0a60, 0x0a5e, 0x0a5d, 0x1f78, 0x0a57,
      0x1f8a, 0x0a61, 0x0a64, 0x0a72, 0x1f89, 0x1f6e, 0x1f8c, 0x1f7e,
      0x1f8e, 0x0a54, 0x1f84, 0x8000, 0x0a73, 0x0c02, 0x0c0c, 0x21f9,
      0x0c0d, 0x0c03, 0x21fe, 0x2201, 0x0bfd, 0x2218, 0x0c06, 0x0c11,
      0x220d, 0x0c10, 0x0c0a, 0x0bfe, 0x2202, 0x220f, 0x0c00, 0x220a,
      0x0c09, 0x0c08, 0x2206, 0x2207, 0x0c01, 0x2211, 0x0c0e, 0x0c05,
      0x0a6c, 0x0dcc, 0x2496, 0x0c0b, 0x0bff, 0x0c0f, 0x0f47, 0x21fc,
      0x0c07, 0x0c04, 0x2213, 0x24b2, 0x24ac, 0x0dbe, 0x0dcb, 0x8000,
      0x0db5, 0x0dc9, 0x249b, 0x8000, 0x0db3, 0x0dbd, 0x0dca, 0x0dbb,
      0x0dbf, 0x0dba, 0x0a6d, 0x0db4, 0x0db2, 0x24a4, 0x24a1, 0x0db8,
      0x0dbc, 0x0dc3, 0x0dc8, 0x0dc5, 0x0db9, 0x24ad, 0x24af, 0x0dc0,
      0x0dc2, 0x0db1, 0x0dc1, 0x0db7, 0x0f36, 0x8000, 0x0dcd, 0x24ab,
      0x24c0, 0x249f, 0x24b4, 0x24a2, 0x26d9, 0x0db6, 0x0dc6, 0x24b1,
      0x24a9, 0x24a8, 0x0dc4, 0x26d8, 0x0f39, 0x0f3b, 0x0f46, 0x0f3e,
      0x0f4a, 0x26e1, 0x8000, 0x0f44, 0x0f3a, 0x0f3d, 0x0f40, 0x0f43,
      0x0f37, 0x8000, 0x0f3f, 0x0f42, 0x11a9, 0x0f38, 0x0f3c, 0x26db,
      0x0dc7, 0x26df, 0x26e0, 0x0f41, 0x26e2, 0x26f0, 0x2945, 0x0f49,
      0x24ae, 0x26dc, 0x0f48, 0x26da, 0x26de, 0x26e8, 0x26dd, 0x1f70,
      0x108e, 0x8000, 0x2940, 0x1090, 0x294d, 0x1093, 0x1095, 0x1094,
      0x1091, 0x8000, 0x108f, 0x1098, 0x294c, 0x1097, 0x1092, 0x294a,
      0x295a, 0x1099, 0x108d, 0x2941, 0x1096, 0x2942, 0x11a1, 0x2b3b,
      0x11ad, 0x2944, 0x2949, 0x11a5, 0x11a3, 0x11a4, 0x11ab, 0x11a6,
      0x11a7, 0x11aa, 0x11ae, 0x11a8, 0x11af, 0x11a2, 0x1294, 0x11ac,
      0x2b41, 0x1298, 0x2cf8, 0x1296, 0x1297, 0x129a, 0x1299, 0x2cf0,
      0x133c, 0x3236, 0x133a, 0x1337, 0x133b, 0x1338, 0x2e57, 0x1339,
      0x133d, 0x2e5a, 0x2e5c, 0x2f8f, 0x1295, 0x2cef, 0x2e56, 0x2cf7,
      0x8000, 0x13cb, 0x13c9, 0x13ca, 0x2f90, 0x2f99, 0x2f98, 0x1427,
      0x3083, 0x3087, 0x8000, 0x1475, 0x1476, 0x3235, 0x14f1, 0x32f2,
      0x14cf, 0x14ff, 0x053b, 0x0093, 0x019f, 0x0293, 0x0296, 0x1670,
      0x0294, 0x0295, 0x8000, 0x03f0, 0x03ee, 0x03ef, 0x03ed, 0x03f1,
      0x179c, 0x053d, 0x0535, 0x0538, 0x053a, 0x053c, 0x0539, 0x1915,
      0x1914, 0x0537, 0x1911, 0x8000, 0x8000, 0x06ce, 0x1aca, 0x06cf,
      0x8000, 0x8000, 0x06cb, 0x1ac6, 0x1ac9, 0x8000, 0x08bf, 0x1d18,
      0x08c2, 0x1d1d, 0x0a75, 0x0a76, 0x0a7c, 0x0a79, 0x0a77, 0x0a78,
      0x0a7a, 0x1f9c, 0x1f9b, 0x8000, 0x8000, 0x2221, 0x0c17, 0x8000,
      0x0c1c, 0x0c13, 0x0a7b, 0x2223, 0x0dcf, 0x0c21, 0x0c19, 0x0c1e,
      0x2228, 0x0c16, 0x0c1d, 0x0c1b, 0x0c18, 0x0c15, 0x0c20, 0x8000,
      0x0c1a, 0x0dd0, 0x24c5, 0x0dd2, 0x24c6, 0x24c2, 0x0dd1, 0x24c8,
      0x0dd3, 0x2702, 0x0f4b, 0x0dce, 0x0f4e, 0x0f4c, 0x2701, 0x0f4d,
      0x2704, 0x2700, 0x295e, 0x8000, 0x10a0, 0x109a, 0x2960, 0x295c,
      0x109c, 0x295f, 0x10a2, 0x10a4, 0x10a5, 0x109e, 0x10a1, 0x109d,
      0x2963, 0x109f, 0x11b1, 0x11b8, 0x11b4, 0x11b3, 0x11b0, 0x11b6,
      0x11b5, 0x129b, 0x11b2, 0x2cfd, 0x129c, 0x2cfc, 0x129d, 0x133e,
      0x2e63, 0x133f, 0x2f9f, 0x13cc, 0x1428, 0x308b, 0x308a, 0x3139,
      0x1f9f, 0x1f9d, 0x8000, 0x1513, 0x06cc, 0x0094, 0x03f3, 0x8000,
      0x03f2, 0x053e, 0x0536, 0x11b9, 0x8000, 0x0095, 0x06d0, 0x0c22,
      0x03f4, 0x0096, 0x08c4, 0x0dd4, 0x8000, 0x1539, 0x8000, 0x1ad9,
      0x191a, 0x11ba, 0x8000, 0x0097, 0x03f5, 0x1fa9, 0x0a7d, 0x0c23,
      0x8000, 0x0f4f, 0x1340, 0x24ce, 0x0098, 0x8000, 0x0099, 0x01a1,
      0x01a0, 0x0298, 0x0297, 0x1671, 0x03f6, 0x0541, 0x03f7, 0x1920,
      0x0540, 0x053f, 0x1adc, 0x1adb, 0x06d1, 0x08c5, 0x1d2f, 0x0a7f,
      0x8000, 0x1fac, 0x2239, 0x0dd5, 0x0dd6, 0x1341, 0x1429, 0x2fa1,
      0x191f, 0x009a, 0x0102, 0x15b8, 0x03f8, 0x029b, 0x1674, 0x029a,
      0x1676, 0x03f9, 0x03fc, 0x03fb, 0x03fa, 0x0544, 0x8000, 0x0543,
      0x0542, 0x1adf, 0x06d5, 0x06d3, 0x06d2, 0x06d4, 0x1ae3, 0x1ade,
      0x06d6, 0x1fb1, 0x1ae4, 0x08c9, 0x1d31, 0x08cb, 0x08c8, 0x08c7,
      0x1d30, 0x1d39, 0x1d35, 0x1d34, 0x1fb3, 0x0a81, 0x0a83, 0x8000,
      0x8000, 0x0a82, 0x0a80, 0x0c24, 0x8000, 0x1fb4, 0x2241, 0x2240,
      0x0c27, 0x0c26, 0x24d2, 0x0dd7, 0x0c25, 0x24d3, 0x0dd8, 0x2714,
      0x0f52, 0x2713, 0x2971, 0x10a6, 0x2975, 0x2972, 0x2717, 0x2b4e,
      0x11bc, 0x2b4f, 0x2b4d, 0x129f, 0x12a0, 0x1342, 0x1343, 0x13cd,
      0x31d1, 0x11bb, 0x1477, 0x0103, 0x08cc, 0x1929, 0x1d3a, 0x8000,
      0x0104, 0x009b, 0x15ba, 0x1679, 0x167c, 0x029c, 0x03ff, 0x17b6,
      0x17b5, 0x17b4, 0x03fe, 0x03fd, 0x0400, 0x0548, 0x054b, 0x0545,
      0x192b, 0x1934, 0x192c, 0x8000, 0x0547, 0x054a, 0x0546, 0x0549,
      0x192a, 0x1ae9, 0x06dd, 0x1ae5, 0x06db, 0x1ae6, 0x1ae8, 0x1ae7,
      0x1aeb, 0x1aec, 0x06dc, 0x06d8, 0x1aea, 0x06da, 0x1d40, 0x08d1,
      0x08cf, 0x08cd, 0x08d0, 0x1d41, 0x06d9, 0x1d3b, 0x8000, 0x08ce,
      0x8000, 0x1fc1, 0x1fc2, 0x0a8d, 0x0a87, 0x1fc6, 0x0a88, 0x0a8e,
      0x0a8f, 0x0a85, 0x1fc4, 0x1fbd, 0x0a8c, 0x0a86, 0x0a8b, 0x0a8a,
      0x0a89, 0x1fc0, 0x1fbe, 0x17b1, 0x1fcb, 0x2247, 0x0c2a, 0x0c2f,
      0x0c29, 0x0c30, 0x0c31, 0x0c2c, 0x0c2b, 0x8000, 0x224b, 0x0c2d,
      0x8000, 0x2249, 0x224a, 0x0dda, 0x0dd9, 0x0f53, 0x0ddb, 0x0ddc,
      0x24da, 0x8000, 0x0c28, 0x24d8, 0x24d7, 0x8000, 0x0f57, 0x0f55,
      0x0f54, 0x2723, 0x0f56, 0x2722, 0x2721, 0x8000, 0x2725, 0x297c,
      0x271e, 0x2b53, 0x10a7, 0x10a8, 0x10a9, 0x10ab, 0x10aa, 0x2978,
      0x12a1, 0x11c0, 0x2b58, 0x11be, 0x2b54, 0x2b52, 0x1344, 0x2b51,
      0x2d01, 0x2d03, 0x1345, 0x13ce, 0x142b, 0x3238, 0x12a2, 0x14ab,
      0x8000, 0x2d02, 0x313c, 0x2b57, 0x0105, 0x1af6, 0x08d3, 0x10ac,
      0x1346, 0x1478, 0x8000, 0x0106, 0x193b, 0x1af8, 0x08d4, 0x08d5,
      0x1fcc, 0x24df, 0x0dde, 0x2729, 0x2254, 0x10ad, 0x10ae, 0x8000,
      0x2b5a, 0x2d0a, 0x12a3, 0x308e, 0x2d09, 0x2e6f, 0x80bd, 0x0107,
      0x054c, 0x08d6, 0x8000, 0x8000, 0x0108, 0x1afa, 0x08d7, 0x0a90,
      0x0a91, 0x8000, 0x0109, 0x15bb, 0x029e, 0x029d, 0x1fcd, 0x8000,
      0x010b, 0x010c, 0x010d, 0x010e, 0x029f, 0x02a0, 0x0402, 0x17bd,
      0x17bc, 0x0551, 0x054f, 0x0550, 0x054e, 0x167e, 0x8000, 0x17bb,
      0x193d, 0x06de, 0x06e1, 0x1afb, 0x06e0, 0x06df, 0x06e2, 0x1afc,
      0x08da, 0x1d4a, 0x08d8, 0x08d9, 0x0a93, 0x0a92, 0x1fcf, 0x1fce,
      0x08db, 0x8000, 0x2259, 0x2258, 0x24e0, 0x0c32, 0x0c33, 0x0f58,
      0x1348, 0x1347, 0x1479, 0x8000, 0x010f, 0x8000, 0x08dc, 0x24e1,
      0x0ddf, 0x8000, 0x8000, 0x1680, 0x8000, 0x1681, 0x0405, 0x0403,
      0x0555, 0x0556, 0x0553, 0x0554, 0x0552, 0x193f, 0x06e6, 0x06e7,
      0x8000, 0x08df, 0x06ec, 0x06ea, 0x06e9, 0x06e8, 0x06e3, 0x1b02,
      0x06e4, 0x06e5, 0x06eb, 0x08e0, 0x1d50, 0x08e1, 0x1d4d, 0x08dd,
      0x08de, 0x1fd7, 0x0a98, 0x0a95, 0x0a99, 0x0a96, 0x1fd2, 0x0a94,
      0x225b, 0x0c35, 0x0c37, 0x0c3b, 0x0c39, 0x2260, 0x225f, 0x0c3a,
      0x0c34, 0x0c36, 0x8000, 0x8000, 0x0de3, 0x0de2, 0x0de1, 0x225c,
      0x272e, 0x2263, 0x0de4, 0x24e5, 0x24e2, 0x272c, 0x0f5b, 0x0f59,
      0x0f5e, 0x0f5f, 0x0f5c, 0x272b, 0x0f5d, 0x0de0, 0x8000, 0x2732,
      0x2987, 0x2983, 0x10af, 0x2985, 0x8000, 0x2984, 0x11c2, 0x2b5e,
      0x11c1, 0x2b61, 0x2b60, 0x12a4, 0x10b1, 0x8000, 0x12a5, 0x2d0d,
      0x2d0b, 0x2d0c, 0x134a, 0x13cf, 0x13d0, 0x8000, 0x3140, 0x8000,
      0x142c, 0x147b, 0x147a, 0x8000, 0x31d3, 0x14d0, 0x14d1, 0x0404,
      0x8000, 0x0557, 0x0a9b, 0x0a9c, 0x8000, 0x0110, 0x01a2, 0x02a1,
      0x0406, 0x0558, 0x0559, 0x055a, 0x8000, 0x08e2, 0x0a9e, 0x0a9d,
      0x2269, 0x2734, 0x0f60, 0x2b62, 0x8000, 0x2d12, 0x3141, 0x2fa6,
      0x2fa5, 0x8000, 0x0111, 0x0a9f, 0x8000, 0x24e9, 0x0f61, 0x2d13,
      0x8000, 0x0112, 0x0407, 0x055d, 0x055e, 0x055c, 0x055b, 0x06ef,
      0x8000, 0x06f0, 0x06f1, 0x08e4, 0x08e3, 0x08e5, 0x0aa0, 0x226b,
      0x0c3d, 0x0c3e, 0x8000, 0x0de5, 0x0de6, 0x0f62, 0x10b3, 0x10b2,
      0x2989, 0x2fa8, 0x2b63, 0x11c4, 0x2d14, 0x8000, 0x0113, 0x0408,
      0x0409, 0x0561, 0x0565, 0x0564, 0x055f, 0x1945, 0x0566, 0x1943,
      0x0562, 0x1947, 0x0563, 0x1949, 0x17c3, 0x17c2, 0x1b10, 0x1b08,
      0x06f3, 0x06f4, 0x1b11, 0x1d5e, 0x8000, 0x06f2, 0x1b0f, 0x1d57,
      0x1d60, 0x1d5b, 0x08e9, 0x08e6, 0x08ea, 0x08eb, 0x08e8, 0x08e7,
      0x8000, 0x1d56, 0x0c49, 0x1fdc, 0x1fdb, 0x1fe0, 0x1fde, 0x2271,
      0x0c3f, 0x0c47, 0x0c42, 0x0c45, 0x0dea, 0x0c4a, 0x0c43, 0x0c41,
      0x0c40, 0x226e, 0x226d, 0x0c48, 0x0c44, 0x0de9, 0x24ef, 0x8000,
      0x24f0, 0x0f67, 0x2738, 0x0f63, 0x0f66, 0x10b5, 0x10b4, 0x11c6,
      0x10b7, 0x11c9, 0x11c8, 0x11c5, 0x8000, 0x11ca, 0x11c7, 0x2b68,
      0x12a9, 0x12a7, 0x12a8, 0x134b, 0x2fac, 0x142d, 0x14d2, 0x327f,
      0x298f, 0x1500, 0x1d58, 0x0114, 0x0567, 0x1fe4, 0x8000, 0x0115,
      0x02a3, 0x040a, 0x194b, 0x06f6, 0x0aa2, 0x0c4b, 0x2b6c, 0x11cb,
      0x2e74, 0x8000, 0x0116, 0x8000, 0x17c6, 0x194d, 0x17c8, 0x0568,
      0x1954, 0x056a, 0x056b, 0x194e, 0x194f, 0x06fe, 0x1b15, 0x1b13,
      0x06fd, 0x04f0, 0x1d67, 0x06fb, 0x0701, 0x06ff, 0x06f8, 0x1b19,
      0x06f7, 0x08ed, 0x0569, 0x08ee, 0x1fe9, 0x0aa3, 0x1fe7, 0x1ff0,
      0x08ec, 0x0aa4, 0x1fea, 0x0aa5, 0x1fed, 0x227f, 0x0c50, 0x0c4c,
      0x0c52, 0x0c4e, 0x8000, 0x2278, 0x227a, 0x0c53, 0x0c54, 0x24f8,
      0x2280, 0x24f4, 0x24fa, 0x24f6, 0x0dec, 0x0df0, 0x0ded, 0x0def,
      0x24fd, 0x8000, 0x0c4d, 0x0f6a, 0x0f6e, 0x0f6c, 0x0deb, 0x0f69,
      0x0f6b, 0x8000, 0x0f68, 0x0f6f, 0x8000, 0x2742, 0x0f6d, 0x2746,
      0x2740, 0x299a, 0x299e, 0x10b9, 0x10bb, 0x10b8, 0x10ba, 0x11cf,
      0x2b72, 0x11cd, 0x2b6e, 0x11d0, 0x11cc, 0x2b70, 0x12ab, 0x2743,
      0x134c, 0x13d3, 0x2fb0, 0x11ce, 0x8000, 0x13d1, 0x13d2, 0x13d4,
      0x3092, 0x8000, 0x8000, 0x0117, 0x1683, 0x040c, 0x040d, 0x040e,
      0x056c, 0x056f, 0x056e, 0x056d, 0x17cc, 0x0702, 0x1957, 0x1b22,
      0x0703, 0x1b24, 0x1b20, 0x0706, 0x0709, 0x070a, 0x1b21, 0x1b23,
      0x0708, 0x0707, 0x0705, 0x0704, 0x1d6f, 0x1ff5, 0x08ef, 0x1d6b,
      0x08f0, 0x08f1, 0x8000, 0x2287, 0x0c56, 0x0c57, 0x8000, 0x0c58,
      0x2502, 0x0df3, 0x0df1, 0x0df2, 0x2500, 0x2501, 0x2505, 0x2503,
      0x2504, 0x2748, 0x8000, 0x10bc, 0x2749, 0x2b78, 0x11d1, 0x11d2,
      0x2b79, 0x12ac, 0x2e7b, 0x134d, 0x147c, 0x3143, 0x8000, 0x155e,
      0x0570, 0x0571, 0x1d71, 0x0c5a, 0x8000, 0x0118, 0x02a6, 0x02a5,
      0x02a4, 0x0410, 0x040f, 0x8000, 0x0574, 0x195d, 0x0572, 0x195c,
      0x0573, 0x8000, 0x0711, 0x1b2c, 0x070e, 0x1b29, 0x8000, 0x070b,
      0x070f, 0x070d, 0x0710, 0x1b27, 0x1b2b, 0x1b28, 0x1d75, 0x1d73,
      0x08f2, 0x0aaa, 0x1ff7, 0x0aa9, 0x0aa7, 0x0aa8, 0x1ffa, 0x0aa6,
      0x1ff8, 0x0c5e, 0x228f, 0x228d, 0x0c5c, 0x2293, 0x0c5b, 0x0c5f,
      0x0c5d, 0x8000, 0x274e, 0x0df4, 0x0df5, 0x0f74, 0x0f75, 0x0f71,
      0x0f73, 0x0f70, 0x0f72, 0x29a1, 0x10bf, 0x8000, 0x10c1, 0x10c0,
      0x10bd, 0x10be, 0x11d3, 0x2b7a, 0x12ad, 0x2d20, 0x12ae, 0x12af,
      0x2e7d, 0x134f, 0x134e, 0x2fb7, 0x3144, 0x8000, 0x0119, 0x15bd,
      0x02a7, 0x17ce, 0x0412, 0x0576, 0x0411, 0x8000, 0x0575, 0x1961,
      0x0712, 0x1b32, 0x1b30, 0x0713, 0x1b33, 0x1b35, 0x08f3, 0x08f4,
      0x0aad, 0x2297, 0x0aac, 0x0aab, 0x0c61, 0x0c62, 0x2511, 0x0df7,
      0x0df6, 0x2513, 0x0f77, 0x8000, 0x2751, 0x29a6, 0x29a4, 0x29a5,
      0x2295, 0x10c2, 0x2b80, 0x8000, 0x2b82, 0x12b0, 0x12b1, 0x13d5,
      0x8000, 0x14ac, 0x8000, 0x011a, 0x1963, 0x0714, 0x8000, 0x8000,
      0x098b, 0x098a, 0x0aaf, 0x0aae, 0x1ffd, 0x8000, 0x0df8, 0x0df9,
      0x13d6, 0x8000, 0x01a3, 0x0413, 0x0578, 0x0577, 0x1b39, 0x1b3d,
      0x1b3e, 0x1b3c, 0x0716, 0x08fa, 0x08f7, 0x08fb, 0x1d7f, 0x08f5,
      0x1d7c, 0x08f9, 0x08f6, 0x8000, 0x1d82, 0x1d85, 0x08f8, 0x08fc,
      0x0715, 0x1b3f, 0x1d84, 0x1d80, 0x2007, 0x0ab2, 0x2000, 0x0ab0,
      0x1fff, 0x0ab7, 0x2003, 0x0ab6, 0x2004, 0x0ab8, 0x0ab3, 0x0ab9,
      0x0ab4, 0x8000, 0x0ab5, 0x0ab1, 0x0c65, 0x229a, 0x229f, 0x2299,
      0x0c67, 0x229d, 0x0c66, 0x229e, 0x229c, 0x0dfd, 0x8000, 0x22a1,
      0x0dfc, 0x251e, 0x2524, 0x251b, 0x0e03, 0x0e00, 0x0dfb, 0x0dfe,
      0x251d, 0x0dff, 0x0f7f, 0x0dfa, 0x0e01, 0x2519, 0x8000, 0x8000,
      0x2520, 0x2516, 0x2517, 0x2755, 0x0f78, 0x2757, 0x0f79, 0x0f7b,
      0x0e02, 0x2754, 0x0c64, 0x0f7e, 0x0f7a, 0x0f7c, 0x0f7d, 0x10c5,
      0x2753, 0x29b7, 0x29b2, 0x10c3, 0x29af, 0x29ac, 0x11da, 0x10c8,
      0x10c6, 0x10c4, 0x29ab, 0x29b0, 0x10c9, 0x10ca, 0x29b3, 0x2b85,
      0x2b8c, 0x8000, 0x2b8a, 0x11d8, 0x2b86, 0x2b93, 0x11d5, 0x2b8b,
      0x11d6, 0x11d9, 0x2b84, 0x0f80, 0x11d7, 0x2b8f, 0x8000, 0x2d21,
      0x2d25, 0x12b5, 0x2d24, 0x12b7, 0x12b6, 0x2d2b, 0x2d28, 0x12b3,
      0x2d29, 0x12b4, 0x12b2, 0x1354, 0x1352, 0x8000, 0x2e82, 0x1353,
      0x1350, 0x1351, 0x8000, 0x13d8, 0x2fbb, 0x13d7, 0x13d9, 0x8000,
      0x142e, 0x3094, 0x3095, 0x1355, 0x3148, 0x314a, 0x3149, 0x3147,
      0x147e, 0x147d, 0x14ad, 0x14af, 0x8000, 0x31d5, 0x3281, 0x3282,
      0x14f3, 0x14f2, 0x32b2, 0x1518, 0x2b94, 0x01a4, 0x8000, 0x1968,
      0x0717, 0x08fd, 0x08ff, 0x08fe, 0x1d8d, 0x0aba, 0x2008, 0x0c6a,
      0x0abb, 0x8000, 0x8000, 0x0c68, 0x22a7, 0x0e05, 0x0c69, 0x2528,
      0x2527, 0x0e07, 0x275c, 0x0f81, 0x8000, 0x10cb, 0x8000, 0x10cc,
      0x29bb, 0x11dc, 0x11e1, 0x11dd, 0x11df, 0x11db, 0x8000, 0x11e0,
      0x12b8, 0x8000, 0x13da, 0x3096, 0x314b, 0x8000, 0x314c, 0x3283,
      0x80be, 0x01a5, 0x02a8, 0x0414, 0x057c, 0x057a, 0x057f, 0x057b,
      0x0580, 0x057e, 0x196d, 0x057d, 0x071b, 0x071a, 0x1d90, 0x1b4e,
      0x1b52, 0x1b4a, 0x1b49, 0x1d91, 0x0723, 0x071f, 0x1b4f, 0x071e,
      0x0719, 0x1b4d, 0x0724, 0x0721, 0x0725, 0x0722, 0x071c, 0x0718,
      0x071d, 0x0ac0, 0x1d97, 0x1d96, 0x0903, 0x090a, 0x0907, 0x090c,
      0x0908, 0x0904, 0x1d94, 0x0905, 0x1d9a, 0x1d9b, 0x0906, 0x090b,
      0x0901, 0x0909, 0x0900, 0x090d, 0x1d95, 0x2013, 0x0abd, 0x0abf,
      0x0c70, 0x2015, 0x8000, 0x0abc, 0x0ac3, 0x0ac5, 0x0ac4, 0x0abe,
      0x2012, 0x0ac1, 0x0ac6, 0x0902, 0x0ac2, 0x0ac7, 0x2010, 0x0c6c,
      0x22b0, 0x22ae, 0x0c6e, 0x22aa, 0x8000, 0x22ab, 0x22b5, 0x22ad,
      0x0c6f, 0x0c6d, 0x0c6b, 0x22b3, 0x0e0a, 0x0e0d, 0x0e13, 0x253c,
      0x8000, 0x0e1a, 0x0e17, 0x253d, 0x0e09, 0x0e10, 0x0e11, 0x8000,
      0x0e0f, 0x0e15, 0x0e16, 0x2538, 0x0e12, 0x0e08, 0x0e0b, 0x2530,
      0x2536, 0x2532, 0x0e0c, 0x0e19, 0x0e0e, 0x2535, 0x252c, 0x2537,
      0x0e18, 0x0f86, 0x0f88, 0x0e14, 0x0f8c, 0x0f82, 0x0f8a, 0x8000,
      0x2767, 0x8000, 0x0f89, 0x0f8d, 0x0f87, 0x0f84, 0x0f83, 0x0f85,
      0x29c7, 0x2763, 0x0f8f, 0x2764, 0x8000, 0x0f90, 0x29cb, 0x0f91,
      0x10cf, 0x10d4, 0x10cd, 0x29ca, 0x10d5, 0x29c0, 0x10d0, 0x10d3,
      0x29c2, 0x10d1, 0x10ce, 0x11ec, 0x10d2, 0x29c3, 0x29c9, 0x11e8,
      0x11ea, 0x11e6, 0x2b9c, 0x11f0, 0x2ba7, 0x11e5, 0x11ee, 0x2ba6,
      0x11e9, 0x11e3, 0x2ba8, 0x11eb, 0x11e4, 0x2ba2, 0x2b99, 0x2ba5,
      0x11ed, 0x11ef, 0x12b9, 0x12ba, 0x12bf, 0x12bc, 0x2d2e, 0x12bb,
      0x2d32, 0x12bd, 0x12be, 0x1359, 0x135a, 0x1356, 0x1357, 0x8000,
      0x2e8a, 0x135b, 0x1358, 0x13dc, 0x2fbf, 0x13de, 0x2fc1, 0x13df,
      0x13dd, 0x2fc0, 0x309b, 0x3098, 0x3099, 0x3285, 0x1430, 0x309c,
      0x14b1, 0x142f, 0x3097, 0x314d, 0x14b0, 0x14b2, 0x3286, 0x3284,
      0x1506, 0x8000, 0x01a6, 0x0581, 0x0726, 0x201d, 0x8000, 0x29d1,
      0x8000, 0x11f3, 0x2baa, 0x8000, 0x2e8f, 0x13e0, 0x309d, 0x314e,
      0x14d3, 0x8000, 0x15be, 0x0415, 0x02a9, 0x196f, 0x1b59, 0x1b58,
      0x0727, 0x1b55, 0x1d9f, 0x8000, 0x0c72, 0x0c73, 0x22ba, 0x0c71,
      0x0e1b, 0x22bd, 0x0c74, 0x2541, 0x22bb, 0x276d, 0x0f92, 0x0f93,
      0x10d6, 0x2e91, 0x2bad, 0x2bab, 0x135c, 0x2e92, 0x314f, 0x14d4,
      0x8000, 0x01a7, 0x0416, 0x0582, 0x1970, 0x0728, 0x1b5a, 0x1da1,
      0x0910, 0x1da2, 0x090f, 0x2021, 0x0c77, 0x0c76, 0x0c75, 0x0f94,
      0x10d7, 0x2d38, 0x135d, 0x135f, 0x135e, 0x1431, 0x01a8, 0x1b5e,
      0x072a, 0x0729, 0x1da4, 0x0911, 0x0912, 0x0913, 0x0ac9, 0x0aca,
      0x22c2, 0x0e1e, 0x0e1c, 0x0e1d, 0x2543, 0x2544, 0x2775, 0x0f95,
      0x2772, 0x2774, 0x10da, 0x29d6, 0x10d8, 0x11f4, 0x12c1, 0x8000,
      0x12c2, 0x11f5, 0x2e94, 0x2e95, 0x2fc4, 0x13e1, 0x8000, 0x01a9,
      0x01aa, 0x072c, 0x0418, 0x072b, 0x8000, 0x0acb, 0x8000, 0x01ab,
      0x0585, 0x1974, 0x0584, 0x0586, 0x8000, 0x01ac, 0x1976, 0x072e,
      0x0730, 0x072d, 0x072f, 0x0914, 0x8000, 0x1dad, 0x22c4, 0x2546,
      0x0f96, 0x10db, 0x8000, 0x309f, 0x8000, 0x01ad, 0x0587, 0x8000,
      0x0731, 0x0732, 0x1db0, 0x0916, 0x0915, 0x0acc, 0x0c78, 0x0c79,
      0x0e20, 0x0e1f, 0x11f9, 0x11f8, 0x11f7, 0x11fa, 0x2d3c, 0x12c4,
      0x12c3, 0x1480, 0x147f, 0x8000, 0x01ae, 0x0c7b, 0x0acd, 0x0c7a,
      0x0e21, 0x8000, 0x8000, 0x01af, 0x01b0, 0x01b1, 0x02ab, 0x02aa,
      0x02ad, 0x02af, 0x02ae, 0x02ac, 0x041d, 0x041b, 0x041a, 0x8000,
      0x041f, 0x041e, 0x0422, 0x041c, 0x02b0, 0x0420, 0x17d7, 0x0419,
      0x058b, 0x058c, 0x058d, 0x1987, 0x2029, 0x1989, 0x0590, 0x1986,
      0x0588, 0x1981, 0x058a, 0x058f, 0x0593, 0x0591, 0x8000, 0x197a,
      0x0737, 0x0740, 0x058e, 0x0589, 0x073a, 0x073f, 0x073d, 0x2028,
      0x0734, 0x8000, 0x0736, 0x8000, 0x0733, 0x073c, 0x073e, 0x8000,
      0x1db2, 0x1db5, 0x1db9, 0x091d, 0x0919, 0x1cc0, 0x091b, 0x1db3,
      0x091a, 0x1db8, 0x0917, 0x0ad3, 0x0ad5, 0x0ad4, 0x202b, 0x0ad0,
      0x0ad2, 0x0e22, 0x0ad1, 0x0ad7, 0x0acf, 0x0ace, 0x0c7f, 0x0c85,
      0x0ad8, 0x0c82, 0x0c80, 0x22d1, 0x0c7d, 0x0c7c, 0x0c7e, 0x0c83,
      0x22c6, 0x0e27, 0x0e23, 0x0e28, 0x254f, 0x0e24, 0x8000, 0x0c81,
      0x0e25, 0x0e26, 0x277c, 0x0f9b, 0x0f97, 0x0f98, 0x0f99, 0x0f9a,
      0x10dd, 0x29e0, 0x10dc, 0x11fd, 0x29e2, 0x1201, 0x2bb1, 0x1203,
      0x1200, 0x11ff, 0x11fe, 0x2bb2, 0x11fb, 0x1202, 0x2bb4, 0x12c5,
      0x1360, 0x2fc7, 0x2d3d, 0x13e2, 0x30a0, 0x1481, 0x3288, 0x0592,
      0x01b2, 0x0423, 0x0e29, 0x1204, 0x8000, 0x01b3, 0x0742, 0x0741,
      0x8000, 0x29e6, 0x8000, 0x01b4, 0x0594, 0x8000, 0x0e2a, 0x10df,
      0x8000, 0x01b5, 0x0424, 0x1b69, 0x0743, 0x091e, 0x2037, 0x0c86,
      0x0e2b, 0x10e0, 0x1205, 0x12c7, 0x2fc8, 0x8000, 0x01b6, 0x0425,
      0x0744, 0x0ad9, 0x8000, 0x2780, 0x01b7, 0x0ada, 0x0e2d, 0x22d4,
      0x8000, 0x01b8, 0x17da, 0x198b, 0x0745, 0x0748, 0x0746, 0x8000,
      0x0920, 0x091f, 0x0921, 0x0922, 0x1dc0, 0x1dc4, 0x1dc1, 0x1dc3,
      0x0c87, 0x0e2e, 0x22d6, 0x29e8, 0x29e9, 0x2785, 0x10e1, 0x10e2,
      0x2e99, 0x2d40, 0x2fc9, 0x3241, 0x13e3, 0x3151, 0x8000, 0x01b9,
      0x02b1, 0x1206, 0x8000, 0x01ba, 0x1dc5, 0x14db, 0x8000, 0x15bf,
      0x15c2, 0x01bb, 0x1691, 0x1692, 0x1690, 0x02b3, 0x02b4, 0x168d,
      0x168e, 0x02b2, 0x0428, 0x0427, 0x042b, 0x17e9, 0x0432, 0x17ec,
      0x17e2, 0x17e8, 0x042f, 0x17ea, 0x8000, 0x17dd, 0x042e, 0x0429,
      0x17e3, 0x0430, 0x0433, 0x042d, 0x0426, 0x0435, 0x0431, 0x042c,
      0x0749, 0x17e4, 0x042a, 0x8000, 0x0434, 0x05a6, 0x05ab, 0x05a0,
      0x05a8, 0x05a5, 0x1993, 0x05a1, 0x198d, 0x059a, 0x05a4, 0x05a7,
      0x05a9, 0x0599, 0x1999, 0x059d, 0x059b, 0x0596, 0x1995, 0x05a2,
      0x1997, 0x198f, 0x199d, 0x8000, 0x198e, 0x1992, 0x05a3, 0x059e,
      0x0597, 0x059c, 0x1b7c, 0x0598, 0x1990, 0x8000, 0x059f, 0x0757,
      0x074c, 0x1b76, 0x1b77, 0x1b75, 0x075a, 0x074a, 0x1b6d, 0x1b83,
      0x0759, 0x0754, 0x0752, 0x0751, 0x0756, 0x1b82, 0x074e, 0x0755,
      0x0758, 0x075b, 0x0af0, 0x074d, 0x0926, 0x1b85, 0x0750, 0x1b7e,
      0x0753, 0x074f, 0x1b70, 0x074b, 0x8000, 0x1b6e, 0x1dd9, 0x1dcb,
      0x0930, 0x0931, 0x0932, 0x1dd5, 0x8000, 0x092c, 0x0923, 0x092b,
      0x092d, 0x0928, 0x0925, 0x0924, 0x092f, 0x0927, 0x0934, 0x0933,
      0x1dc8, 0x1dd4, 0x1dda, 0x092a, 0x0af4, 0x092e, 0x0929, 0x2040,
      0x0ae2, 0x0ae0, 0x2061, 0x2057, 0x0aed, 0x2062, 0x8000, 0x2055,
      0x0af3, 0x2050, 0x0adf, 0x0af1, 0x0adb, 0x1c2f, 0x0ae3, 0x0ae8,
      0x0ae4, 0x0aec, 0x0ae5, 0x2046, 0x203e, 0x2045, 0x0aeb, 0x204d,
      0x0adc, 0x205c, 0x0ae7, 0x0ae1, 0x0ae9, 0x0ade, 0x0aef, 0x205b,
      0x2052, 0x0aea, 0x22f8, 0x2047, 0x0af2, 0x0c92, 0x0c59, 0x0c8b,
      0x0c93, 0x0aee, 0x2300, 0x0c8a, 0x0c98, 0x0c8f, 0x22e7, 0x0ae6,
      0x8000, 0x22e9, 0x0c91, 0x0c94, 0x0c95, 0x0c8d, 0x0c96, 0x0c8e,
      0x0c90, 0x0c97, 0x2304, 0x8000, 0x22ec, 0x0c8c, 0x0c89, 0x22f5,
      0x22f3, 0x22e8, 0x0c88, 0x22e2, 0x22de, 0x0e3b, 0x8000, 0x2567,
      0x0e33, 0x0e36, 0x2553, 0x0e34, 0x2554, 0x256d, 0x8000, 0x0e35,
      0x0e38, 0x255b, 0x2555, 0x0e3c, 0x0e30, 0x0e39, 0x255d, 0x2557,
      0x0e32, 0x0e31, 0x0e2f, 0x0e3e, 0x0e37, 0x2569, 0x255e, 0x8000,
      0x0e3d, 0x278a, 0x2562, 0x0e3a, 0x8000, 0x2797, 0x256c, 0x2561,
      0x27ae, 0x279d, 0x0fa8, 0x0fa0, 0x27b0, 0x8000, 0x2798, 0x2788,
      0x2795, 0x2a03, 0x279f, 0x0fab, 0x22ee, 0x0faa, 0x27a8, 0x0fa4,
      0x27a0, 0x0fa3, 0x279b, 0x0f9d, 0x0f9f, 0x27aa, 0x278f, 0x0fa6,
      0x0fa5, 0x0fa2, 0x8000, 0x0fa9, 0x27ad, 0x0fa7, 0x27a9, 0x0f9e,
      0x0fa1, 0x2bcc, 0x29fa, 0x10e8, 0x10e9, 0x10e3, 0x29fd, 0x2a00,
      0x29ea, 0x29f0, 0x10e4, 0x2a05, 0x10ec, 0x29ef, 0x29f5, 0x10e6,
      0x10e7, 0x10eb, 0x10ea, 0x2bbd, 0x120d, 0x29f2, 0x10e5, 0x8000,
      0x29f3, 0x2bd5, 0x2bc8, 0x2bcd, 0x1209, 0x2bdd, 0x2bd6, 0x1208,
      0x2bd9, 0x120f, 0x2bd8, 0x2bca, 0x1211, 0x120b, 0x120c, 0x2bd0,
      0x2bd3, 0x120e, 0x13be, 0x120a, 0x1212, 0x1210, 0x12c9, 0x1207,
      0x2bc5, 0x8000, 0x2bbe, 0x12cd, 0x2d47, 0x12cf, 0x12ce, 0x2d49,
      0x2d4c, 0x2d4b, 0x2d4a, 0x12cc, 0x2d4e, 0x12c8, 0x12cb, 0x12ca,
      0x8000, 0x1364, 0x8000, 0x2ea3, 0x2eab, 0x1362, 0x2ea9, 0x1365,
      0x1361, 0x1366, 0x1363, 0x1367, 0x13e5, 0x13e7, 0x8000, 0x13e4,
      0x2fcd, 0x2fcb, 0x2fd1, 0x2fd3, 0x13e8, 0x13ea, 0x13eb, 0x8000,
      0x8000, 0x13e9, 0x2fcf, 0x1434, 0x30ad, 0x2fca, 0x30ac, 0x1433,
      0x8000, 0x31da, 0x30a8, 0x14b4, 0x14b5, 0x31dc, 0x8000, 0x328a,
      0x13e6, 0x15c4, 0x0436, 0x05ac, 0x1b8e, 0x075c, 0x0935, 0x0af5,
      0x0c9a, 0x0c99, 0x0c9b, 0x2579, 0x27b9, 0x2a0a, 0x2a09, 0x1213,
      0x2d58, 0x8000, 0x01bc, 0x0437, 0x17f1, 0x05ad, 0x05af, 0x075f,
      0x1ba5, 0x1ba0, 0x075d, 0x1b99, 0x0762, 0x0763, 0x0760, 0x1b9f,
      0x0761, 0x075e, 0x1b91, 0x093f, 0x1def, 0x093e, 0x1df2, 0x0939,
      0x8000, 0x093a, 0x0938, 0x093c, 0x0937, 0x0940, 0x207e, 0x093d,
      0x0af7, 0x0afa, 0x0af6, 0x2074, 0x0afb, 0x207b, 0x2317, 0x0af8,
      0x0ca1, 0x8000, 0x0ca3, 0x0ca4, 0x0c9f, 0x0c9e, 0x2313, 0x0c9d,
      0x231b, 0x0c9c, 0x0ca2, 0x0ca0, 0x231d, 0x2320, 0x0ca6, 0x231c,
      0x0e45, 0x2597, 0x0e40, 0x2581, 0x257b, 0x0e48, 0x0e43, 0x258f,
      0x2584, 0x0e44, 0x2580, 0x257e, 0x0fac, 0x0e42, 0x257f, 0x27cb,
      0x0fb6, 0x0e46, 0x0fb4, 0x27c0, 0x0fb3, 0x27cd, 0x27cc, 0x0faf,
      0x27d4, 0x27d3, 0x0fb0, 0x27d1, 0x8000, 0x0fae, 0x0e47, 0x8000,
      0x0e41, 0x0fb5, 0x0fb2, 0x27c4, 0x27bb, 0x27bc, 0x0fad, 0x0fb1,
      0x10f1, 0x2a10, 0x10ef, 0x2a15, 0x10ee, 0x10f0, 0x2a18, 0x8000,
      0x10ed, 0x2a1d, 0x1219, 0x8000, 0x121b, 0x121a, 0x2bf6, 0x2bf4,
      0x2bf0, 0x2bf1, 0x2be5, 0x2be2, 0x2be9, 0x2bef, 0x1216, 0x1214,
      0x1218, 0x121c, 0x121d, 0x2d68, 0x2d5e, 0x1217, 0x8000, 0x12d3,
      0x12d1, 0x12d2, 0x2d66, 0x136b, 0x1368, 0x136c, 0x2d61, 0x2eb5,
      0x2eb4, 0x2ebd, 0x2d6b, 0x1369, 0x2eba, 0x136a, 0x13ed, 0x2fdb,
      0x30b1, 0x30b4, 0x1438, 0x1437, 0x1436, 0x1435, 0x3159, 0x14d6,
      0x14b6, 0x31e1, 0x14d5, 0x14f4, 0x8000, 0x01bd, 0x8000, 0x19aa,
      0x1ba7, 0x8000, 0x8000, 0x8000, 0x8000, 0x30b6, 0x8000, 0x01be,
      0x05b0, 0x19ab, 0x0941, 0x1dfb, 0x2081, 0x2080, 0x0afe, 0x0ca7,
      0x27da, 0x0fb8, 0x0fb7, 0x10f2, 0x14d7, 0x8000, 0x01bf, 0x0439,
      0x05b1, 0x0765, 0x1bab, 0x0766, 0x8000, 0x1ba9, 0x0769, 0x1bb1,
      0x1bae, 0x0767, 0x0943, 0x0948, 0x0947, 0x0945, 0x0946, 0x1e09,
      0x8000, 0x1e01, 0x0942, 0x8000, 0x1e0a, 0x1e00, 0x0944, 0x1ba8,
      0x8000, 0x8000, 0x208a, 0x0b01, 0x0aff, 0x0b00, 0x0caf, 0x2325,
      0x2086, 0x8000, 0x0cb1, 0x0ca9, 0x0cb0, 0x0cac, 0x0caa, 0x0cab,
      0x0cad, 0x0ca8, 0x27e5, 0x0e4f, 0x0e51, 0x25a4, 0x259c, 0x0e49,
      0x0e4b, 0x0e4d, 0x25a1, 0x0e4c, 0x0e4e, 0x259f, 0x0fba, 0x0fbe,
      0x27dc, 0x27e6, 0x0e4a, 0x10f3, 0x0fb9, 0x0fbc, 0x27e0, 0x27e1,
      0x10f7, 0x0e50, 0x10f5, 0x2a27, 0x10f6, 0x2a24, 0x10f4, 0x2a23,
      0x2bf9, 0x121f, 0x121e, 0x8000, 0x1220, 0x2d70, 0x2bfd, 0x8000,
      0x136f, 0x2ec1, 0x2d72, 0x2ec5, 0x1370, 0x2ec2, 0x2ec7, 0x136d,
      0x136e, 0x2fdd, 0x1439, 0x2d71, 0x13ee, 0x1221, 0x30ba, 0x30b7,
      0x1483, 0x31e5, 0x1482, 0x328f, 0x31e4, 0x2329, 0x15c5, 0x01c0,
      0x05b2, 0x0b02, 0x12d4, 0x8000, 0x2ec9, 0x8000, 0x8000, 0x02b5,
      0x094a, 0x0949, 0x0b03, 0x2090, 0x0cb2, 0x25a8, 0x10f9, 0x8000,
      0x10f8, 0x1223, 0x2c02, 0x12d5, 0x2eca, 0x8000, 0x13ef, 0x143b,
      0x315e, 0x8000, 0x14f5, 0x8000, 0x8000, 0x02b6, 0x05b3, 0x1e10,
      0x2093, 0x2092, 0x1e12, 0x0cb3, 0x232e, 0x25ab, 0x25ac, 0x27ea,
      0x2a2f, 0x2c05, 0x12d6, 0x13f0, 0x2ecc, 0x1484, 0x3291, 0x8000,
      0x02b7, 0x05b5, 0x05b6, 0x19b1, 0x05b4, 0x0770, 0x076d, 0x076c,
      0x0772, 0x076f, 0x0773, 0x0771, 0x076b, 0x076e, 0x0774, 0x0775,
      0x1bb4, 0x0952, 0x094c, 0x0951, 0x094d, 0x094e, 0x094b, 0x094f,
      0x0950, 0x8000, 0x0953, 0x0b0e, 0x0b10, 0x0b0f, 0x0b08, 0x0b04,
      0x0cc6, 0x0b09, 0x0b0d, 0x209f, 0x8000, 0x2095, 0x0b0c, 0x209e,
      0x0b0a, 0x0b06, 0x0b11, 0x209b, 0x0b0b, 0x0b07, 0x0b05, 0x2338,
      0x0cc1, 0x0cbc, 0x8000, 0x0cb7, 0x0cb8, 0x0cb4, 0x0cc3, 0x0cc0,
      0x0cc2, 0x0cb9, 0x0cbe, 0x0cb5, 0x0cb6, 0x0cbb, 0x2337, 0x2336,
      0x233c, 0x0cbf, 0x0cba, 0x233d, 0x0cc4, 0x0e53, 0x0e56, 0x8000,
      0x0e5e, 0x0e58, 0x0fc3, 0x0e5d, 0x0e5f, 0x0e54, 0x0cbd, 0x0e57,
      0x0e55, 0x0e59, 0x0e5b, 0x0e52, 0x0e5c, 0x0e5a, 0x0fca, 0x0fc6,
      0x0fcd, 0x0fce, 0x0fbf, 0x27f6, 0x0fc9, 0x0fc8, 0x0fc2, 0x0fc1,
      0x0fc7, 0x0fc4, 0x0fcc, 0x27ed, 0x0fc0, 0x27f1, 0x0fcb, 0x27f5,
      0x8000, 0x0fcf, 0x2a35, 0x2a3b, 0x2a38, 0x2a30, 0x2a37, 0x10fa,
      0x1100, 0x10fc, 0x1106, 0x1101, 0x10fd, 0x1107, 0x1105, 0x0fc5,
      0x10fb, 0x2a34, 0x1109, 0x1102, 0x10fe, 0x1103, 0x1104, 0x10ff,
      0x2a3c, 0x2a33, 0x1108, 0x122b, 0x2c0a, 0x2c13, 0x2c10, 0x8000,
      0x1228, 0x1224, 0x122c, 0x2a36, 0x1225, 0x1226, 0x2c16, 0x1227,
      0x122a, 0x8000, 0x1229, 0x2c0d, 0x2c08, 0x2d84, 0x12d7, 0x12da,
      0x12d9, 0x2d7a, 0x12d8, 0x2d80, 0x1371, 0x8000, 0x1374, 0x8000,
      0x1376, 0x1377, 0x2ed8, 0x2ed3, 0x2ed2, 0x1373, 0x1379, 0x1375,
      0x8000, 0x1372, 0x13f3, 0x13f5, 0x13f6, 0x13f2, 0x13f4, 0x13f1,
      0x143c, 0x143d, 0x30bd, 0x143e, 0x1485, 0x3161, 0x8000, 0x14b7,
      0x31e8, 0x31e9, 0x31ea, 0x14d9, 0x14da, 0x14d8, 0x3293, 0x1501,
      0x8000, 0x1507, 0x32cd, 0x32f6, 0x8000, 0x02b8, 0x122e, 0x122d,
      0x8000, 0x8000, 0x02b9, 0x0776, 0x2343, 0x0fd0, 0x0954, 0x1bb5,
      0x0fd1, 0x12db, 0x8000, 0x1510, 0x2c17, 0x02ba, 0x0955, 0x1e1a,
      0x0b12, 0x0cc8, 0x25b5, 0x0e61, 0x110a, 0x0fd2, 0x110b, 0x122f,
      0x2d8c, 0x8000, 0x1693, 0x0778, 0x0777, 0x0b13, 0x2348, 0x234a,
      0x0cca, 0x0cc9, 0x0e63, 0x0e62, 0x110c, 0x2c1d, 0x8000, 0x8000,
      0x02bb, 0x05b7, 0x05b8, 0x0779, 0x077a, 0x1bb8, 0x095b, 0x0959,
      0x095a, 0x0956, 0x0958, 0x0957, 0x0b14, 0x0ccf, 0x0b16, 0x0b1b,
      0x0b1d, 0x0b1f, 0x0b1c, 0x20a7, 0x0b19, 0x0b15, 0x0b17, 0x0b1e,
      0x0b1a, 0x0b18, 0x20a9, 0x0cd1, 0x0cd0, 0x0cce, 0x0cd2, 0x0ccc,
      0x0ccd, 0x0ccb, 0x8000, 0x0e65, 0x0e66, 0x0e64, 0x25b7, 0x2803,
      0x2805, 0x0fdb, 0x2806, 0x0fd4, 0x8000, 0x0fd3, 0x0fdd, 0x0fd9,
      0x0fda, 0x0fd6, 0x0fd5, 0x0fdc, 0x0fd7, 0x2802, 0x0fd8, 0x110d,
      0x2a44, 0x2a45, 0x1230, 0x1234, 0x1232, 0x1231, 0x2d90, 0x1233,
      0x2d91, 0x12dc, 0x137a, 0x137b, 0x2edf, 0x13f8, 0x13f7, 0x30c1,
      0x143f, 0x30c2, 0x1486, 0x8000, 0x1487, 0x14dc, 0x2ee0, 0x02bc,
      0x095d, 0x095c, 0x0e67, 0x0fde, 0x2a49, 0x8000, 0x02bd, 0x05ba,
      0x05b9, 0x1bba, 0x077b, 0x0b22, 0x20ac, 0x0b21, 0x0b20, 0x0e69,
      0x0e68, 0x0fe0, 0x8000, 0x1235, 0x30c3, 0x8000, 0x02be, 0x1bbc,
      0x095e, 0x1e24, 0x095f, 0x1e22, 0x1e21, 0x0b25, 0x20ba, 0x0b28,
      0x0b23, 0x20b5, 0x0b27, 0x20b6, 0x20b3, 0x0b26, 0x0b29, 0x0b24,
      0x20b9, 0x2362, 0x0cd4, 0x0cd3, 0x235e, 0x0cd5, 0x0cd9, 0x2359,
      0x0cd6, 0x235a, 0x0cd7, 0x25bf, 0x25bb, 0x25c0, 0x0e6a, 0x0fe5,
      0x0fe2, 0x2818, 0x2813, 0x0fe3, 0x0fe9, 0x0fe4, 0x280d, 0x2817,
      0x281a, 0x0fe8, 0x0fe7, 0x2816, 0x2a56, 0x1110, 0x1113, 0x2a52,
      0x8000, 0x2a54, 0x2a55, 0x1111, 0x110e, 0x110f, 0x2a50, 0x2c23,
      0x2c25, 0x1238, 0x1236, 0x1239, 0x1441, 0x2c24, 0x12e2, 0x2da1,
      0x12dd, 0x12e1, 0x12de, 0x12e0, 0x2d94, 0x2d9f, 0x2d96, 0x2ee9,
      0x137d, 0x1382, 0x137f, 0x1381, 0x2d9e, 0x2d95, 0x1380, 0x2ee5,
      0x3168, 0x13fa, 0x2feb, 0x13fb, 0x137e, 0x13f9, 0x1440, 0x1442,
      0x1237, 0x316c, 0x1488, 0x316b, 0x1489, 0x3169, 0x316a, 0x14f6,
      0x32cf, 0x1508, 0x8000, 0x2d9d, 0x02bf, 0x077c, 0x8000, 0x0cdc,
      0x12e3, 0x8000, 0x8000, 0x0fea, 0x02c0, 0x043a, 0x05bd, 0x05bc,
      0x077f, 0x077d, 0x077e, 0x0960, 0x0961, 0x20c4, 0x20c6, 0x0b2c,
      0x20be, 0x20bc, 0x0b2d, 0x20bd, 0x0cdf, 0x0cdd, 0x2368, 0x236a,
      0x0cde, 0x2367, 0x2369, 0x0ce0, 0x0e6c, 0x0e6e, 0x0e6b, 0x0e6d,
      0x2826, 0x8000, 0x0fec, 0x0ff1, 0x0feb, 0x0fed, 0x0fef, 0x0fee,
      0x0ff0, 0x0ff2, 0x2823, 0x0ff3, 0x8000, 0x1115, 0x1117, 0x1116,
      0x2a5d, 0x1114, 0x8000, 0x2a5a, 0x2a5f, 0x2a59, 0x123b, 0x123e,
      0x123c, 0x123a, 0x123d, 0x2c27, 0x2da2, 0x2da3, 0x2fef, 0x12e4,
      0x12e5, 0x1384, 0x2eee, 0x2eec, 0x2fed, 0x2ff0, 0x30c6, 0x1443,
      0x148a, 0x3170, 0x31ef, 0x8000, 0x02c1, 0x0b2e, 0x0ce1, 0x8000,
      0x0e6f, 0x8000, 0x1119, 0x1118, 0x1385, 0x1444, 0x8000, 0x02c2,
      0x0780, 0x0ce2, 0x8000, 0x8000, 0x02c3, 0x02c6, 0x02c5, 0x17f6,
      0x17f8, 0x043b, 0x043d, 0x17f7, 0x043c, 0x17fa, 0x05c0, 0x05c5,
      0x05c2, 0x05bf, 0x05c6, 0x05c1, 0x05c4, 0x05c3, 0x19b5, 0x05be,
      0x0786, 0x0783, 0x078a, 0x8000, 0x0788, 0x0785, 0x0784, 0x0781,
      0x1bc3, 0x0787, 0x0789, 0x0782, 0x1e2d, 0x1e30, 0x0963, 0x096d,
      0x0969, 0x1e2e, 0x0971, 0x096a, 0x096f, 0x0965, 0x0962, 0x0964,
      0x0970, 0x0968, 0x096b, 0x0967, 0x096c, 0x1e31, 0x096e, 0x0966,
      0x20cb, 0x0b2f, 0x0b31, 0x0b33, 0x0b30, 0x0b34, 0x0b32, 0x8000,
      0x0ce8, 0x0ceb, 0x0cf1, 0x0ce6, 0x236f, 0x0cf0, 0x0ce4, 0x0ce3,
      0x0cee, 0x0ced, 0x0cec, 0x0cea, 0x0cef, 0x236d, 0x0ce5, 0x0ce7,
      0x0ce9, 0x0e71, 0x0e74, 0x0e78, 0x0e72, 0x0e75, 0x0e70, 0x8000,
      0x0e73, 0x0e76, 0x0e77, 0x0ff6, 0x0ff4, 0x0ff7, 0x0ff5, 0x2829,
      0x111d, 0x111b, 0x111a, 0x2a60, 0x0ff8, 0x111c, 0x2a61, 0x111f,
      0x2a62, 0x111e, 0x1240, 0x123f, 0x1244, 0x1242, 0x1243, 0x1241,
      0x2c28, 0x12e6, 0x12e7, 0x12e8, 0x1386, 0x14b9, 0x14b8, 0x1bc5,
      0x02c8, 0x15c9, 0x8000, 0x15c6, 0x078b, 0x02c9, 0x8000, 0x02cc,
      0x1697, 0x02cb, 0x8000, 0x02ca, 0x169b, 0x17fe, 0x0440, 0x17fc,
      0x17fd, 0x17ff, 0x043e, 0x0441, 0x043f, 0x1800, 0x19b8, 0x05c9,
      0x19bb, 0x19bd, 0x05c7, 0x19bc, 0x05ca, 0x8000, 0x8000, 0x19ba,
      0x1bd1, 0x05c8, 0x078c, 0x078e, 0x1bd4, 0x1bcb, 0x1bd3, 0x1bce,
      0x0972, 0x0973, 0x1e35, 0x0b36, 0x1e32, 0x0974, 0x20d1, 0x0b35,
      0x0cf2, 0x20d0, 0x2377, 0x0b37, 0x0cf3, 0x2376, 0x0e79, 0x0e7a,
      0x25cf, 0x0e7b, 0x25ce, 0x25cd, 0x0ffb, 0x282d, 0x0ffa, 0x0ff9,
      0x0ffc, 0x1120, 0x2a67, 0x2830, 0x1245, 0x2ef3, 0x2da7, 0x3171,
      0x2ff3, 0x30c9, 0x148b, 0x078d, 0x02cd, 0x05cc, 0x05cb, 0x0791,
      0x0790, 0x1bd6, 0x078f, 0x1e3c, 0x0975, 0x20de, 0x0b3a, 0x0b39,
      0x20dc, 0x20db, 0x0cf6, 0x0cf5, 0x0cf4, 0x25d7, 0x0e7c, 0x0e7e,
      0x0e7d, 0x0e7f, 0x25d8, 0x25d6, 0x1000, 0x2833, 0x2834, 0x0ffd,
      0x0ffe, 0x2835, 0x0fff, 0x2a6b, 0x2a69, 0x1121, 0x2a68, 0x1248,
      0x1247, 0x2c30, 0x2c2c, 0x8000, 0x2dae, 0x12e9, 0x12ea, 0x1389,
      0x2dad, 0x13fd, 0x2ff7, 0x2ff6, 0x1445, 0x324e, 0x2836, 0x31f1,
      0x14dd, 0x14f7, 0x324f, 0x8000, 0x1388, 0x02ce, 0x0442, 0x13fe,
      0x0cf7, 0x02cf, 0x05cd, 0x0976, 0x0b3b, 0x12eb, 0x1001, 0x0443,
      0x0794, 0x0792, 0x0795, 0x0793, 0x0979, 0x097a, 0x1e41, 0x0978,
      0x097b, 0x0977, 0x0b43, 0x20e8, 0x0b41, 0x8000, 0x0b42, 0x20e9,
      0x0b3c, 0x0b3d, 0x0b40, 0x0d02, 0x0cfa, 0x237f, 0x8000, 0x0d07,
      0x0d05, 0x0d03, 0x238a, 0x0cf9, 0x0cfe, 0x2383, 0x8000, 0x0d00,
      0x0cff, 0x25dc, 0x0e80, 0x2380, 0x0e82, 0x2384, 0x0e83, 0x25eb,
      0x25e2, 0x0e8b, 0x0e87, 0x0e85, 0x0e84, 0x25dd, 0x0e88, 0x25e4,
      0x1007, 0x283f, 0x1003, 0x8000, 0x1008, 0x284c, 0x2847, 0x2840,
      0x1009, 0x2842, 0x2843, 0x1005, 0x2844, 0x1004, 0x283e, 0x100c,
      0x1124, 0x1128, 0x112a, 0x112c, 0x112f, 0x1250, 0x1131, 0x112b,
      0x1122, 0x1127, 0x112d, 0x124b, 0x1129, 0x1130, 0x1126, 0x2a6e,
      0x112e, 0x124d, 0x124f, 0x1253, 0x2c44, 0x8000, 0x1252, 0x124c,
      0x2c39, 0x1251, 0x2c38, 0x1249, 0x1256, 0x2c40, 0x2c36, 0x124e,
      0x2c41, 0x1254, 0x12ec, 0x2db5, 0x12ee, 0x12f6, 0x12f5, 0x2db3,
      0x2db9, 0x2c33, 0x2db0, 0x2db6, 0x12f2, 0x12f3, 0x12f1, 0x12ed,
      0x138d, 0x138e, 0x138b, 0x1391, 0x1396, 0x1394, 0x138f, 0x138a,
      0x1390, 0x1392, 0x2ef6, 0x1395, 0x138c, 0x2efb, 0x2f01, 0x1397,
      0x1400, 0x3005, 0x2ffa, 0x2efc, 0x13ff, 0x3003, 0x144c, 0x1446,
      0x144b, 0x1448, 0x30cf, 0x144a, 0x30d0, 0x1449, 0x30ce, 0x148c,
      0x3174, 0x3172, 0x148d, 0x148e, 0x14bc, 0x31f3, 0x8000, 0x14bb,
      0x31f2, 0x14ba, 0x14de, 0x14f9, 0x3299, 0x14f8, 0x32ba, 0x1502,
      0x329a, 0x150c, 0x150a, 0x150b, 0x1511, 0x1125, 0x0444, 0x8000,
      0x0445, 0x05ce, 0x0797, 0x1e4e, 0x097d, 0x1e4f, 0x0b47, 0x0b4b,
      0x0b46, 0x0b48, 0x0b4a, 0x0b49, 0x0b45, 0x0d09, 0x239b, 0x0e8c,
      0x0e91, 0x0e8f, 0x0e90, 0x0e8d, 0x0e8e, 0x285e, 0x285d, 0x100d,
      0x100e, 0x2a99, 0x2a97, 0x1132, 0x2a94, 0x2a9c, 0x2a96, 0x2c56,
      0x2c53, 0x125a, 0x2c55, 0x1257, 0x1258, 0x1259, 0x2a95, 0x12f9,
      0x8000, 0x2f0d, 0x12f7, 0x12fa, 0x12f8, 0x2dc9, 0x1398, 0x2f0e,
      0x3018, 0x1402, 0x3017, 0x144d, 0x30da, 0x30d9, 0x125b, 0x0446,
      0x8000, 0x1560, 0x01c1, 0x15cc, 0x169d, 0x02d4, 0x02d1, 0x169e,
      0x02d2, 0x02d0, 0x02d3, 0x0449, 0x1803, 0x0448, 0x0447, 0x044b,
      0x044a, 0x05d0, 0x05cf, 0x05d1, 0x05d2, 0x19c2, 0x079e, 0x079b,
      0x079c, 0x079f, 0x1bdc, 0x079a, 0x0798, 0x0799, 0x079d, 0x097e,
      0x0986, 0x0982, 0x0b53, 0x0980, 0x0983, 0x097f, 0x0984, 0x0985,
      0x0981, 0x1e50, 0x0b4f, 0x8000, 0x0b52, 0x0b54, 0x0b50, 0x0b51,
      0x20fc, 0x20fd, 0x0b4c, 0x0b4e, 0x0b4d, 0x0d0b, 0x0d0c, 0x8000,
      0x23a2, 0x0d0a, 0x0e92, 0x0e94, 0x0e93, 0x8000, 0x2861, 0x1133,
      0x2a9d, 0x1135, 0x2c59, 0x2c5a, 0x125c, 0x2dcb, 0x1399, 0x1134,
      0x8000, 0x125d, 0x8000, 0x044c, 0x07a0, 0x1bdd, 0x0987, 0x0b55,
      0x0b57, 0x0b56, 0x0b58, 0x0b59, 0x0d0f, 0x0d0e, 0x0e95, 0x0d0d,
      0x23a3, 0x0d10, 0x0e96, 0x1136, 0x28dd, 0x125e, 0x2dd0, 0x12fd,
      0x12fe, 0x12fc, 0x2dd1, 0x12ff, 0x12fb, 0x139a, 0x8000, 0x044d,
      0x0989, 0x0988, 0x0b5a, 0x2104, 0x2103, 0x0b5b, 0x0d14, 0x0d11,
      0x0d13, 0x0d12, 0x0e97, 0x8000, 0x2864, 0x100f, 0x2865, 0x1012,
      0x1010, 0x1011, 0x113a, 0x1137, 0x113c, 0x1138, 0x113b, 0x1139,
      0x125f, 0x1260, 0x2dd3, 0x1300, 0x139c, 0x1403, 0x139b, 0x8000,
      0x1450, 0x8000, 0x144e, 0x144f, 0x301a, 0x148f, 0x2dd4, 0x1490,
      0x14e1, 0x14df, 0x3254, 0x14e0, 0x329c, 0x2f14, 0x044e, 0x0d15,
      0x2867, 0x113d, 0x113e, 0x8000, 0x044f, 0x1013, 0x139d, 0x8000,
      0x05d3, 0x113f, 0x8000, 0x14bd, 0x8000, 0x05d4, 0x23a8, 0x0d16,
      0x0e99, 0x0d17, 0x23a9, 0x23aa, 0x2605, 0x8000, 0x1014, 0x1016,
      0x1015, 0x2aa3, 0x1140, 0x2aa2, 0x2c64, 0x2c61, 0x8000, 0x1261,
      0x1302, 0x2dd8, 0x2dd5, 0x1303, 0x2dd6, 0x8000, 0x2f18, 0x8000,
      0x301c, 0x8000, 0x1492, 0x1491, 0x14e2, 0x8000, 0x8000, 0x05d5,
      0x260c, 0x1262, 0x0b5c, 0x260b, 0x286b, 0x8000, 0x2c67, 0x2f19,
      0x2de0, 0x2dde, 0x139e, 0x2f1a, 0x8000, 0x8000, 0x8000, 0x05d6,
      0x8000, 0x2c68, 0x8000, 0x05d7, 0x0e9a, 0x139f, 0x1451, 0x2de1,
      0x31f9, 0x8000, 0x05d8, 0x098c, 0x098d, 0x0b5d, 0x2108, 0x0b5e,
      0x0b5f, 0x0d1d, 0x23ac, 0x0d18, 0x0d19, 0x0d1c, 0x1144, 0x0d1a,
      0x0d1b, 0x23ad, 0x23ae, 0x260d, 0x0e9b, 0x0e9c, 0x286d, 0x1017,
      0x1147, 0x8000, 0x2aa9, 0x286f, 0x1018, 0x1145, 0x8000, 0x1141,
      0x8000, 0x8000, 0x1142, 0x1146, 0x1143, 0x1263, 0x8000, 0x8000,
      0x1307, 0x1305, 0x1306, 0x8000, 0x1309, 0x13a1, 0x2f1d, 0x13a2,
      0x13a0, 0x2f1c, 0x3021, 0x1453, 0x8000, 0x1452, 0x1493, 0x14be,
      0x14e3, 0x14fa, 0x32d3, 0x8000, 0x05d9, 0x260e, 0x0e9d, 0x1264,
      0x2de5, 0x2f20, 0x130a, 0x2f22, 0x13a3, 0x1404, 0x30e2, 0x30e3,
      0x2f21, 0x8000, 0x05da, 0x8000, 0x05db, 0x8000, 0x07a1, 0x1bde,
      0x8000, 0x0b60, 0x0b63, 0x0b61, 0x210a, 0x0b65, 0x0b64, 0x0b62,
      0x0d1f, 0x0d1e, 0x0d20, 0x0d21, 0x23b0, 0x2610, 0x0e9f, 0x0ea0,
      0x2876, 0x0ea2, 0x101b, 0x0ea1, 0x1148, 0x287a, 0x287b, 0x101d,
      0x101c, 0x2879, 0x287c, 0x101e, 0x114b, 0x114d, 0x114c, 0x114a,
      0x2aaa, 0x2aab, 0x2aac, 0x1149, 0x2c71, 0x130e, 0x2c77, 0x2c74,
      0x2c73, 0x8000, 0x2de7, 0x130d, 0x2de6, 0x13a4, 0x2f24, 0x13a5,
      0x302a, 0x3029, 0x3027, 0x3026, 0x1406, 0x1405, 0x3181, 0x1494,
      0x1454, 0x14bf, 0x329e, 0x14fb, 0x8000, 0x05dc, 0x2c79, 0x1e59,
      0x8000, 0x05dd, 0x130f, 0x1407, 0x2613, 0x2c7b, 0x2c7a, 0x8000,
      0x07a2, 0x0b67, 0x0b66, 0x0d22, 0x0d24, 0x0d23, 0x2616, 0x0ea3,
      0x2615, 0x1020, 0x1023, 0x1025, 0x1024, 0x2885, 0x1026, 0x1022,
      0x2886, 0x287d, 0x101f, 0x1021, 0x2ab5, 0x2883, 0x114f, 0x2ab0,
      0x114e, 0x2aaf, 0x1150, 0x8000, 0x2ab3, 0x2c81, 0x1267, 0x8000,
      0x1266, 0x2df0, 0x2c7c, 0x2c87, 0x8000, 0x2dee, 0x1310, 0x2dea,
      0x2de9, 0x13a6, 0x2ded, 0x13a7, 0x30e9, 0x2f30, 0x2f32, 0x2f2d,
      0x2f31, 0x1408, 0x1409, 0x3031, 0x140b, 0x3034, 0x140a, 0x3033,
      0x1458, 0x1457, 0x30eb, 0x30ea, 0x1456, 0x1455, 0x3188, 0x8000,
      0x3189, 0x3185, 0x1496, 0x31fa, 0x1495, 0x3186, 0x14c2, 0x318b,
      0x14c0, 0x8000, 0x31fb, 0x14c1, 0x14e4, 0x1504, 0x32d7, 0x1505,
      0x32e6, 0x1514, 0x2887, 0x07a3, 0x8000, 0x23b6, 0x0ea4, 0x261c,
      0x0ea5, 0x1027, 0x1151, 0x1152, 0x8000, 0x2df3, 0x2c88, 0x1459,
      0x3038, 0x14c5, 0x1497, 0x14c4, 0x14fc, 0x14c3, 0x8000, 0x07a4,
      0x8000, 0x1bdf, 0x0d25, 0x8000, 0x261d, 0x0ea6, 0x261e, 0x288b,
      0x1154, 0x1028, 0x8000, 0x288c, 0x8000, 0x1153, 0x2abe, 0x1313,
      0x2df5, 0x2df7, 0x2f37, 0x13a8, 0x3039, 0x303a, 0x303b, 0x30f1,
      0x8000, 0x318e, 0x1498, 0x31fd, 0x14fd, 0x14e5, 0x2f39, 0x07a5,
      0x1155, 0x102a, 0x2df8, 0x8000, 0x32e8, 0x8000, 0x1be0, 0x1515,
      0x8000, 0x07a6, 0x8000, 0x2df9, 0x2f3b, 0x3190, 0x8000, 0x07a7,
      0x0ea7, 0x0ea8, 0x2890, 0x102c, 0x2dfa, 0x102b, 0x1314, 0x8000,
      0x8000, 0x2c8d, 0x1316, 0x1315, 0x145b, 0x145a, 0x8000, 0x14e6,
      0x8000, 0x098e, 0x2898, 0x102e, 0x2ac1, 0x2892, 0x8000, 0x2ac9,
      0x2aca, 0x2ac8, 0x2c90, 0x126a, 0x2c96, 0x1156, 0x2f45, 0x1268,
      0x1269, 0x131b, 0x1318, 0x2e01, 0x1317, 0x13ab, 0x2f42, 0x13aa,
      0x2f3d, 0x2f40, 0x13a9, 0x1319, 0x8000, 0x8000, 0x303d, 0x140d,
      0x8000, 0x8000, 0x140c, 0x145d, 0x30f7, 0x30f9, 0x145c, 0x319d,
      0x319b, 0x149c, 0x3196, 0x1499, 0x14c6, 0x3200, 0x14e7, 0x3261,
      0x325c, 0x14c7, 0x3208, 0x14c8, 0x329f, 0x150d, 0x150e, 0x2acb,
      0x098f, 0x210b, 0x0d26, 0x23bb, 0x2625, 0x0eab, 0x0ea9, 0x0eaa,
      0x28a6, 0x2ada, 0x102f, 0x28a0, 0x28a4, 0x1030, 0x1031, 0x8000,
      0x115c, 0x2ad2, 0x1158, 0x1159, 0x115a, 0x115b, 0x2ad5, 0x126c,
      0x126d, 0x2ca9, 0x2ca8, 0x2ca4, 0x2e09, 0x131d, 0x131c, 0x131e,
      0x2e0a, 0x13ae, 0x2e13, 0x13b0, 0x2f5c, 0x13af, 0x13ad, 0x2f5d,
      0x13b1, 0x8000, 0x8000, 0x305e, 0x304e, 0x3057, 0x305d, 0x145e,
      0x310f, 0x145f, 0x3109, 0x310c, 0x305c, 0x2f4f, 0x3102, 0x310d,
      0x310b, 0x3108, 0x3100, 0x3101, 0x1460, 0x8000, 0x3107, 0x149e,
      0x149d, 0x31ae, 0x31ac, 0x31aa, 0x14c9, 0x31a9, 0x3214, 0x14e8,
      0x14e9, 0x3213, 0x320b, 0x3218, 0x320e, 0x3264, 0x32a7, 0x326c,
      0x32db, 0x1512, 0x1517, 0x31a8, 0x1516, 0x32f1, 0x8000, 0x0990,
      0x140e, 0x14ea, 0x14eb, 0x3115, 0x8000, 0x0991, 0x0d27, 0x8000,
      0x23bc, 0x28a7, 0x2add, 0x2adb, 0x126e, 0x2e19, 0x8000, 0x2f68,
      0x13b2, 0x13b4, 0x8000, 0x13b3, 0x3063, 0x3062, 0x1462, 0x8000,
      0x14ca, 0x8000, 0x32f4, 0x8000, 0x0992, 0x8000, 0x8000, 0x2caf,
      0x13b5, 0x8000, 0x0993, 0x0eac, 0x1033, 0x8000, 0x0b68, 0x2cb0,
      0x14fe, 0x8000, 0x0b69, 0x126f, 0x1034, 0x321d, 0x8000, 0x0b6a,
      0x115e, 0x115d, 0x1273, 0x1271, 0x1270, 0x1272, 0x131f, 0x3064,
      0x3066, 0x1410, 0x1463, 0x14cb, 0x3118, 0x32c3, 0x150f, 0x8000,
      0x210c, 0x2cb2, 0x2f6a, 0x8000, 0x23bd, 0x2cb3, 0x8000, 0x8000,
      0x14ec, 0x8000, 0x32aa, 0x8000, 0x0d28, 0x28aa, 0x28a9, 0x2ae3,
      0x8000, 0x0d29, 0x1320, 0x8000, 0x2e1d, 0x1464, 0x311a, 0x311c,
      0x8000, 0x0d2a, 0x2cb6, 0x2e1f, 0x1321, 0x1411, 0x8000, 0x3223,
      0x8000, 0x0ead, 0x2ae4, 0x1274, 0x2f6d, 0x8000, 0x8000, 0x0eae,
      0x1275, 0x311e, 0x3226, 0x8000, 0x1036, 0x2cb7, 0x2e24, 0x2f70,
      0x1412, 0x1414, 0x306b, 0x1466, 0x1467, 0x8000, 0x14a0, 0x14a1,
      0x3229, 0x14ee, 0x3273, 0x14ed, 0x1413, 0x115f, 0x8000, 0x14a2,
      0x31b7, 0x8000, 0x1160, 0x8000, 0x2cb8, 0x31b8, 0x8000, 0x819e,
      0x819f, 0x81a0, 0x81a1, 0x81a2, 0x81a3, 0x81a4, 0x81a5, 0x81a6,
      0x81a7, 0x81a8, 0x81a9, 0x81aa, 0x81ab, 0x81ac, 0x81ad, 0x81ae,
      0x81af, 0x81b0, 0x81b1, 0x81b2, 0x81b3, 0x81b4, 0x81b5, 0x81b6,
      0x81b7, 0x81b8, 0x81b9, 0x81ba, 0x81bb, 0x81bc, 0x81bd, 0x81be,
      0x81bf, 0x81c0, 0x81c1, 0x81c2, 0x81c5, 0x81c6, 0x81c7, 0x81c3,
      0x8000, 0x8009, 0x8048, 0x804b, 0x80a0, 0x80a5, 0x804c, 0x804a,
      0x801d, 0x801e, 0x806c, 0x806d, 0x800d, 0x8000, 0x8004, 0x809c,
      0x811a, 0x811b, 0x811c, 0x811d, 0x811e, 0x811f, 0x8120, 0x8121,
      0x8122, 0x8123, 0x8007, 0x8006, 0x8073, 0x8075, 0x8074, 0x8008,
      0x80a6, 0x813a, 0x813b, 0x813c, 0x813d, 0x813e, 0x813f, 0x8140,
      0x8141, 0x8142, 0x8143, 0x8144, 0x8145, 0x8146, 0x8147, 0x8148,
      0x8149, 0x814a, 0x814b, 0x814c, 0x814d, 0x814e, 0x814f, 0x8150,
      0x8151, 0x8152, 0x8153, 0x8025, 0x809d, 0x8026, 0x8000, 0x8063,
      0x8049, 0x8154, 0x8155, 0x8156, 0x8157, 0x8158, 0x8159, 0x815a,
      0x815b, 0x815c, 0x815d, 0x815e, 0x815f, 0x8160, 0x8161, 0x8162,
      0x8163, 0x8164, 0x8165, 0x8166, 0x8167, 0x8168, 0x8169, 0x816a,
      0x816b, 0x816c, 0x816d, 0x8021, 0x8017, 0x8022, 0x8000, 0x151e,
      0x151f, 0x1524, 0x1525, 0x1526, 0x00a0, 0x8000, 0x1527, 0x16a0,
      0x001c, 0x8000, 0x011d, 0x011e, 0x8000, 0x210e, 0x8000, 0x1521,
      0x1528, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x152b, 0x8000, 0x8000, 0x153d, 0x153c, 0x153e, 0x8000,
      0x8000, 0x8000, 0x1541, 0x8000, 0x1565, 0x1567, 0x0128, 0x1569,
      0x1566, 0x1562, 0x1563, 0x8000, 0x8000, 0x156e, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x156a, 0x1570, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x156b, 0x15db,
      0x8000, 0x8000, 0x8000, 0x15dd, 0x8000, 0x15dc, 0x8000, 0x8000,
      0x15cf, 0x15d1, 0x15d2, 0x15d3, 0x15d4, 0x15de, 0x15d6, 0x15d7,
      0x15d9, 0x01c6, 0x01dd, 0x15d5, 0x01d6, 0x16a3, 0x16a5, 0x16a8,
      0x16aa, 0x16ab, 0x16ac, 0x16af, 0x16b0, 0x16b1, 0x16b3, 0x16b6,
      0x16a6, 0x16b7, 0x16b9, 0x8000, 0x16ba, 0x02e2, 0x16a1, 0x16a2,
      0x16a9, 0x02e7, 0x16b4, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x1818, 0x8000,
      0x1815, 0x8000, 0x8000, 0x8000, 0x8000, 0x180f, 0x1806, 0x1808,
      0x1809, 0x180a, 0x180b, 0x180c, 0x180e, 0x1810, 0x1811, 0x1813,
      0x8000, 0x1814, 0x1817, 0x8000, 0x8000, 0x8000, 0x19cb, 0x19cc,
      0x19c8, 0x19ca, 0x19cd, 0x19ce, 0x19d0, 0x19d1, 0x19d2, 0x19d5,
      0x19d6, 0x19d8, 0x19d9, 0x19da, 0x19db, 0x19dc, 0x8000, 0x05f1,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x19dd, 0x8000, 0x07ba, 0x07a9, 0x1bf7, 0x1be2, 0x1bf8, 0x1be4,
      0x1be5, 0x1be6, 0x1be8, 0x1bec, 0x1bee, 0x1bef, 0x1be9, 0x1bf0,
      0x1bf1, 0x8000, 0x07bb, 0x1be7, 0x8000, 0x1bf9, 0x8000, 0x8000,
      0x8000, 0x8000, 0x1bf6, 0x8000, 0x8000, 0x8000, 0x1bfa, 0x8000,
      0x1bfb, 0x8000, 0x1bf2, 0x1bf3, 0x1bf4, 0x07ae, 0x07b7, 0x8000,
      0x1e5f, 0x1e5e, 0x1e67, 0x8000, 0x1e61, 0x0994, 0x1e5a, 0x1e60,
      0x1e5b, 0x1e63, 0x1e64, 0x1e65, 0x8000, 0x1e68, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x2120, 0x8000, 0x2110,
      0x0b74, 0x211b, 0x2117, 0x8000, 0x2111, 0x2112, 0x2113, 0x2114,
      0x0b75, 0x2119, 0x211a, 0x211c, 0x211d, 0x8000, 0x23cb, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x23c8, 0x23c5, 0x23c6,
      0x23c7, 0x23c3, 0x23c4, 0x23bf, 0x2628, 0x2629, 0x262a, 0x262b,
      0x2632, 0x262e, 0x0eb7, 0x8000, 0x8000, 0x8000, 0x8000, 0x2633,
      0x28ab, 0x28af, 0x8000, 0x28ae, 0x28ac, 0x8000, 0x8000, 0x8000,
      0x2aea, 0x2ae9, 0x2ae5, 0x2ae6, 0x1163, 0x2ae7, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x2cb9, 0x2cba,
      0x2e25, 0x2e26, 0x8000, 0x8000, 0x3071, 0x3070, 0x1416, 0x31b9,
      0x8000, 0x8000, 0x80b6, 0x19de, 0x80b7, 0x80b8, 0x80b9, 0x1e69,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x19df, 0x152c, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x16bd, 0x8000, 0x8000, 0x16be, 0x8000, 0x8000, 0x8000,
      0x8000, 0x19e3, 0x8000, 0x8000, 0x8000, 0x1bfe, 0x8000, 0x8000,
      0x8000, 0x1e6a, 0x23cd, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x1542, 0x1574,
      0x1573, 0x1544, 0x15e1, 0x15e2, 0x15e3, 0x8000, 0x8000, 0x16c3,
      0x8000, 0x16c2, 0x8000, 0x8000, 0x046d, 0x0471, 0x8000, 0x8000,
      0x8000, 0x8000, 0x19e7, 0x19e8, 0x19ea, 0x19eb, 0x1bff, 0x1c00,
      0x1c01, 0x0b78, 0x2122, 0x2124, 0x2125, 0x23ce, 0x23cf, 0x2634,
      0x8000, 0x8000, 0x3073, 0x3072, 0x31ba, 0x1575, 0x181b, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x09a5,
      0x8000, 0x8000, 0x8000, 0x2aeb, 0x8000, 0x00bb, 0x8000, 0x8000,
      0x16c6, 0x1e6c, 0x8000, 0x1576, 0x8000, 0x8000, 0x8000, 0x8000,
      0x23d2, 0x28b1, 0x2f72, 0x16c7, 0x181d, 0x1545, 0x8000, 0x8000,
      0x030b, 0x8000, 0x181e, 0x8000, 0x8000, 0x16c8, 0x181f, 0x1820,
      0x8000, 0x8000, 0x19ef, 0x1c06, 0x1e6d, 0x8000, 0x23d3, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x00cd, 0x8000, 0x8000,
      0x8000, 0x8000, 0x0155, 0x014e, 0x8000, 0x157a, 0x8000, 0x8000,
      0x8000, 0x8000, 0x020a, 0x01f7, 0x01f8, 0x8000, 0x8000, 0x15ef,
      0x8000, 0x15ee, 0x020d, 0x15f7, 0x15eb, 0x15ec, 0x15f3, 0x15f4,
      0x8000, 0x15f1, 0x15f2, 0x16ca, 0x16cb, 0x16cc, 0x16cd, 0x0311,
      0x0312, 0x0313, 0x031f, 0x16d2, 0x16d3, 0x16d4, 0x16d5, 0x8000,
      0x16da, 0x16d1, 0x16de, 0x8000, 0x8000, 0x8000, 0x8000, 0x16d8,
      0x8000, 0x16d9, 0x8000, 0x8000, 0x182d, 0x182e, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x0483, 0x0488, 0x0480,
      0x1825, 0x182b, 0x182c, 0x0490, 0x1834, 0x1830, 0x1831, 0x1832,
      0x1827, 0x1828, 0x1836, 0x1a02, 0x8000, 0x8000, 0x19fc, 0x19fd,
      0x19f0, 0x0623, 0x061a, 0x0620, 0x0614, 0x19f1, 0x19f2, 0x19f3,
      0x19f4, 0x19f5, 0x19f7, 0x19fb, 0x8000, 0x1a06, 0x8000, 0x1a05,
      0x19ff, 0x8000, 0x8000, 0x07d2, 0x07d3, 0x07d4, 0x07ce, 0x07cf,
      0x07da, 0x1c0a, 0x1c1b, 0x1c0c, 0x1c07, 0x1c08, 0x1c15, 0x1c16,
      0x1c17, 0x1c18, 0x1c0e, 0x1c0f, 0x1c10, 0x1c11, 0x8000, 0x8000,
      0x8000, 0x8000, 0x07d8, 0x07db, 0x07de, 0x8000, 0x1c1c, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x1c19, 0x8000,
      0x1c12, 0x1c13, 0x1c14, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x1e81, 0x8000, 0x1e83, 0x1e7b, 0x09b6, 0x09ba, 0x09be,
      0x1e70, 0x1e71, 0x1e7c, 0x1e74, 0x1e75, 0x8000, 0x1e7e, 0x1e7f,
      0x8000, 0x1e79, 0x1e73, 0x0b8c, 0x0b81, 0x0b83, 0x212f, 0x2130,
      0x2131, 0x2134, 0x2135, 0x2136, 0x2137, 0x2138, 0x2139, 0x2128,
      0x2129, 0x2133, 0x80bc, 0x8000, 0x8000, 0x212a, 0x212b, 0x212c,
      0x212d, 0x0b8f, 0x0b8a, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x23d6, 0x23dc,
      0x23d8, 0x23de, 0x23df, 0x0d49, 0x0d45, 0x0d3e, 0x0d3f, 0x23da,
      0x23db, 0x23e0, 0x23d4, 0x23d5, 0x2640, 0x2641, 0x2642, 0x2643,
      0x2644, 0x263f, 0x2646, 0x2647, 0x2649, 0x2638, 0x2639, 0x263c,
      0x263d, 0x2648, 0x0ec0, 0x0ec9, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x1042, 0x1044, 0x28bb, 0x28b3, 0x28b4,
      0x28b8, 0x28b9, 0x28b5, 0x28b6, 0x1166, 0x1168, 0x2aec, 0x2aed,
      0x2aee, 0x2aef, 0x2af0, 0x2af1, 0x2af3, 0x2af2, 0x8000, 0x8000,
      0x8000, 0x2af5, 0x8000, 0x8000, 0x8000, 0x1277, 0x2cbc, 0x2cbd,
      0x2cbe, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x2e2c, 0x2e2d, 0x2e2e, 0x2e2a, 0x2e2b, 0x2f74, 0x8000, 0x8000,
      0x3074, 0x3075, 0x3076, 0x3123, 0x3125, 0x8000, 0x8000, 0x14a3,
      0x8000, 0x3274, 0x0159, 0x157b, 0x8000, 0x8000, 0x157c, 0x15fb,
      0x8000, 0x15fc, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x1a07, 0x1c1f, 0x1e85, 0x213d, 0x264a, 0x28be,
      0x8000, 0x32b0, 0x1530, 0x8000, 0x1547, 0x8000, 0x157d, 0x8000,
      0x8000, 0x157f, 0x8000, 0x8000, 0x157e, 0x8000, 0x8000, 0x8000,
      0x15fd, 0x1601, 0x8000, 0x1602, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x15fe, 0x0218, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x16ef, 0x16ec, 0x16e7,
      0x16e8, 0x16e2, 0x16e5, 0x0326, 0x0329, 0x16e1, 0x16ee, 0x16ed,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x1838, 0x1841, 0x049a, 0x1840, 0x1842, 0x183d,
      0x8000, 0x1844, 0x1843, 0x183a, 0x183c, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x1846, 0x8000, 0x8000, 0x8000,
      0x8000, 0x1a11, 0x1a09, 0x1a12, 0x1a13, 0x1a0b, 0x0629, 0x1a0e,
      0x1a0f, 0x1a10, 0x8000, 0x1a14, 0x8000, 0x8000, 0x8000, 0x1a16,
      0x1a0d, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x1c33, 0x1c34, 0x1c31, 0x1c32, 0x1c30, 0x1c29, 0x1c37, 0x1c21,
      0x1c22, 0x1c2a, 0x1c23, 0x1c25, 0x1c2d, 0x8000, 0x1c39, 0x1c27,
      0x1c3b, 0x1c3c, 0x1c36, 0x1c3d, 0x1c3e, 0x1c3f, 0x1c40, 0x1c2c,
      0x062c, 0x1c38, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x1e86, 0x1e87, 0x1e8f, 0x1e8b,
      0x1e98, 0x1e99, 0x09cb, 0x1e8c, 0x1e91, 0x1e95, 0x1e93, 0x8000,
      0x1e97, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x1e92, 0x8000, 0x8000, 0x2149, 0x0b9b, 0x213f, 0x214c, 0x2147,
      0x2148, 0x2143, 0x2144, 0x2145, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x214b, 0x8000, 0x8000, 0x8000,
      0x23e7, 0x23f3, 0x23f4, 0x23f5, 0x23ed, 0x23f0, 0x23e6, 0x23ee,
      0x23f1, 0x23f2, 0x0d56, 0x23ea, 0x23eb, 0x23ec, 0x8000, 0x8000,
      0x23ef, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x2652, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x2653, 0x8000, 0x264f, 0x2650,
      0x2651, 0x264d, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x28c6, 0x28c0, 0x28c4, 0x8000, 0x2af7, 0x2af9, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x1327, 0x2e31, 0x2e32,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x31bb,
      0x31bc, 0x8000, 0x8000, 0x1847, 0x8000, 0x23f6, 0x8000, 0x1531,
      0x16f0, 0x1848, 0x1a18, 0x2e33, 0x1548, 0x8000, 0x8000, 0x8000,
      0x8000, 0x1580, 0x16f1, 0x1a19, 0x8000, 0x1c41, 0x8000, 0x8000,
      0x8000, 0x23f7, 0x8000, 0x8000, 0x2cc2, 0x8000, 0x31bd, 0x1587,
      0x8000, 0x1584, 0x1585, 0x0169, 0x1583, 0x1581, 0x1582, 0x8000,
      0x8000, 0x8000, 0x160d, 0x1606, 0x1607, 0x1605, 0x160e, 0x8000,
      0x160c, 0x1609, 0x160a, 0x160b, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x16f2,
      0x16f3, 0x16f4, 0x16f5, 0x16fe, 0x1700, 0x16fd, 0x16fb, 0x8000,
      0x16f9, 0x1701, 0x16f7, 0x16f8, 0x8000, 0x16fa, 0x16ff, 0x0341,
      0x185b, 0x8000, 0x8000, 0x8000, 0x1855, 0x8000, 0x1858, 0x1859,
      0x185a, 0x1850, 0x1851, 0x184d, 0x1853, 0x185d, 0x8000, 0x1857,
      0x8000, 0x04a2, 0x184a, 0x1a1b, 0x1a1f, 0x1a20, 0x1a23, 0x8000,
      0x8000, 0x8000, 0x8000, 0x1a1c, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x1a21, 0x8000, 0x8000, 0x1a1e, 0x1c42,
      0x1c43, 0x07f8, 0x1c45, 0x1c47, 0x1c52, 0x1c57, 0x8000, 0x1c5c,
      0x8000, 0x1c5a, 0x8000, 0x1c58, 0x1c51, 0x8000, 0x8000, 0x1c61,
      0x8000, 0x1c5f, 0x1c59, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x1c4b, 0x1c4c, 0x1c4d, 0x1c53, 0x1c55, 0x8000, 0x1c5d, 0x1c5e,
      0x8000, 0x8000, 0x1c56, 0x1c5b, 0x1c4e, 0x1c4f, 0x1c50, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x1ead, 0x1eaa,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x09d2, 0x1eb2,
      0x1eb3, 0x1eb0, 0x1ea3, 0x1eb4, 0x1ea1, 0x1ea2, 0x8000, 0x1eb5,
      0x8000, 0x8000, 0x8000, 0x1eae, 0x8000, 0x8000, 0x8000, 0x1eb6,
      0x1ea8, 0x1ea9, 0x1e9d, 0x1ea4, 0x1ea5, 0x1ea6, 0x1eac, 0x8000,
      0x214f, 0x2154, 0x2158, 0x2159, 0x2156, 0x215c, 0x215d, 0x8000,
      0x215a, 0x8000, 0x8000, 0x2162, 0x2161, 0x8000, 0x8000, 0x215b,
      0x215e, 0x215f, 0x8000, 0x8000, 0x23f9, 0x23fa, 0x23fb, 0x23fe,
      0x2403, 0x2400, 0x2401, 0x2404, 0x8000, 0x8000, 0x28d2, 0x8000,
      0x2408, 0x8000, 0x8000, 0x2655, 0x2656, 0x2657, 0x2658, 0x2659,
      0x8000, 0x2660, 0x265b, 0x8000, 0x0ed8, 0x8000, 0x0eda, 0x8000,
      0x8000, 0x8000, 0x8000, 0x1055, 0x28cb, 0x28cc, 0x28cd, 0x28d1,
      0x8000, 0x8000, 0x28d0, 0x8000, 0x28ca, 0x8000, 0x8000, 0x8000,
      0x28cf, 0x8000, 0x2b00, 0x2b02, 0x8000, 0x2b01, 0x8000, 0x8000,
      0x8000, 0x2afe, 0x2afb, 0x2aff, 0x8000, 0x2e34, 0x2e36, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x13bd, 0x8000, 0x8000, 0x3077,
      0x3078, 0x3127, 0x8000, 0x31be, 0x322d, 0x8000, 0x8000, 0x002e,
      0x8000, 0x8000, 0x8000, 0x8000, 0x1703, 0x1a24, 0x063f, 0x1c64,
      0x1c63, 0x8000, 0x240a, 0x8000, 0x2b03, 0x8000, 0x8000, 0x160f,
      0x1610, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x185f, 0x8000,
      0x1a26, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x1ebb, 0x1eb7, 0x1eb8, 0x1eb9, 0x1ebc, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x28d3, 0x2b05, 0x2b04, 0x8000,
      0x8000, 0x8000, 0x8000, 0x1a28, 0x8000, 0x1ebe, 0x8000, 0x154c,
      0x1533, 0x8000, 0x2167, 0x1174, 0x1708, 0x8000, 0x8000, 0x1707,
      0x1860, 0x8000, 0x1a29, 0x1a2a, 0x8000, 0x1c67, 0x0809, 0x8000,
      0x2cc5, 0x8000, 0x154e, 0x8000, 0x158e, 0x8000, 0x8000, 0x8000,
      0x161b, 0x8000, 0x8000, 0x8000, 0x8000, 0x1613, 0x1614, 0x1615,
      0x1616, 0x1617, 0x1618, 0x1619, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x1717, 0x8000, 0x1718, 0x8000, 0x8000,
      0x1709, 0x170a, 0x170b, 0x1712, 0x1714, 0x1715, 0x170f, 0x1710,
      0x171a, 0x170d, 0x1716, 0x1861, 0x1862, 0x1863, 0x1866, 0x1867,
      0x1868, 0x186c, 0x1864, 0x1872, 0x8000, 0x1869, 0x186a, 0x186b,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x1873, 0x8000, 0x8000,
      0x8000, 0x186f, 0x8000, 0x064f, 0x8000, 0x1a2c, 0x1a2d, 0x1a2e,
      0x1a2f, 0x8000, 0x0651, 0x8000, 0x8000, 0x1a30, 0x8000, 0x8000,
      0x0653, 0x1a2b, 0x1c68, 0x1c69, 0x1c6a, 0x0815, 0x1c71, 0x1c6c,
      0x1c6d, 0x1c6e, 0x1c6f, 0x8000, 0x080c, 0x1c72, 0x1c73, 0x1c74,
      0x1c75, 0x1c76, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x1c77, 0x8000, 0x8000, 0x1ec0, 0x1ec1, 0x8000, 0x8000, 0x1ec9,
      0x1eca, 0x1ecb, 0x09e1, 0x1ec6, 0x1ec7, 0x1ec3, 0x1ecd, 0x8000,
      0x1ecf, 0x1ed0, 0x8000, 0x8000, 0x8000, 0x8000, 0x2170, 0x2171,
      0x216f, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x2168, 0x2169,
      0x216b, 0x216c, 0x216e, 0x8000, 0x240f, 0x2410, 0x2411, 0x2412,
      0x8000, 0x8000, 0x2414, 0x2415, 0x2416, 0x2417, 0x241b, 0x8000,
      0x8000, 0x8000, 0x241c, 0x2419, 0x266b, 0x2665, 0x8000, 0x8000,
      0x2667, 0x0ee3, 0x2668, 0x2669, 0x266c, 0x266d, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x28d8, 0x28d9, 0x28da, 0x28db, 0x28dc,
      0x28d4, 0x28d5, 0x28de, 0x28d6, 0x28e0, 0x8000, 0x8000, 0x2cc6,
      0x8000, 0x2e37, 0x8000, 0x8000, 0x8000, 0x8000, 0x2f78, 0x2f79,
      0x8000, 0x8000, 0x307a, 0x8000, 0x3129, 0x312a, 0x8000, 0x158f,
      0x161d, 0x8000, 0x2172, 0x8000, 0x8000, 0x1875, 0x8000, 0x161e,
      0x1877, 0x1878, 0x1879, 0x187a, 0x8000, 0x8000, 0x1a32, 0x1c78,
      0x1c79, 0x8000, 0x2173, 0x2174, 0x8000, 0x241e, 0x241f, 0x266f,
      0x2670, 0x2671, 0x8000, 0x28e1, 0x28e2, 0x28e3, 0x8000, 0x1590,
      0x8000, 0x1552, 0x8000, 0x1621, 0x1622, 0x1623, 0x8000, 0x8000,
      0x8000, 0x8000, 0x187b, 0x187c, 0x187d, 0x187e, 0x187f, 0x1a34,
      0x1a35, 0x1a36, 0x8000, 0x8000, 0x1c7c, 0x1c7d, 0x1c7a, 0x8000,
      0x8000, 0x8000, 0x8000, 0x09ec, 0x8000, 0x8000, 0x2178, 0x217a,
      0x217c, 0x8000, 0x8000, 0x2422, 0x2423, 0x2424, 0x2428, 0x2427,
      0x2426, 0x2420, 0x8000, 0x8000, 0x2673, 0x2675, 0x8000, 0x28e6,
      0x28e7, 0x28e9, 0x8000, 0x8000, 0x2f7a, 0x2f7b, 0x8000, 0x312b,
      0x31c0, 0x8000, 0x1592, 0x8000, 0x1625, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x1593, 0x1626, 0x8000, 0x8000, 0x1882,
      0x1a38, 0x1c7f, 0x8000, 0x242a, 0x0d7a, 0x2677, 0x28ea, 0x8000,
      0x31c1, 0x1722, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x242b,
      0x2bdf, 0x1594, 0x8000, 0x1627, 0x1628, 0x8000, 0x1724, 0x1725,
      0x8000, 0x1c81, 0x1c82, 0x8000, 0x1c83, 0x8000, 0x1ede, 0x8000,
      0x8000, 0x1edc, 0x1edd, 0x8000, 0x8000, 0x2678, 0x8000, 0x2b0a,
      0x2b09, 0x8000, 0x2e39, 0x2f7c, 0x2f7d, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x1596, 0x1595, 0x1635, 0x162d, 0x1726, 0x1727,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x1637, 0x8000,
      0x8000, 0x8000, 0x1632, 0x1633, 0x1634, 0x162f, 0x173c, 0x8000,
      0x1728, 0x172b, 0x172c, 0x172d, 0x172e, 0x1731, 0x1732, 0x1733,
      0x1734, 0x1736, 0x173a, 0x1737, 0x1738, 0x1885, 0x1886, 0x8000,
      0x173b, 0x8000, 0x8000, 0x8000, 0x8000, 0x1890, 0x1892, 0x04d8,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x1887,
      0x1888, 0x1889, 0x188a, 0x188b, 0x188e, 0x8000, 0x8000, 0x8000,
      0x8000, 0x1a4b, 0x8000, 0x8000, 0x1a46, 0x1a48, 0x1a3f, 0x1a40,
      0x1a41, 0x1a49, 0x1c84, 0x1c85, 0x1c86, 0x082f, 0x0833, 0x0836,
      0x1c90, 0x1c8b, 0x1c89, 0x1eef, 0x1c8c, 0x1c8d, 0x1ee1, 0x1ee2,
      0x1c93, 0x1edf, 0x1ee0, 0x8000, 0x1c97, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x1c94, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x1c95, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x1ef1,
      0x8000, 0x8000, 0x8000, 0x1eed, 0x1eee, 0x2180, 0x1ee8, 0x1ee9,
      0x1eea, 0x8000, 0x1eeb, 0x1ef0, 0x1ef3, 0x09f8, 0x8000, 0x8000,
      0x1ef6, 0x1ef4, 0x8000, 0x8000, 0x8000, 0x1ef2, 0x1ef5, 0x8000,
      0x8000, 0x8000, 0x8000, 0x2184, 0x2185, 0x2186, 0x2181, 0x218b,
      0x242e, 0x2189, 0x2187, 0x8000, 0x8000, 0x8000, 0x2689, 0x8000,
      0x2439, 0x243a, 0x243b, 0x2435, 0x2433, 0x2431, 0x2436, 0x2437,
      0x2430, 0x8000, 0x2440, 0x8000, 0x8000, 0x2679, 0x267a, 0x267b,
      0x8000, 0x8000, 0x267c, 0x267d, 0x2686, 0x2687, 0x2683, 0x2684,
      0x267e, 0x267f, 0x2680, 0x2681, 0x8000, 0x8000, 0x28f8, 0x8000,
      0x8000, 0x268a, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x28f5,
      0x28f6, 0x28f0, 0x28f1, 0x28f3, 0x28ee, 0x2b0c, 0x8000, 0x8000,
      0x8000, 0x2cd1, 0x8000, 0x8000, 0x8000, 0x2b0d, 0x2b0e, 0x2b10,
      0x2b11, 0x2b12, 0x2cc9, 0x8000, 0x2ccb, 0x2ccc, 0x2ccd, 0x2cce,
      0x2ccf, 0x2cd0, 0x8000, 0x2cd2, 0x2e3a, 0x2f7e, 0x8000, 0x8000,
      0x31c3, 0x31c4, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x218d, 0x218e, 0x8000, 0x8000, 0x8000, 0x2443, 0x2442, 0x268b,
      0x8000, 0x8000, 0x8000, 0x8000, 0x1639, 0x1898, 0x00f0, 0x1598,
      0x1599, 0x8000, 0x159b, 0x8000, 0x8000, 0x8000, 0x15a0, 0x8000,
      0x1642, 0x1645, 0x8000, 0x1648, 0x8000, 0x8000, 0x8000, 0x8000,
      0x1647, 0x1649, 0x1644, 0x163b, 0x163c, 0x163d, 0x163f, 0x1641,
      0x8000, 0x174c, 0x8000, 0x173f, 0x039f, 0x1746, 0x0386, 0x1740,
      0x1742, 0x1743, 0x8000, 0x8000, 0x8000, 0x8000, 0x174b, 0x174a,
      0x189c, 0x189d, 0x189e, 0x189f, 0x18a0, 0x18a1, 0x18a2, 0x18a3,
      0x18a4, 0x18a5, 0x18a6, 0x1a4e, 0x1a4f, 0x18aa, 0x8000, 0x8000,
      0x8000, 0x18a7, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x18a8,
      0x8000, 0x1a50, 0x1a51, 0x1a53, 0x1a55, 0x1a56, 0x1a5b, 0x1a5c,
      0x1a5e, 0x1a5f, 0x1a61, 0x1a68, 0x0679, 0x8000, 0x8000, 0x8000,
      0x1a5d, 0x0677, 0x8000, 0x1a62, 0x1a66, 0x8000, 0x8000, 0x8000,
      0x8000, 0x1a67, 0x1caa, 0x1cab, 0x1cad, 0x1efa, 0x1cae, 0x1caf,
      0x1cb0, 0x1ef9, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x1cb1,
      0x8000, 0x8000, 0x1cb4, 0x1c9a, 0x1c9c, 0x1ca0, 0x1ca1, 0x1ca2,
      0x0863, 0x1ca5, 0x085a, 0x8000, 0x8000, 0x1cb3, 0x8000, 0x8000,
      0x8000, 0x1efb, 0x1efc, 0x1efd, 0x8000, 0x8000, 0x8000, 0x8000,
      0x1f0b, 0x1efe, 0x1eff, 0x1f01, 0x1f02, 0x1f04, 0x1f11, 0x1f17,
      0x8000, 0x1f07, 0x1f08, 0x1f09, 0x0a1c, 0x1f05, 0x1f0e, 0x2193,
      0x0a0e, 0x0bca, 0x2197, 0x2199, 0x219a, 0x219b, 0x219c, 0x8000,
      0x8000, 0x8000, 0x21b4, 0x219d, 0x219f, 0x21a0, 0x21a2, 0x21a3,
      0x21a5, 0x21a7, 0x21a9, 0x21ab, 0x21ac, 0x0bcb, 0x21ae, 0x21af,
      0x2459, 0x2444, 0x8000, 0x8000, 0x21b3, 0x21b1, 0x8000, 0x8000,
      0x8000, 0x8000, 0x2445, 0x244a, 0x244d, 0x244e, 0x244f, 0x2450,
      0x2451, 0x2452, 0x2453, 0x0d8a, 0x2447, 0x8000, 0x2454, 0x0d93,
      0x2455, 0x2457, 0x2458, 0x268c, 0x268d, 0x245b, 0x8000, 0x8000,
      0x8000, 0x8000, 0x245a, 0x8000, 0x8000, 0x8000, 0x245e, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x0f19, 0x0f1a, 0x2698,
      0x268e, 0x268f, 0x2691, 0x2692, 0x2693, 0x2694, 0x2695, 0x2696,
      0x2697, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x269b, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x2699, 0x8000,
      0x8000, 0x28fe, 0x106f, 0x8000, 0x2900, 0x8000, 0x28fa, 0x28fc,
      0x28fd, 0x8000, 0x8000, 0x8000, 0x2b14, 0x2b17, 0x2b18, 0x8000,
      0x8000, 0x1188, 0x8000, 0x2cd7, 0x2e40, 0x1282, 0x2cd5, 0x2cd6,
      0x2e3b, 0x8000, 0x2cd3, 0x2e3c, 0x2e3d, 0x2e3e, 0x2e3f, 0x1330,
      0x8000, 0x8000, 0x2f7f, 0x2f81, 0x2f82, 0x8000, 0x307d, 0x312c,
      0x312d, 0x312e, 0x8000, 0x8000, 0x8000, 0x8000, 0x322f, 0x8000,
      0x3275, 0x8000, 0x1f1e, 0x2904, 0x174d, 0x18ad, 0x18ae, 0x8000,
      0x8000, 0x1a6a, 0x1a6b, 0x8000, 0x8000, 0x1cb8, 0x1f19, 0x1f1a,
      0x1f1b, 0x1f1c, 0x21b5, 0x8000, 0x8000, 0x245f, 0x8000, 0x269e,
      0x2905, 0x2b1a, 0x8000, 0x8000, 0x2e41, 0x8000, 0x21b6, 0x2cda,
      0x31c7, 0x8000, 0x1f21, 0x2460, 0x18af, 0x26a0, 0x26a1, 0x2b1b,
      0x8000, 0x174f, 0x8000, 0x8000, 0x1cb9, 0x8000, 0x8000, 0x21b7,
      0x0d96, 0x8000, 0x2b1c, 0x2e42, 0x8000, 0x15a2, 0x15a4, 0x8000,
      0x164c, 0x164d, 0x8000, 0x175c, 0x175b, 0x17a4, 0x8000, 0x1751,
      0x1752, 0x1753, 0x1758, 0x1754, 0x1755, 0x03ad, 0x1757, 0x8000,
      0x8000, 0x8000, 0x18ba, 0x18b8, 0x18b9, 0x8000, 0x8000, 0x8000,
      0x8000, 0x04fb, 0x8000, 0x18bd, 0x8000, 0x18b2, 0x18b3, 0x18b5,
      0x18b6, 0x18b7, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x068c, 0x068e, 0x1a70, 0x1a71, 0x1a72, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x1cba, 0x1cbd, 0x1cbe, 0x1cbf, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x1f25, 0x0a2b, 0x1f27, 0x1f28,
      0x1f2b, 0x1f29, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x21bd, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x21b8, 0x21b9, 0x21ba, 0x21bb, 0x21bf, 0x21c0, 0x21bc,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x2463,
      0x2461, 0x2462, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x26a8,
      0x8000, 0x8000, 0x26a3, 0x26a4, 0x26a5, 0x8000, 0x8000, 0x2911,
      0x8000, 0x8000, 0x8000, 0x2910, 0x8000, 0x1079, 0x290f, 0x290b,
      0x1077, 0x1074, 0x8000, 0x290e, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x1191, 0x2b1d, 0x2cde, 0x8000, 0x8000, 0x8000,
      0x2f85, 0x2f86, 0x8000, 0x8000, 0x3230, 0x3231, 0x31c8, 0x175d,
      0x1f2d, 0x2465, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x1a74, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x21c1, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x2912, 0x8000, 0x8000, 0x8000, 0x15a5, 0x15a6, 0x15a7,
      0x15a8, 0x15a9, 0x15aa, 0x15ab, 0x15ac, 0x1651, 0x164f, 0x1656,
      0x1657, 0x8000, 0x8000, 0x8000, 0x1658, 0x8000, 0x8000, 0x8000,
      0x1654, 0x1773, 0x1769, 0x176b, 0x1774, 0x8000, 0x03b7, 0x03c3,
      0x175f, 0x1760, 0x1761, 0x1762, 0x1764, 0x1766, 0x1767, 0x1768,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x1772,
      0x8000, 0x8000, 0x18e4, 0x8000, 0x8000, 0x8000, 0x8000, 0x1771,
      0x8000, 0x18c2, 0x18c3, 0x18c7, 0x18e6, 0x18c9, 0x18cb, 0x18cc,
      0x18e8, 0x18cd, 0x18d0, 0x18d3, 0x18d5, 0x18d6, 0x18d9, 0x8000,
      0x8000, 0x8000, 0x050a, 0x8000, 0x18e5, 0x8000, 0x8000, 0x8000,
      0x18c4, 0x18e1, 0x18e0, 0x18e2, 0x8000, 0x8000, 0x18dd, 0x1a7c,
      0x1a7d, 0x1a81, 0x1a82, 0x1a83, 0x1a84, 0x1a87, 0x1a88, 0x06aa,
      0x1a89, 0x1a8a, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x1a8d, 0x8000, 0x06a9,
      0x1a76, 0x1a77, 0x1a78, 0x1a80, 0x8000, 0x1cde, 0x1cdf, 0x1ce0,
      0x1ce1, 0x1ce3, 0x1ce4, 0x1ce5, 0x1cd3, 0x1cd4, 0x1cdc, 0x8000,
      0x8000, 0x8000, 0x1ce2, 0x1cd8, 0x1cd7, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x0890, 0x0892,
      0x0893, 0x1cc2, 0x1cc5, 0x1cc7, 0x1cc8, 0x1cc9, 0x1ccb, 0x1ccc,
      0x1ccd, 0x1cce, 0x1cd9, 0x1cda, 0x1cdb, 0x1f3e, 0x1f3f, 0x1f40,
      0x1f41, 0x1f42, 0x1f43, 0x1f44, 0x1f45, 0x1f46, 0x1f47, 0x1f48,
      0x1f49, 0x1f4b, 0x0a38, 0x1f5d, 0x1f4e, 0x1f2e, 0x1f50, 0x1f57,
      0x1f58, 0x1f30, 0x1f31, 0x1f32, 0x1f34, 0x1f36, 0x1f38, 0x1f3a,
      0x1f3b, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x1f4f, 0x8000, 0x1f5b, 0x8000,
      0x1f56, 0x1f59, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x1f51,
      0x1f5a, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x21eb,
      0x21e8, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x21cf, 0x21d0, 0x21d1,
      0x21d2, 0x21d3, 0x21d4, 0x21d6, 0x21d9, 0x21db, 0x21dd, 0x21de,
      0x8000, 0x8000, 0x8000, 0x21e2, 0x21e4, 0x8000, 0x8000, 0x8000,
      0x8000, 0x21c3, 0x21c5, 0x21c7, 0x21ca, 0x21cc, 0x21e1, 0x21e9,
      0x21ea, 0x21ec, 0x21ed, 0x8000, 0x8000, 0x8000, 0x248a, 0x8000,
      0x8000, 0x8000, 0x2489, 0x8000, 0x2481, 0x2485, 0x2486, 0x2468,
      0x2469, 0x246a, 0x246d, 0x246e, 0x2470, 0x2471, 0x2474, 0x2475,
      0x2487, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x247a, 0x247c, 0x247d, 0x2488, 0x8000, 0x0dad,
      0x2477, 0x2478, 0x2479, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x2480, 0x8000, 0x26b6, 0x26b7, 0x26b8, 0x26b9, 0x26ba, 0x26bb,
      0x26a9, 0x26aa, 0x26ad, 0x8000, 0x26b0, 0x26b1, 0x26b3, 0x0f2f,
      0x26b4, 0x26c2, 0x8000, 0x26c7, 0x26ca, 0x8000, 0x26ce, 0x26cc,
      0x26c3, 0x8000, 0x8000, 0x8000, 0x26c0, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x26c1, 0x8000, 0x26bc, 0x26be, 0x26c6,
      0x26cd, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x292d, 0x8000,
      0x8000, 0x8000, 0x8000, 0x292a, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x2964, 0x2929, 0x1085, 0x8000, 0x8000, 0x8000,
      0x8000, 0x292e, 0x2913, 0x2914, 0x2915, 0x2918, 0x291a, 0x291b,
      0x291c, 0x291e, 0x2920, 0x2921, 0x2922, 0x2924, 0x2925, 0x8000,
      0x8000, 0x8000, 0x2b24, 0x2b25, 0x2b26, 0x2b27, 0x2b28, 0x2b29,
      0x2b2a, 0x2b2b, 0x2b2c, 0x2b2e, 0x2b31, 0x2b2f, 0x8000, 0x8000,
      0x2b20, 0x2b21, 0x2b1e, 0x1199, 0x119a, 0x8000, 0x2ce1, 0x2ce9,
      0x2ce2, 0x2ce3, 0x8000, 0x8000, 0x2cdf, 0x2ce0, 0x2ce8, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x2e46, 0x2e47,
      0x2e48, 0x2e49, 0x8000, 0x2e4a, 0x1333, 0x2e4d, 0x2e4e, 0x2e45,
      0x8000, 0x8000, 0x8000, 0x8000, 0x2f88, 0x3081, 0x2f8a, 0x2f8b,
      0x8000, 0x8000, 0x8000, 0x8000, 0x307e, 0x307f, 0x8000, 0x8000,
      0x3130, 0x3131, 0x3132, 0x14aa, 0x31c9, 0x8000, 0x3277, 0x3279,
      0x327a, 0x3278, 0x1775, 0x18e9, 0x8000, 0x1a93, 0x1a94, 0x1a95,
      0x1a96, 0x1ce7, 0x1ce8, 0x1cea, 0x1f61, 0x8000, 0x21f3, 0x8000,
      0x21f1, 0x21f2, 0x248d, 0x248e, 0x248f, 0x8000, 0x8000, 0x119d,
      0x1a97, 0x8000, 0x1777, 0x1a98, 0x1a99, 0x1ceb, 0x1cec, 0x1f62,
      0x1f63, 0x1f64, 0x2491, 0x2492, 0x26d0, 0x26d1, 0x26d3, 0x2936,
      0x2b36, 0x2e53, 0x18ec, 0x8000, 0x2493, 0x2494, 0x2939, 0x293a,
      0x2ceb, 0x31cc, 0x1537, 0x1659, 0x8000, 0x119f, 0x8000, 0x1778,
      0x8000, 0x1a9a, 0x1a9b, 0x1a9c, 0x1a9d, 0x1f67, 0x1f68, 0x8000,
      0x8000, 0x21f5, 0x212e, 0x0bfc, 0x2495, 0x26d4, 0x26d5, 0x26d6,
      0x293d, 0x1556, 0x15ad, 0x0193, 0x165a, 0x165b, 0x1779, 0x18f0,
      0x051c, 0x1aa0, 0x06b0, 0x06b1, 0x06b2, 0x1cf0, 0x0898, 0x8000,
      0x8000, 0x1f6a, 0x0a51, 0x0a4f, 0x1557, 0x8000, 0x1558, 0x1559,
      0x8000, 0x155a, 0x8000, 0x8000, 0x8000, 0x15ae, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x15b5, 0x15af, 0x019d,
      0x0196, 0x15b1, 0x15b2, 0x15b4, 0x8000, 0x8000, 0x8000, 0x8000,
      0x166c, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x178f, 0x166e,
      0x8000, 0x0288, 0x165c, 0x165e, 0x1660, 0x1661, 0x0291, 0x1662,
      0x1663, 0x1667, 0x1668, 0x1669, 0x166a, 0x166b, 0x8000, 0x1782,
      0x1783, 0x1789, 0x03ea, 0x178b, 0x052c, 0x8000, 0x8000, 0x1794,
      0x8000, 0x8000, 0x8000, 0x1792, 0x1798, 0x1795, 0x1796, 0x8000,
      0x8000, 0x8000, 0x8000, 0x1799, 0x1786, 0x1787, 0x177b, 0x177f,
      0x1781, 0x190e, 0x1908, 0x8000, 0x8000, 0x1903, 0x8000, 0x8000,
      0x8000, 0x190c, 0x190f, 0x1904, 0x8000, 0x8000, 0x8000, 0x190a,
      0x1907, 0x8000, 0x18f2, 0x18f3, 0x18f4, 0x0530, 0x18fe, 0x1900,
      0x1901, 0x1910, 0x8000, 0x8000, 0x8000, 0x1909, 0x8000, 0x1902,
      0x8000, 0x1ac2, 0x8000, 0x8000, 0x8000, 0x8000, 0x1ac0, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x1abf, 0x8000, 0x1ac5, 0x1ac3,
      0x08a8, 0x8000, 0x1ac1, 0x1abe, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x1ac4, 0x8000, 0x8000, 0x8000, 0x8000, 0x1aa1, 0x1aa3,
      0x1aa4, 0x1aa5, 0x1aa8, 0x06be, 0x1aa9, 0x1aaa, 0x1aab, 0x1aad,
      0x06c5, 0x1aae, 0x1aaf, 0x1ab0, 0x1ab1, 0x1ab2, 0x1ab4, 0x1ab5,
      0x1ab7, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x1d14, 0x1d0b, 0x1d0c,
      0x1d10, 0x8000, 0x8000, 0x1d0d, 0x1d11, 0x8000, 0x1cf2, 0x1cf4,
      0x1cf5, 0x1cf6, 0x1cf8, 0x1cfa, 0x1cfb, 0x1cfc, 0x1cfd, 0x1cfe,
      0x1d01, 0x1d02, 0x1d05, 0x1d06, 0x1d07, 0x1d08, 0x1d09, 0x089f,
      0x1d0e, 0x1d15, 0x8000, 0x8000, 0x1d0f, 0x1d16, 0x1d12, 0x089b,
      0x08ad, 0x1f6b, 0x8000, 0x1f91, 0x8000, 0x8000, 0x8000, 0x1f96,
      0x8000, 0x8000, 0x1f85, 0x1f86, 0x1f87, 0x1f88, 0x1f8b, 0x0a74,
      0x8000, 0x8000, 0x1f9a, 0x8000, 0x1f97, 0x8000, 0x8000, 0x8000,
      0x1f90, 0x8000, 0x1f99, 0x8000, 0x1f94, 0x2214, 0x8000, 0x8000,
      0x8000, 0x1f93, 0x8000, 0x8000, 0x1f6c, 0x1f6d, 0x1f6f, 0x1f71,
      0x1f72, 0x0a56, 0x1f8f, 0x1f74, 0x1f75, 0x1f76, 0x1f77, 0x1f79,
      0x1f7a, 0x1f7b, 0x0a70, 0x1f7c, 0x1f7d, 0x1f7f, 0x1f80, 0x1f81,
      0x1f82, 0x1f83, 0x8000, 0x8000, 0x8000, 0x8000, 0x1f95, 0x1f92,
      0x8000, 0x2216, 0x2220, 0x8000, 0x221b, 0x8000, 0x8000, 0x8000,
      0x8000, 0x221e, 0x221c, 0x8000, 0x8000, 0x8000, 0x2217, 0x8000,
      0x221d, 0x221a, 0x2215, 0x8000, 0x21fa, 0x21fb, 0x21fd, 0x21ff,
      0x2200, 0x2203, 0x2204, 0x2205, 0x8000, 0x2208, 0x2209, 0x220b,
      0x220c, 0x220e, 0x0c12, 0x2210, 0x2212, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x24bf, 0x8000, 0x8000, 0x8000, 0x8000,
      0x2497, 0x2498, 0x8000, 0x8000, 0x8000, 0x24be, 0x8000, 0x8000,
      0x8000, 0x8000, 0x24bd, 0x8000, 0x26f9, 0x8000, 0x8000, 0x26f1,
      0x24ba, 0x8000, 0x8000, 0x8000, 0x24bc, 0x24b7, 0x8000, 0x8000,
      0x24b9, 0x26ff, 0x24bb, 0x2499, 0x249a, 0x249c, 0x249d, 0x249e,
      0x24a0, 0x24a3, 0x24a5, 0x24a6, 0x24a7, 0x8000, 0x24aa, 0x24b3,
      0x8000, 0x24b6, 0x26f4, 0x8000, 0x26ed, 0x26ee, 0x26ef, 0x26e3,
      0x26e4, 0x26e5, 0x26e6, 0x26e7, 0x26e9, 0x26ea, 0x26eb, 0x26ec,
      0x8000, 0x26fc, 0x26f2, 0x8000, 0x8000, 0x8000, 0x26f6, 0x8000,
      0x26f8, 0x8000, 0x26fe, 0x26f7, 0x26fb, 0x8000, 0x8000, 0x0f45,
      0x8000, 0x8000, 0x8000, 0x8000, 0x26f5, 0x8000, 0x8000, 0x8000,
      0x8000, 0x293e, 0x293f, 0x2943, 0x2946, 0x2947, 0x2948, 0x108c,
      0x294b, 0x2b38, 0x2b39, 0x294f, 0x2951, 0x2954, 0x2956, 0x2957,
      0x2959, 0x2952, 0x294e, 0x2950, 0x2958, 0x8000, 0x2b45, 0x8000,
      0x8000, 0x8000, 0x8000, 0x2cf9, 0x8000, 0x2b44, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x2b42, 0x8000, 0x24b5, 0x8000,
      0x8000, 0x2b3a, 0x2b3d, 0x2b3e, 0x2b3c, 0x2b3f, 0x2b40, 0x8000,
      0x2cf5, 0x2cf6, 0x8000, 0x8000, 0x8000, 0x2cfa, 0x8000, 0x8000,
      0x8000, 0x2ced, 0x2cee, 0x2cf1, 0x2cf2, 0x2cf3, 0x2cf4, 0x8000,
      0x2e55, 0x2e58, 0x8000, 0x8000, 0x2e59, 0x2e5b, 0x2e5d, 0x8000,
      0x2e5f, 0x2e5e, 0x8000, 0x8000, 0x2f91, 0x2f92, 0x2f93, 0x2f94,
      0x2f95, 0x2f96, 0x2f97, 0x2f9a, 0x2f9d, 0x8000, 0x2f9b, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x3088, 0x3084, 0x3085,
      0x3086, 0x8000, 0x3089, 0x8000, 0x8000, 0x3136, 0x8000, 0x8000,
      0x3137, 0x31cd, 0x8000, 0x8000, 0x8000, 0x8000, 0x31ce, 0x3234,
      0x3233, 0x32b1, 0x32c7, 0x32c6, 0x32f3, 0x8000, 0x8000, 0x15b6,
      0x8000, 0x166f, 0x8000, 0x8000, 0x8000, 0x179b, 0x179d, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x17a1, 0x8000,
      0x8000, 0x8000, 0x179e, 0x17a2, 0x17a5, 0x8000, 0x8000, 0x8000,
      0x17a0, 0x179f, 0x1912, 0x1913, 0x8000, 0x8000, 0x8000, 0x1916,
      0x8000, 0x8000, 0x8000, 0x1919, 0x8000, 0x1918, 0x1917, 0x8000,
      0x1ad3, 0x8000, 0x1ad6, 0x8000, 0x1acf, 0x8000, 0x1ad7, 0x1ace,
      0x1ad5, 0x1ad8, 0x8000, 0x8000, 0x8000, 0x1acc, 0x1acd, 0x1ad0,
      0x8000, 0x8000, 0x1ad2, 0x8000, 0x1ac7, 0x1ac8, 0x1acb, 0x06ca,
      0x06cd, 0x8000, 0x8000, 0x8000, 0x8000, 0x1d28, 0x8000, 0x8000,
      0x1d20, 0x1d24, 0x8000, 0x1d29, 0x8000, 0x8000, 0x1d2a, 0x1d22,
      0x1d27, 0x8000, 0x8000, 0x1d26, 0x8000, 0x1d23, 0x8000, 0x8000,
      0x8000, 0x8000, 0x08c0, 0x08c1, 0x1d19, 0x1d1a, 0x1d1b, 0x1d1c,
      0x08c3, 0x1d1e, 0x8000, 0x1d1f, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x1fa0, 0x1fa1, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x1fa5, 0x8000,
      0x1fa3, 0x8000, 0x8000, 0x8000, 0x8000, 0x2225, 0x2226, 0x2227,
      0x8000, 0x8000, 0x2234, 0x8000, 0x8000, 0x2230, 0x222e, 0x8000,
      0x8000, 0x8000, 0x222b, 0x2235, 0x8000, 0x8000, 0x8000, 0x2229,
      0x8000, 0x8000, 0x222a, 0x8000, 0x8000, 0x8000, 0x2237, 0x2233,
      0x222f, 0x2232, 0x2222, 0x0c14, 0x0c1f, 0x2224, 0x24c3, 0x24c4,
      0x24c7, 0x24c9, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x24ca, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x270c, 0x8000, 0x8000, 0x2709, 0x8000, 0x8000, 0x270f,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x2969,
      0x2708, 0x270d, 0x2710, 0x270b, 0x270a, 0x270e, 0x2703, 0x2705,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x295b, 0x295d, 0x109b,
      0x10a3, 0x2968, 0x2961, 0x2962, 0x2966, 0x8000, 0x8000, 0x2965,
      0x8000, 0x296b, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x2967, 0x8000, 0x8000, 0x8000, 0x2b48,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x2b4c, 0x8000, 0x2b4a,
      0x2b47, 0x8000, 0x8000, 0x8000, 0x2b46, 0x11b7, 0x8000, 0x8000,
      0x129e, 0x2cff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x2cfb, 0x8000, 0x8000, 0x8000, 0x2e62, 0x2f9c, 0x2e64, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x2fa0, 0x8000, 0x8000, 0x8000, 0x8000, 0x308c, 0x8000, 0x8000,
      0x3138, 0x8000, 0x8000, 0x8000, 0x31cf, 0x8000, 0x3237, 0x8000,
      0x8000, 0x32be, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x24cd, 0x191b, 0x8000, 0x8000, 0x2238, 0x1faa, 0x15b7, 0x0299,
      0x17a6, 0x191d, 0x191e, 0x1ada, 0x8000, 0x1d2e, 0x1d2c, 0x1d2d,
      0x8000, 0x08c6, 0x0a7e, 0x1fab, 0x1fad, 0x1fae, 0x8000, 0x8000,
      0x223a, 0x223b, 0x223c, 0x223d, 0x24d0, 0x24d1, 0x24cf, 0x8000,
      0x8000, 0x8000, 0x2711, 0x2712, 0x0f50, 0x8000, 0x8000, 0x296d,
      0x296e, 0x2e66, 0x2e67, 0x2e68, 0x2e69, 0x2e6a, 0x8000, 0x313a,
      0x327d, 0x8000, 0x155b, 0x155c, 0x15b9, 0x8000, 0x1677, 0x1678,
      0x1672, 0x1673, 0x1675, 0x8000, 0x17a7, 0x17a8, 0x17a9, 0x17aa,
      0x17ab, 0x17ac, 0x17ad, 0x17ae, 0x17af, 0x17b0, 0x1921, 0x1922,
      0x1923, 0x1924, 0x8000, 0x1925, 0x1926, 0x1927, 0x1928, 0x1add,
      0x1ae0, 0x1ae1, 0x1ae2, 0x8000, 0x8000, 0x8000, 0x1fbc, 0x8000,
      0x08ca, 0x1d32, 0x1d33, 0x1fb0, 0x1d36, 0x1d37, 0x1d38, 0x1fba,
      0x1fbb, 0x1fb2, 0x1fb5, 0x1fb6, 0x1fb7, 0x1fb8, 0x1fb9, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x223e, 0x223f, 0x2242, 0x2243,
      0x8000, 0x8000, 0x0f51, 0x24d4, 0x24d5, 0x8000, 0x8000, 0x2715,
      0x2716, 0x2718, 0x2719, 0x271a, 0x271d, 0x296f, 0x2970, 0x2973,
      0x2974, 0x8000, 0x2d00, 0x2fa2, 0x2fa3, 0x308d, 0x313b, 0x31d0,
      0x31d2, 0x06d7, 0x8000, 0x8000, 0x167d, 0x8000, 0x167a, 0x167b,
      0x8000, 0x8000, 0x0401, 0x8000, 0x17b7, 0x8000, 0x17b2, 0x17b3,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x1937,
      0x8000, 0x192e, 0x8000, 0x1931, 0x1936, 0x1939, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x1933, 0x1938, 0x1935, 0x192f, 0x192d,
      0x8000, 0x1aef, 0x1af0, 0x8000, 0x1af2, 0x8000, 0x8000, 0x8000,
      0x1af5, 0x8000, 0x1932, 0x1aee, 0x8000, 0x8000, 0x8000, 0x8000,
      0x1aed, 0x1af4, 0x8000, 0x1af1, 0x8000, 0x1d3c, 0x1d3d, 0x1d3e,
      0x1d3f, 0x1d42, 0x08d2, 0x8000, 0x1d47, 0x8000, 0x1d44, 0x8000,
      0x8000, 0x1d45, 0x1d43, 0x1d49, 0x8000, 0x1d48, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x224e, 0x1fca, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x1fc9, 0x0a84,
      0x1fbf, 0x1fc3, 0x1fc5, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x2245, 0x2246, 0x0c2e, 0x2248, 0x8000, 0x224f,
      0x2252, 0x8000, 0x224c, 0x8000, 0x2251, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x2250, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x2727, 0x24d6, 0x24d9, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x0ddd, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x24dc, 0x24db, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x2726, 0x271f,
      0x2720, 0x2724, 0x8000, 0x8000, 0x8000, 0x2976, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x297b, 0x8000, 0x2977, 0x2b50,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x2b55, 0x8000, 0x8000, 0x8000, 0x2b56, 0x11bd,
      0x11bf, 0x2d04, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x2d07,
      0x8000, 0x2e6b, 0x2fa4, 0x2e6c, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x142a, 0x313f,
      0x8000, 0x8000, 0x8000, 0x8000, 0x17b9, 0x1af7, 0x2253, 0x3239,
      0x17ba, 0x193a, 0x1af9, 0x8000, 0x2255, 0x2256, 0x24dd, 0x24de,
      0x8000, 0x2728, 0x297d, 0x2b59, 0x2b5b, 0x2b5c, 0x8000, 0x2257,
      0x8000, 0x8000, 0x8000, 0x8000, 0x010a, 0x054d, 0x193c, 0x167f,
      0x8000, 0x8000, 0x8000, 0x193e, 0x8000, 0x8000, 0x8000, 0x1d4b,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x272a, 0x8000, 0x297e, 0x8000, 0x8000, 0x17be,
      0x17bf, 0x1b03, 0x1afd, 0x1afe, 0x1aff, 0x1b00, 0x1b01, 0x1d52,
      0x1d4c, 0x1d4e, 0x1d4f, 0x1d51, 0x1fd3, 0x1fd4, 0x1fd5, 0x1fd6,
      0x0a9a, 0x0a97, 0x1fd0, 0x1fd1, 0x8000, 0x2267, 0x2268, 0x225d,
      0x0c38, 0x225e, 0x2261, 0x2262, 0x2264, 0x24e6, 0x24e7, 0x24e3,
      0x24e4, 0x272d, 0x272f, 0x2730, 0x0f5a, 0x8000, 0x297f, 0x2980,
      0x8000, 0x2982, 0x2986, 0x10b0, 0x11c3, 0x2b5f, 0x8000, 0x12a6,
      0x2d0e, 0x2d0f, 0x2e70, 0x1349, 0x308f, 0x8000, 0x32ee, 0x1941,
      0x15bc, 0x1682, 0x8000, 0x8000, 0x1b05, 0x06ed, 0x1d53, 0x8000,
      0x8000, 0x1fd9, 0x8000, 0x8000, 0x8000, 0x2735, 0x2736, 0x2737,
      0x17c0, 0x06ee, 0x226a, 0x2988, 0x2fa7, 0x1942, 0x8000, 0x1b06,
      0x1d55, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x1fda, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x02a2,
      0x17c4, 0x17c1, 0x8000, 0x1944, 0x1946, 0x0560, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x1b07, 0x1b12, 0x1b09,
      0x1b0a, 0x1b0b, 0x1b0c, 0x06f5, 0x1b0e, 0x1b0d, 0x1d5a, 0x1d5c,
      0x1d5d, 0x8000, 0x8000, 0x8000, 0x1d59, 0x8000, 0x8000, 0x1fdd,
      0x1fdf, 0x1fe1, 0x1fe2, 0x1fe3, 0x8000, 0x8000, 0x0aa1, 0x2275,
      0x8000, 0x8000, 0x8000, 0x226c, 0x226f, 0x0c46, 0x2270, 0x2272,
      0x2273, 0x2274, 0x24ea, 0x24eb, 0x24ec, 0x24ed, 0x24ee, 0x8000,
      0x0de7, 0x0de8, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x273a, 0x0f64, 0x8000, 0x2739, 0x0f65, 0x10b6,
      0x2992, 0x298a, 0x298b, 0x298c, 0x298d, 0x298e, 0x2991, 0x8000,
      0x8000, 0x2b64, 0x2b65, 0x2b69, 0x8000, 0x8000, 0x8000, 0x8000,
      0x2d15, 0x12aa, 0x2d16, 0x8000, 0x2e71, 0x2e72, 0x8000, 0x2fa9,
      0x2faa, 0x2fab, 0x3090, 0x31d4, 0x323a, 0x327e, 0x8000, 0x8000,
      0x2277, 0x8000, 0x8000, 0x8000, 0x1fe5, 0x8000, 0x2fad, 0x8000,
      0x8000, 0x17c5, 0x8000, 0x17c7, 0x040b, 0x8000, 0x8000, 0x17c9,
      0x17ca, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x1950, 0x1951, 0x1952, 0x1953, 0x8000, 0x1955, 0x8000, 0x1956,
      0x1b1f, 0x1b1d, 0x8000, 0x8000, 0x06fc, 0x1b14, 0x1b16, 0x1b17,
      0x0700, 0x1b18, 0x06f9, 0x06fa, 0x1b1b, 0x8000, 0x1b1a, 0x8000,
      0x8000, 0x8000, 0x8000, 0x1d69, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x1d68, 0x1d61, 0x1d63, 0x1d64, 0x1d65, 0x1d66, 0x1ff2, 0x8000,
      0x1fe6, 0x1fe8, 0x1feb, 0x1fec, 0x1fee, 0x1fef, 0x8000, 0x8000,
      0x227b, 0x2279, 0x227c, 0x227d, 0x227e, 0x0c4f, 0x0c51, 0x8000,
      0x8000, 0x8000, 0x2286, 0x2285, 0x8000, 0x8000, 0x2282, 0x8000,
      0x0c55, 0x2283, 0x8000, 0x8000, 0x8000, 0x24fb, 0x8000, 0x0dee,
      0x24f3, 0x24f5, 0x24f7, 0x24f9, 0x24ff, 0x8000, 0x24fe, 0x8000,
      0x8000, 0x8000, 0x8000, 0x273c, 0x273d, 0x273e, 0x273f, 0x2741,
      0x8000, 0x2744, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x299f, 0x299b, 0x8000, 0x8000, 0x8000, 0x299d, 0x2994, 0x2995,
      0x2996, 0x2997, 0x2998, 0x2999, 0x2b6d, 0x2b6f, 0x2b71, 0x8000,
      0x8000, 0x2b75, 0x8000, 0x2b77, 0x8000, 0x2b73, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x2d18, 0x2b74, 0x2d19,
      0x2d1a, 0x2e75, 0x2e76, 0x2e78, 0x8000, 0x2e7a, 0x8000, 0x2fae,
      0x2faf, 0x2fb1, 0x2fb3, 0x8000, 0x8000, 0x3093, 0x8000, 0x8000,
      0x3091, 0x3142, 0x8000, 0x8000, 0x323b, 0x3280, 0x8000, 0x17cb,
      0x8000, 0x8000, 0x195b, 0x8000, 0x1958, 0x1959, 0x8000, 0x8000,
      0x1b25, 0x1b26, 0x8000, 0x8000, 0x1d6a, 0x8000, 0x8000, 0x8000,
      0x1d6c, 0x1d6d, 0x1d6e, 0x1d70, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x1ff3, 0x1ff4, 0x2288, 0x228a, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x2506, 0x2507, 0x250a,
      0x8000, 0x8000, 0x8000, 0x8000, 0x2508, 0x8000, 0x2509, 0x8000,
      0x274c, 0x8000, 0x2747, 0x274a, 0x8000, 0x29a0, 0x8000, 0x2d1e,
      0x2d1f, 0x8000, 0x8000, 0x2fb4, 0x8000, 0x8000, 0x8000, 0x323c,
      0x323d, 0x274d, 0x8000, 0x17cd, 0x8000, 0x8000, 0x195e, 0x195f,
      0x1960, 0x1b2f, 0x1b2a, 0x1b2d, 0x8000, 0x8000, 0x070c, 0x8000,
      0x8000, 0x1d72, 0x1d74, 0x8000, 0x1ff9, 0x8000, 0x8000, 0x8000,
      0x1ffb, 0x8000, 0x8000, 0x8000, 0x2294, 0x228c, 0x0c60, 0x228e,
      0x8000, 0x228b, 0x8000, 0x2510, 0x2292, 0x8000, 0x8000, 0x8000,
      0x250b, 0x250c, 0x250d, 0x250e, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x29a3, 0x2b7e, 0x8000, 0x29a2, 0x2b7d, 0x2b7f,
      0x2b7b, 0x8000, 0x8000, 0x8000, 0x8000, 0x2e7c, 0x8000, 0x8000,
      0x2fb5, 0x2fb6, 0x8000, 0x3145, 0x8000, 0x17cf, 0x8000, 0x8000,
      0x1962, 0x8000, 0x1b31, 0x1b34, 0x8000, 0x8000, 0x1d76, 0x1d77,
      0x1d78, 0x8000, 0x8000, 0x1ffc, 0x8000, 0x8000, 0x8000, 0x2296,
      0x2512, 0x2750, 0x274f, 0x0f76, 0x8000, 0x29a7, 0x29a8, 0x2b81,
      0x11d4, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x1b37, 0x8000, 0x8000, 0x1ffe, 0x8000, 0x8000, 0x8000,
      0x2298, 0x8000, 0x2514, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x2fb8, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x1b38, 0x1b3a, 0x1b3b, 0x8000, 0x8000, 0x1b40, 0x1d79,
      0x1d7a, 0x2001, 0x1d7d, 0x1d7e, 0x1d81, 0x1d83, 0x1d86, 0x1d87,
      0x1d88, 0x8000, 0x1d8a, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x1d8b, 0x2006, 0x8000, 0x8000, 0x2005, 0x8000, 0x1d7b,
      0x2002, 0x8000, 0x8000, 0x0c63, 0x229b, 0x22a0, 0x8000, 0x22a6,
      0x8000, 0x8000, 0x8000, 0x8000, 0x22a5, 0x22a2, 0x22a3, 0x8000,
      0x8000, 0x2523, 0x8000, 0x8000, 0x2515, 0x2518, 0x251a, 0x251c,
      0x251f, 0x2522, 0x0e04, 0x8000, 0x8000, 0x2521, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x2752, 0x2756, 0x8000, 0x2758,
      0x8000, 0x10c7, 0x29ad, 0x29ae, 0x29a9, 0x29aa, 0x29b1, 0x8000,
      0x29b5, 0x29b8, 0x29b4, 0x8000, 0x8000, 0x8000, 0x8000, 0x2b8e,
      0x2b90, 0x2b91, 0x2b92, 0x2b83, 0x2b87, 0x2b88, 0x2b89, 0x2b8d,
      0x8000, 0x8000, 0x2b97, 0x8000, 0x8000, 0x2b95, 0x2d22, 0x2d23,
      0x2d26, 0x2d27, 0x2d2a, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x2d2c, 0x8000, 0x8000, 0x2e7e, 0x2e7f, 0x2e80, 0x2e81,
      0x8000, 0x8000, 0x2fb9, 0x2fba, 0x2fbd, 0x8000, 0x2fbc, 0x8000,
      0x3146, 0x8000, 0x8000, 0x8000, 0x14ae, 0x31d6, 0x8000, 0x8000,
      0x8000, 0x17d1, 0x0579, 0x1966, 0x1967, 0x8000, 0x8000, 0x196b,
      0x8000, 0x1b42, 0x1b43, 0x1b44, 0x8000, 0x1b48, 0x1b47, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x1d8f, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x1d8c, 0x200a, 0x2009, 0x8000, 0x8000, 0x22a9,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x0e06, 0x2525,
      0x2526, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x275d, 0x275b,
      0x8000, 0x8000, 0x29b9, 0x29ba, 0x8000, 0x29bd, 0x11de, 0x8000,
      0x8000, 0x2e83, 0x2e84, 0x8000, 0x8000, 0x8000, 0x13db, 0x8000,
      0x32c8, 0x8000, 0x8000, 0x196e, 0x196c, 0x8000, 0x8000, 0x0720,
      0x1b4b, 0x1b4c, 0x1b50, 0x1b51, 0x8000, 0x1d9c, 0x1d9e, 0x8000,
      0x8000, 0x8000, 0x1d92, 0x1d93, 0x1d98, 0x1d99, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x201a, 0x2017, 0x2018,
      0x8000, 0x8000, 0x8000, 0x2019, 0x200c, 0x200d, 0x200e, 0x200f,
      0x2011, 0x2016, 0x2014, 0x8000, 0x8000, 0x22b8, 0x22b7, 0x8000,
      0x8000, 0x22b9, 0x8000, 0x8000, 0x8000, 0x22ac, 0x22af, 0x22b1,
      0x22b2, 0x22b4, 0x22b6, 0x253f, 0x8000, 0x2529, 0x252a, 0x252b,
      0x252d, 0x252e, 0x252f, 0x2531, 0x2533, 0x8000, 0x8000, 0x253e,
      0x8000, 0x8000, 0x2534, 0x2539, 0x253a, 0x253b, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x276c, 0x276b, 0x8000, 0x0f8b, 0x275f, 0x2760, 0x2761, 0x2762,
      0x2765, 0x2766, 0x2768, 0x2769, 0x276a, 0x0f8e, 0x8000, 0x8000,
      0x8000, 0x29d0, 0x29cd, 0x8000, 0x29be, 0x29bf, 0x29c1, 0x29c4,
      0x29c5, 0x29c6, 0x29c8, 0x29cc, 0x11e2, 0x2b9e, 0x2b9f, 0x2ba0,
      0x2ba1, 0x11e7, 0x2ba3, 0x11f1, 0x2b9a, 0x2b9b, 0x2b9d, 0x2ba9,
      0x8000, 0x11f2, 0x8000, 0x8000, 0x8000, 0x8000, 0x2d2d, 0x2d2f,
      0x2d30, 0x2d31, 0x2d33, 0x2d34, 0x2d35, 0x8000, 0x2d37, 0x8000,
      0x8000, 0x2d36, 0x2e85, 0x2e86, 0x2e87, 0x2e88, 0x2e89, 0x2e8b,
      0x2e8c, 0x2e8d, 0x8000, 0x2fc2, 0x8000, 0x8000, 0x309a, 0x31d7,
      0x323f, 0x8000, 0x3287, 0x8000, 0x090e, 0x201e, 0x8000, 0x12c0,
      0x2e90, 0x8000, 0x1b54, 0x1b56, 0x1b57, 0x2020, 0x22bc, 0x22be,
      0x8000, 0x29d2, 0x29d3, 0x29d4, 0x2bac, 0x3240, 0x0417, 0x1971,
      0x8000, 0x8000, 0x8000, 0x1b5b, 0x1da0, 0x1da3, 0x2022, 0x2023,
      0x22c0, 0x22c1, 0x22bf, 0x276e, 0x276f, 0x2770, 0x29d5, 0x8000,
      0x2d39, 0x8000, 0x2e93, 0x8000, 0x2fc3, 0x309e, 0x0583, 0x1972,
      0x1b5c, 0x1b5d, 0x8000, 0x8000, 0x1da5, 0x1da6, 0x1da7, 0x1da8,
      0x1da9, 0x1daa, 0x8000, 0x2024, 0x22c3, 0x8000, 0x2542, 0x8000,
      0x10d9, 0x8000, 0x2771, 0x2773, 0x2776, 0x8000, 0x8000, 0x2bae,
      0x2baf, 0x1975, 0x1b5f, 0x1dac, 0x8000, 0x29d7, 0x2bb0, 0x1684,
      0x8000, 0x8000, 0x17d3, 0x1977, 0x1b60, 0x1b61, 0x8000, 0x8000,
      0x1daf, 0x1db1, 0x8000, 0x8000, 0x8000, 0x8000, 0x2025, 0x2026,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x2547, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x29d9,
      0x11f6, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x2e96, 0x2fc5, 0x8000, 0x8000, 0x155f, 0x17d4, 0x1685, 0x1686,
      0x1687, 0x1688, 0x1689, 0x8000, 0x8000, 0x17d9, 0x8000, 0x17d5,
      0x0421, 0x17d6, 0x17d8, 0x8000, 0x8000, 0x1978, 0x1979, 0x197b,
      0x197c, 0x197d, 0x197e, 0x197f, 0x1980, 0x1982, 0x1983, 0x1984,
      0x1985, 0x8000, 0x073b, 0x8000, 0x1b62, 0x1b63, 0x0735, 0x0738,
      0x1b64, 0x1b65, 0x1b66, 0x1b67, 0x1b68, 0x8000, 0x0739, 0x1dbd,
      0x091c, 0x1db4, 0x0918, 0x1db6, 0x1db7, 0x1dba, 0x1dbb, 0x8000,
      0x1dbe, 0x8000, 0x8000, 0x8000, 0x202a, 0x0ad6, 0x202c, 0x202d,
      0x202e, 0x202f, 0x2030, 0x8000, 0x8000, 0x2031, 0x8000, 0x8000,
      0x8000, 0x22c5, 0x22c7, 0x22c8, 0x22c9, 0x22ca, 0x22cb, 0x22cc,
      0x22cd, 0x22ce, 0x22cf, 0x22d0, 0x0c84, 0x22d2, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x2549, 0x254a, 0x254b, 0x254c,
      0x254d, 0x254e, 0x2779, 0x277a, 0x0f9c, 0x277b, 0x277d, 0x8000,
      0x8000, 0x8000, 0x8000, 0x29da, 0x29db, 0x29dc, 0x29dd, 0x29de,
      0x29df, 0x10de, 0x29e1, 0x29e3, 0x29e4, 0x8000, 0x8000, 0x8000,
      0x8000, 0x2bb3, 0x11fc, 0x2bb5, 0x2bb6, 0x12c6, 0x2d3e, 0x2d3f,
      0x2e97, 0x2e98, 0x8000, 0x2fc6, 0x3150, 0x14b3, 0x3289, 0x8000,
      0x2032, 0x2bb8, 0x2033, 0x2034, 0x2035, 0x198a, 0x8000, 0x8000,
      0x1dbf, 0x2550, 0x0e2c, 0x8000, 0x0595, 0x1b6a, 0x0747, 0x8000,
      0x1dc2, 0x203a, 0x2038, 0x2039, 0x8000, 0x22d5, 0x22d7, 0x22d8,
      0x22d9, 0x8000, 0x8000, 0x2781, 0x2782, 0x2783, 0x2784, 0x2786,
      0x29e7, 0x2bba, 0x2bbb, 0x2bb9, 0x8000, 0x2e9c, 0x2e9a, 0x8000,
      0x2e9b, 0x31d8, 0x8000, 0x203b, 0x8000, 0x15c0, 0x15c1, 0x168a,
      0x168b, 0x168c, 0x168f, 0x198c, 0x17db, 0x17dc, 0x8000, 0x17eb,
      0x17ee, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x17de, 0x17df,
      0x17e0, 0x17e5, 0x17e6, 0x17e7, 0x19a4, 0x8000, 0x8000, 0x8000,
      0x19a0, 0x8000, 0x8000, 0x8000, 0x8000, 0x05aa, 0x1991, 0x1994,
      0x1996, 0x1998, 0x199a, 0x199b, 0x199c, 0x199e, 0x8000, 0x19a2,
      0x8000, 0x19a3, 0x1b8a, 0x8000, 0x8000, 0x1b87, 0x1b6c, 0x1b6f,
      0x1b71, 0x1b72, 0x1b73, 0x1b74, 0x1b78, 0x1b79, 0x1b7a, 0x1b7b,
      0x1b8c, 0x1b8d, 0x18e3, 0x8000, 0x1b8b, 0x1b89, 0x1de2, 0x1b7d,
      0x1b7f, 0x1b80, 0x1b81, 0x1b84, 0x1b86, 0x203c, 0x1dc6, 0x8000,
      0x1de6, 0x1de1, 0x8000, 0x1dc7, 0x1dc9, 0x1dca, 0x1dcc, 0x1dcd,
      0x1dce, 0x1dcf, 0x1dd0, 0x1dd1, 0x1dd2, 0x1dd3, 0x1dd6, 0x1dd7,
      0x1dd8, 0x8000, 0x8000, 0x8000, 0x1de0, 0x1de4, 0x1de3, 0x8000,
      0x8000, 0x8000, 0x1d13, 0x8000, 0x8000, 0x1ddb, 0x1ddc, 0x1ddd,
      0x203d, 0x203f, 0x0add, 0x2041, 0x2042, 0x2043, 0x2044, 0x8000,
      0x2048, 0x2049, 0x8000, 0x204b, 0x204c, 0x204e, 0x204f, 0x2051,
      0x2053, 0x2054, 0x206a, 0x1de7, 0x8000, 0x8000, 0x8000, 0x8000,
      0x205f, 0x2060, 0x2056, 0x2058, 0x2059, 0x205a, 0x205d, 0x205e,
      0x8000, 0x8000, 0x2068, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x2069, 0x8000, 0x8000, 0x8000, 0x8000, 0x2067, 0x206e, 0x2064,
      0x8000, 0x8000, 0x8000, 0x8000, 0x2311, 0x8000, 0x8000, 0x230d,
      0x230f, 0x8000, 0x22fa, 0x22fb, 0x22fc, 0x22fd, 0x22fe, 0x22ff,
      0x2301, 0x2302, 0x2303, 0x8000, 0x22da, 0x8000, 0x22db, 0x22dc,
      0x22dd, 0x22df, 0x22e0, 0x22e1, 0x22e3, 0x22e4, 0x22e5, 0x22e6,
      0x22ea, 0x22eb, 0x22ed, 0x8000, 0x22ef, 0x22f0, 0x22f1, 0x22f2,
      0x22f4, 0x22f6, 0x22f7, 0x22f9, 0x8000, 0x8000, 0x230e, 0x8000,
      0x8000, 0x8000, 0x8000, 0x2308, 0x2309, 0x230a, 0x2307, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x2305, 0x2551, 0x2552, 0x2556, 0x2558, 0x2559, 0x255a,
      0x255c, 0x255f, 0x2560, 0x2563, 0x2564, 0x2565, 0x2566, 0x2568,
      0x256a, 0x256b, 0x256e, 0x256f, 0x2570, 0x2571, 0x2572, 0x8000,
      0x8000, 0x8000, 0x8000, 0x2575, 0x8000, 0x2577, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x2787, 0x2789, 0x278b, 0x278c,
      0x278d, 0x278e, 0x2790, 0x2791, 0x2792, 0x2793, 0x2794, 0x2796,
      0x2799, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x27b6, 0x27b7, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x279a, 0x279c, 0x279e, 0x27a1, 0x27a2, 0x27a3, 0x27a4, 0x27a5,
      0x27a6, 0x27a7, 0x27ab, 0x27ac, 0x27af, 0x29ff, 0x27b1, 0x27b2,
      0x27b3, 0x27b4, 0x27b5, 0x29eb, 0x29ec, 0x29ed, 0x29ee, 0x29f1,
      0x29f4, 0x29f6, 0x29f8, 0x29f9, 0x29fb, 0x29fc, 0x29fe, 0x8000,
      0x8000, 0x8000, 0x8000, 0x2a01, 0x2a02, 0x2a04, 0x8000, 0x8000,
      0x2a08, 0x8000, 0x8000, 0x2a06, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x2a07, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x2bde, 0x2bbc, 0x2bbf, 0x2bc0, 0x2bc1, 0x2bc2,
      0x2bc3, 0x2bc4, 0x2bc6, 0x2bc7, 0x2bc9, 0x2bcb, 0x2bce, 0x2bcf,
      0x2bd1, 0x2bd2, 0x2bd4, 0x2bd7, 0x2d48, 0x2d4d, 0x2d4f, 0x2d50,
      0x2d51, 0x2d52, 0x2d53, 0x2d54, 0x8000, 0x8000, 0x8000, 0x2d55,
      0x2d57, 0x2d56, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x2d42, 0x2d43, 0x2d44, 0x2d45, 0x2d46, 0x8000,
      0x8000, 0x8000, 0x2e9d, 0x2e9e, 0x2e9f, 0x2ea0, 0x2ea1, 0x2ea2,
      0x8000, 0x2ea4, 0x2ea5, 0x2ea7, 0x2ea8, 0x2eaa, 0x2eac, 0x8000,
      0x2eaf, 0x2eb0, 0x30a2, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x2ead, 0x2fcc, 0x2fce, 0x2ea6, 0x2fd0,
      0x2fd2, 0x2fd4, 0x8000, 0x8000, 0x2fd5, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x30a1, 0x8000, 0x30a3, 0x30a4, 0x30a5, 0x30a6,
      0x30a7, 0x30a9, 0x30aa, 0x30ab, 0x30ae, 0x8000, 0x8000, 0x8000,
      0x1432, 0x3157, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x3152, 0x3153, 0x8000, 0x3154, 0x3155, 0x8000, 0x8000, 0x3156,
      0x8000, 0x31d9, 0x31db, 0x31dd, 0x31de, 0x31df, 0x3242, 0x328b,
      0x328c, 0x32e1, 0x32ea, 0x1b8f, 0x2066, 0x1de8, 0x8000, 0x2a0b,
      0x32c9, 0x17f0, 0x17f2, 0x17f3, 0x8000, 0x19a9, 0x8000, 0x8000,
      0x05ae, 0x19a6, 0x19a7, 0x1b90, 0x1b92, 0x1b93, 0x1b94, 0x1b95,
      0x0764, 0x1b96, 0x1b97, 0x1b98, 0x1b9a, 0x1b9b, 0x1b9c, 0x8000,
      0x1ba4, 0x1ba3, 0x1ba2, 0x1b9d, 0x1b9e, 0x8000, 0x8000, 0x093b,
      0x8000, 0x1df8, 0x1dfa, 0x8000, 0x8000, 0x1df9, 0x1de9, 0x1dea,
      0x1deb, 0x1dec, 0x1ded, 0x1dee, 0x1df0, 0x1df1, 0x1df3, 0x1df4,
      0x1df5, 0x1df6, 0x1df7, 0x0af9, 0x2070, 0x2071, 0x2072, 0x2073,
      0x2075, 0x2076, 0x2077, 0x0afc, 0x207d, 0x2078, 0x2079, 0x207a,
      0x207c, 0x2314, 0x2315, 0x2316, 0x2318, 0x2319, 0x231a, 0x0ca5,
      0x231e, 0x231f, 0x2321, 0x8000, 0x2334, 0x8000, 0x257a, 0x0e3f,
      0x257c, 0x257d, 0x2582, 0x2583, 0x2585, 0x2586, 0x2587, 0x2588,
      0x2589, 0x258a, 0x8000, 0x8000, 0x258b, 0x258c, 0x258d, 0x258e,
      0x2590, 0x2591, 0x2592, 0x2593, 0x2594, 0x2595, 0x2596, 0x2598,
      0x2599, 0x8000, 0x27d5, 0x27ba, 0x27bd, 0x27be, 0x27bf, 0x27c1,
      0x27c2, 0x27c3, 0x27c5, 0x27c6, 0x27c7, 0x27c8, 0x27c9, 0x27d7,
      0x8000, 0x8000, 0x8000, 0x27ca, 0x27ce, 0x27cf, 0x27d0, 0x27d2,
      0x2a0c, 0x2a0d, 0x2a0f, 0x2a11, 0x2a12, 0x2a13, 0x2a14, 0x2a16,
      0x2a17, 0x2a19, 0x2a1a, 0x2a1b, 0x2a1c, 0x2a1e, 0x2a1f, 0x2a20,
      0x8000, 0x2a21, 0x8000, 0x2bf3, 0x2bf5, 0x2bf7, 0x8000, 0x8000,
      0x2be0, 0x2be1, 0x2be3, 0x2be4, 0x1215, 0x2be6, 0x2be7, 0x2be8,
      0x2bea, 0x2beb, 0x2bec, 0x2bed, 0x2bee, 0x8000, 0x8000, 0x2bf2,
      0x2d59, 0x2d5a, 0x2d5b, 0x12d0, 0x2d5d, 0x2d5f, 0x2d60, 0x2d62,
      0x2d63, 0x2d64, 0x2d65, 0x2d67, 0x8000, 0x8000, 0x8000, 0x8000,
      0x2d6a, 0x2a0e, 0x2d6c, 0x2d6d, 0x8000, 0x2eb2, 0x2eb3, 0x2eb6,
      0x2eb7, 0x2eb8, 0x2eb9, 0x2ebb, 0x2ebc, 0x8000, 0x8000, 0x8000,
      0x13ec, 0x2fd6, 0x2fd7, 0x2fd8, 0x2fd9, 0x2fda, 0x30af, 0x30b0,
      0x30b2, 0x30b3, 0x30b5, 0x3158, 0x8000, 0x315a, 0x315b, 0x315c,
      0x31e0, 0x31e2, 0x31e3, 0x8000, 0x3243, 0x3244, 0x3245, 0x32b3,
      0x32ca, 0x32cb, 0x32cc, 0x1ba6, 0x207f, 0x3246, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x19ac, 0x19ad, 0x19ae, 0x0768,
      0x1baa, 0x1bac, 0x1bad, 0x076a, 0x1baf, 0x1bb0, 0x1bb2, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x1dfc, 0x1dfd, 0x1dfe,
      0x1dff, 0x1e02, 0x1e03, 0x1e04, 0x1e05, 0x1e06, 0x1e07, 0x1e08,
      0x1e0b, 0x1e0c, 0x2082, 0x2083, 0x2084, 0x2085, 0x2088, 0x2089,
      0x208b, 0x208c, 0x8000, 0x8000, 0x2087, 0x8000, 0x8000, 0x8000,
      0x2322, 0x2323, 0x0cae, 0x2324, 0x2326, 0x2327, 0x2328, 0x8000,
      0x8000, 0x8000, 0x259a, 0x259b, 0x259d, 0x259e, 0x25a0, 0x25a2,
      0x25a3, 0x208d, 0x8000, 0x27db, 0x27dd, 0x27de, 0x8000, 0x27df,
      0x27e2, 0x27e3, 0x27e4, 0x0fbd, 0x0fbb, 0x2a22, 0x2a25, 0x2a26,
      0x2a28, 0x2a29, 0x2a2a, 0x2a2b, 0x2a2e, 0x2bfa, 0x2bfb, 0x2bfc,
      0x2bfe, 0x2bff, 0x2c00, 0x1222, 0x8000, 0x8000, 0x8000, 0x8000,
      0x2d6f, 0x2d73, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x2d74,
      0x2ec0, 0x2ec3, 0x2ec4, 0x2ec6, 0x8000, 0x8000, 0x2fdc, 0x8000,
      0x30b8, 0x30b9, 0x143a, 0x315d, 0x8000, 0x31e6, 0x328d, 0x328e,
      0x8000, 0x1e0f, 0x232b, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x208f, 0x232c, 0x25a7, 0x25a9, 0x27e7, 0x27e8, 0x27e9, 0x2c01,
      0x2c03, 0x8000, 0x2ecb, 0x19af, 0x1e11, 0x2094, 0x232d, 0x232f,
      0x2330, 0x2331, 0x2332, 0x2333, 0x25ad, 0x8000, 0x8000, 0x27eb,
      0x27ec, 0x2c04, 0x2fdf, 0x30bb, 0x3160, 0x31e7, 0x8000, 0x19b0,
      0x1e13, 0x1e14, 0x1e15, 0x1e16, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x2096, 0x2097, 0x2098, 0x2099, 0x209a, 0x209c,
      0x209d, 0x20a0, 0x8000, 0x8000, 0x20a1, 0x8000, 0x8000, 0x8000,
      0x20a3, 0x0cc7, 0x8000, 0x8000, 0x2335, 0x2339, 0x233a, 0x233b,
      0x0cc5, 0x233e, 0x8000, 0x8000, 0x8000, 0x8000, 0x2340, 0x8000,
      0x8000, 0x8000, 0x25ae, 0x25af, 0x25b0, 0x25b1, 0x25b3, 0x25b2,
      0x8000, 0x27fa, 0x8000, 0x27fc, 0x8000, 0x27ee, 0x27ef, 0x27f0,
      0x27f2, 0x27f3, 0x27f4, 0x27f7, 0x27f8, 0x8000, 0x8000, 0x8000,
      0x8000, 0x27f9, 0x8000, 0x27fb, 0x2a3e, 0x8000, 0x8000, 0x8000,
      0x8000, 0x2a31, 0x2a32, 0x2a39, 0x2a3a, 0x2a40, 0x8000, 0x2c06,
      0x2c07, 0x2c09, 0x2c0b, 0x2c0c, 0x2c0e, 0x2c0f, 0x2c11, 0x8000,
      0x8000, 0x8000, 0x2c14, 0x2c15, 0x2c12, 0x2d77, 0x2d78, 0x2d79,
      0x2d7b, 0x2d7c, 0x2d7d, 0x2d7e, 0x2d7f, 0x2d81, 0x2d82, 0x2d83,
      0x8000, 0x8000, 0x8000, 0x2d89, 0x8000, 0x2d87, 0x8000, 0x8000,
      0x2ed9, 0x2ecd, 0x2ece, 0x2ecf, 0x1378, 0x2ed0, 0x2ed1, 0x2ed4,
      0x2ed5, 0x2ed6, 0x2fe0, 0x2fe1, 0x2fe2, 0x2fe3, 0x2fe6, 0x8000,
      0x2fe5, 0x2fe4, 0x8000, 0x30bc, 0x30be, 0x30bf, 0x30c0, 0x8000,
      0x8000, 0x3162, 0x3163, 0x3164, 0x8000, 0x8000, 0x3166, 0x8000,
      0x8000, 0x3165, 0x8000, 0x8000, 0x8000, 0x3247, 0x3248, 0x3292,
      0x1e17, 0x1e18, 0x2342, 0x25b4, 0x27fe, 0x8000, 0x2eda, 0x31ec,
      0x2344, 0x27ff, 0x8000, 0x8000, 0x1bb6, 0x1e19, 0x20a4, 0x2345,
      0x2346, 0x2347, 0x2c18, 0x2c19, 0x2c1a, 0x2c1b, 0x2edb, 0x2edc,
      0x8000, 0x1bb7, 0x1e1b, 0x20a5, 0x20a6, 0x2349, 0x2800, 0x2a41,
      0x2a42, 0x8000, 0x2c1c, 0x2d8d, 0x2d8e, 0x2d8f, 0x2edd, 0x32ce,
      0x8000, 0x1bb9, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x20ab,
      0x20aa, 0x8000, 0x8000, 0x20a8, 0x8000, 0x234b, 0x25b9, 0x2807,
      0x8000, 0x8000, 0x2801, 0x2804, 0x8000, 0x8000, 0x2a48, 0x2a47,
      0x8000, 0x8000, 0x2c1e, 0x8000, 0x8000, 0x8000, 0x2ede, 0x8000,
      0x8000, 0x8000, 0x3167, 0x31ed, 0x234c, 0x234d, 0x2a4a, 0x8000,
      0x8000, 0x8000, 0x8000, 0x19b2, 0x1bbb, 0x8000, 0x8000, 0x1e1e,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x20ad, 0x8000, 0x8000,
      0x234e, 0x234f, 0x2350, 0x2351, 0x2352, 0x2353, 0x2356, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x25ba, 0x8000, 0x0fdf, 0x2808,
      0x2809, 0x280a, 0x8000, 0x8000, 0x280b, 0x8000, 0x2a4b, 0x2a4c,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x2ee1, 0x2ee2,
      0x2ee3, 0x2ee4, 0x2fe8, 0x8000, 0x8000, 0x32b4, 0x05bb, 0x1bbd,
      0x1e20, 0x1e23, 0x20af, 0x20b0, 0x20b1, 0x20b2, 0x20b4, 0x20b7,
      0x20b8, 0x0b2a, 0x8000, 0x2363, 0x0cda, 0x2357, 0x2358, 0x0cd8,
      0x235b, 0x235c, 0x235d, 0x0cdb, 0x235f, 0x2360, 0x2361, 0x25bc,
      0x25bd, 0x25be, 0x25c1, 0x25c2, 0x25c3, 0x25c4, 0x25c5, 0x8000,
      0x8000, 0x8000, 0x25c6, 0x8000, 0x281e, 0x8000, 0x281c, 0x280c,
      0x0fe1, 0x280e, 0x280f, 0x2810, 0x2811, 0x2812, 0x2814, 0x2815,
      0x0fe6, 0x2819, 0x281b, 0x8000, 0x8000, 0x2a4d, 0x2a4e, 0x2a4f,
      0x1112, 0x2a51, 0x2a53, 0x8000, 0x2c22, 0x8000, 0x2c20, 0x2c21,
      0x2d97, 0x2d98, 0x2d99, 0x2d9a, 0x2d9b, 0x2d9c, 0x2da0, 0x12df,
      0x8000, 0x8000, 0x137c, 0x2ee6, 0x2ee7, 0x2ee8, 0x2eea, 0x2fe9,
      0x2fea, 0x13fc, 0x30c4, 0x316d, 0x316e, 0x31ee, 0x3249, 0x324a,
      0x324b, 0x324c, 0x3294, 0x3295, 0x3296, 0x8000, 0x32b5, 0x32e2,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x2a58, 0x2eeb, 0x8000, 0x8000, 0x8000, 0x8000, 0x32d0, 0x1bbf,
      0x1bc0, 0x1e25, 0x1e26, 0x1e27, 0x1e28, 0x8000, 0x8000, 0x1e2a,
      0x8000, 0x20c9, 0x20ca, 0x20bb, 0x0b2b, 0x20bf, 0x20c0, 0x20c1,
      0x20c2, 0x20c3, 0x20c5, 0x20c7, 0x20c8, 0x8000, 0x2364, 0x2365,
      0x2366, 0x236b, 0x236c, 0x25cb, 0x25c8, 0x25c9, 0x8000, 0x8000,
      0x8000, 0x8000, 0x2820, 0x2821, 0x2822, 0x2824, 0x2825, 0x281f,
      0x2a5b, 0x2a5c, 0x2a5e, 0x8000, 0x8000, 0x8000, 0x2c26, 0x8000,
      0x8000, 0x8000, 0x2da4, 0x2eed, 0x1383, 0x2eef, 0x2ef0, 0x2fee,
      0x2ff1, 0x2fec, 0x30c7, 0x30c8, 0x316f, 0x31f0, 0x8000, 0x8000,
      0x2ef1, 0x8000, 0x8000, 0x8000, 0x1695, 0x1694, 0x02c4, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x17f5, 0x17f9, 0x8000,
      0x8000, 0x8000, 0x8000, 0x19b3, 0x8000, 0x8000, 0x19b6, 0x19b4,
      0x8000, 0x1bc7, 0x1bc1, 0x1bc2, 0x1bc4, 0x1bc6, 0x1e2c, 0x1e2f,
      0x8000, 0x8000, 0x20cc, 0x20cd, 0x8000, 0x8000, 0x8000, 0x8000,
      0x236e, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x2371, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x282b, 0x8000, 0x2827, 0x2828,
      0x2a63, 0x8000, 0x2c29, 0x8000, 0x8000, 0x8000, 0x1387, 0x2ff2,
      0x15c7, 0x15ca, 0x8000, 0x1696, 0x1698, 0x1699, 0x169a, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x19b7, 0x19b9, 0x8000, 0x8000, 0x8000, 0x19bf, 0x1bc9, 0x1bca,
      0x8000, 0x1bcc, 0x1bcd, 0x1bcf, 0x1bd0, 0x1bd2, 0x8000, 0x8000,
      0x8000, 0x1e33, 0x1e34, 0x1e36, 0x1e37, 0x1e38, 0x1e39, 0x8000,
      0x20ce, 0x20cf, 0x0b38, 0x8000, 0x20da, 0x2a64, 0x20d2, 0x20d3,
      0x20d4, 0x20d5, 0x20d6, 0x20d7, 0x20d8, 0x20d9, 0x8000, 0x2372,
      0x2373, 0x2374, 0x2375, 0x2378, 0x2379, 0x25cc, 0x25d0, 0x25d1,
      0x25d2, 0x25d3, 0x25d4, 0x25d5, 0x2da6, 0x8000, 0x282c, 0x282e,
      0x282f, 0x2831, 0x2832, 0x8000, 0x2a65, 0x2a66, 0x2c2a, 0x8000,
      0x2da8, 0x2da9, 0x2ef2, 0x2ff4, 0x30cb, 0x30ca, 0x1bd5, 0x1bd7,
      0x8000, 0x1e3d, 0x1e3e, 0x1e3f, 0x8000, 0x8000, 0x8000, 0x8000,
      0x20df, 0x8000, 0x20dd, 0x8000, 0x237a, 0x237b, 0x8000, 0x25d9,
      0x8000, 0x8000, 0x2839, 0x8000, 0x8000, 0x2a6a, 0x8000, 0x1246,
      0x2c2b, 0x2c2d, 0x2c2e, 0x2c2f, 0x8000, 0x8000, 0x8000, 0x2c31,
      0x2daa, 0x2dab, 0x2dac, 0x8000, 0x2ef4, 0x2ef5, 0x8000, 0x2ff5,
      0x2ff8, 0x8000, 0x30cc, 0x8000, 0x324d, 0x32b6, 0x1509, 0x19c0,
      0x1bd8, 0x0796, 0x1bd9, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x1e42, 0x1e43, 0x1e44, 0x097c, 0x1e45, 0x1e46, 0x1e47,
      0x1e49, 0x1e4a, 0x1e4c, 0x8000, 0x1e48, 0x8000, 0x1e4b, 0x20e6,
      0x20e7, 0x20ea, 0x0b44, 0x20eb, 0x20ec, 0x8000, 0x8000, 0x20ef,
      0x8000, 0x8000, 0x8000, 0x8000, 0x20f3, 0x20f2, 0x8000, 0x20f1,
      0x0b3e, 0x0b3f, 0x20e0, 0x20e1, 0x20e2, 0x20e3, 0x20e4, 0x20e5,
      0x20ed, 0x20f0, 0x20f4, 0x20f5, 0x8000, 0x8000, 0x8000, 0x8000,
      0x0d08, 0x238e, 0x8000, 0x8000, 0x8000, 0x8000, 0x237c, 0x237d,
      0x237e, 0x0cf8, 0x0cfb, 0x0d04, 0x2381, 0x2382, 0x2386, 0x0d06,
      0x2387, 0x0d01, 0x0cfc, 0x0cfd, 0x2388, 0x2389, 0x238b, 0x238c,
      0x238d, 0x238f, 0x8000, 0x8000, 0x8000, 0x2390, 0x2393, 0x2396,
      0x2398, 0x8000, 0x239a, 0x2391, 0x8000, 0x2399, 0x8000, 0x8000,
      0x8000, 0x8000, 0x2394, 0x2392, 0x25ed, 0x8000, 0x25f7, 0x8000,
      0x8000, 0x25ef, 0x25fa, 0x25f3, 0x8000, 0x8000, 0x8000, 0x8000,
      0x25fc, 0x8000, 0x25f5, 0x25ec, 0x8000, 0x8000, 0x0e89, 0x25da,
      0x0e8a, 0x25db, 0x0e86, 0x25de, 0x25df, 0x25e0, 0x25e1, 0x25e3,
      0x25e5, 0x25e6, 0x25e7, 0x25e8, 0x25e9, 0x25ea, 0x8000, 0x25f0,
      0x25f6, 0x25fb, 0x8000, 0x8000, 0x8000, 0x25f4, 0x25f8, 0x8000,
      0x100a, 0x100b, 0x2845, 0x2846, 0x2848, 0x2849, 0x284a, 0x284b,
      0x1006, 0x2856, 0x2851, 0x8000, 0x8000, 0x8000, 0x25f1, 0x8000,
      0x8000, 0x2859, 0x2850, 0x8000, 0x8000, 0x8000, 0x2858, 0x8000,
      0x8000, 0x2854, 0x8000, 0x284d, 0x8000, 0x2855, 0x283a, 0x283b,
      0x283c, 0x283d, 0x1002, 0x2841, 0x0e81, 0x8000, 0x2852, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x2a6d, 0x2a6f, 0x2a70,
      0x2a71, 0x2a72, 0x2a73, 0x1123, 0x2a74, 0x2a75, 0x2a76, 0x2a77,
      0x2a78, 0x2a79, 0x2a7a, 0x2a7b, 0x2a7c, 0x2a7d, 0x2a7e, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x2a80, 0x2a84, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x2a90, 0x2a87, 0x8000, 0x8000,
      0x2a92, 0x2a8c, 0x2a93, 0x2a88, 0x2a8b, 0x2a85, 0x2a91, 0x285b,
      0x2a7f, 0x8000, 0x2a8f, 0x8000, 0x8000, 0x2a81, 0x2a8e, 0x8000,
      0x8000, 0x2a86, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x2a83, 0x8000, 0x8000, 0x2a8a, 0x8000, 0x8000, 0x8000,
      0x2c45, 0x2c49, 0x8000, 0x2c47, 0x8000, 0x2c4a, 0x2dc1, 0x8000,
      0x8000, 0x2c48, 0x8000, 0x8000, 0x8000, 0x2c50, 0x8000, 0x2c46,
      0x8000, 0x8000, 0x8000, 0x8000, 0x2c34, 0x2c35, 0x2c37, 0x2c3a,
      0x2c3b, 0x2c3c, 0x2c3d, 0x1255, 0x2c3e, 0x2c3f, 0x2c42, 0x2c43,
      0x124a, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x2c6c,
      0x8000, 0x8000, 0x8000, 0x8000, 0x2dbd, 0x8000, 0x8000, 0x2c4e,
      0x8000, 0x8000, 0x8000, 0x8000, 0x2c52, 0x8000, 0x8000, 0x8000,
      0x2dc4, 0x2dc7, 0x8000, 0x2dbb, 0x2dc0, 0x2dbe, 0x8000, 0x2dbc,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x2dc5, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x2dc2, 0x8000, 0x2dbf, 0x2daf,
      0x2db1, 0x2db2, 0x12f4, 0x2db4, 0x2db7, 0x2db8, 0x12ef, 0x12f0,
      0x2dba, 0x2c51, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x2f07,
      0x2f06, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x2f05, 0x2f03, 0x8000, 0x8000, 0x8000, 0x8000, 0x2dc8,
      0x2f04, 0x8000, 0x8000, 0x8000, 0x8000, 0x2ef7, 0x2ef8, 0x2ef9,
      0x2efa, 0x2efd, 0x2efe, 0x2eff, 0x2f00, 0x2f02, 0x1393, 0x2f08,
      0x8000, 0x8000, 0x8000, 0x8000, 0x2f0b, 0x2f09, 0x1401, 0x300a,
      0x300d, 0x8000, 0x8000, 0x8000, 0x8000, 0x3016, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x3015, 0x8000, 0x3013, 0x8000,
      0x300c, 0x8000, 0x8000, 0x300e, 0x8000, 0x3010, 0x8000, 0x3014,
      0x8000, 0x8000, 0x2ff9, 0x2ffb, 0x2ffc, 0x2ffd, 0x2ffe, 0x2fff,
      0x3000, 0x3001, 0x3002, 0x3004, 0x3006, 0x3007, 0x3008, 0x3009,
      0x30d2, 0x8000, 0x8000, 0x30cd, 0x1447, 0x8000, 0x30d8, 0x8000,
      0x8000, 0x30d1, 0x8000, 0x30d7, 0x8000, 0x30d5, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x30d6, 0x3179, 0x317b, 0x8000,
      0x317a, 0x3178, 0x3173, 0x3175, 0x3177, 0x31f5, 0x8000, 0x3176,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x3251, 0x8000, 0x8000, 0x3250, 0x3252, 0x8000, 0x8000,
      0x3297, 0x3298, 0x32b8, 0x8000, 0x8000, 0x32b7, 0x32b9, 0x8000,
      0x8000, 0x32e3, 0x32e4, 0x32e5, 0x8000, 0x8000, 0x8000, 0x32eb,
      0x8000, 0x1e4d, 0x20f6, 0x285c, 0x8000, 0x2f0c, 0x8000, 0x8000,
      0x8000, 0x20f7, 0x20f8, 0x8000, 0x8000, 0x8000, 0x239c, 0x239d,
      0x8000, 0x8000, 0x8000, 0x285f, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x2a98, 0x2a9a, 0x2a9b, 0x2c54, 0x2c57, 0x2c58, 0x8000,
      0x2dca, 0x2f0f, 0x3019, 0x8000, 0x30db, 0x8000, 0x8000, 0x15cb,
      0x15cd, 0x169c, 0x8000, 0x8000, 0x8000, 0x8000, 0x1801, 0x1802,
      0x1804, 0x1805, 0x19c3, 0x19c4, 0x19c5, 0x19c6, 0x8000, 0x8000,
      0x19c7, 0x8000, 0x8000, 0x8000, 0x8000, 0x1e51, 0x1e52, 0x8000,
      0x8000, 0x8000, 0x20fa, 0x20fb, 0x20fe, 0x20ff, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x239f, 0x23a0, 0x23a1, 0x25fd, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x25fe, 0x2862, 0x8000, 0x8000,
      0x8000, 0x2c5b, 0x8000, 0x8000, 0x8000, 0x8000, 0x1e55, 0x2100,
      0x2102, 0x8000, 0x2863, 0x2a9e, 0x8000, 0x8000, 0x2dcc, 0x2dcd,
      0x2dce, 0x2dcf, 0x8000, 0x2f10, 0x8000, 0x3253, 0x8000, 0x8000,
      0x8000, 0x23a6, 0x23a4, 0x23a5, 0x25ff, 0x8000, 0x8000, 0x2866,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x2c60,
      0x8000, 0x8000, 0x2c5d, 0x2dd2, 0x8000, 0x2f13, 0x2f15, 0x2f11,
      0x2f12, 0x301b, 0x8000, 0x8000, 0x8000, 0x30dd, 0x30dc, 0x317c,
      0x8000, 0x3255, 0x3256, 0x8000, 0x32d1, 0x8000, 0x8000, 0x8000,
      0x1e56, 0x2105, 0x2106, 0x2107, 0x8000, 0x23ab, 0x2601, 0x2602,
      0x2603, 0x2604, 0x0e98, 0x2606, 0x2607, 0x2608, 0x2609, 0x260a,
      0x8000, 0x2868, 0x2869, 0x286a, 0x2aa4, 0x2c62, 0x2c63, 0x8000,
      0x8000, 0x2dd7, 0x1301, 0x2dd9, 0x2dda, 0x2f16, 0x2f17, 0x301d,
      0x30de, 0x31f7, 0x31f8, 0x3257, 0x1503, 0x286c, 0x2c66, 0x8000,
      0x2ddd, 0x2f1b, 0x30df, 0x317d, 0x3258, 0x2aa5, 0x8000, 0x8000,
      0x8000, 0x1304, 0x301e, 0x301f, 0x8000, 0x8000, 0x1e57, 0x8000,
      0x8000, 0x8000, 0x8000, 0x2874, 0x2873, 0x2870, 0x286e, 0x2871,
      0x2872, 0x1019, 0x2aa7, 0x2aa8, 0x8000, 0x8000, 0x2c6e, 0x2c69,
      0x2c6a, 0x2c6b, 0x8000, 0x2c6d, 0x2de2, 0x2de3, 0x2de4, 0x1308,
      0x2f1e, 0x2f1f, 0x3020, 0x8000, 0x3022, 0x3023, 0x30e0, 0x317e,
      0x317f, 0x8000, 0x8000, 0x329d, 0x32d2, 0x23af, 0x8000, 0x260f,
      0x0e9e, 0x2875, 0x101a, 0x8000, 0x8000, 0x8000, 0x2f23, 0x3024,
      0x3025, 0x8000, 0x8000, 0x8000, 0x30e1, 0x3180, 0x32d4, 0x8000,
      0x8000, 0x8000, 0x1e58, 0x8000, 0x8000, 0x23b1, 0x8000, 0x8000,
      0x8000, 0x8000, 0x2611, 0x2877, 0x8000, 0x2612, 0x8000, 0x8000,
      0x8000, 0x2878, 0x2c6f, 0x8000, 0x8000, 0x8000, 0x2c75, 0x2c76,
      0x2c78, 0x2c70, 0x2c72, 0x1265, 0x130b, 0x130c, 0x2de8, 0x8000,
      0x8000, 0x8000, 0x8000, 0x2f25, 0x2f26, 0x3028, 0x8000, 0x30e5,
      0x30e4, 0x8000, 0x8000, 0x3182, 0x8000, 0x8000, 0x8000, 0x8000,
      0x2614, 0x8000, 0x8000, 0x2f28, 0x8000, 0x8000, 0x2f27, 0x8000,
      0x8000, 0x8000, 0x23b2, 0x23b3, 0x23b4, 0x23b5, 0x2617, 0x2618,
      0x2619, 0x261a, 0x261b, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
      0x2888, 0x8000, 0x287e, 0x287f, 0x2880, 0x2881, 0x2882, 0x2884,
      0x2ab1, 0x2ab2, 0x2ab4, 0x2ab6, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x2c7d, 0x2c7e, 0x2c7f, 0x2c80, 0x2c82,
      0x2c83, 0x2c84, 0x2c85, 0x2c86, 0x2deb, 0x2dec, 0x2def, 0x2df1,
      0x8000, 0x8000, 0x8000, 0x8000, 0x2df2, 0x8000, 0x2f29, 0x2f2a,
      0x2f2b, 0x2f2c, 0x2f2e, 0x2f2f, 0x2f33, 0x2f34, 0x302c, 0x302d,
      0x302e, 0x302f, 0x3030, 0x3032, 0x3035, 0x8000, 0x30ed, 0x8000,
      0x30e6, 0x30e7, 0x30e8, 0x30ec, 0x8000, 0x3183, 0x3184, 0x3187,
      0x318a, 0x8000, 0x3259, 0x32bb, 0x8000, 0x32d8, 0x32d9, 0x8000,
      0x32e7, 0x32ef, 0x2ab8, 0x2ab9, 0x2aba, 0x1311, 0x2f36, 0x3036,
      0x3037, 0x30ee, 0x318d, 0x325a, 0x8000, 0x8000, 0x8000, 0x2df4,
      0x8000, 0x8000, 0x288a, 0x288d, 0x8000, 0x1029, 0x8000, 0x2abd,
      0x2abc, 0x8000, 0x2c89, 0x2c8a, 0x2c8b, 0x2c8c, 0x1312, 0x2df6,
      0x8000, 0x8000, 0x8000, 0x2f38, 0x2f3a, 0x30ef, 0x30f0, 0x30f2,
      0x31fc, 0x31fe, 0x32da, 0x318f, 0x2ac0, 0x30f3, 0x261f, 0x2620,
      0x288f, 0x2dfb, 0x2dfc, 0x8000, 0x8000, 0x8000, 0x8000, 0x30f4,
      0x3191, 0x8000, 0x8000, 0x2621, 0x2622, 0x8000, 0x8000, 0x8000,
      0x2899, 0x2891, 0x102d, 0x2893, 0x2894, 0x2895, 0x2896, 0x8000,
      0x2acc, 0x2ace, 0x8000, 0x8000, 0x2acd, 0x8000, 0x8000, 0x2ac2,
      0x2ac3, 0x2ac4, 0x2ac5, 0x2ac6, 0x2ac7, 0x2c8e, 0x126b, 0x2c8f,
      0x2c91, 0x2c92, 0x2c93, 0x2c94, 0x2c95, 0x2c99, 0x8000, 0x8000,
      0x2e07, 0x8000, 0x8000, 0x2e08, 0x2dfd, 0x2dfe, 0x2dff, 0x2e00,
      0x2e02, 0x2e03, 0x131a, 0x2e04, 0x8000, 0x8000, 0x8000, 0x8000,
      0x8000, 0x2f4a, 0x8000, 0x8000, 0x8000, 0x2f3c, 0x2f3e, 0x2f3f,
      0x13ac, 0x2f41, 0x2f43, 0x2f44, 0x2f46, 0x8000, 0x2f4c, 0x3046,
      0x8000, 0x303c, 0x303e, 0x303f, 0x3040, 0x3041, 0x3042, 0x3044,
      0x8000, 0x3043, 0x3048, 0x8000, 0x30fd, 0x8000, 0x8000, 0x8000,
      0x8000, 0x30f5, 0x30f6, 0x30f8, 0x30fa, 0x30fb, 0x3193, 0x3194,
      0x3195, 0x149a, 0x149b, 0x319c, 0x3197, 0x3198, 0x3199, 0x319a,
      0x8000, 0x8000, 0x8000, 0x3206, 0x8000, 0x3201, 0x3202, 0x3203,
      0x3204, 0x3205, 0x8000, 0x8000, 0x325d, 0x325e, 0x325f, 0x3260,
      0x8000, 0x8000, 0x32a1, 0x8000, 0x8000, 0x32a0, 0x32bc, 0x32bd,
      0x32bf, 0x8000, 0x8000, 0x8000, 0x32ec, 0x32f0, 0x8000, 0x8000,
      0x23b9, 0x23ba, 0x2624, 0x2626, 0x289b, 0x8000, 0x8000, 0x8000,
      0x289c, 0x289d, 0x289e, 0x289f, 0x28a1, 0x28a2, 0x28a3, 0x28a5,
      0x8000, 0x8000, 0x8000, 0x2993, 0x8000, 0x8000, 0x1157, 0x2acf,
      0x2ad0, 0x2ad1, 0x2ad3, 0x2ad4, 0x2ad6, 0x2ad7, 0x2ad8, 0x2c9a,
      0x2c9b, 0x2c9c, 0x2c9d, 0x2c9e, 0x2c9f, 0x2ca0, 0x2ca1, 0x8000,
      0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x2ca2, 0x2ca3, 0x2ca5,
      0x2ca6, 0x2ca7, 0x2e0b, 0x2e0c, 0x2e0d, 0x2e0e, 0x2e0f, 0x2e10,
      0x2e11, 0x2e12, 0x2e14, 0x2e15, 0x8000, 0x2e16, 0x8000, 0x8000,
      0x8000, 0x8000, 0x8000, 0x2f4d, 0x2f4e, 0x2f50, 0x2f51, 0x2f52,
      0x2f53, 0x2f54, 0x2f55, 0x2f56, 0x2f57, 0x8000, 0x2f64, 0x2f58,
      0x2f59, 0x2f5a, 0x2f5b, 0x2f5e, 0x2f5f, 0x2f60, 0x2f61, 0x2f62,
      0x2f63, 0x3049, 0x304a, 0x304b, 0x304c, 0x304d, 0x304f, 0x3050,
      0x3051, 0x3052, 0x3053, 0x3054, 0x3055, 0x3056, 0x3058, 0x3059,
      0x305a, 0x305b, 0x8000, 0x3060, 0x30fe, 0x30ff, 0x3103, 0x3104,
      0x3105, 0x3106, 0x310a, 0x310e, 0x3110, 0x8000, 0x3111, 0x3113,
      0x31af, 0x8000, 0x31a0, 0x31a1, 0x31a2, 0x31a3, 0x31a4, 0x31a5,
      0x31a6, 0x31a7, 0x31ab, 0x31ad, 0x3209, 0x320a, 0x320c, 0x320d,
      0x3217, 0x321b, 0x8000, 0x8000, 0x320f, 0x3210, 0x3211, 0x3212,
      0x3215, 0x3216, 0x3262, 0x3263, 0x3265, 0x3266, 0x3267, 0x3268,
      0x3269, 0x326a, 0x326b, 0x326d, 0x8000, 0x32a2, 0x32a3, 0x32a4,
      0x32a5, 0x32c1, 0x32a6, 0x32c2, 0x32dc, 0x32e9, 0x8000, 0x8000,
      0x8000, 0x2adc, 0x2cac, 0x2cad, 0x8000, 0x8000, 0x8000, 0x2e18,
      0x2f67, 0x3061, 0x8000, 0x3116, 0x8000, 0x326e, 0x32a8, 0x8000,
      0x2627, 0x2adf, 0x1032, 0x2ade, 0x8000, 0x8000, 0x140f, 0x31b0,
      0x8000, 0x32ed, 0x8000, 0x2f69, 0x321c, 0x8000, 0x28a8, 0x2ae0,
      0x2ae1, 0x2cb1, 0x2e1a, 0x3065, 0x3117, 0x3119, 0x31b1, 0x321e,
      0x321f, 0x32a9, 0x8000, 0x2e1b, 0x2e1c, 0x3220, 0x32c4, 0x311b,
      0x3221, 0x2cb4, 0x2cb5, 0x2e1e, 0x2e20, 0x2e21, 0x2e22, 0x2f6b,
      0x3068, 0x3069, 0x311d, 0x31b2, 0x149f, 0x31b3, 0x31b4, 0x3222,
      0x3224, 0x2f6c, 0x31b5, 0x3225, 0x32ab, 0x32f7, 0x2e23, 0x2f6e,
      0x2f6f, 0x2f71, 0x306a, 0x306c, 0x306d, 0x1465, 0x311f, 0x3120,
      0x31b6, 0x3227, 0x3228, 0x322a, 0x3271, 0x3272, 0x32ac, 0x32ad,
      0x32ae, 0x32af, 0x32f5, 0x8000, 0x3121, 0x8000, 0x8000, 0x32c5 };

   static unsigned short int *TCA2TELtab = TCA_2_TEL_Tab;
   static unsigned short int *TEL2TCAtab = TEL_2_TCA_Tab;

#else

   static unsigned short int *TCA2TELtab = NULL;
   static unsigned short int *TEL2TCAtab = NULL;

#endif


#define GetBIG5code     Get2Byte
#define GetIBMcode      Get2Byte
#define GetNSCcode      Get2Byte
/* #define GetNSCPcode     Get2Byte */
#define GetEUCcode      Get4Byte
#define GetTCAcode      Get2Byte
#define GetTELcode      Get2Byte
/* #define GetIBMHcode     Get2Byte */

#define PutBIG5code     Put2Byte
#define PutIBMcode      Put2Byte
#define PutNSCcode      Put2Byte
/* #define PutNSCPcode     Put2Byte */
#define PutEUCcode      Put4Byte
#define PutTCAcode      Put2Byte
#define PutTELcode      Put2Byte
/* #define PutIBMHcode     Put2Byte */

#define ErrorNo                 (-1)
#define ASCIIOffset             (-1000)
#define SymOffset               (-10000)
#define TELOffset               20000
#define ESC                     0x1b
#define SI                      0x0f
#define SO                      0x0e
#define CPlane                  0x24
#define G0                      0x28
#define G1                      0x29
#define G2                      0x2a
#define G3                      0x2b
#define InRange(Low, X, Upper)  ( (Low) <= (X) && (X) <= (Upper) )

typedef  union
         {
          unsigned char Byte[4];
          long code;
        } CODE;

static char *InStr, *EndStr;
static int InNo, OutNo;
static unsigned int SOf=0, SIf=~0, LS2f=0, LS3f=0, SS2f=0, SS3f=0;
static unsigned int SOf1=0, SIf1=~0, LS2f1=0, LS3f1=0, SS2f1=0, SS3f1=0;
static unsigned int Ctrl_cnt=0;
static unsigned char Gset[4]={0, 1, 2, 14};
static CODE Ctrl;

static CODE Get2Byte(), Get4Byte(), GetNSCPcode(), GetIBMHcode();
static int  Put2Byte(), Put4Byte(), PutNSCPcode(), PutIBMHcode();
static int  BIG5order(), IBMorder(), NSCorder(), EUCorder(), TCAorder(),
            TELorder(), IBMHorder(), NSCPorder();
static CODE BIG5code(), IBMcode(), NSCcode(), EUCcode(), TCAcode(), TELcode(),
            IBMHcode(), NSCPcode();
static int  IDent(), IBM2NSC(), NSC2IBM(), TCA2TEL(), TEL2TCA(), SymbolTab();
static CODE ASCIITab();

static CODE (*GetCode[8])() =
     {GetBIG5code, GetIBMcode, GetNSCcode, GetEUCcode, GetTCAcode, GetTELcode,
      GetIBMHcode, GetNSCPcode};

static int  (*PutCode[8])() =
     {PutBIG5code, PutIBMcode, PutNSCcode, PutEUCcode, PutTCAcode, PutTELcode,
      PutIBMHcode, PutNSCPcode};

static int  (*Seq[8])() =
     {BIG5order, IBMorder, NSCorder, EUCorder, TCAorder, TELorder, IBMHorder,
      NSCPorder};

static CODE (*Code[8])() =
     {BIG5code, IBMcode, NSCcode, EUCcode, TCAcode, TELcode, IBMHcode,
      NSCPcode};

static int  (*Transform[8][8])() = {
       /*  BIG5    IBM     NSC     EUC     TCA     TEL     IBMH    NSCP   */
/*BIG5*/ IDent,  IDent,  IBM2NSC,IBM2NSC,IBM2NSC,TCA2TEL,IDent,  IBM2NSC,
/*IBM */ IDent,  IDent,  IBM2NSC,IBM2NSC,IBM2NSC,TCA2TEL,IDent,  IBM2NSC,
/*NSC */ NSC2IBM,NSC2IBM,IDent,  IDent,  IDent,  TCA2TEL,NSC2IBM,IDent,
/*EUC */ NSC2IBM,NSC2IBM,IDent,  IDent,  IDent,  TCA2TEL,NSC2IBM,IDent,
/*TCA */ NSC2IBM,NSC2IBM,IDent,  IDent,  IDent,  TCA2TEL,NSC2IBM,IDent,
/*TEL */ TEL2TCA,TEL2TCA,TEL2TCA,TEL2TCA,TEL2TCA,IDent,  TEL2TCA,TEL2TCA,
/*IBMH*/ IDent,  IDent,  IBM2NSC,IBM2NSC,IBM2NSC,TCA2TEL,IDent,  IBM2NSC,
/*NSCP*/ NSC2IBM,NSC2IBM,IDent,  IDent,  IDent,  TCA2TEL,NSC2IBM,IDent    };

/*****************************************************************************
 *                                                                           *
 *  ... Get2Byte(string) function                                            *
 *      input>.  string: Input the address of a string.                      *
 *      output>. Return 1 (ASCII code) or 2 byte(s).                         *
 *               (string address will increase by 1 or 2)                    *
 *                                                                           *
 *****************************************************************************/

static CODE Get2Byte(s)
unsigned char **s;
{
CODE code;

   code.code=0L;

   if ( ((code.Byte[0] = *(*s)++) & 0x080) && (InStr < EndStr) )
      code.Byte[1] = *(*s)++;
   return( code );
}

/*****************************************************************************
 *                                                                           *
 *  ... Get4Byte(string) function                                            *
 *      input>.  string: Input a string.                                     *
 *      output>. Return 1 (ASCII code), 2 or 4 byte(s).                      *
 *               (string address will increase by 1, 2 or 4)                 *
 *                                                                           *
 *****************************************************************************/

static CODE Get4Byte(s)
unsigned char **s;
{
CODE code;

   code.code = 0L;

   /* if ( (**s == 0x08e) && (InStr < EndStr) )
     code.code = *(* (long **)s )++;			*/
   if ( (**s == 0x08e) && (InStr < EndStr) ) {
#ifdef sun3					/* sun3/m68xxx arch */
     code.code = *(* (long **)s )++;
#else						/* sun3+sun4/RISC arch */
     /*
     code.code = (long) **s;
     ((long*) (*s))++;
     */ /* no Bus error, but still suffer from binary alignment problem */

     /* default -- a much safer way: */
     code.Byte[0] = *(*s)++;
     code.Byte[1] = *(*s)++;
     code.Byte[2] = *(*s)++;
     code.Byte[3] = *(*s)++;
#endif
   }
   else if ( ((code.Byte[0] = *(*s)++) >= 0x0a1) && (InStr < EndStr) )
           code.Byte[1] = *(*s)++;
   return( code );
}

/*****************************************************************************
 *                                                                           *
 *  ... GetNSCPcode(string) function                                         *
 *      input>.  string: Input a string.                                     *
 *      output>. Return 1 (ASCII code), or 2 byte(s).                        *
 *               (string address will increase by 1, or 2)                   *
 *               Set SI, SO, LS2, LS3, SS2, or SS3 flag(s).                  *
 *                                                                           *
 *****************************************************************************/

static CODE GetNSCPcode(s)
unsigned char **s;
{
CODE code;
unsigned int i, G, Plane;

  code.code = 0L;

  while( InStr < EndStr )
  {
    if ( Ctrl_cnt != 0 )
    {
       code.Byte[0] = Ctrl.Byte[0];
       for(i=0; i<3; i++)
          Ctrl.Byte[i] = Ctrl.Byte[i+1];
       Ctrl.Byte[3] = 0;
       Ctrl_cnt--;
       return( code );
    }

    Ctrl.code = 0L;
    switch ( Ctrl.Byte[0] = *(*s)++ )
    {
    case ESC :
         switch ( Ctrl.Byte[1] = *(*s)++ )
         {
         case G0 :
         case G1 :
         case G2 :
         case G3 :
              Gset[Ctrl.Byte[1] - 0x28] = 0; /* Gset[] ::= ASCII */
              (*s)++; /* skip 1 byte */
              break;
         case CPlane :
              Ctrl.Byte[2] = *(*s)++;
              if ( InRange(0x28, Ctrl.Byte[2], 0x2b) )
              {
                   Plane = (Ctrl.Byte[3] = *(*s)++) - 0x30 + 1;
                   if ( InRange(1, Plane, 16) )
                      Gset[Ctrl.Byte[2]-0x28] = Plane;
                   else /* Error */
                      Ctrl_cnt = 4;
              }
              else /* Error */
                 Ctrl_cnt = 3;
              break;
         case 0x6e : /* LS2 ::= ESC 0x6e */
         case 0x6f : /* LS3 ::= ESC 0x6f */
              LS2f = (Ctrl.Byte[1] == 0x6e)?~0:0;
              LS3f = (Ctrl.Byte[1] == 0x6f)?~0:0;
              SIf = SOf = SS2f = SS3f = 0;
         case 0x4e : /* SS2 ::= ESC 0x4e */
         case 0x4f : /* SS3 ::= ESC 0x4f */
              SS2f = (Ctrl.Byte[1] == 0x4e)?~0:0;
              SS3f = (Ctrl.Byte[1] == 0x4f)?~0:0;
              break;
         default : /* Error */
              Ctrl_cnt = 2;
              break;
         }
         break;
    case SI  :
    case SO  :
         SIf = (Ctrl.Byte[0] == SI)?~0:0;
         SOf = (Ctrl.Byte[0] == SO)?~0:0;
         SS2f = SS3f = LS2f = LS3f = 0;
         break;
    default  : /* Get code */
         code.Byte[0] = Ctrl.Byte[0];
         Ctrl.code = 0L;
         if ( ((SIf&Gset[0]) || ((SS2f | LS2f)&Gset[2])  ||
               (SOf&Gset[1]) || ((SS3f | LS3f)&Gset[3])) &&
              (InStr < EndStr) )
            code.Byte[1] = *(*s)++;
         return( code );
         break;
    }
  }
  return(code);		/* shin -^^- 1994/04/21 - */
			/* to avoid Bus/Alignment Errors */
}

/*****************************************************************************
 *                                                                           *
 *  ... GetIBMHcode(string) function                                         *
 *      input>.  string: Input a string.                                     *
 *      output>. Return 1 (ASCII code), or 2 byte(s).                        *
 *               (string address will increase by 1, or 2)                   *
 *               Set SI, or SO flag.                                         *
 *                                                                           *
 *****************************************************************************/

static CODE GetIBMHcode(s)
unsigned char **s;
{
CODE code;

  code.code = 0L;

  while( InStr < EndStr )
  {
    switch ( code.Byte[0] = *(*s)++ )
    {
    case SI  :
    case SO  :
         SIf = (code.Byte[0] == SI)?~0:0;
         SOf = (code.Byte[0] == SO)?~0:0;
         break;
    default  : /* Get code */
         if ( SOf && (InStr < EndStr) )
            code.Byte[1] = *(*s)++;
         return( code );
         break;
    }
  }
  return(code);		/* shin -^^- 1994/04/21 - */
			/* to avoid Bus/Alignment Errors */
}

/*****************************************************************************
 *                                                                           *
 *  ... Put2Byte(word, stream) function                                      *
 *      input>.  word: The output code                                       *
 *               stream: The address of a string.                            *
 *      output>. send the word to a STREAMS file.                            *
 *                                                                           *
 *****************************************************************************/

static Put2Byte(word, stream)
CODE word;
unsigned char **stream;
{
   if ( (*(*stream)++ = word.Byte[0]) & 0x80)
      *(*stream)++ = word.Byte[1];
}

/*****************************************************************************
 *                                                                           *
 *  ... Put4Byte(word, stream) function                                      *
 *      input>.  word: The output code                                       *
 *               stream: The address of a string.                            *
 *      output>. send the word to a STREAMS file.                            *
 *                                                                           *
 *****************************************************************************/

static Put4Byte(word,stream)
CODE word;
unsigned char **stream;
{
   if (word.Byte[0] == 0x8e)
#ifdef	sun3			/* shin -^^- 1994/03/17 */
      *(* (long **)stream )++ = word.code;
#else
   {
	*(*stream)++ = word.Byte[0];
	*(*stream)++ = word.Byte[1];
	*(*stream)++ = word.Byte[2];
	*(*stream)++ = word.Byte[3];
   }
#endif
   else if ( (*(*stream)++ = word.Byte[0]) >= 0xa1)
           *(*stream)++ = word.Byte[1];
}

/*****************************************************************************
 *                                                                           *
 *  ... PutNSCcode(word, stream) function                                    *
 *      input>.  word: The output code                                       *
 *               stream: The address of a string.                            *
 *      output>. send the word to a STREAMS file.                            *
 *                                                                           *
 *****************************************************************************/

static PutNSCPcode(word, stream)
CODE word;
unsigned char **stream;
{
unsigned int cnt=0;

   *(*stream)++ = word.Byte[cnt];
   while ( (word.Byte[++cnt]) && (cnt<4) )
      *(*stream)++ = word.Byte[cnt];
}

/*****************************************************************************
 *                                                                           *
 *  ... PutIBMHcode(word, stream) function                                   *
 *      input>.  word: The output code                                       *
 *               stream: The address of a string.                            *
 *      output>. Send the control code, SI or SO, to a STREAMS file as       *
 *               the plane transfered. Otherwise, send the word to the       *
 *               STREAMS file.                                               *
 *                                                                           *
 *****************************************************************************/

static PutIBMHcode(word, stream)
CODE word;
unsigned char **stream;
{
   if ( word.Byte[1] | word.Byte[2] | word.Byte[3] )
   {
      SIf1 = 0;
      if ( !SOf1 )
         *(*stream)++ = SO;
      SOf1 = ~0;
      *(*stream)++ = word.Byte[0];
      *(*stream)++ = word.Byte[1];
   }
   else
   {
      SOf1 = 0;
      if ( !SIf1 )
         *(*stream)++ = SI;
      SIf1 = ~0;
      *(*stream)++ = word.Byte[0];
   }
}

/*****************************************************************************
 *                                                                           *
 *  ... IBMorder(ibm) function                                               *
 *      input>.  1, or 2 byte(s) code.                                       *
 *      output>. If the input code is ASCII, return the sum of the           *
 *               Hex. value of the ASCII code plus the value of              *
 *               'ASCIIOffset'. Else, if the input code is Symbol,           *
 *               return the sum of the sequential No. of the Symbol          *
 *               plus the value of 'SymOffset'. Otherwise, if the            *
 *               input code is word, return the sequential No. of            *
 *               the word.                                                   *
 *      return>. Upon successful completion, a value of the number           *
 *               is returned. Otherwise, a value of -1 is returned           *
 *               , and ErrorNo is set to indicate the error.                 *
 *                                                                           *
 *****************************************************************************/

static int IBMorder(ibm)
CODE ibm;
{
int order;

   if ( !(ibm.Byte[1] | ibm.Byte[2] | ibm.Byte[3]) )
      return(ibm.Byte[0]+ASCIIOffset);

   if ( !(InRange(0x81, ibm.Byte[0], 0xfc))  ||
        !((InRange(0x40, ibm.Byte[1], 0x7e)) ||
          (InRange(0x80, ibm.Byte[1], 0xfc))) )
      return(ErrorNo);

   order = (ibm.Byte[1]-0x040) - ((ibm.Byte[1]>=0x080)?1:0) + 188*ibm.Byte[0] ;

   if ( InRange(0x81, ibm.Byte[0], 0x8b) )
   {
      order -= 188*0x81;
      if ( InRange(0, order, 1913) )
         return(order+SymOffset);
   }
   if ( InRange(0x8c, ibm.Byte[0], 0xa8) )
   {
      order -= 188*0x8c;
      if ( InRange(0, order, 5400) )
         return(order);
   }
   else
   {
      order -= 188*0xa9-5401;
      if ( InRange(5401, order, 13052) )
         return(order);
   }
   return(ErrorNo);
}

/*****************************************************************************
 *                                                                           *
 *  ... IBMHorder(hst) function                                              *
 *      input>.  1, or 2 byte(s) code.                                       *
 *      output>. If the input code is ASCII, return the sum of the           *
 *               Hex. value of the ASCII code plus the value of              *
 *               'ASCIIOffset'. Else, if the input code is Symbol,           *
 *               return the sum of the sequential No. of the Symbol          *
 *               plus the value of 'SymOffset'. Otherwise, if the            *
 *               input code is word, return the sequential No. of            *
 *               the word.                                                   *
 *      return>. Upon successful completion, a value of the number           *
 *               is returned. Otherwise, a value of -1 is returned           *
 *               , and ErrorNo is set to indicate the error.                 *
 *                                                                           *
 *****************************************************************************/

static int IBMHorder(IHost)
CODE IHost;
{
int order;

   if ( !(IHost.Byte[1] | IHost.Byte[2] | IHost.Byte[3]) )
      return(IHost.Byte[0]+ASCIIOffset);

   if ( (IHost.Byte[0] == 0x40) && (IHost.Byte[1] == 0x40) )
      return(SymOffset);

   if ( !(InRange(0x41, IHost.Byte[0], 0x91))  ||
        !((InRange(0x41, IHost.Byte[1], 0x7f)) ||
          (InRange(0x81, IHost.Byte[1], 0xfd))) )
      return(ErrorNo);

   order = (IHost.Byte[1]-0x41)-((IHost.Byte[1]>=0x81)?1:0)+188*IHost.Byte[0];

   if ( InRange(0x41, IHost.Byte[0], 0x46) )
   {
      order -= 188*0x41 - 1;
      if ( InRange(0, order, 1193) )
         return(order+SymOffset);
   }
   else if ( InRange(0x4c, IHost.Byte[0], 0x68) )
   {
      order -= 188*0x4c;
      if ( InRange(0, order, 5400) )
         return(order);
   }
   else
   {
      order -= 188*0x69-5401;
      if ( InRange(5401, order, 13052) )
         return(order);
   }
   return(ErrorNo);
}

/*****************************************************************************
 *                                                                           *
 *  ... BIG5order(b5) function                                               *
 *      input>.  1, or 2 byte(s) code.                                       *
 *      output>. If the input code is ASCII, return the sum of the           *
 *               Hex. value of the ASCII code plus the value of              *
 *               'ASCIIOffset'. Else, if the input code is Symbol,           *
 *               return the sum of the sequential No. of the Symbol          *
 *               plus the value of 'SymOffset'. Otherwise, if the            *
 *               input code is word, return the sequential No. of            *
 *               the word.                                                   *
 *      return>. Upon successful completion, a value of the number           *
 *               is returned. Otherwise, a value of -1 is returned           *
 *               , and ErrorNo is set to indicate the error.                 *
 *                                                                           *
 *****************************************************************************/

static int BIG5order(b5)
CODE b5;
{
int order;

   if ( !(b5.Byte[1] | b5.Byte[2] | b5.Byte[3]) )
      return(b5.Byte[0]+ASCIIOffset);

   if ( !(InRange(0xa1, b5.Byte[0], 0xfe))  ||
        !((InRange(0x40, b5.Byte[1], 0x7e)) ||
          (InRange(0xa1, b5.Byte[1], 0xfe))) )
      return(ErrorNo);

   order = (b5.Byte[1]-0x040) - ((b5.Byte[1]>=0x0a1)?0x022:0) + 157*b5.Byte[0];

   if ( InRange(0xa1, b5.Byte[0], 0xa3) )
   {
      order -= 157*0xa1;
      if ( InRange(0, order, 440) )
         return(order+SymOffset);
   }
   else if ( InRange(0xa4, b5.Byte[0], 0xc6) )
   {
      order -= 157*0xa4;
      if ( InRange(0, order, 5400) )
         return(order);
   }
   else
   {
      order -= 157*0xc9-5401;
      if ( InRange(5401, order, 13052) )
         return(order);
   }
   return(ErrorNo);
}

/*****************************************************************************
 *                                                                           *
 *  ... EUCorder(euc) function                                               *
 *      input>.  1, or 2 byte(s) code.                                       *
 *      output>. If the input code is ASCII, return the sum of the           *
 *               Hex. value of the ASCII code plus the value of              *
 *               'ASCIIOffset'. Else, if the input code is Symbol,           *
 *               return the sum of the sequential No. of the Symbol          *
 *               plus the value of 'SymOffset'. Otherwise, if the            *
 *               input code is word, return the sequential No. of            *
 *               the word.                                                   *
 *      return>. Upon successful completion, a value of the number           *
 *               is returned. Otherwise, a value of -1 is returned           *
 *               , and ErrorNo is set to indicate the error.                 *
 *                                                                           *
 *****************************************************************************/

static int EUCorder(euc)
CODE euc;
{
int order;

   if ( !(euc.Byte[1] | euc.Byte[2] | euc.Byte[3]) )
      return(euc.Byte[0]+ASCIIOffset);

   if ( euc.Byte[0] == 0x8e )
   {
      if ( !InRange(0xa2, euc.Byte[1], 0xb0) ||
           !InRange(0xa1, euc.Byte[2], 0xfe) ||
           !InRange(0xa1, euc.Byte[3], 0xfe) )
         return(ErrorNo);
      order = (euc.Byte[2]-0x0a1)*94+(euc.Byte[3]-0x0a1)+5401;
      if ( InRange(5401, order, 13050) )
         return(order);
      return(ErrorNo);
   }
   else
   {
      if ( !InRange(0xa1, euc.Byte[0], 0xfe) ||
           !InRange(0xa1, euc.Byte[1], 0xfe) )
         return(ErrorNo);

      order = euc.Byte[0]*94+(euc.Byte[1]-0x0a1);
      if ( InRange(0xa1, euc.Byte[0], 0xc2) )
      {
         order -= 0xa1 * 94;
         if ( InRange(0, order, 3134) )
            return(order+SymOffset);
      }
      else if ( InRange(0xc4, euc.Byte[0], 0xfd) )
      {
         order -= 0xc4 * 94;
         if ( InRange(0, order, 5400) )
            return(order);
      }
      return(ErrorNo);
   }
}

/*****************************************************************************
 *                                                                           *
 *  ... NSCorder(nsc) function                                               *
 *      input>.  1, or 2 byte(s) code.                                       *
 *      output>. If the input code is ASCII, return the sum of the           *
 *               Hex. value of the ASCII code plus the value of              *
 *               'ASCIIOffset'. Else, if the input code is Symbol,           *
 *               return the sum of the sequential No. of the Symbol          *
 *               plus the value of 'SymOffset'. Otherwise, if the            *
 *               input code is word, return the sequential No. of            *
 *               the word.                                                   *
 *      return>. Upon successful completion, a value of the number           *
 *               is returned. Otherwise, a value of -1 is returned           *
 *               , and ErrorNo is set to indicate the error.                 *
 *                                                                           *
 *****************************************************************************/

static int NSCorder(nsc)
CODE nsc;
{
int order;

   if ( !(nsc.Byte[1] | nsc.Byte[2] | nsc.Byte[3]) )
      return(nsc.Byte[0]+ASCIIOffset);

   if ( !(InRange(0xa1, nsc.Byte[0], 0xfe))  ||
        !((InRange(0x21, nsc.Byte[1], 0x7e)) ||
          (InRange(0xa1, nsc.Byte[1], 0xfe))) )
      return(ErrorNo);

   if ( !(nsc.Byte[1]&0x80) )
   {
      order = nsc.Byte[1] - 0x021 + 94 * (nsc.Byte[0] - 0x0a1) + 5401;
      if ( InRange(5401, order, 13050) )
         return(order);
   }
   else if ( InRange(0xc4, nsc.Byte[0], 0xfd) )
   {
      order = nsc.Byte[1] - 0x0a1 + 94 * (nsc.Byte[0] - 0x0c4);
      if ( InRange(0, order, 5400) )
         return(order);
   }
   else
   {
      order = nsc.Byte[1] - 0x0a1 + 94 * (nsc.Byte[0] - 0x0a1);
      if ( InRange(0, order, 3134) )
         return(order+SymOffset);
   }
   return(ErrorNo);
}

/*****************************************************************************
 *                                                                           *
 *  ... NSCPorder(nsc) function                                              *
 *      input>.  1, or 2 byte(s) code.                                       *
 *      output>. If the input code is ASCII, return the sum of the           *
 *               Hex. value of the ASCII code plus the value of              *
 *               'ASCIIOffset'. Else, if the input code is Symbol,           *
 *               return the sum of the sequential No. of the Symbol          *
 *               plus the value of 'SymOffset'. Otherwise, if the            *
 *               input code is word, return the sequential No. of            *
 *               the word.                                                   *
 *               Additionally, reset SI, SO, LS2, LS3, SS2, or SS3           *
 *               flag(s).                                                    *
 *      return>. Upon successful completion, a value of the number           *
 *               is returned. Otherwise, a value of -1 is returned           *
 *               , and ErrorNo is set to indicate the error.                 *
 *                                                                           *
 *****************************************************************************/
static int NSCPorder(nsc)
CODE nsc;
{
int order, Plane;

   if ( !(nsc.Byte[1] | nsc.Byte[2] | nsc.Byte[3]) )
      return(nsc.Byte[0]+ASCIIOffset);

   if ( !(InRange(0x21, nsc.Byte[0], 0x7e)) ||
        !(InRange(0x21, nsc.Byte[1], 0x7e)) )
      return(ErrorNo);

   if ( SS2f | SS3f )
      Plane = (SS2f&Gset[2]) + (SS3f&Gset[3]);
   else
      Plane = (SIf&Gset[0]) + (SOf&Gset[1]) + (LS2f&Gset[2]) + (LS3f&Gset[3]);
   SS2f = SS3f = 0;

   order = nsc.Byte[1] - 0x21 + 94 * (nsc.Byte[0] - 0x21);
   switch( Plane )
   {
   case 1 :
      if ( InRange(0x44, nsc.Byte[0], 0x7d) )
      {
         order -= 94 * (0x44-0x21);
         if ( InRange(0, order, 5400) )
            return(order);
      }
      else /* Symbol */
         if ( InRange(0, order, 3134) )
            return(order+SymOffset);
      break;
   case 2 :
      order += 5401;
      if ( InRange(5401, order, 13050) )
         return(order);
      break;
   case 14 :
      return(order+14000);
      break;
   }
   return(ErrorNo);
}

/*****************************************************************************
 *                                                                           *
 *  ... TELorder(tel) function                                               *
 *      input>.  1, or 2 byte(s) code.                                       *
 *      output>. If the input code is ASCII, return the sum of the           *
 *               Hex. value of the ASCII code plus the value of              *
 *               'ASCIIOffset'. Else, if the input code is Symbol,           *
 *               return the sum of the sequential No. of the Symbol          *
 *               plus the value of 'SymOffset'. Otherwise, if the            *
 *               input code is word, return the sequential No. of            *
 *               the word.                                                   *
 *      return>. Upon successful completion, a value of the number           *
 *               is returned. Otherwise, a value of -1 is returned           *
 *               , and ErrorNo is set to indicate the error.                 *
 *                                                                           *
 *****************************************************************************/

static int TELorder(tel)
CODE tel;
{
int order;

   if ( !(tel.Byte[1] | tel.Byte[2] | tel.Byte[3]) )
      return(tel.Byte[0]+ASCIIOffset);

   if ( !(InRange(0xa1, tel.Byte[0], 0xfe))  ||
        !((InRange(0x21, tel.Byte[1], 0x7e)) ||
          (InRange(0xa1, tel.Byte[1], 0xfe))) )
      return(ErrorNo);

   if ( tel.Byte[1]&0x80 ) /* 1'st Plane */
   {
      order = tel.Byte[1] - 0x0a1 + 94 * (tel.Byte[0] - 0x0a1);
      if ( InRange(0, order, 7902) )
         return(order);
      else if ( InRange(7903, order, 8037) )
         return(order-7903+SymOffset);
   }
   else /* 2'nd Plane */
   {
      order = tel.Byte[1] - 0x021 + 94 * (tel.Byte[0] - 0x0a1) + TELOffset;
      if ( InRange(TELOffset, order, 8489+TELOffset) )
         return(order);
   }
   return(ErrorNo);
}

/*****************************************************************************
 *                                                                           *
 *  ... TCAorder(tca) function                                               *
 *      input>.  1, or 2 byte(s) code.                                       *
 *      output>. If the input code is ASCII, return the sum of the           *
 *               Hex. value of the ASCII code plus the value of              *
 *               'ASCIIOffset'. Else, if the input code is Symbol,           *
 *               return the sum of the sequential No. of the Symbol          *
 *               plus the value of 'SymOffset'. Otherwise, if the            *
 *               input code is word, return the sequential No. of            *
 *               the word.                                                   *
 *      return>. Upon successful completion, a value of the number           *
 *               is returned. Otherwise, a value of -1 is returned           *
 *               , and ErrorNo is set to indicate the error.                 *
 *                                                                           *
 *****************************************************************************/

static int TCAorder(tca)
CODE tca;
{
int order;

   if ( !(tca.Byte[1] | tca.Byte[2] | tca.Byte[3]) )
      return(tca.Byte[0]+ASCIIOffset);

   if ( !(InRange(0x81, tca.Byte[0], 0xfd))  ||
        !((InRange(0x30, tca.Byte[1], 0x39)) ||
          (InRange(0x41, tca.Byte[1], 0x5a)) ||
          (InRange(0x61, tca.Byte[1], 0x7a)) ||
          (InRange(0x80, tca.Byte[1], 0xfd))) )
     return(ErrorNo);

  if ( InRange(0x30, tca.Byte[1], 0x39) )
      order = (tca.Byte[1]-0x030) + 188 * tca.Byte[0];
   else if ( InRange(0x41, tca.Byte[1], 0x5a) )
      order = (tca.Byte[1]-0x030) - 0x007 + 188 * tca.Byte[0];
   else if ( InRange(0x61, tca.Byte[1], 0x7a) )
      order = (tca.Byte[1]-0x030) - 0x00d + 188 * tca.Byte[0];
   else
      order = (tca.Byte[1]-0x030) - 0x012 + 188 * tca.Byte[0];

   if ( InRange(0x81, tca.Byte[0], 0x91) )
   {
      order -= 188 * 0x81;
      if ( InRange(0, order, 3134) )
         return(order+SymOffset);
   }
   else if ( InRange(0x92, tca.Byte[0], 0xaf) )
   {
      order -= 188 * 0x092 + (0xa0-0x30-0x12);
      if ( InRange(0, order, 5400) )
         return(order);
   }
   else /* if ( InRange(0xb0, tca.Byte[0], 0xd8) ) */
   {
      order -= 188 * 0x0b0 - 5401;
      if ( InRange(5401, order, 13050) )
         return(order);
   }
   return(ErrorNo);
}

char WORDindx[13] = { 0, 0, 3, 3, 4, 15, 22, 22, 23, 26, 26, 36, 50 };

/*****************************************************************************
 *                                                                           *
 *  ... IBM2NSC(order) function                                              *
 *      input>.  The sequential No. in IBM Set.                              *
 *      output>. The sequential No. in NSC Set.                              *
 *                                                                           *
 *****************************************************************************/

static int IBM2NSC(order)
int order;
{
int cnt;

static short int SeqIBMtoNSC[64][2] = {
       {    1,    0}, { 1413,  424}, { 1414,   -1}, { 1838,    0},
       { 3714,    1}, { 4101, -387}, { 4102,    0}, { 4627,    1},
       { 4816, -189}, { 4817,    0}, { 4901,    1}, { 4955,    2},
       { 4956,    0}, { 4957,    1}, { 5047, -146}, { 5048,    0},
       { 5412,-5378}, { 5413,   -1}, { 5446,    0}, { 5494,  -49},
       { 5495,   -1}, { 5541,    0}, { 5708, -168}, { 5709,   -1},
       { 7658,  637}, { 7659,   -2}, { 8297,   -1}, { 8696, -201},
       { 8697,   -2}, {10334,   -1}, {10480,    0}, {10767,    1},
       {10883, -551}, {10884,    0}, {11021, -542}, {11022,   -1},
       {11126,    0}, {11348,  366}, {11349,   -1}, {11547, -422},
       {11548,   -2}, {11630, -863}, {11631,   -3}, {11717,   -2},
       {11725,  321}, {11726,   -3}, {11879,  310}, {11880,   -4},
       {11936,   -3}, {12049,   -2}, {12191,   -1}, {12236, -304},
       {12237,   -2}, {12308,   -1}, {12502, -196}, {12503,   -2},
       {12993,   -1}, {13036,  -45}, {13037,   -2}, {13038,    9},
       {13039,   -3}, {13050,   -2}, {13054,   -2} };

   if ( !(InRange(0, order, 13053)) ) return(SymOffset);

   cnt = WORDindx[ order >> 10 ];
   while ( order >= (SeqIBMtoNSC[cnt][0]-1) ) cnt++;
   return( order + SeqIBMtoNSC[cnt-1][1] );
}

/*****************************************************************************
 *                                                                           *
 *  ... NSC2IBM(order) function                                              *
 *      input>.  The sequential No. in NSC Set.                              *
 *      output>. The sequential No. in IBM Set.                              *
 *                                                                           *
 *****************************************************************************/

static int NSC2IBM(order)
int order;
{
int cnt;

static short int SeqNSCtoIBM[62][2] = {
       {    1,    0}, { 1413,    1}, { 1837, -424}, { 1838,    0},
       { 3714,  387}, { 3715,   -1}, { 4102,    0}, { 4627,  189},
       { 4628,   -1}, { 4817,    0}, { 4901,  146}, { 4902,   -1},
       { 4956,    0}, { 4957,   -2}, { 4958,   -1}, { 5048,    0},
       { 5412,    1}, { 5445,   49}, { 5446,    0}, { 5494,    1},
       { 5540,  168}, { 5541,    0}, { 5708,    1}, { 7657,    2},
       { 8295, -637}, { 8296,    1}, { 8695,    2}, {10332,  551},
       {10333,    1}, {10479,  542}, {10480,    0}, {10767,  863},
       {10768,   -1}, {10884,    0}, {11021,    1}, {11125,  422},
       {11126,    0}, {11348,    1}, {11546,    2}, {11628,    3},
       {11714, -366}, {11715,    2}, {11723,    3}, {11876,    4},
       {11932,  304}, {11933,    3}, {12046, -321}, {12047,    2},
       {12189, -310}, {12190,    1}, {12235,    2}, {12306,  196},
       {12307,    1}, {12501,    2}, {12991,   45}, {12992,    1},
       {13035,    2}, {13036,    3}, {13047,   -9}, {13048,    2},
       {13052,    2} };

   if ( !(InRange(0, order, 13053)) ) return(SymOffset);

   cnt = WORDindx[ order >> 10 ];
   while ( order >= (SeqNSCtoIBM[cnt][0]-1) ) cnt++;
   return( order + SeqNSCtoIBM[cnt-1][1] );
}

/*****************************************************************************
 *                                                                           *
 *  ... TCA2TEL(order) function                                              *
 *      input>.  The sequential No. in NSC Set.                              *
 *      output>. The sequential No. in TEL Set.                              *
 *                                                                           *
 *****************************************************************************/

static int TCA2TEL(order)
int order;
{
FILE *TELf;
char string[256];
short int key;

   if ( InNo != 4 ) /* Transform Input_Code to TCA code. */
      order = Transform[InNo][4](order);

   if ( !InRange(0, order, 13051) )
      return(SymOffset);

   key = TCA2TELtab[order+944];

   if ( key & 0x4000 )      /* IF it is in 2'nd Plane.   */
      key = (key & 0x3fff) + TELOffset;
   else if ( key & 0x8000 ) /* ELSE IF it is a Symbol. */
      key = (key & 0x7fff) + SymOffset;
   return(key);             /* ELSE it is in 1'st Plane. */
}

/*****************************************************************************
 *                                                                           *
 *  ... TEL2TCA(order) function                                              *
 *      input>.  The sequential No. in TEL Set.                              *
 *      output>. The sequential No. in NSC Set.                              *
 *                                                                           *
 *****************************************************************************/

static int TEL2TCA(order)
int order;
{
FILE *TELf;
char string[256];
short int key;

   if ( InRange(0, order, 7902) ) /* 1'st Plane */
      key = TEL2TCAtab[order];
   else if ( InRange(TELOffset, order, 8489+TELOffset) ) /* 2'nd Plane */
      key = TEL2TCAtab[order-TELOffset+8038];
   else
      key = TEL2TCAtab[0];

   if ( key & 0x8000 ) /* If it is Symbol */
      return(SymOffset);

   key = Transform[4][OutNo](key);
   return(key);
}

/*****************************************************************************
 *                                                                           *
 *  ... SymbolTab(InCodeNo, OutCodeNo, order)                                *
 *      input>.  order    : Input order that is to be converted.             *
 *               InCodeNo : The input internal code No..                     *
 *               OutCodeNo: The output internal code No..                    *
 *                      Internal Code No:                                    *
 *                                       0: BIG5                             *
 *                                       1: IBM 5550                         *
 *                                       2: NSC Internal code                *
 *                                       3: EUC                              *
 *                                       4: TCA                              *
 *                                       5: TELegraph                        *
 *                                       6: IBM Host                         *
 *                                       7: NSC with Protocol                *
 *      output>. The converted result.                                       *
 *      return>. Upon successful completion, a value of the number is        *
 *               returned. Otherwise, a value of the first Symbol is         *
 *               returned, and ErrorNo is set to indicate the error.         *
 *                                                                           *
 *****************************************************************************/

static int SymbolTab(InCodeNo, OutCodeNo, order )
int order, InCodeNo, OutCodeNo;
{
FILE *TELf, *IBMHf;
short int key, point;
char string[256];

static char OffIndx[10] = { 0, 66, 77, 85, 87,  87,  87,  87,  93,  107 };

static short int Off2Sym[138][2] = {
  {   0,   0}, {   1,   2}, {   2,   3}, {   3,   1}, {   4,   4}, {   5,   5},
  {   6,   7}, {   7,   6}, {   8,   8}, {   9,   9}, {  10,   0}, {  12,  74},
  {  13,  73}, {  14, 234}, {  16,  96}, {  17,  98}, {  18, 236}, {  28,  22},
  {  29,  24}, {  30, 156}, {  32, 129}, {  33, 154}, {  34,  21}, {  35,  11},
  {  37,  67}, {  41,  29}, {  43,  37}, {  45, 246}, {  47,  33}, {  49,  49},
  {  51,  45}, {  53,  53}, {  55,  57}, {  57,  41}, {  59, 109}, {  60, 125},
  {  61, 113}, {  62, 111}, {  64, 117}, {  65, 120}, {  66, 115}, {  68, 118},
  {  70, 121}, {  71, 141}, {  72, 143}, {  73, 142}, {  74, 181}, {  75,   0},
  {  77, 167}, {  78, 161}, {  79, 160}, {  80, 163}, {  83,  75}, {  85, 248},
  {  86, 166}, {  87,  79}, {  88,  86}, {  90,  81}, {  92,  85}, {  93,  88},
  {  97,  83}, {  99,  92}, { 101,  78}, { 102, 162}, { 103, 148}, { 105, 146},
  { 107,   0}, { 203, 282}, { 213,   0}, { 220, 314}, { 246,   0}, { 252, 340},
  { 278,   0}, { 282, 249}, { 315, 456}, { 329, 500}, { 365,   0}, { 376, 536},
  { 404, 810}, { 462,   0}, { 470, 366}, { 494,   0}, { 502, 390}, { 526,   0},
  { 564, 868}, { 597,   0}, { 612, 901}, { 645,   0}, {1504, 302}, {1516,   0},
  {1520, 452}, {1524,  16}, {1525, 414}, {1562,   0}, {1692, 470}, {1702,   0},
  {1708, 480}, {1718,   0}, {1723, 191}, {1766,   0}, {1786,  55}, {1788,  59},
  {1790,  43}, {1792,   0}, {1793,  23}, {1794,  25}, {1798,  31}, {1800,  35},
  {1802,  39}, {1804,  47}, {1806,  51}, {1808,   0}, {1810,  77}, {1811,  80},
  {1812,  94}, {1814,   0}, {1816, 100}, {1822, 108}, {1823, 114}, {1824, 122},
  {1826, 130}, {1836, 144}, {1838, 150}, {1842, 140}, {1843,   0}, {1845, 168},
  {1846, 172}, {1855,   0}, {1859,  71}, {1861,   0}, {1864, 934}, {1867, 182},
  {1876,   0}, {1881, 292}, {1891,   0}, {1897, 490}, {1907, 937}, {1913, 943}};

static short int Sym2Off[700] = {
  /*   0 */    0,   3,   1,   2,   4,   5,   7,   6,   8,   9,   6,  35,
  /*  12 */   36,   3,   1,   4,1524,   7,   6,   8,   9,  34,  28,1793,
  /*  24 */   29,1794,1795,1796,1797,  41,  42,1798,1799,  47,  48,1800,
  /*  36 */ 1801,  43,  44,1802,1803,  57,  58,1790,1791,  51,  52,1804,
  /*  48 */ 1805,  49,  50,1806,1807,  53,  54,1786,1787,  55,  56,1788,
  /*  60 */ 1789,  41,  42,  47,  48,  43,  44,  37,  38,  39,  40,1859,
  /*  72 */ 1860,  13,  12,  83,  84,1810, 101,  87,1811,  90,  91,  97,
  /*  84 */   98,  92,  88,  89,  93,  94,  95,  96,  99, 100,1812,1813,
  /*  96 */   16,1743,  17,1723,1816,1817,1818,1819,1820,1821,  83,  84,
  /* 108 */ 1822,  59,  60,  62,  63,  61,1823,  66,  67,  64,  68,  69,
  /* 120 */   65,  70,1824,1825,  59,  60,  66,  67,  64,  32,1826,1827,
  /* 132 */ 1828,1829,1830,1831,1832,1833,1834,1835,1842,  71,  73,  72,
  /* 144 */ 1836,1837, 105, 106, 103, 104,1838,1839,1840,1841,  33,  34,
  /* 156 */   30,  31,1763,1764,  79,  78, 102,  80,  81,  82,  86,  77,
  /* 168 */ 1845,  79,  82,  86,1846,1847,1848,1849,1850,1851,1852,1853,
  /* 180 */ 1854,  74,1867,1868,1869,1870,1871,1872,1873,1874,1875,1723,
  /* 192 */ 1724,1725,1726,1727,1728,1729,1730,1731,1732,1733,1734,1735,
  /* 204 */ 1736,1737,1738,1739,1740,1741,1742,1743,1744,1745,1746,1747,
  /* 216 */ 1748,1749,1750,1751,1752,1753,1754,1755,1756,1757,1758,1759,
  /* 228 */ 1760,1761,1762,1763,1764,1765,  14,  15,  18,  19,  20,  21,
  /* 240 */   22,  23,  24,  25,  26,  27,  45,  46,  85, 282, 283, 284,
  /* 252 */  285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296,
  /* 264 */  297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308,
  /* 276 */  309, 310, 311, 312, 313, 314, 203, 204, 205, 206, 207, 208,
  /* 288 */  209, 210, 211, 212,1881,1882,1883,1884,1885,1886,1887,1888,
  /* 300 */ 1889,1890,1504,1505,1506,1507,1508,1509,1510,1511,1512,1513,
  /* 312 */ 1514,1515, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229,
  /* 324 */  230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241,
  /* 336 */  242, 243, 244, 245, 252, 253, 254, 255, 256, 257, 258, 259,
  /* 348 */  260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271,
  /* 360 */  272, 273, 274, 275, 276, 277, 470, 471, 472, 473, 474, 475,
  /* 372 */  476, 477, 478, 479, 480, 481, 482, 483, 484, 485, 486, 487,
  /* 384 */  488, 489, 490, 491, 492, 493, 502, 503, 504, 505, 506, 507,
  /* 396 */  508, 509, 510, 511, 512, 513, 514, 515, 516, 517, 518, 519,
  /* 408 */  520, 521, 522, 523, 524, 525,1525,1526,1527,1528,1529,1530,
  /* 420 */ 1531,1532,1533,1534,1535,1536,1537,1538,1539,1540,1541,1542,
  /* 432 */ 1543,1544,1545,1546,1547,1548,1549,1550,1551,1552,1553,1554,
  /* 444 */ 1555,1556,1557,1558,1559,1560,1561,1524,1520,1521,1522,1523,
  /* 456 */  315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326,
  /* 468 */  327, 328,1692,1693,1694,1695,1696,1697,1698,1699,1700,1701,
  /* 480 */ 1708,1709,1710,1711,1712,1713,1714,1715,1716,1717,1897,1898,
  /* 492 */ 1899,1900,1901,1902,1903,1904,1905,1906, 329, 330, 331, 332,
  /* 504 */  333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344,
  /* 516 */  345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356,
  /* 528 */  357, 358, 359, 360, 361, 362, 363, 364, 376, 377, 378, 379,
  /* 540 */  380, 381, 382, 383, 384, 385, 386, 387, 388, 389, 390, 391,
  /* 552 */  392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 403,
  /* 564 */    0,  34, 404, 405, 406, 407, 408, 409, 410, 411, 412, 413,
  /* 820 */  414, 415, 416, 417, 418, 419, 420, 421, 422, 423, 424, 425,
  /* 832 */  426, 427, 428, 429, 430, 431, 432, 433, 434, 435, 436, 437,
  /* 844 */  438, 439, 440, 441, 442, 443, 444, 445, 446, 447, 448, 449,
  /* 856 */  450, 451, 452, 453, 454, 455, 456, 457, 458, 459, 460, 461,
  /* 868 */  564, 565, 566, 567, 568, 569, 570, 571, 572, 573, 574, 575,
  /* 880 */  576, 577, 578, 579, 580, 581, 582, 583, 584, 585, 586, 587,
  /* 892 */  588, 589, 590, 591, 592, 593, 594, 595, 596, 612, 613, 614,
  /* 904 */  615, 616, 617, 618, 619, 620, 621, 622, 623, 624, 625, 626,
  /* 916 */  627, 628, 629, 630, 631, 632, 633, 634, 635, 636, 637, 638,
  /* 928 */  639, 640, 641, 642, 643, 644,1864,1865,1866,1907,1908,1909,
  /* 940 */ 1910,1911,1912,1913 };

   order -= SymOffset;
   if ( !(InRange(0, order, 3134)) ) order = 0;

   switch( InCodeNo )
   {
   case 0 /* B */ :
          if ( InRange(148, order, 149) )
             key = 297 - order;
          else if ( InRange(234, order, 440) )
             key = order + 48;
          else
             key = order;
          break;
   case 1 /* I */ :
          point = OffIndx[ order/200 ];
          while ( order >= Off2Sym[point][0] ) point++;
          key = ( order - Off2Sym[point-1][0] ) + Off2Sym[point-1][1];
          key *= Off2Sym[point-1][1] && 1;
          break;
   case 2 /* N */ :
   case 3 /* E */ :
   case 4 /* T */ :
   case 7 /* P */ :
          key = order;
          break;
   case 5 /*TEL*/ :
          order += 7903;
          key = TEL2TCAtab[order];
          if ( !(key & 0x8000) ) /* If it's not Symbol.           */
             key = 0;            /*    assign the 1'st symbol SP. */
          key &= 0x7fff;
          break;
   case 6 /*IBMH*/:
          order = IBMIN_tab[order];
                  /* IBM HOST Symbol Offset --> IBM 5550 Symbol Offset */
          point = OffIndx[ order/200 ];
          while ( order >= Off2Sym[point][0] ) point++;
          key = ( order - Off2Sym[point-1][0] ) + Off2Sym[point-1][1];
          key *= Off2Sym[point-1][1] && 1;

          break;
   }

   switch ( OutCodeNo )
   {
   case 0 /* B */ :
          if ( InRange(408+48, key, 3134) |
               InRange(234, key, 234+47)  | key < 0 )
             return(SymOffset);
          else if ( InRange(234+48, key, 407+48) )
             return(key-48+SymOffset);
          else if ( InRange(148, key, 149) )
             return(297-key+SymOffset);
          return(key+SymOffset);
          break;
   case 1 /* I */ :
          if ( InRange(0, key, 565) )
             return(Sym2Off[key]+SymOffset);
          else if ( InRange(810, key, 943) )
             return(Sym2Off[key-244]+SymOffset);
          return(SymOffset);
          break;
   case 2 /* N */ :
   case 3 /* E */ :
   case 4 /* T */ :
   case 7 /* P */ :
          if ( InRange(234, key, 281) |
               InRange(456, key, 469) |
               InRange(500, key, 563) |
               InRange(777, key, 3101) )
             return(SymOffset);
          return(key+SymOffset);
          break;
   case 5 /*TEL*/ :
          key = TCA2TELtab[key];
          if ( key & 0x8000 )      /* If it is a Symbol. */
             key = (key & 0x7fff) + SymOffset;
          else if ( key & 0x4000 ) /* If it is in 2'nd Plane. */
             key = (key & 0x3fff) + TELOffset;
          return(key);
          break;
   case 6 /*IBMH*/:
          /*if ( InRange(0, key, 565) )
             key = Sym2Off[key];
          else if ( InRange(810, key, 943) )
             key = Sym2Off[key-244];
          else
             key = 0;

          key = IBMHOST_tab[key];*/
                /* IBM 5550 Symbol Offset --> IBM HOST Symbol Offset */
          printf("error !\n \n \n ");
          return(key+SymOffset);
          break;
   }
  /* return(?);	*/
  /* shin -^^- 1994/04/21 - */
  /* should we return something here to avoid Bus/Alignment Errors ?? */
}

/*****************************************************************************
 *                                                                           *
 *  ... IDent(order) function                                                *
 *      Output No. is identical with input No.                               *
 *                                                                           *
 *****************************************************************************/

static IDent(order)
int order;
{
   return (order);
}

/*****************************************************************************
 *                                                                           *
 *  ... IBMcode(ibm) function                                                *
 *      input>.  the sequential No.                                          *
 *      output>. internal code                                               *
 *                                                                           *
 *****************************************************************************/

static CODE IBMcode(ibm)
int ibm;
{
CODE code;

   code.code = 0L;

   if ( InRange(ASCIIOffset, ibm, 255+ASCIIOffset) )
   {
      code.Byte[0] = ibm-ASCIIOffset;
      return(code);
   }
   else if ( InRange(SymOffset, ibm, 1913+SymOffset) )
   {
      code.Byte[0] = (ibm-SymOffset) / 188 + 0x81;
      code.Byte[1] = (ibm-SymOffset) % 188 + 0x40;
   }
   else if ( InRange(0, ibm, 5400) )
   {
      code.Byte[0] = ibm / 188 + 0x08c;
      code.Byte[1] = ibm % 188 + 0x040;
   }
   else if ( InRange(5401, ibm, 13053) )
   {
      code.Byte[0] = (ibm-5401) / 188 + 0x0a9;
      code.Byte[1] = (ibm-5401) % 188 + 0x040;
   }

   code.Byte[1] += (code.Byte[1] > 0x07e) ? 1 : 0;


   return(code);
}

/*****************************************************************************
 *                                                                           *
 *  ... IBMHcode(hst) function                                               *
 *      input>.  the sequential No.                                          *
 *      output>. internal code                                               *
 *                                                                           *
 *****************************************************************************/

static CODE IBMHcode(IHost)
int IHost;
{
CODE code;

   code.code = 0L;

   if ( InRange(ASCIIOffset, IHost, 255+ASCIIOffset) )
   {
      code.Byte[0] = IHost - ASCIIOffset;
      return(code);
   }
   else if ( IHost == SymOffset )
      code.Byte[0] = code.Byte[1] = 0x40;
   else if ( InRange(SymOffset, IHost, 1913+SymOffset) )
   {
      code.Byte[0] = (IHost-SymOffset-1) / 188 + 0x41;
      code.Byte[1] = (IHost-SymOffset-1) % 188 + 0x41;
   }
   else if ( InRange(0, IHost, 5400) )
   {
      code.Byte[0] = IHost / 188 + 0x04c;
      code.Byte[1] = IHost % 188 + 0x041;
   }
   else if ( InRange(5401, IHost, 13053) )
   {
      code.Byte[0] = (IHost-5401) / 188 + 0x069;
      code.Byte[1] = (IHost-5401) % 188 + 0x041;
   }

   code.Byte[1] += (code.Byte[1] > 0x07f) ? 1 : 0;

   return(code);
}

/*****************************************************************************
 *                                                                           *
 *  ... BIG5code(b5) function                                                *
 *      input>.  the sequential No.                                          *
 *      output>. internal code                                               *
 *                                                                           *
 *****************************************************************************/

static CODE BIG5code(b5)
int b5;
{
CODE code;

   code.code = 0L;

   if ( InRange(ASCIIOffset, b5, 255+ASCIIOffset) )
   {
      code.Byte[0] = b5 - ASCIIOffset;
      return(code);
   }
   else if ( InRange(SymOffset, b5, 440+SymOffset) )
   {
      code.Byte[0] = (b5-SymOffset) / 157 + 0x0a1;
      code.Byte[1] = (b5-SymOffset) % 157 + 0x040;
   }
   else if ( InRange(0, b5, 5400) )
   {
      code.Byte[0] = b5 / 157 + 0x0a4;
      code.Byte[1] = b5 % 157 + 0x040;
   }
   else if ( InRange(5401, b5, 13053) )
   {
      code.Byte[0] = (b5-5401) / 157 + 0x0c9;
      code.Byte[1] = (b5-5401) % 157 + 0x040;
   }

   code.Byte[1] += (code.Byte[1] > 0x07e) ? 0x022 : 0;

   return(code);
}

/*****************************************************************************
 *                                                                           *
 *  ... NSCcode(nsc) function                                                *
 *      input>.  the sequential No.                                          *
 *      output>. internal code                                               *
 *                                                                           *
 *****************************************************************************/

static CODE NSCcode(nsc)
int nsc;
{
CODE code;

   code.code = 0L;

   if ( InRange(ASCIIOffset, nsc, 255+ASCIIOffset) )
   {
      code.Byte[0] = nsc - ASCIIOffset;
      return(code);
   }
   else if ( InRange(SymOffset, nsc, 3134+SymOffset) )
   {
      code.Byte[0] = (nsc-SymOffset) / 94 + 0x021 + 0x080;
      code.Byte[1] = (nsc-SymOffset) % 94 + 0x021 + 0x080;
   }
   else if ( InRange(0, nsc, 5400) )
   {
      code.Byte[0] = nsc / 94 + 0x044 + 0x080;
      code.Byte[1] = nsc % 94 + 0x021 + 0x080;
   }
   else if ( InRange(5401, nsc, 13051) )
   {
      code.Byte[0] = (nsc-5401) / 94 + 0x021 + 0x080;
      code.Byte[1] = (nsc-5401) % 94 + 0x021;
   }

   return(code);
}

/*****************************************************************************
 *                                                                           *
 *  ... NSCPcode(nsc) function                                               *
 *      input>.  the sequential No.                                          *
 *      output>. [Ctrl_code] internal code                                   *
 *                                                                           *
 *****************************************************************************/

static CODE NSCPcode(nsc)
int nsc;
{
CODE code;
unsigned char *p;

   code.code = 0L;
   p = code.Byte;

   if ( InRange(ASCIIOffset, nsc, 255+ASCIIOffset) )
   {
      if ( !SIf1 )
         *p++ = SI;
      SIf1 = ~0;
      SOf1=LS2f1=LS3f1=SS2f1=SS3f1=0;
      *p++ = nsc - ASCIIOffset;
      return(code);
   }
   else  if ( InRange(SymOffset, nsc, 5400) ) /* 1'st Plane */
   /* InRange(SymOffset, nsc, SymOffset+3134) | InRange(0, nsc, 5400) */
   {
      if ( !SOf1 )
         *p++ = SO;
      SOf1 = ~0;
      SIf1=LS2f1=LS3f1=SS2f1=SS3f1=0;
      *p++ = (nsc-((nsc<0)?SymOffset:0)) / 94 + ((nsc<0)?0x21:0x44);
      *p++ = (nsc-((nsc<0)?SymOffset:0)) % 94 + 0x21;
   }
   else if ( InRange(5401, nsc, 13050) ) /* 2'nd Plane */
   {
      code.Byte[0] = ESC; /* SS2 = ESC 4/14 */
      code.Byte[1] = 0x4e;
      code.Byte[2] = (nsc-5401) / 94 + 0x21;
      code.Byte[3] = (nsc-5401) % 94 + 0x21;
   }
   else /* 14'th Plane */
   {
      code.Byte[0] = ESC; /* SS3 = ESC 4/15 */
      code.Byte[1] = 0x4f;
      code.Byte[2] = (nsc-14000) / 94 + 0x21;
      code.Byte[3] = (nsc-14000) % 94 + 0x21;
   }

   return(code);
}

/*****************************************************************************
 *                                                                           *
 *  ... TELcode(tel) function                                                *
 *      input>.  the sequential No.                                          *
 *      output>. internal code                                               *
 *                                                                           *
 *****************************************************************************/

static CODE TELcode(tel)
int tel;
{
CODE code;

   code.code = 0L;

   if ( InRange(7903+SymOffset, tel, 8037+SymOffset) )
      tel -= SymOffset;

   if ( InRange(ASCIIOffset, tel, 255+ASCIIOffset) )
   {
      code.Byte[0] = tel - ASCIIOffset;
      return(code);
   }
   else if ( InRange(0, tel, 8037) ) /* 1'st Plane */
   {
      code.Byte[0] = tel / 94 + 0x0a1;
      code.Byte[1] = tel % 94 + 0x0a1;
   }
   else if ( InRange(TELOffset, tel, 8489+TELOffset) ) /* 2'nd Plane */
   {
      code.Byte[0] = (tel-TELOffset) / 94 + 0x0a1;
      code.Byte[1] = (tel-TELOffset) % 94 + 0x021;
   }

   return(code);
}

/*****************************************************************************
 *                                                                           *
 *  ... TCAcode(tca) function                                                *
 *      input>.  the sequential No.                                          *
 *      output>. internal code                                               *
 *                                                                           *
 *****************************************************************************/

static CODE TCAcode(tca)
int tca;
{
CODE code;

   code.code = 0L;

   if ( InRange(ASCIIOffset, tca, 255+ASCIIOffset) )
   {
      code.Byte[0] = tca - ASCIIOffset;
      return(code);
   }
   else if ( InRange(SymOffset, tca, 3134+SymOffset) )
   {
      code.Byte[0] = (tca-SymOffset) / 188 + 0x081;
      code.Byte[1] = (tca-SymOffset) % 188 + 0x030;
   }
   else if ( InRange(0, tca, 5400) )
   {
      code.Byte[0] = (tca+0x05e) / 188 + 0x092;
      code.Byte[1] = (tca+0x05e) % 188 + 0x030;
   }
   else if ( InRange(5401, tca, 13051) )
   {
      code.Byte[0] = (tca-5401) / 188 + 0x0b0;
      code.Byte[1] = (tca-5401) % 188 + 0x030;
   }

   if ( InRange(0x41-0x07, code.Byte[1], 0x5a-0x07) )
      code.Byte[1] += 0x007;
   else if ( InRange(0x61-0x0d, code.Byte[1], 0x7a-0x0d) )
      code.Byte[1] += 0x00d;
   else if ( InRange(0x80-0x12, code.Byte[1], 0xfd-0x12) )
      code.Byte[1] += 0x012;

   return(code);
}

/*****************************************************************************
 *                                                                           *
 *  ... EUCcode(euc) function                                                *
 *      input>.  the sequential No.                                          *
 *      output>. internal code                                               *
 *                                                                           *
 *****************************************************************************/

static CODE EUCcode(euc)
int euc;
{
CODE code;

   code.code = 0L;

   if ( InRange(ASCIIOffset, euc, 255+ASCIIOffset) )
   {
      code.Byte[0] = euc - ASCIIOffset;
      return(code);
   }
   else if ( InRange(SymOffset, euc, 3134+SymOffset) )
   {
      code.Byte[0] = (euc-SymOffset) / 94 + 0x0a1;
      code.Byte[1] = (euc-SymOffset) % 94 + 0x0a1;
   }
   else if ( InRange(0, euc, 5400) )
   {
      code.Byte[0] = euc / 94 + 0x0c4;
      code.Byte[1] = euc % 94 + 0x0a1;
   }
   else if ( InRange(5401, euc, 13051) )
   {
      code.Byte[0] = 0x8e;
      code.Byte[1] = 0xa2;
      code.Byte[2] = (euc-5401) / 94 + 0x0a1;
      code.Byte[3] = (euc-5401) % 94 + 0x0a1;
   }

   return(code);
}

/*****************************************************************************
 *                                                                           *
 *  ... Alter(InString, OutString, InCodeNo, OutCodeNo) function             *
 *  ..Tch2Tch(InString, OutString, InCodeNo, OutCodeNo, InLen, OutLen)       *
 *      input>.  InString : Input string that is to be converted.            *
 *               InCodeNo : The internal code No. in InString.               *
 *               OutCodeNo: The internal code No. in OutString.              *
 *		 InLen    : Length of InString to be converted               *
 *                      Internal Code No:                                    *
 *                                       0: BIG5                             *
 *                                       1: IBM 5550                         *
 *                                       2: NSC Internal code                *
 *                                       3: EUC                              *
 *                                       4: TCA                              *
 *                                       5: TELegraph                        *
 *                                       6: IBM Host                         *
 *                                       7: NSC with Protocol                *
 *      output>. OutString: Send the converted result to 'OutString'         *
 *                          and transfer chinese mode to English mode.       *
 *		 OutLen   : Length of OutString after conversion             *
 *      return>. Upon successful completion, a string is returned.           *
 *               Otherwise, a value of -1 is returned, and ErrorNo           *
 *               is set to indicate the error.                               *
 *                                                                           *
 *****************************************************************************/

/*
 * @(#)Tch2Tch: conversion between codes for traditional chinese characters
 */
Tch2Tch(InString, OutString, InCodeNo, OutCodeNo, InLen, OutLen)
char *InString, *OutString;
int InCodeNo, OutCodeNo;
int InLen, *OutLen;
{
CODE InId, OutId;
int  InNumber, OutNumber;
char	*OutStrBegAddr;

   InNo  = InCodeNo;
   OutNo = OutCodeNo;
   Ctrl.code = 0L;

   InStr  = InString;
   EndStr = InStr + InLen;
   OutStrBegAddr = OutString;

   while ( InStr < EndStr )
   {
      InId     = GetCode[InNo](&InStr);
      InNumber = Seq[InNo](InId);

      if (InNumber == ErrorNo)
         OutId = Code[OutNo]( SymOffset );
      else if (InRange(ASCIIOffset, InNumber, 256+ASCIIOffset))
         OutId = Code[OutNo]( InNumber );
      else if (InRange(SymOffset, InNumber, 3134+SymOffset))
         OutId = Code[OutNo]( SymbolTab(InNo, OutNo, InNumber) );
      else
         OutId = Code[OutNo]( Transform[InNo][OutNo](InNumber) );

      PutCode[OutNo](OutId, &OutString);
   }

   if ( ((OutNo == 6) || (OutNo == 7)) && !(SIf) )
   {
      OutId.code    = 0L;
      OutId.Byte[0] = SI;
      PutCode[OutNo](OutId, &OutString);
   }

   *OutLen = (int) (OutString - OutStrBegAddr);

   *OutString = 0;
}

/*
 * History:
 *
 * $Log: ccvt.c,v $
 * Revision 1.5  1994/04/21  16:50:52  shin
 * 1. pass buffer lengths explicitly to Alter() so that they are not
 * 	counted with strlen(). This is necessary if your input stream
 * 	contains '\0'. Lacking this step may resulted in difficult in
 * 	coupling with other AP's like 'more'.
 * 2. fix Bus/Alignment errors resulted from exiting a function without
 * 	executing a return() statement. This bug occurs in functions
 * 	which return a structure. (May be also for some other types of
 * 	return's.) See GetNSCPcode() and GetIBMHcode().
 * 3. rearrange the order of the codes so that it is essentially the same
 * 	as the 'code.c' file, which is distributed by III.
 * 4. main() is now moved to 'ccf.c' and 'tw.c' for easy maintenance.
 *
 * Revision 1.4  1994/03/16  18:48:00  shin
 * 1. fix Bus error and binary alignment bugs in Put4Byte
 * 2. incorporate entry points for combination with TWTTY for
 * 	on-line code conversion.
 */
