// Copyright 2013 The Closure Library Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS-IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * @fileoverview List formatting symbols for all locales.
 *
 * This file is autogenerated by script.  See
 * http://go/generate_list_symbols.py using --for_closure
 * File generated from CLDR ver. 32
 *
 * To reduce the file size (which may cause issues in some JS
 * developing environments), this file will only contain locales
 * that are usually supported by Google products. It is a super
 * set of 40 languages. The rest of the data can be found in another file
 * named "listsymbolsext.js", which will be generated at the same
 * time as this file.
 * Before checkin, this file could have been manually edited. This is
 * to incorporate changes before we could correct CLDR. All manual
 * modification must be documented in this section, and should be
 * removed after those changes land to CLDR.
 * @suppress {const}
 */

// clang-format off

goog.provide('goog.labs.i18n.ListFormatSymbolsExt');
goog.provide('goog.labs.i18n.ListFormatSymbols_af_NA');
goog.provide('goog.labs.i18n.ListFormatSymbols_af_ZA');
goog.provide('goog.labs.i18n.ListFormatSymbols_agq');
goog.provide('goog.labs.i18n.ListFormatSymbols_agq_CM');
goog.provide('goog.labs.i18n.ListFormatSymbols_ak');
goog.provide('goog.labs.i18n.ListFormatSymbols_ak_GH');
goog.provide('goog.labs.i18n.ListFormatSymbols_am_ET');
goog.provide('goog.labs.i18n.ListFormatSymbols_ar_001');
goog.provide('goog.labs.i18n.ListFormatSymbols_ar_AE');
goog.provide('goog.labs.i18n.ListFormatSymbols_ar_BH');
goog.provide('goog.labs.i18n.ListFormatSymbols_ar_DJ');
goog.provide('goog.labs.i18n.ListFormatSymbols_ar_EG');
goog.provide('goog.labs.i18n.ListFormatSymbols_ar_EH');
goog.provide('goog.labs.i18n.ListFormatSymbols_ar_ER');
goog.provide('goog.labs.i18n.ListFormatSymbols_ar_IL');
goog.provide('goog.labs.i18n.ListFormatSymbols_ar_IQ');
goog.provide('goog.labs.i18n.ListFormatSymbols_ar_JO');
goog.provide('goog.labs.i18n.ListFormatSymbols_ar_KM');
goog.provide('goog.labs.i18n.ListFormatSymbols_ar_KW');
goog.provide('goog.labs.i18n.ListFormatSymbols_ar_LB');
goog.provide('goog.labs.i18n.ListFormatSymbols_ar_LY');
goog.provide('goog.labs.i18n.ListFormatSymbols_ar_MA');
goog.provide('goog.labs.i18n.ListFormatSymbols_ar_MR');
goog.provide('goog.labs.i18n.ListFormatSymbols_ar_OM');
goog.provide('goog.labs.i18n.ListFormatSymbols_ar_PS');
goog.provide('goog.labs.i18n.ListFormatSymbols_ar_QA');
goog.provide('goog.labs.i18n.ListFormatSymbols_ar_SA');
goog.provide('goog.labs.i18n.ListFormatSymbols_ar_SD');
goog.provide('goog.labs.i18n.ListFormatSymbols_ar_SO');
goog.provide('goog.labs.i18n.ListFormatSymbols_ar_SS');
goog.provide('goog.labs.i18n.ListFormatSymbols_ar_SY');
goog.provide('goog.labs.i18n.ListFormatSymbols_ar_TD');
goog.provide('goog.labs.i18n.ListFormatSymbols_ar_TN');
goog.provide('goog.labs.i18n.ListFormatSymbols_ar_XB');
goog.provide('goog.labs.i18n.ListFormatSymbols_ar_YE');
goog.provide('goog.labs.i18n.ListFormatSymbols_as');
goog.provide('goog.labs.i18n.ListFormatSymbols_as_IN');
goog.provide('goog.labs.i18n.ListFormatSymbols_asa');
goog.provide('goog.labs.i18n.ListFormatSymbols_asa_TZ');
goog.provide('goog.labs.i18n.ListFormatSymbols_ast');
goog.provide('goog.labs.i18n.ListFormatSymbols_ast_ES');
goog.provide('goog.labs.i18n.ListFormatSymbols_az_Cyrl');
goog.provide('goog.labs.i18n.ListFormatSymbols_az_Cyrl_AZ');
goog.provide('goog.labs.i18n.ListFormatSymbols_az_Latn');
goog.provide('goog.labs.i18n.ListFormatSymbols_az_Latn_AZ');
goog.provide('goog.labs.i18n.ListFormatSymbols_bas');
goog.provide('goog.labs.i18n.ListFormatSymbols_bas_CM');
goog.provide('goog.labs.i18n.ListFormatSymbols_be_BY');
goog.provide('goog.labs.i18n.ListFormatSymbols_bem');
goog.provide('goog.labs.i18n.ListFormatSymbols_bem_ZM');
goog.provide('goog.labs.i18n.ListFormatSymbols_bez');
goog.provide('goog.labs.i18n.ListFormatSymbols_bez_TZ');
goog.provide('goog.labs.i18n.ListFormatSymbols_bg_BG');
goog.provide('goog.labs.i18n.ListFormatSymbols_bm');
goog.provide('goog.labs.i18n.ListFormatSymbols_bm_ML');
goog.provide('goog.labs.i18n.ListFormatSymbols_bn_BD');
goog.provide('goog.labs.i18n.ListFormatSymbols_bn_IN');
goog.provide('goog.labs.i18n.ListFormatSymbols_bo');
goog.provide('goog.labs.i18n.ListFormatSymbols_bo_CN');
goog.provide('goog.labs.i18n.ListFormatSymbols_bo_IN');
goog.provide('goog.labs.i18n.ListFormatSymbols_br_FR');
goog.provide('goog.labs.i18n.ListFormatSymbols_brx');
goog.provide('goog.labs.i18n.ListFormatSymbols_brx_IN');
goog.provide('goog.labs.i18n.ListFormatSymbols_bs_Cyrl');
goog.provide('goog.labs.i18n.ListFormatSymbols_bs_Cyrl_BA');
goog.provide('goog.labs.i18n.ListFormatSymbols_bs_Latn');
goog.provide('goog.labs.i18n.ListFormatSymbols_bs_Latn_BA');
goog.provide('goog.labs.i18n.ListFormatSymbols_ca_AD');
goog.provide('goog.labs.i18n.ListFormatSymbols_ca_ES');
goog.provide('goog.labs.i18n.ListFormatSymbols_ca_FR');
goog.provide('goog.labs.i18n.ListFormatSymbols_ca_IT');
goog.provide('goog.labs.i18n.ListFormatSymbols_ccp');
goog.provide('goog.labs.i18n.ListFormatSymbols_ccp_BD');
goog.provide('goog.labs.i18n.ListFormatSymbols_ccp_IN');
goog.provide('goog.labs.i18n.ListFormatSymbols_ce');
goog.provide('goog.labs.i18n.ListFormatSymbols_ce_RU');
goog.provide('goog.labs.i18n.ListFormatSymbols_cgg');
goog.provide('goog.labs.i18n.ListFormatSymbols_cgg_UG');
goog.provide('goog.labs.i18n.ListFormatSymbols_chr_US');
goog.provide('goog.labs.i18n.ListFormatSymbols_ckb');
goog.provide('goog.labs.i18n.ListFormatSymbols_ckb_IQ');
goog.provide('goog.labs.i18n.ListFormatSymbols_ckb_IR');
goog.provide('goog.labs.i18n.ListFormatSymbols_cs_CZ');
goog.provide('goog.labs.i18n.ListFormatSymbols_cy_GB');
goog.provide('goog.labs.i18n.ListFormatSymbols_da_DK');
goog.provide('goog.labs.i18n.ListFormatSymbols_da_GL');
goog.provide('goog.labs.i18n.ListFormatSymbols_dav');
goog.provide('goog.labs.i18n.ListFormatSymbols_dav_KE');
goog.provide('goog.labs.i18n.ListFormatSymbols_de_BE');
goog.provide('goog.labs.i18n.ListFormatSymbols_de_DE');
goog.provide('goog.labs.i18n.ListFormatSymbols_de_IT');
goog.provide('goog.labs.i18n.ListFormatSymbols_de_LI');
goog.provide('goog.labs.i18n.ListFormatSymbols_de_LU');
goog.provide('goog.labs.i18n.ListFormatSymbols_dje');
goog.provide('goog.labs.i18n.ListFormatSymbols_dje_NE');
goog.provide('goog.labs.i18n.ListFormatSymbols_dsb');
goog.provide('goog.labs.i18n.ListFormatSymbols_dsb_DE');
goog.provide('goog.labs.i18n.ListFormatSymbols_dua');
goog.provide('goog.labs.i18n.ListFormatSymbols_dua_CM');
goog.provide('goog.labs.i18n.ListFormatSymbols_dyo');
goog.provide('goog.labs.i18n.ListFormatSymbols_dyo_SN');
goog.provide('goog.labs.i18n.ListFormatSymbols_dz');
goog.provide('goog.labs.i18n.ListFormatSymbols_dz_BT');
goog.provide('goog.labs.i18n.ListFormatSymbols_ebu');
goog.provide('goog.labs.i18n.ListFormatSymbols_ebu_KE');
goog.provide('goog.labs.i18n.ListFormatSymbols_ee');
goog.provide('goog.labs.i18n.ListFormatSymbols_ee_GH');
goog.provide('goog.labs.i18n.ListFormatSymbols_ee_TG');
goog.provide('goog.labs.i18n.ListFormatSymbols_el_CY');
goog.provide('goog.labs.i18n.ListFormatSymbols_el_GR');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_001');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_150');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_AG');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_AI');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_AS');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_AT');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_BB');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_BE');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_BI');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_BM');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_BS');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_BW');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_BZ');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_CC');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_CH');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_CK');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_CM');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_CX');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_CY');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_DE');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_DG');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_DK');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_DM');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_ER');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_FI');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_FJ');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_FK');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_FM');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_GD');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_GG');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_GH');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_GI');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_GM');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_GU');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_GY');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_HK');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_IL');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_IM');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_IO');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_JE');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_JM');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_KE');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_KI');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_KN');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_KY');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_LC');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_LR');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_LS');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_MG');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_MH');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_MO');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_MP');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_MS');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_MT');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_MU');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_MW');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_MY');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_NA');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_NF');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_NG');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_NL');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_NR');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_NU');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_NZ');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_PG');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_PH');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_PK');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_PN');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_PR');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_PW');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_RW');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_SB');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_SC');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_SD');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_SE');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_SH');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_SI');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_SL');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_SS');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_SX');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_SZ');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_TC');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_TK');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_TO');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_TT');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_TV');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_TZ');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_UG');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_UM');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_US_POSIX');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_VC');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_VG');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_VI');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_VU');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_WS');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_XA');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_ZM');
goog.provide('goog.labs.i18n.ListFormatSymbols_en_ZW');
goog.provide('goog.labs.i18n.ListFormatSymbols_eo');
goog.provide('goog.labs.i18n.ListFormatSymbols_es_AR');
goog.provide('goog.labs.i18n.ListFormatSymbols_es_BO');
goog.provide('goog.labs.i18n.ListFormatSymbols_es_BR');
goog.provide('goog.labs.i18n.ListFormatSymbols_es_BZ');
goog.provide('goog.labs.i18n.ListFormatSymbols_es_CL');
goog.provide('goog.labs.i18n.ListFormatSymbols_es_CO');
goog.provide('goog.labs.i18n.ListFormatSymbols_es_CR');
goog.provide('goog.labs.i18n.ListFormatSymbols_es_CU');
goog.provide('goog.labs.i18n.ListFormatSymbols_es_DO');
goog.provide('goog.labs.i18n.ListFormatSymbols_es_EA');
goog.provide('goog.labs.i18n.ListFormatSymbols_es_EC');
goog.provide('goog.labs.i18n.ListFormatSymbols_es_GQ');
goog.provide('goog.labs.i18n.ListFormatSymbols_es_GT');
goog.provide('goog.labs.i18n.ListFormatSymbols_es_HN');
goog.provide('goog.labs.i18n.ListFormatSymbols_es_IC');
goog.provide('goog.labs.i18n.ListFormatSymbols_es_NI');
goog.provide('goog.labs.i18n.ListFormatSymbols_es_PA');
goog.provide('goog.labs.i18n.ListFormatSymbols_es_PE');
goog.provide('goog.labs.i18n.ListFormatSymbols_es_PH');
goog.provide('goog.labs.i18n.ListFormatSymbols_es_PR');
goog.provide('goog.labs.i18n.ListFormatSymbols_es_PY');
goog.provide('goog.labs.i18n.ListFormatSymbols_es_SV');
goog.provide('goog.labs.i18n.ListFormatSymbols_es_UY');
goog.provide('goog.labs.i18n.ListFormatSymbols_es_VE');
goog.provide('goog.labs.i18n.ListFormatSymbols_et_EE');
goog.provide('goog.labs.i18n.ListFormatSymbols_eu_ES');
goog.provide('goog.labs.i18n.ListFormatSymbols_ewo');
goog.provide('goog.labs.i18n.ListFormatSymbols_ewo_CM');
goog.provide('goog.labs.i18n.ListFormatSymbols_fa_AF');
goog.provide('goog.labs.i18n.ListFormatSymbols_fa_IR');
goog.provide('goog.labs.i18n.ListFormatSymbols_ff');
goog.provide('goog.labs.i18n.ListFormatSymbols_ff_CM');
goog.provide('goog.labs.i18n.ListFormatSymbols_ff_GN');
goog.provide('goog.labs.i18n.ListFormatSymbols_ff_MR');
goog.provide('goog.labs.i18n.ListFormatSymbols_ff_SN');
goog.provide('goog.labs.i18n.ListFormatSymbols_fi_FI');
goog.provide('goog.labs.i18n.ListFormatSymbols_fil_PH');
goog.provide('goog.labs.i18n.ListFormatSymbols_fo');
goog.provide('goog.labs.i18n.ListFormatSymbols_fo_DK');
goog.provide('goog.labs.i18n.ListFormatSymbols_fo_FO');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_BE');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_BF');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_BI');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_BJ');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_BL');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_CD');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_CF');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_CG');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_CH');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_CI');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_CM');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_DJ');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_DZ');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_FR');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_GA');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_GF');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_GN');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_GP');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_GQ');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_HT');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_KM');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_LU');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_MA');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_MC');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_MF');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_MG');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_ML');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_MQ');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_MR');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_MU');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_NC');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_NE');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_PF');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_PM');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_RE');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_RW');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_SC');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_SN');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_SY');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_TD');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_TG');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_TN');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_VU');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_WF');
goog.provide('goog.labs.i18n.ListFormatSymbols_fr_YT');
goog.provide('goog.labs.i18n.ListFormatSymbols_fur');
goog.provide('goog.labs.i18n.ListFormatSymbols_fur_IT');
goog.provide('goog.labs.i18n.ListFormatSymbols_fy');
goog.provide('goog.labs.i18n.ListFormatSymbols_fy_NL');
goog.provide('goog.labs.i18n.ListFormatSymbols_ga_IE');
goog.provide('goog.labs.i18n.ListFormatSymbols_gd');
goog.provide('goog.labs.i18n.ListFormatSymbols_gd_GB');
goog.provide('goog.labs.i18n.ListFormatSymbols_gl_ES');
goog.provide('goog.labs.i18n.ListFormatSymbols_gsw_CH');
goog.provide('goog.labs.i18n.ListFormatSymbols_gsw_FR');
goog.provide('goog.labs.i18n.ListFormatSymbols_gsw_LI');
goog.provide('goog.labs.i18n.ListFormatSymbols_gu_IN');
goog.provide('goog.labs.i18n.ListFormatSymbols_guz');
goog.provide('goog.labs.i18n.ListFormatSymbols_guz_KE');
goog.provide('goog.labs.i18n.ListFormatSymbols_gv');
goog.provide('goog.labs.i18n.ListFormatSymbols_gv_IM');
goog.provide('goog.labs.i18n.ListFormatSymbols_ha');
goog.provide('goog.labs.i18n.ListFormatSymbols_ha_GH');
goog.provide('goog.labs.i18n.ListFormatSymbols_ha_NE');
goog.provide('goog.labs.i18n.ListFormatSymbols_ha_NG');
goog.provide('goog.labs.i18n.ListFormatSymbols_haw_US');
goog.provide('goog.labs.i18n.ListFormatSymbols_he_IL');
goog.provide('goog.labs.i18n.ListFormatSymbols_hi_IN');
goog.provide('goog.labs.i18n.ListFormatSymbols_hr_BA');
goog.provide('goog.labs.i18n.ListFormatSymbols_hr_HR');
goog.provide('goog.labs.i18n.ListFormatSymbols_hsb');
goog.provide('goog.labs.i18n.ListFormatSymbols_hsb_DE');
goog.provide('goog.labs.i18n.ListFormatSymbols_hu_HU');
goog.provide('goog.labs.i18n.ListFormatSymbols_hy_AM');
goog.provide('goog.labs.i18n.ListFormatSymbols_id_ID');
goog.provide('goog.labs.i18n.ListFormatSymbols_ig');
goog.provide('goog.labs.i18n.ListFormatSymbols_ig_NG');
goog.provide('goog.labs.i18n.ListFormatSymbols_ii');
goog.provide('goog.labs.i18n.ListFormatSymbols_ii_CN');
goog.provide('goog.labs.i18n.ListFormatSymbols_is_IS');
goog.provide('goog.labs.i18n.ListFormatSymbols_it_CH');
goog.provide('goog.labs.i18n.ListFormatSymbols_it_IT');
goog.provide('goog.labs.i18n.ListFormatSymbols_it_SM');
goog.provide('goog.labs.i18n.ListFormatSymbols_it_VA');
goog.provide('goog.labs.i18n.ListFormatSymbols_ja_JP');
goog.provide('goog.labs.i18n.ListFormatSymbols_jgo');
goog.provide('goog.labs.i18n.ListFormatSymbols_jgo_CM');
goog.provide('goog.labs.i18n.ListFormatSymbols_jmc');
goog.provide('goog.labs.i18n.ListFormatSymbols_jmc_TZ');
goog.provide('goog.labs.i18n.ListFormatSymbols_ka_GE');
goog.provide('goog.labs.i18n.ListFormatSymbols_kab');
goog.provide('goog.labs.i18n.ListFormatSymbols_kab_DZ');
goog.provide('goog.labs.i18n.ListFormatSymbols_kam');
goog.provide('goog.labs.i18n.ListFormatSymbols_kam_KE');
goog.provide('goog.labs.i18n.ListFormatSymbols_kde');
goog.provide('goog.labs.i18n.ListFormatSymbols_kde_TZ');
goog.provide('goog.labs.i18n.ListFormatSymbols_kea');
goog.provide('goog.labs.i18n.ListFormatSymbols_kea_CV');
goog.provide('goog.labs.i18n.ListFormatSymbols_khq');
goog.provide('goog.labs.i18n.ListFormatSymbols_khq_ML');
goog.provide('goog.labs.i18n.ListFormatSymbols_ki');
goog.provide('goog.labs.i18n.ListFormatSymbols_ki_KE');
goog.provide('goog.labs.i18n.ListFormatSymbols_kk_KZ');
goog.provide('goog.labs.i18n.ListFormatSymbols_kkj');
goog.provide('goog.labs.i18n.ListFormatSymbols_kkj_CM');
goog.provide('goog.labs.i18n.ListFormatSymbols_kl');
goog.provide('goog.labs.i18n.ListFormatSymbols_kl_GL');
goog.provide('goog.labs.i18n.ListFormatSymbols_kln');
goog.provide('goog.labs.i18n.ListFormatSymbols_kln_KE');
goog.provide('goog.labs.i18n.ListFormatSymbols_km_KH');
goog.provide('goog.labs.i18n.ListFormatSymbols_kn_IN');
goog.provide('goog.labs.i18n.ListFormatSymbols_ko_KP');
goog.provide('goog.labs.i18n.ListFormatSymbols_ko_KR');
goog.provide('goog.labs.i18n.ListFormatSymbols_kok');
goog.provide('goog.labs.i18n.ListFormatSymbols_kok_IN');
goog.provide('goog.labs.i18n.ListFormatSymbols_ks');
goog.provide('goog.labs.i18n.ListFormatSymbols_ks_IN');
goog.provide('goog.labs.i18n.ListFormatSymbols_ksb');
goog.provide('goog.labs.i18n.ListFormatSymbols_ksb_TZ');
goog.provide('goog.labs.i18n.ListFormatSymbols_ksf');
goog.provide('goog.labs.i18n.ListFormatSymbols_ksf_CM');
goog.provide('goog.labs.i18n.ListFormatSymbols_ksh');
goog.provide('goog.labs.i18n.ListFormatSymbols_ksh_DE');
goog.provide('goog.labs.i18n.ListFormatSymbols_kw');
goog.provide('goog.labs.i18n.ListFormatSymbols_kw_GB');
goog.provide('goog.labs.i18n.ListFormatSymbols_ky_KG');
goog.provide('goog.labs.i18n.ListFormatSymbols_lag');
goog.provide('goog.labs.i18n.ListFormatSymbols_lag_TZ');
goog.provide('goog.labs.i18n.ListFormatSymbols_lb');
goog.provide('goog.labs.i18n.ListFormatSymbols_lb_LU');
goog.provide('goog.labs.i18n.ListFormatSymbols_lg');
goog.provide('goog.labs.i18n.ListFormatSymbols_lg_UG');
goog.provide('goog.labs.i18n.ListFormatSymbols_lkt');
goog.provide('goog.labs.i18n.ListFormatSymbols_lkt_US');
goog.provide('goog.labs.i18n.ListFormatSymbols_ln_AO');
goog.provide('goog.labs.i18n.ListFormatSymbols_ln_CD');
goog.provide('goog.labs.i18n.ListFormatSymbols_ln_CF');
goog.provide('goog.labs.i18n.ListFormatSymbols_ln_CG');
goog.provide('goog.labs.i18n.ListFormatSymbols_lo_LA');
goog.provide('goog.labs.i18n.ListFormatSymbols_lrc');
goog.provide('goog.labs.i18n.ListFormatSymbols_lrc_IQ');
goog.provide('goog.labs.i18n.ListFormatSymbols_lrc_IR');
goog.provide('goog.labs.i18n.ListFormatSymbols_lt_LT');
goog.provide('goog.labs.i18n.ListFormatSymbols_lu');
goog.provide('goog.labs.i18n.ListFormatSymbols_lu_CD');
goog.provide('goog.labs.i18n.ListFormatSymbols_luo');
goog.provide('goog.labs.i18n.ListFormatSymbols_luo_KE');
goog.provide('goog.labs.i18n.ListFormatSymbols_luy');
goog.provide('goog.labs.i18n.ListFormatSymbols_luy_KE');
goog.provide('goog.labs.i18n.ListFormatSymbols_lv_LV');
goog.provide('goog.labs.i18n.ListFormatSymbols_mas');
goog.provide('goog.labs.i18n.ListFormatSymbols_mas_KE');
goog.provide('goog.labs.i18n.ListFormatSymbols_mas_TZ');
goog.provide('goog.labs.i18n.ListFormatSymbols_mer');
goog.provide('goog.labs.i18n.ListFormatSymbols_mer_KE');
goog.provide('goog.labs.i18n.ListFormatSymbols_mfe');
goog.provide('goog.labs.i18n.ListFormatSymbols_mfe_MU');
goog.provide('goog.labs.i18n.ListFormatSymbols_mg');
goog.provide('goog.labs.i18n.ListFormatSymbols_mg_MG');
goog.provide('goog.labs.i18n.ListFormatSymbols_mgh');
goog.provide('goog.labs.i18n.ListFormatSymbols_mgh_MZ');
goog.provide('goog.labs.i18n.ListFormatSymbols_mgo');
goog.provide('goog.labs.i18n.ListFormatSymbols_mgo_CM');
goog.provide('goog.labs.i18n.ListFormatSymbols_mk_MK');
goog.provide('goog.labs.i18n.ListFormatSymbols_ml_IN');
goog.provide('goog.labs.i18n.ListFormatSymbols_mn_MN');
goog.provide('goog.labs.i18n.ListFormatSymbols_mr_IN');
goog.provide('goog.labs.i18n.ListFormatSymbols_ms_BN');
goog.provide('goog.labs.i18n.ListFormatSymbols_ms_MY');
goog.provide('goog.labs.i18n.ListFormatSymbols_ms_SG');
goog.provide('goog.labs.i18n.ListFormatSymbols_mt_MT');
goog.provide('goog.labs.i18n.ListFormatSymbols_mua');
goog.provide('goog.labs.i18n.ListFormatSymbols_mua_CM');
goog.provide('goog.labs.i18n.ListFormatSymbols_my_MM');
goog.provide('goog.labs.i18n.ListFormatSymbols_mzn');
goog.provide('goog.labs.i18n.ListFormatSymbols_mzn_IR');
goog.provide('goog.labs.i18n.ListFormatSymbols_naq');
goog.provide('goog.labs.i18n.ListFormatSymbols_naq_NA');
goog.provide('goog.labs.i18n.ListFormatSymbols_nb_NO');
goog.provide('goog.labs.i18n.ListFormatSymbols_nb_SJ');
goog.provide('goog.labs.i18n.ListFormatSymbols_nd');
goog.provide('goog.labs.i18n.ListFormatSymbols_nd_ZW');
goog.provide('goog.labs.i18n.ListFormatSymbols_nds');
goog.provide('goog.labs.i18n.ListFormatSymbols_nds_DE');
goog.provide('goog.labs.i18n.ListFormatSymbols_nds_NL');
goog.provide('goog.labs.i18n.ListFormatSymbols_ne_IN');
goog.provide('goog.labs.i18n.ListFormatSymbols_ne_NP');
goog.provide('goog.labs.i18n.ListFormatSymbols_nl_AW');
goog.provide('goog.labs.i18n.ListFormatSymbols_nl_BE');
goog.provide('goog.labs.i18n.ListFormatSymbols_nl_BQ');
goog.provide('goog.labs.i18n.ListFormatSymbols_nl_CW');
goog.provide('goog.labs.i18n.ListFormatSymbols_nl_NL');
goog.provide('goog.labs.i18n.ListFormatSymbols_nl_SR');
goog.provide('goog.labs.i18n.ListFormatSymbols_nl_SX');
goog.provide('goog.labs.i18n.ListFormatSymbols_nmg');
goog.provide('goog.labs.i18n.ListFormatSymbols_nmg_CM');
goog.provide('goog.labs.i18n.ListFormatSymbols_nn');
goog.provide('goog.labs.i18n.ListFormatSymbols_nn_NO');
goog.provide('goog.labs.i18n.ListFormatSymbols_nnh');
goog.provide('goog.labs.i18n.ListFormatSymbols_nnh_CM');
goog.provide('goog.labs.i18n.ListFormatSymbols_nus');
goog.provide('goog.labs.i18n.ListFormatSymbols_nus_SS');
goog.provide('goog.labs.i18n.ListFormatSymbols_nyn');
goog.provide('goog.labs.i18n.ListFormatSymbols_nyn_UG');
goog.provide('goog.labs.i18n.ListFormatSymbols_om');
goog.provide('goog.labs.i18n.ListFormatSymbols_om_ET');
goog.provide('goog.labs.i18n.ListFormatSymbols_om_KE');
goog.provide('goog.labs.i18n.ListFormatSymbols_or_IN');
goog.provide('goog.labs.i18n.ListFormatSymbols_os');
goog.provide('goog.labs.i18n.ListFormatSymbols_os_GE');
goog.provide('goog.labs.i18n.ListFormatSymbols_os_RU');
goog.provide('goog.labs.i18n.ListFormatSymbols_pa_Arab');
goog.provide('goog.labs.i18n.ListFormatSymbols_pa_Arab_PK');
goog.provide('goog.labs.i18n.ListFormatSymbols_pa_Guru');
goog.provide('goog.labs.i18n.ListFormatSymbols_pa_Guru_IN');
goog.provide('goog.labs.i18n.ListFormatSymbols_pl_PL');
goog.provide('goog.labs.i18n.ListFormatSymbols_ps');
goog.provide('goog.labs.i18n.ListFormatSymbols_ps_AF');
goog.provide('goog.labs.i18n.ListFormatSymbols_pt_AO');
goog.provide('goog.labs.i18n.ListFormatSymbols_pt_CH');
goog.provide('goog.labs.i18n.ListFormatSymbols_pt_CV');
goog.provide('goog.labs.i18n.ListFormatSymbols_pt_GQ');
goog.provide('goog.labs.i18n.ListFormatSymbols_pt_GW');
goog.provide('goog.labs.i18n.ListFormatSymbols_pt_LU');
goog.provide('goog.labs.i18n.ListFormatSymbols_pt_MO');
goog.provide('goog.labs.i18n.ListFormatSymbols_pt_MZ');
goog.provide('goog.labs.i18n.ListFormatSymbols_pt_ST');
goog.provide('goog.labs.i18n.ListFormatSymbols_pt_TL');
goog.provide('goog.labs.i18n.ListFormatSymbols_qu');
goog.provide('goog.labs.i18n.ListFormatSymbols_qu_BO');
goog.provide('goog.labs.i18n.ListFormatSymbols_qu_EC');
goog.provide('goog.labs.i18n.ListFormatSymbols_qu_PE');
goog.provide('goog.labs.i18n.ListFormatSymbols_rm');
goog.provide('goog.labs.i18n.ListFormatSymbols_rm_CH');
goog.provide('goog.labs.i18n.ListFormatSymbols_rn');
goog.provide('goog.labs.i18n.ListFormatSymbols_rn_BI');
goog.provide('goog.labs.i18n.ListFormatSymbols_ro_MD');
goog.provide('goog.labs.i18n.ListFormatSymbols_ro_RO');
goog.provide('goog.labs.i18n.ListFormatSymbols_rof');
goog.provide('goog.labs.i18n.ListFormatSymbols_rof_TZ');
goog.provide('goog.labs.i18n.ListFormatSymbols_ru_BY');
goog.provide('goog.labs.i18n.ListFormatSymbols_ru_KG');
goog.provide('goog.labs.i18n.ListFormatSymbols_ru_KZ');
goog.provide('goog.labs.i18n.ListFormatSymbols_ru_MD');
goog.provide('goog.labs.i18n.ListFormatSymbols_ru_RU');
goog.provide('goog.labs.i18n.ListFormatSymbols_ru_UA');
goog.provide('goog.labs.i18n.ListFormatSymbols_rw');
goog.provide('goog.labs.i18n.ListFormatSymbols_rw_RW');
goog.provide('goog.labs.i18n.ListFormatSymbols_rwk');
goog.provide('goog.labs.i18n.ListFormatSymbols_rwk_TZ');
goog.provide('goog.labs.i18n.ListFormatSymbols_sah');
goog.provide('goog.labs.i18n.ListFormatSymbols_sah_RU');
goog.provide('goog.labs.i18n.ListFormatSymbols_saq');
goog.provide('goog.labs.i18n.ListFormatSymbols_saq_KE');
goog.provide('goog.labs.i18n.ListFormatSymbols_sbp');
goog.provide('goog.labs.i18n.ListFormatSymbols_sbp_TZ');
goog.provide('goog.labs.i18n.ListFormatSymbols_se');
goog.provide('goog.labs.i18n.ListFormatSymbols_se_FI');
goog.provide('goog.labs.i18n.ListFormatSymbols_se_NO');
goog.provide('goog.labs.i18n.ListFormatSymbols_se_SE');
goog.provide('goog.labs.i18n.ListFormatSymbols_seh');
goog.provide('goog.labs.i18n.ListFormatSymbols_seh_MZ');
goog.provide('goog.labs.i18n.ListFormatSymbols_ses');
goog.provide('goog.labs.i18n.ListFormatSymbols_ses_ML');
goog.provide('goog.labs.i18n.ListFormatSymbols_sg');
goog.provide('goog.labs.i18n.ListFormatSymbols_sg_CF');
goog.provide('goog.labs.i18n.ListFormatSymbols_shi');
goog.provide('goog.labs.i18n.ListFormatSymbols_shi_Latn');
goog.provide('goog.labs.i18n.ListFormatSymbols_shi_Latn_MA');
goog.provide('goog.labs.i18n.ListFormatSymbols_shi_Tfng');
goog.provide('goog.labs.i18n.ListFormatSymbols_shi_Tfng_MA');
goog.provide('goog.labs.i18n.ListFormatSymbols_si_LK');
goog.provide('goog.labs.i18n.ListFormatSymbols_sk_SK');
goog.provide('goog.labs.i18n.ListFormatSymbols_sl_SI');
goog.provide('goog.labs.i18n.ListFormatSymbols_smn');
goog.provide('goog.labs.i18n.ListFormatSymbols_smn_FI');
goog.provide('goog.labs.i18n.ListFormatSymbols_sn');
goog.provide('goog.labs.i18n.ListFormatSymbols_sn_ZW');
goog.provide('goog.labs.i18n.ListFormatSymbols_so');
goog.provide('goog.labs.i18n.ListFormatSymbols_so_DJ');
goog.provide('goog.labs.i18n.ListFormatSymbols_so_ET');
goog.provide('goog.labs.i18n.ListFormatSymbols_so_KE');
goog.provide('goog.labs.i18n.ListFormatSymbols_so_SO');
goog.provide('goog.labs.i18n.ListFormatSymbols_sq_AL');
goog.provide('goog.labs.i18n.ListFormatSymbols_sq_MK');
goog.provide('goog.labs.i18n.ListFormatSymbols_sq_XK');
goog.provide('goog.labs.i18n.ListFormatSymbols_sr_Cyrl');
goog.provide('goog.labs.i18n.ListFormatSymbols_sr_Cyrl_BA');
goog.provide('goog.labs.i18n.ListFormatSymbols_sr_Cyrl_ME');
goog.provide('goog.labs.i18n.ListFormatSymbols_sr_Cyrl_RS');
goog.provide('goog.labs.i18n.ListFormatSymbols_sr_Cyrl_XK');
goog.provide('goog.labs.i18n.ListFormatSymbols_sr_Latn_BA');
goog.provide('goog.labs.i18n.ListFormatSymbols_sr_Latn_ME');
goog.provide('goog.labs.i18n.ListFormatSymbols_sr_Latn_RS');
goog.provide('goog.labs.i18n.ListFormatSymbols_sr_Latn_XK');
goog.provide('goog.labs.i18n.ListFormatSymbols_sv_AX');
goog.provide('goog.labs.i18n.ListFormatSymbols_sv_FI');
goog.provide('goog.labs.i18n.ListFormatSymbols_sv_SE');
goog.provide('goog.labs.i18n.ListFormatSymbols_sw_CD');
goog.provide('goog.labs.i18n.ListFormatSymbols_sw_KE');
goog.provide('goog.labs.i18n.ListFormatSymbols_sw_TZ');
goog.provide('goog.labs.i18n.ListFormatSymbols_sw_UG');
goog.provide('goog.labs.i18n.ListFormatSymbols_ta_IN');
goog.provide('goog.labs.i18n.ListFormatSymbols_ta_LK');
goog.provide('goog.labs.i18n.ListFormatSymbols_ta_MY');
goog.provide('goog.labs.i18n.ListFormatSymbols_ta_SG');
goog.provide('goog.labs.i18n.ListFormatSymbols_te_IN');
goog.provide('goog.labs.i18n.ListFormatSymbols_teo');
goog.provide('goog.labs.i18n.ListFormatSymbols_teo_KE');
goog.provide('goog.labs.i18n.ListFormatSymbols_teo_UG');
goog.provide('goog.labs.i18n.ListFormatSymbols_tg');
goog.provide('goog.labs.i18n.ListFormatSymbols_tg_TJ');
goog.provide('goog.labs.i18n.ListFormatSymbols_th_TH');
goog.provide('goog.labs.i18n.ListFormatSymbols_ti');
goog.provide('goog.labs.i18n.ListFormatSymbols_ti_ER');
goog.provide('goog.labs.i18n.ListFormatSymbols_ti_ET');
goog.provide('goog.labs.i18n.ListFormatSymbols_to');
goog.provide('goog.labs.i18n.ListFormatSymbols_to_TO');
goog.provide('goog.labs.i18n.ListFormatSymbols_tr_CY');
goog.provide('goog.labs.i18n.ListFormatSymbols_tr_TR');
goog.provide('goog.labs.i18n.ListFormatSymbols_tt');
goog.provide('goog.labs.i18n.ListFormatSymbols_tt_RU');
goog.provide('goog.labs.i18n.ListFormatSymbols_twq');
goog.provide('goog.labs.i18n.ListFormatSymbols_twq_NE');
goog.provide('goog.labs.i18n.ListFormatSymbols_tzm');
goog.provide('goog.labs.i18n.ListFormatSymbols_tzm_MA');
goog.provide('goog.labs.i18n.ListFormatSymbols_ug');
goog.provide('goog.labs.i18n.ListFormatSymbols_ug_CN');
goog.provide('goog.labs.i18n.ListFormatSymbols_uk_UA');
goog.provide('goog.labs.i18n.ListFormatSymbols_ur_IN');
goog.provide('goog.labs.i18n.ListFormatSymbols_ur_PK');
goog.provide('goog.labs.i18n.ListFormatSymbols_uz_Arab');
goog.provide('goog.labs.i18n.ListFormatSymbols_uz_Arab_AF');
goog.provide('goog.labs.i18n.ListFormatSymbols_uz_Cyrl');
goog.provide('goog.labs.i18n.ListFormatSymbols_uz_Cyrl_UZ');
goog.provide('goog.labs.i18n.ListFormatSymbols_uz_Latn');
goog.provide('goog.labs.i18n.ListFormatSymbols_uz_Latn_UZ');
goog.provide('goog.labs.i18n.ListFormatSymbols_vai');
goog.provide('goog.labs.i18n.ListFormatSymbols_vai_Latn');
goog.provide('goog.labs.i18n.ListFormatSymbols_vai_Latn_LR');
goog.provide('goog.labs.i18n.ListFormatSymbols_vai_Vaii');
goog.provide('goog.labs.i18n.ListFormatSymbols_vai_Vaii_LR');
goog.provide('goog.labs.i18n.ListFormatSymbols_vi_VN');
goog.provide('goog.labs.i18n.ListFormatSymbols_vun');
goog.provide('goog.labs.i18n.ListFormatSymbols_vun_TZ');
goog.provide('goog.labs.i18n.ListFormatSymbols_wae');
goog.provide('goog.labs.i18n.ListFormatSymbols_wae_CH');
goog.provide('goog.labs.i18n.ListFormatSymbols_wo');
goog.provide('goog.labs.i18n.ListFormatSymbols_wo_SN');
goog.provide('goog.labs.i18n.ListFormatSymbols_xog');
goog.provide('goog.labs.i18n.ListFormatSymbols_xog_UG');
goog.provide('goog.labs.i18n.ListFormatSymbols_yav');
goog.provide('goog.labs.i18n.ListFormatSymbols_yav_CM');
goog.provide('goog.labs.i18n.ListFormatSymbols_yi');
goog.provide('goog.labs.i18n.ListFormatSymbols_yi_001');
goog.provide('goog.labs.i18n.ListFormatSymbols_yo');
goog.provide('goog.labs.i18n.ListFormatSymbols_yo_BJ');
goog.provide('goog.labs.i18n.ListFormatSymbols_yo_NG');
goog.provide('goog.labs.i18n.ListFormatSymbols_yue');
goog.provide('goog.labs.i18n.ListFormatSymbols_yue_Hans');
goog.provide('goog.labs.i18n.ListFormatSymbols_yue_Hans_CN');
goog.provide('goog.labs.i18n.ListFormatSymbols_yue_Hant');
goog.provide('goog.labs.i18n.ListFormatSymbols_yue_Hant_HK');
goog.provide('goog.labs.i18n.ListFormatSymbols_zgh');
goog.provide('goog.labs.i18n.ListFormatSymbols_zgh_MA');
goog.provide('goog.labs.i18n.ListFormatSymbols_zh_Hans');
goog.provide('goog.labs.i18n.ListFormatSymbols_zh_Hans_CN');
goog.provide('goog.labs.i18n.ListFormatSymbols_zh_Hans_HK');
goog.provide('goog.labs.i18n.ListFormatSymbols_zh_Hans_MO');
goog.provide('goog.labs.i18n.ListFormatSymbols_zh_Hans_SG');
goog.provide('goog.labs.i18n.ListFormatSymbols_zh_Hant');
goog.provide('goog.labs.i18n.ListFormatSymbols_zh_Hant_HK');
goog.provide('goog.labs.i18n.ListFormatSymbols_zh_Hant_MO');
goog.provide('goog.labs.i18n.ListFormatSymbols_zh_Hant_TW');
goog.provide('goog.labs.i18n.ListFormatSymbols_zu_ZA');

goog.require('goog.labs.i18n.ListFormatSymbols');


/**
 * List formatting symbols for locale af_NA.
 */
goog.labs.i18n.ListFormatSymbols_af_NA = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} en {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} en {1}'
};


/**
 * List formatting symbols for locale af_ZA.
 */
goog.labs.i18n.ListFormatSymbols_af_ZA = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} en {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} en {1}'
};


/**
 * List formatting symbols for locale agq.
 */
goog.labs.i18n.ListFormatSymbols_agq = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale agq_CM.
 */
goog.labs.i18n.ListFormatSymbols_agq_CM = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ak.
 */
goog.labs.i18n.ListFormatSymbols_ak = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ak_GH.
 */
goog.labs.i18n.ListFormatSymbols_ak_GH = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale am_ET.
 */
goog.labs.i18n.ListFormatSymbols_am_ET = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} እና {1}',
  LIST_START: '{0}፣ {1}',
  LIST_MIDDLE: '{0}፣ {1}',
  LIST_END: '{0}, እና {1}'
};


/**
 * List formatting symbols for locale ar_001.
 */
goog.labs.i18n.ListFormatSymbols_ar_001 = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} و{1}',
  LIST_START: '{0}، {1}',
  LIST_MIDDLE: '{0}، {1}',
  LIST_END: '{0}، و{1}'
};


/**
 * List formatting symbols for locale ar_AE.
 */
goog.labs.i18n.ListFormatSymbols_ar_AE = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} و{1}',
  LIST_START: '{0}، {1}',
  LIST_MIDDLE: '{0}، {1}',
  LIST_END: '{0}، و{1}'
};


/**
 * List formatting symbols for locale ar_BH.
 */
goog.labs.i18n.ListFormatSymbols_ar_BH = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} و{1}',
  LIST_START: '{0}، {1}',
  LIST_MIDDLE: '{0}، {1}',
  LIST_END: '{0}، و{1}'
};


/**
 * List formatting symbols for locale ar_DJ.
 */
goog.labs.i18n.ListFormatSymbols_ar_DJ = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} و{1}',
  LIST_START: '{0}، {1}',
  LIST_MIDDLE: '{0}، {1}',
  LIST_END: '{0}، و{1}'
};


/**
 * List formatting symbols for locale ar_EG.
 */
goog.labs.i18n.ListFormatSymbols_ar_EG = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} و{1}',
  LIST_START: '{0}، {1}',
  LIST_MIDDLE: '{0}، {1}',
  LIST_END: '{0}، و{1}'
};


/**
 * List formatting symbols for locale ar_EH.
 */
goog.labs.i18n.ListFormatSymbols_ar_EH = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} و{1}',
  LIST_START: '{0}، {1}',
  LIST_MIDDLE: '{0}، {1}',
  LIST_END: '{0}، و{1}'
};


/**
 * List formatting symbols for locale ar_ER.
 */
goog.labs.i18n.ListFormatSymbols_ar_ER = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} و{1}',
  LIST_START: '{0}، {1}',
  LIST_MIDDLE: '{0}، {1}',
  LIST_END: '{0}، و{1}'
};


/**
 * List formatting symbols for locale ar_IL.
 */
goog.labs.i18n.ListFormatSymbols_ar_IL = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} و{1}',
  LIST_START: '{0}، {1}',
  LIST_MIDDLE: '{0}، {1}',
  LIST_END: '{0}، و{1}'
};


/**
 * List formatting symbols for locale ar_IQ.
 */
goog.labs.i18n.ListFormatSymbols_ar_IQ = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} و{1}',
  LIST_START: '{0}، {1}',
  LIST_MIDDLE: '{0}، {1}',
  LIST_END: '{0}، و{1}'
};


/**
 * List formatting symbols for locale ar_JO.
 */
goog.labs.i18n.ListFormatSymbols_ar_JO = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} و{1}',
  LIST_START: '{0}، {1}',
  LIST_MIDDLE: '{0}، {1}',
  LIST_END: '{0}، و{1}'
};


/**
 * List formatting symbols for locale ar_KM.
 */
goog.labs.i18n.ListFormatSymbols_ar_KM = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} و{1}',
  LIST_START: '{0}، {1}',
  LIST_MIDDLE: '{0}، {1}',
  LIST_END: '{0}، و{1}'
};


/**
 * List formatting symbols for locale ar_KW.
 */
goog.labs.i18n.ListFormatSymbols_ar_KW = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} و{1}',
  LIST_START: '{0}، {1}',
  LIST_MIDDLE: '{0}، {1}',
  LIST_END: '{0}، و{1}'
};


/**
 * List formatting symbols for locale ar_LB.
 */
goog.labs.i18n.ListFormatSymbols_ar_LB = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} و{1}',
  LIST_START: '{0}، {1}',
  LIST_MIDDLE: '{0}، {1}',
  LIST_END: '{0}، و{1}'
};


/**
 * List formatting symbols for locale ar_LY.
 */
goog.labs.i18n.ListFormatSymbols_ar_LY = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} و{1}',
  LIST_START: '{0}، {1}',
  LIST_MIDDLE: '{0}، {1}',
  LIST_END: '{0}، و{1}'
};


/**
 * List formatting symbols for locale ar_MA.
 */
goog.labs.i18n.ListFormatSymbols_ar_MA = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} و{1}',
  LIST_START: '{0}، {1}',
  LIST_MIDDLE: '{0}، {1}',
  LIST_END: '{0}، و{1}'
};


/**
 * List formatting symbols for locale ar_MR.
 */
goog.labs.i18n.ListFormatSymbols_ar_MR = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} و{1}',
  LIST_START: '{0}، {1}',
  LIST_MIDDLE: '{0}، {1}',
  LIST_END: '{0}، و{1}'
};


/**
 * List formatting symbols for locale ar_OM.
 */
goog.labs.i18n.ListFormatSymbols_ar_OM = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} و{1}',
  LIST_START: '{0}، {1}',
  LIST_MIDDLE: '{0}، {1}',
  LIST_END: '{0}، و{1}'
};


/**
 * List formatting symbols for locale ar_PS.
 */
goog.labs.i18n.ListFormatSymbols_ar_PS = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} و{1}',
  LIST_START: '{0}، {1}',
  LIST_MIDDLE: '{0}، {1}',
  LIST_END: '{0}، و{1}'
};


/**
 * List formatting symbols for locale ar_QA.
 */
goog.labs.i18n.ListFormatSymbols_ar_QA = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} و{1}',
  LIST_START: '{0}، {1}',
  LIST_MIDDLE: '{0}، {1}',
  LIST_END: '{0}، و{1}'
};


/**
 * List formatting symbols for locale ar_SA.
 */
goog.labs.i18n.ListFormatSymbols_ar_SA = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} و{1}',
  LIST_START: '{0}، {1}',
  LIST_MIDDLE: '{0}، {1}',
  LIST_END: '{0}، و{1}'
};


/**
 * List formatting symbols for locale ar_SD.
 */
goog.labs.i18n.ListFormatSymbols_ar_SD = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} و{1}',
  LIST_START: '{0}، {1}',
  LIST_MIDDLE: '{0}، {1}',
  LIST_END: '{0}، و{1}'
};


/**
 * List formatting symbols for locale ar_SO.
 */
goog.labs.i18n.ListFormatSymbols_ar_SO = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} و{1}',
  LIST_START: '{0}، {1}',
  LIST_MIDDLE: '{0}، {1}',
  LIST_END: '{0}، و{1}'
};


/**
 * List formatting symbols for locale ar_SS.
 */
goog.labs.i18n.ListFormatSymbols_ar_SS = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} و{1}',
  LIST_START: '{0}، {1}',
  LIST_MIDDLE: '{0}، {1}',
  LIST_END: '{0}، و{1}'
};


/**
 * List formatting symbols for locale ar_SY.
 */
goog.labs.i18n.ListFormatSymbols_ar_SY = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} و{1}',
  LIST_START: '{0}، {1}',
  LIST_MIDDLE: '{0}، {1}',
  LIST_END: '{0}، و{1}'
};


/**
 * List formatting symbols for locale ar_TD.
 */
goog.labs.i18n.ListFormatSymbols_ar_TD = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} و{1}',
  LIST_START: '{0}، {1}',
  LIST_MIDDLE: '{0}، {1}',
  LIST_END: '{0}، و{1}'
};


/**
 * List formatting symbols for locale ar_TN.
 */
goog.labs.i18n.ListFormatSymbols_ar_TN = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} و{1}',
  LIST_START: '{0}، {1}',
  LIST_MIDDLE: '{0}، {1}',
  LIST_END: '{0}، و{1}'
};


/**
 * List formatting symbols for locale ar_XB.
 */
goog.labs.i18n.ListFormatSymbols_ar_XB = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} ؜‮and‬؜ {1}',
  LIST_START: '{0}، {1}',
  LIST_MIDDLE: '{0}، {1}',
  LIST_END: '{0}, ؜‮and‬؜ {1}'
};


/**
 * List formatting symbols for locale ar_YE.
 */
goog.labs.i18n.ListFormatSymbols_ar_YE = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} و{1}',
  LIST_START: '{0}، {1}',
  LIST_MIDDLE: '{0}، {1}',
  LIST_END: '{0}، و{1}'
};


/**
 * List formatting symbols for locale as.
 */
goog.labs.i18n.ListFormatSymbols_as = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale as_IN.
 */
goog.labs.i18n.ListFormatSymbols_as_IN = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale asa.
 */
goog.labs.i18n.ListFormatSymbols_asa = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale asa_TZ.
 */
goog.labs.i18n.ListFormatSymbols_asa_TZ = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ast.
 */
goog.labs.i18n.ListFormatSymbols_ast = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} y {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} y {1}'
};


/**
 * List formatting symbols for locale ast_ES.
 */
goog.labs.i18n.ListFormatSymbols_ast_ES = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} y {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} y {1}'
};


/**
 * List formatting symbols for locale az_Cyrl.
 */
goog.labs.i18n.ListFormatSymbols_az_Cyrl = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale az_Cyrl_AZ.
 */
goog.labs.i18n.ListFormatSymbols_az_Cyrl_AZ = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale az_Latn.
 */
goog.labs.i18n.ListFormatSymbols_az_Latn = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} və {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} və {1}'
};


/**
 * List formatting symbols for locale az_Latn_AZ.
 */
goog.labs.i18n.ListFormatSymbols_az_Latn_AZ = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} və {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} və {1}'
};


/**
 * List formatting symbols for locale bas.
 */
goog.labs.i18n.ListFormatSymbols_bas = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale bas_CM.
 */
goog.labs.i18n.ListFormatSymbols_bas_CM = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale be_BY.
 */
goog.labs.i18n.ListFormatSymbols_be_BY = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} і {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} і {1}'
};


/**
 * List formatting symbols for locale bem.
 */
goog.labs.i18n.ListFormatSymbols_bem = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale bem_ZM.
 */
goog.labs.i18n.ListFormatSymbols_bem_ZM = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale bez.
 */
goog.labs.i18n.ListFormatSymbols_bez = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale bez_TZ.
 */
goog.labs.i18n.ListFormatSymbols_bez_TZ = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale bg_BG.
 */
goog.labs.i18n.ListFormatSymbols_bg_BG = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} и {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} и {1}'
};


/**
 * List formatting symbols for locale bm.
 */
goog.labs.i18n.ListFormatSymbols_bm = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale bm_ML.
 */
goog.labs.i18n.ListFormatSymbols_bm_ML = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale bn_BD.
 */
goog.labs.i18n.ListFormatSymbols_bn_BD = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} এবং {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} এবং {1}'
};


/**
 * List formatting symbols for locale bn_IN.
 */
goog.labs.i18n.ListFormatSymbols_bn_IN = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} এবং {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} এবং {1}'
};


/**
 * List formatting symbols for locale bo.
 */
goog.labs.i18n.ListFormatSymbols_bo = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale bo_CN.
 */
goog.labs.i18n.ListFormatSymbols_bo_CN = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale bo_IN.
 */
goog.labs.i18n.ListFormatSymbols_bo_IN = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale br_FR.
 */
goog.labs.i18n.ListFormatSymbols_br_FR = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale brx.
 */
goog.labs.i18n.ListFormatSymbols_brx = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale brx_IN.
 */
goog.labs.i18n.ListFormatSymbols_brx_IN = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale bs_Cyrl.
 */
goog.labs.i18n.ListFormatSymbols_bs_Cyrl = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} и {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} и {1}'
};


/**
 * List formatting symbols for locale bs_Cyrl_BA.
 */
goog.labs.i18n.ListFormatSymbols_bs_Cyrl_BA = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} и {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} и {1}'
};


/**
 * List formatting symbols for locale bs_Latn.
 */
goog.labs.i18n.ListFormatSymbols_bs_Latn = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} i {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} i {1}'
};


/**
 * List formatting symbols for locale bs_Latn_BA.
 */
goog.labs.i18n.ListFormatSymbols_bs_Latn_BA = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} i {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} i {1}'
};


/**
 * List formatting symbols for locale ca_AD.
 */
goog.labs.i18n.ListFormatSymbols_ca_AD = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} i {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} i {1}'
};


/**
 * List formatting symbols for locale ca_ES.
 */
goog.labs.i18n.ListFormatSymbols_ca_ES = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} i {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} i {1}'
};


/**
 * List formatting symbols for locale ca_FR.
 */
goog.labs.i18n.ListFormatSymbols_ca_FR = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} i {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} i {1}'
};


/**
 * List formatting symbols for locale ca_IT.
 */
goog.labs.i18n.ListFormatSymbols_ca_IT = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} i {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} i {1}'
};


/**
 * List formatting symbols for locale ccp.
 */
goog.labs.i18n.ListFormatSymbols_ccp = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} 𑄃𑄳𑄃 {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} 𑄃𑄳𑄃 {1}'
};


/**
 * List formatting symbols for locale ccp_BD.
 */
goog.labs.i18n.ListFormatSymbols_ccp_BD = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} 𑄃𑄳𑄃 {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} 𑄃𑄳𑄃 {1}'
};


/**
 * List formatting symbols for locale ccp_IN.
 */
goog.labs.i18n.ListFormatSymbols_ccp_IN = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} 𑄃𑄳𑄃 {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} 𑄃𑄳𑄃 {1}'
};


/**
 * List formatting symbols for locale ce.
 */
goog.labs.i18n.ListFormatSymbols_ce = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ce_RU.
 */
goog.labs.i18n.ListFormatSymbols_ce_RU = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale cgg.
 */
goog.labs.i18n.ListFormatSymbols_cgg = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale cgg_UG.
 */
goog.labs.i18n.ListFormatSymbols_cgg_UG = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale chr_US.
 */
goog.labs.i18n.ListFormatSymbols_chr_US = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} ᎠᎴ {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} ᎠᎴ {1}'
};


/**
 * List formatting symbols for locale ckb.
 */
goog.labs.i18n.ListFormatSymbols_ckb = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ckb_IQ.
 */
goog.labs.i18n.ListFormatSymbols_ckb_IQ = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ckb_IR.
 */
goog.labs.i18n.ListFormatSymbols_ckb_IR = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale cs_CZ.
 */
goog.labs.i18n.ListFormatSymbols_cs_CZ = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} a {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} a {1}'
};


/**
 * List formatting symbols for locale cy_GB.
 */
goog.labs.i18n.ListFormatSymbols_cy_GB = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} a(c) {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, a(c) {1}'
};


/**
 * List formatting symbols for locale da_DK.
 */
goog.labs.i18n.ListFormatSymbols_da_DK = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} og {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} og {1}'
};


/**
 * List formatting symbols for locale da_GL.
 */
goog.labs.i18n.ListFormatSymbols_da_GL = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} og {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} og {1}'
};


/**
 * List formatting symbols for locale dav.
 */
goog.labs.i18n.ListFormatSymbols_dav = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale dav_KE.
 */
goog.labs.i18n.ListFormatSymbols_dav_KE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale de_BE.
 */
goog.labs.i18n.ListFormatSymbols_de_BE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} und {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} und {1}'
};


/**
 * List formatting symbols for locale de_DE.
 */
goog.labs.i18n.ListFormatSymbols_de_DE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} und {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} und {1}'
};


/**
 * List formatting symbols for locale de_IT.
 */
goog.labs.i18n.ListFormatSymbols_de_IT = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} und {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} und {1}'
};


/**
 * List formatting symbols for locale de_LI.
 */
goog.labs.i18n.ListFormatSymbols_de_LI = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} und {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} und {1}'
};


/**
 * List formatting symbols for locale de_LU.
 */
goog.labs.i18n.ListFormatSymbols_de_LU = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} und {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} und {1}'
};


/**
 * List formatting symbols for locale dje.
 */
goog.labs.i18n.ListFormatSymbols_dje = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale dje_NE.
 */
goog.labs.i18n.ListFormatSymbols_dje_NE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale dsb.
 */
goog.labs.i18n.ListFormatSymbols_dsb = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} a {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} a {1}'
};


/**
 * List formatting symbols for locale dsb_DE.
 */
goog.labs.i18n.ListFormatSymbols_dsb_DE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} a {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} a {1}'
};


/**
 * List formatting symbols for locale dua.
 */
goog.labs.i18n.ListFormatSymbols_dua = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale dua_CM.
 */
goog.labs.i18n.ListFormatSymbols_dua_CM = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale dyo.
 */
goog.labs.i18n.ListFormatSymbols_dyo = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale dyo_SN.
 */
goog.labs.i18n.ListFormatSymbols_dyo_SN = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale dz.
 */
goog.labs.i18n.ListFormatSymbols_dz = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} དང་ {1}',
  LIST_START: '{0} དང་ {1}',
  LIST_MIDDLE: '{0} དང་ {1}',
  LIST_END: '{0} དང་ {1}'
};


/**
 * List formatting symbols for locale dz_BT.
 */
goog.labs.i18n.ListFormatSymbols_dz_BT = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} དང་ {1}',
  LIST_START: '{0} དང་ {1}',
  LIST_MIDDLE: '{0} དང་ {1}',
  LIST_END: '{0} དང་ {1}'
};


/**
 * List formatting symbols for locale ebu.
 */
goog.labs.i18n.ListFormatSymbols_ebu = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ebu_KE.
 */
goog.labs.i18n.ListFormatSymbols_ebu_KE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ee.
 */
goog.labs.i18n.ListFormatSymbols_ee = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} kple {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, kple {1}'
};


/**
 * List formatting symbols for locale ee_GH.
 */
goog.labs.i18n.ListFormatSymbols_ee_GH = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} kple {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, kple {1}'
};


/**
 * List formatting symbols for locale ee_TG.
 */
goog.labs.i18n.ListFormatSymbols_ee_TG = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} kple {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, kple {1}'
};


/**
 * List formatting symbols for locale el_CY.
 */
goog.labs.i18n.ListFormatSymbols_el_CY = {
  GENDER_STYLE: 1,
  LIST_TWO: '{0} και {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} και {1}'
};


/**
 * List formatting symbols for locale el_GR.
 */
goog.labs.i18n.ListFormatSymbols_el_GR = {
  GENDER_STYLE: 1,
  LIST_TWO: '{0} και {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} και {1}'
};


/**
 * List formatting symbols for locale en_001.
 */
goog.labs.i18n.ListFormatSymbols_en_001 = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_150.
 */
goog.labs.i18n.ListFormatSymbols_en_150 = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_AG.
 */
goog.labs.i18n.ListFormatSymbols_en_AG = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_AI.
 */
goog.labs.i18n.ListFormatSymbols_en_AI = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_AS.
 */
goog.labs.i18n.ListFormatSymbols_en_AS = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_AT.
 */
goog.labs.i18n.ListFormatSymbols_en_AT = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_BB.
 */
goog.labs.i18n.ListFormatSymbols_en_BB = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_BE.
 */
goog.labs.i18n.ListFormatSymbols_en_BE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_BI.
 */
goog.labs.i18n.ListFormatSymbols_en_BI = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_BM.
 */
goog.labs.i18n.ListFormatSymbols_en_BM = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_BS.
 */
goog.labs.i18n.ListFormatSymbols_en_BS = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_BW.
 */
goog.labs.i18n.ListFormatSymbols_en_BW = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_BZ.
 */
goog.labs.i18n.ListFormatSymbols_en_BZ = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_CC.
 */
goog.labs.i18n.ListFormatSymbols_en_CC = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_CH.
 */
goog.labs.i18n.ListFormatSymbols_en_CH = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_CK.
 */
goog.labs.i18n.ListFormatSymbols_en_CK = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_CM.
 */
goog.labs.i18n.ListFormatSymbols_en_CM = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_CX.
 */
goog.labs.i18n.ListFormatSymbols_en_CX = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_CY.
 */
goog.labs.i18n.ListFormatSymbols_en_CY = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_DE.
 */
goog.labs.i18n.ListFormatSymbols_en_DE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_DG.
 */
goog.labs.i18n.ListFormatSymbols_en_DG = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_DK.
 */
goog.labs.i18n.ListFormatSymbols_en_DK = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_DM.
 */
goog.labs.i18n.ListFormatSymbols_en_DM = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_ER.
 */
goog.labs.i18n.ListFormatSymbols_en_ER = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_FI.
 */
goog.labs.i18n.ListFormatSymbols_en_FI = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_FJ.
 */
goog.labs.i18n.ListFormatSymbols_en_FJ = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_FK.
 */
goog.labs.i18n.ListFormatSymbols_en_FK = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_FM.
 */
goog.labs.i18n.ListFormatSymbols_en_FM = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_GD.
 */
goog.labs.i18n.ListFormatSymbols_en_GD = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_GG.
 */
goog.labs.i18n.ListFormatSymbols_en_GG = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_GH.
 */
goog.labs.i18n.ListFormatSymbols_en_GH = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_GI.
 */
goog.labs.i18n.ListFormatSymbols_en_GI = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_GM.
 */
goog.labs.i18n.ListFormatSymbols_en_GM = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_GU.
 */
goog.labs.i18n.ListFormatSymbols_en_GU = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_GY.
 */
goog.labs.i18n.ListFormatSymbols_en_GY = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_HK.
 */
goog.labs.i18n.ListFormatSymbols_en_HK = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_IL.
 */
goog.labs.i18n.ListFormatSymbols_en_IL = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_IM.
 */
goog.labs.i18n.ListFormatSymbols_en_IM = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_IO.
 */
goog.labs.i18n.ListFormatSymbols_en_IO = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_JE.
 */
goog.labs.i18n.ListFormatSymbols_en_JE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_JM.
 */
goog.labs.i18n.ListFormatSymbols_en_JM = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_KE.
 */
goog.labs.i18n.ListFormatSymbols_en_KE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_KI.
 */
goog.labs.i18n.ListFormatSymbols_en_KI = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_KN.
 */
goog.labs.i18n.ListFormatSymbols_en_KN = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_KY.
 */
goog.labs.i18n.ListFormatSymbols_en_KY = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_LC.
 */
goog.labs.i18n.ListFormatSymbols_en_LC = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_LR.
 */
goog.labs.i18n.ListFormatSymbols_en_LR = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_LS.
 */
goog.labs.i18n.ListFormatSymbols_en_LS = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_MG.
 */
goog.labs.i18n.ListFormatSymbols_en_MG = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_MH.
 */
goog.labs.i18n.ListFormatSymbols_en_MH = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_MO.
 */
goog.labs.i18n.ListFormatSymbols_en_MO = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_MP.
 */
goog.labs.i18n.ListFormatSymbols_en_MP = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_MS.
 */
goog.labs.i18n.ListFormatSymbols_en_MS = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_MT.
 */
goog.labs.i18n.ListFormatSymbols_en_MT = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_MU.
 */
goog.labs.i18n.ListFormatSymbols_en_MU = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_MW.
 */
goog.labs.i18n.ListFormatSymbols_en_MW = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_MY.
 */
goog.labs.i18n.ListFormatSymbols_en_MY = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_NA.
 */
goog.labs.i18n.ListFormatSymbols_en_NA = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_NF.
 */
goog.labs.i18n.ListFormatSymbols_en_NF = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_NG.
 */
goog.labs.i18n.ListFormatSymbols_en_NG = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_NL.
 */
goog.labs.i18n.ListFormatSymbols_en_NL = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_NR.
 */
goog.labs.i18n.ListFormatSymbols_en_NR = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_NU.
 */
goog.labs.i18n.ListFormatSymbols_en_NU = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_NZ.
 */
goog.labs.i18n.ListFormatSymbols_en_NZ = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_PG.
 */
goog.labs.i18n.ListFormatSymbols_en_PG = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_PH.
 */
goog.labs.i18n.ListFormatSymbols_en_PH = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_PK.
 */
goog.labs.i18n.ListFormatSymbols_en_PK = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_PN.
 */
goog.labs.i18n.ListFormatSymbols_en_PN = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_PR.
 */
goog.labs.i18n.ListFormatSymbols_en_PR = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_PW.
 */
goog.labs.i18n.ListFormatSymbols_en_PW = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_RW.
 */
goog.labs.i18n.ListFormatSymbols_en_RW = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_SB.
 */
goog.labs.i18n.ListFormatSymbols_en_SB = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_SC.
 */
goog.labs.i18n.ListFormatSymbols_en_SC = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_SD.
 */
goog.labs.i18n.ListFormatSymbols_en_SD = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_SE.
 */
goog.labs.i18n.ListFormatSymbols_en_SE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_SH.
 */
goog.labs.i18n.ListFormatSymbols_en_SH = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_SI.
 */
goog.labs.i18n.ListFormatSymbols_en_SI = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_SL.
 */
goog.labs.i18n.ListFormatSymbols_en_SL = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_SS.
 */
goog.labs.i18n.ListFormatSymbols_en_SS = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_SX.
 */
goog.labs.i18n.ListFormatSymbols_en_SX = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_SZ.
 */
goog.labs.i18n.ListFormatSymbols_en_SZ = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_TC.
 */
goog.labs.i18n.ListFormatSymbols_en_TC = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_TK.
 */
goog.labs.i18n.ListFormatSymbols_en_TK = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_TO.
 */
goog.labs.i18n.ListFormatSymbols_en_TO = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_TT.
 */
goog.labs.i18n.ListFormatSymbols_en_TT = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_TV.
 */
goog.labs.i18n.ListFormatSymbols_en_TV = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_TZ.
 */
goog.labs.i18n.ListFormatSymbols_en_TZ = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_UG.
 */
goog.labs.i18n.ListFormatSymbols_en_UG = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_UM.
 */
goog.labs.i18n.ListFormatSymbols_en_UM = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_US_POSIX.
 */
goog.labs.i18n.ListFormatSymbols_en_US_POSIX = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_VC.
 */
goog.labs.i18n.ListFormatSymbols_en_VC = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_VG.
 */
goog.labs.i18n.ListFormatSymbols_en_VG = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_VI.
 */
goog.labs.i18n.ListFormatSymbols_en_VI = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_VU.
 */
goog.labs.i18n.ListFormatSymbols_en_VU = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_WS.
 */
goog.labs.i18n.ListFormatSymbols_en_WS = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_XA.
 */
goog.labs.i18n.ListFormatSymbols_en_XA = {
  GENDER_STYLE: 0,
  LIST_TWO: '[{0} åñð {1} one]',
  LIST_START: '[{0}، {1} one]',
  LIST_MIDDLE: '[{0}، {1} one]',
  LIST_END: '[{0}، åñð {1} one]'
};


/**
 * List formatting symbols for locale en_ZM.
 */
goog.labs.i18n.ListFormatSymbols_en_ZM = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale en_ZW.
 */
goog.labs.i18n.ListFormatSymbols_en_ZW = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale eo.
 */
goog.labs.i18n.ListFormatSymbols_eo = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale es_AR.
 */
goog.labs.i18n.ListFormatSymbols_es_AR = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} y {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} y {1}'
};


/**
 * List formatting symbols for locale es_BO.
 */
goog.labs.i18n.ListFormatSymbols_es_BO = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} y {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} y {1}'
};


/**
 * List formatting symbols for locale es_BR.
 */
goog.labs.i18n.ListFormatSymbols_es_BR = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} y {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} y {1}'
};


/**
 * List formatting symbols for locale es_BZ.
 */
goog.labs.i18n.ListFormatSymbols_es_BZ = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} y {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} y {1}'
};


/**
 * List formatting symbols for locale es_CL.
 */
goog.labs.i18n.ListFormatSymbols_es_CL = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} y {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} y {1}'
};


/**
 * List formatting symbols for locale es_CO.
 */
goog.labs.i18n.ListFormatSymbols_es_CO = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} y {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} y {1}'
};


/**
 * List formatting symbols for locale es_CR.
 */
goog.labs.i18n.ListFormatSymbols_es_CR = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} y {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} y {1}'
};


/**
 * List formatting symbols for locale es_CU.
 */
goog.labs.i18n.ListFormatSymbols_es_CU = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} y {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} y {1}'
};


/**
 * List formatting symbols for locale es_DO.
 */
goog.labs.i18n.ListFormatSymbols_es_DO = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} y {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} y {1}'
};


/**
 * List formatting symbols for locale es_EA.
 */
goog.labs.i18n.ListFormatSymbols_es_EA = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} y {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} y {1}'
};


/**
 * List formatting symbols for locale es_EC.
 */
goog.labs.i18n.ListFormatSymbols_es_EC = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} y {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} y {1}'
};


/**
 * List formatting symbols for locale es_GQ.
 */
goog.labs.i18n.ListFormatSymbols_es_GQ = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} y {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} y {1}'
};


/**
 * List formatting symbols for locale es_GT.
 */
goog.labs.i18n.ListFormatSymbols_es_GT = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} y {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} y {1}'
};


/**
 * List formatting symbols for locale es_HN.
 */
goog.labs.i18n.ListFormatSymbols_es_HN = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} y {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} y {1}'
};


/**
 * List formatting symbols for locale es_IC.
 */
goog.labs.i18n.ListFormatSymbols_es_IC = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} y {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} y {1}'
};


/**
 * List formatting symbols for locale es_NI.
 */
goog.labs.i18n.ListFormatSymbols_es_NI = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} y {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} y {1}'
};


/**
 * List formatting symbols for locale es_PA.
 */
goog.labs.i18n.ListFormatSymbols_es_PA = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} y {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} y {1}'
};


/**
 * List formatting symbols for locale es_PE.
 */
goog.labs.i18n.ListFormatSymbols_es_PE = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} y {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} y {1}'
};


/**
 * List formatting symbols for locale es_PH.
 */
goog.labs.i18n.ListFormatSymbols_es_PH = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} y {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} y {1}'
};


/**
 * List formatting symbols for locale es_PR.
 */
goog.labs.i18n.ListFormatSymbols_es_PR = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} y {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} y {1}'
};


/**
 * List formatting symbols for locale es_PY.
 */
goog.labs.i18n.ListFormatSymbols_es_PY = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} y {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} y {1}'
};


/**
 * List formatting symbols for locale es_SV.
 */
goog.labs.i18n.ListFormatSymbols_es_SV = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} y {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} y {1}'
};


/**
 * List formatting symbols for locale es_UY.
 */
goog.labs.i18n.ListFormatSymbols_es_UY = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} y {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} y {1}'
};


/**
 * List formatting symbols for locale es_VE.
 */
goog.labs.i18n.ListFormatSymbols_es_VE = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} y {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} y {1}'
};


/**
 * List formatting symbols for locale et_EE.
 */
goog.labs.i18n.ListFormatSymbols_et_EE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} ja {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} ja {1}'
};


/**
 * List formatting symbols for locale eu_ES.
 */
goog.labs.i18n.ListFormatSymbols_eu_ES = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} eta {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} eta {1}'
};


/**
 * List formatting symbols for locale ewo.
 */
goog.labs.i18n.ListFormatSymbols_ewo = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ewo_CM.
 */
goog.labs.i18n.ListFormatSymbols_ewo_CM = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale fa_AF.
 */
goog.labs.i18n.ListFormatSymbols_fa_AF = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} و {1}',
  LIST_START: '{0}،‏ {1}',
  LIST_MIDDLE: '{0}،‏ {1}',
  LIST_END: '{0}، و {1}'
};


/**
 * List formatting symbols for locale fa_IR.
 */
goog.labs.i18n.ListFormatSymbols_fa_IR = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} و {1}',
  LIST_START: '{0}،‏ {1}',
  LIST_MIDDLE: '{0}،‏ {1}',
  LIST_END: '{0}، و {1}'
};


/**
 * List formatting symbols for locale ff.
 */
goog.labs.i18n.ListFormatSymbols_ff = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ff_CM.
 */
goog.labs.i18n.ListFormatSymbols_ff_CM = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ff_GN.
 */
goog.labs.i18n.ListFormatSymbols_ff_GN = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ff_MR.
 */
goog.labs.i18n.ListFormatSymbols_ff_MR = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ff_SN.
 */
goog.labs.i18n.ListFormatSymbols_ff_SN = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale fi_FI.
 */
goog.labs.i18n.ListFormatSymbols_fi_FI = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} ja {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} ja {1}'
};


/**
 * List formatting symbols for locale fil_PH.
 */
goog.labs.i18n.ListFormatSymbols_fil_PH = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} at {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, at {1}'
};


/**
 * List formatting symbols for locale fo.
 */
goog.labs.i18n.ListFormatSymbols_fo = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} og {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} og {1}'
};


/**
 * List formatting symbols for locale fo_DK.
 */
goog.labs.i18n.ListFormatSymbols_fo_DK = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} og {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} og {1}'
};


/**
 * List formatting symbols for locale fo_FO.
 */
goog.labs.i18n.ListFormatSymbols_fo_FO = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} og {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} og {1}'
};


/**
 * List formatting symbols for locale fr_BE.
 */
goog.labs.i18n.ListFormatSymbols_fr_BE = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_BF.
 */
goog.labs.i18n.ListFormatSymbols_fr_BF = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_BI.
 */
goog.labs.i18n.ListFormatSymbols_fr_BI = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_BJ.
 */
goog.labs.i18n.ListFormatSymbols_fr_BJ = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_BL.
 */
goog.labs.i18n.ListFormatSymbols_fr_BL = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_CD.
 */
goog.labs.i18n.ListFormatSymbols_fr_CD = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_CF.
 */
goog.labs.i18n.ListFormatSymbols_fr_CF = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_CG.
 */
goog.labs.i18n.ListFormatSymbols_fr_CG = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_CH.
 */
goog.labs.i18n.ListFormatSymbols_fr_CH = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_CI.
 */
goog.labs.i18n.ListFormatSymbols_fr_CI = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_CM.
 */
goog.labs.i18n.ListFormatSymbols_fr_CM = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_DJ.
 */
goog.labs.i18n.ListFormatSymbols_fr_DJ = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_DZ.
 */
goog.labs.i18n.ListFormatSymbols_fr_DZ = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_FR.
 */
goog.labs.i18n.ListFormatSymbols_fr_FR = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_GA.
 */
goog.labs.i18n.ListFormatSymbols_fr_GA = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_GF.
 */
goog.labs.i18n.ListFormatSymbols_fr_GF = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_GN.
 */
goog.labs.i18n.ListFormatSymbols_fr_GN = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_GP.
 */
goog.labs.i18n.ListFormatSymbols_fr_GP = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_GQ.
 */
goog.labs.i18n.ListFormatSymbols_fr_GQ = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_HT.
 */
goog.labs.i18n.ListFormatSymbols_fr_HT = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_KM.
 */
goog.labs.i18n.ListFormatSymbols_fr_KM = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_LU.
 */
goog.labs.i18n.ListFormatSymbols_fr_LU = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_MA.
 */
goog.labs.i18n.ListFormatSymbols_fr_MA = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_MC.
 */
goog.labs.i18n.ListFormatSymbols_fr_MC = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_MF.
 */
goog.labs.i18n.ListFormatSymbols_fr_MF = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_MG.
 */
goog.labs.i18n.ListFormatSymbols_fr_MG = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_ML.
 */
goog.labs.i18n.ListFormatSymbols_fr_ML = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_MQ.
 */
goog.labs.i18n.ListFormatSymbols_fr_MQ = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_MR.
 */
goog.labs.i18n.ListFormatSymbols_fr_MR = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_MU.
 */
goog.labs.i18n.ListFormatSymbols_fr_MU = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_NC.
 */
goog.labs.i18n.ListFormatSymbols_fr_NC = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_NE.
 */
goog.labs.i18n.ListFormatSymbols_fr_NE = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_PF.
 */
goog.labs.i18n.ListFormatSymbols_fr_PF = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_PM.
 */
goog.labs.i18n.ListFormatSymbols_fr_PM = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_RE.
 */
goog.labs.i18n.ListFormatSymbols_fr_RE = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_RW.
 */
goog.labs.i18n.ListFormatSymbols_fr_RW = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_SC.
 */
goog.labs.i18n.ListFormatSymbols_fr_SC = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_SN.
 */
goog.labs.i18n.ListFormatSymbols_fr_SN = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_SY.
 */
goog.labs.i18n.ListFormatSymbols_fr_SY = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_TD.
 */
goog.labs.i18n.ListFormatSymbols_fr_TD = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_TG.
 */
goog.labs.i18n.ListFormatSymbols_fr_TG = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_TN.
 */
goog.labs.i18n.ListFormatSymbols_fr_TN = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_VU.
 */
goog.labs.i18n.ListFormatSymbols_fr_VU = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_WF.
 */
goog.labs.i18n.ListFormatSymbols_fr_WF = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fr_YT.
 */
goog.labs.i18n.ListFormatSymbols_fr_YT = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} et {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} et {1}'
};


/**
 * List formatting symbols for locale fur.
 */
goog.labs.i18n.ListFormatSymbols_fur = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} e {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} e {1}'
};


/**
 * List formatting symbols for locale fur_IT.
 */
goog.labs.i18n.ListFormatSymbols_fur_IT = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} e {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} e {1}'
};


/**
 * List formatting symbols for locale fy.
 */
goog.labs.i18n.ListFormatSymbols_fy = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} en {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} en {1}'
};


/**
 * List formatting symbols for locale fy_NL.
 */
goog.labs.i18n.ListFormatSymbols_fy_NL = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} en {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} en {1}'
};


/**
 * List formatting symbols for locale ga_IE.
 */
goog.labs.i18n.ListFormatSymbols_ga_IE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} agus {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, agus {1}'
};


/**
 * List formatting symbols for locale gd.
 */
goog.labs.i18n.ListFormatSymbols_gd = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} agus {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} agus {1}'
};


/**
 * List formatting symbols for locale gd_GB.
 */
goog.labs.i18n.ListFormatSymbols_gd_GB = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} agus {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} agus {1}'
};


/**
 * List formatting symbols for locale gl_ES.
 */
goog.labs.i18n.ListFormatSymbols_gl_ES = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} e {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} e {1}'
};


/**
 * List formatting symbols for locale gsw_CH.
 */
goog.labs.i18n.ListFormatSymbols_gsw_CH = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} und {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} und {1}'
};


/**
 * List formatting symbols for locale gsw_FR.
 */
goog.labs.i18n.ListFormatSymbols_gsw_FR = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} und {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} und {1}'
};


/**
 * List formatting symbols for locale gsw_LI.
 */
goog.labs.i18n.ListFormatSymbols_gsw_LI = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} und {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} und {1}'
};


/**
 * List formatting symbols for locale gu_IN.
 */
goog.labs.i18n.ListFormatSymbols_gu_IN = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} અને {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} અને {1}'
};


/**
 * List formatting symbols for locale guz.
 */
goog.labs.i18n.ListFormatSymbols_guz = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale guz_KE.
 */
goog.labs.i18n.ListFormatSymbols_guz_KE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale gv.
 */
goog.labs.i18n.ListFormatSymbols_gv = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale gv_IM.
 */
goog.labs.i18n.ListFormatSymbols_gv_IM = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ha.
 */
goog.labs.i18n.ListFormatSymbols_ha = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ha_GH.
 */
goog.labs.i18n.ListFormatSymbols_ha_GH = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ha_NE.
 */
goog.labs.i18n.ListFormatSymbols_ha_NE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ha_NG.
 */
goog.labs.i18n.ListFormatSymbols_ha_NG = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale haw_US.
 */
goog.labs.i18n.ListFormatSymbols_haw_US = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale he_IL.
 */
goog.labs.i18n.ListFormatSymbols_he_IL = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} ו{1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} ו{1}'
};


/**
 * List formatting symbols for locale hi_IN.
 */
goog.labs.i18n.ListFormatSymbols_hi_IN = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} और {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, और {1}'
};


/**
 * List formatting symbols for locale hr_BA.
 */
goog.labs.i18n.ListFormatSymbols_hr_BA = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} i {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} i {1}'
};


/**
 * List formatting symbols for locale hr_HR.
 */
goog.labs.i18n.ListFormatSymbols_hr_HR = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} i {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} i {1}'
};


/**
 * List formatting symbols for locale hsb.
 */
goog.labs.i18n.ListFormatSymbols_hsb = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} a {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} a {1}'
};


/**
 * List formatting symbols for locale hsb_DE.
 */
goog.labs.i18n.ListFormatSymbols_hsb_DE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} a {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} a {1}'
};


/**
 * List formatting symbols for locale hu_HU.
 */
goog.labs.i18n.ListFormatSymbols_hu_HU = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} és {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} és {1}'
};


/**
 * List formatting symbols for locale hy_AM.
 */
goog.labs.i18n.ListFormatSymbols_hy_AM = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} և {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} և {1}'
};


/**
 * List formatting symbols for locale id_ID.
 */
goog.labs.i18n.ListFormatSymbols_id_ID = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} dan {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, dan {1}'
};


/**
 * List formatting symbols for locale ig.
 */
goog.labs.i18n.ListFormatSymbols_ig = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ig_NG.
 */
goog.labs.i18n.ListFormatSymbols_ig_NG = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ii.
 */
goog.labs.i18n.ListFormatSymbols_ii = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ii_CN.
 */
goog.labs.i18n.ListFormatSymbols_ii_CN = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale is_IS.
 */
goog.labs.i18n.ListFormatSymbols_is_IS = {
  GENDER_STYLE: 1,
  LIST_TWO: '{0} og {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} og {1}'
};


/**
 * List formatting symbols for locale it_CH.
 */
goog.labs.i18n.ListFormatSymbols_it_CH = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} e {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} e {1}'
};


/**
 * List formatting symbols for locale it_IT.
 */
goog.labs.i18n.ListFormatSymbols_it_IT = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} e {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} e {1}'
};


/**
 * List formatting symbols for locale it_SM.
 */
goog.labs.i18n.ListFormatSymbols_it_SM = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} e {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} e {1}'
};


/**
 * List formatting symbols for locale it_VA.
 */
goog.labs.i18n.ListFormatSymbols_it_VA = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} e {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} e {1}'
};


/**
 * List formatting symbols for locale ja_JP.
 */
goog.labs.i18n.ListFormatSymbols_ja_JP = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}、{1}',
  LIST_START: '{0}、{1}',
  LIST_MIDDLE: '{0}、{1}',
  LIST_END: '{0}、{1}'
};


/**
 * List formatting symbols for locale jgo.
 */
goog.labs.i18n.ListFormatSymbols_jgo = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} pɔp {1}',
  LIST_START: '{0}, ŋ́gɛ {1}',
  LIST_MIDDLE: '{0}, ŋ́gɛ {1}',
  LIST_END: '{0}, ḿbɛn ŋ́gɛ {1}'
};


/**
 * List formatting symbols for locale jgo_CM.
 */
goog.labs.i18n.ListFormatSymbols_jgo_CM = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} pɔp {1}',
  LIST_START: '{0}, ŋ́gɛ {1}',
  LIST_MIDDLE: '{0}, ŋ́gɛ {1}',
  LIST_END: '{0}, ḿbɛn ŋ́gɛ {1}'
};


/**
 * List formatting symbols for locale jmc.
 */
goog.labs.i18n.ListFormatSymbols_jmc = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale jmc_TZ.
 */
goog.labs.i18n.ListFormatSymbols_jmc_TZ = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ka_GE.
 */
goog.labs.i18n.ListFormatSymbols_ka_GE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} და {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} და {1}'
};


/**
 * List formatting symbols for locale kab.
 */
goog.labs.i18n.ListFormatSymbols_kab = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale kab_DZ.
 */
goog.labs.i18n.ListFormatSymbols_kab_DZ = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale kam.
 */
goog.labs.i18n.ListFormatSymbols_kam = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale kam_KE.
 */
goog.labs.i18n.ListFormatSymbols_kam_KE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale kde.
 */
goog.labs.i18n.ListFormatSymbols_kde = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale kde_TZ.
 */
goog.labs.i18n.ListFormatSymbols_kde_TZ = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale kea.
 */
goog.labs.i18n.ListFormatSymbols_kea = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} i {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} i {1}'
};


/**
 * List formatting symbols for locale kea_CV.
 */
goog.labs.i18n.ListFormatSymbols_kea_CV = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} i {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} i {1}'
};


/**
 * List formatting symbols for locale khq.
 */
goog.labs.i18n.ListFormatSymbols_khq = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale khq_ML.
 */
goog.labs.i18n.ListFormatSymbols_khq_ML = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ki.
 */
goog.labs.i18n.ListFormatSymbols_ki = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ki_KE.
 */
goog.labs.i18n.ListFormatSymbols_ki_KE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale kk_KZ.
 */
goog.labs.i18n.ListFormatSymbols_kk_KZ = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} және {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale kkj.
 */
goog.labs.i18n.ListFormatSymbols_kkj = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale kkj_CM.
 */
goog.labs.i18n.ListFormatSymbols_kkj_CM = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale kl.
 */
goog.labs.i18n.ListFormatSymbols_kl = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale kl_GL.
 */
goog.labs.i18n.ListFormatSymbols_kl_GL = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale kln.
 */
goog.labs.i18n.ListFormatSymbols_kln = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale kln_KE.
 */
goog.labs.i18n.ListFormatSymbols_kln_KE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale km_KH.
 */
goog.labs.i18n.ListFormatSymbols_km_KH = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} និង​{1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} និង {1}'
};


/**
 * List formatting symbols for locale kn_IN.
 */
goog.labs.i18n.ListFormatSymbols_kn_IN = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} ಮತ್ತು {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, ಮತ್ತು {1}'
};


/**
 * List formatting symbols for locale ko_KP.
 */
goog.labs.i18n.ListFormatSymbols_ko_KP = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} 및 {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} 및 {1}'
};


/**
 * List formatting symbols for locale ko_KR.
 */
goog.labs.i18n.ListFormatSymbols_ko_KR = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} 및 {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} 및 {1}'
};


/**
 * List formatting symbols for locale kok.
 */
goog.labs.i18n.ListFormatSymbols_kok = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale kok_IN.
 */
goog.labs.i18n.ListFormatSymbols_kok_IN = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ks.
 */
goog.labs.i18n.ListFormatSymbols_ks = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ks_IN.
 */
goog.labs.i18n.ListFormatSymbols_ks_IN = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ksb.
 */
goog.labs.i18n.ListFormatSymbols_ksb = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ksb_TZ.
 */
goog.labs.i18n.ListFormatSymbols_ksb_TZ = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ksf.
 */
goog.labs.i18n.ListFormatSymbols_ksf = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ksf_CM.
 */
goog.labs.i18n.ListFormatSymbols_ksf_CM = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ksh.
 */
goog.labs.i18n.ListFormatSymbols_ksh = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} un {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} un {1}'
};


/**
 * List formatting symbols for locale ksh_DE.
 */
goog.labs.i18n.ListFormatSymbols_ksh_DE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} un {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} un {1}'
};


/**
 * List formatting symbols for locale kw.
 */
goog.labs.i18n.ListFormatSymbols_kw = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale kw_GB.
 */
goog.labs.i18n.ListFormatSymbols_kw_GB = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ky_KG.
 */
goog.labs.i18n.ListFormatSymbols_ky_KG = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} жана {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} жана {1}'
};


/**
 * List formatting symbols for locale lag.
 */
goog.labs.i18n.ListFormatSymbols_lag = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale lag_TZ.
 */
goog.labs.i18n.ListFormatSymbols_lag_TZ = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale lb.
 */
goog.labs.i18n.ListFormatSymbols_lb = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} a(n) {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} a(n) {1}'
};


/**
 * List formatting symbols for locale lb_LU.
 */
goog.labs.i18n.ListFormatSymbols_lb_LU = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} a(n) {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} a(n) {1}'
};


/**
 * List formatting symbols for locale lg.
 */
goog.labs.i18n.ListFormatSymbols_lg = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale lg_UG.
 */
goog.labs.i18n.ListFormatSymbols_lg_UG = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale lkt.
 */
goog.labs.i18n.ListFormatSymbols_lkt = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale lkt_US.
 */
goog.labs.i18n.ListFormatSymbols_lkt_US = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ln_AO.
 */
goog.labs.i18n.ListFormatSymbols_ln_AO = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ln_CD.
 */
goog.labs.i18n.ListFormatSymbols_ln_CD = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ln_CF.
 */
goog.labs.i18n.ListFormatSymbols_ln_CF = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ln_CG.
 */
goog.labs.i18n.ListFormatSymbols_ln_CG = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale lo_LA.
 */
goog.labs.i18n.ListFormatSymbols_lo_LA = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} ແລະ {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale lrc.
 */
goog.labs.i18n.ListFormatSymbols_lrc = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale lrc_IQ.
 */
goog.labs.i18n.ListFormatSymbols_lrc_IQ = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale lrc_IR.
 */
goog.labs.i18n.ListFormatSymbols_lrc_IR = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale lt_LT.
 */
goog.labs.i18n.ListFormatSymbols_lt_LT = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} ir {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} ir {1}'
};


/**
 * List formatting symbols for locale lu.
 */
goog.labs.i18n.ListFormatSymbols_lu = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale lu_CD.
 */
goog.labs.i18n.ListFormatSymbols_lu_CD = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale luo.
 */
goog.labs.i18n.ListFormatSymbols_luo = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale luo_KE.
 */
goog.labs.i18n.ListFormatSymbols_luo_KE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale luy.
 */
goog.labs.i18n.ListFormatSymbols_luy = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale luy_KE.
 */
goog.labs.i18n.ListFormatSymbols_luy_KE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale lv_LV.
 */
goog.labs.i18n.ListFormatSymbols_lv_LV = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} un {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} un {1}'
};


/**
 * List formatting symbols for locale mas.
 */
goog.labs.i18n.ListFormatSymbols_mas = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale mas_KE.
 */
goog.labs.i18n.ListFormatSymbols_mas_KE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale mas_TZ.
 */
goog.labs.i18n.ListFormatSymbols_mas_TZ = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale mer.
 */
goog.labs.i18n.ListFormatSymbols_mer = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale mer_KE.
 */
goog.labs.i18n.ListFormatSymbols_mer_KE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale mfe.
 */
goog.labs.i18n.ListFormatSymbols_mfe = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale mfe_MU.
 */
goog.labs.i18n.ListFormatSymbols_mfe_MU = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale mg.
 */
goog.labs.i18n.ListFormatSymbols_mg = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale mg_MG.
 */
goog.labs.i18n.ListFormatSymbols_mg_MG = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale mgh.
 */
goog.labs.i18n.ListFormatSymbols_mgh = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale mgh_MZ.
 */
goog.labs.i18n.ListFormatSymbols_mgh_MZ = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale mgo.
 */
goog.labs.i18n.ListFormatSymbols_mgo = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale mgo_CM.
 */
goog.labs.i18n.ListFormatSymbols_mgo_CM = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale mk_MK.
 */
goog.labs.i18n.ListFormatSymbols_mk_MK = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} и {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} и {1}'
};


/**
 * List formatting symbols for locale ml_IN.
 */
goog.labs.i18n.ListFormatSymbols_ml_IN = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} കൂടാതെ {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1} എന്നിവ'
};


/**
 * List formatting symbols for locale mn_MN.
 */
goog.labs.i18n.ListFormatSymbols_mn_MN = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale mr_IN.
 */
goog.labs.i18n.ListFormatSymbols_mr_IN = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} आणि {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} आणि {1}'
};


/**
 * List formatting symbols for locale ms_BN.
 */
goog.labs.i18n.ListFormatSymbols_ms_BN = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} dan {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} dan {1}'
};


/**
 * List formatting symbols for locale ms_MY.
 */
goog.labs.i18n.ListFormatSymbols_ms_MY = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} dan {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} dan {1}'
};


/**
 * List formatting symbols for locale ms_SG.
 */
goog.labs.i18n.ListFormatSymbols_ms_SG = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} dan {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} dan {1}'
};


/**
 * List formatting symbols for locale mt_MT.
 */
goog.labs.i18n.ListFormatSymbols_mt_MT = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} u {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, u {1}'
};


/**
 * List formatting symbols for locale mua.
 */
goog.labs.i18n.ListFormatSymbols_mua = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale mua_CM.
 */
goog.labs.i18n.ListFormatSymbols_mua_CM = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale my_MM.
 */
goog.labs.i18n.ListFormatSymbols_my_MM = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}နှင့် {1}',
  LIST_START: '{0} {1}',
  LIST_MIDDLE: '{0} {1}',
  LIST_END: '{0}နှင့် {1}'
};


/**
 * List formatting symbols for locale mzn.
 */
goog.labs.i18n.ListFormatSymbols_mzn = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale mzn_IR.
 */
goog.labs.i18n.ListFormatSymbols_mzn_IR = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale naq.
 */
goog.labs.i18n.ListFormatSymbols_naq = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale naq_NA.
 */
goog.labs.i18n.ListFormatSymbols_naq_NA = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale nb_NO.
 */
goog.labs.i18n.ListFormatSymbols_nb_NO = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} og {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} og {1}'
};


/**
 * List formatting symbols for locale nb_SJ.
 */
goog.labs.i18n.ListFormatSymbols_nb_SJ = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} og {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} og {1}'
};


/**
 * List formatting symbols for locale nd.
 */
goog.labs.i18n.ListFormatSymbols_nd = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale nd_ZW.
 */
goog.labs.i18n.ListFormatSymbols_nd_ZW = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale nds.
 */
goog.labs.i18n.ListFormatSymbols_nds = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale nds_DE.
 */
goog.labs.i18n.ListFormatSymbols_nds_DE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale nds_NL.
 */
goog.labs.i18n.ListFormatSymbols_nds_NL = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ne_IN.
 */
goog.labs.i18n.ListFormatSymbols_ne_IN = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} र {1}',
  LIST_START: '{0},{1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} र {1}'
};


/**
 * List formatting symbols for locale ne_NP.
 */
goog.labs.i18n.ListFormatSymbols_ne_NP = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} र {1}',
  LIST_START: '{0},{1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} र {1}'
};


/**
 * List formatting symbols for locale nl_AW.
 */
goog.labs.i18n.ListFormatSymbols_nl_AW = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} en {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} en {1}'
};


/**
 * List formatting symbols for locale nl_BE.
 */
goog.labs.i18n.ListFormatSymbols_nl_BE = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} en {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} en {1}'
};


/**
 * List formatting symbols for locale nl_BQ.
 */
goog.labs.i18n.ListFormatSymbols_nl_BQ = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} en {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} en {1}'
};


/**
 * List formatting symbols for locale nl_CW.
 */
goog.labs.i18n.ListFormatSymbols_nl_CW = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} en {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} en {1}'
};


/**
 * List formatting symbols for locale nl_NL.
 */
goog.labs.i18n.ListFormatSymbols_nl_NL = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} en {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} en {1}'
};


/**
 * List formatting symbols for locale nl_SR.
 */
goog.labs.i18n.ListFormatSymbols_nl_SR = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} en {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} en {1}'
};


/**
 * List formatting symbols for locale nl_SX.
 */
goog.labs.i18n.ListFormatSymbols_nl_SX = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} en {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} en {1}'
};


/**
 * List formatting symbols for locale nmg.
 */
goog.labs.i18n.ListFormatSymbols_nmg = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale nmg_CM.
 */
goog.labs.i18n.ListFormatSymbols_nmg_CM = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale nn.
 */
goog.labs.i18n.ListFormatSymbols_nn = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} og {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} og {1}'
};


/**
 * List formatting symbols for locale nn_NO.
 */
goog.labs.i18n.ListFormatSymbols_nn_NO = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} og {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} og {1}'
};


/**
 * List formatting symbols for locale nnh.
 */
goog.labs.i18n.ListFormatSymbols_nnh = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale nnh_CM.
 */
goog.labs.i18n.ListFormatSymbols_nnh_CM = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale nus.
 */
goog.labs.i18n.ListFormatSymbols_nus = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale nus_SS.
 */
goog.labs.i18n.ListFormatSymbols_nus_SS = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale nyn.
 */
goog.labs.i18n.ListFormatSymbols_nyn = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale nyn_UG.
 */
goog.labs.i18n.ListFormatSymbols_nyn_UG = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale om.
 */
goog.labs.i18n.ListFormatSymbols_om = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale om_ET.
 */
goog.labs.i18n.ListFormatSymbols_om_ET = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale om_KE.
 */
goog.labs.i18n.ListFormatSymbols_om_KE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale or_IN.
 */
goog.labs.i18n.ListFormatSymbols_or_IN = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} ଓ {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, ଓ {1}'
};


/**
 * List formatting symbols for locale os.
 */
goog.labs.i18n.ListFormatSymbols_os = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} ӕмӕ {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} ӕмӕ {1}'
};


/**
 * List formatting symbols for locale os_GE.
 */
goog.labs.i18n.ListFormatSymbols_os_GE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} ӕмӕ {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} ӕмӕ {1}'
};


/**
 * List formatting symbols for locale os_RU.
 */
goog.labs.i18n.ListFormatSymbols_os_RU = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} ӕмӕ {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} ӕмӕ {1}'
};


/**
 * List formatting symbols for locale pa_Arab.
 */
goog.labs.i18n.ListFormatSymbols_pa_Arab = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale pa_Arab_PK.
 */
goog.labs.i18n.ListFormatSymbols_pa_Arab_PK = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale pa_Guru.
 */
goog.labs.i18n.ListFormatSymbols_pa_Guru = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} ਅਤੇ {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} ਅਤੇ {1}'
};


/**
 * List formatting symbols for locale pa_Guru_IN.
 */
goog.labs.i18n.ListFormatSymbols_pa_Guru_IN = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} ਅਤੇ {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} ਅਤੇ {1}'
};


/**
 * List formatting symbols for locale pl_PL.
 */
goog.labs.i18n.ListFormatSymbols_pl_PL = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} i {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} i {1}'
};


/**
 * List formatting symbols for locale ps.
 */
goog.labs.i18n.ListFormatSymbols_ps = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} او {1}',
  LIST_START: '{0}، {1}',
  LIST_MIDDLE: '{0}، {1}',
  LIST_END: '{0}، او {1}'
};


/**
 * List formatting symbols for locale ps_AF.
 */
goog.labs.i18n.ListFormatSymbols_ps_AF = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} او {1}',
  LIST_START: '{0}، {1}',
  LIST_MIDDLE: '{0}، {1}',
  LIST_END: '{0}، او {1}'
};


/**
 * List formatting symbols for locale pt_AO.
 */
goog.labs.i18n.ListFormatSymbols_pt_AO = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} e {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} e {1}'
};


/**
 * List formatting symbols for locale pt_CH.
 */
goog.labs.i18n.ListFormatSymbols_pt_CH = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} e {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} e {1}'
};


/**
 * List formatting symbols for locale pt_CV.
 */
goog.labs.i18n.ListFormatSymbols_pt_CV = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} e {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} e {1}'
};


/**
 * List formatting symbols for locale pt_GQ.
 */
goog.labs.i18n.ListFormatSymbols_pt_GQ = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} e {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} e {1}'
};


/**
 * List formatting symbols for locale pt_GW.
 */
goog.labs.i18n.ListFormatSymbols_pt_GW = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} e {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} e {1}'
};


/**
 * List formatting symbols for locale pt_LU.
 */
goog.labs.i18n.ListFormatSymbols_pt_LU = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} e {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} e {1}'
};


/**
 * List formatting symbols for locale pt_MO.
 */
goog.labs.i18n.ListFormatSymbols_pt_MO = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} e {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} e {1}'
};


/**
 * List formatting symbols for locale pt_MZ.
 */
goog.labs.i18n.ListFormatSymbols_pt_MZ = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} e {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} e {1}'
};


/**
 * List formatting symbols for locale pt_ST.
 */
goog.labs.i18n.ListFormatSymbols_pt_ST = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} e {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} e {1}'
};


/**
 * List formatting symbols for locale pt_TL.
 */
goog.labs.i18n.ListFormatSymbols_pt_TL = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} e {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} e {1}'
};


/**
 * List formatting symbols for locale qu.
 */
goog.labs.i18n.ListFormatSymbols_qu = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale qu_BO.
 */
goog.labs.i18n.ListFormatSymbols_qu_BO = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale qu_EC.
 */
goog.labs.i18n.ListFormatSymbols_qu_EC = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale qu_PE.
 */
goog.labs.i18n.ListFormatSymbols_qu_PE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale rm.
 */
goog.labs.i18n.ListFormatSymbols_rm = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale rm_CH.
 */
goog.labs.i18n.ListFormatSymbols_rm_CH = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale rn.
 */
goog.labs.i18n.ListFormatSymbols_rn = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale rn_BI.
 */
goog.labs.i18n.ListFormatSymbols_rn_BI = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ro_MD.
 */
goog.labs.i18n.ListFormatSymbols_ro_MD = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} și {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} și {1}'
};


/**
 * List formatting symbols for locale ro_RO.
 */
goog.labs.i18n.ListFormatSymbols_ro_RO = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} și {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} și {1}'
};


/**
 * List formatting symbols for locale rof.
 */
goog.labs.i18n.ListFormatSymbols_rof = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale rof_TZ.
 */
goog.labs.i18n.ListFormatSymbols_rof_TZ = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ru_BY.
 */
goog.labs.i18n.ListFormatSymbols_ru_BY = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} и {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} и {1}'
};


/**
 * List formatting symbols for locale ru_KG.
 */
goog.labs.i18n.ListFormatSymbols_ru_KG = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} и {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} и {1}'
};


/**
 * List formatting symbols for locale ru_KZ.
 */
goog.labs.i18n.ListFormatSymbols_ru_KZ = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} и {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} и {1}'
};


/**
 * List formatting symbols for locale ru_MD.
 */
goog.labs.i18n.ListFormatSymbols_ru_MD = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} и {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} и {1}'
};


/**
 * List formatting symbols for locale ru_RU.
 */
goog.labs.i18n.ListFormatSymbols_ru_RU = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} и {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} и {1}'
};


/**
 * List formatting symbols for locale ru_UA.
 */
goog.labs.i18n.ListFormatSymbols_ru_UA = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} и {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} и {1}'
};


/**
 * List formatting symbols for locale rw.
 */
goog.labs.i18n.ListFormatSymbols_rw = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale rw_RW.
 */
goog.labs.i18n.ListFormatSymbols_rw_RW = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale rwk.
 */
goog.labs.i18n.ListFormatSymbols_rwk = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale rwk_TZ.
 */
goog.labs.i18n.ListFormatSymbols_rwk_TZ = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale sah.
 */
goog.labs.i18n.ListFormatSymbols_sah = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} уонна {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} уонна {1}'
};


/**
 * List formatting symbols for locale sah_RU.
 */
goog.labs.i18n.ListFormatSymbols_sah_RU = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} уонна {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} уонна {1}'
};


/**
 * List formatting symbols for locale saq.
 */
goog.labs.i18n.ListFormatSymbols_saq = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale saq_KE.
 */
goog.labs.i18n.ListFormatSymbols_saq_KE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale sbp.
 */
goog.labs.i18n.ListFormatSymbols_sbp = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale sbp_TZ.
 */
goog.labs.i18n.ListFormatSymbols_sbp_TZ = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale se.
 */
goog.labs.i18n.ListFormatSymbols_se = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} ja {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} ja {1}'
};


/**
 * List formatting symbols for locale se_FI.
 */
goog.labs.i18n.ListFormatSymbols_se_FI = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} ja {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} ja {1}'
};


/**
 * List formatting symbols for locale se_NO.
 */
goog.labs.i18n.ListFormatSymbols_se_NO = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} ja {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} ja {1}'
};


/**
 * List formatting symbols for locale se_SE.
 */
goog.labs.i18n.ListFormatSymbols_se_SE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} ja {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} ja {1}'
};


/**
 * List formatting symbols for locale seh.
 */
goog.labs.i18n.ListFormatSymbols_seh = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale seh_MZ.
 */
goog.labs.i18n.ListFormatSymbols_seh_MZ = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ses.
 */
goog.labs.i18n.ListFormatSymbols_ses = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ses_ML.
 */
goog.labs.i18n.ListFormatSymbols_ses_ML = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale sg.
 */
goog.labs.i18n.ListFormatSymbols_sg = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale sg_CF.
 */
goog.labs.i18n.ListFormatSymbols_sg_CF = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale shi.
 */
goog.labs.i18n.ListFormatSymbols_shi = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale shi_Latn.
 */
goog.labs.i18n.ListFormatSymbols_shi_Latn = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale shi_Latn_MA.
 */
goog.labs.i18n.ListFormatSymbols_shi_Latn_MA = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale shi_Tfng.
 */
goog.labs.i18n.ListFormatSymbols_shi_Tfng = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale shi_Tfng_MA.
 */
goog.labs.i18n.ListFormatSymbols_shi_Tfng_MA = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale si_LK.
 */
goog.labs.i18n.ListFormatSymbols_si_LK = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} සහ {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, සහ {1}'
};


/**
 * List formatting symbols for locale sk_SK.
 */
goog.labs.i18n.ListFormatSymbols_sk_SK = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} a {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} a {1}'
};


/**
 * List formatting symbols for locale sl_SI.
 */
goog.labs.i18n.ListFormatSymbols_sl_SI = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} in {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} in {1}'
};


/**
 * List formatting symbols for locale smn.
 */
goog.labs.i18n.ListFormatSymbols_smn = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale smn_FI.
 */
goog.labs.i18n.ListFormatSymbols_smn_FI = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale sn.
 */
goog.labs.i18n.ListFormatSymbols_sn = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale sn_ZW.
 */
goog.labs.i18n.ListFormatSymbols_sn_ZW = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale so.
 */
goog.labs.i18n.ListFormatSymbols_so = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale so_DJ.
 */
goog.labs.i18n.ListFormatSymbols_so_DJ = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale so_ET.
 */
goog.labs.i18n.ListFormatSymbols_so_ET = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale so_KE.
 */
goog.labs.i18n.ListFormatSymbols_so_KE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale so_SO.
 */
goog.labs.i18n.ListFormatSymbols_so_SO = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale sq_AL.
 */
goog.labs.i18n.ListFormatSymbols_sq_AL = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} dhe {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} dhe {1}'
};


/**
 * List formatting symbols for locale sq_MK.
 */
goog.labs.i18n.ListFormatSymbols_sq_MK = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} dhe {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} dhe {1}'
};


/**
 * List formatting symbols for locale sq_XK.
 */
goog.labs.i18n.ListFormatSymbols_sq_XK = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} dhe {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} dhe {1}'
};


/**
 * List formatting symbols for locale sr_Cyrl.
 */
goog.labs.i18n.ListFormatSymbols_sr_Cyrl = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} и {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} и {1}'
};


/**
 * List formatting symbols for locale sr_Cyrl_BA.
 */
goog.labs.i18n.ListFormatSymbols_sr_Cyrl_BA = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} и {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} и {1}'
};


/**
 * List formatting symbols for locale sr_Cyrl_ME.
 */
goog.labs.i18n.ListFormatSymbols_sr_Cyrl_ME = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} и {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} и {1}'
};


/**
 * List formatting symbols for locale sr_Cyrl_RS.
 */
goog.labs.i18n.ListFormatSymbols_sr_Cyrl_RS = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} и {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} и {1}'
};


/**
 * List formatting symbols for locale sr_Cyrl_XK.
 */
goog.labs.i18n.ListFormatSymbols_sr_Cyrl_XK = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} и {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} и {1}'
};


/**
 * List formatting symbols for locale sr_Latn_BA.
 */
goog.labs.i18n.ListFormatSymbols_sr_Latn_BA = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} i {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} i {1}'
};


/**
 * List formatting symbols for locale sr_Latn_ME.
 */
goog.labs.i18n.ListFormatSymbols_sr_Latn_ME = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} i {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} i {1}'
};


/**
 * List formatting symbols for locale sr_Latn_RS.
 */
goog.labs.i18n.ListFormatSymbols_sr_Latn_RS = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} i {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} i {1}'
};


/**
 * List formatting symbols for locale sr_Latn_XK.
 */
goog.labs.i18n.ListFormatSymbols_sr_Latn_XK = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} i {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} i {1}'
};


/**
 * List formatting symbols for locale sv_AX.
 */
goog.labs.i18n.ListFormatSymbols_sv_AX = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} och {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} och {1}'
};


/**
 * List formatting symbols for locale sv_FI.
 */
goog.labs.i18n.ListFormatSymbols_sv_FI = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} och {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} och {1}'
};


/**
 * List formatting symbols for locale sv_SE.
 */
goog.labs.i18n.ListFormatSymbols_sv_SE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} och {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} och {1}'
};


/**
 * List formatting symbols for locale sw_CD.
 */
goog.labs.i18n.ListFormatSymbols_sw_CD = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} na {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} na {1}'
};


/**
 * List formatting symbols for locale sw_KE.
 */
goog.labs.i18n.ListFormatSymbols_sw_KE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} na {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} na {1}'
};


/**
 * List formatting symbols for locale sw_TZ.
 */
goog.labs.i18n.ListFormatSymbols_sw_TZ = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} na {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} na {1}'
};


/**
 * List formatting symbols for locale sw_UG.
 */
goog.labs.i18n.ListFormatSymbols_sw_UG = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} na {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} na {1}'
};


/**
 * List formatting symbols for locale ta_IN.
 */
goog.labs.i18n.ListFormatSymbols_ta_IN = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} மற்றும் {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} மற்றும் {1}'
};


/**
 * List formatting symbols for locale ta_LK.
 */
goog.labs.i18n.ListFormatSymbols_ta_LK = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} மற்றும் {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} மற்றும் {1}'
};


/**
 * List formatting symbols for locale ta_MY.
 */
goog.labs.i18n.ListFormatSymbols_ta_MY = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} மற்றும் {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} மற்றும் {1}'
};


/**
 * List formatting symbols for locale ta_SG.
 */
goog.labs.i18n.ListFormatSymbols_ta_SG = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} மற்றும் {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} மற்றும் {1}'
};


/**
 * List formatting symbols for locale te_IN.
 */
goog.labs.i18n.ListFormatSymbols_te_IN = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} మరియు {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} మరియు {1}'
};


/**
 * List formatting symbols for locale teo.
 */
goog.labs.i18n.ListFormatSymbols_teo = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale teo_KE.
 */
goog.labs.i18n.ListFormatSymbols_teo_KE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale teo_UG.
 */
goog.labs.i18n.ListFormatSymbols_teo_UG = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale tg.
 */
goog.labs.i18n.ListFormatSymbols_tg = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale tg_TJ.
 */
goog.labs.i18n.ListFormatSymbols_tg_TJ = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale th_TH.
 */
goog.labs.i18n.ListFormatSymbols_th_TH = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}และ{1}',
  LIST_START: '{0} {1}',
  LIST_MIDDLE: '{0} {1}',
  LIST_END: '{0} และ{1}'
};


/**
 * List formatting symbols for locale ti.
 */
goog.labs.i18n.ListFormatSymbols_ti = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ti_ER.
 */
goog.labs.i18n.ListFormatSymbols_ti_ER = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ti_ET.
 */
goog.labs.i18n.ListFormatSymbols_ti_ET = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale to.
 */
goog.labs.i18n.ListFormatSymbols_to = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} mo {1}',
  LIST_START: '{0} mo {1}',
  LIST_MIDDLE: '{0} mo {1}',
  LIST_END: '{0} mo {1}'
};


/**
 * List formatting symbols for locale to_TO.
 */
goog.labs.i18n.ListFormatSymbols_to_TO = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} mo {1}',
  LIST_START: '{0} mo {1}',
  LIST_MIDDLE: '{0} mo {1}',
  LIST_END: '{0} mo {1}'
};


/**
 * List formatting symbols for locale tr_CY.
 */
goog.labs.i18n.ListFormatSymbols_tr_CY = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} ve {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} ve {1}'
};


/**
 * List formatting symbols for locale tr_TR.
 */
goog.labs.i18n.ListFormatSymbols_tr_TR = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} ve {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} ve {1}'
};


/**
 * List formatting symbols for locale tt.
 */
goog.labs.i18n.ListFormatSymbols_tt = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} һәм {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} һәм {1}'
};


/**
 * List formatting symbols for locale tt_RU.
 */
goog.labs.i18n.ListFormatSymbols_tt_RU = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} һәм {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} һәм {1}'
};


/**
 * List formatting symbols for locale twq.
 */
goog.labs.i18n.ListFormatSymbols_twq = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale twq_NE.
 */
goog.labs.i18n.ListFormatSymbols_twq_NE = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale tzm.
 */
goog.labs.i18n.ListFormatSymbols_tzm = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale tzm_MA.
 */
goog.labs.i18n.ListFormatSymbols_tzm_MA = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale ug.
 */
goog.labs.i18n.ListFormatSymbols_ug = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale ug_CN.
 */
goog.labs.i18n.ListFormatSymbols_ug_CN = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} and {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, and {1}'
};


/**
 * List formatting symbols for locale uk_UA.
 */
goog.labs.i18n.ListFormatSymbols_uk_UA = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} і {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} і {1}'
};


/**
 * List formatting symbols for locale ur_IN.
 */
goog.labs.i18n.ListFormatSymbols_ur_IN = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} اور {1}',
  LIST_START: '{0}، {1}',
  LIST_MIDDLE: '{0}، {1}',
  LIST_END: '{0}، اور {1}'
};


/**
 * List formatting symbols for locale ur_PK.
 */
goog.labs.i18n.ListFormatSymbols_ur_PK = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0} اور {1}',
  LIST_START: '{0}، {1}',
  LIST_MIDDLE: '{0}، {1}',
  LIST_END: '{0}، اور {1}'
};


/**
 * List formatting symbols for locale uz_Arab.
 */
goog.labs.i18n.ListFormatSymbols_uz_Arab = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale uz_Arab_AF.
 */
goog.labs.i18n.ListFormatSymbols_uz_Arab_AF = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale uz_Cyrl.
 */
goog.labs.i18n.ListFormatSymbols_uz_Cyrl = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale uz_Cyrl_UZ.
 */
goog.labs.i18n.ListFormatSymbols_uz_Cyrl_UZ = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale uz_Latn.
 */
goog.labs.i18n.ListFormatSymbols_uz_Latn = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} va {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} va {1}'
};


/**
 * List formatting symbols for locale uz_Latn_UZ.
 */
goog.labs.i18n.ListFormatSymbols_uz_Latn_UZ = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} va {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} va {1}'
};


/**
 * List formatting symbols for locale vai.
 */
goog.labs.i18n.ListFormatSymbols_vai = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale vai_Latn.
 */
goog.labs.i18n.ListFormatSymbols_vai_Latn = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale vai_Latn_LR.
 */
goog.labs.i18n.ListFormatSymbols_vai_Latn_LR = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale vai_Vaii.
 */
goog.labs.i18n.ListFormatSymbols_vai_Vaii = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale vai_Vaii_LR.
 */
goog.labs.i18n.ListFormatSymbols_vai_Vaii_LR = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale vi_VN.
 */
goog.labs.i18n.ListFormatSymbols_vi_VN = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} và {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} và {1}'
};


/**
 * List formatting symbols for locale vun.
 */
goog.labs.i18n.ListFormatSymbols_vun = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale vun_TZ.
 */
goog.labs.i18n.ListFormatSymbols_vun_TZ = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale wae.
 */
goog.labs.i18n.ListFormatSymbols_wae = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} und {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} und {1}'
};


/**
 * List formatting symbols for locale wae_CH.
 */
goog.labs.i18n.ListFormatSymbols_wae_CH = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} und {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} und {1}'
};


/**
 * List formatting symbols for locale wo.
 */
goog.labs.i18n.ListFormatSymbols_wo = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale wo_SN.
 */
goog.labs.i18n.ListFormatSymbols_wo_SN = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale xog.
 */
goog.labs.i18n.ListFormatSymbols_xog = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale xog_UG.
 */
goog.labs.i18n.ListFormatSymbols_xog_UG = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale yav.
 */
goog.labs.i18n.ListFormatSymbols_yav = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale yav_CM.
 */
goog.labs.i18n.ListFormatSymbols_yav_CM = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale yi.
 */
goog.labs.i18n.ListFormatSymbols_yi = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} און {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} און {1}'
};


/**
 * List formatting symbols for locale yi_001.
 */
goog.labs.i18n.ListFormatSymbols_yi_001 = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} און {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0} און {1}'
};


/**
 * List formatting symbols for locale yo.
 */
goog.labs.i18n.ListFormatSymbols_yo = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale yo_BJ.
 */
goog.labs.i18n.ListFormatSymbols_yo_BJ = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale yo_NG.
 */
goog.labs.i18n.ListFormatSymbols_yo_NG = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale yue.
 */
goog.labs.i18n.ListFormatSymbols_yue = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}同{1}',
  LIST_START: '{0}、{1}',
  LIST_MIDDLE: '{0}、{1}',
  LIST_END: '{0}同{1}'
};


/**
 * List formatting symbols for locale yue_Hans.
 */
goog.labs.i18n.ListFormatSymbols_yue_Hans = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}同{1}',
  LIST_START: '{0}、{1}',
  LIST_MIDDLE: '{0}、{1}',
  LIST_END: '{0}同{1}'
};


/**
 * List formatting symbols for locale yue_Hans_CN.
 */
goog.labs.i18n.ListFormatSymbols_yue_Hans_CN = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}同{1}',
  LIST_START: '{0}、{1}',
  LIST_MIDDLE: '{0}、{1}',
  LIST_END: '{0}同{1}'
};


/**
 * List formatting symbols for locale yue_Hant.
 */
goog.labs.i18n.ListFormatSymbols_yue_Hant = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}同{1}',
  LIST_START: '{0}、{1}',
  LIST_MIDDLE: '{0}、{1}',
  LIST_END: '{0}同{1}'
};


/**
 * List formatting symbols for locale yue_Hant_HK.
 */
goog.labs.i18n.ListFormatSymbols_yue_Hant_HK = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}同{1}',
  LIST_START: '{0}、{1}',
  LIST_MIDDLE: '{0}、{1}',
  LIST_END: '{0}同{1}'
};


/**
 * List formatting symbols for locale zgh.
 */
goog.labs.i18n.ListFormatSymbols_zgh = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale zgh_MA.
 */
goog.labs.i18n.ListFormatSymbols_zgh_MA = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0}, {1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, {1}'
};


/**
 * List formatting symbols for locale zh_Hans.
 */
goog.labs.i18n.ListFormatSymbols_zh_Hans = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0}和{1}',
  LIST_START: '{0}、{1}',
  LIST_MIDDLE: '{0}、{1}',
  LIST_END: '{0}和{1}'
};


/**
 * List formatting symbols for locale zh_Hans_CN.
 */
goog.labs.i18n.ListFormatSymbols_zh_Hans_CN = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0}和{1}',
  LIST_START: '{0}、{1}',
  LIST_MIDDLE: '{0}、{1}',
  LIST_END: '{0}和{1}'
};


/**
 * List formatting symbols for locale zh_Hans_HK.
 */
goog.labs.i18n.ListFormatSymbols_zh_Hans_HK = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0}和{1}',
  LIST_START: '{0}、{1}',
  LIST_MIDDLE: '{0}、{1}',
  LIST_END: '{0}和{1}'
};


/**
 * List formatting symbols for locale zh_Hans_MO.
 */
goog.labs.i18n.ListFormatSymbols_zh_Hans_MO = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0}和{1}',
  LIST_START: '{0}、{1}',
  LIST_MIDDLE: '{0}、{1}',
  LIST_END: '{0}和{1}'
};


/**
 * List formatting symbols for locale zh_Hans_SG.
 */
goog.labs.i18n.ListFormatSymbols_zh_Hans_SG = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0}和{1}',
  LIST_START: '{0}、{1}',
  LIST_MIDDLE: '{0}、{1}',
  LIST_END: '{0}和{1}'
};


/**
 * List formatting symbols for locale zh_Hant.
 */
goog.labs.i18n.ListFormatSymbols_zh_Hant = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0}和{1}',
  LIST_START: '{0}、{1}',
  LIST_MIDDLE: '{0}、{1}',
  LIST_END: '{0}和{1}'
};


/**
 * List formatting symbols for locale zh_Hant_HK.
 */
goog.labs.i18n.ListFormatSymbols_zh_Hant_HK = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0}及{1}',
  LIST_START: '{0}、{1}',
  LIST_MIDDLE: '{0}、{1}',
  LIST_END: '{0}及{1}'
};


/**
 * List formatting symbols for locale zh_Hant_MO.
 */
goog.labs.i18n.ListFormatSymbols_zh_Hant_MO = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0}及{1}',
  LIST_START: '{0}、{1}',
  LIST_MIDDLE: '{0}、{1}',
  LIST_END: '{0}及{1}'
};


/**
 * List formatting symbols for locale zh_Hant_TW.
 */
goog.labs.i18n.ListFormatSymbols_zh_Hant_TW = {
  GENDER_STYLE: 2,
  LIST_TWO: '{0}和{1}',
  LIST_START: '{0}、{1}',
  LIST_MIDDLE: '{0}、{1}',
  LIST_END: '{0}和{1}'
};


/**
 * List formatting symbols for locale zu_ZA.
 */
goog.labs.i18n.ListFormatSymbols_zu_ZA = {
  GENDER_STYLE: 0,
  LIST_TWO: '{0} ne-{1}',
  LIST_START: '{0}, {1}',
  LIST_MIDDLE: '{0}, {1}',
  LIST_END: '{0}, ne-{1}'
};


/**
 * Selecting symbols by locale.
 */
if (goog.LOCALE == 'af_NA' || goog.LOCALE == 'af-NA') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_af_NA;
}

if (goog.LOCALE == 'af_ZA' || goog.LOCALE == 'af-ZA') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_af_ZA;
}

if (goog.LOCALE == 'agq') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_agq;
}

if (goog.LOCALE == 'agq_CM' || goog.LOCALE == 'agq-CM') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_agq_CM;
}

if (goog.LOCALE == 'ak') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ak;
}

if (goog.LOCALE == 'ak_GH' || goog.LOCALE == 'ak-GH') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ak_GH;
}

if (goog.LOCALE == 'am_ET' || goog.LOCALE == 'am-ET') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_am_ET;
}

if (goog.LOCALE == 'ar_001' || goog.LOCALE == 'ar-001') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ar_001;
}

if (goog.LOCALE == 'ar_AE' || goog.LOCALE == 'ar-AE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ar_AE;
}

if (goog.LOCALE == 'ar_BH' || goog.LOCALE == 'ar-BH') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ar_BH;
}

if (goog.LOCALE == 'ar_DJ' || goog.LOCALE == 'ar-DJ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ar_DJ;
}

if (goog.LOCALE == 'ar_EG' || goog.LOCALE == 'ar-EG') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ar_EG;
}

if (goog.LOCALE == 'ar_EH' || goog.LOCALE == 'ar-EH') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ar_EH;
}

if (goog.LOCALE == 'ar_ER' || goog.LOCALE == 'ar-ER') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ar_ER;
}

if (goog.LOCALE == 'ar_IL' || goog.LOCALE == 'ar-IL') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ar_IL;
}

if (goog.LOCALE == 'ar_IQ' || goog.LOCALE == 'ar-IQ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ar_IQ;
}

if (goog.LOCALE == 'ar_JO' || goog.LOCALE == 'ar-JO') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ar_JO;
}

if (goog.LOCALE == 'ar_KM' || goog.LOCALE == 'ar-KM') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ar_KM;
}

if (goog.LOCALE == 'ar_KW' || goog.LOCALE == 'ar-KW') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ar_KW;
}

if (goog.LOCALE == 'ar_LB' || goog.LOCALE == 'ar-LB') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ar_LB;
}

if (goog.LOCALE == 'ar_LY' || goog.LOCALE == 'ar-LY') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ar_LY;
}

if (goog.LOCALE == 'ar_MA' || goog.LOCALE == 'ar-MA') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ar_MA;
}

if (goog.LOCALE == 'ar_MR' || goog.LOCALE == 'ar-MR') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ar_MR;
}

if (goog.LOCALE == 'ar_OM' || goog.LOCALE == 'ar-OM') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ar_OM;
}

if (goog.LOCALE == 'ar_PS' || goog.LOCALE == 'ar-PS') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ar_PS;
}

if (goog.LOCALE == 'ar_QA' || goog.LOCALE == 'ar-QA') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ar_QA;
}

if (goog.LOCALE == 'ar_SA' || goog.LOCALE == 'ar-SA') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ar_SA;
}

if (goog.LOCALE == 'ar_SD' || goog.LOCALE == 'ar-SD') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ar_SD;
}

if (goog.LOCALE == 'ar_SO' || goog.LOCALE == 'ar-SO') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ar_SO;
}

if (goog.LOCALE == 'ar_SS' || goog.LOCALE == 'ar-SS') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ar_SS;
}

if (goog.LOCALE == 'ar_SY' || goog.LOCALE == 'ar-SY') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ar_SY;
}

if (goog.LOCALE == 'ar_TD' || goog.LOCALE == 'ar-TD') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ar_TD;
}

if (goog.LOCALE == 'ar_TN' || goog.LOCALE == 'ar-TN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ar_TN;
}

if (goog.LOCALE == 'ar_XB' || goog.LOCALE == 'ar-XB') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ar_XB;
}

if (goog.LOCALE == 'ar_YE' || goog.LOCALE == 'ar-YE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ar_YE;
}

if (goog.LOCALE == 'as') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_as;
}

if (goog.LOCALE == 'as_IN' || goog.LOCALE == 'as-IN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_as_IN;
}

if (goog.LOCALE == 'asa') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_asa;
}

if (goog.LOCALE == 'asa_TZ' || goog.LOCALE == 'asa-TZ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_asa_TZ;
}

if (goog.LOCALE == 'ast') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ast;
}

if (goog.LOCALE == 'ast_ES' || goog.LOCALE == 'ast-ES') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ast_ES;
}

if (goog.LOCALE == 'az_Cyrl' || goog.LOCALE == 'az-Cyrl') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_az_Cyrl;
}

if (goog.LOCALE == 'az_Cyrl_AZ' || goog.LOCALE == 'az-Cyrl-AZ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_az_Cyrl_AZ;
}

if (goog.LOCALE == 'az_Latn' || goog.LOCALE == 'az-Latn') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_az_Latn;
}

if (goog.LOCALE == 'az_Latn_AZ' || goog.LOCALE == 'az-Latn-AZ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_az_Latn_AZ;
}

if (goog.LOCALE == 'bas') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_bas;
}

if (goog.LOCALE == 'bas_CM' || goog.LOCALE == 'bas-CM') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_bas_CM;
}

if (goog.LOCALE == 'be_BY' || goog.LOCALE == 'be-BY') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_be_BY;
}

if (goog.LOCALE == 'bem') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_bem;
}

if (goog.LOCALE == 'bem_ZM' || goog.LOCALE == 'bem-ZM') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_bem_ZM;
}

if (goog.LOCALE == 'bez') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_bez;
}

if (goog.LOCALE == 'bez_TZ' || goog.LOCALE == 'bez-TZ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_bez_TZ;
}

if (goog.LOCALE == 'bg_BG' || goog.LOCALE == 'bg-BG') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_bg_BG;
}

if (goog.LOCALE == 'bm') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_bm;
}

if (goog.LOCALE == 'bm_ML' || goog.LOCALE == 'bm-ML') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_bm_ML;
}

if (goog.LOCALE == 'bn_BD' || goog.LOCALE == 'bn-BD') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_bn_BD;
}

if (goog.LOCALE == 'bn_IN' || goog.LOCALE == 'bn-IN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_bn_IN;
}

if (goog.LOCALE == 'bo') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_bo;
}

if (goog.LOCALE == 'bo_CN' || goog.LOCALE == 'bo-CN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_bo_CN;
}

if (goog.LOCALE == 'bo_IN' || goog.LOCALE == 'bo-IN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_bo_IN;
}

if (goog.LOCALE == 'br_FR' || goog.LOCALE == 'br-FR') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_br_FR;
}

if (goog.LOCALE == 'brx') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_brx;
}

if (goog.LOCALE == 'brx_IN' || goog.LOCALE == 'brx-IN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_brx_IN;
}

if (goog.LOCALE == 'bs_Cyrl' || goog.LOCALE == 'bs-Cyrl') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_bs_Cyrl;
}

if (goog.LOCALE == 'bs_Cyrl_BA' || goog.LOCALE == 'bs-Cyrl-BA') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_bs_Cyrl_BA;
}

if (goog.LOCALE == 'bs_Latn' || goog.LOCALE == 'bs-Latn') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_bs_Latn;
}

if (goog.LOCALE == 'bs_Latn_BA' || goog.LOCALE == 'bs-Latn-BA') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_bs_Latn_BA;
}

if (goog.LOCALE == 'ca_AD' || goog.LOCALE == 'ca-AD') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ca_AD;
}

if (goog.LOCALE == 'ca_ES' || goog.LOCALE == 'ca-ES') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ca_ES;
}

if (goog.LOCALE == 'ca_FR' || goog.LOCALE == 'ca-FR') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ca_FR;
}

if (goog.LOCALE == 'ca_IT' || goog.LOCALE == 'ca-IT') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ca_IT;
}

if (goog.LOCALE == 'ccp') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ccp;
}

if (goog.LOCALE == 'ccp_BD' || goog.LOCALE == 'ccp-BD') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ccp_BD;
}

if (goog.LOCALE == 'ccp_IN' || goog.LOCALE == 'ccp-IN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ccp_IN;
}

if (goog.LOCALE == 'ce') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ce;
}

if (goog.LOCALE == 'ce_RU' || goog.LOCALE == 'ce-RU') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ce_RU;
}

if (goog.LOCALE == 'cgg') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_cgg;
}

if (goog.LOCALE == 'cgg_UG' || goog.LOCALE == 'cgg-UG') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_cgg_UG;
}

if (goog.LOCALE == 'chr_US' || goog.LOCALE == 'chr-US') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_chr_US;
}

if (goog.LOCALE == 'ckb') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ckb;
}

if (goog.LOCALE == 'ckb_IQ' || goog.LOCALE == 'ckb-IQ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ckb_IQ;
}

if (goog.LOCALE == 'ckb_IR' || goog.LOCALE == 'ckb-IR') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ckb_IR;
}

if (goog.LOCALE == 'cs_CZ' || goog.LOCALE == 'cs-CZ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_cs_CZ;
}

if (goog.LOCALE == 'cy_GB' || goog.LOCALE == 'cy-GB') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_cy_GB;
}

if (goog.LOCALE == 'da_DK' || goog.LOCALE == 'da-DK') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_da_DK;
}

if (goog.LOCALE == 'da_GL' || goog.LOCALE == 'da-GL') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_da_GL;
}

if (goog.LOCALE == 'dav') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_dav;
}

if (goog.LOCALE == 'dav_KE' || goog.LOCALE == 'dav-KE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_dav_KE;
}

if (goog.LOCALE == 'de_BE' || goog.LOCALE == 'de-BE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_de_BE;
}

if (goog.LOCALE == 'de_DE' || goog.LOCALE == 'de-DE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_de_DE;
}

if (goog.LOCALE == 'de_IT' || goog.LOCALE == 'de-IT') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_de_IT;
}

if (goog.LOCALE == 'de_LI' || goog.LOCALE == 'de-LI') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_de_LI;
}

if (goog.LOCALE == 'de_LU' || goog.LOCALE == 'de-LU') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_de_LU;
}

if (goog.LOCALE == 'dje') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_dje;
}

if (goog.LOCALE == 'dje_NE' || goog.LOCALE == 'dje-NE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_dje_NE;
}

if (goog.LOCALE == 'dsb') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_dsb;
}

if (goog.LOCALE == 'dsb_DE' || goog.LOCALE == 'dsb-DE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_dsb_DE;
}

if (goog.LOCALE == 'dua') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_dua;
}

if (goog.LOCALE == 'dua_CM' || goog.LOCALE == 'dua-CM') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_dua_CM;
}

if (goog.LOCALE == 'dyo') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_dyo;
}

if (goog.LOCALE == 'dyo_SN' || goog.LOCALE == 'dyo-SN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_dyo_SN;
}

if (goog.LOCALE == 'dz') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_dz;
}

if (goog.LOCALE == 'dz_BT' || goog.LOCALE == 'dz-BT') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_dz_BT;
}

if (goog.LOCALE == 'ebu') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ebu;
}

if (goog.LOCALE == 'ebu_KE' || goog.LOCALE == 'ebu-KE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ebu_KE;
}

if (goog.LOCALE == 'ee') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ee;
}

if (goog.LOCALE == 'ee_GH' || goog.LOCALE == 'ee-GH') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ee_GH;
}

if (goog.LOCALE == 'ee_TG' || goog.LOCALE == 'ee-TG') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ee_TG;
}

if (goog.LOCALE == 'el_CY' || goog.LOCALE == 'el-CY') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_el_CY;
}

if (goog.LOCALE == 'el_GR' || goog.LOCALE == 'el-GR') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_el_GR;
}

if (goog.LOCALE == 'en_001' || goog.LOCALE == 'en-001') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_001;
}

if (goog.LOCALE == 'en_150' || goog.LOCALE == 'en-150') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_150;
}

if (goog.LOCALE == 'en_AG' || goog.LOCALE == 'en-AG') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_AG;
}

if (goog.LOCALE == 'en_AI' || goog.LOCALE == 'en-AI') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_AI;
}

if (goog.LOCALE == 'en_AS' || goog.LOCALE == 'en-AS') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_AS;
}

if (goog.LOCALE == 'en_AT' || goog.LOCALE == 'en-AT') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_AT;
}

if (goog.LOCALE == 'en_BB' || goog.LOCALE == 'en-BB') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_BB;
}

if (goog.LOCALE == 'en_BE' || goog.LOCALE == 'en-BE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_BE;
}

if (goog.LOCALE == 'en_BI' || goog.LOCALE == 'en-BI') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_BI;
}

if (goog.LOCALE == 'en_BM' || goog.LOCALE == 'en-BM') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_BM;
}

if (goog.LOCALE == 'en_BS' || goog.LOCALE == 'en-BS') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_BS;
}

if (goog.LOCALE == 'en_BW' || goog.LOCALE == 'en-BW') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_BW;
}

if (goog.LOCALE == 'en_BZ' || goog.LOCALE == 'en-BZ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_BZ;
}

if (goog.LOCALE == 'en_CC' || goog.LOCALE == 'en-CC') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_CC;
}

if (goog.LOCALE == 'en_CH' || goog.LOCALE == 'en-CH') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_CH;
}

if (goog.LOCALE == 'en_CK' || goog.LOCALE == 'en-CK') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_CK;
}

if (goog.LOCALE == 'en_CM' || goog.LOCALE == 'en-CM') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_CM;
}

if (goog.LOCALE == 'en_CX' || goog.LOCALE == 'en-CX') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_CX;
}

if (goog.LOCALE == 'en_CY' || goog.LOCALE == 'en-CY') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_CY;
}

if (goog.LOCALE == 'en_DE' || goog.LOCALE == 'en-DE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_DE;
}

if (goog.LOCALE == 'en_DG' || goog.LOCALE == 'en-DG') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_DG;
}

if (goog.LOCALE == 'en_DK' || goog.LOCALE == 'en-DK') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_DK;
}

if (goog.LOCALE == 'en_DM' || goog.LOCALE == 'en-DM') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_DM;
}

if (goog.LOCALE == 'en_ER' || goog.LOCALE == 'en-ER') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_ER;
}

if (goog.LOCALE == 'en_FI' || goog.LOCALE == 'en-FI') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_FI;
}

if (goog.LOCALE == 'en_FJ' || goog.LOCALE == 'en-FJ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_FJ;
}

if (goog.LOCALE == 'en_FK' || goog.LOCALE == 'en-FK') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_FK;
}

if (goog.LOCALE == 'en_FM' || goog.LOCALE == 'en-FM') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_FM;
}

if (goog.LOCALE == 'en_GD' || goog.LOCALE == 'en-GD') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_GD;
}

if (goog.LOCALE == 'en_GG' || goog.LOCALE == 'en-GG') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_GG;
}

if (goog.LOCALE == 'en_GH' || goog.LOCALE == 'en-GH') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_GH;
}

if (goog.LOCALE == 'en_GI' || goog.LOCALE == 'en-GI') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_GI;
}

if (goog.LOCALE == 'en_GM' || goog.LOCALE == 'en-GM') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_GM;
}

if (goog.LOCALE == 'en_GU' || goog.LOCALE == 'en-GU') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_GU;
}

if (goog.LOCALE == 'en_GY' || goog.LOCALE == 'en-GY') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_GY;
}

if (goog.LOCALE == 'en_HK' || goog.LOCALE == 'en-HK') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_HK;
}

if (goog.LOCALE == 'en_IL' || goog.LOCALE == 'en-IL') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_IL;
}

if (goog.LOCALE == 'en_IM' || goog.LOCALE == 'en-IM') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_IM;
}

if (goog.LOCALE == 'en_IO' || goog.LOCALE == 'en-IO') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_IO;
}

if (goog.LOCALE == 'en_JE' || goog.LOCALE == 'en-JE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_JE;
}

if (goog.LOCALE == 'en_JM' || goog.LOCALE == 'en-JM') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_JM;
}

if (goog.LOCALE == 'en_KE' || goog.LOCALE == 'en-KE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_KE;
}

if (goog.LOCALE == 'en_KI' || goog.LOCALE == 'en-KI') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_KI;
}

if (goog.LOCALE == 'en_KN' || goog.LOCALE == 'en-KN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_KN;
}

if (goog.LOCALE == 'en_KY' || goog.LOCALE == 'en-KY') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_KY;
}

if (goog.LOCALE == 'en_LC' || goog.LOCALE == 'en-LC') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_LC;
}

if (goog.LOCALE == 'en_LR' || goog.LOCALE == 'en-LR') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_LR;
}

if (goog.LOCALE == 'en_LS' || goog.LOCALE == 'en-LS') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_LS;
}

if (goog.LOCALE == 'en_MG' || goog.LOCALE == 'en-MG') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_MG;
}

if (goog.LOCALE == 'en_MH' || goog.LOCALE == 'en-MH') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_MH;
}

if (goog.LOCALE == 'en_MO' || goog.LOCALE == 'en-MO') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_MO;
}

if (goog.LOCALE == 'en_MP' || goog.LOCALE == 'en-MP') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_MP;
}

if (goog.LOCALE == 'en_MS' || goog.LOCALE == 'en-MS') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_MS;
}

if (goog.LOCALE == 'en_MT' || goog.LOCALE == 'en-MT') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_MT;
}

if (goog.LOCALE == 'en_MU' || goog.LOCALE == 'en-MU') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_MU;
}

if (goog.LOCALE == 'en_MW' || goog.LOCALE == 'en-MW') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_MW;
}

if (goog.LOCALE == 'en_MY' || goog.LOCALE == 'en-MY') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_MY;
}

if (goog.LOCALE == 'en_NA' || goog.LOCALE == 'en-NA') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_NA;
}

if (goog.LOCALE == 'en_NF' || goog.LOCALE == 'en-NF') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_NF;
}

if (goog.LOCALE == 'en_NG' || goog.LOCALE == 'en-NG') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_NG;
}

if (goog.LOCALE == 'en_NL' || goog.LOCALE == 'en-NL') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_NL;
}

if (goog.LOCALE == 'en_NR' || goog.LOCALE == 'en-NR') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_NR;
}

if (goog.LOCALE == 'en_NU' || goog.LOCALE == 'en-NU') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_NU;
}

if (goog.LOCALE == 'en_NZ' || goog.LOCALE == 'en-NZ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_NZ;
}

if (goog.LOCALE == 'en_PG' || goog.LOCALE == 'en-PG') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_PG;
}

if (goog.LOCALE == 'en_PH' || goog.LOCALE == 'en-PH') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_PH;
}

if (goog.LOCALE == 'en_PK' || goog.LOCALE == 'en-PK') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_PK;
}

if (goog.LOCALE == 'en_PN' || goog.LOCALE == 'en-PN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_PN;
}

if (goog.LOCALE == 'en_PR' || goog.LOCALE == 'en-PR') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_PR;
}

if (goog.LOCALE == 'en_PW' || goog.LOCALE == 'en-PW') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_PW;
}

if (goog.LOCALE == 'en_RW' || goog.LOCALE == 'en-RW') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_RW;
}

if (goog.LOCALE == 'en_SB' || goog.LOCALE == 'en-SB') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_SB;
}

if (goog.LOCALE == 'en_SC' || goog.LOCALE == 'en-SC') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_SC;
}

if (goog.LOCALE == 'en_SD' || goog.LOCALE == 'en-SD') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_SD;
}

if (goog.LOCALE == 'en_SE' || goog.LOCALE == 'en-SE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_SE;
}

if (goog.LOCALE == 'en_SH' || goog.LOCALE == 'en-SH') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_SH;
}

if (goog.LOCALE == 'en_SI' || goog.LOCALE == 'en-SI') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_SI;
}

if (goog.LOCALE == 'en_SL' || goog.LOCALE == 'en-SL') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_SL;
}

if (goog.LOCALE == 'en_SS' || goog.LOCALE == 'en-SS') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_SS;
}

if (goog.LOCALE == 'en_SX' || goog.LOCALE == 'en-SX') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_SX;
}

if (goog.LOCALE == 'en_SZ' || goog.LOCALE == 'en-SZ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_SZ;
}

if (goog.LOCALE == 'en_TC' || goog.LOCALE == 'en-TC') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_TC;
}

if (goog.LOCALE == 'en_TK' || goog.LOCALE == 'en-TK') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_TK;
}

if (goog.LOCALE == 'en_TO' || goog.LOCALE == 'en-TO') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_TO;
}

if (goog.LOCALE == 'en_TT' || goog.LOCALE == 'en-TT') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_TT;
}

if (goog.LOCALE == 'en_TV' || goog.LOCALE == 'en-TV') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_TV;
}

if (goog.LOCALE == 'en_TZ' || goog.LOCALE == 'en-TZ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_TZ;
}

if (goog.LOCALE == 'en_UG' || goog.LOCALE == 'en-UG') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_UG;
}

if (goog.LOCALE == 'en_UM' || goog.LOCALE == 'en-UM') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_UM;
}

if (goog.LOCALE == 'en_US_POSIX' || goog.LOCALE == 'en-US-POSIX') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_US_POSIX;
}

if (goog.LOCALE == 'en_VC' || goog.LOCALE == 'en-VC') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_VC;
}

if (goog.LOCALE == 'en_VG' || goog.LOCALE == 'en-VG') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_VG;
}

if (goog.LOCALE == 'en_VI' || goog.LOCALE == 'en-VI') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_VI;
}

if (goog.LOCALE == 'en_VU' || goog.LOCALE == 'en-VU') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_VU;
}

if (goog.LOCALE == 'en_WS' || goog.LOCALE == 'en-WS') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_WS;
}

if (goog.LOCALE == 'en_XA' || goog.LOCALE == 'en-XA') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_XA;
}

if (goog.LOCALE == 'en_ZM' || goog.LOCALE == 'en-ZM') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_ZM;
}

if (goog.LOCALE == 'en_ZW' || goog.LOCALE == 'en-ZW') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_en_ZW;
}

if (goog.LOCALE == 'eo') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_eo;
}

if (goog.LOCALE == 'es_AR' || goog.LOCALE == 'es-AR') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_es_AR;
}

if (goog.LOCALE == 'es_BO' || goog.LOCALE == 'es-BO') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_es_BO;
}

if (goog.LOCALE == 'es_BR' || goog.LOCALE == 'es-BR') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_es_BR;
}

if (goog.LOCALE == 'es_BZ' || goog.LOCALE == 'es-BZ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_es_BZ;
}

if (goog.LOCALE == 'es_CL' || goog.LOCALE == 'es-CL') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_es_CL;
}

if (goog.LOCALE == 'es_CO' || goog.LOCALE == 'es-CO') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_es_CO;
}

if (goog.LOCALE == 'es_CR' || goog.LOCALE == 'es-CR') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_es_CR;
}

if (goog.LOCALE == 'es_CU' || goog.LOCALE == 'es-CU') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_es_CU;
}

if (goog.LOCALE == 'es_DO' || goog.LOCALE == 'es-DO') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_es_DO;
}

if (goog.LOCALE == 'es_EA' || goog.LOCALE == 'es-EA') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_es_EA;
}

if (goog.LOCALE == 'es_EC' || goog.LOCALE == 'es-EC') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_es_EC;
}

if (goog.LOCALE == 'es_GQ' || goog.LOCALE == 'es-GQ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_es_GQ;
}

if (goog.LOCALE == 'es_GT' || goog.LOCALE == 'es-GT') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_es_GT;
}

if (goog.LOCALE == 'es_HN' || goog.LOCALE == 'es-HN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_es_HN;
}

if (goog.LOCALE == 'es_IC' || goog.LOCALE == 'es-IC') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_es_IC;
}

if (goog.LOCALE == 'es_NI' || goog.LOCALE == 'es-NI') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_es_NI;
}

if (goog.LOCALE == 'es_PA' || goog.LOCALE == 'es-PA') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_es_PA;
}

if (goog.LOCALE == 'es_PE' || goog.LOCALE == 'es-PE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_es_PE;
}

if (goog.LOCALE == 'es_PH' || goog.LOCALE == 'es-PH') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_es_PH;
}

if (goog.LOCALE == 'es_PR' || goog.LOCALE == 'es-PR') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_es_PR;
}

if (goog.LOCALE == 'es_PY' || goog.LOCALE == 'es-PY') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_es_PY;
}

if (goog.LOCALE == 'es_SV' || goog.LOCALE == 'es-SV') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_es_SV;
}

if (goog.LOCALE == 'es_UY' || goog.LOCALE == 'es-UY') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_es_UY;
}

if (goog.LOCALE == 'es_VE' || goog.LOCALE == 'es-VE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_es_VE;
}

if (goog.LOCALE == 'et_EE' || goog.LOCALE == 'et-EE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_et_EE;
}

if (goog.LOCALE == 'eu_ES' || goog.LOCALE == 'eu-ES') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_eu_ES;
}

if (goog.LOCALE == 'ewo') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ewo;
}

if (goog.LOCALE == 'ewo_CM' || goog.LOCALE == 'ewo-CM') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ewo_CM;
}

if (goog.LOCALE == 'fa_AF' || goog.LOCALE == 'fa-AF') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fa_AF;
}

if (goog.LOCALE == 'fa_IR' || goog.LOCALE == 'fa-IR') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fa_IR;
}

if (goog.LOCALE == 'ff') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ff;
}

if (goog.LOCALE == 'ff_CM' || goog.LOCALE == 'ff-CM') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ff_CM;
}

if (goog.LOCALE == 'ff_GN' || goog.LOCALE == 'ff-GN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ff_GN;
}

if (goog.LOCALE == 'ff_MR' || goog.LOCALE == 'ff-MR') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ff_MR;
}

if (goog.LOCALE == 'ff_SN' || goog.LOCALE == 'ff-SN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ff_SN;
}

if (goog.LOCALE == 'fi_FI' || goog.LOCALE == 'fi-FI') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fi_FI;
}

if (goog.LOCALE == 'fil_PH' || goog.LOCALE == 'fil-PH') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fil_PH;
}

if (goog.LOCALE == 'fo') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fo;
}

if (goog.LOCALE == 'fo_DK' || goog.LOCALE == 'fo-DK') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fo_DK;
}

if (goog.LOCALE == 'fo_FO' || goog.LOCALE == 'fo-FO') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fo_FO;
}

if (goog.LOCALE == 'fr_BE' || goog.LOCALE == 'fr-BE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_BE;
}

if (goog.LOCALE == 'fr_BF' || goog.LOCALE == 'fr-BF') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_BF;
}

if (goog.LOCALE == 'fr_BI' || goog.LOCALE == 'fr-BI') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_BI;
}

if (goog.LOCALE == 'fr_BJ' || goog.LOCALE == 'fr-BJ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_BJ;
}

if (goog.LOCALE == 'fr_BL' || goog.LOCALE == 'fr-BL') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_BL;
}

if (goog.LOCALE == 'fr_CD' || goog.LOCALE == 'fr-CD') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_CD;
}

if (goog.LOCALE == 'fr_CF' || goog.LOCALE == 'fr-CF') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_CF;
}

if (goog.LOCALE == 'fr_CG' || goog.LOCALE == 'fr-CG') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_CG;
}

if (goog.LOCALE == 'fr_CH' || goog.LOCALE == 'fr-CH') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_CH;
}

if (goog.LOCALE == 'fr_CI' || goog.LOCALE == 'fr-CI') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_CI;
}

if (goog.LOCALE == 'fr_CM' || goog.LOCALE == 'fr-CM') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_CM;
}

if (goog.LOCALE == 'fr_DJ' || goog.LOCALE == 'fr-DJ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_DJ;
}

if (goog.LOCALE == 'fr_DZ' || goog.LOCALE == 'fr-DZ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_DZ;
}

if (goog.LOCALE == 'fr_FR' || goog.LOCALE == 'fr-FR') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_FR;
}

if (goog.LOCALE == 'fr_GA' || goog.LOCALE == 'fr-GA') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_GA;
}

if (goog.LOCALE == 'fr_GF' || goog.LOCALE == 'fr-GF') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_GF;
}

if (goog.LOCALE == 'fr_GN' || goog.LOCALE == 'fr-GN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_GN;
}

if (goog.LOCALE == 'fr_GP' || goog.LOCALE == 'fr-GP') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_GP;
}

if (goog.LOCALE == 'fr_GQ' || goog.LOCALE == 'fr-GQ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_GQ;
}

if (goog.LOCALE == 'fr_HT' || goog.LOCALE == 'fr-HT') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_HT;
}

if (goog.LOCALE == 'fr_KM' || goog.LOCALE == 'fr-KM') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_KM;
}

if (goog.LOCALE == 'fr_LU' || goog.LOCALE == 'fr-LU') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_LU;
}

if (goog.LOCALE == 'fr_MA' || goog.LOCALE == 'fr-MA') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_MA;
}

if (goog.LOCALE == 'fr_MC' || goog.LOCALE == 'fr-MC') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_MC;
}

if (goog.LOCALE == 'fr_MF' || goog.LOCALE == 'fr-MF') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_MF;
}

if (goog.LOCALE == 'fr_MG' || goog.LOCALE == 'fr-MG') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_MG;
}

if (goog.LOCALE == 'fr_ML' || goog.LOCALE == 'fr-ML') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_ML;
}

if (goog.LOCALE == 'fr_MQ' || goog.LOCALE == 'fr-MQ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_MQ;
}

if (goog.LOCALE == 'fr_MR' || goog.LOCALE == 'fr-MR') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_MR;
}

if (goog.LOCALE == 'fr_MU' || goog.LOCALE == 'fr-MU') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_MU;
}

if (goog.LOCALE == 'fr_NC' || goog.LOCALE == 'fr-NC') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_NC;
}

if (goog.LOCALE == 'fr_NE' || goog.LOCALE == 'fr-NE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_NE;
}

if (goog.LOCALE == 'fr_PF' || goog.LOCALE == 'fr-PF') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_PF;
}

if (goog.LOCALE == 'fr_PM' || goog.LOCALE == 'fr-PM') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_PM;
}

if (goog.LOCALE == 'fr_RE' || goog.LOCALE == 'fr-RE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_RE;
}

if (goog.LOCALE == 'fr_RW' || goog.LOCALE == 'fr-RW') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_RW;
}

if (goog.LOCALE == 'fr_SC' || goog.LOCALE == 'fr-SC') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_SC;
}

if (goog.LOCALE == 'fr_SN' || goog.LOCALE == 'fr-SN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_SN;
}

if (goog.LOCALE == 'fr_SY' || goog.LOCALE == 'fr-SY') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_SY;
}

if (goog.LOCALE == 'fr_TD' || goog.LOCALE == 'fr-TD') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_TD;
}

if (goog.LOCALE == 'fr_TG' || goog.LOCALE == 'fr-TG') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_TG;
}

if (goog.LOCALE == 'fr_TN' || goog.LOCALE == 'fr-TN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_TN;
}

if (goog.LOCALE == 'fr_VU' || goog.LOCALE == 'fr-VU') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_VU;
}

if (goog.LOCALE == 'fr_WF' || goog.LOCALE == 'fr-WF') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_WF;
}

if (goog.LOCALE == 'fr_YT' || goog.LOCALE == 'fr-YT') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fr_YT;
}

if (goog.LOCALE == 'fur') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fur;
}

if (goog.LOCALE == 'fur_IT' || goog.LOCALE == 'fur-IT') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fur_IT;
}

if (goog.LOCALE == 'fy') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fy;
}

if (goog.LOCALE == 'fy_NL' || goog.LOCALE == 'fy-NL') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_fy_NL;
}

if (goog.LOCALE == 'ga_IE' || goog.LOCALE == 'ga-IE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ga_IE;
}

if (goog.LOCALE == 'gd') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_gd;
}

if (goog.LOCALE == 'gd_GB' || goog.LOCALE == 'gd-GB') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_gd_GB;
}

if (goog.LOCALE == 'gl_ES' || goog.LOCALE == 'gl-ES') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_gl_ES;
}

if (goog.LOCALE == 'gsw_CH' || goog.LOCALE == 'gsw-CH') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_gsw_CH;
}

if (goog.LOCALE == 'gsw_FR' || goog.LOCALE == 'gsw-FR') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_gsw_FR;
}

if (goog.LOCALE == 'gsw_LI' || goog.LOCALE == 'gsw-LI') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_gsw_LI;
}

if (goog.LOCALE == 'gu_IN' || goog.LOCALE == 'gu-IN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_gu_IN;
}

if (goog.LOCALE == 'guz') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_guz;
}

if (goog.LOCALE == 'guz_KE' || goog.LOCALE == 'guz-KE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_guz_KE;
}

if (goog.LOCALE == 'gv') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_gv;
}

if (goog.LOCALE == 'gv_IM' || goog.LOCALE == 'gv-IM') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_gv_IM;
}

if (goog.LOCALE == 'ha') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ha;
}

if (goog.LOCALE == 'ha_GH' || goog.LOCALE == 'ha-GH') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ha_GH;
}

if (goog.LOCALE == 'ha_NE' || goog.LOCALE == 'ha-NE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ha_NE;
}

if (goog.LOCALE == 'ha_NG' || goog.LOCALE == 'ha-NG') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ha_NG;
}

if (goog.LOCALE == 'haw_US' || goog.LOCALE == 'haw-US') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_haw_US;
}

if (goog.LOCALE == 'he_IL' || goog.LOCALE == 'he-IL') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_he_IL;
}

if (goog.LOCALE == 'hi_IN' || goog.LOCALE == 'hi-IN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_hi_IN;
}

if (goog.LOCALE == 'hr_BA' || goog.LOCALE == 'hr-BA') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_hr_BA;
}

if (goog.LOCALE == 'hr_HR' || goog.LOCALE == 'hr-HR') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_hr_HR;
}

if (goog.LOCALE == 'hsb') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_hsb;
}

if (goog.LOCALE == 'hsb_DE' || goog.LOCALE == 'hsb-DE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_hsb_DE;
}

if (goog.LOCALE == 'hu_HU' || goog.LOCALE == 'hu-HU') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_hu_HU;
}

if (goog.LOCALE == 'hy_AM' || goog.LOCALE == 'hy-AM') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_hy_AM;
}

if (goog.LOCALE == 'id_ID' || goog.LOCALE == 'id-ID') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_id_ID;
}

if (goog.LOCALE == 'ig') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ig;
}

if (goog.LOCALE == 'ig_NG' || goog.LOCALE == 'ig-NG') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ig_NG;
}

if (goog.LOCALE == 'ii') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ii;
}

if (goog.LOCALE == 'ii_CN' || goog.LOCALE == 'ii-CN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ii_CN;
}

if (goog.LOCALE == 'is_IS' || goog.LOCALE == 'is-IS') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_is_IS;
}

if (goog.LOCALE == 'it_CH' || goog.LOCALE == 'it-CH') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_it_CH;
}

if (goog.LOCALE == 'it_IT' || goog.LOCALE == 'it-IT') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_it_IT;
}

if (goog.LOCALE == 'it_SM' || goog.LOCALE == 'it-SM') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_it_SM;
}

if (goog.LOCALE == 'it_VA' || goog.LOCALE == 'it-VA') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_it_VA;
}

if (goog.LOCALE == 'ja_JP' || goog.LOCALE == 'ja-JP') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ja_JP;
}

if (goog.LOCALE == 'jgo') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_jgo;
}

if (goog.LOCALE == 'jgo_CM' || goog.LOCALE == 'jgo-CM') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_jgo_CM;
}

if (goog.LOCALE == 'jmc') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_jmc;
}

if (goog.LOCALE == 'jmc_TZ' || goog.LOCALE == 'jmc-TZ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_jmc_TZ;
}

if (goog.LOCALE == 'ka_GE' || goog.LOCALE == 'ka-GE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ka_GE;
}

if (goog.LOCALE == 'kab') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_kab;
}

if (goog.LOCALE == 'kab_DZ' || goog.LOCALE == 'kab-DZ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_kab_DZ;
}

if (goog.LOCALE == 'kam') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_kam;
}

if (goog.LOCALE == 'kam_KE' || goog.LOCALE == 'kam-KE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_kam_KE;
}

if (goog.LOCALE == 'kde') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_kde;
}

if (goog.LOCALE == 'kde_TZ' || goog.LOCALE == 'kde-TZ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_kde_TZ;
}

if (goog.LOCALE == 'kea') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_kea;
}

if (goog.LOCALE == 'kea_CV' || goog.LOCALE == 'kea-CV') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_kea_CV;
}

if (goog.LOCALE == 'khq') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_khq;
}

if (goog.LOCALE == 'khq_ML' || goog.LOCALE == 'khq-ML') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_khq_ML;
}

if (goog.LOCALE == 'ki') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ki;
}

if (goog.LOCALE == 'ki_KE' || goog.LOCALE == 'ki-KE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ki_KE;
}

if (goog.LOCALE == 'kk_KZ' || goog.LOCALE == 'kk-KZ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_kk_KZ;
}

if (goog.LOCALE == 'kkj') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_kkj;
}

if (goog.LOCALE == 'kkj_CM' || goog.LOCALE == 'kkj-CM') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_kkj_CM;
}

if (goog.LOCALE == 'kl') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_kl;
}

if (goog.LOCALE == 'kl_GL' || goog.LOCALE == 'kl-GL') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_kl_GL;
}

if (goog.LOCALE == 'kln') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_kln;
}

if (goog.LOCALE == 'kln_KE' || goog.LOCALE == 'kln-KE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_kln_KE;
}

if (goog.LOCALE == 'km_KH' || goog.LOCALE == 'km-KH') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_km_KH;
}

if (goog.LOCALE == 'kn_IN' || goog.LOCALE == 'kn-IN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_kn_IN;
}

if (goog.LOCALE == 'ko_KP' || goog.LOCALE == 'ko-KP') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ko_KP;
}

if (goog.LOCALE == 'ko_KR' || goog.LOCALE == 'ko-KR') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ko_KR;
}

if (goog.LOCALE == 'kok') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_kok;
}

if (goog.LOCALE == 'kok_IN' || goog.LOCALE == 'kok-IN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_kok_IN;
}

if (goog.LOCALE == 'ks') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ks;
}

if (goog.LOCALE == 'ks_IN' || goog.LOCALE == 'ks-IN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ks_IN;
}

if (goog.LOCALE == 'ksb') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ksb;
}

if (goog.LOCALE == 'ksb_TZ' || goog.LOCALE == 'ksb-TZ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ksb_TZ;
}

if (goog.LOCALE == 'ksf') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ksf;
}

if (goog.LOCALE == 'ksf_CM' || goog.LOCALE == 'ksf-CM') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ksf_CM;
}

if (goog.LOCALE == 'ksh') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ksh;
}

if (goog.LOCALE == 'ksh_DE' || goog.LOCALE == 'ksh-DE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ksh_DE;
}

if (goog.LOCALE == 'kw') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_kw;
}

if (goog.LOCALE == 'kw_GB' || goog.LOCALE == 'kw-GB') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_kw_GB;
}

if (goog.LOCALE == 'ky_KG' || goog.LOCALE == 'ky-KG') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ky_KG;
}

if (goog.LOCALE == 'lag') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_lag;
}

if (goog.LOCALE == 'lag_TZ' || goog.LOCALE == 'lag-TZ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_lag_TZ;
}

if (goog.LOCALE == 'lb') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_lb;
}

if (goog.LOCALE == 'lb_LU' || goog.LOCALE == 'lb-LU') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_lb_LU;
}

if (goog.LOCALE == 'lg') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_lg;
}

if (goog.LOCALE == 'lg_UG' || goog.LOCALE == 'lg-UG') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_lg_UG;
}

if (goog.LOCALE == 'lkt') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_lkt;
}

if (goog.LOCALE == 'lkt_US' || goog.LOCALE == 'lkt-US') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_lkt_US;
}

if (goog.LOCALE == 'ln_AO' || goog.LOCALE == 'ln-AO') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ln_AO;
}

if (goog.LOCALE == 'ln_CD' || goog.LOCALE == 'ln-CD') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ln_CD;
}

if (goog.LOCALE == 'ln_CF' || goog.LOCALE == 'ln-CF') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ln_CF;
}

if (goog.LOCALE == 'ln_CG' || goog.LOCALE == 'ln-CG') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ln_CG;
}

if (goog.LOCALE == 'lo_LA' || goog.LOCALE == 'lo-LA') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_lo_LA;
}

if (goog.LOCALE == 'lrc') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_lrc;
}

if (goog.LOCALE == 'lrc_IQ' || goog.LOCALE == 'lrc-IQ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_lrc_IQ;
}

if (goog.LOCALE == 'lrc_IR' || goog.LOCALE == 'lrc-IR') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_lrc_IR;
}

if (goog.LOCALE == 'lt_LT' || goog.LOCALE == 'lt-LT') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_lt_LT;
}

if (goog.LOCALE == 'lu') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_lu;
}

if (goog.LOCALE == 'lu_CD' || goog.LOCALE == 'lu-CD') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_lu_CD;
}

if (goog.LOCALE == 'luo') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_luo;
}

if (goog.LOCALE == 'luo_KE' || goog.LOCALE == 'luo-KE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_luo_KE;
}

if (goog.LOCALE == 'luy') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_luy;
}

if (goog.LOCALE == 'luy_KE' || goog.LOCALE == 'luy-KE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_luy_KE;
}

if (goog.LOCALE == 'lv_LV' || goog.LOCALE == 'lv-LV') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_lv_LV;
}

if (goog.LOCALE == 'mas') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_mas;
}

if (goog.LOCALE == 'mas_KE' || goog.LOCALE == 'mas-KE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_mas_KE;
}

if (goog.LOCALE == 'mas_TZ' || goog.LOCALE == 'mas-TZ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_mas_TZ;
}

if (goog.LOCALE == 'mer') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_mer;
}

if (goog.LOCALE == 'mer_KE' || goog.LOCALE == 'mer-KE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_mer_KE;
}

if (goog.LOCALE == 'mfe') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_mfe;
}

if (goog.LOCALE == 'mfe_MU' || goog.LOCALE == 'mfe-MU') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_mfe_MU;
}

if (goog.LOCALE == 'mg') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_mg;
}

if (goog.LOCALE == 'mg_MG' || goog.LOCALE == 'mg-MG') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_mg_MG;
}

if (goog.LOCALE == 'mgh') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_mgh;
}

if (goog.LOCALE == 'mgh_MZ' || goog.LOCALE == 'mgh-MZ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_mgh_MZ;
}

if (goog.LOCALE == 'mgo') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_mgo;
}

if (goog.LOCALE == 'mgo_CM' || goog.LOCALE == 'mgo-CM') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_mgo_CM;
}

if (goog.LOCALE == 'mk_MK' || goog.LOCALE == 'mk-MK') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_mk_MK;
}

if (goog.LOCALE == 'ml_IN' || goog.LOCALE == 'ml-IN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ml_IN;
}

if (goog.LOCALE == 'mn_MN' || goog.LOCALE == 'mn-MN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_mn_MN;
}

if (goog.LOCALE == 'mr_IN' || goog.LOCALE == 'mr-IN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_mr_IN;
}

if (goog.LOCALE == 'ms_BN' || goog.LOCALE == 'ms-BN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ms_BN;
}

if (goog.LOCALE == 'ms_MY' || goog.LOCALE == 'ms-MY') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ms_MY;
}

if (goog.LOCALE == 'ms_SG' || goog.LOCALE == 'ms-SG') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ms_SG;
}

if (goog.LOCALE == 'mt_MT' || goog.LOCALE == 'mt-MT') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_mt_MT;
}

if (goog.LOCALE == 'mua') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_mua;
}

if (goog.LOCALE == 'mua_CM' || goog.LOCALE == 'mua-CM') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_mua_CM;
}

if (goog.LOCALE == 'my_MM' || goog.LOCALE == 'my-MM') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_my_MM;
}

if (goog.LOCALE == 'mzn') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_mzn;
}

if (goog.LOCALE == 'mzn_IR' || goog.LOCALE == 'mzn-IR') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_mzn_IR;
}

if (goog.LOCALE == 'naq') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_naq;
}

if (goog.LOCALE == 'naq_NA' || goog.LOCALE == 'naq-NA') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_naq_NA;
}

if (goog.LOCALE == 'nb_NO' || goog.LOCALE == 'nb-NO') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_nb_NO;
}

if (goog.LOCALE == 'nb_SJ' || goog.LOCALE == 'nb-SJ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_nb_SJ;
}

if (goog.LOCALE == 'nd') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_nd;
}

if (goog.LOCALE == 'nd_ZW' || goog.LOCALE == 'nd-ZW') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_nd_ZW;
}

if (goog.LOCALE == 'nds') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_nds;
}

if (goog.LOCALE == 'nds_DE' || goog.LOCALE == 'nds-DE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_nds_DE;
}

if (goog.LOCALE == 'nds_NL' || goog.LOCALE == 'nds-NL') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_nds_NL;
}

if (goog.LOCALE == 'ne_IN' || goog.LOCALE == 'ne-IN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ne_IN;
}

if (goog.LOCALE == 'ne_NP' || goog.LOCALE == 'ne-NP') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ne_NP;
}

if (goog.LOCALE == 'nl_AW' || goog.LOCALE == 'nl-AW') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_nl_AW;
}

if (goog.LOCALE == 'nl_BE' || goog.LOCALE == 'nl-BE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_nl_BE;
}

if (goog.LOCALE == 'nl_BQ' || goog.LOCALE == 'nl-BQ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_nl_BQ;
}

if (goog.LOCALE == 'nl_CW' || goog.LOCALE == 'nl-CW') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_nl_CW;
}

if (goog.LOCALE == 'nl_NL' || goog.LOCALE == 'nl-NL') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_nl_NL;
}

if (goog.LOCALE == 'nl_SR' || goog.LOCALE == 'nl-SR') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_nl_SR;
}

if (goog.LOCALE == 'nl_SX' || goog.LOCALE == 'nl-SX') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_nl_SX;
}

if (goog.LOCALE == 'nmg') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_nmg;
}

if (goog.LOCALE == 'nmg_CM' || goog.LOCALE == 'nmg-CM') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_nmg_CM;
}

if (goog.LOCALE == 'nn') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_nn;
}

if (goog.LOCALE == 'nn_NO' || goog.LOCALE == 'nn-NO') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_nn_NO;
}

if (goog.LOCALE == 'nnh') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_nnh;
}

if (goog.LOCALE == 'nnh_CM' || goog.LOCALE == 'nnh-CM') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_nnh_CM;
}

if (goog.LOCALE == 'nus') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_nus;
}

if (goog.LOCALE == 'nus_SS' || goog.LOCALE == 'nus-SS') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_nus_SS;
}

if (goog.LOCALE == 'nyn') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_nyn;
}

if (goog.LOCALE == 'nyn_UG' || goog.LOCALE == 'nyn-UG') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_nyn_UG;
}

if (goog.LOCALE == 'om') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_om;
}

if (goog.LOCALE == 'om_ET' || goog.LOCALE == 'om-ET') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_om_ET;
}

if (goog.LOCALE == 'om_KE' || goog.LOCALE == 'om-KE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_om_KE;
}

if (goog.LOCALE == 'or_IN' || goog.LOCALE == 'or-IN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_or_IN;
}

if (goog.LOCALE == 'os') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_os;
}

if (goog.LOCALE == 'os_GE' || goog.LOCALE == 'os-GE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_os_GE;
}

if (goog.LOCALE == 'os_RU' || goog.LOCALE == 'os-RU') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_os_RU;
}

if (goog.LOCALE == 'pa_Arab' || goog.LOCALE == 'pa-Arab') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_pa_Arab;
}

if (goog.LOCALE == 'pa_Arab_PK' || goog.LOCALE == 'pa-Arab-PK') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_pa_Arab_PK;
}

if (goog.LOCALE == 'pa_Guru' || goog.LOCALE == 'pa-Guru') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_pa_Guru;
}

if (goog.LOCALE == 'pa_Guru_IN' || goog.LOCALE == 'pa-Guru-IN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_pa_Guru_IN;
}

if (goog.LOCALE == 'pl_PL' || goog.LOCALE == 'pl-PL') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_pl_PL;
}

if (goog.LOCALE == 'ps') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ps;
}

if (goog.LOCALE == 'ps_AF' || goog.LOCALE == 'ps-AF') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ps_AF;
}

if (goog.LOCALE == 'pt_AO' || goog.LOCALE == 'pt-AO') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_pt_AO;
}

if (goog.LOCALE == 'pt_CH' || goog.LOCALE == 'pt-CH') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_pt_CH;
}

if (goog.LOCALE == 'pt_CV' || goog.LOCALE == 'pt-CV') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_pt_CV;
}

if (goog.LOCALE == 'pt_GQ' || goog.LOCALE == 'pt-GQ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_pt_GQ;
}

if (goog.LOCALE == 'pt_GW' || goog.LOCALE == 'pt-GW') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_pt_GW;
}

if (goog.LOCALE == 'pt_LU' || goog.LOCALE == 'pt-LU') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_pt_LU;
}

if (goog.LOCALE == 'pt_MO' || goog.LOCALE == 'pt-MO') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_pt_MO;
}

if (goog.LOCALE == 'pt_MZ' || goog.LOCALE == 'pt-MZ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_pt_MZ;
}

if (goog.LOCALE == 'pt_ST' || goog.LOCALE == 'pt-ST') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_pt_ST;
}

if (goog.LOCALE == 'pt_TL' || goog.LOCALE == 'pt-TL') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_pt_TL;
}

if (goog.LOCALE == 'qu') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_qu;
}

if (goog.LOCALE == 'qu_BO' || goog.LOCALE == 'qu-BO') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_qu_BO;
}

if (goog.LOCALE == 'qu_EC' || goog.LOCALE == 'qu-EC') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_qu_EC;
}

if (goog.LOCALE == 'qu_PE' || goog.LOCALE == 'qu-PE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_qu_PE;
}

if (goog.LOCALE == 'rm') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_rm;
}

if (goog.LOCALE == 'rm_CH' || goog.LOCALE == 'rm-CH') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_rm_CH;
}

if (goog.LOCALE == 'rn') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_rn;
}

if (goog.LOCALE == 'rn_BI' || goog.LOCALE == 'rn-BI') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_rn_BI;
}

if (goog.LOCALE == 'ro_MD' || goog.LOCALE == 'ro-MD') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ro_MD;
}

if (goog.LOCALE == 'ro_RO' || goog.LOCALE == 'ro-RO') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ro_RO;
}

if (goog.LOCALE == 'rof') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_rof;
}

if (goog.LOCALE == 'rof_TZ' || goog.LOCALE == 'rof-TZ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_rof_TZ;
}

if (goog.LOCALE == 'ru_BY' || goog.LOCALE == 'ru-BY') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ru_BY;
}

if (goog.LOCALE == 'ru_KG' || goog.LOCALE == 'ru-KG') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ru_KG;
}

if (goog.LOCALE == 'ru_KZ' || goog.LOCALE == 'ru-KZ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ru_KZ;
}

if (goog.LOCALE == 'ru_MD' || goog.LOCALE == 'ru-MD') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ru_MD;
}

if (goog.LOCALE == 'ru_RU' || goog.LOCALE == 'ru-RU') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ru_RU;
}

if (goog.LOCALE == 'ru_UA' || goog.LOCALE == 'ru-UA') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ru_UA;
}

if (goog.LOCALE == 'rw') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_rw;
}

if (goog.LOCALE == 'rw_RW' || goog.LOCALE == 'rw-RW') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_rw_RW;
}

if (goog.LOCALE == 'rwk') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_rwk;
}

if (goog.LOCALE == 'rwk_TZ' || goog.LOCALE == 'rwk-TZ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_rwk_TZ;
}

if (goog.LOCALE == 'sah') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sah;
}

if (goog.LOCALE == 'sah_RU' || goog.LOCALE == 'sah-RU') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sah_RU;
}

if (goog.LOCALE == 'saq') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_saq;
}

if (goog.LOCALE == 'saq_KE' || goog.LOCALE == 'saq-KE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_saq_KE;
}

if (goog.LOCALE == 'sbp') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sbp;
}

if (goog.LOCALE == 'sbp_TZ' || goog.LOCALE == 'sbp-TZ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sbp_TZ;
}

if (goog.LOCALE == 'se') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_se;
}

if (goog.LOCALE == 'se_FI' || goog.LOCALE == 'se-FI') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_se_FI;
}

if (goog.LOCALE == 'se_NO' || goog.LOCALE == 'se-NO') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_se_NO;
}

if (goog.LOCALE == 'se_SE' || goog.LOCALE == 'se-SE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_se_SE;
}

if (goog.LOCALE == 'seh') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_seh;
}

if (goog.LOCALE == 'seh_MZ' || goog.LOCALE == 'seh-MZ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_seh_MZ;
}

if (goog.LOCALE == 'ses') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ses;
}

if (goog.LOCALE == 'ses_ML' || goog.LOCALE == 'ses-ML') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ses_ML;
}

if (goog.LOCALE == 'sg') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sg;
}

if (goog.LOCALE == 'sg_CF' || goog.LOCALE == 'sg-CF') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sg_CF;
}

if (goog.LOCALE == 'shi') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_shi;
}

if (goog.LOCALE == 'shi_Latn' || goog.LOCALE == 'shi-Latn') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_shi_Latn;
}

if (goog.LOCALE == 'shi_Latn_MA' || goog.LOCALE == 'shi-Latn-MA') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_shi_Latn_MA;
}

if (goog.LOCALE == 'shi_Tfng' || goog.LOCALE == 'shi-Tfng') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_shi_Tfng;
}

if (goog.LOCALE == 'shi_Tfng_MA' || goog.LOCALE == 'shi-Tfng-MA') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_shi_Tfng_MA;
}

if (goog.LOCALE == 'si_LK' || goog.LOCALE == 'si-LK') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_si_LK;
}

if (goog.LOCALE == 'sk_SK' || goog.LOCALE == 'sk-SK') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sk_SK;
}

if (goog.LOCALE == 'sl_SI' || goog.LOCALE == 'sl-SI') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sl_SI;
}

if (goog.LOCALE == 'smn') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_smn;
}

if (goog.LOCALE == 'smn_FI' || goog.LOCALE == 'smn-FI') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_smn_FI;
}

if (goog.LOCALE == 'sn') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sn;
}

if (goog.LOCALE == 'sn_ZW' || goog.LOCALE == 'sn-ZW') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sn_ZW;
}

if (goog.LOCALE == 'so') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_so;
}

if (goog.LOCALE == 'so_DJ' || goog.LOCALE == 'so-DJ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_so_DJ;
}

if (goog.LOCALE == 'so_ET' || goog.LOCALE == 'so-ET') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_so_ET;
}

if (goog.LOCALE == 'so_KE' || goog.LOCALE == 'so-KE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_so_KE;
}

if (goog.LOCALE == 'so_SO' || goog.LOCALE == 'so-SO') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_so_SO;
}

if (goog.LOCALE == 'sq_AL' || goog.LOCALE == 'sq-AL') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sq_AL;
}

if (goog.LOCALE == 'sq_MK' || goog.LOCALE == 'sq-MK') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sq_MK;
}

if (goog.LOCALE == 'sq_XK' || goog.LOCALE == 'sq-XK') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sq_XK;
}

if (goog.LOCALE == 'sr_Cyrl' || goog.LOCALE == 'sr-Cyrl') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sr_Cyrl;
}

if (goog.LOCALE == 'sr_Cyrl_BA' || goog.LOCALE == 'sr-Cyrl-BA') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sr_Cyrl_BA;
}

if (goog.LOCALE == 'sr_Cyrl_ME' || goog.LOCALE == 'sr-Cyrl-ME') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sr_Cyrl_ME;
}

if (goog.LOCALE == 'sr_Cyrl_RS' || goog.LOCALE == 'sr-Cyrl-RS') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sr_Cyrl_RS;
}

if (goog.LOCALE == 'sr_Cyrl_XK' || goog.LOCALE == 'sr-Cyrl-XK') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sr_Cyrl_XK;
}

if (goog.LOCALE == 'sr_Latn_BA' || goog.LOCALE == 'sr-Latn-BA') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sr_Latn_BA;
}

if (goog.LOCALE == 'sr_Latn_ME' || goog.LOCALE == 'sr-Latn-ME') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sr_Latn_ME;
}

if (goog.LOCALE == 'sr_Latn_RS' || goog.LOCALE == 'sr-Latn-RS') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sr_Latn_RS;
}

if (goog.LOCALE == 'sr_Latn_XK' || goog.LOCALE == 'sr-Latn-XK') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sr_Latn_XK;
}

if (goog.LOCALE == 'sv_AX' || goog.LOCALE == 'sv-AX') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sv_AX;
}

if (goog.LOCALE == 'sv_FI' || goog.LOCALE == 'sv-FI') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sv_FI;
}

if (goog.LOCALE == 'sv_SE' || goog.LOCALE == 'sv-SE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sv_SE;
}

if (goog.LOCALE == 'sw_CD' || goog.LOCALE == 'sw-CD') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sw_CD;
}

if (goog.LOCALE == 'sw_KE' || goog.LOCALE == 'sw-KE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sw_KE;
}

if (goog.LOCALE == 'sw_TZ' || goog.LOCALE == 'sw-TZ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sw_TZ;
}

if (goog.LOCALE == 'sw_UG' || goog.LOCALE == 'sw-UG') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_sw_UG;
}

if (goog.LOCALE == 'ta_IN' || goog.LOCALE == 'ta-IN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ta_IN;
}

if (goog.LOCALE == 'ta_LK' || goog.LOCALE == 'ta-LK') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ta_LK;
}

if (goog.LOCALE == 'ta_MY' || goog.LOCALE == 'ta-MY') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ta_MY;
}

if (goog.LOCALE == 'ta_SG' || goog.LOCALE == 'ta-SG') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ta_SG;
}

if (goog.LOCALE == 'te_IN' || goog.LOCALE == 'te-IN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_te_IN;
}

if (goog.LOCALE == 'teo') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_teo;
}

if (goog.LOCALE == 'teo_KE' || goog.LOCALE == 'teo-KE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_teo_KE;
}

if (goog.LOCALE == 'teo_UG' || goog.LOCALE == 'teo-UG') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_teo_UG;
}

if (goog.LOCALE == 'tg') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_tg;
}

if (goog.LOCALE == 'tg_TJ' || goog.LOCALE == 'tg-TJ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_tg_TJ;
}

if (goog.LOCALE == 'th_TH' || goog.LOCALE == 'th-TH') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_th_TH;
}

if (goog.LOCALE == 'ti') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ti;
}

if (goog.LOCALE == 'ti_ER' || goog.LOCALE == 'ti-ER') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ti_ER;
}

if (goog.LOCALE == 'ti_ET' || goog.LOCALE == 'ti-ET') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ti_ET;
}

if (goog.LOCALE == 'to') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_to;
}

if (goog.LOCALE == 'to_TO' || goog.LOCALE == 'to-TO') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_to_TO;
}

if (goog.LOCALE == 'tr_CY' || goog.LOCALE == 'tr-CY') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_tr_CY;
}

if (goog.LOCALE == 'tr_TR' || goog.LOCALE == 'tr-TR') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_tr_TR;
}

if (goog.LOCALE == 'tt') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_tt;
}

if (goog.LOCALE == 'tt_RU' || goog.LOCALE == 'tt-RU') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_tt_RU;
}

if (goog.LOCALE == 'twq') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_twq;
}

if (goog.LOCALE == 'twq_NE' || goog.LOCALE == 'twq-NE') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_twq_NE;
}

if (goog.LOCALE == 'tzm') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_tzm;
}

if (goog.LOCALE == 'tzm_MA' || goog.LOCALE == 'tzm-MA') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_tzm_MA;
}

if (goog.LOCALE == 'ug') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ug;
}

if (goog.LOCALE == 'ug_CN' || goog.LOCALE == 'ug-CN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ug_CN;
}

if (goog.LOCALE == 'uk_UA' || goog.LOCALE == 'uk-UA') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_uk_UA;
}

if (goog.LOCALE == 'ur_IN' || goog.LOCALE == 'ur-IN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ur_IN;
}

if (goog.LOCALE == 'ur_PK' || goog.LOCALE == 'ur-PK') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_ur_PK;
}

if (goog.LOCALE == 'uz_Arab' || goog.LOCALE == 'uz-Arab') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_uz_Arab;
}

if (goog.LOCALE == 'uz_Arab_AF' || goog.LOCALE == 'uz-Arab-AF') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_uz_Arab_AF;
}

if (goog.LOCALE == 'uz_Cyrl' || goog.LOCALE == 'uz-Cyrl') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_uz_Cyrl;
}

if (goog.LOCALE == 'uz_Cyrl_UZ' || goog.LOCALE == 'uz-Cyrl-UZ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_uz_Cyrl_UZ;
}

if (goog.LOCALE == 'uz_Latn' || goog.LOCALE == 'uz-Latn') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_uz_Latn;
}

if (goog.LOCALE == 'uz_Latn_UZ' || goog.LOCALE == 'uz-Latn-UZ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_uz_Latn_UZ;
}

if (goog.LOCALE == 'vai') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_vai;
}

if (goog.LOCALE == 'vai_Latn' || goog.LOCALE == 'vai-Latn') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_vai_Latn;
}

if (goog.LOCALE == 'vai_Latn_LR' || goog.LOCALE == 'vai-Latn-LR') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_vai_Latn_LR;
}

if (goog.LOCALE == 'vai_Vaii' || goog.LOCALE == 'vai-Vaii') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_vai_Vaii;
}

if (goog.LOCALE == 'vai_Vaii_LR' || goog.LOCALE == 'vai-Vaii-LR') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_vai_Vaii_LR;
}

if (goog.LOCALE == 'vi_VN' || goog.LOCALE == 'vi-VN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_vi_VN;
}

if (goog.LOCALE == 'vun') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_vun;
}

if (goog.LOCALE == 'vun_TZ' || goog.LOCALE == 'vun-TZ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_vun_TZ;
}

if (goog.LOCALE == 'wae') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_wae;
}

if (goog.LOCALE == 'wae_CH' || goog.LOCALE == 'wae-CH') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_wae_CH;
}

if (goog.LOCALE == 'wo') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_wo;
}

if (goog.LOCALE == 'wo_SN' || goog.LOCALE == 'wo-SN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_wo_SN;
}

if (goog.LOCALE == 'xog') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_xog;
}

if (goog.LOCALE == 'xog_UG' || goog.LOCALE == 'xog-UG') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_xog_UG;
}

if (goog.LOCALE == 'yav') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_yav;
}

if (goog.LOCALE == 'yav_CM' || goog.LOCALE == 'yav-CM') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_yav_CM;
}

if (goog.LOCALE == 'yi') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_yi;
}

if (goog.LOCALE == 'yi_001' || goog.LOCALE == 'yi-001') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_yi_001;
}

if (goog.LOCALE == 'yo') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_yo;
}

if (goog.LOCALE == 'yo_BJ' || goog.LOCALE == 'yo-BJ') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_yo_BJ;
}

if (goog.LOCALE == 'yo_NG' || goog.LOCALE == 'yo-NG') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_yo_NG;
}

if (goog.LOCALE == 'yue') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_yue;
}

if (goog.LOCALE == 'yue_Hans' || goog.LOCALE == 'yue-Hans') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_yue_Hans;
}

if (goog.LOCALE == 'yue_Hans_CN' || goog.LOCALE == 'yue-Hans-CN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_yue_Hans_CN;
}

if (goog.LOCALE == 'yue_Hant' || goog.LOCALE == 'yue-Hant') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_yue_Hant;
}

if (goog.LOCALE == 'yue_Hant_HK' || goog.LOCALE == 'yue-Hant-HK') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_yue_Hant_HK;
}

if (goog.LOCALE == 'zgh') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_zgh;
}

if (goog.LOCALE == 'zgh_MA' || goog.LOCALE == 'zgh-MA') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_zgh_MA;
}

if (goog.LOCALE == 'zh_Hans' || goog.LOCALE == 'zh-Hans') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_zh_Hans;
}

if (goog.LOCALE == 'zh_Hans_CN' || goog.LOCALE == 'zh-Hans-CN') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_zh_Hans_CN;
}

if (goog.LOCALE == 'zh_Hans_HK' || goog.LOCALE == 'zh-Hans-HK') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_zh_Hans_HK;
}

if (goog.LOCALE == 'zh_Hans_MO' || goog.LOCALE == 'zh-Hans-MO') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_zh_Hans_MO;
}

if (goog.LOCALE == 'zh_Hans_SG' || goog.LOCALE == 'zh-Hans-SG') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_zh_Hans_SG;
}

if (goog.LOCALE == 'zh_Hant' || goog.LOCALE == 'zh-Hant') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_zh_Hant;
}

if (goog.LOCALE == 'zh_Hant_HK' || goog.LOCALE == 'zh-Hant-HK') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_zh_Hant_HK;
}

if (goog.LOCALE == 'zh_Hant_MO' || goog.LOCALE == 'zh-Hant-MO') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_zh_Hant_MO;
}

if (goog.LOCALE == 'zh_Hant_TW' || goog.LOCALE == 'zh-Hant-TW') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_zh_Hant_TW;
}

if (goog.LOCALE == 'zu_ZA' || goog.LOCALE == 'zu-ZA') {
  goog.labs.i18n.ListFormatSymbols = goog.labs.i18n.ListFormatSymbols_zu_ZA;
}

