/* -- THIS FILE IS GENERATED - DO NOT EDIT *//* -*- Mode: C; c-basic-offset: 4 -*- */

#include <Python.h>



#line 4 "zynjacku.override"
#include <Python.h>

#include "pygobject.h"

#include "plugin.h"
#include "engine.h"
#include "rack.h"
#include "enum.h"
#include "hints.h"
#include "midi_cc_map.h"

char *
zynjacku_lv2_dman_get(
  const char * dlpath);
#line 23 "zynjacku.c"


/* ---------- types from other modules ---------- */
static PyTypeObject *_PyGObject_Type;
#define PyGObject_Type (*_PyGObject_Type)


/* ---------- forward type declarations ---------- */
PyTypeObject G_GNUC_INTERNAL PyZynjackuEngine_Type;
PyTypeObject G_GNUC_INTERNAL PyZynjackuEnum_Type;
PyTypeObject G_GNUC_INTERNAL PyZynjackuHints_Type;
PyTypeObject G_GNUC_INTERNAL PyZynjackuMidiCcMap_Type;
PyTypeObject G_GNUC_INTERNAL PyZynjackuPlugin_Type;
PyTypeObject G_GNUC_INTERNAL PyZynjackuRack_Type;

#line 39 "zynjacku.c"



/* ----------- ZynjackuEngine ----------- */

static PyObject *
_wrap_zynjacku_engine_start_jack(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "client_name", NULL };
    char *client_name;
    int ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:ZynjackuEngine.start_jack", kwlist, &client_name))
        return NULL;
    
    ret = zynjacku_engine_start_jack(ZYNJACKU_ENGINE(self->obj), client_name);
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_zynjacku_engine_stop_jack(PyGObject *self)
{
    
    zynjacku_engine_stop_jack(ZYNJACKU_ENGINE(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_zynjacku_engine_get_sample_rate(PyGObject *self)
{
    guint ret;

    
    ret = zynjacku_engine_get_sample_rate(ZYNJACKU_ENGINE(self->obj));
    
    return PyLong_FromUnsignedLong(ret);
}

static PyObject *
_wrap_zynjacku_engine_ui_run(PyGObject *self)
{
    
    zynjacku_engine_ui_run(ZYNJACKU_ENGINE(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_zynjacku_engine_get_midi_activity(PyGObject *self)
{
    int ret;

    
    ret = zynjacku_engine_get_midi_activity(ZYNJACKU_ENGINE(self->obj));
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_zynjacku_engine_get_supported_feature(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "index", NULL };
    PyObject *py_index = NULL;
    const gchar *ret;
    guint index = 0;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:ZynjackuEngine.get_supported_feature", kwlist, &py_index))
        return NULL;
    if (py_index) {
        if (PyLong_Check(py_index))
            index = PyLong_AsUnsignedLong(py_index);
        else if (PyInt_Check(py_index))
            index = PyInt_AsLong(py_index);
        else
            PyErr_SetString(PyExc_TypeError, "Parameter 'index' must be an int or a long");
        if (PyErr_Occurred())
            return NULL;
    }
    
    ret = zynjacku_engine_get_supported_feature(ZYNJACKU_ENGINE(self->obj), index);
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_zynjacku_engine_construct_plugin(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "plugin_obj_ptr", NULL };
    PyGObject *plugin_obj_ptr;
    int ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:ZynjackuEngine.construct_plugin", kwlist, &PyZynjackuPlugin_Type, &plugin_obj_ptr))
        return NULL;
    
    ret = zynjacku_engine_construct_plugin(ZYNJACKU_ENGINE(self->obj), ZYNJACKU_PLUGIN(plugin_obj_ptr->obj));
    
    return PyBool_FromLong(ret);

}

static const PyMethodDef _PyZynjackuEngine_methods[] = {
    { "start_jack", (PyCFunction)_wrap_zynjacku_engine_start_jack, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "stop_jack", (PyCFunction)_wrap_zynjacku_engine_stop_jack, METH_NOARGS,
      NULL },
    { "get_sample_rate", (PyCFunction)_wrap_zynjacku_engine_get_sample_rate, METH_NOARGS,
      NULL },
    { "ui_run", (PyCFunction)_wrap_zynjacku_engine_ui_run, METH_NOARGS,
      NULL },
    { "get_midi_activity", (PyCFunction)_wrap_zynjacku_engine_get_midi_activity, METH_NOARGS,
      NULL },
    { "get_supported_feature", (PyCFunction)_wrap_zynjacku_engine_get_supported_feature, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "construct_plugin", (PyCFunction)_wrap_zynjacku_engine_construct_plugin, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PyZynjackuEngine_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "zynjacku_c.Engine",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyZynjackuEngine_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)0,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- ZynjackuEnum ----------- */

static PyObject *
_wrap_zynjacku_enum_get_count(PyGObject *self)
{
    guint ret;

    
    ret = zynjacku_enum_get_count(ZYNJACKU_ENUM(self->obj));
    
    return PyLong_FromUnsignedLong(ret);
}

static PyObject *
_wrap_zynjacku_enum_get_at_index(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "index", NULL };
    PyObject *py_index = NULL;
    const gchar *ret;
    guint index = 0;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:ZynjackuEnum.get_at_index", kwlist, &py_index))
        return NULL;
    if (py_index) {
        if (PyLong_Check(py_index))
            index = PyLong_AsUnsignedLong(py_index);
        else if (PyInt_Check(py_index))
            index = PyInt_AsLong(py_index);
        else
            PyErr_SetString(PyExc_TypeError, "Parameter 'index' must be an int or a long");
        if (PyErr_Occurred())
            return NULL;
    }
    
    ret = zynjacku_enum_get_at_index(ZYNJACKU_ENUM(self->obj), index);
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static const PyMethodDef _PyZynjackuEnum_methods[] = {
    { "get_count", (PyCFunction)_wrap_zynjacku_enum_get_count, METH_NOARGS,
      NULL },
    { "get_at_index", (PyCFunction)_wrap_zynjacku_enum_get_at_index, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PyZynjackuEnum_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "zynjacku_c.Enum",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyZynjackuEnum_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)0,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- ZynjackuHints ----------- */

static PyObject *
_wrap_zynjacku_hints_get_count(PyGObject *self)
{
    guint ret;

    
    ret = zynjacku_hints_get_count(ZYNJACKU_HINTS(self->obj));
    
    return PyLong_FromUnsignedLong(ret);
}

static PyObject *
_wrap_zynjacku_hints_get_name_at_index(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "index", NULL };
    PyObject *py_index = NULL;
    const gchar *ret;
    guint index = 0;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:ZynjackuHints.get_name_at_index", kwlist, &py_index))
        return NULL;
    if (py_index) {
        if (PyLong_Check(py_index))
            index = PyLong_AsUnsignedLong(py_index);
        else if (PyInt_Check(py_index))
            index = PyInt_AsLong(py_index);
        else
            PyErr_SetString(PyExc_TypeError, "Parameter 'index' must be an int or a long");
        if (PyErr_Occurred())
            return NULL;
    }
    
    ret = zynjacku_hints_get_name_at_index(ZYNJACKU_HINTS(self->obj), index);
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_zynjacku_hints_get_value_at_index(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "index", NULL };
    PyObject *py_index = NULL;
    const gchar *ret;
    guint index = 0;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:ZynjackuHints.get_value_at_index", kwlist, &py_index))
        return NULL;
    if (py_index) {
        if (PyLong_Check(py_index))
            index = PyLong_AsUnsignedLong(py_index);
        else if (PyInt_Check(py_index))
            index = PyInt_AsLong(py_index);
        else
            PyErr_SetString(PyExc_TypeError, "Parameter 'index' must be an int or a long");
        if (PyErr_Occurred())
            return NULL;
    }
    
    ret = zynjacku_hints_get_value_at_index(ZYNJACKU_HINTS(self->obj), index);
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static const PyMethodDef _PyZynjackuHints_methods[] = {
    { "get_count", (PyCFunction)_wrap_zynjacku_hints_get_count, METH_NOARGS,
      NULL },
    { "get_name_at_index", (PyCFunction)_wrap_zynjacku_hints_get_name_at_index, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_value_at_index", (PyCFunction)_wrap_zynjacku_hints_get_value_at_index, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PyZynjackuHints_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "zynjacku_c.Hints",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyZynjackuHints_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)0,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- ZynjackuMidiCcMap ----------- */

static PyObject *
_wrap_zynjacku_midiccmap_get_points(PyGObject *self)
{
    
    zynjacku_midiccmap_get_points(ZYNJACKU_MIDI_CC_MAP(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_zynjacku_midiccmap_point_create(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "cc_value", "parameter_value", NULL };
    PyObject *py_cc_value = NULL;
    double parameter_value;
    guint cc_value = 0;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"Od:ZynjackuMidiCcMap.point_create", kwlist, &py_cc_value, &parameter_value))
        return NULL;
    if (py_cc_value) {
        if (PyLong_Check(py_cc_value))
            cc_value = PyLong_AsUnsignedLong(py_cc_value);
        else if (PyInt_Check(py_cc_value))
            cc_value = PyInt_AsLong(py_cc_value);
        else
            PyErr_SetString(PyExc_TypeError, "Parameter 'cc_value' must be an int or a long");
        if (PyErr_Occurred())
            return NULL;
    }
    
    zynjacku_midiccmap_point_create(ZYNJACKU_MIDI_CC_MAP(self->obj), cc_value, parameter_value);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_zynjacku_midiccmap_point_remove(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "cc_value", NULL };
    PyObject *py_cc_value = NULL;
    guint cc_value = 0;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:ZynjackuMidiCcMap.point_remove", kwlist, &py_cc_value))
        return NULL;
    if (py_cc_value) {
        if (PyLong_Check(py_cc_value))
            cc_value = PyLong_AsUnsignedLong(py_cc_value);
        else if (PyInt_Check(py_cc_value))
            cc_value = PyInt_AsLong(py_cc_value);
        else
            PyErr_SetString(PyExc_TypeError, "Parameter 'cc_value' must be an int or a long");
        if (PyErr_Occurred())
            return NULL;
    }
    
    zynjacku_midiccmap_point_remove(ZYNJACKU_MIDI_CC_MAP(self->obj), cc_value);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_zynjacku_midiccmap_point_cc_value_change(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "cc_value_old", "cc_value_new", NULL };
    PyObject *py_cc_value_old = NULL, *py_cc_value_new = NULL;
    guint cc_value_old = 0, cc_value_new = 0;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"OO:ZynjackuMidiCcMap.point_cc_value_change", kwlist, &py_cc_value_old, &py_cc_value_new))
        return NULL;
    if (py_cc_value_old) {
        if (PyLong_Check(py_cc_value_old))
            cc_value_old = PyLong_AsUnsignedLong(py_cc_value_old);
        else if (PyInt_Check(py_cc_value_old))
            cc_value_old = PyInt_AsLong(py_cc_value_old);
        else
            PyErr_SetString(PyExc_TypeError, "Parameter 'cc_value_old' must be an int or a long");
        if (PyErr_Occurred())
            return NULL;
    }
    if (py_cc_value_new) {
        if (PyLong_Check(py_cc_value_new))
            cc_value_new = PyLong_AsUnsignedLong(py_cc_value_new);
        else if (PyInt_Check(py_cc_value_new))
            cc_value_new = PyInt_AsLong(py_cc_value_new);
        else
            PyErr_SetString(PyExc_TypeError, "Parameter 'cc_value_new' must be an int or a long");
        if (PyErr_Occurred())
            return NULL;
    }
    
    zynjacku_midiccmap_point_cc_value_change(ZYNJACKU_MIDI_CC_MAP(self->obj), cc_value_old, cc_value_new);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_zynjacku_midiccmap_point_parameter_value_change(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "cc_value", "parameter_value", NULL };
    PyObject *py_cc_value = NULL;
    double parameter_value;
    guint cc_value = 0;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"Od:ZynjackuMidiCcMap.point_parameter_value_change", kwlist, &py_cc_value, &parameter_value))
        return NULL;
    if (py_cc_value) {
        if (PyLong_Check(py_cc_value))
            cc_value = PyLong_AsUnsignedLong(py_cc_value);
        else if (PyInt_Check(py_cc_value))
            cc_value = PyInt_AsLong(py_cc_value);
        else
            PyErr_SetString(PyExc_TypeError, "Parameter 'cc_value' must be an int or a long");
        if (PyErr_Occurred())
            return NULL;
    }
    
    zynjacku_midiccmap_point_parameter_value_change(ZYNJACKU_MIDI_CC_MAP(self->obj), cc_value, parameter_value);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_zynjacku_midiccmap_cc_no_assign(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "cc_no", NULL };
    PyObject *py_cc_no = NULL;
    int ret;
    guint cc_no = 0;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:ZynjackuMidiCcMap.cc_no_assign", kwlist, &py_cc_no))
        return NULL;
    if (py_cc_no) {
        if (PyLong_Check(py_cc_no))
            cc_no = PyLong_AsUnsignedLong(py_cc_no);
        else if (PyInt_Check(py_cc_no))
            cc_no = PyInt_AsLong(py_cc_no);
        else
            PyErr_SetString(PyExc_TypeError, "Parameter 'cc_no' must be an int or a long");
        if (PyErr_Occurred())
            return NULL;
    }
    
    ret = zynjacku_midiccmap_cc_no_assign(ZYNJACKU_MIDI_CC_MAP(self->obj), cc_no);
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_zynjacku_midiccmap_get_cc_no(PyGObject *self)
{
    int ret;

    
    ret = zynjacku_midiccmap_get_cc_no(ZYNJACKU_MIDI_CC_MAP(self->obj));
    
    return PyInt_FromLong(ret);
}

static const PyMethodDef _PyZynjackuMidiCcMap_methods[] = {
    { "get_points", (PyCFunction)_wrap_zynjacku_midiccmap_get_points, METH_NOARGS,
      NULL },
    { "point_create", (PyCFunction)_wrap_zynjacku_midiccmap_point_create, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "point_remove", (PyCFunction)_wrap_zynjacku_midiccmap_point_remove, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "point_cc_value_change", (PyCFunction)_wrap_zynjacku_midiccmap_point_cc_value_change, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "point_parameter_value_change", (PyCFunction)_wrap_zynjacku_midiccmap_point_parameter_value_change, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "cc_no_assign", (PyCFunction)_wrap_zynjacku_midiccmap_cc_no_assign, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_cc_no", (PyCFunction)_wrap_zynjacku_midiccmap_get_cc_no, METH_NOARGS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PyZynjackuMidiCcMap_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "zynjacku_c.MidiCcMap",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyZynjackuMidiCcMap_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)0,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- ZynjackuPlugin ----------- */

static PyObject *
_wrap_zynjacku_plugin_destruct(PyGObject *self)
{
    
    zynjacku_plugin_destruct(ZYNJACKU_PLUGIN(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_zynjacku_plugin_get_instance_name(PyGObject *self)
{
    const gchar *ret;

    
    ret = zynjacku_plugin_get_instance_name(ZYNJACKU_PLUGIN(self->obj));
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_zynjacku_plugin_get_name(PyGObject *self)
{
    const gchar *ret;

    
    ret = zynjacku_plugin_get_name(ZYNJACKU_PLUGIN(self->obj));
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_zynjacku_plugin_get_uri(PyGObject *self)
{
    const gchar *ret;

    
    ret = zynjacku_plugin_get_uri(ZYNJACKU_PLUGIN(self->obj));
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_zynjacku_plugin_ui_on(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "ui_uri", "ui_type_uri", "ui_binary_path", "ui_bundle_path", NULL };
    char *ui_uri = NULL, *ui_type_uri = NULL, *ui_binary_path = NULL, *ui_bundle_path = NULL;
    int ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"|zzzz:ZynjackuPlugin.ui_on", kwlist, &ui_uri, &ui_type_uri, &ui_binary_path, &ui_bundle_path))
        return NULL;
    
    ret = zynjacku_plugin_ui_on(ZYNJACKU_PLUGIN(self->obj), ui_uri, ui_type_uri, ui_binary_path, ui_bundle_path);
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_zynjacku_plugin_ui_off(PyGObject *self)
{
    
    zynjacku_plugin_ui_off(ZYNJACKU_PLUGIN(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_zynjacku_plugin_bool_set(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "context", "value", NULL };
    char *context;
    int value;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"si:ZynjackuPlugin.bool_set", kwlist, &context, &value))
        return NULL;
    
    zynjacku_plugin_bool_set(ZYNJACKU_PLUGIN(self->obj), context, value);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_zynjacku_plugin_float_set(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "context", "value", NULL };
    char *context;
    double value;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"sd:ZynjackuPlugin.float_set", kwlist, &context, &value))
        return NULL;
    
    zynjacku_plugin_float_set(ZYNJACKU_PLUGIN(self->obj), context, value);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_zynjacku_plugin_int_set(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "context", "value", NULL };
    char *context;
    int value;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"si:ZynjackuPlugin.int_set", kwlist, &context, &value))
        return NULL;
    
    zynjacku_plugin_int_set(ZYNJACKU_PLUGIN(self->obj), context, value);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_zynjacku_plugin_enum_set(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "context", "value", NULL };
    char *context;
    PyObject *py_value = NULL;
    guint value = 0;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"sO:ZynjackuPlugin.enum_set", kwlist, &context, &py_value))
        return NULL;
    if (py_value) {
        if (PyLong_Check(py_value))
            value = PyLong_AsUnsignedLong(py_value);
        else if (PyInt_Check(py_value))
            value = PyInt_AsLong(py_value);
        else
            PyErr_SetString(PyExc_TypeError, "Parameter 'value' must be an int or a long");
        if (PyErr_Occurred())
            return NULL;
    }
    
    zynjacku_plugin_enum_set(ZYNJACKU_PLUGIN(self->obj), context, value);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_zynjacku_plugin_get_parameters(PyGObject *self)
{
    
    zynjacku_plugin_get_parameters(ZYNJACKU_PLUGIN(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_zynjacku_plugin_set_parameter(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "parameter", "value", "midi_cc_map_obj_ptr", NULL };
    char *parameter, *value;
    GObject *midi_cc_map_obj_ptr = NULL;
    int ret;
    PyGObject *py_midi_cc_map_obj_ptr = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"ss|O:ZynjackuPlugin.set_parameter", kwlist, &parameter, &value, &py_midi_cc_map_obj_ptr))
        return NULL;
    if ((PyObject *)py_midi_cc_map_obj_ptr == Py_None)
        midi_cc_map_obj_ptr = NULL;
    else if (py_midi_cc_map_obj_ptr && pygobject_check(py_midi_cc_map_obj_ptr, &PyGObject_Type))
        midi_cc_map_obj_ptr = G_OBJECT(py_midi_cc_map_obj_ptr->obj);
    else if (py_midi_cc_map_obj_ptr) {
        PyErr_SetString(PyExc_TypeError, "midi_cc_map_obj_ptr should be a GObject or None");
        return NULL;
    }
    
    ret = zynjacku_plugin_set_parameter(ZYNJACKU_PLUGIN(self->obj), parameter, value, (GObject *) midi_cc_map_obj_ptr);
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_zynjacku_plugin_get_midi_cc_map(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "parameter_context", NULL };
    char *parameter_context;
    GObject *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:ZynjackuPlugin.get_midi_cc_map", kwlist, &parameter_context))
        return NULL;
    
    ret = zynjacku_plugin_get_midi_cc_map(ZYNJACKU_PLUGIN(self->obj), parameter_context);
    
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_zynjacku_plugin_set_midi_cc_map(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "string_context", "midi_cc_map_obj_ptr", NULL };
    char *string_context;
    GObject *midi_cc_map_obj_ptr = NULL;
    int ret;
    PyGObject *py_midi_cc_map_obj_ptr;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"sO:ZynjackuPlugin.set_midi_cc_map", kwlist, &string_context, &py_midi_cc_map_obj_ptr))
        return NULL;
    if (py_midi_cc_map_obj_ptr && pygobject_check(py_midi_cc_map_obj_ptr, &PyGObject_Type))
        midi_cc_map_obj_ptr = G_OBJECT(py_midi_cc_map_obj_ptr->obj);
    else if ((PyObject *)py_midi_cc_map_obj_ptr != Py_None) {
        PyErr_SetString(PyExc_TypeError, "midi_cc_map_obj_ptr should be a GObject or None");
        return NULL;
    }
    
    ret = zynjacku_plugin_set_midi_cc_map(ZYNJACKU_PLUGIN(self->obj), string_context, (GObject *) midi_cc_map_obj_ptr);
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_zynjacku_plugin_add_supported_feature(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "feature_uri", NULL };
    char *feature_uri;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:ZynjackuPlugin.add_supported_feature", kwlist, &feature_uri))
        return NULL;
    
    zynjacku_plugin_add_supported_feature(ZYNJACKU_PLUGIN(self->obj), feature_uri);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_zynjacku_plugin_create_oldmidi_input_port(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "port_index", "symbol", NULL };
    PyObject *py_port_index = NULL;
    char *symbol;
    int ret;
    guint port_index = 0;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"Os:ZynjackuPlugin.create_oldmidi_input_port", kwlist, &py_port_index, &symbol))
        return NULL;
    if (py_port_index) {
        if (PyLong_Check(py_port_index))
            port_index = PyLong_AsUnsignedLong(py_port_index);
        else if (PyInt_Check(py_port_index))
            port_index = PyInt_AsLong(py_port_index);
        else
            PyErr_SetString(PyExc_TypeError, "Parameter 'port_index' must be an int or a long");
        if (PyErr_Occurred())
            return NULL;
    }
    
    ret = zynjacku_plugin_create_oldmidi_input_port(ZYNJACKU_PLUGIN(self->obj), port_index, symbol);
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_zynjacku_plugin_create_eventmidi_input_port(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "port_index", "symbol", NULL };
    PyObject *py_port_index = NULL;
    char *symbol;
    int ret;
    guint port_index = 0;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"Os:ZynjackuPlugin.create_eventmidi_input_port", kwlist, &py_port_index, &symbol))
        return NULL;
    if (py_port_index) {
        if (PyLong_Check(py_port_index))
            port_index = PyLong_AsUnsignedLong(py_port_index);
        else if (PyInt_Check(py_port_index))
            port_index = PyInt_AsLong(py_port_index);
        else
            PyErr_SetString(PyExc_TypeError, "Parameter 'port_index' must be an int or a long");
        if (PyErr_Occurred())
            return NULL;
    }
    
    ret = zynjacku_plugin_create_eventmidi_input_port(ZYNJACKU_PLUGIN(self->obj), port_index, symbol);
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_zynjacku_plugin_create_audio_port(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "port_index", "symbol", "input", NULL };
    PyObject *py_port_index = NULL;
    char *symbol;
    int input, ret;
    guint port_index = 0;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"Osi:ZynjackuPlugin.create_audio_port", kwlist, &py_port_index, &symbol, &input))
        return NULL;
    if (py_port_index) {
        if (PyLong_Check(py_port_index))
            port_index = PyLong_AsUnsignedLong(py_port_index);
        else if (PyInt_Check(py_port_index))
            port_index = PyInt_AsLong(py_port_index);
        else
            PyErr_SetString(PyExc_TypeError, "Parameter 'port_index' must be an int or a long");
        if (PyErr_Occurred())
            return NULL;
    }
    
    ret = zynjacku_plugin_create_audio_port(ZYNJACKU_PLUGIN(self->obj), port_index, symbol, input);
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_zynjacku_plugin_create_float_parameter_port(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "port_index", "symbol", "name", "msgcontext", "default_provided", "default_value", "min_provided", "min_value", "max_provided", "max_value", NULL };
    PyObject *py_port_index = NULL;
    char *symbol, *name;
    int msgcontext, default_provided, min_provided, max_provided, ret;
    guint port_index = 0;
    double default_value, min_value, max_value;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"Ossiididid:ZynjackuPlugin.create_float_parameter_port", kwlist, &py_port_index, &symbol, &name, &msgcontext, &default_provided, &default_value, &min_provided, &min_value, &max_provided, &max_value))
        return NULL;
    if (py_port_index) {
        if (PyLong_Check(py_port_index))
            port_index = PyLong_AsUnsignedLong(py_port_index);
        else if (PyInt_Check(py_port_index))
            port_index = PyInt_AsLong(py_port_index);
        else
            PyErr_SetString(PyExc_TypeError, "Parameter 'port_index' must be an int or a long");
        if (PyErr_Occurred())
            return NULL;
    }
    
    ret = zynjacku_plugin_create_float_parameter_port(ZYNJACKU_PLUGIN(self->obj), port_index, symbol, name, msgcontext, default_provided, default_value, min_provided, min_value, max_provided, max_value);
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_zynjacku_plugin_create_float_measure_port(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "port_index", "symbol", "msgcontext", NULL };
    PyObject *py_port_index = NULL;
    char *symbol;
    int msgcontext, ret;
    guint port_index = 0;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"Osi:ZynjackuPlugin.create_float_measure_port", kwlist, &py_port_index, &symbol, &msgcontext))
        return NULL;
    if (py_port_index) {
        if (PyLong_Check(py_port_index))
            port_index = PyLong_AsUnsignedLong(py_port_index);
        else if (PyInt_Check(py_port_index))
            port_index = PyInt_AsLong(py_port_index);
        else
            PyErr_SetString(PyExc_TypeError, "Parameter 'port_index' must be an int or a long");
        if (PyErr_Occurred())
            return NULL;
    }
    
    ret = zynjacku_plugin_create_float_measure_port(ZYNJACKU_PLUGIN(self->obj), port_index, symbol, msgcontext);
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_zynjacku_plugin_create_string_parameter_port(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "port_index", "symbol", "name", "msgcontext", "default_value", "maxlen", NULL };
    PyObject *py_port_index = NULL;
    char *symbol, *name, *default_value;
    int msgcontext, ret;
    guint port_index = 0;
    gsize maxlen;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"Ossisk:ZynjackuPlugin.create_string_parameter_port", kwlist, &py_port_index, &symbol, &name, &msgcontext, &default_value, &maxlen))
        return NULL;
    if (py_port_index) {
        if (PyLong_Check(py_port_index))
            port_index = PyLong_AsUnsignedLong(py_port_index);
        else if (PyInt_Check(py_port_index))
            port_index = PyInt_AsLong(py_port_index);
        else
            PyErr_SetString(PyExc_TypeError, "Parameter 'port_index' must be an int or a long");
        if (PyErr_Occurred())
            return NULL;
    }
    
    ret = zynjacku_plugin_create_string_parameter_port(ZYNJACKU_PLUGIN(self->obj), port_index, symbol, name, msgcontext, default_value, maxlen);
    
    return PyBool_FromLong(ret);

}

static const PyMethodDef _PyZynjackuPlugin_methods[] = {
    { "destruct", (PyCFunction)_wrap_zynjacku_plugin_destruct, METH_NOARGS,
      NULL },
    { "get_instance_name", (PyCFunction)_wrap_zynjacku_plugin_get_instance_name, METH_NOARGS,
      NULL },
    { "get_name", (PyCFunction)_wrap_zynjacku_plugin_get_name, METH_NOARGS,
      NULL },
    { "get_uri", (PyCFunction)_wrap_zynjacku_plugin_get_uri, METH_NOARGS,
      NULL },
    { "ui_on", (PyCFunction)_wrap_zynjacku_plugin_ui_on, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "ui_off", (PyCFunction)_wrap_zynjacku_plugin_ui_off, METH_NOARGS,
      NULL },
    { "bool_set", (PyCFunction)_wrap_zynjacku_plugin_bool_set, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "float_set", (PyCFunction)_wrap_zynjacku_plugin_float_set, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "int_set", (PyCFunction)_wrap_zynjacku_plugin_int_set, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "enum_set", (PyCFunction)_wrap_zynjacku_plugin_enum_set, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_parameters", (PyCFunction)_wrap_zynjacku_plugin_get_parameters, METH_NOARGS,
      NULL },
    { "set_parameter", (PyCFunction)_wrap_zynjacku_plugin_set_parameter, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_midi_cc_map", (PyCFunction)_wrap_zynjacku_plugin_get_midi_cc_map, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_midi_cc_map", (PyCFunction)_wrap_zynjacku_plugin_set_midi_cc_map, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "add_supported_feature", (PyCFunction)_wrap_zynjacku_plugin_add_supported_feature, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "create_oldmidi_input_port", (PyCFunction)_wrap_zynjacku_plugin_create_oldmidi_input_port, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "create_eventmidi_input_port", (PyCFunction)_wrap_zynjacku_plugin_create_eventmidi_input_port, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "create_audio_port", (PyCFunction)_wrap_zynjacku_plugin_create_audio_port, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "create_float_parameter_port", (PyCFunction)_wrap_zynjacku_plugin_create_float_parameter_port, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "create_float_measure_port", (PyCFunction)_wrap_zynjacku_plugin_create_float_measure_port, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "create_string_parameter_port", (PyCFunction)_wrap_zynjacku_plugin_create_string_parameter_port, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PyZynjackuPlugin_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "zynjacku_c.Plugin",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyZynjackuPlugin_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)0,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- ZynjackuRack ----------- */

static PyObject *
_wrap_zynjacku_rack_start_jack(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "client_name", NULL };
    char *client_name;
    int ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:ZynjackuRack.start_jack", kwlist, &client_name))
        return NULL;
    
    ret = zynjacku_rack_start_jack(ZYNJACKU_RACK(self->obj), client_name);
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_zynjacku_rack_stop_jack(PyGObject *self)
{
    
    zynjacku_rack_stop_jack(ZYNJACKU_RACK(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_zynjacku_rack_get_sample_rate(PyGObject *self)
{
    guint ret;

    
    ret = zynjacku_rack_get_sample_rate(ZYNJACKU_RACK(self->obj));
    
    return PyLong_FromUnsignedLong(ret);
}

static PyObject *
_wrap_zynjacku_rack_ui_run(PyGObject *self)
{
    
    zynjacku_rack_ui_run(ZYNJACKU_RACK(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_zynjacku_rack_get_supported_feature(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "index", NULL };
    PyObject *py_index = NULL;
    const gchar *ret;
    guint index = 0;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:ZynjackuRack.get_supported_feature", kwlist, &py_index))
        return NULL;
    if (py_index) {
        if (PyLong_Check(py_index))
            index = PyLong_AsUnsignedLong(py_index);
        else if (PyInt_Check(py_index))
            index = PyInt_AsLong(py_index);
        else
            PyErr_SetString(PyExc_TypeError, "Parameter 'index' must be an int or a long");
        if (PyErr_Occurred())
            return NULL;
    }
    
    ret = zynjacku_rack_get_supported_feature(ZYNJACKU_RACK(self->obj), index);
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_zynjacku_rack_construct_plugin(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "plugin_obj_ptr", NULL };
    PyGObject *plugin_obj_ptr;
    int ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!:ZynjackuRack.construct_plugin", kwlist, &PyZynjackuPlugin_Type, &plugin_obj_ptr))
        return NULL;
    
    ret = zynjacku_rack_construct_plugin(ZYNJACKU_RACK(self->obj), ZYNJACKU_PLUGIN(plugin_obj_ptr->obj));
    
    return PyBool_FromLong(ret);

}

static const PyMethodDef _PyZynjackuRack_methods[] = {
    { "start_jack", (PyCFunction)_wrap_zynjacku_rack_start_jack, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "stop_jack", (PyCFunction)_wrap_zynjacku_rack_stop_jack, METH_NOARGS,
      NULL },
    { "get_sample_rate", (PyCFunction)_wrap_zynjacku_rack_get_sample_rate, METH_NOARGS,
      NULL },
    { "ui_run", (PyCFunction)_wrap_zynjacku_rack_ui_run, METH_NOARGS,
      NULL },
    { "get_supported_feature", (PyCFunction)_wrap_zynjacku_rack_get_supported_feature, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "construct_plugin", (PyCFunction)_wrap_zynjacku_rack_construct_plugin, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PyZynjackuRack_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "zynjacku_c.Rack",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyZynjackuRack_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)0,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- functions ----------- */

static PyObject *
_wrap_zynjacku_get_version(PyObject *self)
{
    const gchar *ret;

    
    ret = zynjacku_get_version();
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_zynjacku_rack_get_version(PyObject *self)
{
    const gchar *ret;

    
    ret = zynjacku_rack_get_version();
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_zynjacku_lv2_dman_get(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "dlpath", NULL };
    char *dlpath;
    gchar *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:zynjacku_lv2_dman_get", kwlist, &dlpath))
        return NULL;
    
    ret = zynjacku_lv2_dman_get(dlpath);
    
    if (ret) {
        PyObject *py_ret = PyString_FromString(ret);
        g_free(ret);
        return py_ret;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

const PyMethodDef zynjacku_c_functions[] = {
    { "zynjacku_get_version", (PyCFunction)_wrap_zynjacku_get_version, METH_NOARGS,
      NULL },
    { "zynjacku_rack_get_version", (PyCFunction)_wrap_zynjacku_rack_get_version, METH_NOARGS,
      NULL },
    { "zynjacku_lv2_dman_get", (PyCFunction)_wrap_zynjacku_lv2_dman_get, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { NULL, NULL, 0, NULL }
};

/* initialise stuff extension classes */
void
zynjacku_c_register_classes(PyObject *d)
{
    PyObject *module;

    if ((module = PyImport_ImportModule("gobject")) != NULL) {
        _PyGObject_Type = (PyTypeObject *)PyObject_GetAttrString(module, "GObject");
        if (_PyGObject_Type == NULL) {
            PyErr_SetString(PyExc_ImportError,
                "cannot import name GObject from gobject");
            return ;
        }
    } else {
        PyErr_SetString(PyExc_ImportError,
            "could not import gobject");
        return ;
    }


#line 1417 "zynjacku.c"
    pygobject_register_class(d, "ZynjackuEngine", ZYNJACKU_TYPE_ENGINE, &PyZynjackuEngine_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pyg_set_object_has_new_constructor(ZYNJACKU_TYPE_ENGINE);
    pygobject_register_class(d, "ZynjackuEnum", ZYNJACKU_TYPE_ENUM, &PyZynjackuEnum_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pyg_set_object_has_new_constructor(ZYNJACKU_TYPE_ENUM);
    pygobject_register_class(d, "ZynjackuHints", ZYNJACKU_TYPE_HINTS, &PyZynjackuHints_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pyg_set_object_has_new_constructor(ZYNJACKU_TYPE_HINTS);
    pygobject_register_class(d, "ZynjackuMidiCcMap", ZYNJACKU_TYPE_MIDI_CC_MAP, &PyZynjackuMidiCcMap_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pyg_set_object_has_new_constructor(ZYNJACKU_TYPE_MIDI_CC_MAP);
    pygobject_register_class(d, "ZynjackuPlugin", ZYNJACKU_TYPE_PLUGIN, &PyZynjackuPlugin_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pyg_set_object_has_new_constructor(ZYNJACKU_TYPE_PLUGIN);
    pygobject_register_class(d, "ZynjackuRack", ZYNJACKU_TYPE_RACK, &PyZynjackuRack_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pyg_set_object_has_new_constructor(ZYNJACKU_TYPE_RACK);
}
