#ifndef ZORP_CT_H_INCLUDED
#define ZORP_CT_H_INCLUDED

#include <zorp/zorp.h>

#if ENABLE_CONNTRACK

#include <zorp/poll.h>
#include <zorp/sockaddr.h>
#include <zorp/stream.h>
#include <zorp/proxy.h>
#include <zorp/packet.h>

#define ZCT_DST_IP	0x0001
#define ZCT_SRC_IP	0x0100
#define ZCT_DST_PORT	0x0002
#define ZCT_SRC_PORT	0x0200

#define ZCS_TO_CLIENT 1
#define ZCS_TO_SERVER 2
#define ZCS_MASTER 3

typedef struct _ZDGramConnection
{
  gchar session_id[MAX_SESSION_ID];
  gint type;
  GStaticRecMutex ref_lock;
  gint ref_cnt;
  
  /* The ct side of the proxy stream-pair. This is where we can pull proxy
   * messages, or send further packets. */
  
  ZStream *ct_stream;

  /* underlying socket we've created, which is explicitly bound */
  ZStream *fd_stream;
  
  /* */
  ZSockAddr *local_addr;
  ZSockAddr *remote_addr;
  
} ZDGramConnection;


typedef gboolean (*ZReceiveAcceptFunc)(ZStream *stream, ZSockAddr *remote, ZSockAddr *dest, gpointer user_data);


/*
 * ZIOReceive encapsulates a datagram mode listener. It takes care of
 * receiving packets on the receiver fd, organizes packets into sessions
 * (based on the peer's address and the protocol information found).
 *
 * On new sessions a callback is called, on packets which belong to already
 * known session, the packet is send to the correct proxy instance.
 */
typedef struct _ZIOReceive
{
  guint ref_cnt;
  gchar session_id[MAX_SESSION_ID];
  gint session_limit;

  /* address we were bound to */
  ZSockAddr *bind_addr;
  ZSockAddr *bound_addr;
  guint32 sock_flags;
  
  /* stream bound to sock above */
  ZStream *fd_stream;
  
  /* callback to be called when a new session is found */
  ZReceiveAcceptFunc callback;
  
  /* callback to be passed to callback */
  gpointer callback_data;
  
  GDestroyNotify callback_data_notify;
} ZIOReceive;

ZIOReceive *
z_io_receive_new(gchar *session_id, 
		ZSockAddr *bind_addr, 
		gint session_limit,
		guint32 sock_flags,
		ZReceiveAcceptFunc callback, 
		gpointer user_data);
		
gboolean z_io_receive_start(ZIOReceive *self);
void z_io_receive_cancel(ZIOReceive *self);
void z_io_receive_ref(ZIOReceive *self);
void z_io_receive_unref(ZIOReceive *self);

/* datagram sockets */
ZDGramConnection *z_dgram_connection_new(gchar *session_id, ZSockAddr *src, ZSockAddr *dest, gint type, gint tos, ZStream **proxy_stream);
void z_dgram_connection_ref(ZDGramConnection *self);
void z_dgram_connection_unref(ZDGramConnection *self);

void z_dgram_connection_start(ZDGramConnection *self);

/* conntrack initialization */
gboolean z_conntrack_init(void);
void z_conntrack_destroy(void);

#else

#define z_conntrack_init() TRUE
#define z_conntrack_destroy()

#endif

#endif
