#ifndef ZORP_PROXY_CODE_H
#define ZORP_PROXY_CODE_H

#include <zorp/zorp.h>

/* default buffer size */
#define ZCODE_BUFSIZE_DEFAULT       256

typedef struct _ZCode ZCode;

struct _ZCode
{
  guchar *buf;
  gint buf_len, buf_used;
  gint error_counter;
  gint (*transform)(ZCode *self, const guchar *from, int fromlen);
  void (*finish)(ZCode *self);
  void (*free_fn)(ZCode *self);
};

gboolean z_code_grow(ZCode *self, gint reqlen);

gint z_code_get_result_length(ZCode *self);
gint z_code_get_result(ZCode *self, guchar *to, int tolen);
const guchar *z_code_peek_result(ZCode *self);
gint z_code_unget_result(ZCode *self, const guchar *from, int fromlen);
gint z_code_transform(ZCode *self, const guchar *from, int fromlen);
void z_code_finish(ZCode *self);

ZCode *z_code_new(gint bufsize);
void z_code_init(ZCode *self, gint bufsize);
void z_code_free(ZCode *self);

static inline gint
z_code_get_errors(ZCode *self)
{
  return self->error_counter;
}

static inline void
z_code_clear_errors(ZCode *self)
{
  self->error_counter = 0;
}

/* FIXME: there's no such thing in 3.0 */
void z_code_data_dump(const char* buf, int len);
#endif
